$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoTipoVenda",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um tipo de venda.",
          position: "right",
        },
      },
      {
        element: "#tabelaTipo",
        popover: {
          title: "Tabela Tipos de Venda",
          description: "Aqui estão os dados dos tipos de venda cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("TIPOVENDA");

  $('#txtTipoVenda').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID CHAVE", "DESCRICAO"], "where": null}`);
  $('#btnTipoVenda').pesquisa('#txtTipoVenda', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID CODIGO", "DESCRICAO"]}`, "Pesquisa Tipo de Venda", 'VENDA_TIPO');
  $('#btnATipoVenda').on('click', function () { $('#txtTipoVenda').val(''); });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtTipoVenda').val('');
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultarTipo();
  });

  $('#btnNovoTipoVenda').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipovenda/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipo').DataTable().row($(this).parents('tr')).data();
      window.location.href = `tipovenda/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaTipo').DataTable().row($(this)).data();
      window.location.href = `tipovenda/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTipo").DataTable().row($(this).parents("tr")).data().CODIGO;
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  await consultarTipo();

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function consultarTipo() {
    $.LoadingOverlay("show");
    try {

      let sWhere = ' 1 = 1 ';
      sWhere += pegaChave('#txtTipoVenda') != '' ? `AND ID = ${pegaChave('#txtTipoVenda')}` : '';

      const pesquisaParam = {
        tabela: 'VENDA_TIPO',
        camposSelect: ['ID CODIGO', 'DESCRICAO'],
        where: [sWhere]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const keys = Object.keys(jsonStr[0]);
      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'data': keys[k]
        });
      }

      const botaoDinamico = {
        targets: [0],
        funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
      }

      criaDataTablePadrao('#tabelaTipo', true, true, true, true, true, false, false, jsonStr, dataSetCols, [], [], [], [], botaoDinamico);
      if ($('#tabelaTipo').DataTable().rows().count() < 4) {
        $('#tabelaTipo').css('min-height', '75px');
      }


    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function excluiRegistro(sCodigo) {
    $.LoadingOverlay('show');
    try {

      let response = await requisicao('DELETE', '/sisplan/cadastros/v1/vendatipo?', `ID=${encodeURIComponent(sCodigo)}`, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        $.LoadingOverlay('hide');
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload(); });

    } catch (error) {
      $.LoadingOverlay('hide');
      console.error(error);
    };
  }

});
