<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Usuário</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.245.9.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../dist/css/PesquisaVariosSelect2.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.cs?versao=3.245.9.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.245.9.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.245.9.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.245.9.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="../plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.245.9.1">

</head>
<style>
  .content-wrapper {
    margin-left: 0px !important;
  }

  .main-header,
  .main-sidebar {
    display: none;
  }
</style>


<body class="hold-transition sidebar-mini layout-fixed">


  <script type="text/javascript" src="../config.js"></script>
  <main class="wrapper">

    <?php
    include_once('../../../../menu.php');
    ?>

    <div id="modal-configuracao" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Configuração E-mail</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-12 col-lg-6">
                <input type="text" class="input-default focus form-control d-none" id="txtEmailCodUsuario" name="txtEmailCodUsuario" class="form-control" placeholder="Usuário">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmailServidor">Servidor</label>
                <input type="text" class="input-default focus form-control" required aria-describedby="ufError" required id="txtEmailServidor" name="txtEmailServidor" class="form-control" placeholder="Servidor">
              </div>
              <div class="col-12 col-lg-6">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmailPorta">Porta</label>
                <input type="text" class="input-default focus form-control" required aria-describedby="ufError" required id="txtEmailPorta" name="txtEmailPorta" class="form-control" placeholder="Porta">
              </div>
              <div class="col-12 col-lg-6">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmailUsuario">Usuário Login</label>
                <input type="text" class="input-default focus form-control" required aria-describedby="ufError" required id="txtEmailUsuario" name="txtEmailUsuario" class="form-control" placeholder="Usuário Login">
              </div>
              <div class="col-12 col-lg-6">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmailSenha">Senha Login</label>
                <input type="password" class="input-default focus form-control" required aria-describedby="ufError" required id="txtEmailSenha" name="txtEmailSenha" class="form-control" placeholder="Senha Login">
              </div>

              <div class="col-12 col-lg-6">
                <label for="txtEmailSSL">Usa SSL</label>
                <div class="relative">
                  <select name="" id="txtEmailSSL" class="input-default">
                    <option value="">Selecione uma opção</option>
                    <option value="S">Sim</option>
                    <option value="N">Não</option>
                  </select>
                </div>
              </div>
              <div class="col-12 col-lg-6">
                <label for="txtEmailTLS">Usa TLS</label>
                <div class="relative">
                  <select name="" id="txtEmailTLS" class="input-default">
                    <option value="">Selecione uma opção</option>
                    <option value="S">Sim</option>
                    <option value="N">Não</option>
                  </select>
                </div>
              </div>
              <div class="col-12 col-lg-12">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmailCopia">E-mail cópia</label>
                <input type="text" class="input-default focus form-control" required aria-describedby="ufError" required id="txtEmailCopia" name="txtEmailCopia" class="form-control" placeholder="E-mail cópia">
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <div class="row">
              <button id="btnEmailExcluir" class='btn btn-danger btn-sisp mr-2' type='button'> Excluir </button>
              <button id="btnEmailConfirmar" class='btn btn-primary btn-sisp' type='button'> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-12">
                <!-- <ol class="breadcrumb float-sm-right">
                  
                  <li class="breadcrumb-item"><a href="../usuario">Usuário</a></li>
                  <li class="breadcrumb-item active">Cadastro de Usuários</li>
                </ol> -->
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <h2>
                  <strong>Cadastro de Usuário</strong>
                  <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                    <i class="fas fa-question-circle"></i>
                  </button>
                </h2>
                <p>Preencha os dados e clique em avançar para realizar o cadastro do usuário</p>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%; width:50%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%; width:50%;"><strong>Configurar</strong></li>
                      </ul>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <div class="col-6 form-group">
                            <div class="form-group form-check">
                              <input type="checkbox" class="form-check-input" id="cbAtivo">
                              <label class="form-check-label pr-4" for="cbAtivo">Ativo</label>
                              <input type="checkbox" class="form-check-input" id="cbVisualizaBarra" style="margin-left: 6px;">
                              <label class="form-check-label pr-4" for="cbVisualizaBarra" style="margin-left: 25px;">Visualiza Barras Expedição</label>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-md-6  col-md form-group">
                              <label for="txtNome">Nome *</label>
                              <div class="relative">
                                <input type="text" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNome" name="txtNome">
                              </div>
                            </div>
                            <div class="col-lg-6 col-6 form-group ">
                              <label for="selectGravaCondicao">Bloquear finalização da venda</label>
                              <div class="relative">
                                <select name="" id="selectGravaCondicao" class="input-default">
                                  <option value="N">Não</option>
                                  <option value="S">Sim</option>
                                </select>
                              </div>
                            </div>
                          </div>

                          <div class="row">
                            <div class="col-md-6 col-6 form-group" id="representanteInfoTour">
                              <label data-error="wrong" data-success="right" for="txtRepresentante">Representante *</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante" name="txtRepresentante">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Representante" name="btn-Representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-md-6 col-6 form-group" id="funcionarioInfoTour">
                              <label data-error="wrong" data-success="right" for="txtFuncionario">Funcionário</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtFuncionario" name="txtFuncionario" class="form-control" placeholder="Funcionário" name="txtRepresentante">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Funcionario" name="btn-Funcionario" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Funcionario" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>

                          <div class="row">
                            <div class="form-group col-md-6 col-12">
                              <label for="txtDescontoMax">Desconto Máximo Usuário</label>
                              <div class="relative">
                                <input type="text" class="input-default focus form-control validate" id="txtDescontoMax" name="txtDescontoMax">
                              </div>
                            </div>

                            <div class="form-group col-md-6 col-12">
                              <label for="txtTipo">Tipo Usuário</label>
                              <div class="relative">
                                <select id="txtTipo" class="input-default focus form-control validate" required="required" name="txtTipo">
                                  <option value="0" selected>Usuário</option>
                                  <option value="1">Supervisor</option>
                                  <option value="2">Master</option>
                                </select>
                              </div>
                            </div>
                            <div class="form-group col-md-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtSetores">Setores</label>
                              <div class="input-group">
                                <!-- <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSetores" name="txtSetores" class="form-control" placeholder="Setores"> -->
                                <select class="js-example-programmatic js-states form-control" id="txtSetores" name="txtSetores" multiple="multiple">
                                </select>
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnSetores" name="btnSetores" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaSetores" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="form-group col-md-6 col-12">
                              <label data-error="wrong" data-success="right" for="txtWhatsapp">WhatsApp</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control" id="txtWhatsapp" name="txtWhatsapp" class="form-control" placeholder="Whatsapp">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnWhatsapp" name="btnWhatsapp" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btnLimpaWhatsapp" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-12 col-sm-12 col-12" style="margin-top: 5px;">
                              <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtDeposito">Depósito </label>
                              <div class="relative" style="margin-top: 5px;">
                                <div class="input-group">
                                  <!-- <input type="text" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Deposito"> -->
                                  <select class="js-example-programmatic js-states form-control" id="txtDeposito" name="txtDeposito" multiple="multiple">
                                  </select>
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-Deposito" name="btn-Deposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <button type="button" id="avancar1" class="btn-sisp next action-button" value="Avançar" style="font-size: 15px;" data-dismiss="modal">Avançar</button>
                        <button type="button" id="btnVoltar" class="btn btn-success btn-sisp action-button-previous" style="padding-bottom: 9px; font-size: 15px;" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <div class="row" id="contas">

                            <div class="form-group col-md-3 col-12">
                              <label for="txtSerie">Série NF</label>
                              <div class="relative">
                                <input type="text" class="input-default focus form-control validate" id="txtSerie" name="txtSerie" placeholder="Série NF">
                              </div>
                            </div>

                            <div class="col-12" id="GrupoInfoTour">
                              <div class="col-md-12 col-12 table-responsive mt-12">
                                <table id="tabela-empAcesso" class="table table-sm table-hover table-select table-condensed">
                                  <thead>
                                    <tr>
                                      <th>Sel</th>
                                      <th>Empresa</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                                <button type="button" id="btnEmail" class="btn btn-danger btn-sisp mt-2">E-mail</button>
                                <button type="button" id="btnResetarSenha" class="btn btn-danger btn-sisp mt-2">Resetar Senha</button>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input id="btnGravar" type="submit" style="font-size:15px;" class="btn btn-danger btn-sisp action-button" value="Gravar">
                        <button type="button" id="voltar4" name="voltar4" class="btn btn-success btn-sisp previous action-button-previous" style="padding-bottom: 10px; font-size: 15px;" data-dismiss="modal">Voltar</button>
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>

    <aside class="control-sidebar control-sidebar-dark">
    </aside>

    <?php
    include_once('../../../../footer.php');
    ?>
    <?php include_once('../../../../menu_fiscal.php'); ?>
  </main>

  <script src="../plugins/jquery/jquery.min.js?versao=3.245.9.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.245.9.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.245.9.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.245.9.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.245.9.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.245.9.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.245.9.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.245.9.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.245.9.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.245.9.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.245.9.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.245.9.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.245.9.1"></script>
  <script src="../utils/funcoes.js?versao=3.245.9.1"></script>
  <script src="../utils/cookies.js?versao=3.245.9.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.245.9.1"></script>
  <script src="../plugins/select2/js/select2.full.min.js?versao=3.245.9.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/sistema/usuario/cadastro_usuario/usuario.js?versao=3.245.9.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

      const temAcesso = await temAcessoTela('USUARIO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("USUARIO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/usuario`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const usuarioAlteracao = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        // e.preventDefault();
        e.stopPropagation();
        deletaRegistro('ACESSO_USUARIOS', getCookie('usuario'), atob(usuarioAlteracao));
        return undefined;
      });

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>