$(document).ready(async function () {

  let linhaEdicao = false;

  const colunasItens = [
    { title: 'Lote', data: 'LOTE' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Acabamento', data: 'ACABAMENTO' },
    { title: 'Pedi Fluxo', data: 'PEDIFLUXO' },
    { title: 'Tecido', data: 'TECIDO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Variante', data: 'VARIANTE' },
    { title: 'Estampa', data: 'ESTAMPA' },
    { title: 'Pedido Tinto', data: 'PEDIDOTINTO' },
    { title: 'Item Pedido Tinto', data: 'ITPEDIDOTINTO' },
    { title: 'Pedido Compra', data: 'PEDIDOCOMPRA' },
    { title: 'Item Pedido Compra', data: 'ITPEDIDOCOMPRA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Gramatura', data: 'GRAMATURA' },
    { title: 'Título do fio', data: 'TITULOFIO' },
    { title: 'Nota fiscal', data: 'NOTA' },
    { title: 'Quantidade', data: 'QTDE' },
    { title: 'Peças', data: 'PECAS' },
    { title: 'Unidade', data: 'UNIDADE' },
    { title: 'Ourelas', data: 'OURELAS' },
    { title: 'Engomar', data: 'ENGOMAR' },
    { title: 'Agulha', data: 'AGULHA' },
    { title: 'Observações', data: 'OBSERVACAO' },
    { title: 'Editar/Excluir', data: 'EXCLUIR' },
  ];

  const urlFal = $(window.location.href.split('/')).get(-1);

  addBotoesAvancarVoltar();
  addPesquisaAutocompleta();
  insereValor('#txtCliente', getCookie('g_nome_empresa_logada'));
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '500px', undefined, colunasItens);

  await setarDataAtual('dtEmissao');
  await validaEdicao();

  $('#btnConfirmarItem').on('click', function () {
    try {
      const item = {
        LOTE: pegaValor('#txtLote'),
        TIPO: pegaValor('#rgTipo'),
        ACABAMENTO: pegaValor('#rgAcabamento'),
        PEDIFLUXO: pegaValor('#rgPediFluxo'),
        TECIDO: pegaChave('#txtTecido'),
        COR: pegaChave('#txtCor'),
        VARIANTE: pegaChave('#txtVariante'),
        ESTAMPA: pegaChave('#txtEstampa'),
        PEDIDOTINTO: pegaValor('#txtPedidoTinto'),
        ITPEDIDOTINTO: pegaValor('#txtItPedTinto'),
        PEDIDOCOMPRA: pegaValor('#txtPedidoCompra'),
        ITPEDIDOCOMPRA: pegaValor('#txtItPedCompra'),
        LARGURA: pegaValor('#txtLargura'),
        GRAMATURA: pegaValor('#txtGramatura'),
        TITULOFIO: pegaValor('#txtTitFioFab'),
        NOTA: pegaValor('#txtNf'),
        QTDE: pegaValor('#txtQuantidade'),
        PECAS: pegaValor('#txtPecas'),
        UNIDADE: pegaValor('#rgUnidade'),
        OURELAS: pegaValor('#rgOurelas'),
        ENGOMAR: pegaValor('#rgEngomar'),
        AGULHA: pegaValor('#rgAgulha'),
        OBSERVACAO: montaObsItem(),
        EXCLUIR: retornaBotaoExcluir(),
      };

      if (linhaEdicao) {
        $("#tabelaItens").DataTable().row(linhaEdicao).remove().draw(false);
        linhaEdicao = false;
      }

      $('#tabelaItens').DataTable().row.add(item).draw(false);
    } finally {
      $('#modalAddItem').modal('hide');
    }
  });

  $('#btnAddItem').on('click', function () {
    window.event.preventDefault();
    limpaCampos();
    linhaEdicao = false;
    $('#modalAddItem').modal('show');
  });

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    $("#tabelaItens").DataTable().row($(this).parents("tr")).remove().draw(false);
  });

  $('#tabelaItens').on('click', '#btn-editar', async function () {
    linhaEdicao = $(this).parents("tr");
    await editaItem(linhaEdicao);
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/servtingimento`;
  });

  $('#btnGravar').on('click', async function () {
    if ($('#tabelaItens').DataTable().rows().length == 0) {
      msgAlerta('Necessário adicionar pelo menos um item a FAL.')
      return;
    }

    await gravaDados();
  });

  $(".maskItens").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $('#txtTecido').on('blur', async function () {
    const material = pegaChave('#txtTecido');

    if (material == '') {
      limpaFts();
      return;
    }

    await carregaFts(material);
  });

  $('#rgFichaTecnica').on('change', function () {
    if ($(this).val() == '') {
      limpaFts(false);
    }

    validaFt();
  });

  function montaObsItem() {
    return (pegaValor('#txtObsItem') + ' - OURELAS: ' + pegaValor('#rgOurelas') + ' - ENGOMAR: ' + pegaValor('#rgEngomar') + ' - AGULHA: ' + pegaValor('#rgAgulha'));
  }

  function limpaFts(bZera = true) {
    if (bZera) {
      $("#rgFichaTecnica").html('<option value="">Selecione uma opção</option>');
    }

    $('#txtLargura').val('');
    $('#txtGramatura').val('');

    setTimeout(() => {
      $('#txtLargura').prop('disabled', false);
      $('#txtGramatura').prop('disabled', false);
    }, 300);
  };

  function limpaCampos() {
    limpaValor('#txtLote');
    limpaValor('#txtTecido');
    limpaValor('#txtCor');
    limpaValor('#txtEstampa');
    limpaValor('#txtPedidoTinto');
    limpaValor('#txtItPedTinto');
    limpaValor('#txtPedidoCompra');
    limpaValor('#txtItPedCompra');
    limpaValor('#txtLargura');
    limpaValor('#txtGramatura');
    limpaValor('#txtTitFioFab');
    limpaValor('#txtNf');
    limpaValor('#txtQuantidade');
    limpaValor('#txtPecas');
    limpaValor('#txtObsItem');
  }

  async function editaItem(linha) {
    $.LoadingOverlay('show');
    try {
      const dados = $("#tabelaItens").DataTable().row(linha).data();

      insereValor('#txtLote', dados.LOTE);
      insereValor('#txtPedidoTinto', dados.PEDIDOTINTO);
      insereValor('#txtItPedTinto', dados.ITPEDIDOTINTO);
      insereValor('#txtPedidoCompra', dados.PEDIDOCOMPRA);
      insereValor('#txtItPedCompra', dados.ITPEDIDOCOMPRA);
      insereValor('#txtLargura', dados.LARGURA);
      insereValor('#txtGramatura', dados.GRAMATURA);
      insereValor('#txtTitFioFab', dados.TITULOFIO);
      insereValor('#txtNf', dados.NOTA);
      insereValor('#txtQuantidade', dados.QTDE);
      insereValor('#txtPecas', dados.PECAS);
      insereValor('#txtVariante', dados.VARIANTE);

      $('#rgTipo').val(dados.TIPO).change();
      $('#rgAcabamento').val(dados.ACABAMENTO).change();
      $('#rgPediFluxo').val(dados.PEDIFLUXO).change();
      $('#rgUnidade').val(dados.UNIDADE).change();
      $('#rgOurelas').val(dados.OURELAS).change();
      $('#rgEngomar').val(dados.ENGOMAR).change();
      $('#rgAgulha').val(dados.AGULHA).change();

      if (dados.TECIDO != '') {
        await insereValor('#txtTecido', dados.TECIDO, (await buscaValor('MATERIAL', 'DESCRICAO', 'CODIGO', dados.TECIDO)).DESCRICAO);
      }

      if (dados.COR != '') {
        await insereValor('#txtCor', dados.COR, (await buscaValor('CADCOR', 'DESCRICAO', 'COR', dados.COR)).DESCRICAO);
      }

      if (dados.ESTAMPA != '') {
        await insereValor('#txtEstampa', dados.ESTAMPA, (await buscaValor('CADCOR', 'DESCRICAO', 'COR', dados.ESTAMPA)).DESCRICAO);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modalAddItem').modal('show');
    }
  }

  async function carregaFts(sMaterial) {
    const pesquisaParam = {
      tabela: 'COMP_MATERIAL',
      camposSelect: ['NUM_CONTROLE', 'LARGURA', 'GRAMATURA'],
      where: [`CODIGO = '${sMaterial}'`]
    };

    const jsonFt = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonFt.length == 0) {
      limpaFts();
      return;
    }

    jsonFt.map(item => {
      $('#rgFichaTecnica').append(
        $(
          '<option>',
          {
            value: item.NUM_CONTROLE,
            text: item.NUM_CONTROLE,
            largura: item.LARGURA,
            gramatura: item.GRAMATURA
          }
        )
      );
    });

    $("#rgFichaTecnica").prop("selectedIndex", 1);

    validaFt();
  };

  function validaFt() {
    insereValor('#txtLargura', $("#rgFichaTecnica :selected").attr('largura'));
    insereValor('#txtGramatura', $("#rgFichaTecnica :selected").attr('gramatura'));
    $('#txtLargura').prop('disabled', true);
    $('#txtGramatura').prop('disabled', true);
  };

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      const fal = {
        NUMERO: pegaValor('#txtNumero'),
        EMP_ID: getCookie('emp_id'),
        DATA_INI: pegaValor('#dtEmissao'),
        OBS: pegaValor('#txtObservacoes') + $('#tabelaItens').DataTable().rows().data()[0].OBSERVACAO,
        STATUS: pegaValor('#txtStatus'),
        FAT_PED_COMPLETO: isChecked('#cbFatPedidoCompleto') ? 'S' : 'N',
        COR: $('#tabelaItens').DataTable().rows().data()[0].COR,
        COR_ESTAMPA: $('#tabelaItens').DataTable().rows().data()[0].ESTAMPA,
        ITENS: retornaItensFal(),
        CLIENTE: pegaValor('#txtCliente').split(' - ')[0]
      }

      const response = await requisicao('POST', '/sisplan/fal/v1/fal?', '', JSON.stringify(fal));

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('FAL cadastrada com sucesso!', () => { window.location.href = `${BASE_URI}/servtingimento` });
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function retornaItensFal() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map(item => {
      arrItens.push(item);
    });
    return arrItens;
  };

  async function validaEdicao() {
    if (urlFal == 'create') {
      insereValor('#txtNumero', await RetornaProximo("FAL", "FAL", "NUMERO", 5));
      $('#txtNumero').prop('disabled', true);
      $('#txtStatus').val('N');
      return;
    }

    $.LoadingOverlay('show');
    try {
      const pesquisaFalIt = {
        tabela: 'FAL_ITEN',
        camposSelect: [
          'LOTE', 'TIPO', 'ACABAMENTO', 'PEDIFLUXO', 'TECIDO', 'COR', 'VARIANTE',
          'ESTAMPA', 'PEDIDOTINTO', 'ITPEDIDOTINTO', 'PEDIDOCOMPRA', 'ITPEDIDOCOMPRA',
          'LARGURA', 'GRAMATURA', 'TITULOFIO', 'NOTA', 'QTDE', 'PECAS', 'UNIDADE',
          'OURELAS', 'ENGOMAR', 'AGULHA', 'OBSERVACAO'
        ],
        where: [`FAL = '${urlFal}' AND EMP_ID = ${getCookie('emp_id')}`]
      };

      const jsonStrFalIt = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFalIt));

      let qtdeTotal = 0;

      jsonStrFalIt.map(item => {
        qtdeTotal += item.QTDE;
        item.EXCLUIR = retornaBotaoExcluir();
        $('#tabelaItens').DataTable().row.add(item).draw(false);
      })

      $('#txtNumero').prop('disabled', true);
      $('#dtEmissao').prop('disabled', true);
      insereValor('#txtNumero', urlFal);
      insereValor('#txtQtdeTotal', qtdeTotal);

      const pesquisaParam = {
        tabela: 'FAL',
        camposSelect: [
          'DATA_INI', 'OBS', 'STATUS', 'FAT_PED_COMPLETO'
        ],
        where: [`NUMERO = '${urlFal}' AND EMP_ID = ${getCookie('emp_id')}`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#dtEmissao', jsonStr[0].DATA_INI);
      insereValor('#txtObservacoes', jsonStr[0].OBS);
      insereValor('#txtStatus', jsonStr[0].STATUS);
      $('#cbFatPedidoCompleto').prop('checked', jsonStr[0].FAT_PED_COMPLETO == 'S');

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function addPesquisaAutocompleta() {
    $('#txtTecido').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnTecido").pesquisa_serverside(["#txtTecido"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Material");
    $('#btnATecido').on('click', function () {
      $('#txtTecido').val('');
      limpaFts();
    });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
    $('#btnACor').on('click', function () { $('#txtCor').val(''); });

    $('#txtVariante').autocompleta(1, `JSON={ "tabela":"VARIANTE", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnVariante").pesquisa_serverside(["#txtVariante"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"VARIANTE", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Variante");
    $('#btnAVariante').on('click', function () { $('#txtVariante').val('') });

    $('#txtEstampa').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["TIPO_COR = 'D' OR TIPO_COR = 'R'"]}`);
    $('#btnEstampa').pesquisa('#txtEstampa', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": ["TIPO_COR = 'D' OR TIPO_COR = 'R'"]}`, 'Pesquisa Cor', 'CADCOR');
    $('#btnAEstampa').on('click', function () { $('#txtEstampa').val(''); });
  };

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-pencil-alt" style="color:blue"></span></button>  ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  };

  function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };
});