$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta das FALs.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma FAL.',
          position: 'right'
        }
      },
      {
        element: '#tabelaServTingimento',
        popover: {
          title: 'Tabela Serviço de Tingimento',
          description: 'Aqui estão todas as FALs cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("SERVTINGIMENTO");

  addPesquisaAutocompleta();
  await consultaServTingimento();

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaServTingimento(true);
    $('#modal-filtros').modal('hide');
  });

  async function consultaServTingimento() {
    try {
      $.LoadingOverlay("show");

      const codigo = pegaChave('#txtFal') != '' ? ` AND FAL.NUMERO = '${pegaChave('#txtFal')}'` : '';
      const status = pegaValor('#rgStatus') != '' ? ` AND (FAL.STATUS = '${pegaValor('#rgStatus')}')` : '';

      const pesquisaParam = {
        tabela: 'FAL',
        camposSelect: [
          'FAL.NUMERO',
          'EMPRESA.EMP_PAT',
          'EMPRESA.EMP_NOME',
          'FAL.STATUS',
          'FAL.DATA_INI EMISSAO',
          'FAL.DATA_FIN ENTREGA',
          'SUM(FAL_ITEN.PESO) TOTAL'
        ],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = FAL.CLIENTE' },
          { tabela: 'FAL_ITEN', condicao: 'FAL_ITEN.FAL = FAL.NUMERO' },
          { tabela: 'EMPRESA', condicao: `EMPRESA.EMP_ID = ${getCookie('emp_id')}` }
        ],
        groupBy: [
          'FAL.NUMERO',
          'EMPRESA.EMP_PAT',
          'EMPRESA.EMP_NOME',
          'FAL.STATUS',
          'FAL.DATA_INI',
          'FAL.DATA_FIN'
        ],
        where: [`1=1 ${codigo} ${status}`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaServTingimento').DataTable({
        destroy: true,
        filter: false,
        language: retornaLangDataTable(),
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        order: [[0, 'desc']],
        columnDefs: [
          {
            render: funcBotaoOpcoes,
            targets: [0]
          },
          {
            render: funcRetornaStatus,
            targets: [3],
          },
          {
            render: funcFormataData,
            targets: [4, 5],
          }
        ]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    }
  }

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "servtingimento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaServTingimento').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this)).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  function funcFormataData(data, type, row) {
    if (!data) {
      return 'NÃO ESPECIFICADO'
    }
    x = data.slice(0, 10).split('-');
    return `${x[2]}/${x[1]}/${x[0]}`;
  };

  function funcRetornaStatus(data, type, row) {
    if (!data) {
      return 'NÃO ACEITO'
    }
    if (data == 'N') {
      return 'NÃO ACEITO'
    }
    if (data == 'A') {
      return 'ACEITO'
    }
    if (data == 'R') {
      return 'RECEBIDO'
    }
    if (data == 'P') {
      return 'EM PROGRESSO'
    }
    return data;
  };

  function funcBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btn-imprimir">Imprimir</button>     ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '</div>';
    return retorno;
  };

  function addPesquisaAutocompleta() {
    $('#txtFal').autocompleta(1, `JSON={ "tabela":"FAL", "camposSelect":[ "NUMERO CHAVE", "CLIENTE DESCRICAO"], "where": null}`);
    $('#btnConsultaFal').pesquisa('#txtFal', 'NUMERO', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"FAL", "camposSelect":[ "NUMERO", "CLIENTE"]}`, 'Pesquisa FAL', 'FAL');
    $('#btnLimpaFal').on('click', function () {
      $('#txtFal').val('');
    });
    $('#btnLimparFiltros').on('click', function () {
      $('#txtFal').val('');
      $('#rgStatus').val('').change();
    });
  };

  function retornaLangDataTable() {
    return {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  };

});