$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relPendente == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPendente: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  let facNumeroOld = ''
  let facCodigoOld = ''

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPendente: novasColunas }))

      $('#tabelaRelPendente').DataTable().columns().visible(true);
      $('#tabelaRelPendente').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#buttonColVis',
        popover: {
          title: 'Configurar colunas visíveis ',
          description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
          position: 'right'
        }
      },
      {
        element: '#buttonExcel',
        popover: {
          title: 'Botão Exportar',
          description: 'Clique aqui para exportar a tabela em CSV.',
          position: 'right'
        }
      },
      ]);
      driver.start();
    });
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  await preencheOrdenacaoTela('RelPendente');

  //Buscar automaticamente ao digitar
  $('#txtFaccao').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
  $('#txtSetor').pesquisa_variosServerside(1, '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtMarca').pesquisa_variosServerside(1, '{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtProduto').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtColecao').pesquisa_variosServerside(1, '{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtLinha').pesquisa_variosServerside(1, '{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtOf').pesquisa_variosServerside(1, '{ "tabela":"OF1", "camposSelect":[ "NUMERO", "CODIGO" ], "where": null}', 'NUMERO', 'CODIGO');
  $('#txtGrupoCli').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtCliente').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
  $('#txtPedido').pesquisa_variosServerside(1, '{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ], "where": null}', 'NUMERO', 'CODCLI');
  $('#txtDeposito').pesquisa_variosServerside(1, '{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtFluxo').pesquisa_variosServerside(1, '{ "tabela":"ROTEIRO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtRepresentante').pesquisa_variosServerside(1, '{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'CODREP', 'NOME');
  $('#txtStatusPed').pesquisa_variosServerside(1, '{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtFaixa').pesquisa_variosServerside(1, '{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtCor').pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
  $('#txtTamanho').pesquisa_variosServerside(1, '{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}', 'TAM', 'FAIXA');
  $('#txtGrupoProd').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtEtiqueta').pesquisa_variosServerside(1, '{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtParte').pesquisa_variosServerside(1, '{ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtPeriodo').pesquisa_variosServerside(1, '{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'PRAZO', 'DESCRICAO');
  $('#txtStatusProd').pesquisa_variosServerside(1, '{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtPrazoProd').pesquisa_variosServerside(1, '{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'PRAZO', 'DESCRICAO');
  componenteTipoClassificacao();

  //btn-consultar
  $('#btn-FaccaoConsulta').pesquisa_serversideSel('#txtFaccao', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Facção');
  $('#btn-SetorConsulta').pesquisa_serversideSel('#txtSetor', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Setor');
  $('#btn-MarcaConsulta').pesquisa_serversideSel('#txtMarca', `{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Marca');
  $('#btn-ProdutoConsulta').pesquisa_serversideSel('#txtProduto', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Produto');
  $('#btn-ColecaoConsulta').pesquisa_serversideSel('#txtColecao', `{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Colecao');
  $('#btn-LinhaConsulta').pesquisa_serversideSel('#txtLinha', `{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Linha');
  $('#btn-OfConsulta').pesquisa_serversideSel('#txtOf', `{ "tabela":"OF1", "camposSelect":[ "NUMERO", "CODIGO" ], "where": null}`, 'Pesquisa de Of');
  $('#btn-GrupoCliConsulta').pesquisa_serversideSel('#txtGrupoCli', `{ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Grupo de Cliente');
  $('#btn-ClienteConsulta').pesquisa_serversideSel('#txtCliente', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Cliente');
  $('#btn-PedidoConsulta').pesquisa_serversideSel('#txtPedido', `{ "tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ], "where": null}`, 'Pesquisa de Pedido');
  $('#btn-DepositoConsulta').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Depósito');
  $('#btn-FluxoConsulta').pesquisa_serversideSel('#txtFluxo', `{ "tabela":"ROTEIRO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Fluxo');
  $('#btn-RepresentanteConsulta').pesquisa_serversideSel('#txtRepresentante', `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, 'Pesquisa de Representante');
  $('#btn-StatusPedConsulta').pesquisa_serversideSel('#txtStatusPed', `{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Status');
  $('#btn-FaixaConsulta').pesquisa_serversideSel('#txtFaixa', `{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Faixa');
  $('#btn-CorConsulta').pesquisa_serversideSel('#txtCor', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}`, 'Pesquisa de Cor');
  $('#btn-TamanhoConsulta').pesquisa_serversideSel('#txtTamanho', `{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}`, 'Pesquisa de Tamanho');
  $('#btn-GrupoProdConsulta').pesquisa_serversideSel('#txtGrupoProd', `{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Grupo de Produto');
  $('#btn-EtiquetaConsulta').pesquisa_serversideSel('#txtEtiqueta', `{ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Etiqueta');
  $('#btn-ParteConsulta').pesquisa_serversideSel('#txtParte', `{ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Parte');
  $('#btn-PeriodoConsulta').pesquisa_serversideSel('#txtPeriodo', `{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Periodo');
  $('#btn-StatusProdConsulta').pesquisa_serversideSel('#txtStatusProd', `{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Status de Produto');
  $('#btn-PrazoProdConsulta').pesquisa_serversideSel('#txtPrazoProd', `{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Prazo de Produtos');

  //limpa pesquisa
  $('#btn-limpa-Faccao').on('click', function () { $('#txtFaccao').empty().trigger('change') })
  $('#btn-limpa-Setor').on('click', function () { $('#txtSetor').empty().trigger('change') })
  $('#btn-limpa-Marca').on('click', function () { $('#txtMarca').empty().trigger('change') })
  $('#btn-limpa-Produto').on('click', function () { $('#txtProduto').empty().trigger('change') })
  $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').empty().trigger('change') })
  $('#btn-limpa-Linha').on('click', function () { $('#txtLinha').empty().trigger('change') })
  $('#btn-limpa-Of').on('click', function () { $('#txtOf').empty().trigger('change') })
  $('#btn-limpa-GrupoCli').on('click', function () { $('#txtGrupoCli').empty().trigger('change') })
  $('#btn-limpa-CLiente').on('click', function () { $('#txtCliente').empty().trigger('change') })
  $('#btn-limpa-Pedido').on('click', function () { $('#txtPedido').empty().trigger('change') })
  $('#btn-limpa-Deposito').on('click', function () { $('#txtDeposito').empty().trigger('change') })
  $('#btn-limpa-Fluxo').on('click', function () { $('#txtFluxo').empty().trigger('change') })
  $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').empty().trigger('change') })
  $('#btn-limpa-StatusPed').on('click', function () { $('#txtStatusPed').empty().trigger('change') })
  $('#btn-limpa-Faixa').on('click', function () { $('#txtFaixa').empty().trigger('change') })
  $('#btn-limpa-Cor').on('click', function () { $('#txtCor').empty().trigger('change') })
  $('#btn-limpa-Tamanho').on('click', function () { $('#txtTamanho').empty().trigger('change') })
  $('#btn-limpa-GrupoProd').on('click', function () { $('#txtGrupoProd').empty().trigger('change') })
  $('#btn-limpa-Etiqueta').on('click', function () { $('#txtEtiqueta').empty().trigger('change') })
  $('#btn-limpa-Parte').on('click', function () { $('#txtParte').empty().trigger('change') })
  $('#btn-limpa-Periodo').on('click', function () { $('#txtPeriodo').empty().trigger('change') })
  $('#btn-limpa-StatusProd').on('click', function () { $('#txtStatusProd').empty().trigger('change') })
  $('#btn-limpa-PrazoProd').on('click', function () { $('#txtPrazoProd').empty().trigger('change') })

  //limpas todos os campos
  $('#btnLimparFiltros').on('click', async function () {
    $('#dtPrevRetornoDe').val('1200-01-01');
    $('#dtPrevRetornoAte').val('2500-12-31');
    $('#dtFinalDe').val('1200-01-01');
    $('#dtFinalAte').val('2500-12-31');
    $('#dtEnvioDe').val('1200-01-01');
    $('#dtEnvioAte').val('2500-12-31');
    $('#txtFaccao').empty().trigger('change')
    $('#txtSetor').empty().trigger('change')
    $('#txtMarca').empty().trigger('change')
    $('#txtProduto').empty().trigger('change')
    $('#txtColecao').empty().trigger('change')
    $('#txtLinha').empty().trigger('change')
    $('#txtOf').empty().trigger('change')
    $('#txtGrupoCli').empty().trigger('change')
    $('#txtPedido').empty().trigger('change')
    $('#txtDeposito').empty().trigger('change')
    $('#txtFluxo').empty().trigger('change')
    $('#txtRepresentante').empty().trigger('change')
    $('#txtStatusPed').empty().trigger('change')
    $('#txtFaixa').empty().trigger('change')
    $('#txtCor').empty().trigger('change')
    $('#txtTamanho').empty().trigger('change')
    $('#txtGrupoProd').empty().trigger('change')
    $('#txtEtiqueta').empty().trigger('change')
    $('#txtParte').empty().trigger('change')
    $('#txtPeriodo').empty().trigger('change')
    $('#txtStatusProd').empty().trigger('change')
    $('#txtPrazoProd').empty().trigger('change')
    $('#txtCliente').empty().trigger('change')
    $('#rdTodos').prop('checked', true);
    $('#rdBuscaTodos').prop('checked', true);
    $('#rdTipoTodos').prop('checked', true);
    $('#cbFoto').prop('checked', false);
    $('#cbDiasPendentes').prop('checked', false);
    $('#cbAgruparPorOf').prop('checked', false);
    $('#cbBuscarBaixados').prop('checked', false);
    $('#cbSomarConjunto').prop('checked', false);
    $('#cbResumoPeriodo').prop('checked', false);
    $('#cbSomarPecas').prop('checked', false);
    $('#cbBuscarNotasFiscais').prop('checked', false);
    $('#cbNotasTodasEmpresas').prop('checked', false);
    $('#cbBuscarPrecoSped').prop('checked', false);
    $('#cbMostrarProximoSetor').prop('checked', false);
    $('#cbCustoIndustrial').prop('checked', false);
    $('#cbBuscaDataPrevSetor').prop('checked', false);
    $('#cbConsiderarUltSetor').prop('checked', false);
    $('#cbProcessoSubProduto').prop('checked', false);
    $('#cbListaPartes').prop('checked', false);
    $('#cbConsideraFaccao').prop('checked', true);
    $('#cbConsideraSetor').prop('checked', true);
    $('#cbConsideraMarca').prop('checked', true);
    $('#cbConsideraColecao').prop('checked', true);
    $('#cbConsideraLinha').prop('checked', true);
    $('#cbConsideraGrupoProd').prop('checked', true);
    $('#cbConsideraEtiqueta').prop('checked', true);
  });

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const dtPrevRetornoDe = $('#dtPrevRetornoDe').val();
    const dtPrevRetornoAte = $('#dtPrevRetornoAte').val();
    const dtFinalDe = $('#dtFinalDe').val();
    const dtFinalAte = $('#dtFinalAte').val();
    const dtEnvioDe = $('#dtEnvioDe').val();
    const dtEnvioAte = $('#dtEnvioAte').val();
    const faccao = await formataListas($('#txtFaccao').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const produto = await formataListas($('#txtProduto').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const ofs = await formataListas($('#txtOf').val().toString());
    const grupoCli = await formataListas($('#txtGrupoCli').val().toString());
    const pedido = await formataListas($('#txtPedido').val().toString());
    const deposito = await formataListas($('#txtDeposito').val().toString());
    const fluxo = await formataListas($('#txtFluxo').val().toString());
    const representante = await formataListas($('#txtRepresentante').val().toString());
    const statusPed = await formataListas($('#txtStatusPed').val().toString());
    const faixa = await formataListas($('#txtFaixa').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const tamanho = await formataListas($('#txtTamanho').val().toString());
    const grupoProd = await formataListas($('#txtGrupoProd').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const parte = await formataListas($('#txtParte').val().toString());
    const periodo = await formataListas($('#txtPeriodo').val().toString());
    const statusProd = await formataListas($('#txtStatusProd').val().toString());
    const prazoProd = await formataListas($('#txtPrazoProd').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const tipoClassificacao = await formataListas($('#txtProdClasTipo').val().toString());
    const cbFoto = $('#cbFoto').is(':checked') ? true : false;
    const cbDiasPendentes = $('#cbDiasPendentes').is(':checked') ? true : false;
    const cbAgruparPorOf = $('#cbAgruparPorOf').is(':checked') ? true : false;
    const cbBuscaBaixados = $('#cbBuscarBaixados').is(':checked') ? true : false;
    const cbSomarConjunto = $('#cbSomarConjunto').is(':checked') ? true : false;
    const cbResumoPeriodo = $('#cbResumoPeriodo').is(':checked') ? true : false;
    const cbSomarPecas = $('#cbSomarPecas').is(':checked') ? true : false;
    const cbBuscarNotasFiscais = $('#cbBuscarNotasFiscais').is(':checked') ? true : false;
    const cbNotasTodasEmpresas = $('#cbNotasTodasEmpresas').is(':checked') ? true : false;
    const cbBuscarPrecoSped = $('#cbBuscarPrecoSped').is(':checked') ? true : false;
    const cbMostrarProximoSetor = $('#cbMostrarProximoSetor').is(':checked') ? true : false;
    const cbCustoIndustrial = $('#cbCustoIndustrial').is(':checked') ? true : false;
    const cbBuscarDataPrevSetor = $('#cbBuscaDataPrevSetor').is(':checked') ? true : false;
    const cbConsiderarUltSetor = $('#cbConsiderarUltSetor').is(':checked') ? true : false;
    const cbProcessoSubProduto = $('#cbProcessoSubProduto').is(':checked') ? true : false;
    const cbListaPartes = $('#cbListaPartes').is(':checked') ? true : false;
    const tipoDeOf = $('input[name="rdfiltroTipoDeOf"]:checked').val();
    const buscarOf = $('input[name="rdfiltroBuscarOf"]:checked').val();
    const tipoOf = $('input[name="rdfiltroTipoOf"]:checked').val();
    const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;

    const consideraFaccao = $('#cbConsideraFaccao').is(':checked') ? true : false;
    const consideraSetor = $('#cbConsideraSetor').is(':checked') ? true : false;
    const consideraMarca = $('#cbConsideraMarca').is(':checked') ? true : false;
    const consideraColecao = $('#cbConsideraColecao').is(':checked') ? true : false;
    const consideraLinha = $('#cbConsideraLinha').is(':checked') ? true : false;
    const consideraGrupoProd = $('#cbConsideraGrupoProd').is(':checked') ? true : false;
    const consideraEtiqueta = $('#cbConsideraEtiqueta').is(':checked') ? true : false;

    const retorno =
      `CLIENTE=${cliente}&` +
      `REPRESENTATE=${representante}&` +
      `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
      `DTPREVRETORNODE=${dtPrevRetornoDe}&` +
      `DTPREVRETORNOATE=${dtPrevRetornoAte}&` +
      `DTFINALDE=${dtFinalDe}&` +
      `DTFINALATE=${dtFinalAte}&` +
      `DTENVIODE=${dtEnvioDe}&` +
      `DTENVIOATE=${dtEnvioAte}&` +
      `FACCAO=${faccao}&` +
      `MARCA=${marca}&` +
      `PRODUTO=${produto}&` +
      `COLECAO=${colecao}&` +
      `LINHA=${linha}&` +
      `OF=${ofs}&` +
      `GRUPOCLI=${grupoCli}&` +
      `PEDIDO=${pedido}&` +
      `DEPOSITO=${deposito}&` +
      `FLUXO=${fluxo}&` +
      `REPRESENTANTE=${representante}&` +
      `STATUSPED=${statusPed}&` +
      `FAIXA=${faixa}&` +
      `COR=${cor}&` +
      `TAMANHO=${tamanho}&` +
      `GRUPOPROD=${grupoProd}&` +
      `ETIQUETA=${etiqueta}&` +
      `PARTE=${parte}&` +
      `PERIODO=${periodo}&` +
      `STATUSPROD=${statusProd}&` +
      `PRAZOPROD=${prazoProd}&` +
      `CBFOTO=${cbFoto}&` +
      `CBDIASPENDENTES=${cbDiasPendentes}&` +
      `CBAGRUPARPOROF=${cbAgruparPorOf}&` +
      `CBBUSCARBAIXADOS=${cbBuscaBaixados}&` +
      `CBSOMARCONJUNTO=${cbSomarConjunto}&` +
      `CBRESUMOPERIODO=${cbResumoPeriodo}&` +
      `CBSOMARPECAS=${cbSomarPecas}&` +
      `CBBUSCARNOTASFISCAIS=${cbBuscarNotasFiscais}&` +
      `CBNOTASTODASEMPRESAS=${cbNotasTodasEmpresas}&` +
      `CBBUSCARPRECOSPED=${cbBuscarPrecoSped}&` +
      `CBMOSTRARPROXIMOSETOR=${cbMostrarProximoSetor}&` +
      `CBCUSTOINDUSTRIAL=${cbCustoIndustrial}&` +
      `CBBUSCARDATAPREVSETOR=${cbBuscarDataPrevSetor}&` +
      `CBCONSIDERARULTSETOR=${cbConsiderarUltSetor}&` +
      `CBPROCESSOSUBPRODUTO=${cbProcessoSubProduto}&` +
      `CBLISTAPARTES=${cbListaPartes}&` +
      `TIPODEOF=${tipoDeOf}&` +
      `BUSCAROF=${buscarOf}&` +
      `TIPOOF=${tipoOf}&` +
      `CONSIDERARFACCAO=${consideraFaccao}&` +
      `CONSIDERARSETOR=${consideraSetor}&` +
      `CONSIDERARMARCA=${consideraMarca}&` +
      `CONSIDERARCOLECAO=${consideraColecao}&` +
      `CONSIDERARLINHA=${consideraLinha}&` +
      `CONSIDERARGRUPOPROD=${consideraGrupoProd}&` +
      `CONSIDERARETIQUETA=${consideraEtiqueta}&` +
      `TODASEMPRESAS=${todasEmpresas}&` +
      `TIPOCLASSIFICACAO=${tipoClassificacao}`;

    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'RelPendente')

  $('#txtOrdem').on('change', function () {
    retornaHintRelatorio('btnImprimir', $("#txtOrdem option")
      .toArray()
      .map(map => {
        return [map.selected, $(map)
          .attr('nome_prt')]
      })
      .filter(filter => filter[0] == true)[0][1])
  })

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  async function fazConsultaPedido(facNumero) {
    if ($.fn.DataTable.isDataTable('#tabelaRelPendentePedido')) {
      $('#tabelaRelPendentePedido').DataTable().destroy();
      $('#tabelaRelPendentePedido').empty();
    }
    try {
      dataSetColsPedidos = [];
      const url = "/sisplan/impressao/v1/consultarelpendente?";
      const filtros = await retornaFiltros();
      const response = await requisicao("GET", url, `${filtros}&PEDIDOS=${'S'}&FAC_NUMERO=${facNumero}&EMPRESA=${getCookie("empresa")}`, "", 360000);

      if (!response) {
        return;
      }

      const jsonStrPedidos = await response.json();

      if (jsonStrPedidos.length == 0) {
        if ($.fn.DataTable.isDataTable('#tabelaRelPendentePedido')) {
          $('#tabelaRelPendentePedido').DataTable().destroy();
          $('#tabelaRelPendentePedido').empty();
        }
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStrPedidos.mensagem);
        return;
      };

      let keys = Object.keys(jsonStrPedidos[0]);

      keys.forEach((k) => {
        dataSetColsPedidos.push({
          title: k,
          data: k,
        });
      });

      $('#tabelaRelPendentePedido').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado na tabela de pedidos",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado na tabela de pedidos",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetColsPedidos,
        data: jsonStrPedidos,
      });
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível fazer consulta dos pedidos! Tente novamente.");
      return;
    }
  }

  async function fazConsultaSubProduto(facCodigo) {
    if ($.fn.DataTable.isDataTable('#tabelaRelPendenteSubProduto')) {
      $('#tabelaRelPendenteSubProduto').DataTable().destroy();
      $('#tabelaRelPendenteSubProduto').empty();
    }
    try {
      dataSetColsSubProduto = [];
      const url = "/sisplan/impressao/v1/consultarelpendente?";
      const filtros = await retornaFiltros();
      const response = await requisicao("GET", url, `${filtros}&SUBPRODUTO=${'S'}&FAC_CODIGO=${facCodigo}&EMPRESA=${getCookie("empresa")}`, "", 360000);

      if (!response) {
        return;
      }

      const jsonStrSubProduto = await response.json();

      if (jsonStrSubProduto.length == 0) {
        if ($.fn.DataTable.isDataTable('#tabelaRelPendenteSubProduto')) {
          $('#tabelaRelPendenteSubProduto').DataTable().destroy();
          $('#tabelaRelPendenteSubProduto').empty();
        }
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStrSubProduto.mensagem);
        return;
      };

      let keys = Object.keys(jsonStrSubProduto[0]);

      keys.forEach((k) => {
        dataSetColsSubProduto.push({
          title: k,
          data: k,
        });
      });

      $('#tabelaRelPendenteSubProduto').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado na tabela de SubProduto",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado na tabela de SubProduto",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetColsSubProduto,
        data: jsonStrSubProduto,
      });
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível fazer consulta dos sub-produtos! Tente novamente.");
      return;
    }
  }

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaRelPendente')) {
      $('#tabelaRelPendente').DataTable().destroy();
      $('#tabelaRelPendente').empty();
    }
    try {
      dataSetCols = [];
      const url = "/sisplan/impressao/v1/consultarelpendente?";
      const filtros = await retornaFiltros();
      const response = await requisicao("GET", url, `${filtros}&PENDENTE=${'S'}&EMPRESA=${getCookie("empresa")}`, "", 360000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        if ($.fn.DataTable.isDataTable('#tabelaRelPendente')) {
          $('#tabelaRelPendente').DataTable().destroy();
          $('#tabelaRelPendente').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaRelPendentePedido')) {
          $('#tabelaRelPendentePedido').DataTable().destroy();
          $('#tabelaRelPendentePedido').empty();
        }
        if ($.fn.DataTable.isDataTable('#tabelaRelPendenteSubProduto')) {
          $('#tabelaRelPendenteSubProduto').DataTable().destroy();
          $('#tabelaRelPendenteSubProduto').empty();
        }
        return;
      }

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      };

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      $('#tabelaRelPendente').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaRelPendente_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaRelPendente_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelpendente?';
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Pendente de Facção', '#tabelaRelPendente');
      })


      $('#tabelaRelPendente').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relPendente).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível fazer consulta do relatório! Tente novamente.");
      return;
    }
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelpendente?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelPendente&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPendente');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelPendente');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      await fazConsulta();
      if (facNumeroOld != '') {
        facNumeroOld = ''
      }
      if (facCodigoOld != '') {
        facCodigoOld = ''
      }
      if ($('#cbProcessoSubProduto').is(':checked')) {
        $("#containerSubProduto").removeClass('d-none');
        $("#containerPedido").removeClass("col-12").addClass("col-6");
      } else {
        $("#containerSubProduto").addClass('d-none');
        $("#containerPedido").removeClass("col-6").addClass("col-12");
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  });

  $('#tabelaRelPendente').on('draw.dt', function () {
    if ($('#tabelaRelPendente').DataTable().rows().count() > 0) {
      $('#tabelaRelPendente tbody tr:eq(0)').trigger('click');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelPendente').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relPendente ?? [])
  })

  $('#tabelaRelPendente').on('click', 'tr', async function () {
    $("#tabelaRelPendente").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass('selected')
    let data = $("#tabelaRelPendente").DataTable().row($(this)).data();
    let facNumero = data.FAC_NUMERO
    let facCodigo = data.FAC_CODIGO
    if ((facNumeroOld == '') || (facNumero != facNumeroOld) || (facCodigoOld == '') || (facCodigo != facCodigoOld)) {
      if ((facNumeroOld == '') || (facNumero != facNumeroOld)) {
        $.LoadingOverlay("show");
        try {
          if (facNumero != '') {
            facNumeroOld = facNumero
          }
          await fazConsultaPedido(facNumero);
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      if ($('#cbProcessoSubProduto').is(':checked')) {
        if ((facCodigoOld == '') || (facCodigo != facCodigoOld)) {
          $.LoadingOverlay("show");
          try {
            if (facCodigo != '') {
              facCodigoOld = facCodigo
            }
            await fazConsultaSubProduto(facCodigo)
          } finally {
            $.LoadingOverlay("hide");
          }
        }
      }
    }

  })
});