$("#tutorial").on("click", function () {
    $("#geral-tab").trigger("click");
    const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        onHighlightStarted: (Element) => {
            if (Element.node.id == "geral") {
                if (!$("#multiCollapseExample1").hasClass("show"));
                $("#multiCollapseExample1").collapse("show");
            } else if (Element.node.id == "duplicatas") {
                if (!$("#collapseFiltros").hasClass("show")) {
                    $("#duplicatas").collapse("show");
                    $("#multiCollapseExample2").collapse("show");
                }
            }
        },
        onPrevious: (Element) => {
            if (
                Element.node.id == "dupicatas-tab" ||
                Element.node.id == "dupicatas"
            ) {
                if (!$("#duplicatas>a").hasClass("collapsed")) {
                    $("#multiCollapseExample2").collapse("show");
                }
            } else if (Element.node.id == "historico") {
                if (!$("#duplicatas>a").hasClass("collapsed")) {
                    $("#duplicatas").collapse("show");
                }
            }
        },
    });

    driver.defineSteps([{
        element: "#geral",
        popover: {
            title: "Aba Geral",
            description: "Clique aqui para abrir a aba geral.",
            position: "botton",
        },
    },
    {
        element: "#multiCollapseExample1",
        popover: {
            title: "Dados Gerais",
            description: "Esses são os campos que você informará os dados gerais.",
            position: "top",
        },
    },
    {
        element: "#duplicatas",
        popover: {
            title: "Aba Duplicatas",
            description: "Clique aqui para abrir aba duplicatas.",
            position: "top",
        },
    },
    {
        element: "#multiCollapseExample2",
        popover: {
            title: "Dados de Duplicatas",
            description: "Aqui ficam as duplicatas importadas.",
            position: "top",
        },
    },
    {
        element: "#btnVoltar",
        popover: {
            title: "Botão Voltar",
            description: "Ao clicar nesse botão você retorna para a tela de consulta de bloquetos.",
            position: "left",
        },
    },
    {
        element: "#btnImprimir",
        popover: {
            title: "Botão Imprimir",
            description: "Ao clicar nesse botão você irá imprimir as duplicatas filtradas.",
            position: "left",
        },
    },
    {
        element: "#btnVoltarTodas",
        popover: {
            title: "Botão Voltar Todas",
            description: "Ao clicar nesse botão você irá voltar todas as duplicatas.",
            position: "left",
        },
    },
    {
        element: "#btnVoltarDup",
        popover: {
            title: "Botão Voltar Duplicata",
            description: "Ao clicar nesse botão você irá voltar a duplicata selecionada.",
            position: "left",
        },
    },
    {
        element: "#btnRecalcular",
        popover: {
            title: "Botão Recalcular",
            description: "Ao clicar nesse botão você irá fazer o recalculo das duplicatas filtradas.",
            position: "left",
        },
    },
    ]);

    driver.start();
    driver.getHighlightedElement();
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let bloqueto = parametros[parametros.length - 1];
    let alterouTaxa = false;
    let alterouMulta = false;
    let nrBancoOriginal;
    let alterouVenctoDup = false;
    let vencimentoOrigDup;

    $('#txtAcrescimo').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtTaxaAcrescimo').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtMultaAtraso').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
    $('#btnConta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
    $('#btnAConta').on('click', function () { $('#txtConta').val('') })

    $('#txtAlterarBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}`);
    $('#btnAlterarBanco').pesquisa_serverside(['#txtAlterarBanco'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
    $('#btnAAlterarBanco').on('click', function () { $('#txtAlterarBanco').val('') })

    $('#cbLayoutGrafico').on('click', function () {
        if ($('#cbLayoutGrafico').is(':checked')) {
            $('#cbNossoNumero').prop('checked', true)
            $('#cbNossoNumero').prop('disabled', true)
        } else {
            $('#cbNossoNumero').prop('checked', false)
            $('#cbNossoNumero').prop('disabled', false)
        }
    })

    $('#cbProtesto1').on('click', function () {
        if ($('#cbProtesto1').is(':checked')) {
            $('#txtInstrucao1').prop('disabled', false)
        } else {
            $('#txtInstrucao1').prop('disabled', true)
            $('#txtInstrucao1').val('')
        }
    })

    $('#cbProtesto2').on('click', function () {
        if ($('#cbProtesto2').is(':checked')) {
            $('#txtInstrucao2').prop('disabled', false)
        } else {
            $('#txtInstrucao2').prop('disabled', true)
            $('#txtInstrucao2').val('')
        }
    })

    $('#cbAtualizaValor').on('click', function () {
        if ($('#cbAtualizaValor').is(':checked')) {
            $($('#cbCalcular').parents()[0]).removeClass('d-none')
        } else {
            $($('#cbCalcular').parents()[0]).addClass('d-none')
        }
    })

    $('#cbAtualizarVencimento').on('click', function () {
        if ($('#cbAtualizarVencimento').is(':checked')) {
            $($('#dtNovoVencimento').parents()[0]).removeClass('d-none')
        } else {
            $($('#dtNovoVencimento').parents()[0]).addClass('d-none')
        }
    })

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/relbloqueto`;
        localStorage.removeItem('resgistros');
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Alterar Banco" id="btn-alterarBanco">Alterar Banco</button>     ' +
            '    <button class="dropdown-item" type="button" title="Alterar Todos os Banco" id="btn-alterarTodosBancos">Alterar Todos os Bancos</button>     ' +
            '    <button class="dropdown-item" type="button" title="Alterar Duplicata" id="btn-alterarDuplicata">Alterar Duplicata</button>     ' +
            '    <button class="dropdown-item" type="button" title="Alterar Todas as Contas" id="btn-alterarContas">Alterar Todas as Contas</button>     ' +
            // '    <button class="dropdown-item" type="button" title="Gerar Borderô" id="btn-gerarBordero">Gerar Borderô</button>     ' +
            '</div>';
        return retorno;
    };

    async function buscaDados(registros) {
        if ($.fn.DataTable.isDataTable('#tabelaDuplicatas')) {
            $('#tabelaDuplicatas').DataTable().destroy();
            $('#tabelaDuplicatas').empty();
        }
        $.LoadingOverlay("show");
        try {
            try {
                dataSetCols = [];
                const url = "/sisplan/relbloqueto/v1/consultarelbloqueto?";
                let numeros = []
                let faturas = []
                for (let i = 0; i < registros.length; i++) {
                    numeros.push(registros[i].NUMERO)
                    faturas.push(registros[i].FATURA)

                }
                numeros = await formataListas(numeros.toString())
                faturas = await formataListas(faturas.toString())
                const response = await requisicao("GET", url, `NUMEROS=${numeros}&FATURAS=${faturas}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (jsonStr.length == 0) {
                    msgAlerta("Nenhum registro encontrado!");
                    if ($.fn.DataTable.isDataTable('#tabelaDuplicatas')) {
                        $('#tabelaDuplicatas').DataTable().destroy();
                        $('#tabelaDuplicatas').empty();
                    }
                    return;
                }

                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                };

                let keys = Object.keys(jsonStr[0]);

                keys.forEach((k) => {
                    dataSetCols.push({
                        title: k,
                        data: k,
                    });
                });

                $('#tabelaDuplicatas').DataTable({
                    bPaginate: true,
                    destroy: true,
                    colReorder: true,
                    language: {
                        sEmptyTable: "Nenhum registro encontrado",
                        sInfo: "_TOTAL_ registros",
                        sInfoEmpty: " 0 registros",
                        sInfoFiltered: "(Filtrados de _MAX_ registros)",
                        sInfoPostFix: "",
                        sInfoThousands: ".",
                        sLengthMenu: "_MENU_ resultados",
                        sLoadingRecords: "Carregando...",
                        sProcessing: "Processando...",
                        sZeroRecords: "Nenhum registro encontrado",
                        sSearch: "Pesquisar",
                        oPaginate: {
                            sNext: "Próximo",
                            sPrevious: "Anterior",
                            sFirst: "Primeiro",
                            sLast: "Último",
                        },
                        oAria: {
                            sSortAscending: ": Ordenar colunas de forma ascendente",
                            sSortDescending: ": Ordenar colunas de forma descendente",
                        },
                    },
                    autoWidth: true,
                    columns: dataSetCols,
                    data: jsonStr,
                    columnDefs: [
                        {
                            targets: [0], render: function (data, type, row) {
                                return retornaBotaoOpcoes(data);
                            }
                        },
                        {
                            type: "date-br",
                            render(data) {
                                return new Intl.DateTimeFormat("pt-BR").format(
                                    new Date(`${data.split(" ")[0]} 23:59:59`)
                                );
                            },
                            targets: [10, 11, 12]
                        },
                        {
                            render(data) {
                                return parseFloat(data).toLocaleString("pt-br", {
                                    minimumFractionDigits: 2,
                                });
                            },
                            targets: [7, 8, 9, 13, 14, 15, 16, 17],
                            "className": 'pr-4 text-right'
                        },
                    ]
                });

                $('#tabelaDuplicatas tbody').on('click', 'tr', async function () {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                    } else {
                        $('#tabelaDuplicatas').DataTable().$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                    }
                });

                setTimeout(() => {
                    $('#btnRecalcular').click()
                }, 2000)

            } catch (err) {
                console.error(err);
                msgErro(`Não foi possível buscar os dados das duplicatas!`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function iniciaRotinaGravaBordero() {
        $.LoadingOverlay('show');
        try {
            //    const statusCarteira = await buscaValor('CARTEIRA', ['SITUA_BCO'], ['CARTEIRA', 'CONTA'], [pegaChave('#txtCarteira'), pegaChave('#txtConta')]);
            let contaAnterior = '';
            let bancoAnterior = '';
            let listaNumeros = '';

            if ($('#txtConta').val() == '' || $('#rgCarteira').val() == '') {
                msgAlerta('Conta ou carteira inválida! Por favor, verifique.');
                $('#txtConta').trigger('focusin');
                return;
            };

            const datatableDuplicatas = $('#tabelaDuplicatas').DataTable().data().toArray();
            const bancoFiltro = pegaChave('#txtBanco');

            for (i = 0; i < datatableDuplicatas.length; i++) {
                if (bancoFiltro != '') {
                    if (bancoFiltro != datatableDuplicatas[i].BANCO) {
                        msgErro('Banco da duplicata ' + datatableDuplicatas[i].NUMERO + ' diferente do campo banco! Impossível continuar, verifique.');
                        return;
                    };
                };

                if (contaAnterior != datatableDuplicatas[i].CONTACHEQUE && contaAnterior != '') {
                    msgErro('Para gerar borderô é necessário todas as duplicatas selecionadas serem da mesma conta! Impossível continuar, verifique.');
                    return;
                };

                if (bancoAnterior != datatableDuplicatas[i].BANCO && bancoAnterior != '') {
                    msgErro('Para gerar borderô é necessário todas as duplicatas selecionadas serem do mesmo banco! Impossível continuar, verifique.');
                    return;
                };

                if (datatableDuplicatas[i].BORDERO != '0' && datatableDuplicatas[i].BORDERO != '') {
                    msgErro('Duplicata nº: ' + datatableDuplicatas[i].NUMERO + ' já existe borderô informado. Favor excluir a mesma do borderô antigo para inserir no novo! Impossível continuar.');
                    return;
                };

                if (listaNumeros == '') {
                    listaNumeros = datatableDuplicatas[i].NUMERO;
                } else {
                    listaNumeros = listaNumeros + ', ' + datatableDuplicatas[i].NUMERO
                };

                contaAnterior = datatableDuplicatas[i].CONTACHEQUE;
                bancoAnterior = datatableDuplicatas[i].BANCO;
            };

            const infoCarteira = await buscaValor('CARTEIRA', ['*'], ['CONTA'], [`${pegaChave('#txtConta')}`]);

            const response = await requisicao('POST',
                '/sisplan/relbloqueto/v1/gerabordero?',
                `CONTA=${pegaChave('#txtConta')}&CARTEIRA=${infoCarteira.CARTEIRA}&VARCART1=&DIASPROTESTO=${infoCarteira.DIASPROTESTO}&OCORRENCIA=&TXACRESC=${infoCarteira.TAXA1}&TXMULTA=${infoCarteira.TAXA2}&LISTANUMEROS=${listaNumeros}&GERALAYOUTGRAFICO=${$('#cbLayoutGrafico').is(':checked') ? true : false}`,
                null,
                120000);

            if (!response) {
                return;
            };

            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            };

            const jsonStr = await response.json();

            criaMensagemSucesso('Borderô gerado com sucesso! Nº: ' + String(jsonStr));

        } catch (err) {
            console.error(err)
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    $('#tabelaDuplicatas').on('click', '#btn-alterarBanco', async function () {
        $.LoadingOverlay('show')
        try {
            let data = $('#tabelaDuplicatas').DataTable().row($(this).parents("tr")).data()

            if (data.NRBANCO != '') {
                msgAlerta('Duplicata com o Nosso Numero gerado. Deseja Continuar?', async () => {
                    $('#containerDuplicata').removeClass('d-none')
                    $('#containerBanco').addClass('col-9')
                    $('#containerBanco').addClass('col-md-9')
                    $('#containerBanco').removeClass('col-12')
                    $('#containerBanco').removeClass('col-md-12')
                    $('#btnGravarBanco').removeClass('d-none')
                    $('#btnGravarTodosBancos').addClass('d-none')
                    $('#modal-alterarBanco').modal('show')
                    $('#txtDuplicataBanco').val(data.NUMERO)
                    insereValor('#txtAlterarBanco', data.BANCO, data.NOME_BANCO)
                }, async () => {
                    return;
                })
            } else {
                $('#containerDuplicata').removeClass('d-none')
                $('#containerBanco').addClass('col-9')
                $('#containerBanco').addClass('col-md-9')
                $('#containerBanco').removeClass('col-12')
                $('#containerBanco').removeClass('col-md-12')
                $('#btnGravarBanco').removeClass('d-none')
                $('#btnGravarTodosBancos').addClass('d-none')
                $('#modal-alterarBanco').modal('show')
                $('#txtDuplicataBanco').val(data.NUMERO)
                insereValor('#txtAlterarBanco', data.BANCO, data.NOME_BANCO)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnGravarBanco').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let numero = $('#txtDuplicataBanco').val()
                let banco = pegaChave('#txtAlterarBanco')
                // if (banco == '') {
                //     msgAlerta('Banco não informado!')
                //     return;
                // }
                let response = await requisicao("POST", "/sisplan/relbloqueto/v1/alterarbanco?", `NUMERO=${encodeURIComponent(numero)}&BANCO=${banco}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success(`Banco Alterado com sucesso!`, "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

                $('#modal-alterarBanco').modal('hide')
                let registros = JSON.parse(localStorage.getItem('registros'));
                await buscaDados(registros)
            } catch (err) {
                console.error(err)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaDuplicatas').on('click', '#btn-alterarTodosBancos', async function () {
        $.LoadingOverlay('show')
        try {
            let nrbancoPreenchido = false;

            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                let item = this.data();
                if (item.NRBANCO) {
                    nrbancoPreenchido = true;
                }
            })

            if (nrbancoPreenchido) {
                msgAlerta('Existem duplicatas com o Nosso Numero gerado. Deseja Continuar?', async () => {
                    $('#containerDuplicata').addClass('d-none')
                    $('#containerBanco').removeClass('col-9')
                    $('#containerBanco').removeClass('col-md-9')
                    $('#containerBanco').addClass('col-12')
                    $('#containerBanco').addClass('col-md-12')
                    $('#btnGravarBanco').addClass('d-none')
                    $('#btnGravarTodosBancos').removeClass('d-none')
                    $('#txtAlterarBanco').val('')
                    $('#modal-alterarBanco').modal('show')
                }, async () => {
                    return;
                })
            } else {
                $('#containerDuplicata').addClass('d-none')
                $('#containerBanco').removeClass('col-9')
                $('#containerBanco').removeClass('col-md-9')
                $('#containerBanco').addClass('col-12')
                $('#containerBanco').addClass('col-md-12')
                $('#btnGravarBanco').addClass('d-none')
                $('#btnGravarTodosBancos').removeClass('d-none')
                $('#txtAlterarBanco').val('')
                $('#modal-alterarBanco').modal('show')
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnGravarTodosBancos').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let banco = pegaChave('#txtAlterarBanco')
                // if (banco == '') {
                //     msgAlerta('Banco não informado!')
                //     return;
                // }
                let registros = JSON.parse(localStorage.getItem('registros'));
                let response;
                for (let i in registros) {
                    response = await requisicao("POST", "/sisplan/relbloqueto/v1/alterarbanco?", `NUMERO=${encodeURIComponent(registros[i].NUMERO)}&BANCO=${banco}`, null);
                    if (!response) {
                        return;
                    }
                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                }

                toastr.success(`Bancos Alterados com sucesso!`, "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

                $('#modal-alterarBanco').modal('hide')
                await buscaDados(registros)
            } catch (err) {
                console.error(err)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaDuplicatas').on('click', '#btn-alterarDuplicata', async function () {
        $.LoadingOverlay('show')
        try {
            let data = $('#tabelaDuplicatas').DataTable().row($(this).parents("tr")).data()

            $('#modalAlterarDuplicata').modal('show')
            $('#txtDuplicataDup').val(data.NUMERO)
            if (data.NUMERO != '') {
                await preencheDadosAlteraDup(data.NUMERO);
            } else {
                msgAlerta('Ocorreu erro ao buscar os dados da duplicata!')
                return;
            }

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function limpaCamposDup() {
        $('#txtClienteDup').val('')
        $('#txtContaDup').val('')
        $('#txtClasseGerDup').val('')
        $('#txtHistoricoDup').val('')
        $('#txtBancoDup').val('')
        $('#txtSituacaoDup').val('')
        $('#txtEndossoDup').val('')
        $('#txtMoedaDup').val('')
        $('#txtNrBancoDup').val('')
        $('#txtBorderoDup').val('')
        $('#txtCartaoNSUDup').val('')
        $('#txtDescProgramadoDup').val('')
        $('#txtJurosProgramadoDup').val('')
        $('#txtObsDup').val('')
        $('#dtEmissaoDup').val('')
        $('#dtVenctoDup').val('')
        $('#dtVenctoPrevDup').val('')
        $('#cbAlteraNum').prop('checked', false)
    }

    async function preencheDadosAlteraDup(numero) {
        $.LoadingOverlay('show')
        try {
            try {
                let cliente = await buscaParametroERP('VEN', '1130', '19', '1') == 'S'
                let param20 = await buscaParametroERP('VEN', '1130', '20', '1') == 'S'
                let param21 = await buscaParametroERP('VEN', '1130', '21', '1') == 'S'
                let param43 = await buscaParametroERP('VEN', '1130', '43', '1') != 'N'
                let paramFin30 = await buscaParametroERP('FIN', '30', '1', '1') == 'S'

                if ((paramFin30) || await Existe('RECEBERB', ['NUMERO'], [numero])) {
                    cliente = false;
                }

                const pesquisaParam = {
                    tabela: "RECEBER",
                    camposSelect: [
                        "RECEBER.DT_EMISSAO", "RECEBER.DT_VENCTO", "RECEBER.DT_PREVISAO", "RECEBER.CODCLI",
                        "ENTIDADE.NOME", "RECEBER.CONTA_CHEQUE", "CADCONTA.DESCRICAO DESC_CONTA",
                        "RECEBER.CLASSE", "CLASSE_GER.DESCRICAO DESC_CLASSE", "RECEBER.HISTORICO",
                        "HISTCP.DESCRICAO DESC_HIST", "RECEBER.BANCO", "CADBAN.NOME_BANCO", "RECEBER.STATUS",
                        "RECEBER.SITUACAO", "TABSIT.DESCRICAO DESC_SIT", "RECEBER.ENDOSSO", "ENTIDADE.CNPJ",
                        "ENDOSSO.NOME NOME_ENDOSSO", "RECEBER.NRBANCO", "RECEBER.BORDERO",
                        "RECEBER.CARTAO_NSU", "RECEBER.MOEDA", "MOEDA.DESCRICAO DESC_MOEDA",
                        "RECEBER.OBS", "RECEBER.JUROS_PROGRAMADO", "RECEBER.DESC_PROGRAMADO"
                    ],
                    leftJoin: [
                        { tabela: 'ENTIDADE', condicao: 'RECEBER.CODCLI = ENTIDADE.CODCLI ' },
                        { tabela: 'CADBAN', condicao: 'CADBAN.BANCO = RECEBER.BANCO ' },
                        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = RECEBER.CLASSE ' },
                        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = RECEBER.HISTORICO ' },
                        { tabela: 'TABSIT', condicao: 'TABSIT.CODIGO = RECEBER.SITUACAO ' },
                        { tabela: 'CADCONTA', condicao: 'CADCONTA.CONTA = RECEBER.CONTA_CHEQUE' },
                        { tabela: 'ENTIDADE', alias: 'ENDOSSO', condicao: 'ENDOSSO.CODCLI = RECEBER.ENDOSSO' },
                        { tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = RECEBER.MOEDA' },
                    ],
                    where: [`RECEBER.NUMERO = '${numero}'`],
                };

                let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                limpaCamposDup();
                if (jsonStr.length > 0) {
                    insereValor('#txtClienteDup', jsonStr[0].CODCLI, jsonStr[0].NOME)
                    insereValor('#txtContaDup', jsonStr[0].CONTA_CHEQUE, jsonStr[0].DESC_CONTA)
                    insereValor('#txtClasseGerDup', jsonStr[0].CLASSE, jsonStr[0].DESC_CLASSE)
                    insereValor('#txtHistoricoDup', jsonStr[0].HISTORICO, jsonStr[0].DESC_HIST)
                    insereValor('#txtBancoDup', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO)
                    insereValor('#txtSituacaoDup', jsonStr[0].SITUACAO, jsonStr[0].DESC_SIT)
                    insereValor('#txtEndossoDup', jsonStr[0].ENDOSSO, jsonStr[0].NOME_ENDOSSO)
                    insereValor('#txtMoedaDup', jsonStr[0].MOEDA, jsonStr[0].DESC_MOEDA)
                    $('#txtNrBancoDup').val(jsonStr[0].NRBANCO)
                    $('#txtBorderoDup').val(jsonStr[0].BORDERO)
                    $('#txtCartaoNSUDup').val(jsonStr[0].CARTAO_NSU)
                    $('#txtDescProgramadoDup').val(jsonStr[0].DESC_PROGRAMADO)
                    $('#txtJurosProgramadoDup').val(jsonStr[0].JUROS_PROGRAMADO)
                    $('#txtObsDup').val(jsonStr[0].OBS)
                    $('#dtEmissaoDup').val(jsonStr[0].DT_EMISSAO.split(' ', -1)[0])
                    $('#dtVenctoDup').val(jsonStr[0].DT_VENCTO.split(' ', -1)[0])
                    $('#dtVenctoPrevDup').val(jsonStr[0].DT_PREVISAO.split(' ', -1)[0])

                    let emp_cnpj = await buscaValor('EMPRESA', 'EMP_CNPJ', 'EMP_ID', getCookie('emp_id'))
                    if ((emp_cnpj == jsonStr[0].CNPJ) && (jsonStr[0].STATUS == 'ANTE')) {
                        cliente = false;
                    }
                    cliente ? $('#panelCliente').removeClass('d-none') : $('#panelCliente').addClass('d-none')
                    param20 ? $('#panelConta').removeClass('d-none') : $('#panelConta').addClass('d-none')
                    param21 ? $('#panelVenctoPrev').removeClass('d-none') : $('#panelVenctoPrev').addClass('d-none')
                    if (param43) {
                        $('#panelEmissaoVencto').removeClass('d-none')
                        $('#panelEndosso').removeClass('d-none')
                        $('#panelNrBanco').removeClass('d-none')
                        $('#panelCartaoNSU').removeClass('d-none')
                        $('#panelBordero').removeClass('d-none')
                        $('#panelMoeda').removeClass('d-none')
                        $('#panelObs').removeClass('d-none')
                        $('#panelDescProgramado').removeClass('d-none')
                        $('#panelJurosProgramado').removeClass('d-none')
                        $('#panelAlteraNum').removeClass('d-none')
                        $('#panelObs').removeClass('d-none')
                    } else {
                        $('#panelEmissaoVencto').addClass('d-none')
                        $('#panelEndosso').addClass('d-none')
                        $('#panelNrBanco').addClass('d-none')
                        $('#panelCartaoNSU').addClass('d-none')
                        $('#panelBordero').addClass('d-none')
                        $('#panelMoeda').addClass('d-none')
                        $('#panelObs').addClass('d-none')
                        $('#panelDescProgramado').addClass('d-none')
                        $('#panelJurosProgramado').addClass('d-none')
                        $('#panelAlteraNum').addClass('d-none')
                        $('#panelObs').addClass('d-none')
                    }

                    nrBancoOriginal = jsonStr[0].NRBANCO
                    vencimentoOrigDup = $('#dtVenctoDup').val();
                }
            } catch (err) {
                console.error(err)
            }

        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnGravarDuplicata').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            let vencimento = $('#dtVenctoDup').val()
            let emissao = $('#dtEmissaoDup').val()

            let partesVencimento = vencimento.split('-');
            let anoVencimento = parseInt(partesVencimento[0], 10);
            let mesVencimento = parseInt(partesVencimento[1], 10);
            let diaVencimento = parseInt(partesVencimento[2], 10);

            let partesEmissao = emissao.split('-');
            let anoEmissao = parseInt(partesEmissao[0], 10);
            let mesEmissao = parseInt(partesEmissao[1], 10);
            let diaEmissao = parseInt(partesEmissao[2], 10);

            if (anoEmissao > anoVencimento || (anoEmissao === anoVencimento && mesEmissao > mesVencimento) || (anoEmissao === anoVencimento && mesEmissao === mesVencimento && diaEmissao > diaVencimento)) {
                msgAlerta('Data de vencimento não pode ser menor que data de emissão. Por favor verifique.');
                return;
            }

            if (!$('#panelCliente').hasClass('d-none') && $('#txtClienteDup').val() == '') {
                msgAlerta('Cliente não informado. Por favor verifique.')
                return;
            }

            if (await validaDescJurosBaixa($('#txtDuplicataDup').val()) && $('#txtDescProgramadoDup').val() > 0) {
                msgAlerta('Não é possível Alterar desconto programado quando ja existem baixas.')
                return;
            }

            if (await validaDescJurosBaixa($('#txtDuplicataDup').val(), false) && $('#txtJurosProgramadoDup').val() > 0) {
                msgAlerta('Não é possível Alterar juros programado quando ja existem baixas.')
                return;
            }

            if ((buscaValor('RECEBER', 'BORDERO', 'NUMERO', $('#txtDuplicataDup').val())) && (vencimentoOrigDup != $('#dtVenctoDup').val())) {
                msgAlerta('Duplicata já enviada ao banco, gravar instrução de mudança de vencimento?', async () => {
                    alterouVenctoDup = true;
                })
            }

            if (nrBancoOriginal != $('#txtNrBancoDup').val()) {
                msgAlerta(`Nr.Banco informado Diferente do Original. Original: ${nrBancoOriginal} informado: ${$('#txtNrBancoDup').val()}. Deseja continuar?`, async () => {
                    msgAlerta(`Deseja Realmente Gravar os Dados?`, async () => {
                        await gravaDadosDuplicata()
                    }, async () => { return })
                }, async () => { return })
            } else {
                msgAlerta(`Deseja Realmente Gravar os Dados?`, async () => {
                    await gravaDadosDuplicata()
                }, async () => { return })
            }

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function retornaValoresDup() {
        let obs = ''
        numero = $('#txtDuplicataDup').val()
        emissao = !$('#panelEmissaoVencto').hasClass('d-none') ? formataDataBonita($('#dtEmissaoDup').val()) + ' 00:00:00.000' : ''
        vencto = !$('#panelEmissaoVencto').hasClass('d-none') ? formataDataBonita($('#dtVenctoDup').val()) + ' 00:00:00.000' : ''
        venctoprev = !$('#panelVenctoPrev').hasClass('d-none') ? formataDataBonita($('#dtVenctoPrevDup').val()) + ' 00:00:00.000' : ''
        cliente = !$('#panelCliente').hasClass('d-none') ? pegaChave('#txtClienteDup') : ''
        conta = !$('#panelConta').hasClass('d-none') ? pegaChave('#txtContaDup') : ''
        endosso = !$('#panelEndosso').hasClass('d-none') ? pegaChave('#txtEndossoDup') : ''
        moeda = !$('#panelMoeda').hasClass('d-none') ? pegaChave('#txtMoedaDup') : ''
        nrbanco = !$('#panelNrBanco').hasClass('d-none') ? $('#txtNrBancoDup').val() : ''
        bordero = !$('#panelBordero').hasClass('d-none') ? $('#txtBorderoDup').val() : ''
        cartaonsu = !$('#panelCartaoNSU').hasClass('d-none') ? $('#txtCartaoNSUDup').val() : ''
        descprogramado = !$('#panelDescProgramado').hasClass('d-none') ? $('#txtDescProgramadoDup').val() : ''
        jurosprogramado = !$('#panelJurosProgramado').hasClass('d-none') ? $('#txtJurosProgramadoDup').val() : ''
        classe = pegaChave('#txtClasseGerDup')
        historico = pegaChave('#txtHistoricoDup')
        banco = pegaChave('#txtBancoDup')
        situacao = pegaChave('#txtSituacaoDup')
        alterouvencimento = alterouVenctoDup ? 'S' : 'N'
        alteransu = !$('#panelAlteraNum').hasClass('d-none') ? $('#cbAlteraNum').is(':checked') ? 'S' : 'N' : ''

        if ($('#cbObsDup').is(':checked')) {
            obs = await buscaValor('RECEBER', 'OBS', 'NUMERO', JSON.parse(localStorage.getItem('registros').NUMERO))
        } else {
            obs = $('#txtObs').val()
        }

        return `NUMERO=${numero}` +
            `&EMISSAO=${emissao}` +
            `&VENCTO=${vencto}` +
            `&VENCTOPREV=${venctoprev}` +
            `&CLIENTE=${cliente}` +
            `&CONTA=${conta}` +
            `&ENDOSSO=${endosso}` +
            `&MOEDA=${moeda}` +
            `&NRBANCO=${nrbanco}` +
            `&BORDERO=${bordero}` +
            `&CARTAONSU=${cartaonsu}` +
            `&DESCPROGRAMADO=${descprogramado}` +
            `&JUROSPROGRAMADO=${jurosprogramado}` +
            `&OBS=${obs}` +
            `&CLASSE=${classe}` +
            `&HISTORICO=${historico}` +
            `&BANCO=${banco}` +
            `&SITUACAO=${situacao}` +
            `&ALTEROUVENCIMENTO=${alterouvencimento}` +
            `&ALTERANSU=${alteransu}`;
    }

    async function gravaDadosDuplicata() {
        try {
            let valores = await retornaValoresDup();
            let response = await requisicao("POST", "/sisplan/relbloqueto/v1/alterarduplicata?", valores, null);
            if (!response) {
                return;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success(`Duplicata Alterada com sucesso!`, "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    data.remove().draw(false);
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

            $('#modalAlterarDuplicata').modal('hide')
            let registros = JSON.parse(localStorage.getItem('registros'));
            await buscaDados(registros)
        } catch (err) {
            console.error(err)
        }
    }

    $('#modalAlterarDuplicata').on('shown.bs.modal', async function () {
        $('#txtContaDup').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
        $('#txtClienteDup').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}`);
        $('#txtClasseGerDup').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#txtHistoricoDup').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#txtBancoDup').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO" ], "where": null}`);
        $('#txtSituacaoDup').autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#txtMoedaDup').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
        $('#txtEndossoDup').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}`);

        $('#btn-ContaDup').pesquisa_serverside(['#txtContaDup'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
        $('#btn-ClienteDup').pesquisa_serverside(['#txtClienteDup'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Cliente');
        $('#btn-ClasseGerDup').pesquisa_serverside(['#txtClasseGerDup'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Classe Gerencial');
        $('#btn-HistoricoDup').pesquisa_serverside(['#txtHistoricoDup'], ['HISTORICO'], ['DESCRICAO'], `{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Histórico');
        $('#btn-BancoDup').pesquisa_serverside(['#txtBancoDup'], ['BANCO'], ['NOME_BANCO'], `{ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO" ], "where": null}`, 'Pesquisa de Banco');
        $('#btn-SituacaoDup').pesquisa_serverside(['#txtSituacaoDup'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Situação');
        $('#btn-MoedaDup').pesquisa_serverside(['#txtMoedaDup'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
        $('#btn-EndossoDup').pesquisa_serverside(['#txtEndossoDup'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Endosso');

        $('#btn-limpa-ContaDup').on('click', function () { $('#txtContaDup').val('') })
        $('#btn-limpa-ClienteDup').on('click', function () { $('#txtClienteDup').val('') })
        $('#btn-limpa-ClasseGerDup').on('click', function () { $('#txtClasseGerDup').val('') })
        $('#btn-limpa-HistoricoDup').on('click', function () { $('#txtHistoricoDup').val('') })
        $('#btn-limpa-BancoDup').on('click', function () { $('#txtBancoDup').val('') })
        $('#btn-limpa-SituacaoDup').on('click', function () { $('#txtSituacaoDup').val('') })
        $('#btn-limpa-MoedaDup').on('click', function () { $('#txtMoedaDup').val('') })
        $('#btn-limpa-EndossoDup').on('click', function () { $('#txtEndossoDup').val('') })


        $('#txtDescProgramadoDup').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });

        $('#txtJurosProgramadoDup').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
    })

    async function validaDescJurosBaixa(numero, desc = true) {
        try {
            let pesquisaParam
            let jsonStr
            let result = false
            if (desc) {
                pesquisaParam = {
                    tabela: "RECEBERB",
                    camposSelect: [
                        "DESCONTO",
                    ],
                    where: [`NUMERO = '${numero} AND DESCONTO > 0'`],
                };

                jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    result = true;
                }
            } else {
                pesquisaParam = {
                    tabela: "RECEBERB",
                    camposSelect: [
                        "JUROS",
                    ],
                    where: [`NUMERO = '${numero} AND JUROS > 0'`],
                };

                jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    result = true;
                }
            }

            return result
        } catch (err) {
            console.error(err)
        }
    }

    $('#tabelaDuplicatas').on('click', '#btn-alterarContas', function () {
        $.LoadingOverlay('show')
        try {
            let nrbancoPreenchido = false;

            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                let item = this.data();
                if (item.NRBANCO) {
                    nrbancoPreenchido = true;
                }
            })

            if (nrbancoPreenchido) {
                msgAlerta('Duplicata com Nosso Numero gerado. Impossível Continuar!')
                return;
            }

            $('#modal-alterarContas').modal('show')
            $('#txtContaDup').val('')
            $('#txtAlterarConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CADCONTA.CONTA CHAVE", "CADCONTA.DESCRICAO DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = ${getCookie('emp_id')})" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`);
            $('#btnAlterarConta').pesquisa_serverside(['#txtAlterarConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "innerjoin": [{ "tabela": "EMP_VALOR", "condicao": "(EMP_VALOR.TABELA = 'CADCONTA' AND EMP_VALOR.CAMPO = 'CODIGO' AND EMP_VALOR.VALOR = CADCONTA.CODIGO AND EMP_VALOR.EMP_ID = '${getCookie('emp_id')}')" }], "where": ["((ATIVO <> 'N') OR (ATIVO IS NULL ))"]}`, 'Pesquisa de Conta');
            $('#btn-limpa-ContaDup').on('click', function () { $('#txtContaDup').val('') })
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnGravarConta').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                let conta = pegaChave('#txtAlterarConta')
                if (conta == '') {
                    msgAlerta('Conta não informada!')
                    return;
                }
                let registros = JSON.parse(localStorage.getItem('registros'));
                let response;
                for (let i in registros) {
                    response = await requisicao("POST", "/sisplan/relbloqueto/v1/alterarconta?", `NUMERO=${encodeURIComponent(registros[i].NUMERO)}&CONTA=${conta}`, null);
                    if (!response) {
                        return;
                    }
                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                }

                toastr.success(`Contas Alteradas com sucesso!`, "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

                $('#modal-alterarContas').modal('hide')
                await buscaDados(registros)
            } catch (err) {
                console.error(err)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaDuplicatas').on('click', '#btn-gerarBordero', function () {
        parent.document.querySelector('#menu_escenvio .nav-link').click();
    })

    retornaHintRelatorio('btnImprimir', 'WFatBol + NUMERO DO BANCO')

    if (bloqueto == 'create') {
        let registros = JSON.parse(localStorage.getItem('registros'));
        await buscaDados(registros)
        const conta = await buscaValor('RECEBER', 'CONTA_CHEQUE', 'NUMERO', registros[0].NUMERO)
        insereValor('#txtConta', conta.CONTA_CHEQUE, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: conta.CONTA_CHEQUE });
        $('#txtConta').focus()

        setTimeout(() => {
            $('#txtConta').trigger('blur')
        }, 100)
    }

    $('#btnAcrescimo').on('click', async function () {
        if (($('#txtAcrescimo').val() != '') && ($('#txtAcrescimo').val() > 0)) {
            if ($('#tabelaDuplicatas').DataTable().data().length > 0) {
                msgAlerta('Você realmente deseja lançar acrescimo no receber?', async () => {
                    $.LoadingOverlay('show')
                    try {
                        try {
                            dataSetCols = [];
                            const url = "/sisplan/relbloqueto/v1/adicionaacrescimo?";
                            let numeros = []
                            let faturas = []
                            let registros = JSON.parse(localStorage.getItem('registros'));
                            let acrescimo = $('#txtAcrescimo').val();
                            for (let i = 0; i < registros.length; i++) {
                                numeros.push(registros[i].NUMERO)
                                faturas.push(registros[i].FATURA)

                            }
                            numeros = await formataListas(numeros.toString())
                            faturas = await formataListas(faturas.toString())
                            let response = await requisicao("POST", url, `NUMEROS=${numeros}&FATURAS=${faturas}&ACRESCIMO=${acrescimo}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                            if (!response) {
                                return;
                            }
                            if (response.status != 200) {
                                let jsonStr = await response.json();
                                msgErro(jsonStr.mensagem);
                                return;
                            }

                            toastr.success("Alteração efetuada com sucesso!", "Confirmação", {
                                toastClass: "success",
                                iconClasses: {
                                    error: "alert-error",
                                    info: "alert-info",
                                    success: "alert-success",
                                    warning: "alert-warning",
                                },
                                positionClass: "toast-top-center",
                                progressBar: true,
                                timeOut: 3000,
                                fadeOut: 1000,
                                onHidden() {
                                    data.remove().draw(false);
                                },
                            }).css({
                                "margin-top": "20%",
                                width: "500px",
                                "max-width": "500px",
                            });

                            $('#txtAcrescimo').val('');

                            await buscaDados(registros)
                        } catch {
                            console.error(err);
                            msgErro(`Não foi possível aplicar o acrescimo no receber!`);
                        }
                    } finally {
                        $.LoadingOverlay('hide')
                    }
                });
            }
        }
    })

    async function preencheDadosBanco(conta, carteira, padraoBoleto) {
        const pesquisaParam = {
            tabela: "CADCONTA",
            camposSelect: [
                "CADCONTA.CONTA",
                "CADCONTA.AGENCIA",
                "CADCONTA.BANCO",
                "CARTEIRA.GERA_NOSSO",
                "CARTEIRA.TAXA1",
                "CARTEIRA.TAXA2",
                "CARTEIRA.IMP_COBREBEM",
                "CARTEIRA.CARTEIRA",
                "CARTEIRA.ACEITE",
                "CARTEIRA.DESCRICAO2",
                "CARTEIRA.DESCRICAO3",
                "CADCONTA.AVALISTA",
                "CARTEIRA.DIASPROTESTO",
                "CARTEIRA.COD_PRACA_SACADO",
                "CARTEIRA.CONVENIO",
                "CARTEIRA.NR_BANCO AS SEQNRBANCO",
                "CARTEIRA.TIPO",
                "CARTEIRA.CEB",
                "CARTEIRA.LOCAL_PAGTO",
                "CARTEIRA.DESCRICAO2 as INSTRUCAO_1",
                "CARTEIRA.DESCRICAO3 AS INSTRUCAO_2",
                "CARTEIRA.PADRAO_INSTR_1",
                "CARTEIRA.PADRAO_INSTR_2",
                "CARTEIRA.INSTRUCAO_1 AS DADOS_1",
                "CARTEIRA.INSTRUCAO_2 AS DADOS_2",
                "CADCONTA.USA_AVALISTA_EMPTAB AS AVALISTA_EMP",
                "CADCONTA.AG_COOPERADO AGCOOPERADO",
                "CARTEIRA.IMP_BOLETO",
                "CARTEIRA.PADRAO_BOLETO",
                "CADCONTA.FDIC",
                "CADCONTA.CONTA_PAGADOR",
                "CARTEIRA.TIPO_DIAS_PROT",
                "CARTEIRA.TIPO_LAYOUT LAYOUT"
            ],
            leftJoin: [
                { tabela: 'CARTEIRA', condicao: 'CADCONTA.CONTA = CARTEIRA.CONTA' },
            ],
            where: [`CADCONTA.CONTA = '${conta}'` +
                `${carteira != '' && carteira != null ? `AND CARTEIRA.CARTEIRA = '${carteira}'` : ''}` +
                `${padraoBoleto ? `AND CARTEIRA.PADRAO_BOLETO = 'S'` : ''}`],
        };

        let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        return jsonStr;
    }

    async function buscaDadosBanco() {
        $.LoadingOverlay('show')
        try {
            let conta = pegaChave('#txtConta');
            let carteira = $('#rgCarteira').val();
            let consulta = await preencheDadosBanco(conta, carteira, true);

            if (consulta.length <= 0) {
                consulta = await preencheDadosBanco(conta, carteira, false);
            }

            let retorno = consulta[0]

            if (!retorno) {
                msgAlerta('Ocorreu um erro ao buscar os dados do banco!')
                return
            }

            await preencheConta(conta)

            let nomeBanco = await buscaValor('CADBAN', 'NOME_BANCO', 'BANCO', retorno.BANCO)
            $('#txtBanco').val(`[${retorno.BANCO}] - ${nomeBanco.NOME_BANCO}`)

            $('#txtInstrucao1').val(retorno.INSTRUCAO_1)
            $('#txtInstrucao2').val() == '' ? $('#txtInstrucao2').val(retorno.INSTRUCAO_2) : $('#txtInstrucao2').val()
            // if (retorno.IMP_COBREBEM == 'N') {
            //     $('#rgLayout').val('0')
            // } else {
            //     $('#rgLayout').val('1')
            // }

            if (retorno.LAYOUT == 'Pré-Impresso') {
                $('#rgLayout').val(0);
            } else if (retorno.LAYOUT == 'Padrão') {
                $('#rgLayout').val(1);
            } else if (retorno.LAYOUT == 'Personalizado') {
                $('#rgLayout').val(2);
            } else if (retorno.LAYOUT == 'Dois Boletos') {
                $('#rgLayout').val(3);
            } else {
                $('#rgLayout').val(0);
            };

            $('#rgLayout').trigger('change')
            $('#txtProtestar').val(retorno.DIASPROTESTO)

            $('#cbFdic').prop('checked', retorno.FDIC == 'S')
            $('#txtContaPagador').val(retorno.CONTA_PAGADOR)

            if (retorno.TIPO_DIAS_PROT == 'U') {
                $($('#cbModoDiasUteis').parents()[0]).removeClass('d-none')
                $('#cbModoDiasUteis').prop('checked', true)
            }


            if (retorno.GERA_NOSSO == 'S') {
                $('#cbNossoNumero').prop('checked', true)
                $('#cbNossoNumero').prop('disabled', true)
                $('#cbNossoNumero').prop('checked', true)
            }
            $('#txtLocalPagamento').val() == '' ? $('#txtLocalPagamento').val(retorno.LOCAL_PAGTO) : $('#txtLocalPagamento').val()

            if (!alterouTaxa) {
                $('#txtTaxaAcrescimo').val(retorno.TAXA1)
            }

            if (!alterouMulta) {
                $('#txtMultaAtraso').val(retorno.TAXA2)
            }

            calculaDiasProtesto(retorno.TIPO_DIAS_PROT == 'U')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function preencheConta(conta) {
        try {
            let optionExiste = false;
            const pesquisaParam = {
                tabela: "CARTEIRA",
                camposSelect: ["CARTEIRA"],
                where: [`CONTA = '${conta}'`],
            };

            let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            for (let i = 0; i < jsonStr.length; i++) {
                let retorno = jsonStr[i]

                $('#rgCarteira option').each(function () {
                    if ($(this).val() == retorno.CARTEIRA) {
                        optionExiste = true
                        return false;
                    }
                })

                if (!optionExiste) {
                    let novaOption = $("<option></option>").attr("value", retorno.CARTEIRA).text(retorno.CARTEIRA);
                    $('#rgCarteira').append(novaOption)
                }
            }

        } catch (error) {
            console.error(error)
        }
    }

    $('#rgCarteira').on('change', async function () {
        if ($('#txtConta').val() != '') {
            await buscaDadosBanco()
        }
    })

    async function diaUtil(dia) {
        let data = new Date(dia)
        let diaDaSemana = data.getDay();
        let diaUtil = diaDaSemana >= 1 && diaDaSemana <= 5;

        const pesquisaParam = {
            tabela: "ANO",
            camposSelect: ["DIA_UTIL"],
            where: [`DATA = '${formataData(data)}' AND DIA_UTIL = 'N'`],
        };

        let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        return (jsonStr.length == 0 && diaUtil);
    }

    $('#txtTaxaAcrescimo').on('blur', function () {
        if ($('#txtTaxaAcrescimo').val() != '' && $('#txtTaxaAcrescimo').val() != 0) {
            alterouTaxa = true;
        }
    })

    $('#txtMultaAtraso').on('blur', function () {
        if ($('#txtMultaAtraso').val() != '' && $('#txtMultaAtraso').val() != 0) {
            alterouMulta = true;
        }
    })

    async function calculaDiasProtesto(isDiaUtil) {
        if (isDiaUtil) {
            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                let dtVencimento = this.data()["DT_VENCTO"];
                let diasProtesto = 0;
                let vDias = parseInt($('#txtProtestar').val()) || 0;

                for (let i = 1; i <= vDias; i++) {
                    if (!diaUtil(dtVencimento)) {
                        diasProtesto++;
                    }
                }

                let novoValor = vDias + diasProtesto;

                this.data()["DIAS_PROTESTO"] = novoValor;
                this.invalidate();
            });

            $('#tabelaDuplicatas').DataTable().draw();
        } else {
            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                let vDias = parseInt($('#txtProtestar').val()) || 0;

                let novoValor = this.data()["DIAS_PROTESTO"] + vDias;

                this.data()["DIAS_PROTESTO"] = novoValor;
                this.invalidate();
            })

            $('#tabelaDuplicatas').DataTable().draw();
        }

    }

    $('#txtConta').on('blur', async function () {
        if ($('#txtConta').val() != '') {
            await buscaDadosBanco()
        }
    })

    $('#btnVoltarDup').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const data = $("#tabelaDuplicatas tr.selected");
            if (data.length > 0) {
                const array = JSON.parse(localStorage.getItem('registros'))
                let selectedRow = $("#tabelaDuplicatas ").DataTable().row(data).data();
                let registro = array.find(function (e) {
                    return (e.FATURA == selectedRow.FATURA) && (e.NUMERO == selectedRow.NUMERO) && (e.BORDERO == selectedRow.BORDERO) && (e.CODCLI == selectedRow.CODCLI);
                });
                let arrayFiltrado = array.filter(function (e) {
                    return e.FATURA != registro.FATURA || e.NUMERO != registro.NUMERO || e.BORDERO != registro.BORDERO || e.CODCLI != registro.CODCLI;
                });

                localStorage.removeItem('registros');
                localStorage.setItem('registros', JSON.stringify(arrayFiltrado))

                $("#tabelaDuplicatas").DataTable().row(data).remove().draw();
            } else {
                msgAlerta('Nenhuma duplicata selecionada!');
            }

            if ($('#tabelaDuplicatas').DataTable().data().length <= 0) {
                $('#btnVoltar').trigger('click')
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnVoltarTodas').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            localStorage.removeItem('registros');
            $("#tabelaDuplicatas").DataTable().rows().remove().draw();
            $('#btnVoltar').trigger('click')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtObs').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#txtObs').val() == '') {
                return
            }
            let novoValor = $('#txtObs').val();
            let dadosSalvos = [];

            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                this.data()["OBS"] = novoValor;
                this.data()["OBS_ORIG"] = novoValor;
                dadosSalvos.push(this.data())
            })

            $("#tabelaDuplicatas").DataTable().rows().remove().draw()

            dadosSalvos.forEach(function (row) {
                $('#tabelaDuplicatas').DataTable().row.add(row);
            });

            $('#tabelaDuplicatas').DataTable().draw();

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#rgLayout').on('change', function () {
        if ($('#rgLayout').val() == 0) {
            $('#cbLayoutGrafico').prop('disabled', false)
            $('#cbLayoutGrafico').prop('checked', true)
        } else {
            $('#cbLayoutGrafico').prop('disabled', true)
            $('#cbLayoutGrafico').prop('checked', false)
        }
    })

    $('#btnRecalcular').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if ($('#cbAtualizarVencimento').is(':checked')) {
                let dataAtual = new Date();
                let novaData = $('#dtNovoVencimento').val()

                let anoAtual = dataAtual.getFullYear();
                let mesAtual = dataAtual.getMonth() + 1;
                let diaAtual = dataAtual.getDate();

                let partesNovaData = novaData.split('-');
                let anoNovaData = parseInt(partesNovaData[0], 10);
                let mesNovaData = parseInt(partesNovaData[1], 10);
                let diaNovaData = parseInt(partesNovaData[2], 10);

                if (anoNovaData < anoAtual || (anoNovaData === anoAtual && mesNovaData < mesAtual) || (anoNovaData === anoAtual && mesNovaData === mesAtual && diaNovaData < diaAtual)) {
                    msgAlerta('Atenção, nova data de vencimento informada é menor que a data de hoje. Impossível continuar!');
                    return;
                }

                let partesNovaDataValidacao = novaData.split('-');
                let anoNovaDataValidacao = parseInt(partesNovaDataValidacao[0], 10);
                let mesNovaDataValidacao = parseInt(partesNovaDataValidacao[1], 10) - 1;
                let diaNovaDataValidacao = parseInt(partesNovaDataValidacao[2], 10);

                let dataAtualObj = new Date(dataAtual.getFullYear(), dataAtual.getMonth(), dataAtual.getDate());
                let novaDataObj = new Date(anoNovaDataValidacao, mesNovaDataValidacao, diaNovaDataValidacao);

                let diferencaEmMilissegundos = novaDataObj.getTime() - dataAtualObj.getTime();

                let diferencaEmDias = diferencaEmMilissegundos / (1000 * 60 * 60 * 24);

                if (diferencaEmDias > 60) {
                    msgAlerta('Atenção, a nova data de vencimento informada é maior que 60 dias a partir de hoje.');
                    return;
                }
            }

            $('#tabelaDuplicatas').DataTable().rows().every(async function () {
                let item = this.data();
                let dtNovoVencto = $('#dtNovoVencimento').val();

                item.PERC_JUROS_DIA_ATRASO = (await buscaParametroERP('FIN', '540', '3', '1') == 'S' ? 0 : item.TAXA) + $('#txtTaxaAcrescimo').val() / 30;
                item.VALOR_JUROS_DIA_ATRASO = (item.PERC_JUROS_DIA_ATRASO / 100) * item.VALOR_DUP;
                item.MULTA_ATRASO = ($('#txtMultaAtraso').val() / 100) * item.VALOR_DUP;

                let sData;
                if ($('#cbAtualizarVencimento').is(':checked') && new Date(item.DT_VENCTO) < new Date(dtNovoVencto)) {
                    sData = dtNovoVencto
                } else {
                    sData = item.DT_VENCTO;
                }

                item.VALOR_CALC_DIA_ATRASO = item.VALOR_JUROS_DIA_ATRASO * (new Date(sData) - new Date(item.DT_VENCTO));

                if ($('#cbAtualizaValor').is(':checked')) {
                    if (new Date(item.DT_VENCTO) <= new Date(dtNovoVencto) || $('#cbCalcular').is(':checked')) {
                        item.VALOR = parseFloat((item.VALOR_DUP + item.MULTA_ATRASO + item.VALOR_CALC_DIA_ATRASO).toFixed(2));
                    }

                    if (item.OBS != '') {
                        item.OBS = item.OBS_ORIG + ' - Data Original = ' + item.DT_VENCTO_ORIG + ' - Valor Original = ' + item.VALOR_DUP;
                    } else {
                        item.OBS = 'Data Original.: ' + item.DT_VENCTO_ORIG + ' - Valor Original.: ' + item.VALOR_DUP;
                    }
                }

                if ($('#cbAtualizarVencimento').is(':checked') && new Date(item.DT_VENCTO) < new Date(dtNovoVencto)) {
                    item.DT_VENCTO = dtNovoVencto
                }

                this.data(item);
                this.invalidate();
            });

            $('#tabelaDuplicatas').DataTable().draw();

        } finally {
            $.LoadingOverlay('hide')
        }

    })

    $('#btnBuscarInf').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            let bordero = $('#tabelaDuplicatas').DataTable().row(0).data().BORDERO;
            let borderoIguais = true;
            let optionExiste = false;

            $('#tabelaDuplicatas').DataTable().rows().every(function () {
                let item = this.data();
                if (item.BORDERO != bordero) {
                    borderoIguais = false;
                }
                bordero = item.BORDERO
            })

            if (borderoIguais) {
                if (!await Existe('BORDERO', ['NUMERO'], [bordero])) {
                    msgAlerta('Bordero não existe. Impossível carregar dados.');
                    return;
                } else {
                    let conta = await buscaValor('BORDERO', 'CONTA', 'NUMERO', bordero);
                    let descConta = await buscaValor('CADCONTA', 'DESCRICAO', 'CONTA', conta.CONTA);
                    insereValor('#txtConta', conta.CONTA, descConta.DESCRICAO);

                    await preencheConta(conta.CONTA)

                    $('#txtConta').focus()
                }
            } else {
                msgAlerta('Impossível carregar informações, Existem Borderos diferentes selecionados!');
                return;
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function imprimirBoleto(numero) {
        const url = `/sisplan/relbloqueto/v1/imprimirboleto?NUMERO=${numero}`;
        try {
            $.LoadingOverlay("show");
            try {
                const bImprimeAutomatico = await verificaImprimirAutomatico('BoletoRelBloqueto');
                const arquivo = await GeraRelatorio(url + '&', 'GET', 1000000, false, 'BoletoRelBloqueto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/` + arquivo, '_blank');
                    }
                    await limparRelatorios();
                }
                let registros = JSON.parse(localStorage.getItem('registros'));
                await buscaDados(registros)
            } catch (err) {
                console.error(err);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    $('#btnImprimir').on('click', async function () {
        if (await CopiaParametro('ESCRITURAL', 6) == '1') {
            await msgAlerta('Deseja gravar o borderô?', async () => {
                await iniciaRotinaGravaBordero();
                await chamaImpressao();
            })
        } else {
            await chamaImpressao();
        }
    });

    async function chamaImpressao() {
        let numeros = []

        $('#tabelaDuplicatas').DataTable().rows().every(async function () {
            let item = this.data()

            numeros.push(item.NUMERO)
        })

        for (let i = 0; i < numeros.length; i++) {
            await imprimirBoleto(numeros[i])
        }

        $('#btnVoltar').trigger('click');
    }
});