$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });

    driver.defineSteps([
      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão filtros',
          description: 'Clique aqui para abrir a aba de filtros.',
          position: 'right'
        }
      },
      {
        element: '#btnAtualizarListaNFe',
        popover: {
          title: 'Botão Atualizar',
          description: 'Clique aqui para atualizar a lista de NF-e.',
          position: 'right'
        }
      },
      {
        element: '#btnDownloadXml',
        popover: {
          title: 'Botão Download',
          description: 'Clique aqui para fazer o download das notas selecionadas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await setarDataAtual('txtDtEmissaoI', true);
  await setarDataAtual('txtDtEmissaoF');

  const languageDataTable = {
    sEmptyTable: "Nenhum registro encontrado",
    sInfo: "_TOTAL_ registros",
    sInfoEmpty: " 0 registros",
    sInfoFiltered: "(Filtrados de _MAX_ registros)",
    sInfoPostFix: "",
    sInfoThousands: ".",
    language: {
      decimal: ",",
      thousands: ".",
    },
    sLengthMenu: "_MENU_ resultados",
    sLoadingRecords: "Carregando...",
    sProcessing: "Processando...",
    sZeroRecords: "Nenhum registro encontrado",
    sSearch: "Pesquisar",
    oPaginate: {
      sNext: "Próximo",
      sPrevious: "Anterior",
      sFirst: "Primeiro",
      sLast: "Último",
    },
    oAria: {
      sSortAscending: ": Ordenar colunas de forma ascendente",
      sSortDescending: ": Ordenar colunas de forma descendente",
    },
  };

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaNotas();
  });

  $('#btnAtualizarListaNFe').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const response = await requisicao('GET', '/sisplan/radarnfe/v1/atualizarnotas?', '', '', 30000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

    } finally {
      $.LoadingOverlay('hide');
      if ($.fn.DataTable.isDataTable("#tabelaNFe")) {
        await consultaNotas();
      }
    }
  });

  async function consultaNotas() {
    try {
      $.LoadingOverlay('show');

      const pFiltros = {
        FORNECEDORES: pegaChave('#txtFornecedor'),
        DTEMIINI: pegaValor('#txtDtEmissaoI'),
        DTEMIFIM: pegaValor('#txtDtEmissaoF'),
        TIPO: pegaValor('input[name="tp_manifestacao"]:checked'),
        ARQUIVOXML: pegaValor('input[name="arq_xml"]:checked'),
        NUMERONFE: pegaValor('#txtNumeroNFe'),
        SERIENFE: pegaValor('#txtSerieNFe'),
        COMPRAS: pegaValor('input[name="lanc_compras"]:checked'),
      }

      const response = await requisicao('POST', '/sisplan/radarnfe/v1/consultarnotas?', '', JSON.stringify(pFiltros), 30000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        return;
      }

      if (!jsonStr.notas) {
        msgAlerta('Nenhuma nota encontrada com os filtros feitos, favor verificar.');
        return;
      }

      preencheTabelaNotas(jsonStr);

    } catch (error) {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
      msgAlerta(error);
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  };

  function preencheTabelaNotas(jsonStr) {
    let dataSetCols = [];

    let keys = Object.keys(jsonStr.notas[0]);
    dataSetCols.push({
      'title': 'SEL',
      'data': 'SEL',
      'width': '15px'
    });


    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    }

    // criaDataTablePadrao('#tabelaNFe', false, false, false, false, true, true, '500px', jsonStr.notas, dataSetCols);

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.col}_row_${meta.row}" class="campoSel">
								<label for="check_col_${meta.col}_row_${meta.row}"></label>
						  </div>`
    }

    $("#tabelaNFe").DataTable({
      destroy: true,
      paging: false,
      filter: false,
      info: false,
      order: true,
      language: languageDataTable,
      autoWidth: true,
      data: jsonStr.notas,
      columns: dataSetCols,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.substr(0, 10)} 23:59:59`)
            );
          },
          targets: [6, 9],
        },
      ],
      rowCallback: function (row, data) {
        let cor = "";
        if (!['', '0'].includes(data.sit_conf)) {
          cor = '#6495ED';
        } if ((data.entrou_nfe == '') && !['2', '3'].includes(data.sit_conf)) {
          cor = '#FFFF00';
        } if ((data.entrou_nfe == '') && ['2', '3'].includes(data.sit_conf)) {
          cor = '#BC8F8F';
        } if (data.tp_nf == 'E') {
          cor = '#3CB371';
        } if (data.nfe_ref != '') {
          cor = '#006400';
        } if ((data.sit_nfe == 'C') || (data.notaCanc != '') || (data.tipo == 'CAN')) {
          cor = '#FF0000';
        }
        $(row).css('color', cor);
      }
    });

  };

  $('#tabelaNFe').on('click', '.campoSel', async function () {
    if (!$(this).prop('checked')) {
      $($(this).closest('tr')).removeClass('selected');
    } else {
      $($(this).closest('tr')).addClass('selected');
    }
  });

  $('#btnDownloadXml').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaNFe")) {
      msgAlerta('Nenhuma nota consultada.')
      return;
    }

    try {
      $.LoadingOverlay('show');

      let pRadar = { NOTAS: [] };

      $('#tabelaNFe').DataTable().rows('.selected').data().map(item => {
        pRadar.NOTAS.push({
          CHAVE_NFE: item.chave_nfe,
          CNPJ: item.cnpj,
          NOME: item.nome,
          INSCRICAO: item.inscricao,
          EXISTE_XML: item.existe_xml,
          DT_EMISSAO: item.dt_emissao,
          TP_NF: item.tp_nf,
          VALOR: item.valor,
          DT_NFE: item.dt_nfe,
          SIT_NFE: item.sit_nfe,
          SIT_CONF: item.sit_conf,
          NSU: item.nsu,
          TIPO: item.tipo,
          NUM_NFE: item.num_nfe,
          ENTROU_NFE: item.entrou_nfe,
          NOTACANC: item.notaCanc,
          NFE_REF: item.nfe_ref,
          NATUREZA_NFE: item.natureza_nfe,
          CNPJ_DEST: item.cnpj_dest,
          DATA: item.data,
          FINNFE: item.finNfe,
          DESC_FINNFE: item.desc_FinNfe,
        });
      });

      if (pRadar.NOTAS.length == 0) {
        msgAlerta('Nenhuma nota selecionada.')
        return;
      }

      const response = await requisicao('POST', '/sisplan/radarnfe/v1/downloadxml?', '', JSON.stringify(pRadar), 30000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Download do XML realizado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        async onHidden() {
          await consultaNotas();
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnEntradaNF').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaNFe")) {
      msgAlerta('Nenhuma nota consultada.')
      return;
    }

    let notas = [];

    $('#tabelaNFe').DataTable().rows('.selected').data().map(item => {
      notas.push({
        CHAVE_NFE: item.chave_nfe,
        CNPJ: item.cnpj,
        NOME: item.nome,
        INSCRICAO: item.inscricao,
        EXISTE_XML: item.existe_xml,
        DT_EMISSAO: item.dt_emissao,
        TP_NF: item.tp_nf,
        VALOR: item.valor,
        DT_NFE: item.dt_nfe,
        SIT_NFE: item.sit_nfe,
        SIT_CONF: item.sit_conf,
        NSU: item.nsu,
        TIPO: item.tipo,
        NUM_NFE: item.num_nfe,
        ENTROU_NFE: item.entrou_nfe,
        NOTACANC: item.notaCanc,
        NFE_REF: item.nfe_ref,
        NATUREZA_NFE: item.natureza_nfe,
        CNPJ_DEST: item.cnpj_dest,
        DATA: item.data,
        FINNFE: item.finNfe,
        DESC_FINNFE: item.desc_FinNfe,
      });
    });

    if (notas.length == 0) {
      msgAlerta('Nenhuma nota selecionada.')
      return;
    };

    if (notas.length > 1) {
      msgAlerta('Impossível dar entrada em mais de uma nota por vez, favor selecionar apenas uma.')
      return;
    }

    if (!await Existe('XML_NOTAS', ['CHAVE_NFE'], [notas[0].CHAVE_NFE])) {
      msgAlerta('Nota não possui XML baixado, favor verificar.')
      return;
    }

    // if (notas[0].ENTROU_NFE != '') {
    //   msgAlerta('Nota já foi lançada, impossível continuar.')
    //   return;
    // }

    try {
      parent.abrirEmNovaAbaIFrame('Entrada NF', `${BASE_URI}/entrada_nf`, `/${notas[0].CHAVE_NFE}`);

      let iframe = parent.document.querySelector('#panel--sisplan_web-loja iframe');
      let src = iframe.getAttribute("src");
      iframe.setAttribute("src", src);
    } catch (error) {
      console.error(error);
    }
  });

  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
  $('#btn-Fornecedor').pesquisa_serverside(['#txtFornecedor', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
  $('#btn-limpa-Fornecedor').on('click', function () { $('#txtFornecedor').val(''); });

});