$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta das FALs.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma FAL.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAcesso',
        popover: {
          title: 'Tabela Serviço de Tingimento',
          description: 'Aqui estão todas as FALs cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  montaPesquisa();

  let bOculto = false;

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaOps();
    $('#modal-filtros').modal('hide');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#dtFinalOpIni').val('1200-01-01');
    $('#dtFinalOpFim').val('2500-12-31');
    $('#dtEmissaoOpIni').val('1200-01-01');
    $('#dtEmissaoOpFim').val('2500-12-31');
    $('.camposFiltros').empty().trigger('change');
    $('.camposFiltros').val('');
    $('.camposFiltros').attr('data-chave', '');
    $('.camposFiltros').attr('data-desc', '');
  });

  $('#btnProcessar').on('click', async function () {
    if ($('#tabelaAcesso').DataTable().rows('.selected').data().length == 0) {
      msgAlerta('Necessário selecionar ao menos uma OP para processar.');
      return;
    }

    await processarOps();
    carregarOps();
  });

  $('#btnSolCompra').on('click', async function () {
    if ($('#tabelaConsumos').DataTable().rows('.selected').data().length == 0) {
      msgAlerta('Necessário selecionar ao menos uma OP para gerar solicitação de compra.');
      return;
    }

    await gerarSolCompra();
  });

  $('#btnConsumosOF').on('click', async function () {
    if ($('#tabelaConsumos').DataTable().rows('.selected').data().length == 0) {
      msgAlerta('Necessário selecionar ao menos uma OP para reservar os consumos.');
      return;
    }

    reservarConsumos();
  });

  $('#btnSaldoNeg').on('click', async function () {
    mostrarSaldoNegativo();

    if (!bOculto) {
      bOculto = true;
    } else {
      bOculto = false;
    }
  });

  async function gerarSolCompra() {
    $.LoadingOverlay('show');
    try {

      const depositoPadrao = (await buscaValor('DEPOSITO', 'CODIGO', 'PRIORIDADE', '1')).CODIGO;

      const solicitacao = {
        NUMERO: await RetornaProximo('SOL_COMPRA', 'SOL_COMPRA', 'NUMERO', 6),
        EMPRESA: getCookie('empresa').replace('_', ''),
        DT_INICIO: retornaDataAtual(),
        USUARIO: getCookie('usuario'),
        DATA: retornaDataAtual(),
        DT_BAIXA: `1899-01-01T00:00:00Z`,
        LIBERADO: 'B',
        OBS: 'Solicitação criada através da Programação MRP',
        ITENS: [],
      };

      $('#tabelaConsumos').DataTable().rows('.selected').data().map((item, index) => {
        solicitacao.ITENS.push({
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          COR: item.COR,
          DEPOSITO: depositoPadrao,
          UNIDADE: item.UNIDADE,
          UNI_COM: item.UNI_COM,
          DIVISOR: item.DIVISOR,
          QTDE: item.CONSUMO,
          PRECO: item.PRECO_COMPRA,
          ORDEM: index + 1,
          TP_ITEM: 'M'
        });
      });

      const response = await requisicao('POST', '/sisplan/solicitacao_compra/v1/solicitacao_compra?', '', JSON.stringify(solicitacao), 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      $('#cbSelTodosCons').prop('checked', false);
      $('.campoSelCons').prop('checked', false);
      $('.linhaAcessoCons').removeClass('selected');

      criaMensagemSucesso(`Solicitação ${solicitacao.NUMERO} gravada com sucesso!`);

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function processarOps() {
    $.LoadingOverlay('show');
    alteraAba();
    try {
      const response = await requisicao('POST', '/sisplan/progppcp/v1/buscaconsumos?', '', JSON.stringify(await retornaFiltros(true)));

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      const dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaConsumos').DataTable({
        destroy: true,
        filter: false,
        language: retornaLangDataTable(),
        autoWidth: true,
        paging: false,
        info: false,
        scrollY: '300px',
        data: jsonStr,
        columns: dataSetCols,
        order: [[0, 'desc']],
        createdRow: function (row, data, dataIndex) {
          $(row).addClass('linhaAcessoCons');
        },
        columnDefs: [
          {
            render: funcCheckboxConsumos,
            targets: [0]
          },
          {
            visible: false,
            targets: [5, 6, 9, 10, 11, 12, 15, 16, 24, 25],
          }
        ]
      });

      $('#tabelaConsumos').on('click', 'tr', async function () {
        selecionarLinhaTabela('#tabelaConsumos', 'campoSelCons', this);
        await carregaEstoque($('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data());
      });

      $('#cbSelTodosCons').on('change', function () {
        if (isChecked('#cbSelTodosCons')) {
          $('.campoSelCons').prop('checked', true);
          $('.linhaAcessoCons').addClass('selected');
        } else {
          $('.campoSelCons').prop('checked', false);
          $('.linhaAcessoCons').removeClass('selected');
        }
      });

      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    }
  };

  async function carregaEstoque(sData) {
    $.LoadingOverlay('show');
    try {

      const pesquisaParam = {
        tabela: 'MAT_ITEN',
        alias: 'ITEM',
        camposSelect: ['NOTA.FATURA', 'NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.PROTOCOLO_NFE', 'NOTA.CHAVE_NFE'],
        leftJoin: [{ tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' }],
        where: [`NOTAITEN.PEDIDO = '${pedido}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function consultaOps() {
    try {
      $.LoadingOverlay('show');

      const response = await requisicao('POST', '/sisplan/progppcp/v1/buscaops?', '', JSON.stringify(await retornaFiltros()));

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      const dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaAcesso').DataTable({
        destroy: true,
        filter: false,
        language: retornaLangDataTable(),
        autoWidth: true,
        paging: false,
        scrollY: '600px',
        data: jsonStr,
        columns: dataSetCols,
        order: [[0, 'desc']],
        createdRow: function (row, data, dataIndex) {
          $(row).addClass('linhaAcesso');
        },
        columnDefs: [
          {
            render: funcCheckbox,
            targets: [0]
          },
          {
            render: funcFormataData,
            targets: [8, 10, 19, 20],
          },
          {
            visible: false,
            targets: [1, 2],
          }
        ]
      });

      $('#tabelaAcesso').on('click', 'tr', function () {
        selecionarLinhaTabela('#tabelaAcesso', 'campoSel', this);
      });

      $('#cbSelTodos').on('change', function () {
        if (isChecked('#cbSelTodos')) {
          $('.campoSel').prop('checked', true);
          $('.linhaAcesso').addClass('selected');
        } else {
          $('.campoSel').prop('checked', false);
          $('.linhaAcesso').removeClass('selected');
        }
      });

      $('#btnProcessar').prop('disabled', false);
      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    }
  }

  async function retornaFiltros(bConsumos = false) {
    const retorno = {
      FINALOPINI: pegaValor('#dtFinalOpIni'),
      FINALOPFIM: pegaValor('#dtFinalOpFim'),
      EMISSAOOPINI: pegaValor('#dtEmissaoOpIni'),
      EMISSAOOPFIM: pegaValor('#dtEmissaoOpFim'),
      OPSINI: pegaValor('#txtOpsIni'),
      OPSFIM: pegaValor('#txtOpsFim'),
      PRAZOENTREGAINI: pegaValor('#txtPrazoEntregaIni'),
      PRAZOENTREGAFIM: pegaValor('#txtPrazoEntregaFim'),
      CORFT: await formataListas($('#txtCorFt').val().toString()),
      SETORFT: await formataListas($('#txtSetorFt').val().toString()),
      APLICACAOFT: await formataListas($('#txtAplicacaoFt').val().toString()),
      DEPOSITO: await formataListas($('#txtDeposito').val().toString()),
      PEDIDO: await formataListas($('#txtPedido').val().toString()),
      STATUS: await formataListas($('#txtStatus').val().toString()),
      SETORPEND: await formataListas($('#txtSetorPend').val().toString()),
      TIPOOP: await formataListas($('#txtTipoOp').val().toString()),
      PARTE: await formataListas($('#txtParte').val().toString()),
      PRODUTO: await formataListas($('#txtProduto').val().toString()),
      MODELO: await formataListas($('#txtModelo').val().toString()),
      COLECAO: await formataListas($('#txtColecao').val().toString()),
      GRUPOPA: await formataListas($('#txtGrupoPA').val().toString()),
      MARCA: await formataListas($('#txtMarca').val().toString()),
      ETIQUETA: await formataListas($('#txtEtiqueta').val().toString()),
      CATEGORIA: await formataListas($('#txtCategoria').val().toString()),
      LINHA: await formataListas($('#txtLinha').val().toString()),
      COR: await formataListas($('#txtCor').val().toString()),
      MATERIAL: await formataListas($('#txtMaterial').val().toString()),
      GRUPOMA: await formataListas($('#txtGrupoMA').val().toString()),
      SUBGRUPO: await formataListas($('#txtSubGrupo').val().toString()),
      QUALIDADE: await formataListas($('#txtQualidade').val().toString()),
      GRUPOCOR: await formataListas($('#txtGrupoCor').val().toString()),
      FORNECEDOR: await formataListas($('#txtFornecedor').val().toString()),
      ORDEMPRODUCAO: await formataListas($('#txtOrdemProducao').val().toString()),
    }

    if (bConsumos) {
      retorno.OPS = '';
      $('#tabelaAcesso').DataTable().rows('.selected').data().map(item => {
        retorno.OPS += (retorno.OPS == '' ? `'${item.NUMERO}'` : `, '${item.NUMERO}'`);
      });
    }

    return retorno;
  }

  function carregarOps() {
    const dados = $('#tabelaAcesso').DataTable().rows('.selected').data();
    const dataSetCols = [];
    const keys = Object.keys(dados[0]);
    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaOps').DataTable({
      destroy: true,
      filter: false,
      language: retornaLangDataTable(),
      autoWidth: true,
      paging: false,
      info: false,
      scrollY: '300px',
      data: dados,
      columns: dataSetCols,
      order: [[0, 'desc']],
      columnDefs: [
        {
          render: funcFormataData,
          targets: [8, 10, 19, 20],
        },
        {
          visible: false,
          targets: [0, 1, 2],
        }
      ]
    });
  };

  function reservarConsumos() {
    $.LoadingOverlay('show');
    try {
      $('#tabelaConsumos').DataTable().rows('.selected').data().map((item, index) => {
        const saldo = item.CONSUMO - coalesce(item.RESERVA) - coalesce(item.RESERVA_CALC);

        if ((saldo > 0) && (saldo <= item.ESTOQUE)) {
          item.RESERVA_CALC += saldo;
          item.SALDO = 0;
        }
      });

      $('#tabelaConsumos').DataTable().rows().data().map((item, index) => {
        $('#tabelaConsumos').DataTable().row(index).data(item).draw(false);
      });

      $('.campoSelCons').prop('checked', false);
      $('.linhaAcessoCons').removeClass('selected');

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function mostrarSaldoNegativo() {
    $.LoadingOverlay('show');
    try {
      if (bOculto) {
        $('#tabelaConsumos tr').closest('tr').show();
        return;
      }

      $('#tabelaConsumos').DataTable().rows().data().map((item, index) => {
        if (item.SALDO >= 0) {
          $($('#tabelaConsumos tr')[index + 1]).closest('tr').hide()
        }
      });
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function alteraAba() {
    $('#tabAcesso').removeClass('active');
    $('#tabProgramacao').addClass('active');
    $('#tabAcesso').prop('aria-selected', 'false');
    $('#tabProgramacao').prop('aria-selected', 'true');
    $('#divAcesso').removeClass('active');
    $('#divProgramacao').addClass('active');
    $('#divAcesso').removeClass('show');
    $('#divProgramacao').addClass('show');
  };

  function funcFormataData(data, type, row) {
    if (!data) {
      return 'NÃO ESPECIFICADO'
    }
    x = data.slice(0, 10).split('-');
    return `${x[2]}/${x[1]}/${x[0]}`;
  };

  function funcCheckbox(data, type, row, meta) {
    return `<div class="icheck-primary d-inline">
                <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
                <label for="check_col_${meta.row}_row_${meta.col}"></label>
            </div>`
  };

  function funcCheckboxConsumos(data, type, row, meta) {
    return `<div class="icheck-primary d-inline">
                <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSelCons">
                <label for="check_col_${meta.row}_row_${meta.col}"></label>
            </div>`
  };

  function retornaLangDataTable() {
    return {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  };

  function montaPesquisa() {
    componenteFiltro('ordemProducao', true);
    componenteFiltro('projecao', true);
    componenteFiltro('corFt', true);
    componenteFiltro('setorFt', true);
    componenteFiltro('aplicacaoFt', true);
    componenteFiltro('deposito', true);
    componenteFiltro('pedido', true);
    componenteFiltro('status', true);
    componenteFiltro('tipoOp', true);
    componenteFiltro('setorPend', true);
    componenteFiltro('modelo', true);
    componenteFiltro('parte', true);
    componenteFiltro('produto', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('marca', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('categoria', true);
    componenteFiltro('linha', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('cor', true);
    componenteFiltro('material', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('grupoCor', true);
    componenteFiltro('fornecedor', true);
  };

});