/* eslint-disable guard-for-in */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoProduto',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um produto.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadProduto_wrapper',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui estão os dados dos produtos cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("PRODUTO");
    const acessoFaccao = await permissaoAcessos('FACPRECO');

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu dropDownProduto" style="z-index: 999999;"> ' +
            '       <button class="dropdown-item" id="btn-editar">Editar</button>     ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button>  ' +
            '       <button class="dropdown-item" id="btn-duplicar">Duplicar</button>  ' +
            '       <button class="dropdown-item" id="btn-barra">Gera Barras</button>  ' +
            '       <button class="dropdown-item" id="btnAnexos">Gestão Documentos</button>     ' +
            '       <button class="dropdown-item" id="btnMedidas">Medidas</button>     ' +
            '       <button class="dropdown-item" id="btnCombProd">Combinações</button>     ' +
            '       <button class="dropdown-item" id="btnHistProd">Modificações</button>     ' +
            '       <button class="dropdown-item" id="btnFluxoProd">Fluxo</button> ' +
            '       <button class="dropdown-item" id="btnProdItensEst">Consulta Estoque</button>     ' +
            '       <button class="dropdown-item" id="btnCadConsumo">Consumos</button>     ';
        if (acessoFaccao.CONSULTA == 'S') {
            retorno +=
                '       <button class="dropdown-item" id="btnImprimirFT">Imprimir FT</button>     ';
        }
        retorno +=
            '       <button class="dropdown-item" id="btnPrecoFaccao">Preço Facção</button>     '; +
                '</div>';
        return retorno;
    }

    consultaProduto();

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoProduto').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "produto/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    // autocompleta filtros
    $('#txtConsultaProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtConsultaColecao').autocompleta(1, `JSON={ "tabela":"colecao", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtConsultaMarca').autocompleta(1, `JSON={ "tabela":"marca", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtConsultaGrupo').autocompleta(1, `JSON={ "tabela":"grupo_pa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#btn-ConsultaProduto').pesquisa_serverside(['#txtConsultaProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
    $('#btn-ConsultaColecao').pesquisa('#txtConsultaColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"colecao", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Coleção', 'colecao');
    $('#btn-ConsultaMarca').pesquisa('#txtConsultaMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"marca", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Marca', 'marca');
    $('#btn-ConsultaGrupo').pesquisa('#txtConsultaGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"grupo_pa", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'grupo');

    $('#btn-limpa-ConsultaProduto').on('click', function () {
        $('#txtConsultaProduto').val('');
    });

    $('#btn-limpa-ConsultaColecao').on('click', function () {
        $('#txtConsultaColecao').val('');
    });

    $('#btn-limpa-ConsultaMarca').on('click', function () {
        $('#txtConsultaMarca').val('');
    });

    $('#btn-limpa-ConsultaGrupo').on('click', function () {
        $('#txtConsultaGrupo').val('');
    });

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaProduto(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtConsultaProduto').val('');
        $('#txtConsultaMarca').val('');
        $('#txtConsultaColecao').val('');
        $('#txtConsultaGrupo').val('');
    });

    function criptografaCodigo(codigo) {
        return btoa(codigo).replaceAll('=', '');
    }

    async function consultaProduto(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            let produto = pegaChave('#txtConsultaProduto') != '' ? ` AND PRODUTO.CODIGO = '${pegaChave('#txtConsultaProduto')}'` : '';
            let colecao = pegaChave('#txtConsultaColecao') != '' ? ` AND PRODUTO.COLECAO = '${pegaChave('#txtConsultaColecao')}'` : '';
            let marca = pegaChave('#txtConsultaMarca') != '' ? ` AND PRODUTO.MARCA = '${pegaChave('#txtConsultaMarca')}'` : '';
            let grupo = pegaChave('#txtConsultaGrupo') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtConsultaGrupo')}'` : '';
            let inputStatus = $('input[name="cbStatusProd"]:checked');
            let statusProduto = inputStatus.attr('id') === 'cbTodos' ? '' : ` AND PRODUTO.ATIVO = '${inputStatus.val()}'`;
            const objPesquisa = { 
                "tabela":"produto", 
                "camposSelect":[ "PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4", "PRODUTO.DESCRICAO", "PRODUTO.PRECO"], 
                "camposWhereServerSide": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI"], 
                "where": [`1=1 ${produto} ${colecao} ${grupo} ${marca} ${statusProduto}`], 
                "innerJoin": [{"tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], 
                "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.IMAGEM4","PRODUTO.DESCRICAO", "PRODUTO.PRECO"]
            };

            $("#tabelaCadProduto").DataTable({
                destroy: true,
                lengthChange: false,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie(
                        "ip_api"
                    )}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "GET",
                    headers: { Authorization: BASIC_AUTH },
                    data: {
                        EMPRESA: getCookie("empresa"),
                        JSON: `${encodeURIComponent(JSON.stringify(objPesquisa))}`,
                        CLIENTE: "S",
                    },
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(row[0]);
                        }
                    },
                    {
                        targets: [2], render: function (data, type, row, meta) {
                            const codigo = row[0];
                            const tipo = row[5];
                            buscaFotoProduto(codigo, tipo);
                            const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
                            return `<img id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="${data}" height="75" width="75"/>`
                        }
                    },
                    {
                        targets: [4], render: function (data, type, row, meta) {
                            const preco = (Math.round(row[4])).toFixed(2);
                            return preco == "NaN" ? row[4] : preco;

                        }
                    }

                ]
            });

            let tabelaProduto = $('#tabelaCadProduto').DataTable();
            tabelaProduto.on('draw.dt', function () {
                const info = tabelaProduto.page.info();
                const paginaAtual = info.page + 1;

                if (paginaAtual === info.pages) {
                    if ((info.end - info.start) < 10) {
                        $('.dropDownProduto').each((i, t) => {
                            $($('.dropDownProduto')[i]).addClass('dropProduto');
                        });
                    }
                }
            });

            // if (bBotao) {
            //     response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"produto", "camposSelect":[ "PRODUTO.CODIGO", "PRODUTO.DESCRICAO, PA_ITEN.TIPO"], "where": ["1=1 ${produto} ${colecao} ${grupo} ${marca}"], "innerJoin": [{"tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO "}], "groupBy": ["PRODUTO.codigo", "PRODUTO.descricao", "PA_ITEN.tipo"]}`, null);
            // } else {
            //     response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"produto", "camposSelect":[ "PRODUTO.CODIGO", "PRODUTO.DESCRICAO, PA_ITEN.TIPO"], "where": ["1=1"], "innerJoin": [{"tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO "}], "groupBy": ["PRODUTO.codigo", "PRODUTO.descricao", "PA_ITEN.tipo"], "limit": 100000}`, null);
            // }

            // if (!response) {
            //     $.LoadingOverlay("hide");
            //     return;
            // }

            // let jsonStr = await response.json();
            // if (response.status != 200) {
            //     $.LoadingOverlay("hide");
            //     msgErro(jsonStr.RESULT[0].mensagem);
            //     return;
            // }

            // $('#tabelaCadProduto').DataTable({
            //     destroy: true,
            //     lengthChange: false,
            //     serverside: true,
            //     "language": {
            //         "sEmptyTable": "Nenhum registro encontrado",
            //         "sInfo": "_TOTAL_ registros",
            //         "sInfoEmpty": " 0 registros",
            //         "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            //         "sInfoPostFix": "",
            //         "sInfoThousands": ".",
            //         "sLengthMenu": "_MENU_ resultados",
            //         "sLoadingRecords": "Carregando...",
            //         "sProcessing": "Processando...",
            //         "sZeroRecords": "Nenhum registro encontrado",
            //         "sSearch": "Pesquisar",
            //         "oPaginate": {
            //             "sNext": "Próximo",
            //             "sPrevious": "Anterior",
            //             "sFirst": "Primeiro",
            //             "sLast": "Último"
            //         },
            //         "oAria": {
            //             "sSortAscending": ": Ordenar colunas de forma ascendente",
            //             "sSortDescending": ": Ordenar colunas de forma descendente"
            //         }
            //     },

            //     "autoWidth": true,
            //     "data": jsonStr.RESULT[0],
            //     "columns": [{
            //         "data": "CODIGO"
            //     },
            //     {
            //         "data": "DESCRICAO"
            //     },
            //     {
            //         "data": null
            //     },
            //     ],
            //     "columnDefs": [{
            //         "targets": -1,
            //         "data": null,
            //         className: "tdBtnOpcoes",
            //         "defaultContent": retornaBotaoOpcoes()
            //     }]
            // });

            $('#tabelaCadProduto').on('click', '#btn-editar', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[0]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[0])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto').on('dblclick', 'tr', async function () {
                if (permissaoUsuarioLogado.ALTERA == 'S') {
                    let data = $('#tabelaCadProduto').DataTable().row($(this)).data();
                    let registroLiberado = await verificarRegistro('PRODUTO', data[0]);
                    if (registroLiberado) {
                        window.location.href = `produto/${criptografaUrl(data[0])}`;
                    }
                } else {
                    msgAlertaSemConfirmacao("Sem permissão para alterar!");
                }
            });

            $('#tabelaCadProduto').on('click', 'tr td', async function () {
                if ($(this).index() == 2) {
                    $('.imagepreview').attr('src', $(this).find('img').attr('src'));
                    $('#imagemodal').modal('show');
                    $('#imagemodal').css('z-index', '999999')
                }
            })

            $.LoadingOverlay("hide");
        } catch (error) {
            $.LoadingOverlay("hide");
            console.error(error);
            msgErro(`Não foi possível buscar os dados do produto`);
        }

    }

    async function buscaFotoProduto(codigo, tipo) {
        const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + tipo);
        try {
            const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            const jsonStr = await response.json();
            if (response.status != 200) {
                $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            const sBase64 = jsonStr;
            $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    $('#tabelaCadProduto').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                await excluiRegistro(data[0]);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function excluiRegistro(codigo) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/produto?", `CODIGOPRODUTO=${encodeURIComponent(codigo)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    let guardaLinha;

    // barra
    $('#tabelaCadProduto').on('click', '#btn-barra', async function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            // ao dar o click ele vai consultar as barras
            let data = $('#tabelaCadProduto').DataTable().rows($(this).closest('tr')).data();
            guardaLinha = $(this).closest('tr');
            let jsonBarra;
            $('#txtCodigoProduto').val(data[0][0]);
            $('#txtDescricaoProduto').val(data[0][3]);
            jsonBarra = await buscaBarras(data[0][0], '1');

            let dataSetCols = [];

            let keys = Object.keys(jsonBarra[0][0]);

            // eslint-disable-next-line no-restricted-syntax
            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }

            for (let i = 0; i < jsonBarra[0].length; i++) {
                jsonBarra[0][i].BARRACLI =
                    `
                    <input type="text" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                `;
            }

            let rowDuplicado = []

            for (let j = 0; j < jsonBarra[0].length; j++) {
                for (let i = j + 1; i < jsonBarra[0].length; i++) {
                    if (jsonBarra[0][j].COR == jsonBarra[0][i].COR && jsonBarra[0][j].TAM == jsonBarra[0][i].TAM) {
                        rowDuplicado.push(i);
                    }
                }
            }

            const duplicados = rowDuplicado.filter(function (itens, pos) {
                return rowDuplicado.indexOf(itens) == pos;
            })

            tabelaBarra = $('#tabelaBarra').DataTable({
                paging: false,
                filter: false,
                info: true,
                order: true,
                destroy: true,
                scrollY: "400px",
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                "data": jsonBarra[0],
                "columns": dataSetCols,
                "columnDefs": [{
                    "targets": [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17],
                    "visible": false
                }]
            });

            if (duplicados.length > 0) {
                $('#tabelaBarra').DataTable().rows([duplicados.toString()]).remove().draw(false);
            }

            $('#modalBarra').modal('show');
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $("#modalBarra").on("shown.bs.modal", function () {
        $("#tabelaBarra").DataTable().columns.adjust().draw(false);
    });

    async function consultaCor(codigoProduto) {
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR'],
            where: [`PA_ITEN.CODIGO = '${codigoProduto}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
            return;
        };

        const listaCores = [];

        for (i in jsonStr) {
            listaCores.push(jsonStr[i].COR);
        };

        const listaFormatada = await formataListas(listaCores.toString());

        return listaFormatada
    };

    async function recarregaBarras(linha) {
        // ao dar o click ele vai consultar as barras
        let data = $('#tabelaCadProduto').DataTable().rows(linha).data();
        let jsonBarra;
        $('#txtCodigoProduto').val(data[0][0]);
        $('#txtDescricaoProduto').val(data[0][1]);
        jsonBarra = await buscaBarras(data[0][0], data[0][5]);

        let dataSetCols = [];

        let keys = Object.keys(jsonBarra[0][0]);

        // eslint-disable-next-line no-restricted-syntax
        for (let k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        }

        for (let i = 0; i < jsonBarra[0].length; i++) {
            jsonBarra[0][i].BARRACLI =
                `
                    <div class="input-group">
                        <input type="text" value="${jsonBarra[0][i].BARRACLI}" class="input-default focus form-control txtBarracli" name="txtBarracli">
                    </div>
                `;
        }

        tabelaBarra = $('#tabelaBarra').DataTable({
            paging: false,
            filter: false,
            info: true,
            order: true,
            destroy: true,
            scrollY: "400px",
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
            "data": jsonBarra[0],
            "columns": dataSetCols,
            "columnDefs": [{
                "targets": [0, 1, 2, 3, 11, 12, 13, 14, 15, 16, 17],
                "visible": false
            }]
        });
    };

    async function buscaBarras(codigo) {
        try {
            $.LoadingOverlay('hide');
            try {
                let url = `/sisplan/funcoes/v1/pesquisa?`;
                let response = await requisicao('GET', url, `JSON={
                    "tabela": "PRODUTO",
                    "camposSelect": ["SUM(QUANTIDADE) AS QTDE", "PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO QUALIDADE", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM",
                        "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_MIN",
                        " CASE WHEN MAX(PA_ITEN.COD_PROD_CLI) IS NULL THEN '' ELSE MAX(PA_ITEN.COD_PROD_CLI) END AS COD_PROD_CLI",
                        " PA_ITEN.ATIVO", " MAX(PA_ITEN.COMPOSICAO2) COMPOSICAO2", "MAX(PA_ITEN.COMPOSICAO3) COMPOSICAO3", "PA_ITEN.QTDE_BARRA"],
                    "where": ["PRODUTO.CODIGO = '${codigo}'"],
                    "innerJoin": [
                        { "tabela": "PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO" },
                        { "tabela": "CADCOR", "condicao": "PA_ITEN.COR = CADCOR.COR" },
                        { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA AND FAIXA_ITEN.TAMANHO = PA_ITEN.TAM" }],
                    "groupby": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.UNIDADE", "PA_ITEN.TIPO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PA_ITEN.QTDE_MIN",
                        "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.ORDEM", "PA_ITEN.QTDE_BARRA",
                        "FAIXA_ITEN.POSICAO", "PA_ITEN.ATIVO"],
                    "orderby": ["PA_ITEN.ORDEM", "PA_ITEN.COR", "FAIXA_ITEN.POSICAO"]
                }`, null, 20000);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                return jsonStr.RESULT;
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    // confirma barra
    $('#btnConfirmarBarra').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: $('.txtBarracli')[i].value,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRACLI'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 4;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                msgErro(error);
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
        $('#modalBarra').modal('hide');
    });
    // gera Ean13
    $('#btnGeraEan13').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRA,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 1;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });
    // gera Barra128
    $('#btnGeraBarra128').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRA28,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRA28'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 2;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });
    // gera Dun14
    $('#btnGeraDun14Barra').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let data = $('#tabelaBarra').DataTable().rows().data();
                const url = '/sisplan/barra/v1/gerabarra?';
                let jsonStr;
                let arrayBarra = [];
                let ProdutoBarra = {};

                for (let i = 0; i < data.length; i++) {
                    let InfoBarras = {
                        CODIGO: data[i].CODIGO,
                        COR: data[i].COR,
                        TAMANHO: data[i].TAM,
                        BARRA: data[i].BARRACLI,
                        TIPO: 'P',
                        ESPECIEBARRA: 'BARRACLI'
                    };
                    arrayBarra.push(InfoBarras);
                };
                ProdutoBarra.TIPOBARRA = 3;
                ProdutoBarra.BARRAS = arrayBarra;

                const response = await requisicao('POST', url, '', `JSON=${encodeURIComponent(JSON.stringify(ProdutoBarra))}`, 30000);

                if (!response) {
                    return;
                };

                if (response.status != 200) {
                    jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                }

                await recarregaBarras(guardaLinha);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#tabelaCadProduto").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalAnexos(data[0], data[3], 'PRODUTO');
    });

    $('#tabelaCadProduto').on('click', '#btnMedidas', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalMedidas(data[0], data[3]);
    })

    $("#tabelaCadProduto").on('click', "#btnCombProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalCombinacao(data[0], data[3]);
    });

    $("#tabelaCadProduto").on('click', "#btnHistProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalHistProd(data[0], data[3]);
    });

    $("#tabelaCadProduto").on('click', "#btnFluxoProd", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalFluxoProd(data[0], data[3]);

    });

    $("#tabelaCadProduto").on('click', "#btnProdItensEst", async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreModalProdItensEst(data[0], data[3]);

    });

    $('#tabelaCadProduto').on('click', '#btnCadConsumo', async function () {
        const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();

        await abreCadConsumo(data[0], data[3]);
    });

    $('#tabelaCadProduto').on('click', "#btn-duplicar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            await duplicaCadastroProduto(data[0]);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProduto').on('click', "#btnImprimirFT", async function () {
        try {
            $.LoadingOverlay("show");
            const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
            const codigoProduto = data[0];
            const coresProd = await consultaCor(codigoProduto);
            const url = `/sisplan/impressao/v1/imprimirft?CODIGO_PROD=${codigoProduto}&CORES_PROD=${coresProd}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('FichaTecnica');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'FichaTecnica');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#tabelaCadProduto').on('click', '#btnPrecoFaccao', async function () {
        if (acessoFaccao.ALTERA == 'S') {
            $.LoadingOverlay('show');
            try {
                const data = $('#tabelaCadProduto').DataTable().row($(this).parents('tr')).data();
                const response = await requisicao('GET',
                    '/Sisplan/Funcoes/V1/pesquisa?',
                    `JSON={ "tabela":"PRO_FLUXO", 
                        "camposSelect":["PRO_FLUXO.PARTE", "TIPO_APL.DESCRICAO"],
                        "leftjoin": [{"tabela": "TIPO_APL", "condicao": "PRO_FLUXO.PARTE = TIPO_APL.CODIGO"}],
                        "where": ["PRO_FLUXO.CODIGO = '${data[0]}'", "TIPO_APL.ATIVO = 'S'"]}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status !== 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                jsonStr = jsonStr.RESULT[0];

                if (jsonStr.length == 0) {
                    msgErro('Esse produto não possui nenhuma parte. Impossível continuar.');
                    return;
                }

                let tabelaPadrao = await buscaParametroERP('FAC', '310', '3', '3');

                if (tabelaPadrao == '') {
                    tabelaPadrao = await buscaValor('REGIAO', 'REGIAO', 'PADRAO_PROD', 'S');
                }

                if (jsonStr.length > 1) {

                    $('#txtTabPadrao').val(tabelaPadrao);
                    $('#txtCodigoFaccao').val(data[0]);

                    $('#txtParte').html('');

                    jsonStr.map((e) => {
                        $('#txtParte').append(`<option class="drilldown-item" value="${e.PARTE}">${e.PARTE} - ${e.DESCRICAO}</option>`);
                    });

                    $('#modalPartes').modal('show');

                } else {
                    $.LoadingOverlay('show');
                    try {
                        window.location.href = `facpreco/${data[0]}#${tabelaPadrao}#${jsonStr[0].PARTE}`;
                    } finally {
                        $.LoadingOverlay('hide');
                    }
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#btnConfirmarPartes').on('click', async function () {
        if ($('#txtParte').val() != '') {
            $.LoadingOverlay('show');
            try {
                window.location.href = `facpreco/${$('#txtCodigoFaccao').val()}#${$('#txtTabPadrao').val()}#${$('#txtParte').val()}`;
            } finally {
                $.LoadingOverlay('hide');
            }
        } else {
            msgErro('Nenhuma parte selecionada, impossível continuar!');
            return;
        }
    });

    $('#btnFecharPartes').on('click', function () {
        $('#modalPartes').modal('hide');
    });

    async function retornaFiltros() {
        const produto = pegaChave('#txtConsultaProduto');
        const colecao = pegaChave('#txtConsultaColecao');
        const marca = pegaChave('#txtConsultaMarca');
        const grupo = pegaChave('#txtConsultaGrupo');

        const retorno =
            `PRODUTO=${produto}` +
            `&COLECAO=${colecao}` +
            `&GRUPO=${grupo}` +
            `&MARCA=${marca}`+
            `&ATIVO=${$('input[name=cbStatusProd]:checked').val()}`

        return retorno;
    }

    retornaHintRelatorio('btnImprimir', 'RelAcessoProduto')

    async function limpaRelatorioAcessoProd() {
        try {
            try {
                $.LoadingOverlay("show");
                let response = await requisicao(
                    "GET",
                    "/Sisplan/funcoes/v1/limparImpressos?",
                    "",
                    null
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    return;
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        } catch (error) {
            $.LoadingOverlay("hide");
        }

    }

    retornaHintRelatorio('btnImprimirAcessoProd', 'RelAcessoProduto')

    $('#btnImprimirAcessoProd').on('click', async function () {
        let str = $('#tabelaCadProduto_info').text();
        str = str.replace('.', '');
        let endIndex = str.indexOf(' registro');

        let contadorRegistros = parseFloat(str.substring(0, endIndex));

        if (parseFloat(contadorRegistros) > 1000) {
            msgAlerta(`Existem ${contadorRegistros} produtos filtrados, a impressão poderá demorar. Deseja Continuar?`, async () =>
                await imprimirAcessoProd()
            )
        } else {
            await imprimirAcessoProd()
        }
    });

    async function imprimirAcessoProd() {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimiracessoproduto?`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoProduto');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 3600000, false, 'RelAcessoProduto');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limpaRelatorioAcessoProd();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

});