$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#conteudo',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#opcoes',
                popover: {
                    title: 'Tipo',
                    description: 'Aqui você escolhe o tipo de item que deseja cadastrar o preço.',
                    position: 'top'
                }
            },
            {
                element: '#txtTabPreco',
                popover: {
                    title: 'Tabela de Preço',
                    description: 'Aqui adicionamos a tabela de preço, podemos consultar as tabelas clicando na lupa.',
                    position: 'top'
                }
            },
            {
                element: '#produtotuto',
                popover: {
                    title: 'Produto / Material',
                    description: 'Aqui adicionamos o produto ou material.',
                    position: 'top'
                }
            },
            {
                element: '#IdDNonePrecoNormal',
                popover: {
                    title: 'Preços',
                    description: 'Tabela de preços normais.',
                    position: 'top'
                }
            },
            {
                element: '#IdDNonePrecoPromo',
                popover: {
                    title: 'Preços Promocionais',
                    description: 'Tabela de preços Promocionais.',
                    position: 'top'
                }
            },
            {
                element: '#btnVoltar',
                popover: {
                    title: 'Botão Voltar',
                    description: 'Clique aqui para voltar para a tela de consulta.',
                    position: 'left'
                }
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o preço.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let base64toBr = atob(parametros[parametros.length - 1]).split('/');
    let codigo = base64toBr[1];
    let regiao = base64toBr[0];
    let tipo = base64toBr[2];
    const parametrosSistema = await BuscaParametrosSistema('S');
    const quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
    const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;



    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PRECOCORTAM', getCookie('usuario'), String(regiao) + String(codigo) + String(tipo));
        window.location.href = `${BASE_URI}/precocortam`;
    });

    $(document).ready(async function () {
        
        $(function () {

            $('#txtPreco').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtTamanhos').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
        });

        $("#btnGravar").click(function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if ($('#txtTabPreco').val() == '') {
                msgErro('Informe uma tabela de preço para continuar.');
                return;
            }

            if ($('#txtProduto').val() == '') {
                msgErro('Informe um produto/material para continuar.');
                return;
            }

            if (erros == 0) {
                gravarPreco();
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtTabPreco: {
                    required: true,
                },
                txtProduto: {
                    required: true,
                }
            },
            messages: {
                txtTabPreco: {
                    required: "Informe uma tabela de preço válida.",
                },
                txtProduto: {
                    required: "Informe um produto válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], saidaTabela);
        $('#txtProduto').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, [], [], [], saidaCampoCodigo);
        $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

        $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'Pesquisa Cor', 'CADCOR');
        $('#btnTabPreco').pesquisa_array(['#txtTabPreco'], ['REGIAO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'REGIAO', saidaTabela);
        $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO"], "where": ["CODIGO <> ''"]}`, 'Pesquisa Produto', 'PRODUTO', saidaCampoCodigo);

        $('#btnExcluiProduto').on('click', function () {
            $('#txtProduto').val('');
        });
        $('#btnExcluiTabPreco').on('click', function () {
            $('#txtTabPreco').val('');
        });
        $('#btnExcluiCor').on('click', function () {
            $('#txtCor').val('');
        });
        $('#btnExcluiTamanho').on('click', function () {
            $('#txtTamanho').val('');
        });

        $('#radioProduto, #radioMaterial').on('change', async function () {
            $('#btnProduto').unbind();
            $('#tabelaGrade').DataTable().clear().draw(false);
            $('#tabelaGrade').DataTable().columns.adjust().draw(false);
            $('#tabelaPromo').DataTable().clear().draw(false);
            $('#tabelaPromo').DataTable().columns.adjust().draw(false);

            if ($('#radioMaterial').is(':checked')) {
                $('#labelProduto').html('Material *');
                $('#txtProduto').attr('placeholder', 'Material');
                $('#txtProduto').val('');
                $('#txtCor').val('');
                $('#txtTamanho').val('');
                $('#txtPreco').val('');
                $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, [], [], [], saidaCampoCodigo);
                $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO <> ''"]}`, 'Pesquisa Material', 'MATERIAL', saidaCampoCodigo);
            } else {
                $('#labelProduto').html('Produto *');
                $('#txtProduto').attr('placeholder', 'Produto');
                $('#txtProduto').val('');
                $('#txtCor').val('');
                $('#txtTamanho').val('');
                $('#txtPreco').val('');
                $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, [], [], [], saidaCampoCodigo);
                $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO <> ''"]}`, 'Pesquisa Produto', 'PRODUTO', saidaCampoCodigo);
            }
        });

        $('#txtProduto').on('change', async function () {
            $('#txtCor').val('');
            $('#txtTamanho').val('');
        });


        async function saidaCampoCodigo() {
            await filtraGrade();
            await filtraGradePromo();
            if ($('#radioProduto').is(':checked')) {
                $('#txtCor').unbind('autocompleta');
                $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$('#txtProduto').attr('data-chave')}'"] }`);
                $('#btnCor').off();
                $('#btnCor').unbind('pesquisa_array');
                $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$('#txtProduto').attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
            } else {
                $('#txtCor').unbind('autocompleta');
                $('#txtCor').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$('#txtProduto').attr('data-chave')}'"] }`);
                $('#btnCor').off();
                $('#btnCor').unbind('pesquisa_array');
                $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["MAT_ITEN.CODIGO = '${$('#txtProduto').attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
            }
        }

        async function saidaTabela() {
            codigo = $('#txtProduto').val();
            if (codigo != '') {
                await filtraGrade();
                await filtraGradePromo();
            }
        }

        async function retornaListaTamanhos(codigo) {
            const url = `/sisplan/funcoes/v1/pesquisa?`;
            let params;
            if ($('#radioProduto').is(':checked')) {
                params = `JSON= {"tabela":"FAIXA_ITEN", "camposSelect":["FAIXA_ITEN.TAMANHO"],
            "WHERE": ["FAIXA IN (SELECT FAIXA FROM [PRODUTO] WHERE (CODIGO = '${codigo}'))"]}`
            } else {
                params = `JSON={"tabela": "MATERIAL", "camposSelect": ["'0' TAMANHO"],
            "WHERE": ["CODIGO = '${codigo}'"]}`
            }
            try {
                var response = await requisicao('GET', url, params, null);

                if (!response) {
                    return '';
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return '';
                }

            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os tamanhos.');
                return '';
            }

            const dados = jsonStr['RESULT'][0];
            let tamanhos = [];
            dados.map((tam) => {
                tamanhos.push(
                    tam.TAMANHO
                )
            });
            return tamanhos;
        };

        //FUNCAO PARA TRAZER TABELA COM OS PRECOS NORMAIS.
        async function montaGradeTabela() {
            $('#tabelaGrade').DataTable().rows().remove().destroy();
            const sCodigo = $('#txtProduto').attr('data-chave');
            const sTabela = $('#txtTabPreco').attr('data-chave');
            const sCor = pegaChave('#txtCor');
            const tamMaterial = 0;
            const url = `/sisplan/funcoes/v1/pesquisa?`;
            let params;
            const sWhereCor = sCor !== '' ? `AND PA_ITEN.COR = '${sCor}'` : '';
            const sWhereCor2 = sCor !== '' ? `AND MAT_ITEN.COR = '${sCor}'` : '';

            if ($('#radioProduto').is(':checked')) {
                params = `JSON={"tabela":"PRODUTO", "camposSelect":["PA_ITEN.COR", "CADCOR.DESCRICAO AS DESCRICAO", "FAIXA_ITEN.TAMANHO AS TAM", "UDF_NVL(PRECO_COR_TAM.PRECO) PRECO"],
                "innerjoin": [{"tabela" : "FAIXA_ITEN", "condicao" : "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA"}],
                "leftjoin": [{"tabela" : "PA_ITEN", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"},
                 {"tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR"},
                 {"tabela" : "PRECO_COR_TAM", "condicao" : "PRECO_COR_TAM.REGIAO = '${sTabela}' AND PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO AND PRECO_COR_TAM.COR = PA_ITEN.COR AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO"}], 
                 "where": ["PRODUTO.CODIGO = '${sCodigo}' ${sWhereCor}"],
                 "groupby": ["PRODUTO.CODIGO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "FAIXA_ITEN.TAMANHO", "FAIXA_ITEN.POSICAO", "PRECO_COR_TAM.PRECO"],
                 "orderby": ["PRODUTO.CODIGO", "PA_ITEN.COR", "FAIXA_ITEN.POSICAO"]}`;
            } else {
                params = `JSON={"tabela":"MATERIAL", "camposSelect":["MAT_ITEN.COR", "CADCOR.DESCRICAO AS DESCRICAO", "'0' TAM", "UDF_NVL(PRECO_COR_TAM.PRECO) PRECO"],
                "leftjoin": [{"tabela" : "MAT_ITEN", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"},
                 {"tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR"},
                 {"tabela" : "PRECO_COR_TAM", "condicao" : "PRECO_COR_TAM.REGIAO = '${sTabela}' AND PRECO_COR_TAM.CODIGO = MATERIAL.CODIGO AND PRECO_COR_TAM.COR = MAT_ITEN.COR AND PRECO_COR_TAM.TAM = '${tamMaterial}'"}], 
                 "where": ["MATERIAL.CODIGO = '${sCodigo}' ${sWhereCor2}"],
                 "groupby": ["MATERIAL.CODIGO", "MAT_ITEN.COR", "CADCOR.DESCRICAO", "PRECO_COR_TAM.PRECO"],
                 "orderby": ["MATERIAL.CODIGO", "MAT_ITEN.COR"]}`;
            }

            try {
                var response = await requisicao('GET', url, params, null);
                if (!response) {
                    return '';
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return '';
                }

                const arrDados = jsonStr['RESULT'][0];
                const tamanhos = await retornaListaTamanhos(sCodigo);

                const arrColunas = [
                    {
                        title: 'COR',
                        data: 'COR'
                    },
                    {
                        title: 'DESC_COR',
                        data: 'DESC_COR'
                    },
                ];

                tamanhos.map((tamanho) => {
                    arrColunas.push({
                        title: tamanho,
                        data: tamanho
                    })
                });

                $('#colunas').html('');
                arrColunas.map((coluna) => {
                    $('#colunas').append(`<th>${coluna.title}</th>`);
                });

                $('#tabelaGrade').DataTable({
                    paging: false,
                    autoWidth: false,
                    filter: false,
                    info: false,
                    ordering: false,
                    destroy: true,
                    scrollH: true,
                    scrollX: true,
                    scrollY: true,
                    scrollCollapse: true,
                    autowidth: true,
                    "language": {
                        "sEmptyTable": "Nenhum registro encontrado",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhum registro encontrado",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }

                    },
                    columns: arrColunas
                });

                return arrDados;

            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados do Item.');
                return '';
            }
        };

        // FUNCAO PARA TRAZER TABELA COM AS DATAS E PRECOS PROMOCIONAIS.
        async function montaGradePromo() {
            $('#tabelaPromo').DataTable().rows().remove().destroy();
            const sCodigo = $('#txtProduto').attr('data-chave');
            const sTabela = $('#txtTabPreco').attr('data-chave');
            const sCor = pegaChave('#txtCor');
            const tamMaterial = 0;
            const url = `/sisplan/funcoes/v1/pesquisa?`;
            let params;
            const sWhereCor = sCor !== '' ? `AND PA_ITEN.COR = '${sCor}'` : '';
            const sWhereCor2 = sCor !== '' ? `AND MAT_ITEN.COR = '${sCor}'` : '';

            if ($('#radioProduto').is(':checked')) {
                params = `JSON={"tabela":"PRODUTO", "camposSelect":["PA_ITEN.COR", "CADCOR.DESCRICAO AS DESCRICAO", "PRECO_COR_TAM.DT_PROMOINI", "PRECO_COR_TAM.DT_PROMOFIM", "FAIXA_ITEN.TAMANHO AS TAM", "UDF_NVL(PRECO_COR_TAM.PRECO_PROMO) PRECOPROMO"],
                "innerjoin": [{"tabela" : "FAIXA_ITEN", "condicao" : "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA"}],
                "leftjoin": [{"tabela" : "PA_ITEN", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"},
                 {"tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR"},
                 {"tabela" : "PRECO_COR_TAM", "condicao" : "PRECO_COR_TAM.REGIAO = '${sTabela}' AND PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO AND PRECO_COR_TAM.COR = PA_ITEN.COR AND PRECO_COR_TAM.TAM = FAIXA_ITEN.TAMANHO"}], 
                 "where": ["PRODUTO.CODIGO = '${sCodigo}' ${sWhereCor}"],
                 "groupby": ["PRODUTO.CODIGO", "PA_ITEN.COR", "CADCOR.DESCRICAO", "PRECO_COR_TAM.DT_PROMOINI", "PRECO_COR_TAM.DT_PROMOFIM", "FAIXA_ITEN.TAMANHO", "FAIXA_ITEN.POSICAO", "PRECO_COR_TAM.PRECO_PROMO"],
                 "orderby": ["PRODUTO.CODIGO", "PA_ITEN.COR", "FAIXA_ITEN.POSICAO"]}`;
            } else {
                params = `JSON={"tabela":"MATERIAL", "camposSelect":["MATERIAL.CODIGO", "MAT_ITEN.COR", "CADCOR.DESCRICAO AS DESCRICAO", "PRECO_COR_TAM.DT_PROMOINI", "PRECO_COR_TAM.DT_PROMOFIM", "'0' TAM", "UDF_NVL(PRECO_COR_TAM.PRECO_PROMO) PRECOPROMO"],
                "leftjoin": [{"tabela" : "MAT_ITEN", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"},
                 {"tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR"},
                 {"tabela" : "PRECO_COR_TAM", "condicao" : "PRECO_COR_TAM.REGIAO = '${sTabela}' AND PRECO_COR_TAM.CODIGO = MATERIAL.CODIGO AND PRECO_COR_TAM.COR = MAT_ITEN.COR AND PRECO_COR_TAM.TAM = '${tamMaterial}'"}], 
                 "where": ["MATERIAL.CODIGO = '${sCodigo}' ${sWhereCor2}"],
                 "groupby": ["MATERIAL.CODIGO", "MAT_ITEN.COR", "CADCOR.DESCRICAO", "PRECO_COR_TAM.DT_PROMOINI", "PRECO_COR_TAM.DT_PROMOFIM", "PRECO_COR_TAM.PRECO_PROMO"],
                 "orderby": ["MATERIAL.CODIGO", "MAT_ITEN.COR"]}`;
            }

            try {
                var response = await requisicao('GET', url, params, null);

                if (!response) {
                    return '';
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return '';
                }

                const arrDados2 = jsonStr['RESULT'][0];
                const tamanhos = await retornaListaTamanhos(sCodigo);

                const arrColunas = [
                    {
                        title: 'COR',
                        data: 'COR'
                    },
                    {
                        title: 'DESC_COR',
                        data: 'DESC_COR'
                    },
                    {
                        title: 'DT_PROMOINI',
                        data: 'DT_PROMOINI'
                    },
                    {
                        title: 'DT_PROMOFIM',
                        data: 'DT_PROMOFIM'
                    }
                ];

                tamanhos.map((tamanho) => {
                    arrColunas.push({
                        title: tamanho,
                        data: tamanho
                    })
                });

                arrColunas[2].render = function (data, type, row) {
                    return `<input type="date" max="2500-12-31" class="input-default focus form-control fundoTransparente txtDtPromoIni txtDtPromoIni_${row.COR.replace('.', '_')}">`
                }
                arrColunas[3].render = function (data, type, row) {
                    return `<input type="date" max="2500-12-31" class="input-default focus form-control fundoTransparente txtDtPromoFim txtDtPromoFim_${row.COR.replace('.', '_')}">`
                }

                $('#colunas2').html('');
                arrColunas.map((coluna) => {
                    $('#colunas2').append(`<th>${coluna.title}</th>`);
                });

                $('#tabelaPromo').DataTable({
                    paging: false,
                    autoWidth: false,
                    filter: false,
                    info: false,
                    ordering: false,
                    destroy: true,
                    scrollH: true,
                    scrollX: true,
                    scrollCollapse: true,
                    autowidth: true,
                    "language": {
                        "sEmptyTable": "Nenhum registro encontrado",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhum registro encontrado",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }

                    },
                    columns: arrColunas

                });

                return arrDados2;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados do Item.');
                return '';
            }
        };

        async function filtraGrade() {
            if (($('#txtProduto').val() != '') && ($('#txtTabPreco').val() != '')) {

                const dadosGrade = await montaGradeTabela();
                const arrayDadosFormatados = [];
                dadosGrade.map((dadoArrayPrincipal) => {
                    const posicaoDadoEncontrado = arrayDadosFormatados.findIndex((dadoArrayFormatado) => dadoArrayFormatado.COR === dadoArrayPrincipal.COR);
                    if (posicaoDadoEncontrado === -1) {
                        arrayDadosFormatados.push(
                            {
                                COR: dadoArrayPrincipal.COR,
                                DESC_COR: dadoArrayPrincipal.DESCRICAO,
                                [dadoArrayPrincipal.TAM]: `<input type="text" maxlength="10" class="input-default focus form-control fundoTransparente txtTamanhos txtCor_${dadoArrayPrincipal.COR.replace('.', '_')} txtTamanho_${dadoArrayPrincipal.TAM}" value="${dadoArrayPrincipal.PRECO}">`,
                            }
                        )
                    } else {
                        const dadoEncontrado = arrayDadosFormatados[posicaoDadoEncontrado];
                        const dadoEditado = { ...dadoEncontrado, [dadoArrayPrincipal.TAM]: `<input type="text" maxlength="10" class="input-default focus form-control fundoTransparente txtTamanhos txtCor_${dadoArrayPrincipal.COR.replace('.', '_')} txtTamanho_${dadoArrayPrincipal.TAM}" value="${dadoArrayPrincipal.PRECO}">` }
                        arrayDadosFormatados[posicaoDadoEncontrado] = dadoEditado;
                    }
                });

                arrayDadosFormatados.forEach((item) => {
                    $('#tabelaGrade').DataTable().row.add(item).draw(false);
                });

                $('#colunas th').css('min-width', '80px');
                $('#tabelaGrade').DataTable().columns.adjust().draw(false);
            }
        };

        async function filtraGradePromo() {
            if (($('#txtProduto').val() != '') && ($('#txtTabPreco').val() != '')) {
                const dadosGradePromo = await montaGradePromo();
                const arrayDadosFormatadosPromo = [];
                dadosGradePromo.map((dadoArrayPrincipalPromo) => {
                    const posicaoDadoEncontradoPromo = arrayDadosFormatadosPromo.findIndex((dadoArrayFormatadoPromo) => dadoArrayFormatadoPromo.COR === dadoArrayPrincipalPromo.COR);
                    if (posicaoDadoEncontradoPromo === -1) {
                        arrayDadosFormatadosPromo.push(
                            {
                                COR: dadoArrayPrincipalPromo.COR,
                                DESC_COR: dadoArrayPrincipalPromo.DESCRICAO,
                                DT_PROMOINI: dadoArrayPrincipalPromo.DT_PROMOINI,
                                DT_PROMOFIM: dadoArrayPrincipalPromo.DT_PROMOFIM,
                                [dadoArrayPrincipalPromo.TAM]: `<input type="number" class="input-default focus form-control fundoTransparente txtTamanhosPromo txtCorPromo_${dadoArrayPrincipalPromo.COR.replace('.', '_')} txtTamanhoPromo_${dadoArrayPrincipalPromo.TAM}" value="${dadoArrayPrincipalPromo.PRECOPROMO}">`,
                            }
                        )
                    } else {
                        const dadoEncontradoPromo = arrayDadosFormatadosPromo[posicaoDadoEncontradoPromo];
                        const dadoEditadoPromo = { ...dadoEncontradoPromo, [dadoArrayPrincipalPromo.TAM]: `<input type="number" class="input-default focus form-control fundoTransparente txtTamanhosPromo txtCorPromo_${dadoArrayPrincipalPromo.COR.replace('.', '_')} txtTamanhoPromo_${dadoArrayPrincipalPromo.TAM}" value="${dadoArrayPrincipalPromo.PRECOPROMO}">` }
                        arrayDadosFormatadosPromo[posicaoDadoEncontradoPromo] = dadoEditadoPromo;
                    }
                });

                arrayDadosFormatadosPromo.forEach((item) => {
                    $('#tabelaPromo').DataTable().row.add(item).draw(false);
                });

                for (let i = 0; i < $('#tabelaPromo').DataTable().rows().count(); i++) {
                    const promoIni = dadosGradePromo[i].DT_PROMOINI === null ? '1899-12-30 00:00:00' : dadosGradePromo[i].DT_PROMOINI;
                    const promoFim = dadosGradePromo[i].DT_PROMOFIM === null ? '1899-12-30 00:00:00' : dadosGradePromo[i].DT_PROMOFIM;
                    $($('.txtDtPromoIni')[i]).val(promoIni.split(' ')[0]);
                    $($('.txtDtPromoFim')[i]).val(promoFim.split(' ')[0]);
                }

                $('#colunas2 th').css('min-width', '80px');
                $('#tabelaPromo').DataTable().columns.adjust().draw(false);

            }
        };

        $('#btnConfirmar').on('click', function () {
            const preco = $('#txtPreco').val();
            const cor = pegaChave('#txtCor');
            const tamanho = $('#txtTamanho').val();
            const arrayTamanhos = tamanho.split(',');

            if ((cor !== '' || tamanho !== '') && preco === '') {
                msgErro('Necessário informar um preço para continuar.');
                return;
            }

            if (cor === '' && tamanho === '') {
                $('.txtTamanhos').val(preco);
            }
            else if (cor === '' && tamanho !== '') {
                for (let i = 0; i < arrayTamanhos.length; i++) {
                    $('.txtTamanho_' + arrayTamanhos[i]).val(preco);
                }
            }
            else if (tamanho === '' && cor !== '') {
                $('.txtCor_' + cor.replace('.', '_')).val(preco);
            }
            else {
                for (let i = 0; i < arrayTamanhos.length; i++) {
                    $('.txtCor_' + cor.replace('.', '_') + '.txtTamanho_' + arrayTamanhos[i]).val(preco);
                }
            }

        });

        $('#tabelaGrade').on('dblclick', '.txtTamanhos', function () {
            const colunaTamanho = $($('#tabelaGrade').DataTable().columns().header()[$(this).closest('td')[0].cellIndex]).html();
            const inputTamanhos = $('#txtTamanho').val();
            const arrayTamanhos = inputTamanhos.split(',');
            if ($('#txtTamanho').val() === '') {
                $('#txtTamanho').val(colunaTamanho);
            } else if (arrayTamanhos.includes(colunaTamanho)) {
                return;
            } else {
                $('#txtTamanho').val(inputTamanhos + ',' + colunaTamanho)
            }
        });

        if (base64toBr != '' && base64toBr != 'r·µ') {
            if (await liberarRegistro('PRECOCORTAM', String(regiao) + String(codigo) + String(tipo)) == false) {
                window.location.href = '../precocortam';
            } else {
                carregaDados(codigo, regiao, tipo);
            }
        }

        async function carregaDados(codigoUrl, regiaoUrl, tipoUrl) {
            try {
                $.LoadingOverlay("show");
                try {

                    $('#txtProduto').prop('disabled', true);
                    $('#btnProduto').prop('disabled', true);
                    $('#btnExcluiProduto').prop('disabled', true);
                    $('#btnExcluiTabPreco').prop('disabled', true);
                    $('#btnTabPreco').prop('disabled', true);
                    $('#txtTabPreco').prop('disabled', true);
                    $('#radioProduto').prop('disabled', true);
                    $('#radioMaterial').prop('disabled', true);

                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"],
                    "WHERE": ["REGIAO = '${regiaoUrl}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    let response2 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"],
                    "WHERE": ["CODIGO = '${codigoUrl}'"]}`, null);

                    if (!response2) {
                        return;
                    }
                    let jsonStr2 = await response2.json();
                    if (response2.status != 200) {
                        msgErro(jsonStr2.RESULT[0].mensagem);
                        return;
                    };

                    let response3 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"],
                    "WHERE": ["CODIGO = '${codigoUrl}'"]}`, null);

                    if (!response3) {
                        return;
                    }
                    let jsonStr3 = await response3.json();
                    if (response3.status != 200) {
                        msgErro(jsonStr3.RESULT[0].mensagem);
                        return;
                    };

                    insereValor('#txtTabPreco', jsonStr.RESULT[0][0].REGIAO, jsonStr.RESULT[0][0].DESCRICAO);

                    if (tipoUrl === 'M') {
                        insereValor('#txtProduto', jsonStr3.RESULT[0][0].CODIGO, jsonStr3.RESULT[0][0].DESCRICAO);
                        $('#radioMaterial').prop('checked', true);
                    } else {
                        insereValor('#txtProduto', jsonStr2.RESULT[0][0].CODIGO, jsonStr2.RESULT[0][0].DESCRICAO);
                        $('#radioProduto').prop('checked', true);
                    };

                    await filtraGrade();
                    await filtraGradePromo();

                    if ($('#radioMaterial').is(':checked')) {
                        $('#labelProduto').html('Material *');
                        $('#txtProduto').attr('placeholder', 'Material');
                        $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, [], [], [], saidaCampoCodigo);
                        $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO <> ''"]}`, 'Pesquisa Material', 'MATERIAL', saidaCampoCodigo);
                    } else {
                        $('#labelProduto').html('Produto *');
                        $('#txtProduto').attr('placeholder', 'Produto');
                        $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, [], [], [], saidaCampoCodigo);
                        $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO <> ''"]}`, 'Pesquisa Produto', 'PRODUTO', saidaCampoCodigo);
                    }

                    await saidaCampoCodigo();

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $(".submit").click(function () {
            return false;
        });
    });

    function montaJsonPreco() {
        const item = new Object();
        const arrGradePrecos = [];
        item.CODIGO = pegaChave('#txtProduto');
        item.REGIAO = pegaChave('#txtTabPreco');
        item.TIPO = $('#radioProduto').is(':checked') ? 'P' : 'M';

        for (let index = 0; index < $('#tabelaGrade').DataTable().rows().count(); index++) {
            const dados = $('#tabelaGrade').DataTable().row(index).data();

            let objGradePrecos = {};
            let arrayGrade = Object.entries(dados);

            let precos = [];

            for (let i = 0; i < arrayGrade.length; i++) {
                if (arrayGrade[i][0] == 'COR' || arrayGrade[i][0] == 'DESC_COR') {
                    if (arrayGrade[i][0] == 'COR') {
                        objGradePrecos.COR = arrayGrade[i][1];
                        const promoIni = $('.txtDtPromoIni_' + objGradePrecos.COR.replace('.', '_')).val() + 'T00:00:00Z';
                        const promoFim = $('.txtDtPromoFim_' + objGradePrecos.COR.replace('.', '_')).val() + 'T00:00:00Z';
                        objGradePrecos.DT_PROMOINI = promoIni;
                        objGradePrecos.DT_PROMOFIM = promoFim;
                    }
                }
                else {
                    const precoPorTam = {};
                    const tamanho = arrayGrade[i][0];
                    const cor = arrayGrade.find((props) => {
                        return props[0] === 'COR'
                    })[1];
                    precoPorTam.TAM = tamanho;
                    const preco = $('.txtTamanho_' + arrayGrade[i][0] + '.txtCor_' + cor.replace('.', '_')).val();
                    const precoPromo = $('.txtTamanhoPromo_' + arrayGrade[i][0] + '.txtCorPromo_' + cor.replace('.', '_')).val();
                    precoPorTam.PRECO = preco;
                    precoPorTam.PRECO_PROMO = precoPromo;
                    if (parseFloat(precoPorTam.PRECO_PROMO) > parseFloat(precoPorTam.PRECO)) {
                        msgAlerta('Preço promocional não pode ser maior que o preço normal.')
                        return;
                    }
                    precos.push(precoPorTam);

                }
            }
            objGradePrecos.PRECOS = precos;

            arrGradePrecos.push(objGradePrecos);
        }
        item.GRADE_PRECOS = arrGradePrecos;
        return item;
    }

    async function gravarPreco() {
        if ($('#txtTabPreco').val() == '') {
            msgAlerta('Preencha o campo Tabela de Preço.');
            setTimeout(function () {
              $('#txtTabPreco').focus();
            }, 2000);
            return;
          } else if (!$('#txtProduto').val()) {
            msgAlerta('Preencha o campo Produto.');
            setTimeout(function () {
              $('#txtProduto').focus();
            }, 2000);
            return;}

        try {
            try {
                const jsonPrecos = montaJsonPreco();

                if (jsonPrecos === '' || jsonPrecos === undefined) {
                    return;
                }

                const response = await requisicao('POST', '/Sisplan/cadastros/v1/precocortam?', '', JSON.stringify(jsonPrecos), 15000);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                toastr.success(
                    'Cadastro efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/precocortam`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
                limpaCampos();

            } finally {
                $.LoadingOverlay("hide");
            }

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os preços para o produto/material informado!`);
        }
    };

    async function limpaCampos() {
        try {
            $.LoadingOverlay("show");
            $('#txtTabPreco').val('');
            $('#txtProduto').val('');
            $('#txtCor').val('');
            $('#txtTamanho').val('');
            $('#txtPreco').val('');
            $('#tabelaGrade').DataTable().clear().draw(false);
            $('#tabelaGrade').DataTable().columns.adjust().draw(false);
            $('#tabelaPromo').DataTable().clear().draw(false);
            $('#tabelaPromo').DataTable().columns.adjust().draw(false);

        } finally {
            $.LoadingOverlay('hide');
        }
    };

});