$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#conteudo',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#tipo',
                popover: {
                    title: 'Tipo',
                    description: 'Neste campo você irá selecionar o tipo de cadastro, produto ou material.',
                    position: 'top'
                }
            },
            {
                element: '#txtTabPreco',
                popover: {
                    title: 'Tabela de Preço',
                    description: 'Aqui, selecionamos a tabela de preço que será cadastrado os valores, podemos consultar clicando na lupa.',
                    position: 'top'
                }
            },
            {
                element: '#txtProduto',
                popover: {
                    title: 'Produto ou Material',
                    description: 'Este campo altera de acordo o cadastro, se for produto ou material, poderá consultar pela lupa e selecionar o mesmo para cadastrar o valor.',
                    position: 'top'
                }
            },
            {
                element: '#txtParcela01',
                popover: {
                    title: 'Preço',
                    description: 'Aqui ficarão os valores.',
                    position: 'top'
                }
            },
            {
                element: '#checkPromo',
                popover: {
                    title: 'Promoção',
                    description: 'Ao selecionar o flag promoção, irá aparecer os campos de preço promocional, data de início e final da promoção.',
                    position: 'top'
                }
            },
            {
                element: '#precos',
                popover: {
                    title: 'Outros Valores',
                    description: 'Aqui ficam os outros valores para serem cadastrados.',
                    position: 'top'
                }
            },
            {
                element: '#tabelaPrecos',
                popover: {
                    title: 'Preços Cadastrados',
                    description: 'Os itens cadastrados apareceram na tabela.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar o preço.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let base64toBr = atob(parametros[parametros.length - 1]).split('/');
    let produto = base64toBr[1];
    let preco = base64toBr[0];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PRECO', getCookie('usuario'), atob(parametros[5]).replace('/', ''));
        window.location.href = `${BASE_URI}/preco`;
    });

    $('#tabelaPrecos').DataTable({
        paging: false,
        filter: false,
        info: false,
        ordering: true,
        destroy: true,
        scrollY: "380px",
        scrollCollapse: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }

        },
        "columnDefs": [
            {
                "targets": [0],
                "visible": false
            },
            {
                "width": "50%", "targets": [3]
            }
        ]
    });

    $(document).ready(async function () {
        const parametrosSistema = await BuscaParametrosSistema('S');
        const quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
        const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;

        $(function () {

            $('#txtParcela01').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela02').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela03').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela04').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela05').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela06').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela07').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela08').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela09').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela10').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela11').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela12').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtParcela13').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtDescMax').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
            $('#txtComMin').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
            $('#txtComMax').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
            $('#txtQtdeDe').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
            $('#txtQtdeAte').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
            $('#txtPrecoPromo').maskMoney({
                decimal: '.',
                thousands: '',
                precision: quantidadeCasasDecimaisCampo
            });
        });

        $("#btnGravar").click(function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                gravarPreco();
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtTabPreco: {
                    required: true,
                },
                txtProduto: {
                    required: true,
                },
                txtParcela01: {
                    required: true,
                }
            },
            messages: {
                txtTabPreco: {
                    required: "Informe uma tabela de preço válida.",
                },
                txtProduto: {
                    required: "Informe um produto válido."
                },
                txtParcela01: {
                    required: "Informe um preço válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
        $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

        $('#btnTabPreco').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'regiao');
        $('#btnExcluiTabPreco').on('click', function () {
            $('#txtTabPreco').val('');
        });

        $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['DESCRICAO', 'CODIGO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}', 'Pesquisa de Produto');

        $('#btnExcluiProduto').on('click', function () {
            $('#txtProduto').val('');
        });

        $('#radioProduto, #radioMaterial').on('change', async function () {
            $('#btnProduto').unbind();
            if ($('#radioMaterial').is(':checked')) {
                $('#labelProduto').html('Material *');
                $('#txtProduto').attr('placeholder', 'Material');
                $('#txtProduto').val('');
                $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
                $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
                    "tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'material');
            } else {
                $('#labelProduto').html('Produto *');
                $('#txtProduto').attr('placeholder', 'Produto');
                $('#txtProduto').val('');
                $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
                $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['DESCRICAO', 'CODIGO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}', 'Pesquisa de Produto');
            }
            $('#txtProduto').blur(async function () {
                await precoExiste();
            });
        });

        if (base64toBr != '' && base64toBr != 'r·µ') {
            if (await liberarRegistro('PRECO', String(preco) + String(produto)) == false) {
                window.location.href = '../preco';
            } else {
                carregaDados(produto, preco);
            }
        }

        async function precoExiste() {
            if ($('#txtTabPreco').val() != '') {
                produto = pegaChave($('#txtProduto').val());
                preco = pegaChave($('#txtTabPreco').val());
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                                "tabela":"tabpreco", 
                                "camposSelect":["preco_00"], 
                                "where": ["codigo = '${produto}' and regiao = '${preco}'"]}`, null);
                    let jsonStr = await response.json();
                    const valor = jsonStr.RESULT[0][0].PRECO_00 ?? 0;
                    if (valor > 0) {
                        carregaDados(produto, preco);
                    }
                } catch (error) {
                    await limpaCampoNaSaidaDoProduto();
                    console.error(error);
                }
            }
        }

        $('#txtProduto').blur(async function () {
            await precoExiste();
        });

        async function carregaDados(produtoUrl, precoUrl) {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"tabpreco", 
                            "camposSelect":["preco_00", "preco_07", "preco_14", "preco_21", "preco_28", "preco_35", "preco_42", "preco_49", "preco_56", "preco_63", "preco_70", "preco_77", "preco_84", "DESC_MAX", "COM_MIN", "COM_MAX", "QTDE_DE", "QTDE_ATE", "dt_promofim", "dt_promoini", "preco_promo", "codigo", "desc_produto", "regiao", "descricao", "promocao"], 
                            "where": ["codigo = '${produtoUrl}' and regiao = '${precoUrl}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    parseFloat($('#txtParcela01').val(jsonStr.RESULT[0][0].PRECO_00));
                    parseFloat($('#txtParcela02').val(jsonStr.RESULT[0][0].PRECO_07));
                    parseFloat($('#txtParcela03').val(jsonStr.RESULT[0][0].PRECO_14));
                    parseFloat($('#txtParcela04').val(jsonStr.RESULT[0][0].PRECO_21));
                    parseFloat($('#txtParcela05').val(jsonStr.RESULT[0][0].PRECO_28));
                    parseFloat($('#txtParcela06').val(jsonStr.RESULT[0][0].PRECO_35));
                    parseFloat($('#txtParcela07').val(jsonStr.RESULT[0][0].PRECO_42));
                    parseFloat($('#txtParcela08').val(jsonStr.RESULT[0][0].PRECO_49));
                    parseFloat($('#txtParcela09').val(jsonStr.RESULT[0][0].PRECO_56));
                    parseFloat($('#txtParcela10').val(jsonStr.RESULT[0][0].PRECO_63));
                    parseFloat($('#txtParcela11').val(jsonStr.RESULT[0][0].PRECO_70));
                    parseFloat($('#txtParcela12').val(jsonStr.RESULT[0][0].PRECO_77));
                    parseFloat($('#txtParcela13').val(jsonStr.RESULT[0][0].PRECO_84));
                    parseFloat($('#txtDescMax').val(jsonStr.RESULT[0][0].DESC_MAX));
                    parseFloat($('#txtComMin').val(jsonStr.RESULT[0][0].COM_MIN));
                    parseFloat($('#txtComMax').val(jsonStr.RESULT[0][0].COM_MAX));
                    parseFloat($('#txtQtdeDe').val(jsonStr.RESULT[0][0].QTDE_DE));
                    parseFloat($('#txtQtdeAte').val(jsonStr.RESULT[0][0].QTDE_ATE));


                    parseFloat($('#txtPrecoPromo').val(jsonStr.RESULT[0][0].PRECO_PROMO));
                    $('#dataIni').val(jsonStr.RESULT[0][0].DT_PROMOINI ? jsonStr.RESULT[0][0].DT_PROMOINI.slice(0, 10) : '');
                    $('#dataFim').val(jsonStr.RESULT[0][0].DT_PROMOFIM ? jsonStr.RESULT[0][0].DT_PROMOFIM.slice(0, 10) : '');

                    insereValor('#txtTabPreco', jsonStr.RESULT[0][0].REGIAO, jsonStr.RESULT[0][0].DESCRICAO);
                    insereValor('#txtProduto', jsonStr.RESULT[0][0].CODIGO, jsonStr.RESULT[0][0].DESC_PRODUTO);

                    if (jsonStr.RESULT[0][0].PROMOCAO == 'S') {
                        $('#checkPromo').prop('checked', true);
                        $('#classeDNone').removeClass('d-none');
                    };

                    if (jsonStr.RESULT[0][0].PROMOCAO == 'N') {
                        $('#checkPromo').prop('checked', false);
                        $('#classeDNone').addClass('d-none');
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#checkPromo').on('click', async function () {
        if ($('#checkPromo').prop('checked')) {
            $('#checkPromo').attr('checked', true);
            $('#classeDNone').removeClass('d-none');
        } else {
            $('#checkPromo').attr('checked', false);
            $('#classeDNone').addClass('d-none');
        }
    });

    async function gravarPreco() {
        try {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            let arrayVazios = [];
            let arrayPreenchidos = [];
            for (let i = 1; i <= 13; i++) {
                if (i < 10) {
                    if ($(`#txtParcela0${i}`).val() == '') {
                        arrayVazios.push(i);
                    } else {
                        arrayPreenchidos.push(i);
                    }
                } else if ($(`#txtParcela${i}`).val() == '') {
                        arrayVazios.push(i);
                    } else {
                        arrayPreenchidos.push(i);
                    }
            }
            if (arrayVazios[0] < arrayPreenchidos[arrayPreenchidos.length - 1]) {
                msgAlerta('Existem parcelas em branco entre parcelas preenchidas, favor verificar.');
                erros = 1;
            }

            if (erros == 0) {

                if (String($('#txtParcela01').val()).length < 11) {

                    $.LoadingOverlay("show");

                    let precoClasse = {};

                    precoClasse.REGIAO = pegaChave($('#txtTabPreco').val(), precoClasse.REGIAO);
                    precoClasse.DESCRICAO = pegaDescricao($('#txtTabPreco').val(), precoClasse.DESCRICAO);
                    precoClasse.CODIGO = pegaChave($('#txtProduto').val(), precoClasse.CODIGO);
                    precoClasse.DESC_PRODUTO = pegaDescricao($('#txtProduto').val(), precoClasse.DESC_PRODUTO);
                    precoClasse.PRECO_00 = parseFloat($('#txtParcela01').val().replace(',', '.'));
                    precoClasse.PRECO_07 = parseFloat($('#txtParcela02').val().replace(',', '.'));
                    precoClasse.PRECO_14 = parseFloat($('#txtParcela03').val().replace(',', '.'));
                    precoClasse.PRECO_21 = parseFloat($('#txtParcela04').val().replace(',', '.'));
                    precoClasse.PRECO_28 = parseFloat($('#txtParcela05').val().replace(',', '.'));
                    precoClasse.PRECO_35 = parseFloat($('#txtParcela06').val().replace(',', '.'));
                    precoClasse.PRECO_42 = parseFloat($('#txtParcela07').val().replace(',', '.'));
                    precoClasse.PRECO_49 = parseFloat($('#txtParcela08').val().replace(',', '.'));
                    precoClasse.PRECO_56 = parseFloat($('#txtParcela09').val().replace(',', '.'));
                    precoClasse.PRECO_63 = parseFloat($('#txtParcela10').val().replace(',', '.'));
                    precoClasse.PRECO_70 = parseFloat($('#txtParcela11').val().replace(',', '.'));
                    precoClasse.PRECO_77 = parseFloat($('#txtParcela12').val().replace(',', '.'));
                    precoClasse.PRECO_84 = parseFloat($('#txtParcela13').val().replace(',', '.'));
                    precoClasse.DESC_MAX = parseFloat($('#txtDescMax').val().replace(',', '.'));
                    precoClasse.COM_MIN = parseFloat($('#txtComMin').val().replace(',', '.'));
                    precoClasse.COM_MAX = parseFloat($('#txtComMax').val().replace(',', '.'));
                    precoClasse.QTDE_DE = parseFloat($('#txtQtdeDe').val().replace(',', '.'));
                    precoClasse.QTDE_ATE = parseFloat($('#txtQtdeAte').val().replace(',', '.'));

                    if ($('#checkPromo').prop('checked')) {
                        precoClasse.PROMOCAO = 'S';
                        precoClasse.PRECO_PROMO = parseFloat($('#txtPrecoPromo').val().replace(',', '.'));
                        precoClasse.DT_PROMOINI = $('#dataIni').val();
                        precoClasse.DT_PROMOFIM = $('#dataFim').val();
                    } else {
                        precoClasse.PROMOCAO = 'N';
                    }

                    precoClasse.TIPO = $('#radioProduto').is(':checked') ? 'P' : 'M';

                    if (precoClasse.TIPO == 'P') {
                        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"produto", 
                            "camposSelect":["colecao"], 
                            "where": ["codigo = '${precoClasse.CODIGO}'"]}`, null);
                        let jsonStr = await response.json();
                        precoClasse.COLECAO = jsonStr.length > 0 ? jsonStr.RESULT[0][0].COLECAO : "00";
                        precoClasse.GRUPO_COR = '00';
                    } else {
                        precoClasse.GRUPO_COR = '0';
                        precoClasse.COLECAO = '00';
                    }

                    let response1 = await requisicao('POST', '/Sisplan/Cadastros/v1/preco?', `JSON=${encodeURIComponent(JSON.stringify(precoClasse))}`, null);

                    if (!response1) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr1 = await response1.json();
                    if (response1.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr1.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                    limpaCampos();

                } else {
                    msgAlerta('Número de caracteres informados maior que o permitido.');
                }
            }

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da região: ${error}`);
        }

    };

    async function limpaCampoNaSaidaDoProduto() {
        $('#txtParcela01').val('');
        $('#txtParcela02').val('');
        $('#txtParcela03').val('');
        $('#txtParcela04').val('');
        $('#txtParcela05').val('');
        $('#txtParcela06').val('');
        $('#txtParcela07').val('');
        $('#txtParcela08').val('');
        $('#txtParcela09').val('');
        $('#txtParcela10').val('');
        $('#txtParcela11').val('');
        $('#txtParcela12').val('');
        $('#txtParcela13').val('');
        $('#txtDescMax').val('');
        $('#txtComMin').val('');
        $('#txtComMax').val('');
        $('#txtQtdeDe').val('');
        $('#txtQtdeAte').val('');
        $('#txtPrecoPromo').val('');
        $('#dataIni').val('');
        $('#dataFim').val('');
        $('#checkPromo').prop('checked', false);
    }

    async function limpaCampos() {
        try {
            $.LoadingOverlay("show");
            let tabpreco = pegaChave('#txtTabPreco');
            let produtocod = pegaChave('#txtProduto');
            let produtotab = pegaDescricao('#txtProduto');
            let precoprod = $('#txtParcela01').val();
            let ordem = $('#tabelaPrecos').DataTable().rows().count();
            $('#tabelaPrecos').DataTable().row.add([ordem, tabpreco, produtocod, produtotab, precoprod]).order([0, 'desc']).draw(false);

            $('#txtParcela01').val('');
            $('#txtParcela02').val('');
            $('#txtParcela03').val('');
            $('#txtParcela04').val('');
            $('#txtParcela05').val('');
            $('#txtParcela06').val('');
            $('#txtParcela07').val('');
            $('#txtParcela08').val('');
            $('#txtParcela09').val('');
            $('#txtParcela10').val('');
            $('#txtParcela11').val('');
            $('#txtParcela12').val('');
            $('#txtParcela13').val('');
            $('#txtDescMax').val('');
            $('#txtComMin').val('');
            $('#txtComMax').val('');
            $('#txtQtdeDe').val('');
            $('#txtQtdeAte').val('');
            $('#txtPrecoPromo').val('');
            $('#dataIni').val('');
            $('#dataFim').val('');
            $('#txtProduto').val('');

        } finally {
            $.LoadingOverlay('hide');
        }
    };

});