$(document).ready(async function () {
  await adicionaPesquisa();

  async function adicionaPesquisa() {
    $('#txtCEPPersonalizado').autocompleta(1, `JSON={ "tabela":"CADCEP", "camposSelect":["CEP CHAVE, NOMCEP DESCRICAO"], "where": null}`);
    $('#btn-CEPPersonalizado').pesquisa('#txtCEPPersonalizado', 'CEP', 'NOMCEP', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCEP", "camposSelect":[ "CEP", "NOMCEP" ], "where": null}', 'Pesquisa CEP', 'CADCEP');
    $('#btn-limpa-CEPPersonalizado').on('click', function () { $('#txtCEPPersonalizado').val('') });
  }

  $('#tabelaPedido').on('click', '#btn-editar-entrega', async function () {
    event.preventDefault();
    const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
    const qtde = await buscaValor('PED_ITEN', 'SUM(QTDE) QTDE', 'NUMERO', data.PEDIDO);
    if (qtde.QTDE > 0) {
      const dadosPedido = await buscaValor('PEDIDO', 'CLI_CEP', 'NUMERO', data.PEDIDO);
      insereValor('#dtAlteraEntrega', data.DT_ENTREGA.slice(0, 10));
      insereValor('#numeroPedido', data.PEDIDO, data.PEDIDO);
      insereValor('#txtCEPEntrega', dadosPedido.CLI_CEP, dadosPedido.CLI_CEP);
      $('#labelPedido').text(`Pedido: ${data.PEDIDO} | Cliente: ${data.CLIENTE}`);
      await buscaDadosEntrega();
      $('#modalEditarDtEntrega').modal('show');
    } else {
      msgAlerta('Pedido sem quantidade pendente. Impossível continuar!')
    }
  })

  $('#gravarDadosEntrega').on('click', async function () {
    await gravaAlteracaoPedido();
  });

  $('#txtCEPPersonalizado').on('focusout', async function () {
    if (pegaChave(this) != '') {
      await buscaDadosCep(pegaChave(this));
    }
  });

  async function buscaDadosCep(cep) {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/cep/v1/cep?';
      const filtros = `CEP=${cep}`;
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        return;
      }

      insereValor('#txtEnderecoPersonalizado', jsonStr.nOMCEP);
      insereValor('#txtNumeroPersonalizado', '');
      insereValor('#txtBairroPersonalizado', jsonStr.bAIRRO);
      insereValor('#txtComplementoPersonalizado', '');
      insereValor('#txtCidadeEstadoPersonalizado', jsonStr.nOMCIDADE + ' / ' + jsonStr.eSTCEP);
    } catch (error) {
      msgErro('Erro na rotina buscaDadosCep: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function gravaAlteracaoPedido() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pedidob2b/v1/dadosentregapedido?';
      const filtros = `PEDIDO=${pegaChave('#numeroPedido')}&ENTREGA=${pegaValor('#dtAlteraEntrega')}`
      const pedido = retornaObjeto();
      const response = await requisicao('POST', url, filtros, `JSON=${encodeURIComponent(JSON.stringify(pedido))}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      $('#modalEditarDtEntrega').modal('hide');
      $(`#btnConsultar`).trigger('click');
      criaMensagemSucesso(`Alterado a data de entrega com sucesso!`);
    } catch (error) {
      msgErro('Erro na rotina gravaAlteracaoPedido: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function retornaObjeto() {
    const retorno = {
      Cli_cep: pegaChave('#txtCEPPersonalizado'),
      Cli_end: pegaValor('#txtEnderecoPersonalizado'),
      Cli_num: pegaValor('#txtNumeroPersonalizado'),
      Cli_compl: pegaValor('#txtComplementoPersonalizado'),
      Cli_bairro: pegaValor('#txtBairroPersonalizado'),
      Cli_ddd: pegaValor('#txtDDD'),
      Cli_fone: pegaValor('#txtTelefone'),
      Cli_recebedor: pegaValor('#txtRecebedor')
    };

    if (isChecked('#radioEndEntidade')) {
      retorno.Cli_cep = pegaValor('#txtCep');
      retorno.Cli_end = pegaValor('#txtEndereco');
      retorno.Cli_num = pegaValor('#txtNumero');
      retorno.Cli_compl = pegaValor('#txtComplemento');
      retorno.Cli_bairro = pegaValor('#txtBairro');
    } else if (isChecked('#radioEntregaEntidade')) {
      retorno.Cli_cep = pegaValor('#txtCepEntrega');
      retorno.Cli_end = pegaValor('#txtEnderecoEntrega');
      retorno.Cli_num = pegaValor('#txtNumeroEntrega');
      retorno.Cli_compl = pegaValor('#txtComplementoEntrega');
      retorno.Cli_bairro = pegaValor('#txtBairroEntrega');
    } else if (isChecked('#radioCobrancaEntidade')) {
      retorno.Cli_cep = pegaValor('#txtCepCobranca');
      retorno.Cli_end = pegaValor('#txtEnderecoCobranca');
      retorno.Cli_num = pegaValor('#txtNumeroCobranca');
      retorno.Cli_compl = pegaValor('#txtComplementoCobranca');
      retorno.Cli_bairro = pegaValor('#txtBairroCobranca');
    }

    return retorno;
  }

  async function buscaDadosEntrega() {
    $.LoadingOverlay('show');
    try {
      const url = '/sisplan/pedidob2b/v1/dadosentregapedido?';
      const filtros = `PEDIDO=${pegaChave('#numeroPedido')}`
      const response = await requisicao('GET', url, filtros);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const complemento = jsonStr[0].COMPLEMENTO != '' ? `- ${jsonStr[0].COMPLEMENTO}` : '';
      $('#txtEndereco').val(`${jsonStr[0].ENDERECO}, ${jsonStr[0].NUMERO} ${complemento}`);
      $('#txtComplemento').val(jsonStr[0].COMPLEMENTO);
      $('#txtNumero').val(jsonStr[0].NUMERO);
      $('#txtBairro').val(jsonStr[0].BAIRRO);
      $('#txtCep').val(jsonStr[0].CEP);
      $('#txtCidadeEstado').val(jsonStr[0].CIDADE_NOME + ' / ' + jsonStr[0].COD_UF);

      const complementoEntrega = jsonStr[0].COMP_ENT != '' ? `- ${jsonStr[0].COMP_ENT}` : '';
      $('#txtEnderecoEntrega').val(`${jsonStr[0].END_ENT}, ${jsonStr[0].NUM_ENT} ${complementoEntrega}`);
      $('#txtComplementoEntrega').val(jsonStr[0].COMP_ENT);
      $('#txtNumeroEntrega').val(jsonStr[0].NUM_ENT);
      $('#txtBairroEntrega').val(jsonStr[0].BAIRRO_ENT);
      $('#txtCepEntrega').val(jsonStr[0].CEP_ENT);
      $('#txtCidadeEstadoEntrega').val(jsonStr[0].CIDADE_NOME_ENT + ' / ' + jsonStr[0].COD_UF_ENT);

      const complementoCobranca = jsonStr[0].COMP_COB != '' ? `- ${jsonStr[0].COMP_COB}` : '';
      $('#txtEnderecoCobranca').val(`${jsonStr[0].END_COB}, ${jsonStr[0].NUM_COB} ${complementoCobranca}`);
      $('#txtComplementoCobranca').val(jsonStr[0].COMP_COB);
      $('#txtNumeroCobranca').val(jsonStr[0].NUM_COB);
      $('#txtBairroCobranca').val(jsonStr[0].BAIRRO_COB);
      $('#txtCepCobranca').val(jsonStr[0].CEP_COB);
      $('#txtCidadeEstadoCobranca').val(jsonStr[0].CIDADE_NOME_COB + ' / ' + jsonStr[0].COD_UF_COB);

      $('#txtEnderecoPersonalizado').val(jsonStr[0].CLI_END);
      $('#txtNumeroPersonalizado').val(jsonStr[0].CLI_NUM);
      $('#txtBairroPersonalizado').val(jsonStr[0].CLI_BAIRRO);
      $('#txtComplementoPersonalizado').val(jsonStr[0].CLI_COMPL);
      $('#txtCEPPersonalizado').val('');
      if (jsonStr[0].CLI_CEP != '') {
        insereValor('#txtCEPPersonalizado', jsonStr[0].CLI_CEP, jsonStr[0].CIDADE_NOME_PED);
      }
      $('#txtCidadeEstadoPersonalizado').val(jsonStr[0].CIDADE_NOME_PED + ' / ' + jsonStr[0].COD_UF_PED);

      $('#txtDDD').val(jsonStr[0].CLI_DDD);
      $('#txtTelefone').val(jsonStr[0].CLI_FONE);
      $('#txtInscricao').val(jsonStr[0].INSCRICAO);
      $('#txtRecebedor').val(jsonStr[0].CLI_RECEBEDOR);
      $('#radioPersonalizadoEntidade').prop('checked', jsonStr[0].CLI_CEP != '');
    } catch (error) {
      msgErro('Erro na rotina buscaDadosEntrega: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
    }
  }
});