<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Pedido</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.245.9.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.245.9.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.245.9.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.245.9.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.245.9.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.245.9.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.245.9.1">
  <style>
    #tabelaMaquinaCartao td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaMaquinaCartao td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #modalPesquisaPedido div {
      z-index: 999 !important;
    }

    #tabelaPedido td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaPedido td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .thPedido {
      width: 10%;
    }

    .dropdown {
      text-align: left;
    }

    ;
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div class="modal fade" id="modalDuplicarPedido" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Duplicar Pedido</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="group-default form-group col-6">
                <label for="txtPedidoOrigem">Pedido de Origem</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" aria-describedby="ufError" disabled id="txtPedidoOrigem" name="txtPedidoOrigem" class="form-control" placeholder="Pedido Origem">
                </div>
              </div>
              <div class="group-default form-group col-6">
                <label for="txtPedidoDestino">Novo Pedido</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" aria-describedby="ufError" id="txtPedidoDestino" name="txtPedidoDestino" class="form-control" placeholder="Novo Pedido">
                </div>
              </div>
              <div class="col-12" id="ClienteDestino">
                <label data-error="wrong" data-success="right" for="txtClienteDestino">Cliente: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteDestino" name="txtClienteDestino" class="form-control" placeholder="Cliente Destino">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClienteDestino" name="btnClienteDestino" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClienteDestino" name="btnLimpaClienteDestino" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-12" id="StatusDestino">
                <label data-error="wrong" data-success="right" for="txtStatusDestino">Status: </label>
                <div class="input-group">
                  <input type="text" autocomplete="off" class="input-default focus form-control" id="txtStatusDestino" name="txtStatusDestino" class="form-control" placeholder="Status Destino">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnStatusDestino" name="btnStatusDestino" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaStatusDestino" name="btnLimpaStatusDestino" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <!-- <div class="row form-group" style="margin-left: 5%; margin-top: 5%;">
                <div class="col-lg-6" style="border-right: 1px solid white">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAC"><label class="labelCheck" for="checkAC">Colocar Faturado como Pendente</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAL"><label class="labelCheck" for="checkAL">Não duplicar Itens Cancelados</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAM"><label class="labelCheck" for="checkAM">Colocar Cancelado como Pendente</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkAP"><label class="labelCheck" for="checkAP">Duplicar somente itens pendentes</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkBA"><label class="labelCheck" for="checkBA">Manter InfoAdProd dos Itens</label></div>
                </div>
                <div class="col-lg-6">
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkCE"><label class="labelCheck" for="checkCE">Não duplicar Fluxo (Pedido4)</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkDF"><label class="labelCheck" for="checkDF">Duplicar somente itens faturados</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkES"><label class="labelCheck" for="checkES">Não duplicar Agendamento (Pedido4)</label></div>
                  <div class="icheck-primary"><input type="checkbox" class="configCheck" id="checkEX"><label class="labelCheck" for="checkEX">Duplicar quantidade original do pedido</label></div>
                </div>
              </div> -->
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
            <button type="button" id="btnDuplicarPedido" class="btn btn-primary">Duplicar</button>
          </div>
        </div>
      </div>
    </div>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Pedido</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid" id="divTabelaPedido">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button id="btnImprimir" class="btn-sisp btn btn-success"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de pedidos</h5>
              <table id="tabelaPedido" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm thPedido">Pedido
                    </th>
                    <th class="th-sm">Cliente
                    </th>
                    <th class="th-sm">Financeiro
                    </th>
                    <th class="th-sm">Comercial
                    </th>
                    <th class="th-sm">Representante
                    </th>
                    <th class="th-sm">Transportadora
                    </th>
                    <th class="th-sm">Data_Emissao
                    </th>
                    <th class="th-sm">Data_Entrega
                    </th>
                    <th class="th-sm">Ped_Cliente
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>

      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiDe">Data Cadastro De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaDe">Data Entrega De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEntregaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaDe">Data Fatura De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataFaturaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaDe">Data Saída De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataSaidaDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEmiAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataEntregaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEntregaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataFaturaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataFaturaAte" name="DataAte">
                  </div>
                </div>
                <div class="group-default form-group col-3">
                  <label for="txtDataSaidaAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataSaidaAte" name="DataAte">
                  </div>
                </div>
              </div>

              <div class="row">

                <div class="col-lg-9">
                  <label data-error="wrong" data-success="right" for="txtPedidoConsulta">Pedido </label>
                  <div class="input-group col-12" style="padding-left: 0px;">
                    <input type="text" class="input-default col-lg-2 col-12 focus form-control" id="txtPedidoConsulta" name="txtPedidoConsulta" class="form-control" placeholder="Pedido">
                    <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <input type="text" id="txtListaPedidos" class="form-group col-lg-12 col-12 input-default focus form-control" placeholder="Lista de Pedidos" disabled>
                    <button class="btn bg-danger" id="btn-limpa-PedidoConsulta" name="btn-limpa-PedidoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>

                <div class="col-lg-3 pl-5 pt-4">
                  <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="ClienteConsulta">
                  <label data-error="wrong" data-success="right" for="txtClienteConsulta">Cliente </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteConsulta" name="txtClienteConsulta" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ClienteConsulta" name="btn-ClienteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ClienteConsulta" name="btn-limpa-ClienteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="RepresentanteConsulta">
                  <label data-error="wrong" data-success="right" for="txtRepresentanteConsulta">Representante </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresentanteConsulta" name="txtRepresentanteConsulta" class="form-control" placeholder="Representante">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-RepresentanteConsulta" name="btn-RepresentanteConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-RepresentanteConsulta" name="btn-limpa-RepresentanteConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="StatusConsulta">
                  <label data-error="wrong" data-success="right" for="txtStatusConsulta">Status </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtStatusConsulta" name="txtStatusConsulta" class="form-control" placeholder="Status">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-StatusConsulta" name="btn-StatusConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-StatusConsulta" name="btn-limpa-StatusConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="TabPrecoConsulta">
                  <label data-error="wrong" data-success="right" for="txtTabPrecoConsulta">Tabela de Preço </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTabPrecoConsulta" name="txtTabPrecoConsulta" class="form-control" placeholder="Tabela de preço">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TabPrecoConsulta" name="btn-TabPrecoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TabPrecoConsulta" name="btn-limpa-TabPrecoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="ColecaoConsulta">
                  <label data-error="wrong" data-success="right" for="txtColecaoConsulta">Coleção </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtColecaoConsulta" name="txtColecaoConsulta" class="form-control" placeholder="Coleção">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ColecaoConsulta" name="btn-ColecaoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ColecaoConsulta" name="btn-limpa-ColecaoConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtOrdemImpressao">Ordem Impressão</label>
                  <div class="input-group">
                    <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdemImpressao" class="custom-select">
                    </select>
                  </div>
                </div>

              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="col-4" id="GrupoPedConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoPedConsulta">Grupo Pedido </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoPedConsulta" name="txtGrupoPedConsulta" class="form-control" placeholder="Grupo pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoPedConsulta" name="btn-GrupoPedConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoPedConsulta" name="btn-limpa-GrupoPedConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="GrupoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtGrupoProdConsulta">Grupo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoProdConsulta" name="txtGrupoProdConsulta" class="form-control" placeholder="Grupo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoProdConsulta" name="btn-GrupoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoProdConsulta" name="btn-limpa-GrupoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4" id="TipoProdConsulta">
                  <label data-error="wrong" data-success="right" for="txtTipoProdConsulta">Tipo Produto </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtTipoProdConsulta" name="txtTipoProdConsulta" class="form-control" placeholder="Tipo produto">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-TipoProdConsulta" name="btn-TipoProdConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-TipoProdConsulta" name="btn-limpa-TipoProdConsulta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-4">
                  <label for="">Financeiro: </label>
                  <div class="relative">
                    <select name="" id="txtBloqFinConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-4">
                  <label for="">Comercial: </label>
                  <div class="relative">
                    <select name="" id="txtBloqComConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="1">Liberados</option>
                      <option value="0">Bloqueados</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-4">
                  <label for="">Situação: </label>
                  <div class="relative">
                    <select name="" id="txtSituacaoConsulta" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="P">Pendentes</option>
                      <option value="F">Faturados</option>
                    </select>
                  </div>
                </div>
              </div>

            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div id="modalAntecipacao" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Antecipação</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="row">

                <div class="col-2">
                  <label data-error="wrong" data-success="right" for="txtPedidoAnte">Pedido </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtPedidoAnte" name="txtPedidoAnte" class="form-control" placeholder="Pedido">
                  </div>
                </div>

                <div class="col-5">
                  <label data-error="wrong" data-success="right" for="txtClienteAnte">Cliente </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtClienteAnte" name="txtClienteAnte" class="form-control" placeholder="Cliente">
                  </div>
                </div>

                <div class="col-5">
                  <label data-error="wrong" data-success="right" for="txtRepresenAnte">Representante </label>
                  <div class="input-group">
                    <input disabled type="text" autocomplete="off" class="input-default focus form-control" id="txtRepresenAnte" name="txtRepresenAnte" class="form-control" placeholder="Representante">
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;" style="margin-top: 1.2%;">

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtMoeda">Moeda *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Moeda" name="btn-Moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Moeda" name="btn-limpa-Moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtHistorico">Histórico *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Historico" name="btn-limpa-Historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ClasseGer" name="btn-limpa-ClasseGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;">

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtSituacao">Situação *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Situacao" name="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtConta">Conta *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Conta" name="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtBanco">Banco *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Banco" name="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
              <div class="row" style="margin-top: 1.2%;">

                <div class="col-sm-2">
                  <label>Emissão *</label>
                  <div class="relative" id="DataEmissao">
                    <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validatel" id="txtDTemissao" name="txtDTemissao">
                  </div>
                </div>

                <div class="col-sm-2">
                  <label>Vencimento *</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" autocomplete="off" class="input-default focus form-control validate" id="txtDTvencimento" name="txtDTvencimento">
                  </div>
                </div>

                <div class="col-sm-4">
                  <label data-error="wrong" data-success="right" for="txtCaixa">Caixa *</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-caixa" name="btn-caixa-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-caixa2" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-4">
                  <label data-error="wrong" data-success="right" for="txtValor">Valor *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
                  </div>
                </div>


              </div>

              <div class="row d-flex justify-content-end" style="margin-top: 1.2%;">
                <div class="col-4">
                  <label for="txtStatus">Status</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" placeholder="Status">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Status" name="btn-Status" data-button="absolute" type="button"> <i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Status" type="button"> <i class="m-0 p-0 fas fa-trash"></i> </button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row d-flex justify-content-end" style="margin-top: 1.2%;">
                <div id="LancaCC" class="col-4 d-flex align-items-center">
                  <input type="checkbox" id="cbNaoLancaCc" style="width: 20px; height: 20px; margin-right: 10px;" class="d-none">
                  <label for="cbNaoLancaCc" id="labelNaoLancaCc" style="margin-bottom: 0rem!important;" class="d-none">
                    Não lançar conta corrente
                  </label>
                </div>
              </div>

              <div class="d-none" id="cartao" style="margin-top: 1.2%;"><label data-error="wrong" data-success="right" for="txtNSU" style="font-size: 20px; margin-left: -6px;">Dados cartão</label>
                <div class="form-row">
                  <div class="col-md-3 col-12 px-0">
                    <label data-error="wrong" data-success="right" for="txtNSU">NSU</label>
                    <div class="input-group">
                      <input type="text" autocomplete="off" class="input-default focus form-control" id="txtNSU" name="txtNSU" class="form-control" placeholder="NSU">
                    </div>
                  </div>

                  <div class="col-md-3 col-12">
                    <label for="select_bandeira">Bandeira</label>
                    <div class="input-group">
                      <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                        <option value="" selected="selected">Selecione uma bandeira</option>
                      </select>
                    </div>
                  </div>

                  <div class="col-md-3 col-12 form-group">
                    <label data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Cond. Pagamento</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" placeholder="Condição de Pagamento">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-CondicaoDePagamento" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>

                  <div class="col-md-3 col-12">
                    <div class="group-default">
                      <label for="txtNrParcelas">Nr. Parcelas</label>
                      <div class="relative">
                        <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" value="1" name="txtNrParcelas" readonly>
                      </div>
                    </div>
                  </div>

                </div>
              </div>


            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-danger btn-sisp" id="btnConfirmarAnte">Confirmar</button>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.245.9.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.245.9.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.245.9.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.245.9.1"></script>
  <script src="dist/js/sisplan.js?versao=3.245.9.1"></script>
  <script src="utils/funcoes.js?versao=3.245.9.1"></script>
  <script src="utils/cookies.js?versao=3.245.9.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.245.9.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.245.9.1"></script>
  <script src="dist/js/driver.min.js?versao=3.245.9.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="config.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.245.9.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.245.9.1"></script>
  <script src="dist/js/jquery.mask.min.js?versao=3.245.9.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PEDIDO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/pedido/acesso_pedido/acesso_pedido.js?versao=3.245.9.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>