$('#tutorial').on('click', function () {
  $(document).ready(async function () {

    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
    });
    driver.defineSteps([{
      element: '#valortotalInfoTour',
      popover: {
        title: 'Total a Pagar',
        description: 'Aqui está informado o valor total a pagar',
        position: 'bottom',
      },
    },
    {
      element: '#valorPagoInfoTour',
      popover: {
        title: 'Total Pago',
        description: 'Aqui está informado o valor que já foi pago.',
        position: 'bottom',
      },
    },
    {
      element: '#saldoInfoTour',
      popover: {
        title: 'Saldo',
        description: 'Aqui está informado o saldo restante.',
        position: 'bottom',
      },
    },
    {
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os campos disponíveis de filtro.',
        position: 'bottom',
      },
    },
    {
      element: '#btn-novoPagar',
      popover: {
        title: 'Botão Novo',
        description: 'Clique aqui para incluir um novo registro a pagar.',
        position: 'bottom',
      },
    },
    {
      element: '#tabelaPagar',
      popover: {
        title: 'Dados Pagar',
        description: 'Aqui estão os dados conforme filtros utilizados.',
        position: 'top',
      },
    },
    ]);
    driver.start();
  });
});
jQuery(async function () {
  const campos = ['txtDataDe', 'txtDataAte', 'txtVenctoDe', 'dtBaixaDe', 'dtBaixaAte', 'txtVenctoAte', 'txtNum_ap', 'txtConsultaFornecedor', 'Status', 'txtSituacao']; //utilizado para salvar os filtros utilizados
  const permissaoUsuarioLogado = await permissaoAcessos("PAGAR");

  $('#txtDataDe').val('1200-01-01');
  $('#txtDataAte').val('2500-12-01');
  $('#txtVenctoDe').val('1200-01-01');
  $('#txtVenctoAte').val('2500-12-01');
  $('#dtBaixaDe').val('1200-01-01');
  $('#dtBaixaAte').val('2500-12-01');
  await setarDataAtual('txtDTPagamento');
  await setarDataAtual('txtDTContabilizacao');

  const FormatoDtNovo = 'DD/MM/YYYY';

  $('#checkTodasEmpresas').on('change', function () {
    if ($('#checkTodasEmpresas')[0].checked == true) {
      carregaEmpresasDisponiveis();
    }
  });

  await carregaValoresPadroes();
  restaurarFiltrosCache('filtrosAcessoPagar', campos);
  $('#btnConsultar').trigger('click');


  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btn-novoPagar').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "pagar/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });


  await preencheOrdenacaoTela('Pagar');

  $('#txtConsultaFornecedor').autocompleta(3, 'JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}');
  $('#txtHistorico').autocompleta(1, 'JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}');
  $('#txtConta').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO"], "where": null}');
  $('#txtClasse').autocompleta(1, 'JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}');

  $('#btn-ConsultaFornecedor').pesquisa('#txtConsultaFornecedor', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}', 'Pesquisa Fornecedor', 'entidade');
  $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}', 'Pesquisa Histórico', 'histcp');
  $('#btn-Conta').pesquisa('#txtConta', 'CONTA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}', 'Pesquisa Conta', 'CADCONTA');
  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}', 'Pesquisa Classe', 'classe_ger');

  $('#btn-limpa-ConsultaFornecedor').on('click', function () {
    $('#txtConsultaFornecedor').val('');
  });

  $('#btn-limpa-Historico').on('click', function () {
    $('#txtHistorico').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });
  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtNum_ap').val('');
    $('#txtConsultaFornecedor').val('');
    $('#txtDataDe').val('1200-01-01');
    $('#txtDataAte').val('2500-12-01');
    $('#txtVenctoDe').val('1200-01-01');
    $('#txtVenctoAte').val('2500-12-01');
    $('#dtBaixaDe').val('1200-01-01');
    $('#dtBaixaAte').val('2500-12-01');
    $('#Status').val('');
    $('#txtSituacao').val('');
    limparFiltrosCache('filtrosAcessoPagar');
  });

  async function buscaBaixas(sNumAp) {
    let url = '/sisplan/pagar/v1/baixaPagar?';
    let jsonStr = [];
    let response = '';
    try {
      response = await requisicao('GET', url, `NUM_AP=${sNumAp}`, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta('Não existem baixas cadastradas nessa AP');
    }
  }

  function atualizaTotais(filtro) {
    let valorTotal = 0;
    let valorPago = 0;
    let valorSaldo = 0;
    valorTotal = $('#tabelaPagar').DataTable().column(6, {
      search: filtro,
    }).data()
      .sum();
    valorPago = $('#tabelaPagar').DataTable().column(7, {
      search: filtro,
    }).data()
      .sum();

    valorSaldo = valorTotal - valorPago;

    $('#txt_val_total').html(parseFloat(valorTotal).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_pago').html(parseFloat(valorPago).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));

    $('#txt_val_saldo').html(parseFloat(valorSaldo).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL',
    }));
  }

  async function buscaPagar() {
    let url = '/sisplan/pagar/v1/Pagar?';
    let sNumAp = $('#txtNum_ap').val();
    let sSituacao = $('#txtSituacao').val();
    let sDTEmiI = moment($('#txtDataDe').val()).format('DD/MM/YYYY');
    let sDTEmiF = moment($('#txtDataAte').val()).format('DD/MM/YYYY');
    let sDtVenctoDe = moment($('#txtVenctoDe').val()).format('DD/MM/YYYY');
    let sDtVenctoAte = moment($('#txtVenctoAte').val()).format('DD/MM/YYYY');
    let dtBaixaDe = moment($('#dtBaixaDe').val()).format('DD/MM/YYYY');
    let dtBaixaAte = moment($('#dtBaixaAte').val()).format('DD/MM/YYYY');
    let sStatus = $('#Status').val();
    let sFornecedor = $('#txtConsultaFornecedor').val().substring(1, $('#txtConsultaFornecedor').val().indexOf('] - '));
    const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    let params = `NUM_AP=${sNumAp}&STATUS=${sStatus}&DT_EMISSAOI=${sDTEmiI}&DT_EMISSAOF=${sDTEmiF}&DT_VENCTOI=${sDtVenctoDe}&DT_VENCTOF=${sDtVenctoAte}&BAIXA_DE=${dtBaixaDe}&BAIXA_ATE=${dtBaixaAte}&SITUACAO=${sSituacao}&FORNECEDOR=${sFornecedor}&EMP_ID=${sEmpID}`;
    let jsonStr = [];
    let response = '';
    try {
      response = await requisicao('GET', url, params, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return await response.json();
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  }

  function retornaBotaoOpcoes(data) {
    return '<div style="text-align:left;"> '
      + '   <div class="dropdown"> '
      + '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> '
      + `      ${data}`
      + '    </button> '
      + '    <div class="dropdown-menu" style="min-width: 2rem;"> '
      + '    <a id="btn-editar" class="dropdown-item" href="#">Editar</a>'
      + '    <a id="btn-duplicar" class="dropdown-item" href="#">Duplicar</a>'
      + '    <a id="btn-visualizar" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Visualizar Baixas</a>'
      + '    <a id="btnExcluir" class="dropdown-item" href="#">Excluir</a>'
      + '    <a id="btnLancRateio" class="dropdown-item" href="#">Rateio</a>'
      + '    </div>'
      + '  </div>'
      + '</div>';
  }

  function retornaBotaoEstornar(data) {
    return '<div style="text-align:center;"> '
      + '   <div class="dropdown"> '
      + '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> '
      + `     ${data}`
      + '    </button> '
      + '    <div class="dropdown-menu" style="min-width: 2rem;"> '
      + '    <a id="btnEstornar" class="dropdown-item"  >Estornar</a>'
      + '    </div>'
      + '  </div>'
      + '</div>';
  }

  function botaoSelecionarGrid() {
    return '<div class="form-check">'
      + '<div class="icheck-primary"><input class="align-self-center checkPagar" type="checkbox" value=""><label></label></div>'
      + '</div>';
  }

  $("#tabelaPagar").on("click", "#btnLancRateio", async function () {
    const table = $("#tabelaPagar").DataTable();
    const data = table.row($(this).parents("tr")).data();
    $('#txtNumeroRateio').val(data.NUM_AP)
    $('#txtClasseRateio').val(data.NUM_OS)
    $('#txtTipoRateio').val('CP')
    $('#txtValorRateio').val(data.VALOR.toFixed(2))
    $('#txtDataRateio').val(formataData(new Date()))
    $('#txtNumeroAnt').val(data.NUM_AP)
    $('#txtDataVencto').val(data.DT_VEN)
    $('#txtDuplicata').val('')
    $('#txtNumeroOC').val('')
    $('#txtCentroCustoFixo').val('')
    $('#txtEmpId').val(data.EMP_ID)
    $('#modalLancRateio').modal('show');
  })

  $('#tabelaPagar').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaPagar', 'checkPagar', this);

    if ($('#tabelaPagar').DataTable().rows('.selected').data().length <= 0) {
      $('#btnBaixar').prop('disabled', true);
    }
  });

  $('#btnConsultar').on('click', async function () {
    limparFiltrosCache('filtrosAcessoPagar');
    try {
      try {
        $.LoadingOverlay('Show');
        let jsonStr = await buscaPagar();

        let table = $('#tabelaPagar').DataTable({
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: [{
            data: null,
          },
          {
            data: 'NUM_AP',
          },
          {
            data: 'CODCRE',
          },
          {
            data: 'CLIENTE',
          },
          {
            data: 'LANCAMENTO',
          },
          {
            data: 'DUPLI',
          },
          {
            data: 'VALOR',
          },
          {
            data: 'VAL_PAG',
          },
          {
            data: 'SALDO',
          },
          {
            data: 'JUROS',
          },
          {
            data: 'MULTA',
          },
          {
            data: 'DESCONTO',
          },
          {
            data: 'DT_EMI',
          },
          {
            data: 'DT_VEN',
          },
          {
            data: 'NUM_OS',
          },
          {
            data: 'BANCO',
          },
          {
            data: 'CONTA',
          },
          {
            data: 'STATUS',
          },
          {
            data: 'SITUACAO',
          },
          {
            data: 'OBS',
          },
          ],
          columnDefs: [{
            type: 'date-br',
            render(data) {
              return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
            },
            targets: 12,
          },
          {
            type: 'date-br',
            render(data, type, row) {
              x = data.slice(0, 10).split('-');
              let icone = '';
              const dataVencimento = new Date(`${row.DT_VEN} 23:59:59`);
              if (dataVencimento < new Date()) {
                icone = '<i class="fas fa-history" style="color: red" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
              } else {
                icone = '';
              }
              const retornaData = new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              return `${retornaData} ${icone}`;

            },
            targets: 13,
          },
          {
            type: 'date-br',
            render(data) {
              return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
            },
            targets: 13,
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [6, 7, 8, 9, 11],
            "className": 'pr-4 text-right'
          },
          {
            className: 'ColunaVermelha',
            targets: 8,
            render(data) {
              return data?.toLocaleString('pt-BR') ?? '';
            },
          },
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            targets: 0,
            data: null,
            defaultContent: botaoSelecionarGrid(),
          },
          {
            targets: [4, 10, 15, 16, 18, 19],
            visible: false,
          }
          ],
        });

        $('#tabelaPagar tbody tr td [data-toggle="tooltip"]').tooltip();

        atualizaTotais('none');

        $('#tabelaPagar').on('click', '#btn-editar', async function () {
          if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = table.row($(this).parents('tr')).data();
            let pagarLiberado = await verificarRegistro('PAGAR', data.NUM_AP);
            if (pagarLiberado) {
              let numAp = btoa(data.NUM_AP);
              window.location.href = `pagar/${numAp}`;
            }
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });

        $('#tabelaPagar').on('click', '#btn-duplicar', async function () {
          if (permissaoUsuarioLogado.INCLUI == 'S') {
            try {
              salvarFiltrosCache('filtrosAcessoPagar', campos);
              const data = table.row($(this).parents('tr')).data();
              let response = await requisicao('POST', '/Sisplan/pagar/V1/duplicar?', `num_ap=${data.NUM_AP}`);

              if (!response) {
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
              }

              //validar qual será o número da ap para passar por parametro
              const numAp = btoa(jsonStr.mensagem);
              window.location.href = `pagar/${numAp}`;
            } catch (error) {
              console.error(error);
            }

          } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
          }
        });
        $('#tabelaPagar').on('click', '.btnOpcao', async function () {
          $('.checkPagar').prop('checked', false);
          $('tr').removeClass('selected');
        });
        $('#modal-filtros').modal('hide');
        $('#btnBaixar').prop('disabled');
      } catch (error) {
        msgErro('Não foi possível buscar os dados do Pagamento: ');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });


  $('#tabelaPagar').on('click', '#btn-visualizar', async function () {
    try {
      try {
        $.LoadingOverlay('show');
        let table = $('#tabelaPagar').DataTable();
        let data = table.row($(this).parents('tr')).data();
        let jsonStr = [];
        let response = '';
        let fornecedor = '';

        jsonStr = await buscaBaixas(data.NUM_AP);

        $('#tabelaBaixar').DataTable({
          destroy: true,

          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: [{
            data: 'NUM_AP',
          },
          {
            data: 'DT_LAN',
          },
          {
            data: 'VALOR',
          },
          {
            data: 'VAL_PAG',
          },
          {
            data: 'JURO',
          },
          {
            data: 'MULTA',
          },
          {
            data: 'DESCONTO',
          },
          ],
          columnDefs: [{
            targets: [0], render: function (data, type, row) {
              return retornaBotaoEstornar(data);
            }
          },
          {
            render: $.fn.dataTable.render.moment(FormatoDtNovo),
            targets: 1,
          },
          ],
        });

        response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.CODCRE", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}], "where": ["PAGTO.NUM_AP = '${data.NUM_AP}'"]}`, null);
        if (!response) {
          return;
        }
        jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        fornecedor = `[${jsonStr.RESULT[0][0].CODCRE}] - ${jsonStr.RESULT[0][0].NOME}`;

        $('#txtFornecedorVisual').val(fornecedor);
        $('#txtDTemissaoVisual').val(data.DT_EMI);
        $('#txtNotaFiscalVisual').val(data.DUPLI);
        $('#txtSaldoVisual').val(data.SALDO);
      } catch (error) {
        console.error(error);
        msgErro('Erro ao buscar as baixas para visualizar');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABPADRAO.TABELA = 'PAGTO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    function primeiroDia() {
      let agora = new Date();
      let primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
      return primeiroDia;
    }

    let diaUm = primeiroDia();
    let dataISO = diaUm.toISOString();
    let dataString = dataISO.substr(0, 10);

    jsonStr.map(async item => {
      switch (item.CAMPO) {

        case 'STATUS': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#Status').val(item.VALOR).change();
          } else {
            $('#Status').val('').change();
          }

          break;
        }
        case 'SITUACAO': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#txtSituacao').val(item.VALOR).change();
          } else {
            $('#txtSituacao').val('Aberto').change();
          }

          break;
        }

        case 'EMISSAO_DE': {
          if (item.VALOR == 'S') {
            $('#txtDataDe').val(dataString);
          } else {
            $('#txtDataDe').val();
          }

          break;
        }

        case 'VENCIMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtVenctoDe').val(dataString);
          } else {
            $('#txtVenctoDe').val();
          }

          break;
        }
      }
    });
  }

  $('#tabelaPagar').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {

      try {
        $.LoadingOverlay('show');
        let table = $('#tabelaPagar').DataTable();
        let data = table.row($(this).parents('tr')).data();

        if ((data.STATUS == 'AGRU') || (data.STATUS == 'DESD')) {
          msgAlerta('Impossível excluir APs agrupadas ou desdobradas.');
          return;
        }

        let response = '';
        try {
          response = await requisicao('DELETE', '/Sisplan/pagar/v1/Pagar?', `num_ap=${data.NUM_AP}&lancamento=${data.LANCAMENTO}`, null);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }
          toastr.success(
            'Pagamento Excluido com Sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning',
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          },
          ).css({
            'margin-top': '20%',
            width: '500px',
            'max-width': '500px',
          });
        } catch (error) {
          console.error(error);
          msgErro('Erro ao excluir o registro.');
        }
      } finally {
        $.LoadingOverlay('hide');
        $('#btnConsultar').trigger('click');
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#tabelaBaixar').on('click', '#btnEstornar', async function () {
    try {
      $.LoadingOverlay('Show');
      let table = $('#tabelaBaixar').DataTable();
      let data = table.row($(this).parents('tr')).data();
      let response = '';
      try {
        response = await requisicao('POST', '/Sisplan/pagar/V1/Estornar?', `LANCAMENTO=${data.LANCAMENTO}&NUM_AP=${data.NUM_AP}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
        $('#txtSaldoVisual').val(parseFloat($('#txtSaldoVisual').val()) + parseFloat(data.VAL_PAG));

        table.rows().remove().draw(false);

        toastr.success(
          'Pagamento Estornado com Sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
      } catch (error) {
        console.error(error);
        msgErro('Erro ao estornar as baixas!');
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#btnConsultar').trigger('click');
    }
  });

  $('#modalBaixar').on('hidden.bs.modal', function () {
    $('#txtClasse').val('');
    $('#txtConta').val('');
    $('#txtHistorico').val('');
  });

  $('#btnBaixar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let sNumero = [];
        let table = $('#tabelaPagar').DataTable();
        let data = table.rows('.selected').data();

        if (data[0].VALOR == data[0].VAL_PAG) {
          msgAlerta('Essa duplicata já está baixada!');
          return;
        }

        for (let i = 0; i < data.length; i++) {
          if ((data[i].STATUS === 'DESD') || (data[i].STATUS === 'AGRU')) {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `, 'modalBaixar');
            return;
          }

          if (data[i].STATUS === 'CHCA') {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um título de Cheque. Impossível Baixar.`, 'modalBaixar');
            return;
          }

          if (data[i].STATUS === 'ANTE') {
            msgAlertaSemConfirmacao(`Num_AP: ${data[i].NUM_AP} é um título de Antecipação. Impossível Baixar. `, 'modalBaixar');
            return;
          }
          sNumero.push(data[i].NUM_AP);
        }

        const contasDiferentes = data.filter((registro) => registro.CONTA !== data[0].CONTA).length > 0;
        if (!contasDiferentes) {
          insereValor("#txtConta", data[0].CONTA, { tabela: 'CADCONTA', campoBusca: 'DESCRICAO', campoWhere: 'CONTA', valorWhere: data[0].CONTA });
        }

        const classesDiferentes = data.filter(registro => registro.NUM_OS !== data[0].NUM_OS).length > 0;
        if (!classesDiferentes) {
          insereValor("#txtClasse", data[0].NUM_OS, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: data[0].NUM_OS });
        }

        $('#modalBaixar').modal('show');

        const ListaNumeros = `'${sNumero.toString().replaceAll(',', "','")}'`;

        let response = await requisicao('GET', '/Sisplan/Pagar/v1/Pagar?', `LISTA_NUM_APS=${ListaNumeros}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT.mensagem);
          return;
        }

        table = await $('#tabelaBaixarContas').DataTable({
          order: false,
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: [
            { data: 'NUM_AP', title: 'NUM_AP' },
            { data: 'CODCRE', title: 'CODCRE' },
            { data: 'CLIENTE', title: 'CLIENTE' },
            { data: null, title: 'DESCONTO' },
            { data: null, title: 'JUROS' },
            { data: 'VALOR', title: 'VALOR' },
            { data: null, title: 'VAL_PAG' },
            { data: 'SALDO', title: 'SALDO' },
          ],
          columnDefs: [{
            targets: 3,
            data: null,
            defaultContent: retornaInputs(true, false, false),
          },
          {
            targets: 4,
            data: null,
            defaultContent: retornaInputs(false, true, false),
          },
          {
            targets: 6,
            data: null,
            defaultContent: retornaInputs(false, false, true),
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [5, 7],
            "className": 'pr-4 text-right'
          }],
        });

        // executa isso depois de carregar o datatable

        let countRow = $('#tabelaBaixarContas').DataTable().rows().count();
        let tableBaixar = $('#tabelaBaixarContas').DataTable().rows().data();
        for (let i = 0; i < countRow; i++) {
          $($('.txtvalorPago')[i]).val(tableBaixar[i].SALDO);
          $($('.txtvalorPago')[i]).attr('data-valor-old', tableBaixar[i].SALDO);
        }

        $('.valoresInput').inputmask('numeric', {
          min: 0,
          positionCaretOnClick: 'select',
          digits: 2,
        }).on('focus', function () {
          let that = $(this);
          setTimeout(function () {
            that.select();
          }, 1);
        });
      } catch (error) {
        console.error(error);
        msgErro('Erro ao Realizar baixa');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  retornaHintRelatorio('btnImprimir', 'Pagar')
  $('#btnImprimir').on('click', async function () {
    try {
      try {
        $.LoadingOverlay('show');

        let numeros = [];
        let table = $('#tabelaPagar').DataTable();
        let pagar = table.rows('.selected').data();

        for (let i = 0; i < pagar.length; i++) {
          numeros.push(pagar[i].NUM_AP);
        }

        const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

        let situacaoFiltro = ''
        let fornecedorFiltro = ''
        let dataAteFiltro = ''
        let dataDeFiltro = ''
        let venctoAteFiltro = ''
        let venctoDeFiltro = ''
        let dataBaixaDeFiltro = ''
        let dataBaixaAteFiltro = ''
        let statusFiltro = ''
        let emp_id = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
          ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
          : getCookie('emp_id');

        if (numeros.length == 0) {
          situacaoFiltro = $('#txtSituacao').val();
          fornecedorFiltro = $('#txtConsultaFornecedor').val().substring(1, $('#txtConsultaFornecedor').val().indexOf('] - '));
          dataAteFiltro = moment($('#txtDataAte').val()).format('DD/MM/YYYY');
          dataDeFiltro = moment($('#txtDataDe').val()).format('DD/MM/YYYY');
          venctoAteFiltro = moment($('#txtVenctoAte').val()).format('DD/MM/YYYY');
          venctoDeFiltro = moment($('#txtVenctoDe').val()).format('DD/MM/YYYY');
          dataBaixaDeFiltro = moment($('#dtBaixaDe').val()).format('DD/MM/YYYY');
          dataBaixaAteFiltro = moment($('#dtBaixaAte').val()).format('DD/MM/YYYY');
          statusFiltro = $('#Status').val();
          emp_id = $('#checkTodasEmpresas').prop('checked') == false ? emp_id : $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : emp_id;
        }

        url = `/sisplan/impressao/v1/acesso_pagar?TELA_ORDENACAO=Pagar&NUM_AP=${ListaNumeros}&ORDEM_ORDENACAO=${$('#txtOrdem').val()}&SITUACAO=${situacaoFiltro}&FORNECEDOR=${fornecedorFiltro}&DATADE=${dataDeFiltro}&DATAATE=${dataAteFiltro}&VENCTODE=${venctoDeFiltro}&VENCTOATE=${venctoAteFiltro}&BAIXA_DE=${dataBaixaDeFiltro}&BAIXA_ATE=${dataBaixaAteFiltro}&STATUS=${statusFiltro}&EMP_ID=${emp_id}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('Pagar');
        arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Pagar');
        if (arquivo != undefined && arquivo != "") {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (err) {
        console.error(err);
        msgErro('Erro ao imprimir relatório.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function retornaInputs(bUsaDesconto = false, bUsaJuros = false, bUsaValor = false) {
    let retorno = '';
    if (bUsaDesconto) {
      retorno = '<div><input min="0" type="text" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtDesconto"></div>';
    }
    if (bUsaJuros) {
      retorno = '<input min="0" type="text" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtJuros">';
    }
    if (bUsaValor) {
      retorno = '<input min="0" type="text" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtvalorPago">';
    }
    return retorno;
  }

  $('#tabelaBaixarContas').on('blur', '.txtvalorPago', async function () {
    let valor = parseFloat($(this).val());
    let saldo = parseFloat(($(this).closest('tr')[0].childNodes[7].childNodes[0].data).replace('.', '').replace(',', '.'));

    if (valor > saldo) {
      msgAlerta('Valor não pode ser maior que o Saldo');
      $(this).val(saldo);
      $(this).closest('tr').find('.txtJuros').val('0');
      $(this).closest('tr').find('.txtDesconto').val('0');
    }
  });

  // desconto
  $('#tabelaBaixarContas').on('blur', '.txtDesconto', async function () {
    if (parseFloat($(this).val()) < 0) {
      msgAlerta('Desconto não pode ser menor que 0!');
      $(this).val(0);
      return;
    }
    let desconto = parseFloat($(this).val());
    let saldo = parseFloat(($(this).closest('tr')[0].childNodes[7].childNodes[0].data).replace('.', '').replace(',', '.'));
    let novoValor = 0;
    let valorPago = saldo - desconto;

    if (valorPago < 0) {
      msgAlerta('Valor pago não pode ser menor que 0!');
      $(this).closest('tr').find('.txtvalorPago').val(saldo);
      $(this).closest('tr').find('.txtJuros').val('0');
      $(this).val('0');
      return;
    }

    $(this).closest('tr').find('.txtvalorPago').val(await TruncaDecimais(2, valorPago, novoValor));

    if (novoValor > saldo) {
      msgAlerta('Valor não pode ser maior que o Saldo');
      $(this).closest('tr').find('.txtvalorPago').val(saldo);
      $(this).closest('tr').find('.txtJuros').val('0');
      $(this).val('0');
    }
  });

  // juros
  $('#tabelaBaixarContas').on('blur', '.txtJuros', async function () {
    const juros = parseFloat($(this).val());
    const saldo = parseFloat(($(this).closest('tr')[0].childNodes[7].childNodes[0].data).replace('.', '').replace(',', '.'));
    const valorPago = saldo + juros;

    if (juros < 0) {
      msgAlerta('Juros não pode ser menor que 0!');
      $(this).val(0);
      return;
    }

    $(this).closest('tr').find('.txtvalorPago').val(TruncaDecimaisNova(2, valorPago));

  });

  async function pegaValoresBaixa() {
    try {
      let table = $('#tabelaBaixarContas').DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto;

      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          VAL_PAG: parseFloat($($('#tabelaBaixarContas').find('.txtvalorPago')[i]).val()),
          DESCONTO: $($('#tabelaBaixarContas').find('.txtDesconto')[i]).val(),
          JURO: $($('#tabelaBaixarContas').find('.txtJuros')[i]).val(),
          LANCAMENTO: rows.data()[i].LANCAMENTO,
          NUM_AP: rows.data()[i].NUM_AP,
          DOCTO: rows.data()[i].DOCTO,
          DT_LAN: `${$('#txtDTPagamento').val()}T00:00:00Z`,
          VAL_DEV: rows.data()[i].VAL_DEV,
          DESP_COBRANCA: rows.data()[i].DESP_COBRANCA,
          VAR_CAMBIAL: rows.data()[i].VAR_CAMBIAL,
          HISTORICO: rows.data()[i].HISTORICO,
          OBS: rows.data()[i].OBS + ' ' + $('#txtObs').val(),
          SALDO: parseFloat(rows.data()[i].SALDO) - parseFloat($($('#tabelaBaixarContas').find('.txtvalorPago')[i]).val()),
          VALPAGO_MOEDA: rows.data()[i].VALPAGO_MOEDA,
          TAXA_MOEDA: rows.data()[i].TAXA_MOEDA,
          DT_PROCESSAMENTO: rows.data()[i].DT_PROCESSAMENTO,
        };

        valores.push(objeto);

        objeto = {};
      }
      return valores;
    } catch (error) {
      msgErro('Erro ao pegar os valores da tabela');
    }
  }

  $('#btn-baixar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      if ($('#txtConta').val() == '') {
        msgAlerta('Conta não informada!');
        $('#btn-Conta').trigger('click');
        return;
      }
      if ($('#txtClasse').val() == '') {
        msgAlerta('Classe não informada!');
        $('#btn-Classe').trigger('click');
        return;
      }
      if ($('#txtHistorico').val() == '') {
        msgAlerta('Histórico não informado!');
        $('#btn-Historico').trigger('click');
        return;
      }
      try {
        let table = $('#tabelaBaixarContas').DataTable();
        let rows = table.rows();
        let count = rows.count();
        let Baixas = {};
        let response = '';
        let jsonStr = [];

        // valida se tem saldo
        for (let i = 0; i < rows[0].length; i++) {
          if (rows.data()[i].SALDO == 0) {
            msgAlerta('Registro já está baixado!');
            $('#tabelaBaixarContas').DataTable().rows([i]).remove().draw(false);
            if (rows[0].length == 1) {
              $('#modalBaixar').modal('hide');
            }
            return;
          }
        }

        Baixas = await pegaValoresBaixa();

        for (let i = 0; i < count; i++) {

          if (parseFloat(Baixas[i].VAL_PAG) <= 0) {
            msgAlerta('Valor pago não pode ser 0');
            return;
          }

          response = await requisicao('POST', '/Sisplan/Pagar/V1/baixaPagar?', '', `JSON=${encodeURIComponent(JSON.stringify(Baixas[i]))}`);

          if (!response) {
            return;
          }

          jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
          }
        }
        toastr.success(
          'Pagamento baixado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            $('#btnConsultar').trigger('click');
            $('#modalBaixar').modal('hide');
          },
        },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
      } catch (error) {
        console.error(error);
        msgAlerta('Erro ao realizar baixa!');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnDesdobrarAgrupar').on('click', async function () {

    const data = $("#tabelaPagar").DataTable().rows(".selected").data().toArray();

    if (data.length == 0) {
      msgErro('Nenhuma AP selecionada. Impossível continuar.')
      return;
    }

    let valida = data.filter(e => e.EMP_ID != getCookie('emp_id'));

    if (valida.length > 0) {
      msgErro('Não é possível desdobrar/agrupar APs de empresas diferentes da atual. Impossível continuar.')
      return;
    }

    valida = data.filter(e => (e.SALDO != e.VALOR) && (e.VALOR > 0));

    if (valida.length > 0) {
      msgErro('AP possui baixas. Impossível continuar.')
      return;
    }

    valida = undefined;

    const codcre = data[0].CODCRE;

    valida = data.find(e => codcre != e.CODCRE);

    if (valida != undefined) {
      msgErro('O fornecedor precisa ser o mesmo para todas as APs. Impossível continuar.');
      return;
    }
    msgAlerta('Deseja mesmo desdobrar/agrupar as APs selecionadas?', () => { }, () => { }, () => {
      $.LoadingOverlay('show');
      $('#modal-desdobra-pagar').modal('show');
      $.LoadingOverlay('hide');
    })
  });

  $('#btnConsultar').trigger('click');
});
