$(document).ready(async function () {

  const colunasItens = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Tam', data: 'TAM' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Valor', data: 'VALOR' },
    { title: 'Custom', data: 'CUSTOMIZACAO' },
    { title: 'Excluir', data: 'EXCLUIR' },
  ];

  const colunasCaracteristicas = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Valor', data: 'VALOR' },
  ];

  const colunasComposicao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
    { title: 'Nome Fornecedor', data: 'NOME_FORNECEDOR' },
    { title: 'Excluir', data: 'EXCLUIR' },
  ];

  const colunasFt = [
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Ordem', data: 'ORDEM' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
  ];

  const colunasGrade = [
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Preço', data: 'PRECO' },
    { title: '% Acresc.', data: 'PERC_ACRESC' },
    { title: 'Val Acresc.', data: 'VAL_ACRESC' },
    { title: '% Desc.', data: 'PERC_DESC' },
    { title: 'Val Desc.', data: 'VAL_DESC' },
    { title: 'Preço Líq.', data: 'PRECO_LIQ' },
    { title: 'Total', data: 'TOTAL' },
  ];

  const colunasAplicacoes = [
    { title: 'Característica', data: 'CARACTERISTICA' },
    { title: 'Subcaracterística', data: 'SUBCARACTERISTICA' },
  ];

  const colunasTecidosUtilizados = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Fundo', data: 'FUNDO' },
    { title: 'Visor', data: 'VISOR' },
    { title: 'Consumo', data: 'CONSUMO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Fornecedor', data: 'FORNECEDOR' },
  ];

  const colunasConsumos = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Qtde', data: 'QTDE' },
    { title: 'Custo', data: 'CUSTO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Desc Cor', data: 'DESC_COR' },
  ];

  const colunasSerigrafiaTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSerigrafiaTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
  ];

  const colunasSerigrafia = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Cores', data: 'QTDE_CORES' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasBordadoProgramacao = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoTamanho = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' }
  ];

  const colunasBordadoLocal = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
    { title: 'Margem', data: 'MARGEM' }
  ];

  const colunasBordado = [
    { title: 'Nome', data: 'NOME' },
    { title: 'Programação', data: 'PROGRAMACAO' },
    { title: 'Tamanho', data: 'TAMANHO' },
    { title: 'Local', data: 'LOCAL' },
    { title: 'Qtde Prog', data: 'QTDE_PROG' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Altura', data: 'ALTURA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasSublimacao = [
    { title: 'SEL', data: 'SEL' },
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotapeTipo = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Preço', data: 'PRECO' },
  ];

  const colunasTermotape = [
    { title: 'Código', data: 'CODIGO' },
    { title: 'Descrição', data: 'DESCRICAO' },
    { title: 'Tam CM²', data: 'TAM_CM2' },
    { title: 'Total', data: 'TOTAL' },
    { title: 'Preço', data: 'PRECO' },
  ];

  let idCaracteristica = '';

  await verificaPermissoes('ORCAMENTO');
  await adicionaEmpresas();
  await setarDataAtual('dtDigitacao');
  await setarDataAtual('dtEmissao');
  await carregaValoresPadroes();

  addPesquisaAutocompleta();
  criaMascaraCampos();
  addBotoesAvancarVoltar();
  addValidacaoCamposObrigatorios();

  criaDataTablePadrao('#tabelaDuplicatas', false, false, false, false, true, false, '193px');
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', undefined, colunasItens);
  criaDataTablePadrao('#tabelaCaracteristicas', false, false, false, false, true, false, '300px', undefined, colunasCaracteristicas);
  criaDataTablePadrao('#tabelaComposicao', false, false, false, false, true, false, '300px', undefined, colunasComposicao);
  criaDataTablePadrao('#tabelaFt', false, false, false, false, true, false, '300px', undefined, colunasFt);
  criaDataTablePadrao('#tabelaGrade', false, false, false, false, true, false, '300px', undefined, colunasGrade);
  criaDataTablePadrao('#tabelaAplicacoes', false, false, false, false, true, false, '300px', undefined, colunasAplicacoes);
  criaDataTablePadrao('#tabelaTecidosUtilizados', false, false, false, false, true, false, '300px', undefined, colunasTecidosUtilizados, [8, 9]);
  criaDataTablePadrao('#tabelaConsumos', false, false, false, false, true, false, '300px', undefined, colunasConsumos);
  criaDataTablePadrao('#tabelaSerigrafia', false, false, false, false, true, false, '400px', undefined, colunasSerigrafia);
  criaDataTablePadrao('#tabelaSerigrafiaTipo', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTipo, [0, 1, 3]);
  criaDataTablePadrao('#tabelaSerigrafiaLocal', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaLocal, [0, 2]);
  criaDataTablePadrao('#tabelaSerigrafiaTamanho', false, false, false, false, true, false, '200px', undefined, colunasSerigrafiaTamanho, [0]);
  criaDataTablePadrao('#tabelaBordado', false, false, false, false, true, false, '400px', undefined, colunasBordado);
  criaDataTablePadrao('#tabelaBordadoProgramacao', false, false, false, false, true, false, '200px', undefined, colunasBordadoProgramacao, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoTamanho', false, false, false, false, true, false, '200px', undefined, colunasBordadoTamanho, [0, 2]);
  criaDataTablePadrao('#tabelaBordadoLocal', false, false, false, false, true, false, '200px', undefined, colunasBordadoLocal, [0, 2, 3]);
  criaDataTablePadrao('#tabelaSublimacao', false, false, false, false, true, false, '400px', undefined, colunasSublimacao);
  criaDataTablePadrao('#tabelaTermotapeTipo', false, false, false, false, true, false, '200px', undefined, colunasTermotapeTipo, [2]);
  criaDataTablePadrao('#tabelaTermotape', false, false, false, false, true, false, '400px', undefined, colunasTermotape, [0]);

  await carregaCustomSerigrafiaTipo();
  await carregaCustomSerigrafiaLocal();
  await carregaCustomSerigrafiaTam();

  await carregaCustomBordadoProg();
  await carregaCustomBordadoTam();
  await carregaCustomBordadoLocal();

  await carregaCustomSublimacao();
  await carregaCustomTermotape();

  await validaEdicao();

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });

  $('#txtLinha, #txtGrupo, #txtEtiqueta').on('blur', async function () {
    const linha = pegaChave('#txtLinha');
    const grupo = pegaChave('#txtGrupo');
    const etiqueta = pegaChave('#txtEtiqueta');

    if ((linha == '') || (grupo == '') || (etiqueta == '')) {
      return;
    }

    await buscaCaracteristica(linha, grupo, etiqueta);
  });

  $('#btnAddSerigrafia').on('click', function () {
    addSerigrafia();
  });

  $('#btnRemoveSerigrafia').on('click', function () {
    removeSerigrafia();
  });

  $('#btnAddBordado').on('click', function () {
    addBordado();
  });

  $('#btnRemoveBordado').on('click', function () {
    removeBordado();
  });

  $('#btnAddTermotape').on('click', function () {
    addTermotape();
  });

  $('#btnAddComposicao').on('click', function () {
    $('#modalComposicao').modal('show');
  });

  $('#btnAddItem').on('click', function () {
    $('#modalItem').modal('show');
  });

  $('#btnConfirmarComposicao').on('click', function () {
    adicionaComposicao();
  });

  $('#tabelaComposicao').on('click', '#btn-excluir-composicao', async function () {
    $('#tabelaComposicao').DataTable().row($(this).parents('tr')).remove().draw(false);
  });

  $("#modalItem").on('shown.bs.modal', async function () {
    $('body').addClass('sidebar-collapse');
    ajustaTabelasModalItem();
  });

  $("#modalItem").on('hidden.bs.modal', async function () {
    $('body').removeClass('sidebar-collapse');
  });

  $('#tabCaracteristicas, #tabComposicao, #tabAplicacoes, #tabConsumos, #tabGrade, #tabObs, #tabFt, #tabSerigrafia, #tabBordado, #tabSublimacao, #tabTermotape').on('click', async function () {
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
    if ($(this)[0].id == 'tabAplicacoes') {
      carregaAplicacoes();
    }
    if (($(this)[0].id == 'tabGrade') && (pegaValor('#txtFaixa') != '')) {
      await explodeFaixa(pegaChave('#txtFaixa'));
    }
  });

  $('#tabCustomizacoes').on('click', function () {
    setTimeout(() => { $('#tabSerigrafia').trigger('click') }, 200);
    setTimeout(() => { ajustaTabelasModalItem() }, 200);
  });

  $('#txtCliente').on('blur', async function () {
    await buscaRepresentanteCliente();
    await buscaContatoCliente();
  });

  $('#txtRepresentante').on('blur', async function () {
    await buscaComissaoRepresentante();
  });

  $("#edtVencimento1, #edtVencimento2, #edtVencimento3, #edtVencimento4, #edtVencimento5, #edtVencimento6, #edtVencimento7, #edtVencimento8, #edtVencimento9, #edtVencimento10, #edtVencimento11, #edtVencimento12").change(async function () {
    if ($(this).val() == 0) {
      $(this).val('');
    }
    await simulaFinanceiro();
  });

  $('#txtDias').on('blur', function () {
    const dias = pegaValor('#txtDias');

    if (dias == '') {
      return;
    }

    setarDataAtual('dtEntrega', false, parseFloat(dias));
    setarDataAtual('dtSaida', false, parseFloat(dias));
  });

  $('#tabelaCaracteristicas').on('click', 'td', function () {
    selecionarLinhaTabela('#tabelaCaracteristicas', 'checkCaracteristica', this);
  });

  $('#tabelaBordadoProgramacao').on('click', 'tr', async function () {
    $('#tabelaBordadoProgramacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoTamanho').on('click', 'tr', async function () {
    $('#tabelaBordadoTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordadoLocal').on('click', 'tr', async function () {
    $('#tabelaBordadoLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTipo').on('click', 'tr', async function () {
    $('#tabelaSerigrafiaTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await carregaCustomSerigrafiaTam();
  });

  $('#tabelaSerigrafiaLocal').on('click', 'tr', function () {
    $('#tabelaSerigrafiaLocal > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafiaTamanho').on('click', 'tr', function () {
    $('#tabelaSerigrafiaTamanho > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSerigrafia').on('click', 'tr', function () {
    $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaBordado').on('click', 'tr', function () {
    $('#tabelaBordado > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaSublimacao').on('click', 'tr', function () {
    $('#tabelaSublimacao > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#tabelaTermotapeTipo').on('click', 'tr', function () {
    $('#tabelaTermotapeTipo > tbody > tr').removeClass('selected');
    $(this).closest('tr').addClass('selected');
  });

  $('#txtCodigo').on('blur', function () {
    const codigo = pegaChave('#txtCodigo');

    if (codigo == '') {
      return;
    }

    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"] }`);
    $('#btn-Cor').off();
    $('#btn-Cor').unbind();
    $('#btn-Cor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${codigo}' AND PA_ITEN.ATIVO = 'S'"]}`, 'Pesquisa Cor', 'CADCOR');
  });

  async function validaEdicao() {
    if ($(window.location.href.split('/')).get(-1) == 'create') {
      insereValor('#txtNumero', await RetornaProximo('OS', 'OS', 'NUMERO', 5));
      return;
    }
  }

  async function buscaRepresentanteCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP', 'REPRESEN.NOME'],
      leftJoin: [{ tabela: 'REPRESEN', condicao: `ENTIDADE.CODREP = REPRESEN.CODREP` }],
      where: [`ENTIDADE.CODCLI = '${codcli}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtRepresentante', jsonStr[0].CODREP, jsonStr[0].NOME);
      await buscaComissaoRepresentante();
    } else {
      limpaValor('#txtRepresentante');
    }
  }

  async function buscaContatoCliente() {
    const codcli = pegaChave('#txtCliente');

    if (codcli == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'CONTATO',
      camposSelect: ['ID', 'NOME'],
      where: [`CODCLI = '${codcli}' AND TIPO = 'Orçamento'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].NOME != '') {
      insereValor('#txtSolicitante', jsonStr[0].ID, jsonStr[0].NOME);
    } else {
      limpaValor('#txtSolicitante');
    }
  }

  async function buscaComissaoRepresentante() {
    const codrep = pegaChave('#txtRepresentante');

    if (codrep == '') {
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['COMISSAO', 'COMISSAO2'],
      where: [`CODREP = '${codrep}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtComissaoFat', jsonStr[0].COMISSAO);
    insereValor('#txtComissaoRec', jsonStr[0].COMISSAO2);
  }

  async function carregaCustomSerigrafiaTam() {
    $.LoadingOverlay('show');
    $('#tabelaSerigrafiaTamanho').DataTable().clear().draw(false);
    try {
      if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() == 0) {
        return;
      }

      const descTipo = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].DESCRICAO;
      const qtdeCores = $('#tabelaSerigrafiaTipo').DataTable().rows('.selected').data()[0].QTDE_CORES;

      const pesquisaParam = {
        tabela: 'CUSTOMIZA',
        camposSelect: ['CUSTOMIZA.ID_TAMANHO', 'TAM.DESCRICAO'],
        leftJoin: [{ tabela: 'CUSTOMIZA', alias: 'TAM', condicao: `TAM.ID = CUSTOMIZA.ID_TAMANHO AND TAM.TIPO = 'SERIGTAM'` }],
        where: [`CUSTOMIZA.TIPO = 'SERIGTIPO' AND CUSTOMIZA.DESCRICAO = '${descTipo}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      jsonStr.map(item => {
        $('#tabelaSerigrafiaTamanho').DataTable().row.add({
          CODIGO: item.ID_TAMANHO,
          DESCRICAO: item.DESCRICAO,
        }).draw(false);
      });

      insereValor('#txtQtdeCores', qtdeCores);

      if ($('#tabelaSerigrafiaTamanho').DataTable().rows().count() > 0) {
        $($('#tabelaSerigrafiaTamanho > tbody > tr')[0]).addClass('selected');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaCustomSerigrafiaLocal() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM', 'ATIVO'],
      where: [`TIPO = 'SERIGLOCAL'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSerigrafiaLocal').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaSerigrafiaLocal').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafiaLocal > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomSerigrafiaTipo() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'QTDE_COR', 'COALESCE(VAL_TELA [SOMA] VAL_FOTO [SOMA] VAL_COR, 0) PRECO'],
      where: [`TIPO = 'SERIGTIPO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSerigrafiaTipo').DataTable().row.add({
        CODIGO: item.ID,
        QTDE_CORES: item.QTDE_COR,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaSerigrafiaTipo').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafiaTipo > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoProg() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
      where: [`TIPO = 'BORDPROG'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoProgramacao').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaBordadoProgramacao').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoProgramacao > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoTam() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO'],
      where: [`TIPO = 'BORDTAM'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoTamanho').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
      }).draw(false);
    });

    if ($('#tabelaBordadoTamanho').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoTamanho > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomBordadoLocal() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'COALESCE(PRECO, 0) PRECO', 'MARGEM'],
      where: [`TIPO = 'BORDLOCAL'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaBordadoLocal').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO,
        MARGEM: item.MARGEM,
      }).draw(false);
    });

    if ($('#tabelaBordadoLocal').DataTable().rows().count() > 0) {
      $($('#tabelaBordadoLocal > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomSublimacao() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'VAL_PROG'],
      where: [`TIPO = 'SUBLI'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaSublimacao').DataTable().row.add({
        SEL: botaoSelecionarGrid('checkSublimacao'),
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.VAL_PROG
      }).draw(false);
    });

    if ($('#tabelaSublimacao').DataTable().rows().count() > 0) {
      $($('#tabelaSublimacao > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaCustomTermotape() {
    const pesquisaParam = {
      tabela: 'CUSTOMIZA',
      camposSelect: ['ID', 'DESCRICAO', 'PRECO'],
      where: [`TIPO = 'TERMO'`],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    jsonStr.map(item => {
      $('#tabelaTermotapeTipo').DataTable().row.add({
        CODIGO: item.ID,
        DESCRICAO: item.DESCRICAO,
        PRECO: item.PRECO
      }).draw(false);
    });

    if ($('#tabelaTermotapeTipo').DataTable().rows().count() > 0) {
      $($('#tabelaTermotapeTipo > tbody > tr')[0]).addClass('selected');
    }
  };

  async function carregaComposicao() {
    $.LoadingOverlay('show');
    $('#tabelaComposicao').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacomposicao?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaComposicao').DataTable().row.add({
          CODIGO: item.COD_MAT,
          DESCRICAO: item.DESC_MAT,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
          FORNECEDOR: '',
          NOME_FORNECEDOR: '',
          EXCLUIR: retornaBotaoExcluir(),
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function carregaConsumos() {
    $.LoadingOverlay('show');
    $('#tabelaConsumos').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscaconsumos?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaConsumos').DataTable().row.add({
          CODIGO: item.ID,
          DESCRICAO: item.DESC_MAT,
          QTDE: item.QTDE,
          CUSTO: item.CUSTO,
          COR: item.COR,
          DESC_COR: item.DESC_COR,
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaCaracteristica(sLinha, sGrupo, sEtiqueta) {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['CARACT.ID', 'CARACT.COD_FAIXA', 'FAIXA.DESCRICAO DESC_FAIXA'],
      where: [`CARACT.COD_ETQ = '${sEtiqueta}' AND CARACT.COD_GRUPO = '${sGrupo}' AND CARACT.COD_LINHA = '${sLinha}'`],
      leftJoin: [{ tabela: 'FAIXA', condicao: `FAIXA.CODIGO = CARACT.COD_FAIXA` }],
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhuma característica encontrada para o grupo, etiqueta e linha informados. Favor verificar.');
      return;
    }

    idCaracteristica = jsonStr[0].ID;

    insereValor('#txtFaixa', jsonStr[0].COD_FAIXA, jsonStr[0].DESC_FAIXA);

    await carregaCaracteristicas();
    await carregaComposicao();
    await carregaConsumos();
  };

  async function explodeFaixa(sFaixa) {
    if (pegaValor('#txtValTotal') > 0) {
      return;
    }

    $.LoadingOverlay('show');
    $('#tabelaGrade').DataTable().clear();
    try {
      const pesquisaParam = {
        tabela: 'FAIXA_ITEN',
        camposSelect: ['TAMANHO', 'POSICAO'],
        where: [`FAIXA = '${sFaixa}'`],
        orderBy: ['POSICAO'],
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      const precoVenda = await montaPrecoVenda();

      jsonStr.map((item, index) => {
        $('#tabelaGrade').DataTable().row.add({
          TAMANHO: item.TAMANHO,
          QTDE: retornaInputValor('txtQtdeGrade txtCamposGrade', index),
          PRECO: precoVenda,
          PERC_ACRESC: retornaInputValor('txtPercAcresGrade txtCamposGrade', index),
          VAL_ACRESC: retornaInputValor('txtValAcresGrade txtCamposGrade', index),
          PERC_DESC: retornaInputValor('txtPercDescGrade txtCamposGrade', index),
          VAL_DESC: retornaInputValor('txtValDescGrade txtCamposGrade', index),
          PRECO_LIQ: '0.00',
          TOTAL: '0.00',
        }).draw(false);
      });
    } finally {
      $('.txtCamposGrade').on('change', function () {
        calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
      });

      insereValor('#txtQtdeTotal', '0.00');
      insereValor('#txtValTotal', '0.00');

      aplicaMascara();

      $.LoadingOverlay('hide');
    }
  };

  async function carregaCaracteristicas() {
    $.LoadingOverlay('show');
    $('#tabelaCaracteristicas').DataTable().clear().draw();
    try {
      const response = await requisicao('GET', '/sisplan/orcamento/v1/buscacaracteristicas?', `ID=${idCaracteristica}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      jsonStr.map(item => {
        $('#tabelaCaracteristicas').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkCaracteristica'),
          CODIGO: item.ID,
          DESCRICAO: item.DESC_OPCIONAL,
          VALOR: item.VALOR,
        }).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function removeSerigrafia() {
    $('#tabelaSerigrafia').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
      $($('#tabelaSerigrafia > tbody > tr')[0]).addClass('selected');
    }
  };

  async function montaPrecoVenda() {
    let precoVenda = await retornaCustoFixo();

    $('#tabelaCaracteristicas').DataTable().rows('.selected').data().map(item => {
      precoVenda += item.VALOR;
    });

    $('#tabelaConsumos').DataTable().rows().data().map(item => {
      precoVenda += (item.CUSTO * item.QTDE);
    });

    precoVenda += $('#tabelaSerigrafia').DataTable().column(8, {}).data().sum();

    precoVenda += $('#tabelaBordado').DataTable().column(8, {}).data().sum();

    return precoVenda.toFixed(2);
  };

  async function retornaPrecoMat(sCodigo) {
    const pesquisaParam = {
      tabela: 'MAT_PRECO',
      camposSelect: ['PRECO_1 PRECO'],
      where: [`CODIGO = '${sCodigo}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length > 0) {
      return jsonStr[0].PRECO;
    } else {
      return 0;
    }
  };

  async function retornaCustoFixo() {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: ['(VALOR_COST [SOMA] VALOR_LINHA [SOMA] MARGEM) CUSTO_FIXO'],
      where: [`ID = ${idCaracteristica}`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr[0].CUSTO_FIXO;
  };

  function addSerigrafia() {
    try {
      $('#tabelaSerigrafia').DataTable().row.add({
        NOME: pegaValor('#txtNomeSerigrafia'),
        TIPO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaSerigrafiaTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_CORES: pegaValor('#txtQtdeCores'),
        TOTAL: pegaValor('#txtTotalPecasSerigrafia'),
        ALTURA: pegaValor('#txtAlturaSerigrafia'),
        LARGURA: pegaValor('#txtLarguraSerigrafia'),
        PRECO: $('#tabelaSerigrafiaTipo').DataTable().row('.selected').data().PRECO + $('#tabelaSerigrafiaLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaSerigrafia').DataTable().rows().count() > 0) {
        $('#tabelaSerigrafia > tbody > tr').removeClass('selected');
        $($('#tabelaSerigrafia > tbody > tr')[$('#tabelaSerigrafia').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeSerigrafia');
      limpaValor('#txtAlturaSerigrafia');
      limpaValor('#txtLarguraSerigrafia');
      limpaValor('#txtTotalPecasSerigrafia');
    }
  };

  function addTermotape() {
    try {
      $('#tabelaTermotape').DataTable().row.add({
        CODIGO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().CODIGO,
        DESCRICAO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().DESCRICAO,
        TAM_CM2: pegaValor('#txtTamCm2'),
        TOTAL: pegaValor('#txtTotalPecasTermotape'),
        PRECO: $('#tabelaTermotapeTipo').DataTable().row('.selected').data().PRECO,
      }).draw(false);

      if ($('#tabelaTermotape').DataTable().rows().count() > 0) {
        $('#tabelaTermotape > tbody > tr').removeClass('selected');
        $($('#tabelaTermotape > tbody > tr')[$('#tabelaTermotape').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtTamCm2');
      limpaValor('#txtTotalPecasTermotape');
    }
  };

  function removeBordado() {
    $('#tabelaBordado').DataTable().row('.selected').remove().draw(false);

    if ($('#tabelaBordado').DataTable().rows().count() > 0) {
      $($('#tabelaBordado > tbody > tr')[0]).addClass('selected');
    }
  };

  function addBordado() {
    try {
      $('#tabelaBordado').DataTable().row.add({
        NOME: pegaValor('#txtNomeBordado'),
        PROGRAMACAO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().DESCRICAO,
        TAMANHO: $('#tabelaBordadoTamanho').DataTable().row('.selected').data().DESCRICAO,
        LOCAL: $('#tabelaBordadoLocal').DataTable().row('.selected').data().DESCRICAO,
        QTDE_PROG: pegaValor('#txtQtdeProg'),
        TOTAL: pegaValor('#txtTotalPecasBordado'),
        ALTURA: pegaValor('#txtAlturaBordado'),
        LARGURA: pegaValor('#txtLarguraBordado'),
        PRECO: $('#tabelaBordadoProgramacao').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoTamanho').DataTable().row('.selected').data().PRECO + $('#tabelaBordadoLocal').DataTable().row('.selected').data().PRECO
      }).draw(false);

      if ($('#tabelaBordado').DataTable().rows().count() > 0) {
        $('#tabelaBordado > tbody > tr').removeClass('selected');
        $($('#tabelaBordado > tbody > tr')[$('#tabelaBordado').DataTable().rows().count() - 1]).addClass('selected');
      }
    } finally {
      limpaValor('#txtNomeBordado');
      limpaValor('#txtQtdeProg');
      limpaValor('#txtAlturaBordado');
      limpaValor('#txtLarguraBordado');
      limpaValor('#txtTotalPecasBordado');
    }
  };

  function carregaAplicacoes() {
    $('#tabelaAplicacoes').DataTable().clear();
    $('#tabelaTecidosUtilizados').DataTable().clear();

    try {
      $('#tabelaCaracteristicas').DataTable().rows('.selected').data().map(item => {
        $('#tabelaAplicacoes').DataTable().row.add({
          CARACTERISTICA: item.CODIGO,
          SUBCARACTERISTICA: item.DESCRICAO
        }).draw(false);
      });

      $('#tabelaComposicao').DataTable().rows().data().map(item => {
        $('#tabelaTecidosUtilizados').DataTable().row.add({
          SEL: botaoSelecionarGrid('checkAplicacoes'),
          CODIGO: item.CODIGO,
          DESCRICAO: item.DESCRICAO,
          ALTURA: retornaInputValor('txtAltura'),
          LARGURA: retornaInputValor('txtLargura'),
          FUNDO: retornaInputValor('txtFundo'),
          VISOR: retornaInputValor('txtVisor'),
          CONSUMO: retornaInputValor('txtConsumo'),
          COR: item.COR,
          FORNECEDOR: item.FORNECEDOR
        }).draw(false);
      });
    } finally {
      aplicaMascara();
    }
  };

  function botaoSelecionarGrid(sNomeCheck) {
    return '<div class="form-check">' +
      `<input type="checkbox" class="align-self-center ${sNomeCheck}" value"">` +
      '</div>';
  };

  function adicionaComposicao() {
    if ((pegaValor('#txtFornecedor') == '') || (pegaValor('#txtMaterial') == '') || (pegaValor('#txtCorItem') == '')) {
      msgAlerta('Necessário preencher todos os campos para adicionar composição.');
      return;
    }

    try {
      const composicao = {
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCorItem'),
        DESC_COR: pegaDescricao('#txtCorItem'),
        FORNECEDOR: pegaChave('#txtFornecedor'),
        NOME_FORNECEDOR: pegaDescricao('#txtFornecedor'),
        EXCLUIR: retornaBotaoExcluir(),
      };

      $('#tabelaComposicao').DataTable().row.add(composicao).draw(false);
    } finally {
      $('#txtMaterial').val('');
      $('#txtCorItem').val('');
      $('#txtFornecedor').val('');
      $('#modalComposicao').modal('hide');
    }
  };

  function retornaBotaoExcluir() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir-composicao"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '</div>'
    );
  }

  function retornaInputValor(sNomeInput, iIndex = 0) {
    return `<input type="text" class="input-default focus form-control camposMascara ${sNomeInput}" data-campo="${sNomeInput}" data-index="${iIndex}" value="0.00">`;
  };

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function ajustaTabelasModalItem() {
    $('#tabelaCaracteristicas').DataTable().columns.adjust().draw(false);
    $('#tabelaComposicao').DataTable().columns.adjust().draw(false);
    $('#tabelaFt').DataTable().columns.adjust().draw(false);
    $('#tabelaGrade').DataTable().columns.adjust().draw(false);
    $('#tabelaAplicacoes').DataTable().columns.adjust().draw(false);
    $('#tabelaTecidosUtilizados').DataTable().columns.adjust().draw(false);
    $('#tabelaConsumos').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafia').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSerigrafiaTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordado').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoProgramacao').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoTamanho').DataTable().columns.adjust().draw(false);
    $('#tabelaBordadoLocal').DataTable().columns.adjust().draw(false);
    $('#tabelaSublimacao').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotapeTipo').DataTable().columns.adjust().draw(false);
    $('#tabelaTermotape').DataTable().columns.adjust().draw(false);
  };

  function calculaTotaisGrade(sCampo, iIndex) {
    const valor = parseFloat($($('.' + sCampo)[iIndex]).val());
    const qtde = parseFloat($($('.txtQtdeGrade')[iIndex]).val());

    switch (sCampo) {
      case 'txtQtdeGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        dados.TOTAL = (parseFloat(dados.PRECO) * valor).toFixed(2);
        dados.PRECO_LIQ = dados.TOTAL;

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorAcres = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valorAcres).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValAcresGrade')[iIndex]).val(valorAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValAcresGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percAcres = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) + valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercAcresGrade')[iIndex]).val(percAcres.toFixed(2));
        $($('.txtPercDescGrade')[iIndex]).val('0.00');
        $($('.txtValDescGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtPercDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const valorDesc = TruncaDecimaisNova(2, (parseFloat(dados.PRECO_LIQ) * valor) / 100);
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valorDesc).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtValDescGrade')[iIndex]).val(valorDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
      case 'txtValDescGrade': {
        const dados = $('#tabelaGrade').DataTable().row(iIndex).data();
        const percDesc = TruncaDecimaisNova(2, valor / (parseFloat(dados.PRECO_LIQ) / 100));
        dados.TOTAL = (parseFloat(dados.PRECO_LIQ) - valor).toFixed(2);

        $('#tabelaGrade').DataTable().row(iIndex).data(dados).draw(false);
        $($('.txtPercDescGrade')[iIndex]).val(percDesc.toFixed(2));
        $($('.txtPercAcresGrade')[iIndex]).val('0.00');
        $($('.txtValAcresGrade')[iIndex]).val('0.00');
        break;
      }
    }

    $('.camposMascara').unbind();

    $('.txtCamposGrade').on('blur', function () {
      calculaTotaisGrade($(this).attr('data-campo').replace(' txtCamposGrade', ''), $(this).attr('data-index'));
    });

    aplicaMascara();

    $($('.' + sCampo)[iIndex]).val(valor.toFixed(2));
    $($('.txtQtdeGrade')[iIndex]).val(qtde.toFixed(2));

    atualizaTotaisGrade();
  };

  function atualizaTotaisGrade() {
    let qtdeTotal = 0;
    $('.txtQtdeGrade').each(index => { qtdeTotal += parseFloat($($('.txtQtdeGrade')[index]).val()) });

    const valTotal = $("#tabelaGrade").DataTable().column(8, {}).data().sum();

    insereValor('#txtQtdeTotal', qtdeTotal.toFixed(2));
    insereValor('#txtValTotal', valTotal.toFixed(2));
  };

  function zeraQtdeGrade() {
    calculaTotaisGrade('txtQtdeGrade', 0);
  }

  async function simulaFinanceiro() {
    let parcelas = [];
    for (let i = 0; i < 12; i++) {
      if ($(`#edtVencimento${i + 1}`).val() != "") {
        parcelas.push($(`#edtVencimento${i + 1}`).val());
      }
    }
    let i = 1;
    let diferenca;
    let valorNota = $("#txtValorTotal").html().substring(8).replace(".", "").replace(",", ".");
    let vValor = parseFloat((valorNota / parcelas.length).toFixed(2));
    if (
      valorNota > vValor * parcelas.length ||
      valorNota < vValor * parcelas.length
    ) {
      diferenca = (valorNota - vValor * parcelas.length).toFixed(2);
    }
    let guardaValor = vValor;
    let arrVenctos = await RetornaVencimentos(parcelas);
    $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);
    parcelas.forEach((element) => {
      if (element != "") {
        if (diferenca > 0 || i == 0) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
          diferenca = 0;
        } else {
          vValor = guardaValor;
        }
        if (diferenca < 0 && i == parcelas.length) {
          vValor = (vValor + parseFloat(diferenca)).toFixed(2);
        }
        vValor = `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i}" name="txtValorRec-${i}" value="${vValor}">`;
        $("#tabelaDuplicatas").DataTable().row.add([i, arrVenctos[i - 1], vValor]).draw(false);
      }
      i++;
    });
    focuValor();
  };

  async function RetornaVencimentos(arrDias) {
    let arrVencimentos = [];
    try {
      let dataAtual = new Date();
      for (let index = 0; index < arrDias.length; index++) {
        if (arrDias[index] != "") {
          let novoPrazo = new Date();
          novoPrazo.setDate(dataAtual.getDate() + parseInt(arrDias[index]));

          const response = await requisicao("GET", "/sisplan/nfe/v1/datavencimento?", `CODCLI=${pegaChave('#txtCliente')}&DATA=${formataData(novoPrazo)}`);
          const jsonStr = await response.text();

          let novaData = jsonStr.split('/')[2] + '-' + jsonStr.split('/')[1] + '-' + jsonStr.split('/')[0];
          novaData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${index}" name="txtDataRec" value="${novaData}"></input>`
          arrVencimentos.push(novaData);
        }
      }
      return arrVencimentos;
    } catch (error) {
      console.error(error);
    }
  };

  function focuValor() {
    $('.classeValorFin').on('focusout', function () {
      let parcelas = [];
      let vValor = 0;
      for (let i = 0; i < 12; i++) {
        if ($(`#edtVencimento${i + 1}`).val() != "") {
          parcelas.push($(`#edtVencimento${i + 1}`).val());
          vValor += parseFloat($(`#txtValorRec-${i + 1}`).val());
        }
      }
      const valorNota = $("#txtValorTotal").html().substring(8).replace(".", "").replace(",", ".");
      vValor = parseFloat((valorNota - vValor).toFixed(2));
      const valAtual = parseFloat($(`#txtValorRec-${parcelas.length}`).val());
      if (parseFloat((vValor + valAtual).toFixed(2)) > 0) {
        $(`#txtValorRec-${parcelas.length}`).val(parseFloat((vValor + valAtual).toFixed(2)));
      } else {
        msgAlerta('Valor das parcelas é superior ao total da nota, recalculo será efetuado!');
        simulaFinanceiro();
      }
    });
  };

  async function calculaTotaisItens() {
    $.LoadingOverlay("show");
    try {
      let itens = $(".itens");

      let nota = {};
      nota.CODCLI = pegaChave("#txtCliente");
      nota.DTEMISSAO = $("#txtDataEmissao").val();
      nota.NATUREZA = pegaChave("#txtNatureza");
      nota.ITENS = [];

      for (let i = 0; i < itens.length; i++) {
        if ($(seletorPorNome("txtProduto", i)).val() != "" && $(seletorPorNome("txtPreco", i)).val() != "" && $(seletorPorNome("txtQuantidade", i)).val() != "") {
          if ($(seletorPorNome("txtProduto", i)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", i)).attr("data-codigo") != "") {
            let item = {};
            item.CODIGO = $(seletorPorNome("txtProduto", i)).attr("data-codigo");
            item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", i)).val());
            item.PRECO = parseFloat($(seletorPorNome("txtPreco", i)).val());
            item.NATUREZA = nota.NATUREZA;
            item.VALOR = item.PRECO * item.QTDE;
            nota.ITENS.push(item);
          }
        }
      }

      if (nota.ITENS.length == 0) {
        zeraTotais();
        return;
      }

      try {
        const response = await requisicao("POST", "/sisplan/fatservico/v1/retornatotais?", '', JSON.stringify(nota), 300000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        let qtdeTotal = 0;
        jsonStr.itens.map(item => { qtdeTotal += item.qtde; });

        $("#txtTotalLiquido").html(parseFloat(jsonStr.valor_liq).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorTotal").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtTotalQtde").html(parseFloat(qtdeTotal));

        $("#txtValorPis").html(parseFloat(jsonStr.val_pis).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorCofins").html(parseFloat(jsonStr.val_cofins).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorIss").html(parseFloat(jsonStr.valor_iss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $("#txtValorCsll").html(parseFloat(jsonStr.val_csll).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorInss").html(parseFloat(jsonStr.val_inss).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
        $("#txtValorIrrf").html(parseFloat(jsonStr.val_irrf).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

        $("#txtValorFinanceiro").html(parseFloat(jsonStr.valor).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $(".collapse").on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-right").removeClass("fa-angle-right").addClass("fa-angle-down");
  }).on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);
    clicked.parent().find(".fa-angle-down").removeClass("fa-angle-down").addClass("fa-angle-right");
  });

  $("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
    setTimeout(() => { $(this).css("color", "red"); }, 200);
    setTimeout(() => { $(this).css("color", "inherit"); }, 2000);
  });

  $("#dropdown").trigger("change");

  $("#gravar").click(async function () {
    $(this).attr('disabled', true);

    if (!validaDadosItens()) {
      return;
    }

    $.LoadingOverlay("show");
    try {

      let arrayItens = [];
      for (let index = 0; index < $(".itens").length; index++) {
        if ($(seletorPorNome("txtProduto", index)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", index)).attr("data-codigo") != "") {
          arrayItens.push({
            CODIGO: $(seletorPorNome("txtProduto", index)).attr("data-codigo"),
            DESCRICAO: $(seletorPorNome("txtProduto", index)).attr("data-descricao"),
            QUALIDADE: '1',
            QTDE: parseFloat($(seletorPorNome("txtQuantidade", index)).val()),
            PRECO: parseFloat($(seletorPorNome("txtPreco", index)).val()),
            VALOR_TOTAL: (parseFloat($(seletorPorNome("txtQuantidade", index)).val()) * parseFloat($(seletorPorNome("txtPreco", index)).val())).toFixed(2),
          });
        }
      }

      const classOs = {
        NUMERO: pegaValor('#txtNumero'),
        USUARIO: pegaValor('#txtUsuario'),
        CODREP: pegaChave('#txtVendedor'),
        CLIENTE: pegaChave('#txtCliente'),
        DT_CADASTRO: pegaValor('#txtDataEmissao'),
        DT_SAIDA: pegaValor('#txtDataSaida'),
        TERCEIRO: pegaChave('#txtExecutor'),
        DUPLICATA: pegaValor('#txtDuplicata'),
        DESCONTO: pegaValor('#txtPercDesc'),
        STATUS: pegaChave('#txtStatus'),
        REQUISITANTE: pegaValor('#txtRequisitante'),
        SETOR: pegaChave('#txtSetor'),
        OBSERVACAO: pegaValor('#txtObservacao'),
        TAB_PRE: pegaChave('#txtTabPreco'),
        DESCONTO_VALOR: pegaValor('#txtDesconto'),
        DT_BAIXA: pegaValor('#txtDtBaixa'),
        PEDIDO: pegaChave('#txtPedido'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        VEICULO: pegaValor('#txtVeiculo'),
        ANO_MODELO: pegaValor('#txtAnoModelo'),
        KILOMETRAGEM: pegaValor('#txtQuilometragem'),
        CHASSI: pegaValor('#txtChassi'),
        PLACA: pegaValor('#txtPlaca'),
        ITENS: arrayItens
      };

      const response = await requisicao('POST', '/sisplan/os/v1/ordemservico?', '', `JSON=${encodeURIComponent(JSON.stringify(classOs))}`, 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      criaMensagemSucesso('Ordem de serviço gravada com sucesso.', () => { window.location.href = `${BASE_URI}/ordemservico`; });

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgErro(`Não foi possível gravar os dados da ordem de serviço: ${error}`);
    } finally {
      $(this).attr('disabled', false);
    }
  });

  function trocaIdClass(seletor, indice) {
    const classe = seletor.substring(1);
    $(`${seletor}-${indice}`).addClass(`${classe}-atual`).removeClass(`${classe}-${indice}`);
    $(`${seletor}-atual`).addClass(`${classe}-${indice - 1}`).removeClass(`${classe}-atual`);
  };

  async function DeleteItem(id) {
    let itens = $(".itens");
    for (let i = 0; i < itens.length; i++) {
      if (i == id) {
        $(`.item-${i}`).addClass(`removido`).removeClass(`item-${i}`);
      } else if (i > id) {
        $(`.item-${i}`).addClass(`atual`).removeClass(`item-${i}`);
        $(`.atual`).addClass(`item-${i - 1}`).removeClass(`atual`);
        trocaIdClass(`.btn-limpa`, i);
        trocaIdClass(`.btn-edit`, i);
        trocaIdClass(`.btn-add`, i);
        trocaIdClass(`.txtItem`, i);
        $(`.contador.item-${i - 1}>span`).html(i);
      }
    }
    await calculaTotaisItens();
  };

  function validaDadosItens() {
    const servico = $($(".classeProduto")[0]).val();
    const qtde = $($(".classeQuantidade")[0]).val();
    const preco = $($(".classePreco")[0]).val();

    if ([servico, qtde, preco].includes('')) {
      msgAlerta('Serviço, quantidade ou preço não informados.\nFavor voltar a aba de itens e verificar.');
      return false;
    }
    return true;
  };

  function zeraTotais() {
    $("#txtTotalLiquido").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorTotal").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtTotalQtde").html(parseFloat(0));

    $("#txtValorPis").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorCofins").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorCsll").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorInss").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    $("#txtValorIrrf").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));

    $("#txtValorFinanceiro").html(parseFloat(0).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  };

  async function carregaValoresPadroes() {
    if ($(window.location.href.split('/')).get(-1) != 'create') {
      return;
    }

    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'NOTA'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    // jsonStr.map(item => {
    //   switch (item.CAMPO) {
    //     case 'OPERACAO': {
    //       if (item.VALOR != '') {
    //         insereValor('#txtReducao', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoVenda', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoNota', item.VALOR, 'VALOR PADRÃO');
    //         insereValor('#txtOperacaoMovimentacao', item.VALOR, 'VALOR PADRÃO');
    //       }
    //       break;
    //     }
    //     case 'DEPOSITO': {
    //       if (item.VALOR != '') {
    //         insereValor('#txtDeposito', item.VALOR, 'VALOR PADRÃO');
    //       }
    //       break;
    //     }
    //   }
    // });
  };

  function seletorPorNome(name, i) {
    return `.item-${i}>div>input[name*="${name}"]`;
  };

  function addPesquisaAutocompleta() {
    $("#txtCliente").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $("#btn-cliente").pesquisa_serverside(["#txtCliente", "#txtCNPJ"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $("#btn-limpa-cliente").on("click", function () { $("#txtCliente").val(""); $("#txtCNPJ").val(""); $("#txtCliente").trigger("blur"); });

    $("#txtRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Representante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Representante");
    $("#btn-limpa-Representante").on("click", function () { $("#txtRepresentante").val(""); });

    $("#txtAgencia").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null }`);
    $("#btn-Agencia").pesquisa_serverside(["#txtAgencia"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, "Pesquisa Agência");
    $("#btn-limpa-Agencia").on("click", function () { $("#txtAgencia").val(""); });

    $("#txtSolicitante").autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["NUMERO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
    $("#btn-Solicitante").pesquisa_serverside(["#txtSolicitante"], ["NUMERO"], ["NOME"], `{"tabela":"CONTATO", "camposSelect":[ "NUMERO", "NOME" ], "where": []}`, "Pesquisa Solicitante");
    $("#btn-limpa-Solicitante").on("click", function () { $("#txtSolicitante").val(""); });

    $("#txtTabPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
    $("#btn-TabPreco").pesquisa_serverside(["#txtTabPreco"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`, "Pesquisa Tabela de Preço");
    $("#btn-limpa-TabPreco").on("click", function () { $("#txtTabPreco").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-classeGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-classeGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMoeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btnAMoeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtNatureza").autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`);
    $("#btn-natureza").pesquisa("#txtNatureza", "NATUREZA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`, "Pesquisa Natureza", "natureza");
    $("#btn-limpa-natureza").on("click", function () { $("#txtNatureza").val(""); });

    $("#txtTransportadora").autocompleta(1, `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`);
    $("#btnTransportadora").pesquisa("#txtTransportadora", "CODIGO", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtran", "camposSelect":[ "codigo", "nome" ], "where": null}', "Pesquisa Transportadora", "tabtran");
    $("#btnATransportadora").on("click", function () { $("#txtTransportadora").val(""); });

    $("#txtCodigo").autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Codigo").pesquisa("#txtCodigo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Produto", "PRODUTO");
    $("#btn-limpa-Codigo").on("click", function () { $("#txtCodigo").val(""); });

    $("#txtCor").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Cor").pesquisa("#txtCor", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btn-limpa-Cor").on("click", function () { $("#txtCor").val(""); });

    $("#txtLinha").autocompleta(1, `JSON={ "tabela":"TABLIN", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Linha").pesquisa("#txtLinha", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Linha", "TABLIN");
    $("#btn-limpa-Linha").on("click", function () { $("#txtLinha").val(""); });

    $("#txtGrupo").autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Grupo", "GRUPO_PA");
    $("#btn-limpa-Grupo").on("click", function () { $("#txtGrupo").val(""); });

    $("#txtEtiqueta").autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Etiqueta").pesquisa("#txtEtiqueta", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Etiqueta", "ETQ_PROD");
    $("#btn-limpa-Etiqueta").on("click", function () { $("#txtEtiqueta").val(""); });

    $("#txtMarkup").autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Markup").pesquisa("#txtMarkup", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Markup", "CAD_MARKUP");
    $("#btn-limpa-Markup").on("click", function () { $("#txtMarkup").val(""); });

    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Depósito", "DEPOSITO");
    $("#btn-limpa-Deposito").on("click", function () { $("#txtDeposito").val(""); });

    $("#txtFornecedor").autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`);
    $("#btnFornecedor").pesquisa_serverside(["#txtFornecedor"], ["CODCLI", "CNPJ"], ["NOME"], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
    $("#btnAFornecedor").on("click", function () { $("#txtFornecedor").val(""); });

    $("#txtMaterial").autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnMaterial").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Material", "MATERIAL");
    $("#btnAMaterial").on("click", function () { $("#txtMaterial").val(""); });

    $("#txtCorItem").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCor").pesquisa("#txtCorItem", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACor").on("click", function () { $("#txtCorItem").val(""); });

    $("#txtCorGrade").autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnCorGrade").pesquisa("#txtCorGrade", "COR", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', "Pesquisa Cor", "CADCOR");
    $("#btnACorGrade").on("click", function () { $("#txtCorGrade").val(""); });

    $("#txtFaixa").autocompleta(1, `JSON={ "tabela":"FAIXA", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btnFaixa").pesquisa("#txtFaixa", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA", "camposSelect":[ "CODIGO", "descricao" ], "where": null}', "Pesquisa Faixa", "Faixa");
    $("#btnAFaixa").on("click", function () { $("#txtFaixa").val(""); });
  };

  function criaMascaraCampos() {
    $("#txtTamCm2, #txtLarguraBordado, #txtAlturaBordado, #txtLarguraSerigrafia, #txtAlturaSerigrafia, #txtComissaoFat, #txtComissaoRec, #txtComissao, #txtAliquota, #txtValFrete, #txtPesoBruto, #txtPesoLiquido, #txtFrete, #txtQtde, #txtPreco").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#txtTotalPecasTermotape, #txtTotalPecasBordado, #txtQtdeProg, #txtTotalPecasSerigrafia, #txtVolumes, #txtQtdeCores").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  };

  function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextFs) - 2).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs) - 2).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };

  function addValidacaoCamposObrigatorios() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCliente: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtTransportadora: {
          required: true,
        },
        "txtProduto-0": {
          required: true,
        },
        "txtQuantidade-0": {
          required: true,
        },
        "txtPreco-0": {
          required: true,
        }
      },
      messages: {
        txtCliente: {
          required: "Informe um cliente válido.",
        },
        txtDeposito: {
          required: "Informe um depósito válido.",
        },
        txtTransportadora: {
          required: "Informe uma transportadora válida.",
        },
        "txtProduto-0": {
          required: "Informe um produto válido.",
        },
        "txtQuantidade-0": {
          required: "Informe uma quantidade válida.",
        },
        "txtPreco-0": {
          required: "Informe um preço válido.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

});

