$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaNatureza',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma natureza.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaNatureza',
                popover: {
                    title: 'Tabela Natureza',
                    description: 'Aqui estão os dados das naturezas cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("NATUREZA");

    $('#txtCstIcms').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstPis').autocompleta(1, `JSON={ "tabela":"TABPIS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpi').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstCofins').autocompleta(1, `JSON={ "tabela":"TABCOFINS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNcm').autocompleta(1, `JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCsosn').autocompleta(1, `JSON={ "tabela":"TABCSOSN", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#btnCstIcms').pesquisa('#txtCstIcms', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'tabtri');
    $('#btnCstPis').pesquisa('#txtCstPis', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPIS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST PIS', 'TABPIS');
    $('#btnCstIpi').pesquisa('#txtCstIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST IPI', 'TABIPI');
    $('#btnCstCofins').pesquisa('#txtCstCofins', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABCOFINS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST COFINS', 'TABCOFINS');
    $('#btnNcm').pesquisa('#txtNcm', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa NCM', 'TABFIS');
    $('#btnCsosn').pesquisa('#txtCsosn', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABCSOSN", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CSOSN', 'TABCSOSN');

    $('#btnACstCofins').on('click', function () {
        $('#txtCstCofins').val('');
    });
    $('#btnACstIpi').on('click', function () {
        $('#txtCstIpi').val('');
    });
    $('#btnACstIcms').on('click', function () {
        $('#txtCstIcms').val('');
    });
    $('#btnACstPis').on('click', function () {
        $('#txtCstPis').val('');
    });
    $('#btnACsosn').on('click', function () {
        $('#txtCsosn').val('');
    });
    $('#btnANcm').on('click', function () {
        $('#txtNcm').val('');
    });


    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovaNatureza').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "natureza/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
            '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaNatureza();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaNatureza(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCstIcms').val('');
        $('#txtCstIpi').val('');
        $('#txtNcm').val('');
        $('#txtCstPis').val('');
        $('#txtCstCofins').val('');
        $('#txtCsosn').val('');
    });

    async function consultaNatureza(bBotao = false) {
        try {
            $.LoadingOverlay("show");
            let response;
            let csticms = pegaChave('#txtCstIcms') != '' ? ` AND CLATRIB = '${pegaChave('#txtCstIcms')}'` : '';
            let cstpis = pegaChave('#txtCstPis') != '' ? ` AND CLAPIS = '${pegaChave('#txtCstPis')}'` : '';
            let cstipi = pegaChave('#txtCstIpi') != '' ? ` AND CLAIPI = '${pegaChave('#txtCstIpi')}'` : '';
            let cstcofins = pegaChave('#txtCstCofins') != '' ? ` AND CLACOFINS = '${pegaChave('#txtCstCofins')}'` : '';
            let ncm = pegaChave('#txtNcm') != '' ? ` AND CLAFIS = '${pegaChave('#txtNcm')}'` : '';
            let csosn = pegaChave('#txtCsosn') != '' ? ` AND CSOSN = '${pegaChave('#txtCsosn')}'` : '';

            if (bBotao) {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"],  "where": ["1=1 ${csticms}  ${cstpis}  ${cstipi}  ${cstcofins} ${ncm} ${csosn}"]}`, null);
            } else {
                response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"], "where": null}', null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaNatureza').DataTable({
                destroy: true,
                lengthChange: false,
                serverside: true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "NATUREZA"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                }
                }]
            });
            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#tabelaNatureza').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaNatureza').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('NATUREZA', data.NATUREZA);
            if (registroLiberado) {
                let novoNumero = btoa(data.NATUREZA);
                window.location.href = `natureza/${String(novoNumero)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaNatureza').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaNatureza').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('NATUREZA', data.NATUREZA);
            if (registroLiberado) {
                let novoNumero = btoa(data.NATUREZA);
                window.location.href = `natureza/${String(novoNumero)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaNatureza').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaNatureza").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $('#tabelaNatureza').on('click', '#btn-duplicar', async function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            let data = $('#tabelaNatureza').DataTable().row($(this).parents('tr')).data();
            await duplicaCadastroNatureza(data.NATUREZA)
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/natureza?", `CODIGONATUREZA=${encodeURIComponent(valorLinha.NATUREZA)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});