$("#tutorial").on("click", function () {
    $("#geral-tab").trigger("click");
    $('#cbGeraContabil').prop('checked', true)
    $('#cbGeraContabil').trigger('change')
    const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        onHighlightStarted: (Element) => {
            if (Element.node.id == "dados") {
                if (!$("#multiCollapseExample1").hasClass("show"));
                $("#multiCollapseExample1").collapse("show");
            } else if (Element.node.id == "financeiro") {
                if (!$("#collapseFiltros").hasClass("show")) {
                    $("#financeiro").collapse("show");
                    $("#multiCollapseExample2").collapse("show");
                }
            } else if (Element.node.id == "contabilidade") {
                if (!$("#collapseFiltros").hasClass("show")) {
                    $("#contabilidade").collapse("show");
                    $("#multiCollapseExample3").collapse("show");
                }
            }
        },
        onPrevious: (Element) => {
            if (
                Element.node.id == "financeiro-tab" ||
                Element.node.id == "financeiro"
            ) {
                if (!$("#financeiro>a").hasClass("collapsed")) {
                    $("#multiCollapseExample2").collapse("show");
                }
            } else if (Element.node.id == "contabilidade") {
                if (!$("#financeiro>a").hasClass("collapsed")) {
                    $("#financeiro").collapse("show");
                }
            }
        },
    });

    driver.defineSteps([{
        element: "#dados",
        popover: {
            title: "Aba Dados",
            description: "Clique aqui para abrir a aba dados.",
            position: "botton",
        },
    },
    {
        element: "#multiCollapseExample1",
        popover: {
            title: "Dados de Cadastro Geral",
            description: "Esses são os campos que você informará os dados gerais de cadastro.",
            position: "top",
        },
    },
    {
        element: "#financeiro",
        popover: {
            title: "Aba Financeiro",
            description: "Clique aqui para abrir aba financeiro.",
            position: "top",
        },
    },
    {
        element: "#multiCollapseExample2",
        popover: {
            title: "Dados Financeiros",
            description: "Aqui ficam os dados financeiros ligados ao documento.",
            position: "top",
        },
    },
    {
        element: "#contabilidade",
        popover: {
            title: "Aba Contabilidade",
            description: "Clique aqui para abrir aba contabilidade.",
            position: "top",
        },
    },
    {
        element: "#multiCollapseExample3",
        popover: {
            title: "Dados Contábeis",
            description: "Aqui ficam os dados contábeis cadastrados a este documento.",
            position: "top",
        },
    },
    {
        element: "#btnContabil",
        popover: {
            title: "Incluir Contabilidade",
            description: "Clique aqui para incluir um registro contábil.",
            position: "top",
        },
    },
    {
        element: "#btnRateio",
        popover: {
            title: "Incluir Rateio",
            description: "Clique aqui para incluir um rateio.",
            position: "top",
        },
    },
    {
        element: "#btnVoltar",
        popover: {
            title: "Botão Voltar",
            description: "Ao clicar nesse botão você retorna para a tela de consulta de movimento bancário.",
            position: "left",
        },
    },
    {
        element: "#gravar",
        popover: {
            title: "Botão Gravar",
            description: "Ao clicar nesse botão você grava os dados inseridos.",
            position: "left",
        },
    },
    ]);

    driver.start();
    driver.getHighlightedElement();
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let movimento = parametros[parametros.length - 1] == 'create' ? parametros[parametros.length - 1] : descriptografaUrl(parametros[parametros.length - 1]);
    let lancamento = movimento != 'create' ? movimento.split('O')[0] : '';
    let operacao = movimento != 'create' ? movimento.split('O')[1].split('C')[0] : '';
    let conta = movimento != 'create' ? movimento.split('O')[1].split('C')[1].split('D')[0] : '';
    let docto = movimento != 'create' ? movimento.split('O')[1].split('C')[1].split('D')[1] : '';

    operacao = operacao == 'X' ? '-' : '+'
    let duplicando = localStorage.getItem('duplicarmovimento') == 'true' ? true : false
    localStorage.removeItem('duplicarmovimento')

    let parametrosContabil = await BuscaParametrosContabil()

    let alterandoContabil = false;
    let indiceLinhaContabil = 0;

    let alterandoRateio = false;
    let indiceLinhaRateio = 0;

    let lancamentoOrig;
    let operacaoOrig;
    let contaOrig;
    let doctoOrig;
    let incluindo = false;

    $('#txtConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO" ], "where": ["ATIVO = 'S'"]}`);
    $('#txtHistorico').autocompleta(1, 'JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtCliente').autocompleta(1, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO" ], "where": null}');
    $('#txtMoeda').autocompleta(1, 'JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');
    $('#txtClasseGer').autocompleta(1, 'JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}');

    $('#btn-ContaConsulta').pesquisa_serverside(['#txtConta'], ['CONTA'], ['DESCRICAO'], `{ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Conta');
    $('#btn-HistoricoConsulta').pesquisa_serverside(['#txtHistorico'], ['HISTORICO'], ['DESCRICAO'], `{ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Histórico');
    $('#btn-ClienteConsulta').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Cliente');
    $('#btn-MoedaConsulta').pesquisa_serverside(['#txtMoeda'], ['CODMOE'], ['DESCRICAO'], `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}`, 'Pesquisa de Moeda');
    $('#btn-ClasseGerConsulta').pesquisa_serverside(['#txtClasseGer'], ['CODIGO'], ['DESCRICAO', 'OPERACAO'], `{ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO", "OPERACAO"], "where": null}`, 'Pesquisa de Classe Gerencial');

    $('#btn-limpa-Conta').on('click', function () {
        $('#txtConta').val('')
        $('#txtBanco').val('')
    })
    $('#btn-limpa-Historico').on('click', function () { $('#txtHistorico').val('') })
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val('') })
    $('#btn-limpa-Moeda').on('click', function () { $('#txtMoeda').val('') })
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').val('') })

    $('#txtConta').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const pesquisaParam = {
                    tabela: "CADCONTA",
                    camposSelect: [
                        "CADBAN.BANCO",
                        "CADBAN.NOME_BANCO"
                    ],
                    leftJoin: [
                        { tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },
                    ],
                    where: [`CADCONTA.CONTA = '${pegaChave('#txtConta')}'`],
                };

                const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    $('#txtBanco').val(`${jsonStr[0].BANCO} - ${jsonStr[0].NOME_BANCO}`)
                }
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtClasseGer').on('blur', async function () {
        $.LoadingOverlay('show')
        try {
            try {
                const pesquisaParam = {
                    tabela: "CLASSE_GER",
                    camposSelect: [
                        "OPERACAO"
                    ],
                    where: [`CODIGO = '${pegaChave('#txtClasseGer')}'`],
                };

                const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                if (jsonStr.length > 0) {
                    $('#txtOperacao').val(jsonStr[0].OPERACAO)
                }
            } catch (error) {
                console.error(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtValorMoeda').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtValorTaxa').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtValor').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtValorDoc').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#cbGeraContabil').on('change', function () {
        if ($('#cbGeraContabil').is(':checked')) {
            $('#contabilidade').removeClass('d-none')
            $('#multiCollapseExample3').removeClass('d-none')
        } else {
            $('#contabilidade').addClass('d-none')
            $('#multiCollapseExample3').addClass('d-none')
        }
    })

    if (parametrosContabil[0].VALOR == '1') {
        $('#cbGeraContabil').prop('checked', true)
    } else {
        $('#cbGeraContabil').prop('checked', false)
    }

    $('#cbGeraContabil').trigger('change')

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("MOVIMENTOBANCARIO", getCookie("usuario"), lancamento);
        window.location.href = `${BASE_URI}/movimentobancario`;
    });

    $(document).ready(function () {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtClasseGer: {
                    required: true,
                },
                txtHistorico: {
                    required: true,
                },
                txtConta: {
                    required: true,
                },
                txtDocumento: {
                    required: true,
                },
                txtValor: {
                    required: true,
                },

            },
            messages: {
                txtClasseGer: {
                    required: "Informe uma classe gerencial.",
                },
                txtHistorico: {
                    required: "Informe um histórico.",
                },
                txtConta: {
                    required: "Informe uma conta.",
                },
                txtDocumento: {
                    required: "Informe um documento.",
                },
                txtValor: {
                    required: "Informe um valor.",
                },

            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });

        $(".radio-group .radio").click(function () {
            $(this).parent().find(".radio").removeClass("selected");
            $(this).addClass("selected");
        });

        $(".submit").click(function () {
            return false;
        });
    });

    //BUSCA DADOS AO ABRIR A TELA
    if (movimento != "" && movimento != "create") {
        if (((!duplicando) && (await liberarRegistro("MOVIMENTOBANCARIO", lancamento)) == false)){
            window.location.href = "../movimentobancario";
        } else {
            try {
                $.LoadingOverlay("show");
                try {
                    const url = "/sisplan/movimentobancario/v1/consultamanutencao?";
                    const filtros = `LANCAMENTO=${lancamento}&DOCTO=${encodeURIComponent(docto)}&CONTA=${encodeURIComponent(conta)}&OPERACAO=${encodeURIComponent(operacao)}`
                    const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr['RESULT'][0].mensagem);
                        return;
                    }

                    !duplicando ? $("#txtLancamento").val(jsonStr[0].LANCAMENTO) : $("#txtLancamento").val('');
                    $("#txtBanco").val(`${jsonStr[0].BANCO} - ${jsonStr[0].DESC_BANCO}`);
                    !duplicando ? $("#txtDocumento").val(jsonStr[0].DOCTO) : $("#txtDocumento").val('');
                    $("#dtVencimento").val(jsonStr[0].DT_VENCTO);
                    $("#dtContabilizacao").val(jsonStr[0].DT_CONT);
                    $("#dtLancamento").val(jsonStr[0].DT_LAN);
                    $("#txtOperacao").val(jsonStr[0].OPERACAO);
                    $("#txtTipo").val(jsonStr[0].TIPO);
                    $("#txtEmpId").val(jsonStr[0].EMP_ID);
                    $("#txtAntecipacao").val(jsonStr[0].NUMAP_ANTEC);
                    $("#txtObs").val(jsonStr[0].OBSERVACAO);
                    $("#txtValorMoeda").val(jsonStr[0].VALOR_MOEDA);
                    $('#txtValorTaxa').val(jsonStr[0].TAXA_MOEDA);
                    $('#txtValor').val(jsonStr[0].VALOR);
                    $('#txtLanctoConc').val(jsonStr[0].LANC_CON);

                    insereValor('#txtConta', jsonStr[0].CONTA, jsonStr[0].DESC_CONTA);
                    insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESC_HISTORICO);
                    insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME_CLIENTE);
                    insereValor('#txtClasseGer', jsonStr[0].CLASSE, jsonStr[0].DESC_CLASSE);
                    jsonStr[0].DESC_MOEDA != '' ? insereValor('#txtMoeda', jsonStr[0].MOEDA, jsonStr[0].DESC_MOEDA) : '';

                    jsonStr[0].PENDENTE == 'N' ? $('#rdBaixado').prop('checked', true) : $('#rdPendente').prop('checked', true)

                    if (jsonStr[0].NUMAP_ANTEC != '') {
                        $('#txtValor').prop('disabled', true)
                        $('#txtValorMoeda').prop('disabled', true)
                        $('#txtValorTaxa').prop('disabled', true)
                    } else {
                        $('#txtValor').prop('disabled', false)
                        $('#txtValorMoeda').prop('disabled', false)
                        $('#txtValorTaxa').prop('disabled', false)
                    }

                    lancamentoOrig = jsonStr[0].LANCAMENTO;
                    contaOrig = jsonStr[0].CONTA;
                    doctoOrig = jsonStr[0].DOCTO;
                    operacaoOrig = jsonStr[0].OPERACAO;
                    incluindo = false;

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da movimentação: ${error}`);
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        }
    } else {
        let date = new Date().toISOString().split('T')[0]
        $("#dtVencimento").val(date);
        $("#dtLancamento").val(date);
        $("#dtContabilizacao").val(date);

        $('#txtTipo').val('L')
        $('#txtEmpId').val(getCookie('emp_id'))
        incluindo = true;
    }

    //FUNÇÃO DE GRAVAR
    async function gravarDados(classe) {
        try {
            $.LoadingOverlay("show");
            let response = await requisicao(
                "POST",
                "/sisplan/movimentobancario/v1/manutencao?",
                `JSON=${encodeURIComponent(JSON.stringify(classe))}`,
                null
            );

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr
                .success(
                    `Cadastro efetuado com sucesso!`,
                    "Confirmação",
                    {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 5000,
                        fadeOut: 3000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/movimentobancario`;
                        },
                    }
                )
                .css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da manutenção: ${error}`);
        }
    }

    $("#gravar").click(async function () {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            //data de contabilização precisa ser maior que a data de lançamento

            if (!validaData($('#dtVencimento').val())) {
                msgAlerta('A data de vencimento está fora do período normal.');
                return;
            }

            if (!validaData($('#dtLancamento').val())) {
                msgAlerta('A data de lançamento está fora do período normal.');
                return;
            }

            if (!validaData($('#dtContabilizacao').val())) {
                msgAlerta('A data de contabilização está fora do período normal.');
                return;
            }

            if (new Date($('#dtLancamento').val()) > new Date($('#dtContabilizacao').val())) {
                msgAlerta('A Data de Contabilização deve ser maior que a Data de Lançamento.')
                return;
            }

            if ($('#txtTipo').val().toUpperCase() != 'P') {
                if ($('#txtMoeda').val() == '') {
                    msgAlerta('Moeda não informada!');
                    return;
                }
            }

            if ($('#txtValor').val() == '' || $('#txtValor').val() == 0) {
                msgAlerta('Valor não informado!')
                return;
            }

            if (verificaCaracteresEspeciais($('#txtDocumento').val()) == 1) {
                msgAlerta('O Numero da Duplicata não pode conter os seguintes caracteres: , :  ?  *  "  <  >  |')
                $('#txtDocumento').focus()
                return;
            }

            let classe = await montaClasseManutencao();

            if (!incluindo) {
                if (classe.OPERACAO != classe.OPERACAOORIG) {
                    msgAguardaConfirmacao('A operação foi alterada, deseja continuar?', async () => {
                        await gravarDados(classe)
                    })
                } else[
                    await gravarDados(classe)
                ]
            } else {
                await gravarDados(classe)
            }
        }
    });

    async function montaClasseManutencao() {
        if (duplicando){
            incluindo = true
        } 
        const classe = {}

        classe.LANCAMENTO = $('#txtLancamento').val();
        classe.CONTA = pegaChave('#txtConta');
        classe.BANCO = $('#txtBanco').val().split(' - ')[0];
        classe.DOCUMENTO = $('#txtDocumento').val();
        classe.DTVENCIMENTO = $('#dtVencimento').val();
        classe.DTLANCAMENTO = $('#dtLancamento').val();
        classe.DTCONTABILIZACAO = $('#dtContabilizacao').val();
        classe.PENDENTE = $('#rdPendente').is(':checked') ? 'S' : 'N';
        classe.MOEDA = pegaChave('#txtMoeda')
        classe.HISTORICO = pegaChave('#txtHistorico');
        classe.CLIENTE = pegaChave('#txtCliente');
        classe.CLASSEGER = pegaChave('#txtClasseGer');
        classe.OPERACAO = $('#txtOperacao').val();
        classe.TIPO = $('#txtTipo').val();
        classe.EMPID = $('#txtEmpId').val();
        classe.ANTECIPACAO = $('#txtAntecipacao').val();
        classe.OBSERVACAO = $('#txtObs').val();
        classe.VALORMOEDA = $('#txtValorMoeda').val();
        classe.TAXAMOEDA = $('#txtValorTaxa').val();
        classe.VALOR = $('#txtValor').val();
        classe.LANCTOCONC = $('#txtLanctoConc').val();
        classe.VALORDOC = $('#txtValorDoc').val();
        classe.LANCAMENTOORIG = lancamentoOrig;
        classe.CONTAORIG = contaOrig;
        classe.OPERACAOORIG = operacaoOrig;
        classe.DOCTOORIG = doctoOrig;
        classe.INCLUINDO = incluindo ? 'S' : 'N'
        classe.TIPOANTE = $('#rdPagar').is(':checked') ? 'P' : 'R';
        classe.GERACONTABILIZACAO = $('#cbGeraContabil').is(':checked') ? 'S' : 'N';
        classe.CONTABILIZACAO = montaArrayContabilizacao();

        return classe
    }

    function montaArrayContabilizacao() {
        const array = []
        let novaRow = {}
        const tabela = $('#tabelaContabilidade').DataTable().data().toArray();

        for (let i = 0; i < tabela.length; i++) {
            novaRow = {}

            novaRow.DEBITA = tabela[i][0];
            novaRow.CREDITA = tabela[i][2];
            novaRow.VALOR = tabela[i][4];
            novaRow.OBS = tabela[i][5];
            novaRow.ORDEM = tabela[i][6];
            novaRow.RATEIO = montaArrayRateio(tabela[i][6]);

            array.push(novaRow)
        }

        return array;
    }

    function montaArrayRateio(ordem) {
        const array = []
        let novaRow = {}
        const tabela = $('#tabelaRateio').DataTable().data().toArray();

        for (let i = 0; i < tabela.length; i++) {
            if (ordem == tabela[i][4]) {
                novaRow = {}

                novaRow.CODIGO = tabela[i][0];
                novaRow.PERC = tabela[i][2];
                novaRow.VALOR = tabela[i][3];

                array.push(novaRow)
            }
        }

        return array;
    }

    function validaData(data) {
        let dataAtual = new Date();

        let dataEntrada = new Date(data);

        let dataMinima = new Date();
        dataMinima.setDate(dataAtual.getDate() - 180);

        if (dataEntrada >= dataMinima) {
            return true; // Data válida
        } else {
            return false; // Data inválida
        }
    }

    function verificaCaracteresEspeciais(str) {
        // Verificar se contem ',' ':' '?' '*' '"' '<' '>' ou '|'
        if (str.includes(',') || str.includes(':') || str.includes('?') ||
            str.includes('*') || str.includes('"') || str.includes('<') ||
            str.includes('>') || str.includes('|')) {
            return 1;
        } else {
            return 0;
        }
    }

    await criaDataTableFinanceiro()
    await criaDataTableContabilidade()
    await criaDataTableRaterio()

    async function criaDataTableFinanceiro() {

        if ($.fn.DataTable.isDataTable('#tabelaFinanceiro')) {
            $("#tabelaFinanceiro").DataTable().destroy();
            $("#tabelaFinanceiro").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Numero',
        })
        dataSetCols.push({
            'title': 'Código',
        })
        dataSetCols.push({
            'title': 'Nome',
        })
        dataSetCols.push({
            'title': 'Emissão',
        })
        dataSetCols.push({
            'title': 'Vencimento',
        })
        dataSetCols.push({
            'title': 'Desconto',
        })
        dataSetCols.push({
            'title': 'Juros',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Empresa',
        })

        $('#tabelaFinanceiro').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    type: "date-br",
                    render(data) {
                        return new Intl.DateTimeFormat("pt-BR").format(
                            new Date(`${data.split(" ")[0]} 23:59:59`)
                        );
                    },
                    targets: [3, 4]
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [5, 6, 7],
                    "className": 'pr-4 text-right'
                },
            ]
        });

        await carregaFinanceiro()
    };

    async function carregaFinanceiro() {
        if ((!duplicando) && (movimento != '' && movimento != 'create')) {
            $.LoadingOverlay('show')
            try {
                try {
                    const url = "/sisplan/movimentobancario/v1/buscafinanceiro?";
                    const filtros = `LANCAMENTO=${lancamento}&DOCTO=${encodeURIComponent(docto)}&CONTA=${encodeURIComponent(conta)}&OPERACAO=${encodeURIComponent(operacao)}&TIPO=${$('#txtTipo').val()}`
                    const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                    if (!response) {
                        return;
                    }

                    let jsonStrFinan = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStrFinan['RESULT'][0].mensagem);
                        return;
                    }

                    if (jsonStrFinan.length == 0) {
                        return;
                    }

                    let novoRegistro = []

                    for (let i = 0; i < jsonStrFinan.length; i++) {
                        novoRegistro = []

                        novoRegistro.push(jsonStrFinan[i].NUMERO)
                        novoRegistro.push(jsonStrFinan[i].CODIGO)
                        novoRegistro.push(jsonStrFinan[i].NOME)
                        novoRegistro.push(jsonStrFinan[i].EMISSAO)
                        novoRegistro.push(jsonStrFinan[i].VENCTO)
                        novoRegistro.push(jsonStrFinan[i].DESCONTO)
                        novoRegistro.push(jsonStrFinan[i].JUROS)
                        novoRegistro.push(jsonStrFinan[i].VALOR)
                        novoRegistro.push(jsonStrFinan[i].EMPRESA)

                        $('#tabelaFinanceiro').DataTable().row.add(novoRegistro).draw(false);
                    }
                } catch {
                    console.error(error)
                    msgErro(`Não foi possível buscar os dados do Financeiro: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide')
            }
        }
    }

    async function criaDataTableContabilidade() {

        if ($.fn.DataTable.isDataTable('#tabelaContabilidade')) {
            $('#tabelaContabilidade').DataTable().destroy();
            $('#tabelaContabilidade').empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Debita',
        })
        dataSetCols.push({
            'title': 'Conta Débito',
        })
        dataSetCols.push({
            'title': 'Credita',
        })
        dataSetCols.push({
            'title': 'Conta Crédito',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Observação',
        })
        dataSetCols.push({
            'title': 'Ordem',
        })

        $('#tabelaContabilidade').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [4],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [6],
                    visible: false,
                },
            ]
        });

        await carregaContabilidade()
    };

    async function carregaContabilidade() {
        if ((!duplicando) && (movimento != '' && movimento != 'create')) {
            $.LoadingOverlay('show')
            try {
                try {
                    const url = "/sisplan/movimentobancario/v1/buscacontabil?";
                    const filtros = `LANCAMENTO=${lancamento}`
                    const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                    if (!response) {
                        return;
                    }

                    let jsonStrContabil = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStrContabil['RESULT'][0].mensagem);
                        return;
                    }

                    if (jsonStrContabil.length == 0) {
                        return;
                    }

                    let novoRegistro = []

                    for (let i = 0; i < jsonStrContabil.length; i++) {
                        novoRegistro = []

                        novoRegistro.push(jsonStrContabil[i].CONTA_C)
                        novoRegistro.push(jsonStrContabil[i].DESC_C)
                        novoRegistro.push(jsonStrContabil[i].CONTA_D)
                        novoRegistro.push(jsonStrContabil[i].DESC_D)
                        novoRegistro.push(jsonStrContabil[i].VALOR)
                        novoRegistro.push(jsonStrContabil[i].OBSERVACAO)
                        novoRegistro.push(jsonStrContabil[i].ORDEM)


                        $('#tabelaContabilidade').DataTable().row.add(novoRegistro).draw(false);
                    }
                } catch {
                    console.error(error)
                    msgErro(`Não foi possível buscar os dados de contabilidade: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide')
            }
        }
    }

    async function criaDataTableCadContabilidade() {
        if ($.fn.DataTable.isDataTable('#tabelaCadContabil')) {
            $('#tabelaCadContabil').DataTable().destroy();
            $('#tabelaCadContabil').empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Debita',
        })
        dataSetCols.push({
            'title': 'Conta Débito',
        })
        dataSetCols.push({
            'title': 'Credita',
        })
        dataSetCols.push({
            'title': 'Conta Crédito',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Observação',
        })
        dataSetCols.push({
            'title': 'Ordem',
        })

        let tabCadastro = $('#tabelaCadContabil').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [4],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [6],
                    visible: false,
                },
            ]
        });

        let tabPrincipal = $('#tabelaContabilidade').DataTable()
        tabCadastro.clear().draw();

        let dadosCont = tabPrincipal.rows().data().toArray()

        tabCadastro.rows.add(dadosCont).draw()
    }

    async function criaDataTableRaterio() {

        if ($.fn.DataTable.isDataTable('#tabelaRateio')) {
            $("#tabelaRateio").DataTable().destroy();
            $("#tabelaRateio").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Código',
        })
        dataSetCols.push({
            'title': 'CentroCusto',
        })
        dataSetCols.push({
            'title': 'Perc',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Ordem',
        })

        $('#tabelaRateio').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [3],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [4],
                    visible: false,
                },
            ]
        });

        await carregaRateio()
    };

    async function carregaRateio() {
        if ((!duplicando) && (movimento != '' && movimento != 'create')) {
            $.LoadingOverlay('show')
            try {
                try {
                    const url = "/sisplan/movimentobancario/v1/buscarateio?";
                    const filtros = `LANCAMENTO=${lancamento}`
                    const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

                    if (!response) {
                        return;
                    }

                    let jsonStrContabil = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStrContabil['RESULT'][0].mensagem);
                        return;
                    }

                    if (jsonStrContabil.length == 0) {
                        return;
                    }

                    let novoRegistro = []

                    for (let i = 0; i < jsonStrContabil.length; i++) {
                        novoRegistro = []

                        novoRegistro.push(jsonStrContabil[i].CODIGO)
                        novoRegistro.push(jsonStrContabil[i].CENTROCUSTO)
                        novoRegistro.push(jsonStrContabil[i].PERC)
                        novoRegistro.push(jsonStrContabil[i].VALOR)
                        novoRegistro.push(jsonStrContabil[i].ORDEM)

                        $('#tabelaRateio').DataTable().row.add(novoRegistro).draw(false);
                    }
                } catch {
                    console.error(error)
                    msgErro(`Não foi possível buscar os dados de contabilidade: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide')
            }
        }
    }

    async function criaDataTableCadRateio() {
        if ($.fn.DataTable.isDataTable('#tabelaCadRateio')) {
            $("#tabelaCadRateio").DataTable().destroy();
            $("#tabelaCadRateio").empty();
        };

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Código',
        })
        dataSetCols.push({
            'title': 'CentroCusto',
        })
        dataSetCols.push({
            'title': 'Perc',
        })
        dataSetCols.push({
            'title': 'Valor',
        })
        dataSetCols.push({
            'title': 'Ordem',
        })

        let tabCadastro = $('#tabelaCadRateio').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-br", {
                            minimumFractionDigits: 2,
                        });
                    },
                    targets: [3],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [4],
                    visible: false,
                },
            ]
        });

        let tabPrincipal = $('#tabelaRateio').DataTable()
        tabCadastro.clear().draw();

        let dadosCont = tabPrincipal.rows().data().toArray()

        tabCadastro.rows.add(dadosCont).draw()
    };

    function calculaValorMoeda() {
        let valor = 0
        if (($('#txtValorMoeda').val() > 0) && ($('#txtValorTaxa').val() > 0)) {
            valor = $('#txtValorMoeda').val() * $('#txtValorTaxa').val()
        }

        return valor
    }

    $('#txtValorMoeda').on('blur', function () {
        let valorNovo = calculaValorMoeda() > 0 ? calculaValorMoeda() : $('#txtValor').val();
        $('#txtValor').val(valorNovo)
    })

    $('#txtValorTaxa').on('blur', function () {
        let valorNovo = calculaValorMoeda() > 0 ? calculaValorMoeda() : $('#txtValor').val();
        $('#txtValor').val(valorNovo)
    })

    $('#btnContabil').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            $('#modal-contabil').modal('show')
            $('#txtContaDebita').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);
            $('#txtContaCredita').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);

            $('#btn-ContaDebitaConsulta').pesquisa_serverside(['#txtContaDebita'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta Contábil');
            $('#btn-ContaCreditaConsulta').pesquisa_serverside(['#txtContaCredita'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Conta Contábil');

            $('#btn-limpa-ContaDebita').on('click', function () { $('#txtContaDebita').val('') })
            $('#btn-limpa-ContaCredita').on('click', function () { $('#txtContaCredita').val('') })

            $('#txtValorContabil').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });

            await criaDataTableCadContabilidade()
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function bloqueiaCamposCont(libera) {
        $('#txtContaDebita').prop('disabled', libera)
        $('#btn-ContaDebitaConsulta').prop('disabled', libera)
        $('#btn-limpa-ContaDebita').prop('disabled', libera)
        $('#txtContaCredita').prop('disabled', libera)
        $('#btn-ContaCreditaConsulta').prop('disabled', libera)
        $('#btn-limpa-ContaCredita').prop('disabled', libera)
        $('#txtValorContabil').prop('disabled', libera)
        $('#txtObsContabil').prop('disabled', libera)

        if (libera) {
            $('#btnIncluirContabil').removeClass('d-none')
            $('#btnAlterarContabil').removeClass('d-none')
            $('#btnExcluirContabil').removeClass('d-none')
            $('#btnConfirmarTotalContabil').removeClass('d-none')
            $('#btnDesistirTotalContabil').removeClass('d-none')
            $('#btnConfirmarContabil').addClass('d-none')
            $('#btnDesistirContabil').addClass('d-none')
        } else {
            $('#btnIncluirContabil').addClass('d-none')
            $('#btnAlterarContabil').addClass('d-none')
            $('#btnExcluirContabil').addClass('d-none')
            $('#btnConfirmarTotalContabil').addClass('d-none')
            $('#btnDesistirTotalContabil').addClass('d-none')
            $('#btnConfirmarContabil').removeClass('d-none')
            $('#btnDesistirContabil').removeClass('d-none')
        }
    }

    function limpaCamposCont() {
        $('#txtContaDebita').val('')
        $('#txtContaCredita').val('')
        $('#txtValorContabil').val('')
        $('#txtObsContabil').val('')
        $("#tabelaCadContabil").dataTable().$("tr.selected").removeClass("selected")
    }

    function insereValorContabil(alterando, indiceLinha) {
        $.LoadingOverlay('show')
        try {
            try {
                const novoRegistro = []

                const debita = pegaChave('#txtContaDebita');
                const descDebita = pegaDescricao('#txtContaDebita');
                const credita = pegaChave('#txtContaCredita');
                const descCredita = pegaDescricao('#txtContaCredita');
                const valor = $('#txtValorContabil').val()
                const obs = $('#txtObsContabil').val()
                const ordem = $('#tabelaCadContabil').DataTable().data().length + 1

                novoRegistro.push(debita)
                novoRegistro.push(descDebita)
                novoRegistro.push(credita)
                novoRegistro.push(descCredita)
                novoRegistro.push(valor)
                novoRegistro.push(obs)
                !alterando ? novoRegistro.push(ordem) : novoRegistro.push(indiceLinha + 1)

                if (alterando) {
                    $('#tabelaCadContabil').DataTable().row(indiceLinha).data(novoRegistro).draw(false);
                } else {
                    $('#tabelaCadContabil').DataTable().row.add(novoRegistro).draw(false);
                }

                alterandoContabil = false;
            } catch {
                console.log(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnIncluirContabil').on('click', function () {
        $.LoadingOverlay('show')
        try {
            alterandoContabil = false;
            bloqueiaCamposCont(false)
            limpaCamposCont()

            if ($('#tabelaCadContabil').DataTable().data().length <= 0) {
                let valor = $('#txtValor').val()
                $('#txtValorContabil').val(valor)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnAlterarContabil').on('click', function () {
        let tabela = $("#tabelaCadContabil").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            alterandoContabil = true
            indiceLinhaContabil = linha.index()

            bloqueiaCamposCont(false)
        } else {
            msgAlerta('Nenhum registro selecionado para alterar!')
        }
    })

    $('#btnConfirmarContabil').on('click', async function () {
        $.LoadingOverlay('show')
        try {

            if ($('#txtContaDebita').val() == '') {
                msgAlerta('Conta Debita não informada, impossivel Continuar!')
                return;
            }

            if ($('#txtContaCredita').val() == '') {
                msgAlerta('Conta Credita não informada, impossivel Continuar!')
                return;
            }

            if ($('#txtValorContabil').val() == '') {
                msgAlerta('Valor não informada, impossivel Continuar!')
                return;
            }

            insereValorContabil(alterandoContabil, indiceLinhaContabil)

            bloqueiaCamposCont(true)
            limpaCamposCont()

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnDesistirContabil').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposCont();
            bloqueiaCamposCont(true);
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnExcluirContabil').on('click', function () {
        let tabela = $("#tabelaCadContabil").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                $.LoadingOverlay('show')
                try {
                    tabela.row(linha).remove().draw();
                    limpaCamposCont()
                } finally {
                    $.LoadingOverlay('hide')
                }
            });
        } else {
            msgAlerta('Nenhum registro selecionado para excluir!')
        }
    })

    $('#tabelaCadContabil').on('click', 'tr', function () {
        if (!alterandoContabil) {
            $("#tabelaCadContabil").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass('selected')
            let tabela = $("#tabelaCadContabil").DataTable()
            let linha = tabela.$("tr.selected");
            let cont = tabela.row(linha).data()
            $('#txtValorContabil').val(cont[4])
            $('#txtObsContabil').val(cont[5])
            insereValor('#txtContaDebita', cont[0], cont[1])
            insereValor('#txtContaCredita', cont[2], cont[3])
        }
    })

    $('#btnDesistirTotalContabil').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposCont()
            $('#modal-contabil').modal('hide')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConfirmarTotalContabil').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposCont()
            $('#modal-contabil').modal('hide')

            let tabPrincipal = $('#tabelaContabilidade').DataTable()
            let tabCadastro = $('#tabelaCadContabil').DataTable()
            tabPrincipal.clear().draw();

            let dadosCont = tabCadastro.rows().data().toArray()

            tabPrincipal.rows.add(dadosCont).draw()
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function bloqueiaCamposRateio(libera) {
        $('#txtCentroCusto').prop('disabled', libera)
        $('#btn-CentroCustoConsulta').prop('disabled', libera)
        $('#btn-limpa-CentroCusto').prop('disabled', libera)
        $('#txtValorRateio').prop('disabled', libera)
        $('#txtPercRateio').prop('disabled', libera)

        if (libera) {
            $('#btnIncluirRateio').removeClass('d-none')
            $('#btnAlterarRateio').removeClass('d-none')
            $('#btnExcluirRateio').removeClass('d-none')
            $('#btnConfirmarTotalRateio').removeClass('d-none')
            $('#btnDesistirTotalRateio').removeClass('d-none')
            $('#btnConfirmarRateio').addClass('d-none')
            $('#btnDesistirRateio').addClass('d-none')
        } else {
            $('#btnIncluirRateio').addClass('d-none')
            $('#btnAlterarRateio').addClass('d-none')
            $('#btnExcluirRateio').addClass('d-none')
            $('#btnConfirmarTotalRateio').addClass('d-none')
            $('#btnDesistirTotalRateio').addClass('d-none')
            $('#btnConfirmarRateio').removeClass('d-none')
            $('#btnDesistirRateio').removeClass('d-none')
        }
    }

    function limpaCamposRateio() {
        $('#txtCentroCusto').val('')
        $('#txtValorRateio').val('')
        $('#txtPercRateio').val('')
    }

    $('#btnRateio').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            const tabelaContabil = $("#tabelaContabilidade").DataTable()
            const linhaContabil = tabelaContabil.$('tr.selected')

            if (linhaContabil.length <= 0) {
                msgAlerta('Nenhum registro contábil foi selecionado para incluir rateio!')
                return;
            }

            $('#modal-rateio').modal('show')
            $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO" ], "where": null}`);

            $('#btn-CentroCustoConsulta').pesquisa_serverside(['#txtCentroCusto'], ['CODIGO'], ['DESCRICAO'], `{ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Centro de Custo');

            $('#btn-limpa-CentroCusto').on('click', function () { $('#txtCentroCusto').val('') })

            $('#txtValorRateio').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });

            $('#txtPercRateio').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });

            await criaDataTableCadRateio()

            let ordem = tabelaContabil.row(linhaContabil).data()[6]
            let ordemRateio = 0;

            if (ordem > 0) {
                $('#tabelaCadRateio tbody tr').each(function () {
                    ordemRateio = $('#tabelaCadRateio').DataTable().row($(this)).data()[4]
                    if (ordemRateio != ordem) {
                        $(this).hide();
                    } else {
                        $(this).show();
                    }
                });
            } else {
                $('#tabelaCadRateio tbody tr').hide();
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    function insereValorRateio(alterando, indiceLinha) {
        $.LoadingOverlay('show')
        try {
            try {
                const tabelaContabil = $("#tabelaContabilidade").DataTable()
                const linhaContabil = tabelaContabil.$('tr.selected')
                const registroContabil = tabelaContabil.row(linhaContabil).data()
                const novoRegistro = []

                const centroCusto = pegaChave('#txtCentroCusto');
                const descCentroCusto = pegaDescricao('#txtCentroCusto');
                const perc = $('#txtPercRateio').val();
                const valor = $('#txtValorRateio').val();
                const ordem = registroContabil[6]

                novoRegistro.push(centroCusto)
                novoRegistro.push(descCentroCusto)
                novoRegistro.push(perc)
                novoRegistro.push(valor)
                novoRegistro.push(ordem)

                if (alterando) {
                    $('#tabelaCadRateio').DataTable().row(indiceLinha).data(novoRegistro).draw(false);
                } else {
                    $('#tabelaCadRateio').DataTable().row.add(novoRegistro).draw(false);
                }

                alterandoRateio = false;
            } catch {
                console.log(error)
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnIncluirRateio').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            alterandoRateio = false;
            bloqueiaCamposRateio(false)
            limpaCamposRateio()

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnAlterarRateio').on('click', function () {
        let tabela = $("#tabelaCadRateio").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            alterandoRateio = true
            indiceLinhaRateio = linha.index()

            bloqueiaCamposRateio(false)
        } else {
            msgAlerta('Nenhum registro selecionado para alterar!')
        }
    })

    $('#btnConfirmarRateio').on('click', async function () {
        $.LoadingOverlay('show')
        try {

            if ($('#txtCentroCusto').val() == '') {
                msgAlerta('Centro de Custo não informado, impossivel Continuar!')
                return;
            }

            if ($('#txtValorRateio').val() == '') {
                msgAlerta('Valor não informado, impossivel Continuar!')
                return;
            }

            insereValorRateio(alterandoRateio, indiceLinhaRateio)

            bloqueiaCamposRateio(true)
            limpaCamposRateio()

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnDesistirRateio').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposRateio();
            bloqueiaCamposRateio(true);
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnExcluirRateio').on('click', function () {
        let tabela = $("#tabelaCadRateio").DataTable()
        let linha = tabela.$("tr.selected");
        if (linha.length > 0) {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                $.LoadingOverlay('show')
                try {
                    tabela.row(linha).remove().draw();
                    limpaCamposRateio()
                } finally {
                    $.LoadingOverlay('hide')
                }
            });
        } else {
            msgAlerta('Nenhum registro selecionado para excluir!')
        }
    })

    $('#tabelaCadRateio').on('click', 'tr', function () {
        if (!alterandoRateio) {
            $("#tabelaCadRateio").dataTable().$("tr.selected").removeClass("selected");
            $(this).addClass('selected')
            let tabela = $("#tabelaCadRateio").DataTable()
            let linha = tabela.$("tr.selected");
            let rateio = tabela.row(linha).data()
            $('#txtValorRateio').val(rateio[3])
            $('#txtPercRateio').val(rateio[2])
            insereValor('#txtCentroCusto', rateio[0], rateio[1])
        }
    })

    $('#btnDesistirTotalRateio').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposRateio()
            $('#modal-rateio').modal('hide')
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#btnConfirmarTotalRateio').on('click', function () {
        $.LoadingOverlay('show')
        try {
            limpaCamposRateio()
            $('#modal-rateio').modal('hide')

            let tabPrincipal = $('#tabelaRateio').DataTable()
            let tabCadastro = $('#tabelaCadRateio').DataTable()
            tabPrincipal.clear().draw();

            let dadosRateio = tabCadastro.rows().data().toArray()

            tabPrincipal.rows.add(dadosRateio).draw()

        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#tabelaContabilidade').on('click', 'tr', function () {
        let ordem = 0;
        let ordemRateio = 0;

        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            $('#tabelaContabilidade').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
            ordem = $('#tabelaContabilidade').DataTable().row($(this)).data()[6]
        }

        if (ordem > 0) {
            $('#tabelaRateio tbody tr').each(function () {
                ordemRateio = $('#tabelaRateio').DataTable().row($(this)).data()[4]
                if (ordemRateio != ordem) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        } else {
            $('#tabelaRateio tbody tr').hide();
        }
    })

    $('#txtPercRateio').on('blur', function () {
        $.LoadingOverlay('show')
        try {
            const perc = $('#txtPercRateio').val()
            const tabelaContabil = $("#tabelaContabilidade").DataTable()
            const linhaContabil = tabelaContabil.$('tr.selected')
            const valorCont = tabelaContabil.row(linhaContabil).data()[4]

            const valorFinal = roundTo((parseFloat(valorCont) / 100) * parseFloat(perc), 2)

            $('#txtValorRateio').val(valorFinal)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtValorRateio').on('blur', function () {
        $.LoadingOverlay('show')
        try {
            const valor = $('#txtValorRateio').val()
            const tabelaContabil = $("#tabelaContabilidade").DataTable()
            const linhaContabil = tabelaContabil.$('tr.selected')
            const valorCont = tabelaContabil.row(linhaContabil).data()[4]

            const percFinal = roundTo((parseFloat(valor) / parseFloat(valorCont)) * 100, 2)

            $('#txtPercRateio').val(percFinal)
        } finally {
            $.LoadingOverlay('hide')
        }
    })
});
