/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show'));
                    $('#multiCollapseExample1').collapse('show');
                } else
                    if (Element.node.id == 'documentoaba') {
                        if (!$('#collapseFiltros').hasClass('show')) {
                            $('#documento').collapse('show');
                            $('#multiCollapseExample2').collapse('show');
                        }
                    } else
                        if (Element.node.id == 'endereco') {
                            if (!$('#multiCollapseExample3').hasClass('show')) {
                                $('#multiCollapseExample3').collapse('show');
                                $('#enderecoGeral').collapse('show');
                            }
                        } else
                            if (Element.node.id == 'geral') {
                                if (!$('#collapseFiltros').hasClass('show')) {
                                    $('#endereco_geral-tab').trigger('click');
                                }
                            } else
                                if (Element.node.id == 'endereco_entrega_geral') {
                                    if (!$('#collapseFiltros').hasClass('show')) {
                                        $('#enderecoEntrega').collapse('show');
                                    }
                                } else
                                    if (Element.node.id == 'endereco_cobranca_geral') {
                                        if (!$('#collapseFiltros').hasClass('show')) {
                                            $('#enderecoCobranca').collapse('show');
                                        }
                                    } else
                                        if (Element.node.id == 'venda') {
                                            if (!$('#collapseFiltros').hasClass('show')) {
                                                $('#multiCollapseExample3').collapse('show');
                                            }
                                        } else
                                            if (Element.node.id == 'compra') {
                                                if (!$('#collapseFiltros').hasClass('show')) {
                                                    $('#multiCollapseExample4').collapse('show');
                                                }
                                            }
            },
            onPrevious: (Element) => {
                if ((Element.node.id == 'documento-tab') || (Element.node.id == 'documentoaba')) {
                    if (!$('#geral>a').hasClass('collapsed')) {
                        $('#multiCollapseExample2').collapse('show');
                        // $('#geral').addClass('active show');
                    }

                } else
                    if (Element.node.id == 'endereco') {
                        if (!$('#documento>a').hasClass('collapsed')) {
                            $('#documentoaba').collapse('show');
                            // $('#documento').addClass('active show');
                        }
                    } else
                        if (Element.node.id == 'endereco_entrega_geral-tab') {
                            if (!$('#endereco_geral').hasClass('active')) {
                                $('#endereco_geral-tab').trigger('click');
                                $('#endereco_geral').addClass('active show');
                            }
                        } else
                            if (Element.node.id == 'endereco_cobranca_geral-tab') {
                                if (!$('#endereco_entrega_geral').hasClass('active')) {
                                    $('#endereco_entrega_geral-tab').trigger('click');
                                    $('#endereco_entrega_geral').addClass('active show');
                                }
                            }
            }
        });

        driver.defineSteps([{
            element: '#geral-tab',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#geral',
            popover: {
                title: 'Cadastro Geral',
                description: 'Aqui você pode informar os dados gerais de cadastro do material.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados de Cadastro Geral',
                description: 'Esses são os campos que você informará os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#tourcodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourdesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourund',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourundvenda',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourstatus',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelacores',
            popover: {
                title: 'Tabela Cores',
                description: 'Aqui fica a tabela onde você pode inserir as cores.',
                position: 'top'
            }
        },
        {
            element: '#documentoaba',
            popover: {
                title: 'Aba Tributações',
                description: 'Clique aqui para abrir aba tributações.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Tributações',
                description: 'Aqui ficam os dados de tributações a serem preenchidos.',
                position: 'top'
            }
        },
        {
            element: '#tourncm',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#touricms',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursped',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toureipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#venda',
            popover: {
                title: 'Aba Cadastro de Cores',
                description: 'Aqui você pode adicionar as cores que o material possui.',
                position: 'top'
            }
        },
        {
            element: '#compra',
            popover: {
                title: 'Aba Cadastro de Tipo de Venda/Regra',
                description: 'Aqui você pode adicionar os tipos de venda/regra ao material.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelavenda',
            popover: {
                title: 'Tabela Tipo de Venda/Regra',
                description: 'Aqui fica a tabela onde você pode inserir os tipos de venda/regra.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});
$(document).ready(async function () {

    // $('#txtCodigo').prop('disabled', true);
    $('#checkAtivo').attr('checked', true);
    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('MATERIAL', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/material`;
    });


    $('#txtPeso').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtKgHora').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoReposicao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtFatorConversao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 4
    });
    $('#txtPrecoUltCompra').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtCiclo').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIpi').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtGramatura').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtLargura').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIcms').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtTara').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#tabelaVendaRegra').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
    });

    $('#tabelaFaixaCor').DataTable({
        scrollY: "100px",
        scrollCollapse: true,
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('.radio-group .radio').click(function () {
        $(this).parent().find('.radio').removeClass('selected');
        $(this).addClass('selected');
    });

    $(".submit").click(function () {
        return false;
    });

    $('#btnTributacoes').on('click', function () {
        $('#modalTrib').modal('show');
    });

    $('#btnFaixaCor').on('click', function () {
        $('#modalFaixaCor').modal('show');
    });

    $('#btnVendaRegra').on('click', function () {
        $('#modalVendaRegra').modal('show');
    });


    $('#txtSubgrupo').autocompleta(1, `JSON={ "tabela":"subgrupo_ma", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa chave", "replace(replace(replace((tam01 || '/' || tam02 || '/' || tam03 || '/' || tam04 || '/' || tam05 || '/' || tam06 || '/' || tam07 || '/' || tam08 || '/' || tam09 || '/' || tam10 || '/' || tam11 || '/' || tam12),'//', ''), '/  /', ''), ' ', '') as descricao"], "where": null}`);
    $('#txtUnidade').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtUnidadeCompra').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"colecao", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodFornec').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMarca').autocompleta(1, `JSON={ "tabela":"MARCA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtLinha').autocompleta(1, `JSON={ "tabela":"tablin", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNcm').autocompleta(1, `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIcmsEntrada').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIcmsSaida').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiSaida').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiEntrada').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtSped').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEnqIpi').autocompleta(1, `JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNatureza').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
    $('#txtEmpresaRegra').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave, emp_nome descricao" ], "where": null}`);
    $('#txtRegra').autocompleta(1, `JSON={ "tabela":"regra", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`);

    $('#txtEmpresaRegra').change(async function () {
        valor = $('#txtEmpresaRegra').val();
        $('#txtEmpresaRegra').val(valor.replace('_', ''));
    });

    $('#btnNcm').pesquisa('#txtNcm', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao", "observacao"]}`, 'Pesquisa NCM', 'TABFIS');
    $('#btnANcm').on('click', function () {
        $('#txtNcm').val('');
    });
    $('#btnSubgrupo').pesquisa('#txtSubgrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"subgrupo_ma", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa SubGrupo', 'subgrupo_ma');
    $('#btnASubgrupo').on('click', function () {
        $('#txtSubgrupo').val('');
    });
    $('#btnCstIcmsEntrada').pesquisa('#txtCstIcmsEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
    $('#btnACstIcmsEntrada').on('click', function () {
        $('#txtCstIcmsEntrada').val('');
    });
    $('#btnCstIcmsSaida').pesquisa('#txtCstIcmsSaida', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
    $('#btnACstIcmsSaida').on('click', function () {
        $('#txtCstIcmsSaida').val('');
    });
    $('#btnCstIpiSaida').pesquisa('#txtCstIpiSaida', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Saída', 'TABIPI');
    $('#btnACstIpiSaida').on('click', function () {
        $('#txtCstIpiSaida').val('');
    });
    $('#btnCstIpiEntrada').pesquisa('#txtCstIpiEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Entrada', 'TABIPI');
    $('#btnACstIpiEntrada').on('click', function () {
        $('#txtCstIpiEntrada').val('');
    });
    $('#btnSped').pesquisa('#txtSped', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
    $('#btnASped').on('click', function () {
        $('#txtSped').val('');
    });
    $('#btnEnqIpi').pesquisa('#txtEnqIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Enquadramento IPI', 'ENQUADRA');
    $('#btnAEnqIpi').on('click', function () {
        $('#txtEnqIpi').val('');
    });
    $('#btnNatureza').pesquisa('#txtNatureza', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'NATUREZA');
    $('#btnANatureza').on('click', function () {
        $('#txtNatureza').val('');
    });

    $('#btnEmpresaRegra').pesquisa('#txtEmpresaRegra', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat,'_','') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');
    $('#btnAEmpresaRegra').on('click', function () {
        $('#txtEmpresaRegra').val('');
    });

    $('#btnRegra').pesquisa('#txtRegra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regra", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Regra', 'regra');
    $('#btnARegra').on('click', function () {
        $('#txtRegra').val('');
    });

    $('#btnCodFornerc').pesquisa('#txtCodFornec', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnACodFornerc').on('click', function () {
        $('#txtCodFornec').val('');
    });

    $('#btnFaixaTam').pesquisa('#txtFaixaTam', 'FAIXA', 'TAM01', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pcpfaixa", "camposSelect":[ "faixa", "replace(replace(replace((tam01 || '/' || tam02 || '/' || tam03 || '/' || tam04 || '/' || tam05 || '/' || tam06 || '/' || tam07 || '/' || tam08 || '/' || tam09 || '/' || tam10 || '/' || tam11 || '/' || tam12),'//', ''), '/  /', ''), ' ', '') as tam01"]}`, 'Pesquisa Faixa', 'pcpfaixa');
    $('#btnAFaixaTam').on('click', function () {
        $('#txtFaixaTam').val('');
    });

    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'GRUPO_MA');
    $('#btnAGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });

    $('#btnMarca').pesquisa('#txtMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MARCA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Marca', 'marca');
    $('#btnAMarca').on('click', function () {
        $('#txtMarca').val('');
    });

    $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
    $('#btnAEtiqueta').on('click', function () {
        $('#txtEtiqueta').val('');
    });

    $('#btnCodCliente').pesquisa('#txtCodCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnACodCliente').on('click', function () {
        $('#txtCodCliente').val('');
    });

    $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"colecao", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Coleção', 'colecao');
    $('#btnAColecao').on('click', function () {
        $('#txtColecao').val('');
    });

    $('#btnLinha').pesquisa('#txtLinha', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tablin", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Linha', 'tablin');
    $('#btnALinha').on('click', function () {
        $('#txtLinha').val('');
    });

    $('#btnStatus').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Status', 'SITPROD');
    $('#btnAStatus').on('click', function () {
        $('#txtStatus').val('');
    });

    $('#btnTag').pesquisa('#txtTag', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADTAG", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa TAG', 'CADTAG');
    $('#btnATag').on('click', function () {
        $('#txtTag').val('');
    });

    $('#btnFaixaDesc').pesquisa('#txtFaixaDesc', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA_DESCONTO", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Faixa Desconto', 'FAIXA_DESCONTO');
    $('#btnAFaixaDesc').on('click', function () {
        $('#txtFaixaDesc').val('');
    });

    $('#btnUnidade').pesquisa('#txtUnidade', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnAUnidade').on('click', function () {
        $('#txtUnidade').val('');
    });

    $('#btnUnidadeCompra').pesquisa('#txtUnidadeCompra', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnAUnidadeCompra').on('click', function () {
        $('#txtUnidadeCompra').val('');
    });

    $('#btnAbrirCondicao').on('click', function () {
        $('#modalCondicao').modal('show');
    });

    $('#btnAbrirVendaRegra').on('click', function () {
        $('#modalAdicionarVendaRegra').modal('show');
    });

    $('#btn-limpa-CondPagto').on('click', function () {
        $('#txtCondPagto').val('');
    });

    $('#btnAdicionar').on('click', async function () {
        let desc = $('#txtCondPagto').val();
        if (desc == '') {
            msgAlerta('Campo deve ser preenchido');
            return;
        }
        addValorCond();
        $('#txtCondPagto').val('');
        ;
    });

    $('#txtCodigo').on('focusout', async function() {
        if ($(this).val() != '') {
            const bProduto = await Existe('PRODUTO', ['CODIGO'], [$(this).val()]);
            const bMaterial = await Existe('MATERIAL', ['CODIGO'], [$(this).val()]);
            const bServico = await Existe('SERVICO', ['CODIGO'], [$(this).val()]);
            if (bProduto || bMaterial || bServico) {
                const tabela = bProduto ? 'produto' : bMaterial ? 'material' : bServico ? 'serviço' : '';
                msgAlerta(`Já existe um ${tabela} cadastrado com o código ${$(this).val()}, necessário informar outro código.`);
                $(this).val('');
                $(this).focus();
            } else {
                $('#txtCodigo').prop('disabled', true);
            }
        }
    });

    async function addValorCond() {
        let codCond = pegaChave('#txtCondPagto');
        let descCond = pegaDescricao('#txtCondPagto');
        $('#tabelaFaixaCor').DataTable().row.add([codCond, descCond,
            '<div style="text-align:center;"> ' +
            '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
            '      Excluir' +
            '   </button> ' +
            '</div>'
        ]).draw(false);
    };

    let coresExcluir = [];

    $('#tabelaFaixaCor').on('click', '#btnExluirCond', async function () {
        let table = $('#tabelaFaixaCor').DataTable();
        let rowData = table.row($(this).parents('tr')).data();
        let material = $("#txtCodigo").val();
        let cor = rowData[0];

        let corTabela = {
            CODIGO: material,
            COR: cor,
            TIPO: 'M'
        }

        let response = await requisicao(
            "GET",
            "/Sisplan/Cadastros/v1/validausocor?",
            `JSON=${encodeURIComponent(JSON.stringify(corTabela))}`,
            null
        );

        if (!response) {
            $.LoadingOverlay("hide");
            return;
        };
        let jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
        } else {
            coresExcluir.push(corTabela);
            table.row($(this).parents('tr')).remove().draw(false);
        }
    });

    $('#tabelaVendaRegra').on('click', '#btnExluirCond', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#btnAdicionarTipoRegra').on('click', async function () {
        let desc = $('#txtTipoVenda').val();
        if (desc == '') {
            msgAlerta('Campo deve ser preenchido');
            return;
        }
        addTipoRegra();
        $('#txtTipoVenda').val('');
        $('#txtEmpresaRegra').val('');
        $('#txtRegra').val('');
        ;
    });

    async function addTipoRegra() {
        try {
            $.LoadingOverlay('show');
            let tipoVenda = $('#txtTipoVenda').val();
            let empresaTipo = pegaChave('#txtEmpresaRegra');
            let regra = pegaChave('#txtRegra');
            let regraDesc = pegaDescricao('#txtRegra');
            $('#tabelaVendaRegra').DataTable().row.add([tipoVenda, empresaTipo, regra, regraDesc,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm" id="btnExluirTipo" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
            ]).draw(false);

            toastr.success(
                `Registro adicionado com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 5000,
                fadeOut: 3000
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#tabelaVendaRegra').on('click', '#btnExluirTipo', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricao: {
                required: true,
            },
            txtUnidade: {
                required: true,
            },
            txtUnidadeVenda: {
                required: true,
            },
            txtGrupo: {
                required: true,
            },
            txtNcm: {
                required: true,
            },
            txtCstIcmsEntrada: {
                required: true,
            },
            txtCstIcmsSaida: {
                required: true,
            },
            txtSped: {
                required: true,
            },
            txtCstIpiEntrada: {
                required: true,
            },
            txtCstIpiSaida: {
                required: true,
            }
        },
        messages: {
            txtCodigo: {
                required: "Informe um código válido.",
            },
            txtDescricao: {
                required: "Informe uma descrição válida.",
            },
            txtUnidade: {
                required: "Informe uma unidade válida."
            },
            txtUnidadeVenda: {
                required: "Informe uma unidade válida."
            },
            txtGrupo: {
                required: "Informe um grupo válido."
            },
            txtNcm: {
                required: "Informe um NCM válido."
            },
            txtCstIcmsEntrada: {
                required: "Informe um CST ICMS válido."
            },
            txtCstIcmsSaida: {
                required: "Informe um CST ICMS válido."
            },
            txtSped: {
                required: "Informe um SPED válido."
            },
            txtCstIpiEntrada: {
                required: "Informe um CST IPI válido."
            },
            txtCstIpiSaida: {
                required: "Informe um CST IPI válido."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status !== 200) {
                $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr.mensagem;

            let extension = "png";
            let contentType = response.headers.get('content-type');
            if (contentType && contentType.indexOf('image/') === 0) {
                extension = contentType.replace('image/', '');
            }

            if (extension === "png") {
                $("#infoprodimagem").attr('src', `data:image/png;base64,${sBase64}`);
            } else {
                // Se não for PNG, converter para JPG e exibir
                let jpegBase64 = await convertToJPEG(sBase64);
                $("#infoprodimagem").attr('src', `data:image/jpg;base64,${jpegBase64}`);
            }

        } catch (error) {
            console.error(error);
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }


    $('#fileimagem').change(async function () {

        try {
            $.LoadingOverlay("show");
            const leitorDeArquivos = new FileReader();
            const previaDaImagem = document.querySelector('.imagem');
            const inputArquivo = document.querySelector('.upload');

            let imagemEnviada = inputArquivo.files[0];
            leitorDeArquivos.readAsDataURL(imagemEnviada);
            leitorDeArquivos.addEventListener('loadend', function (load) {
                previaDaImagem.src = load.target.result;
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    // $('#txtDescricao').on('keypress', function (event) {
    //     var regex = new RegExp("^[a-zA-Z0-9 ./-]+$");
    //     var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    //     if (!regex.test(key)) {
    //         event.preventDefault(); return false;
    //     }
    // });

    $('#btn-CondPagto').pesquisa('#txtCondPagto', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":["cor", "descricao"]}`, 'Pesquisa Cor', 'cadcor');

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let material = parametros[parametros.length - 1];
    await buscaFoto(material);

    if (material != '' && material != 'create') {
        $('#txtCodigo').prop('disabled', true);
        // if (await liberarRegistro('PRODUTO', produto) == false) {
        //     window.location.href = '../produto';
        // } else {

        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"material", 
            "camposSelect":["CODIGO", "COD_MESTRE", "DESCRICAO", "DESCRICAO2", "FAIXA", "LINHA",
                            "STATUS", "GRUPO", "SUB_GRUPO", "UNIDADE", "UNI_COM", "PESO", "ATIVO",
                            "KG_HORA", "ESTOQUE", "DIVISOR", "PRE_COMPRA", "CICLO", "GRAMATURA", "LARGURA",
                            "MAXIMO", "CODFIS", "CODEXTIPI", "CODTRI_ENT", "CODTRI", "CODSPED", "CODIPI_ENT",
                            "CODIPI", "IPI", "ICMS", "NATUREZA", "TRIBUTACAO", "ENQUADRA", "POSSE", "REPOSICAO"
                            ], 
            "where": ["codigo = '${material}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtCodigoMestre').val(jsonStr.RESULT[0][0].COD_MESTRE);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                $('#txtComplemento').val(jsonStr.RESULT[0][0].DESCRICAO2);
                $('#txtExtIpi').val(jsonStr.RESULT[0][0].CODEXTIPI);

                $('#txtPeso').val(parseFloat(jsonStr.RESULT[0][0].PESO ? jsonStr.RESULT[0][0].PESO : 0));
                $('#txtKgHora').val(parseFloat(jsonStr.RESULT[0][0].KG_HORA ? jsonStr.RESULT[0][0].KG_HORA : 0));
                $('#txtPrecoReposicao').val(parseFloat(jsonStr.RESULT[0][0].REPOSICAO ? jsonStr.RESULT[0][0].REPOSICAO : 0));
                $('#txtFatorConversao').val(parseFloat(jsonStr.RESULT[0][0].DIVISOR ? jsonStr.RESULT[0][0].DIVISOR : 0));
                $('#txtPrecoUltCompra').val(parseFloat(jsonStr.RESULT[0][0].PRE_COMPRA ? jsonStr.RESULT[0][0].PRE_COMPRA : 0));
                $('#txtCiclo').val(parseFloat(jsonStr.RESULT[0][0].CICLO ? jsonStr.RESULT[0][0].CICLO : 0));
                $('#txtGramatura').val(parseFloat(jsonStr.RESULT[0][0].GRAMATURA ? jsonStr.RESULT[0][0].GRAMATURA : 0));
                $('#txtLargura').val(parseFloat(jsonStr.RESULT[0][0].LARGURA ? jsonStr.RESULT[0][0].LARGURA : 0));
                $('#txtTara').val(parseFloat(jsonStr.RESULT[0][0].MAXIMO ? jsonStr.RESULT[0][0].MAXIMO : 0));
                $('#txtIpi').val((jsonStr.RESULT[0][0].IPI));
                $('#txtIcms').val((jsonStr.RESULT[0][0].ICMS));

                if (jsonStr.RESULT[0][0].ATIVO == "S") {
                    $('#checkAtivo').prop('checked', true);
                } else {
                    $('#checkAtivo').prop('checked', false);
                }

                if (jsonStr.RESULT[0][0].ESTOQUE == "S") {
                    $('#checkLiberado').prop('checked', true);
                } else {
                    $('#checkLiberado').prop('checked', false);
                }

                if (jsonStr.RESULT[0][0].TRIBUTACAO == "N") {
                    $('#selectTrib').val(0);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "D") {
                    $('#selectTrib').val(1);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "1") {
                    $('#selectTrib').val(2);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "2") {
                    $('#selectTrib').val(3);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "3") {
                    $('#selectTrib').val(4);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "4") {
                    $('#selectTrib').val(5);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "5") {
                    $('#selectTrib').val(6);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "6") {
                    $('#selectTrib').val(7);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "7") {
                    $('#selectTrib').val(8);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "8") {
                    $('#selectTrib').val(9);
                }

                if (jsonStr.RESULT[0][0].POSSE == "1") {
                    $('#selectPosse').val(0);
                }
                if (jsonStr.RESULT[0][0].POSSE == "2") {
                    $('#selectPosse').val(1);
                }
                if (jsonStr.RESULT[0][0].POSSE == "3") {
                    $('#selectPosse').val(2);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"pcpfaixa", 
                "camposSelect":["replace(replace(replace((tam01 || '/' || tam02 || '/' || tam03 || '/' || tam04 || '/' || tam05 || '/' || tam06 || '/' || tam07 || '/' || tam08 || '/' || tam09 || '/' || tam10 || '/' || tam11 || '/' || tam12),'//', ''), '/  /', ''), ' ', '') as descricao"], 
                "where": ["faixa = '${jsonStr.RESULT[0][0].FAIXA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtFaixaTam', jsonStr.RESULT[0][0].FAIXA, jsonStrClasse.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"grupo_ma", 
                "camposSelect":["descricao"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].GRUPO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtGrupo', jsonStr.RESULT[0][0].GRUPO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"subgrupo_ma", 
                "camposSelect":["DESCRICAO"], 
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].SUB_GRUPO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtSubgrupo', jsonStr.RESULT[0][0].SUB_GRUPO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade", 
                "camposSelect":["descricao"], 
                "where": ["unidade = '${jsonStr.RESULT[0][0].UNIDADE}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidade', jsonStr.RESULT[0][0].UNIDADE, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade", 
                "camposSelect":["descricao"], 
                "where": ["unidade = '${jsonStr.RESULT[0][0].UNI_COM}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidadeCompra', jsonStr.RESULT[0][0].UNI_COM, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"SITPROD", 
                "camposSelect":["DESCRICAO"], 
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].STATUS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtStatus', jsonStr.RESULT[0][0].STATUS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABLIN", 
                "camposSelect":["DESCRICAO"], 
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].LINHA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtLinha', jsonStr.RESULT[0][0].LINHA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabfis", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODFIS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNcm', jsonStr.RESULT[0][0].CODFIS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABTRI", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODTRI_ENT}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIcmsEntrada', jsonStr.RESULT[0][0].CODTRI_ENT, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABTRI", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODTRI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIcmsSaida', jsonStr.RESULT[0][0].CODTRI, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODIPI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiSaida', jsonStr.RESULT[0][0].CODIPI, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODIPI_ENT}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiEntrada', jsonStr.RESULT[0][0].CODIPI_ENT, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABSPED", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODSPED}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtSped', jsonStr.RESULT[0][0].CODSPED, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"NATUREZA", 
                "camposSelect":["DESCRICAO"], 
                "where": ["natureza = '${jsonStr.RESULT[0][0].NATUREZA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNatureza', jsonStr.RESULT[0][0].NATUREZA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ENQUADRA", 
                "camposSelect":["DESCRICAO"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].ENQUADRA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtEnqIpi', jsonStr.RESULT[0][0].ENQUADRA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"MAT_ITEN", 
                        "camposSelect":["CADCOR.COR", "CADCOR.DESCRICAO"], 
                        "innerJoin": [{"tabela": "CADCOR", 
                        "condicao": "MAT_ITEN.COR = CADCOR.COR"}], 
                        "where": ["MAT_ITEN.CODIGO = '${material}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    let listaCond = jsonStr;
                    let controlador = [];
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        if (controlador.includes(listaCond.RESULT[0][i].COR) == false) {

                            controlador.push(listaCond.RESULT[0][i].COR);

                            $('#tabelaFaixaCor').DataTable().row.add([
                                listaCond.RESULT[0][i].COR,
                                listaCond.RESULT[0][i].DESCRICAO,
                                '<div style="text-align:center;"> ' +
                                '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
                                '      Excluir' +
                                '   </button> ' +
                                '</div>'
                            ]).draw(false);
                        }
                    }

                } catch (error) {
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }

                try {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                "tabela":"TPVENDA_REGRA", 
                "camposSelect":["TPVENDA_REGRA.TIPO_VENDA", "replace(TPVENDA_REGRA.EMPRESA, '_', '') as EMPRESA", "TPVENDA_REGRA.COD_REGRA", "REGRA.DESCRICAO"], 
                "innerJoin": [{"tabela": "REGRA", 
                "condicao": "TPVENDA_REGRA.COD_REGRA = REGRA.CODIGO"}], 
                "where": ["TPVENDA_REGRA.CODIGO = '${material}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }
                    let listaCond = jsonStr;
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        $('#tabelaVendaRegra').DataTable().row.add([
                            listaCond.RESULT[0][i].TIPO_VENDA,
                            listaCond.RESULT[0][i].EMPRESA,
                            listaCond.RESULT[0][i].COD_REGRA,
                            listaCond.RESULT[0][i].DESCRICAO,
                            '<div style="text-align:center;"> ' +
                            '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
                            '      Excluir' +
                            '   </button> ' +
                            '</div>'
                        ]).draw(false);
                    }
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da regra: ${error}`);
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da região: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
        // }
    } else {
        await carregaValoresPadroes();
    };

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABPADRAO.TABELA = 'MATERIAL'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        jsonStr.map(item => {
            switch (item.CAMPO) {
                case 'UNIDADE': {
                    insereValor('#txtUnidade', item.VALOR, {tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR});
                    break;
                }
                case 'UNI_COM': {
                    insereValor('#txtUnidadeCompra', item.VALOR, {tabela: 'UNIDADE', campoBusca: 'DESCRICAO', campoWhere: 'UNIDADE', valorWhere: item.VALOR});
                    break;
                }
                case 'CODFIS': {
                    insereValor('#txtNcm', item.VALOR, {tabela: 'TABFIS', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'CODTRI': {
                    insereValor('#txtCstIcmsSaida', item.VALOR, {tabela: 'TABTRI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'CODTRI_ENT': {
                    insereValor('#txtCstIcmsEntrada', item.VALOR, {tabela: 'TABTRI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'CODIPI': {
                    insereValor('#txtCstIpiSaida', item.VALOR, {tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'CODIPI_ENT': {
                    insereValor('#txtCstIpiEntrada', item.VALOR, {tabela: 'TABIPI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'IPI': {
                    insereValor('#txtIpi', item.VALOR);
                    break;
                }
                case 'POSSE': {
                    $('#selectPosse').val(item.VALOR).change();
                    break;
                }
                case 'SPED': {
                    insereValor('#txtSped', item.VALOR, {tabela: 'TABSPED', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'TRIBUTACAO': {
                    $('#selectTrib').val(item.VALOR).change();
                    break;
                }
                case 'ENQUADRA': {
                    insereValor('#txtEnqIpi', item.VALOR, {tabela: 'ENQUADRA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'NATUREZA': {
                    insereValor('#txtNatureza', item.VALOR, {tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR});
                    break;
                }
                case 'STATUS': {
                    insereValor('#txtStatus', item.VALOR, {tabela: 'SITPROD', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'GRUPO_MA': {
                    insereValor('#txtGrupo', item.VALOR, {tabela: 'GRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
                case 'SUBGRUPO_MA': {
                    insereValor('#txtSubgrupo', item.VALOR, {tabela: 'SUBGRUPO_MA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR});
                    break;
                }
            }
        });

        const codigo = await RetornaProximo('MATERIAL', 'MATERIAL', 'CODIGO', 6);
        $('#txtCodigo').val(codigo);
        $('#txtCodigo').focus();
    }

    $("#gravar").click(

        async function () {

            if ($('#tabelaFaixaCor').DataTable().rows().count() < 1) {
                msgAlerta('Insira pelo menos uma cor ao material.')
                return;
            }

            $('#multiCollapseExample2').collapse('show');
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                try {
                    $.LoadingOverlay("show");

                    try {
                        material = $('#txtCodigo').val();
                        let file = $('input[type=file]')[0].files[0];
                        let reader = new FileReader();
                        let baseString;
                        reader.onloadend = function () {
                            baseString = reader.result;
                        };
                        reader.readAsDataURL(file);

                        // Função para converter a imagem para JPEG
                        function convertToJPEG(base64String) {
                            return new Promise((resolve, reject) => {
                                const img = new Image();
                                img.onload = function () {
                                    const canvas = document.createElement('canvas');
                                    canvas.width = img.width;
                                    canvas.height = img.height;
                                    const ctx = canvas.getContext('2d');
                                    ctx.drawImage(img, 0, 0);
                                    const jpegDataURL = canvas.toDataURL('image/jpeg');
                                    resolve(jpegDataURL);
                                };
                                img.src = base64String;
                            });
                        }
                        function wait(ms) {
                            return new Promise((resolve) => setTimeout(resolve, ms));
                        }
                        await wait(2000);
                        baseString = await convertToJPEG(baseString);
                        await wait(1000); 

                        let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
                        if (!response) {
                            console.error('Resposta vazia ou não está no formato JSON válido.');
                            return;
                        }

                        let jsonStr;
                        try {
                            jsonStr = await response.json();
                        } catch (error) {
                            console.error('Erro ao fazer parsing do JSON:', error);
                            return;
                        }
                        let pastaFoto = jsonStr.mensagem;

                        response = await requisicao(
                            'POST',
                            '/sisplan/funcoes/v1/FotoItem?',
                            `PDIRETORIOSALVAR=${pastaFoto}&NOMEARQUIVO=${material}.${file.name.split('.').pop()}`,
                            `SBASE64=${encodeURIComponent(baseString)}`
                        );
                    } catch (error) {
                        console.error(error);
                    }


                    material = {};

                    material.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('MATERIAL', 'MATERIAL', 'CODIGO', 6) : $('#txtCodigo').val();
                    material.DESCRICAO = $('#txtDescricao').val();
                    // .replace(/[^a-z0-9 ./-]/gi, '');
                    material.COD_MESTRE = $('#txtCodigoMestre').val();
                    material.GRUPO = pegaChave('#txtGrupo', material.GRUPO);
                    material.SUB_GRUPO = pegaChave('#txtSubgrupo', material.SUB_GRUPO);
                    material.DESCRICAO2 = $('#txtComplemento').val();
                    material.UNIDADE = pegaChave('#txtUnidade', material.UNIDADE);
                    material.UNI_COM = pegaChave('#txtUnidadeCompra', material.UNI_COM);
                    material.FAIXA = pegaChave('#txtFaixaTam', material.FAIXA);
                    material.PESO = $('#txtPeso').val();
                    material.KG_HORA = $('#txtKgHora').val();
                    material.REPOSICAO = $('#txtPrecoReposicao').val();
                    material.LINHA = pegaChave('#txtLinha', material.LINHA);
                    material.DIVISOR = $('#txtFatorConversao').val();
                    material.PRE_COMPRA = $('#txtPrecoUltCompra').val();
                    material.CICLO = $('#txtCiclo').val();
                    material.STATUS = pegaChave('#txtStatus', material.STATUS);
                    material.GRAMATURA = $('#txtGramatura').val();
                    material.LARGURA = $('#txtLargura').val();
                    material.MAXIMO = $('#txtTara').val();

                    material.CODFIS = pegaChave($('#txtNcm').val(), material.CODFIS);
                    material.CODEXTIPI = $('#txtExtIpi').val();
                    material.CODTRI_ENT = pegaChave('#txtCstIcmsEntrada', material.CODFIS);
                    material.CODTRI = pegaChave('#txtCstIcmsSaida', material.CODTRI);
                    material.CODSPED = pegaChave('#txtSped', material.CODSPED);
                    material.CODIPI_ENT = pegaChave('#txtCstIpiEntrada', material.CODIPI_ENT);
                    material.CODIPI = pegaChave('#txtCstIpiSaida', material.CODIPI);
                    material.IPI = parseFloat($('#txtIpi').val().replace(',', '.'));
                    material.ICMS = parseFloat($('#txtIcms').val().replace(',', '.'));
                    material.NATUREZA = pegaChave('#txtNatureza', material.NATUREZA);
                    material.ENQUADRA = pegaChave('#txtEnqIpi', material.ENQUADRA);

                    if ($('#checkAtivo').prop('checked')) {
                        material.ATIVO = 'S';
                    } else {
                        material.ATIVO = 'N';
                    }

                    if ($('#checkLiberado').prop('checked')) {
                        material.ESTOQUE = 'S';
                    } else {
                        material.ESTOQUE = 'N';
                    }

                    if ($('#selectTrib').val() == 0) {
                        material.TRIBUTACAO = "N";
                    }
                    if ($('#selectTrib').val() == 1) {
                        material.TRIBUTACAO = "D";
                    }
                    if ($('#selectTrib').val() == 2) {
                        material.TRIBUTACAO = "1";
                    }
                    if ($('#selectTrib').val() == 3) {
                        material.TRIBUTACAO = "2";
                    }
                    if ($('#selectTrib').val() == 4) {
                        material.TRIBUTACAO = "3";
                    }
                    if ($('#selectTrib').val() == 5) {
                        material.TRIBUTACAO = "4";
                    }
                    if ($('#selectTrib').val() == 6) {
                        material.TRIBUTACAO = "5";
                    }
                    if ($('#selectTrib').val() == 7) {
                        material.TRIBUTACAO = "6";
                    }
                    if ($('#selectTrib').val() == 8) {
                        material.TRIBUTACAO = "7";
                    }
                    if ($('#selectTrib').val() == 9) {
                        material.TRIBUTACAO = "8";
                    }

                    if ($('#selectPosse').val() == "0") {
                        material.POSSE = 1;
                    }
                    if ($('#selectPosse').val() == "1") {
                        material.POSSE = 2;
                    }
                    if ($('#selectPosse').val() == "2") {
                        material.POSSE = 3;
                    }

                    let arrayCores = [];
                    for (let index = 0; index < $('#tabelaFaixaCor').DataTable().rows().count(); index++) {
                        let data = $('#tabelaFaixaCor').DataTable().row(index).data();
                        let cor = {};
                        cor.CODIGO = material.CODIGO;
                        cor.COR = data[0];
                        arrayCores.push(cor);
                    }
                    material.CORES = arrayCores;

                    let arrayTipoVendas = [];
                    for (let index = 0; index < $('#tabelaVendaRegra').DataTable().rows().count(); index++) {
                        let data = $('#tabelaVendaRegra').DataTable().row(index).data();
                        let tipovenda = {};
                        tipovenda.CODIGO = material.CODIGO;
                        tipovenda.TIPO_VENDA = data[0];
                        tipovenda.EMPRESA = `_${data[1]}`;
                        tipovenda.COD_REGRA = data[2];
                        arrayTipoVendas.push(tipovenda);
                    }
                    material.TIPOVENDAS = arrayTipoVendas;

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/material?', `JSON=${encodeURIComponent(JSON.stringify(material))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                         Material: ${material.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/material`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                }

            }
        }
    );

    $('.collapse').on('shown.bs.collapse', function (e) {
        let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

        clicked
            .parent()
            .find(".fa-angle-right")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-down");
    })
        .on('hidden.bs.collapse', function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

});