<?php include_once('../../config.php'); ?>


<!DOCTYPE html>
<html class="theme-light">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Loja</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/fontawesome-free/css/all.min.css?versao=3.245.9.1">
  <link rel="shortcut icon" href="<?php echo BASE_URI; ?>/favicon.ico">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/adminlte.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.245.9.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/select2/css/select2.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/driver.min.css?versao=3.245.9.1" />
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/jquery-ui.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/daterangepicker/daterangepicker.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/animate.min.css?versao=3.245.9.1">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/custom.css?versao=3.245.9.1">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/dataTables.bootstrap4.min.css?versao=3.245.9.1" />
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/sisplan.css?versao=3.245.9.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.245.9.1">
  <link href='../dist/css/bootstrap.min.css'>
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/normalize.css?versao=3.245.9.1">
  <link rel="stylesheet" href="dist/css/cards-financeiro.css">

  <!-- Google Font: Source Sans Pro -->
  <style>
    .content-wrapper {
      margin-left: 0px !important;
    }

    .main-header,
    .main-sidebar {
      display: none;
    }

    #msform {
      text-align: center;
      position: relative;
      margin-top: 20px
    }

    /* #msform fieldset .form-card {
      padding: 20px 40px 30px 40px;
      box-sizing: border-box;
      width: 94%;
      margin: 0 3% 20px 3%;
      position: relative
    } */

    #msform fieldset {
      border: 0 none;
      border-radius: 0.5rem;
      box-sizing: border-box;
      width: 100%;
      margin: 0;
      padding-bottom: 20px;
      position: relative
    }

    #msform fieldset:not(:first-of-type) {
      display: none
    }

    /* #msform fieldset .form-card {
      text-align: left;
    } */


    /* #msform .action-button {
      width: 100px;
      font-weight: bold;
      color: white;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 5px
    } */

    #msform .action-button:hover,
    #msform .action-button:focus {
      box-shadow: 0 0 0 2px white, 0 0 0 3px skyblue
    }

    #msform .action-button-previous {
      width: 100px;
      background: #616161;
      font-weight: bold;
      color: white;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 5px
    }

    #msform .action-button-previous:hover,
    #msform .action-button-previous:focus {
      box-shadow: 0 0 0 2px white, 0 0 0 3px #616161
    }

    select.list-dt {
      border: none;
      outline: 0;
      border-bottom: 1px solid #ccc;
      padding: 2px 5px 3px 5px;
      margin: 2px
    }

    select.list-dt:focus {
      border-bottom: 2px solid skyblue
    }

    .card {
      z-index: 0;
      border: none;
      border-radius: 0.5rem;
      position: relative
    }

    .fs-title {
      font-size: 25px;
      color: #2C3E50;
      margin-bottom: 10px;
      font-weight: bold;
      text-align: left
    }

    #progressbar {
      margin-bottom: 30px;
      overflow: hidden;
      color: lightgrey;
      margin-left: 0px;
      margin-right: 0px;
    }

    #progressbar .active {
      color: #000000
    }

    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    #progressbar #account:before {
      font-family: Font Awesome 5 Free;
      content: "\f06b"
    }

    #progressbar #personal:before {
      font-family: Font Awesome 5 Free;
      content: "\f51e"
    }

    #progressbar #payment:before {
      font-family: Font Awesome 5 Free;
      content: "\f058"
    }

    #progressbar #confirm:before {
      font-family: Font Awesome 5 Free;
      content: "\f058"
    }

    #progressbar li:before {
      width: 50px;
      height: 50px;
      line-height: 45px;
      display: block;
      font-size: 18px;
      color: #ffffff;
      background: lightgray;
      border-radius: 50%;
      margin: 0 auto 10px auto;
      padding: 2px
    }

    #progressbar li:after {
      content: '';
      width: 100%;
      height: 2px;
      background: lightgray;
      position: absolute;
      left: 0;
      top: 25px;
      z-index: -1
    }

    #progressbar li.active:before,
    #progressbar li.active:after {
      background: var(--primary-color);
    }


    :root {
      --animate-duration: 800ms;
      --animate-delay: 120ms;
    }

    /* .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    } */

    #btn-botao-presente {
      cursor: pointer;
    }

    .info-box .info-box-icon {
      min-width: 30px !important;
      width: 30px !important;
      /* height: 30px!important;
      min-height: 30px!important; */
    }

    .info-box-icon>i {
      font-size: 20px !important;
    }

    .info-box .info-box-text,
    .info-box .progress-description {
      overflow: unset;
      font-size: 20px;
      font-weight: 400;
    }

    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }

    /* .bg-info,
    .text-info {
      color: #343a40 !important;
    } */

    /* .info-box.bg-info {
          border: solid 1px;
    border-color: #10707f!important;
      background-color: #343a40 !important;
    } */

    /* .btn-info {
      background-color: #343a40 !important;
    } */

    .ui-autocomplete-loading {
      background: white url("<?php echo BASE_URI; ?>/dist/img/ui-anim_basic_16x16.gif") center center no-repeat;
    }

    #tabelaVendas td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #tabelaVendas .pr-4 {
      padding-right: 1.5rem !important;
    }

    #tabelaVendas td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    .modal-body {
      max-height: 100vh;
      overflow-y: auto;
    }

    .botoesPainel {
      background: none;
      color: inherit;
      border: none;
      padding: 0;
      font: inherit;
      cursor: pointer;
      outline: inherit;
      width: 100%;
      text-align: left;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    include_once('../../feedback_widget.html');
    ?>


    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Loja</h1>
              <button title="Tutorial" type="button" class="btn btn-info ml-2 btn-sm" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid" id="painelLojaTour">
          <!-- Small boxes (Stat box) -->
          <div class="row">
            <div class="col-lg-4 col-12">
              <!-- small box -->
              <div class="small-box bg-secondary animate__animated animate__fadeInLeft text-white" style="background: linear-gradient(141deg, rgb(67 176 229) 15%, rgb(18 130 185) 69%) !important">
                <div class="inner">
                  <h3 id="txt_total_vendas">
                  </h3>
                  <p>Vendas</p>
                </div>
                <div class="icon">
                  <i class="ion ion-bag"></i>
                </div>
              </div>
            </div>
            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__zoomIn text-white" style="background: linear-gradient(141deg, rgb(59 161 33) 15%, rgb(2 121 11) 69%) !important">
                <div class=" inner">
                  <h3 id="txt_total_itens">
                    <div class="carregando"></div><sup style="font-size: 20px"></sup>
                  </h3>
                  <p>Itens Vendidos</p>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
              </div>
            </div>

            <div class="col-lg-4 col-12">
              <div class="small-box animate__animated animate__fadeInRight text-white" style="background: linear-gradient(141deg, rgb(255 193 7) 15%, rgb(213 160 0) 69%) !important">
                <div style="color:white!important;" class="inner">
                  <h3 id="txt_val_total">
                    <div class="carregando"></div>
                  </h3>
                  <p>Valor Total</p>
                </div>
                <div class="icon">
                  <i class="ion ion-pie-graph"></i>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="card">
          <div class="card-body">
            <div class="container-fluid">
              <div class="row">
                <!-- <div class="col-sm-1"></div> -->
                <div class="col-lg-2 col-12">
                  <a href="#">
                    <div class="info-box bg-info" id="atalhoClienteTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-users text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Clientes</span>
                        <span class="info-box-number text-white">(F2)</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="col-lg-2 col-12">
                  <button id="btnPreVenda" class="botoesPainel">
                    <!-- <a href="venda/create"> -->
                    <div class="info-box bg-info" id="atalhoPrevendaTour" style="cursor: pointer;">
                      <span class="info-box-icon bg-white"><i class="fas fa-cart-plus text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Pré-Venda</span>
                        <span class="info-box-number text-white">(F3)</span>
                      </div>
                    </div>
                  </button>
                  <!-- </a> -->
                </div>
                <div class="col-lg-2 col-12">
                  <!-- <a href="devolucao/create"> -->
                  <button id="btnDevolucao" class="botoesPainel">
                    <div class="info-box bg-info" id="atalhoDevoTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-cart-arrow-down text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Devolução</span>
                        <span class="info-box-number text-white">(F5)</span>
                      </div>
                    </div>
                  </button>
                  <!-- </a> -->
                </div>
                <div class="col-lg-2 col-12">
                  <a href="#">
                    <div class="info-box bg-info" id="atalhoPrecoTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-book text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Preços</span>
                        <span class="info-box-number text-white">(F6)</span>
                      </div>
                    </div>
                  </a>
                </div>
                <!-- <div class="col-lg-2 col-12">
                  <a href="venda/create">
                    <div class="info-box bg-info" id="atalhoPrevendaTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-cart-plus text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Contas A Rec.</span>
                        <span class="info-box-number text-white">(F10)</span>
                      </div>
                    </div>
                  </a>
                </div> -->
                <div class="col-lg-2 col-12">
                  <a href="#">
                    <div class="info-box bg-info" id="atalhoCaixaTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-calculator text-info"></i></span>

                      <div class="info-box-content">
                        <span class="info-box-text text-white">Caixa</span>
                        <span class="info-box-number text-white">(F7)</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div class="col-lg-2 col-12">
                  <button id="btn-botao-presente" class="botoesPainel">
                    <!-- <a id="btn-botao-presente"> -->
                    <div class="info-box bg-info" id="atalhoPresenteTour">
                      <span class="info-box-icon bg-white"><i class="fas fa-gift text-info"></i></span>
                      <div class="info-box-content">
                        <span class="info-box-text text-white">Cartão Presente</span>
                        <span class="info-box-number text-white">(F8)</span>
                      </div>
                    </div>
                  </button>
                </div>
                <!-- <div class="col-sm-1"></div> -->
              </div>
            </div>
            <div class="container-fluid">
              <div class="row pb-4">
                <div class="col-sm-12">
                  <button class="btn btn-success btn-sisp" id="btnFiltrosTour" type="button">
                    <span class="fas fa-filter"></span> Filtros
                  </button>
                  <button id="btn-parametros" class="btn btn-sisp btn-success">
                    <span class="fas fa-cogs"></span> Config.
                  </button>
                  <button id="btn-solicitaAdm" class="btn btn-sisp btn-primary d-none">
                    <span class="fas fa-users-cog"></span> ADM TEF
                  </button>
                  <button id="abrirVendasNaoSalvas" class="btn btn-sisp btn-success">
                    <span class="fas fa-paste"></span> Vendas não salvas
                  </button>
                  <button id="btnMinhasVendas" class="btn btn-sisp btn-success">
                    <span class="fas fa-shopping-basket"></span>
                    <span> Minhas Vendas </span>
                  </button>
                  <button id="btnAgrupaVendas" class="btn btn-sisp btn-success d-none" title="Agrupamento de Vendas/Consignados">
                    <span class="fas fa-shopping-basket"></span>
                    <span> Agrupa. Vendas </span>
                  </button>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-sm-12 table-responsive" style="padding-left:14px">
                <table id="tabelaVendas" cellspacing="0" class="table table-sm table-select table-hover animate__animated animate__fadeIn" width="100%">
                  <thead>
                    <tr id="colunas">
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                      <th></th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </section>

      <div class="modal fade" id="modal-filtros">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-lg-3 col-12">
                  <div class="group-default form-group">
                    <label for="txtDataDe">Data De:</label>
                    <input class="form-check-input" style="margin-left: 75px;" type="checkbox" id="cbDataDeAtual" title="Quando marcado, considera sempre a data atual."> <label style="margin-left: 95px;" for="cbDataDeAtual" title="Quando marcado, considera sempre a data atual.">Cons. Data Atual</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe" max="2500-12-31">
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <div class="group-default form-group">
                    <label for="txtDataAte">Data Até:</label>
                    <div class="relative">
                      <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="txtDataAte" max="2500-12-31">
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtCliente">Cliente:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtVendedorFiltro">Vendedor:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVendedorFiltro" name="txtVendedorFiltro" class="form-control" placeholder="Vendedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-vendedorFiltro" name="btn-vendedorFiltro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-vendedorFiltro" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtCaixaFiltro">Caixa:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCaixaFiltro" name="txtCaixaFiltro" class="form-control" placeholder="Caixa">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-caixa-filtro" name="btn-caixa-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-caixa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtTipoVendaFiltro">Tipo de Venda:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTipoVendaFiltro" name="txtTipoVendaFiltro" class="form-control" placeholder="Tipo de Venda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnPesquisaTipoVenda" name="btnPesquisaTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtVenda">Venda:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVenda" name="txtVenda" class="form-control" placeholder="Venda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-venda" name="btn-venda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-venda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-12">
                  <label data-error="wrong" data-success="right" for="txtCodSeq">Cód. Sequencial:</label>
                  <div class="input-group">
                    <input type="number" data-selecionado="false" class="input-default focus form-control" id="txtCodSeq" name="txtCodSeq" class="form-control" placeholder="Cod. Seq.">
                  </div>
                </div>

                <div class="col-lg-3 col-12 ">
                  <!-- <fieldset class="form border-Field mb-0 pb-0 d-flex"> -->
                  <!-- <legend class="textoBorda mb-0 pb-0">Status</legend> -->
                  <label class="textoBorda mt-3">Status</label>
                  <div class="row">
                    <div class="col-lg-4 col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbEmitido" checked> <label for="cbEmitido">Emitido</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbDevolvido" checked> <label for="cbDevolvido">Devolvido</label>
                      </div>
                    </div>
                    <div class="col-lg-4 col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbPendente" checked> <label for="cbPendente">Pendente</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="checkCanceladas" checked> <label for="checkCanceladas">Canceladas</label>
                      </div>
                    </div>
                    <div class="col-lg-4 col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbAgrupada" checked> <label for="cbAgrupada">Agrupada</label>
                      </div>
                    </div>
                  </div>
                  <!-- </fieldset> -->
                </div>

                <div class="col-lg-3 col-12" id="d_cf">
                  <label class="textoBorda mt-3 pl-2">Sem Documento Fiscal</label>
                  <div class="row pl-2">
                    <div class="col-lg-12 col-12">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbSemNFE"> <label for="cbSemNFE">Sem NFe</label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="cbSemNFCE"> <label for="cbSemNFCE">Sem NFCe</label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-lg-3 col-12 mt-3 d-none" id="d_nfe">
                  <label data-error="wrong" data-success="right" for="txtNFe">Nº NF-e:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNFe" name="txtNFe" class="form-control" placeholder="Nº NF-e">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-NFe" name="btn-NFe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-NFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-3 col-12 mt-3 d-none" id="d_nfce">
                  <label data-error="wrong" data-success="right" for="txtNFCe">Nº NFC-e:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNFCe" name="txtNFCe" class="form-control" placeholder="Nº NFC-e">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-NFCe" name="btn-NFCe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-NFCe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-3 col-12 mt-3 d-none" id="d_cf">
                  <label data-error="wrong" data-success="right" for="txtCupom">Nº Cupom Fiscal:</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCupom" name="txtCupom" class="form-control" placeholder="Nº Cupom Fiscal">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Cupom" name="btn-Cupom" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Cupom" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="modal-footer">
              <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
                Filtros</button>     
              <button id="btnConsultar" class="btn btn-primary btn-sisp float-right" type="button">
                <span class="fas fa-search"></span> Consultar
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-vendedor">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Configurações Loja</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row block">
                <div class="col-sm-12">
                  <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVendedor" name="txtVendedor" class="form-control" placeholder="Vendedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-vendedor" name="btn-vendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-vendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-sm-12">
                  <label data-error="wrong" data-success="right" for="txtCaixa">Caixa</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa">
                    <div class="input-group-append">
                      <button class="btn bg-danger d-none" id="btn-impostor" name="btn-impostor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-caixa" name="btn-caixa-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-caixa2" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
              <button id="confirmar_dados" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>

      <div class="modal fade" id="modal-cancelar">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title" id="title-cancelar"></h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row block">
                <div class="col-sm-12">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtObs">Observação</label>
                    <input class="d-none" id="txt_cancelar_cupom" />
                    <textarea type="textarea" style="resize: none" placeholder="Observação" class="input-default focus form-control validate" id="txtObs" name="txtObs" required="required" rows="3"></textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Fechar</button>
              <button id="confirmar_obs" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <div class="modal fade" id="modal-nfce" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
          <div class="modal-content">
            <div class="modal-header">
              <h4 id="modalNFCE-titulo" class="modal-title">Converter Venda para NFC-e</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-12">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtClienteNFCE">Cliente</label>
                    <div class="input-group">
                      <input type="text" placeholder="Cliente" class="input-default" id="txtClienteNFCE" name="txtClienteNFCE" disabled>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnClienteNFCE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-12">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtCpfNFCE">CPF/CNPJ</label>
                    <input type="text" placeholder="CPF/CNPJ" class="input-default" id="txtCpfNFCE" name="txtCpfNFCE">
                    <input type="text" placeholder="Venda" class="input-default d-none" id="txtCodVen" name="txtCodVen">
                  </div>
                </div>
                <div class="col-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaNFCE">Natureza</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaNFCE" name="txtNaturezaNFCE" class="form-control" placeholder="Natureza">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-NaturezaNFCE" name="btn-NaturezaNFCE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12" style="margin-top: 13px">
                  <label data-error="wrong" data-success="right" for="txtOperacaoNfce">Operação</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtOperacaoNfce" name="txtOperacaoNfce" placeholder="Operação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOperacaoNfce" name="btnOperacaoNfce" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnAOperacaoNfce" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-12" style="margin-top: 13px">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtInfoAdicionaisNFCE">Informações
                      Adicionais</label>
                    <textarea type="textarea" style="resize: none" placeholder="Informações Adicionais" class="input-default focus form-control validate" id="txtInfoAdicionaisNFCE" name="txtInfoAdicionaisNFCE" required="required" rows="3"></textarea>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <div class="col-sm-12">
                  <button id="btn_confirmar_nfce" class="btn btn-danger btn-sisp"> Confirmar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal fade" id="modalNFE" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 id="modalNFCE-titulo" class="modal-title">Faturar Venda</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtClienteNFE">Cliente</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtClienteNFE" name="txtClienteNFE" class="form-control" placeholder="Cliente">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ClienteNFE" name="btn-ClienteNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ClienteNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-12" style="margin-top: 2%">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtNaturezaNFE">Natureza</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNaturezaNFE" name="txtNaturezaNFE" class="form-control" placeholder="Natureza">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-NaturezaNFE" name="btn-NaturezaNFE" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-NaturezaNFE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12" style="margin-top: 2%">
                  <label data-error="wrong" data-success="right" for="txtOperacaoNota">Operação</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtOperacaoNota" name="txtOperacaoNota" placeholder="Operação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnOperacaoNota" name="btnOperacaoNota" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnAOperacaoNota" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <div class="col-sm-12">
                  <button type="button" id="btn_confirmar_nfe" class="btn btn-danger"> Confirmar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modalAlterarVendedor" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-sm">
          <div class="modal-content">
            <div class="modal-header">
              <h4 id="modalAlterarVendedor-titulo" class="modal-title">Alterar Vendedor</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-12">
                  <label for="txtVendaVendedor">Venda</label>
                  <div class="relative">
                    <input type="text" id="txtVendaVendedor" name="txtVendaVendedor" class="input-default focus form-control" disabled>
                  </div>
                </div>
                <div class="col-12" id="VendedorInfoTour">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtAlterarVendedor">Vendedor</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtAlterarVendedor" name="txtAlterarVendedor" class="form-control" placeholder="Vendedor" required>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-AlterarVendedor" name="btn-AlterarVendedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-AlterarVendedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <div class="col-sm-12">
                  <button type="button" id="btn_confirmar_alterarVendedor" class="btn btn-danger"> Confirmar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modalVisualizaCartaoPresente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h4 id="modalVisualizaCartaoPresente-titulo" class="modal-title">Cartão Presente</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-12 form-group">
                  <label for="txtCartaoPresenteVisualiza">Cartão Presente</label>
                  <div class="relative">
                    <input type="text" id="txtCartaoPresenteVisualiza" name="txtCartaoPresenteVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
                <div class="col-6 form-group">
                  <label for="txtEmissaoVisualiza">Emissão</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" id="txtEmissaoVisualiza" name="txtCartaoPresenteVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
                <div class="col-6 form-group">
                  <label for="txtVencimentoVisualiza">Vencimento</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" id="txtVencimentoVisualiza" name="txtCartaoPresenteVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
                <div class="col-4 form-group">
                  <label for="txtValorVisualiza">Valor</label>
                  <div class="relative">
                    <input type="text" id="txtValorVisualiza" name="txtValorVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
                <div class="col-4 form-group">
                  <label for="txtValorUtilizadoVisualiza">Valor Utilizado</label>
                  <div class="relative">
                    <input type="text" id="txtValorUtilizadoVisualiza" name="txtValorUtilizadoVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
                <div class="col-4 form-group">
                  <label for="txtValorRestanteVisualiza">Valor Restante</label>
                  <div class="relative">
                    <input type="text" id="txtValorRestanteVisualiza" name="txtValorRestanteVisualiza" class="input-default focus form-control" readonly disabled>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button type="button" id="btnImprimirCartaoPresente" class="btn btn-secondary mr-1">Imprimir</button>
                <button type="button" id="btnConfirmarVisuCartao" class="btn btn-danger"> Confirmar</button>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade" id="modal-cartao-presente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
              <h4 id="modal-titulo" class="modal-title">Lançamento Cartão Presente</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="col-12 mx-0">
                <form id="msform">
                  <ul id="progressbar">
                    <li class="active" id="account"><strong>Cartão Presente</strong></li>
                    <li id="personal"><strong>Parcelas</strong></li>
                  </ul>
                  <div class="input-group" style="margin-top: 26px; margin-left: 10px">
                    <input title="Criar uma antecipação para o cliente" type="checkbox" id="cbLancarAntecipacao"> <label title="Criar uma antecipação para o cliente" for="cbLancarAntecipacao" style="margin-top: 6px; margin-left: 5px;">Lançar como Antecipação</label>
                  </div>
                  <fieldset class="active">
                    <div class="form-card">
                      <h2 class="fs-title">Dados Cartão Presente</h2>
                      <div class="form-row">
                        <div class="col-6">
                          <label for="txtNumeroPresente">Número</label>
                          <div class="input-group">
                            <input id="txtNumeroPresente" name="txtNumeroPresente" placeholder="Número" type="text" class="input-default focus form-control validate" required />
                            <input id="txtNumeroInvisivel" name="txtNumeroInvisivel" placeholder="Número" type="text" class="input-default focus form-control d-none" />
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnNumeroPresente" name="btnNumeroPresente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaNumeroPresente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-6">
                          <label data-error="wrong" data-success="right" for="txtClientePresente">Cliente</label>
                          <div class="input-group">
                            <input type="text" data-selecionado="false" class="input-default focus form-control validate" required id="txtClientePresente" name="txtClientePresente" placeholder="Cliente">
                            <input type="text" class="input-default form-control d-none" id="txtCNPJPresente" name="txtCNPJPresente">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btn-cliente-presente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btn-limpa-cliente-presente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                        <div class="col-6">
                          <label for="txtDataPresente">Data de Validade</label>
                          <div class="input-group-append">
                            <input id="txtDataPresente" name="txtDataPresente" type="date" max="2500-12-31" class="input-default focus form-control validate" required />
                          </div>
                        </div>
                        <div class="col-6">
                          <label for="txtValorPresente">Valor</label>
                          <div class="input-group-append">
                            <input min="1.00" value="0.00" id="txtValorPresente" name="txtValorPresente" placeholder="Valor" type="text" class="input-default focus form-control validate valoresInput" required />
                          </div>
                        </div>
                      </div>
                      <input type="submit" name="next" class="btn btn-danger btn-sisp next action-button focus" id="btnProximo1" value="Próximo" />
                    </div>
                  </fieldset>
                  <fieldset style="padding: 0px!important;">
                    <div class="form-card" style="padding: 0px!important;">
                      <h2 class="fs-title">Parcelas/Pagamento</h2>
                      <div class="row">
                        <div class="col-12" id="condicoesCartao">
                          <div class="row">
                            <div class="col-12" id="divtxtMoeda">
                              <label data-error="wrong" data-success="right" for="txtMoeda">Moeda</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-moeda" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-moeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-3 bandeira d-none" id="divSelectBandeira">
                              <label>Bandeira</label>
                              <div class="input-group">
                                <select class="form-control select2 select2-danger focus" id="select_bandeira" name="select_bandeira" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                  <option value="" selected="selected">Selecione uma bandeira</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-8">
                              <label data-error="wrong" data-success="right" for="txtCondicaoDePagamento">Cond.
                                Pagamento</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCondicaoDePagamento" name="txtCondicaoDePagamento" class="form-control" placeholder="Condição de Pagamento">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-CondicaoDePagamento" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-condicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                            <div class="col-2 d-none">
                              <div class="group-default">
                                <label for="txtNrParcelas">Nr. Parcelas</label>
                                <div class="relative">
                                  <input type="text" placeholder="Nr. Parcelas" class="input-default" id="txtNrParcelas" name="txtNrParcelas" readonly>
                                </div>
                              </div>
                            </div>
                            <div class="col-4">
                              <div class="group-default">
                                <label>Valor</label>
                                <input id="txtValorParcela" placeholder="Valor" type="text" class="input-default form-control valoresInput" />
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-sm-10 mt-2">
                              <h5 style="width:100%;color: var(--font-color)!important;padding: 5px;border-radius: 3px; padding-top:7px" class="float-left">Saldo à Pagar : <span id="txtsaldo_a_pagar">R$&nbsp;00,00</span></h5>
                            </div>
                            <div class="col-sm-2 mt-2 d-flex justify-content-">
                              <button type="button" id="btnAddCondicao" style="font-size:15px" class="btn btn-lg btn-secundary action-button float-right focus btn-sisp">Adicionar</button>
                            </div>
                          </div>
                        </div>
                        <div class="col-12 d-none" id="card-lista-parcelas">
                          <div class="card" style="margin-top:40px;">
                            <div class="card-header">
                              <h5>Lista de Parcelas</h5>
                            </div>
                            <div class="card-body table-responsive">
                              <table id="tabela-parcelas" width="100%" style="width:100%" class="table table-sm table-select table-hover">
                                <thead>
                                  <tr>
                                    <th>Moeda</th>
                                    <th>Condição</th>
                                    <th>Parcela</th>
                                    <th>Vencimento</th>
                                    <th>Valor</th>
                                    <th>Desc. Moeda</th>
                                    <th>usaTef</th>
                                    <th>ValorTotal</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                              <button id="btn-limpa-tabela-parcelas" class="btn bg-danger float-right">
                                Limpar
                              </button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <input id="btn-concluir" type="button" name="next" class="btn btn-danger btn-sisp next action-button" value="Concluir" />
                    <input type="button" name="previous" class="btn btn-success btn-sisp previous action-button-previous" value="Voltar" />
                  </fieldset>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalMinhasVendas">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Minhas Vendas</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-lg-3 col-12">
                <div class="group-default form-group">
                  <label for="txtDataDeMinhasVendas">Data De:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDeMinhasVendas" name="txtDataDeMinhasVendas">
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-12">
                <div class="group-default form-group">
                  <label for="txtDataAteMinhasVendas">Data Até:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataAteMinhasVendas" name="txtDataAteMinhasVendas">
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-12">
                <label data-error="wrong" data-success="right" for="txtClienteMinhasVendas">Cliente:</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtClienteMinhasVendas" name="txtClienteMinhasVendas" class="form-control" placeholder="Cliente">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnClienteMinhasVendas" name="btnClienteMinhasVendas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaClienteMinhasVendas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-3 col-12">
                <label data-error="wrong" data-success="right" for="txtVendaMinhasVendas">Venda:</label>
                <div class="input-group">
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtVendaMinhasVendas" name="txtVendaMinhasVendas" class="form-control" placeholder="Venda">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnVendaMinhasVendas" name="btnVendaMinhasVendas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btnLimpaVendaMinhasVendas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-12  col-12" style="margin-top: 1%;" id="tabelatuto">
                <label data-error="wrong" data-success="right" for="tabelaMinhasVendas" style="margin-right: 963px;">Vendas</label>
                <table width="100%" style="width: 100%" id="tabelaMinhasVendas" class="align-self-center table table-sm table-select table-hover">
                  <thead>
                    <tr>
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp" id="btnImprimirMinhasVendas" style="background-color: #B22222; border-color: #B22222">
              <span class="fas fa-print" style="color: var(--font-color) !important;"></span> Imprimir
            </button>   
            <button class="btn btn-primary btn-sisp" id="btnFecharMinhasVendas" style="background-color: #B22222; border-color: #B22222"> Fechar</button>   
            <button id="btnConsultarMinhasVendas" class="btn btn-primary btn-sisp float-right" type="button">
              <span class="fas fa-search"></span> Consultar
            </button>
          </div>
        </div>
      </div>
    </div>
    <!-- /.content -->
  </div>
  </div>

  <?php
  include_once('../../footer.php');
  include_once('../../menu_fiscal.php');
  include_once('modais/modal_cupom_troca.php');
  include_once('modais/modal_cfe.php');
  include_once('modais/modal_vendaFechada.php');
  include_once('modais/modal_crmbonus.php');
  ?>
  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.content-wrapper -->
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js?versao=3.245.9.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-ui/jquery-ui.min.js?versao=3.245.9.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.245.9.1"></script>
  <!-- ChartJS -->
  <script src="<?php echo BASE_URI; ?>/plugins/chart.js/Chart.min.js?versao=3.245.9.1"></script>
  <!-- Sparkline -->
  <script src="<?php echo BASE_URI; ?>/plugins/sparklines/sparkline.js?versao=3.245.9.1"></script>

  <script src="<?php echo BASE_URI; ?>/dist/js/adminlte.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/adminltemenu.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/loadingoverlay.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/dataTables.bootstrap4.min.js?versao=3.245.9.1"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/sum().js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.keyTable.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/utils/cookies.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/requisicoes.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/driver.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/toastr/toastr.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/sisplan.js?versao=3.245.9.1"></script>

  <script src="<?php echo BASE_URI; ?>/plugins/daterangepicker/daterangepicker.js?versao=3.245.9.1"></script>
  <!-- Select2 -->
  <script src="<?php echo BASE_URI; ?>/plugins/select2/js/select2.full.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/valida_cpf_cnpj.js?versao=3.245.9.1"></script>

  <script src="<?php echo BASE_URI; ?>/pages/loja/js/rotinas.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-validation/jquery.validate.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-validation/additional-methods.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/datetime.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/plugins/moment/moment.min.js?versao=3.245.9.1"></script>
  <script src="<?php echo BASE_URI; ?>/pages/cfe/cfe.js?versao=3.245.9.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.245.9.1"></script>

  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.maskMoney.min.js?versao=3.245.9.1"></script>

  <script src="<?php echo BASE_URI; ?>/dist/js/jquery.mask.min.js?versao=3.245.9.1"></script>
  <!-- date-<-picker -->
  <!-- InputMask -->
  <script>
    //inicio tour
    document.addEventListener('keydown', (event) => {
      const keyName = event.key;

      if (keyName === 'F3') {
        event.preventDefault();
        parent.abrirEmNovaAbaIFrame('Venda', `<?php echo BASE_URI; ?>/venda/create`);
      } else if (keyName === 'F2') {
        event.preventDefault();
        parent.abrirEmNovaAbaIFrame('Cliente', `<?php echo BASE_URI; ?>/cliente`);
      } else if (keyName === 'F5') {
        event.preventDefault();
        parent.abrirEmNovaAbaIFrame('Devolução', `<?php echo BASE_URI; ?>/devolucao/create`);
      } else if (keyName === 'F6') {
        event.preventDefault();
        parent.abrirEmNovaAbaIFrame('Preços', `<?php echo BASE_URI; ?>/precos`);
      } else if (keyName === 'F7') {
        event.preventDefault();
        parent.abrirEmNovaAbaIFrame('Caixa', `<?php echo BASE_URI; ?>/caixa`);
      } else if (keyName === 'F8') {
        event.preventDefault();
        $('#btn-botao-presente').trigger('click');
      }
    });

    $('#atalhoClienteTour').on('click', () => {
      parent.document.querySelector('#menu_entidade .nav-link').click();
    })

    $('#atalhoPrecoTour').on('click', () => {
      parent.document.querySelector('#menu_venda_preco .nav-link').click();
    })

    $('#atalhoCaixaTour').on('click', () => {
      parent.document.querySelector('#menu_venda_caixa .nav-link').click();
    })

    $('#btnFiltrosTour').on('click', async function() {
      $('#cbEmitido').prop('checked', JSON.parse(getCookie('emitido') == '' ? true : getCookie('emitido')));
      $('#cbPendente').prop('checked', JSON.parse(getCookie('pendente') == '' ? true : getCookie('pendente')));
      $('#cbDevolvido').prop('checked', JSON.parse(getCookie('devolvido') == '' ? true : getCookie('devolvido')));
      $('#checkCanceladas').prop('checked', JSON.parse(getCookie('canceladas') == '' ? true : getCookie('canceladas')));
      $('#cbAgrupada').prop('checked', JSON.parse(getCookie('agrupada') == '' ? true : getCookie('agrupada')));
      // if ($('#cbDataDeAtual').prop('checked')) {
      //   await setarDataAtual('txtDataDe');
      // } else {
      //   await setarDataAtual('txtDataDe', true);
      // }
      // não altero mais a data no clique do botão, apenas quando recarregar a página.
      $('#modal-filtros').modal('show');
    });

    jQuery.extend(jQuery.validator.messages, {
      required: "This field is required.",
      remote: "Please fix this field.",
      email: "Please enter a valid email address.",
      url: "Please enter a valid URL.",
      date: "Please enter a valid date.",
      dateISO: "Please enter a valid date (ISO).",
      number: "Please enter a valid number.",
      digits: "Please enter only digits.",
      creditcard: "Please enter a valid credit card number.",
      equalTo: "Please enter the same value again.",
      accept: "Please enter a value with a valid extension.",
      maxlength: jQuery.validator.format("Please enter no more than {0} characters."),
      minlength: jQuery.validator.format("Please enter at least {0} characters."),
      rangelength: jQuery.validator.format("Please enter a value between {0} and {1} characters long."),
      range: jQuery.validator.format("Please enter a value between {0} and {1}."),
      max: jQuery.validator.format("Please enter a value less than or equal to {0}."),
      min: jQuery.validator.format("Informe um valor maior ou igual a 1.00")
    });

    $('#tutorial').on('click', function() {
      $('#geral-tab').trigger('click');
      $(document).ready(async function() {

        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false,
          onHighlightStarted: (Element) => {
            if (Element.node.id == 'card-body-filtrar') {
              if (!$('#collapseFiltros').hasClass('show')) {
                $('#btnFiltrosTour').trigger('click');
              }
            }
          }
        });

        driver.defineSteps([{
            element: '#painelLojaTour',
            popover: {
              title: 'Totalizadores',
              description: 'Aqui é apresentado alguns indicadores referente as vendas filtradas.',
              position: 'botton'
            }
          }, {
            element: '#atalhoClienteTour',
            popover: {
              title: 'Atalho Clientes',
              description: 'Ao clicar aqui você será levado para a área de cadastro de clientes/fornecedores.',
              position: 'top'
            }
          },
          {
            element: '#atalhoPrevendaTour',
            popover: {
              title: 'Atalho Pré-Venda',
              description: 'Através desse botão, você será direcionado a tela de Pré-Venda, para iniciar uma nova venda.',
              position: 'top'
            }
          },
          {
            element: '#atalhoDevoTour',
            popover: {
              title: 'Atalho Devolução',
              description: 'Clicando aqui você será direcionado a tela de Devolução, onde poderá efetuar a devolução de algum produto e gerando um crédito para seu cliente.',
              position: 'top'
            }
          },
          {
            element: '#atalhoPrecoTour',
            popover: {
              title: 'Atalho Preços',
              description: 'Através desse botão, você será direcionado para a tela de Preços, onde você pode consultar os preços e estoque de determinados produtos.',
              position: 'top'
            }
          }, {
            element: '#atalhoCaixaTour',
            popover: {
              title: 'Atalho Caixa',
              description: 'Esse botão te levará a tela de Caixa, onde você tem um controle sobre as entradas, saídas e saldos disponíveis conforme as movimentações de sua loja.',
              position: 'top'
            }
          },
          {
            element: '#atalhoPresenteTour',
            popover: {
              title: 'Atalho Cartão Presente',
              description: 'Esse botão te levará a tela de cartão presente, onde você consegue lançar um cartão presente no sistema.',
              position: 'top'
            }
          },
          {
            element: '#btnFiltrosTour',
            popover: {
              title: 'Botão Filtros',
              description: 'Clique aqui para abrir os filtros disponíveis.',
              position: 'top'
            }
          },
          {
            element: '#card-body-filtrar',
            popover: {
              title: 'Botão Filtro',
              description: 'Filtre os dados conforme sua necessidade e depois clique em Consultar.',
              position: 'top'
            }
          },
          {
            element: '#btn-parametros',
            popover: {
              title: 'Botão Vendedor',
              description: 'Através desse botão você definirá o Vendedor e Caixa logado.',
              position: 'top'
            }
          },
          {
            element: '#tabelaVendas',
            popover: {
              title: 'Lista de Vendas',
              description: 'Aqui você consegue ver suas vendas, tendo a opção de realizar algumas ações como cancelar, editar ou até mesmo imprimir a venda. <br><b>OBS</b>: Essa lista será apresentada de acordo com os filtros informados nos passos anteriores. ',
              position: 'top'
            }
          }
        ]);
        //inicio tour 

        driver.start();

        const activeElement = driver.getHighlightedElement();
        // inicior tuor
        //final
      });
    });
    //fim tour
    $(document).ready(async function() {
      $('#cbDataDeAtual').prop('checked', JSON.parse(localStorage.getItem("cbDataDeAtual") == null ? false : localStorage.getItem("cbDataDeAtual")));
      const paramVen54 = await CopiaParametro('VENDA', 54);
      if ($('#cbDataDeAtual').prop('checked')) {
        await setarDataAtual('txtDataDe');
      } else {
        await setarDataAtual('txtDataDe', true);
      }
      await setarDataAtual('txtDataAte');
      await setarDataAtual('txtDataDeMinhasVendas', true);
      await setarDataAtual('txtDataAteMinhasVendas');
      const apenasVendasDoRepresentanteLogado = await apenasClientesVinculadosAoRepresentante();
      await carregaValoresPadroes();

      if (apenasVendasDoRepresentanteLogado) {
        await bloqueiaFiltroEPreencheValorRepresentante('#txtVendedorFiltro', '#btn-vendedorFiltro', '#btn-limpa-vendedorFiltro');
      };

      const temAcesso = await temAcessoTela('LOJA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, '<?php echo BASE_URI; ?>');
        return;
      }
      const permissaoAcessoLoja = await permissaoAcessos("LOJA");
      const permissaoAgrupamento = await permissaoAcessos("AGRUPAMENTO_VENDA");
      let usuarioNaoTrocouCaixaComSenhaSupervisor = ((sessionStorage.getItem('usuarioTrocouCaixaVinculadoComSenhaSupervisor') != 'true') && (paramVen54 != '2'));

      let listaOrdenacao = ['VENDA DESC'];

      let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (colunas == null || colunas.acessoVenda == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          acessoVenda: ['HR_VENDA', 'FECHADA']
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      $('#btnConfirmarColunas').on('click', async function() {
        try {
          $.LoadingOverlay('show');

          const novasColunas = (retornaNovasColunasInvisiveis()).filter(e => e != 'VENDA');

          novasColunas.push('HR_VENDA');
          novasColunas.push('FECHADA');

          localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
            ...colunas,
            acessoVenda: novasColunas
          }))

          $('#tabelaVendas').DataTable().columns().visible(true);

          $('#tabelaVendas').DataTable().columns().every(
            function() {
              if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
              }
            })

        } finally {
          $.LoadingOverlay('hide');
          $('#modal-ColunasVisiveis').modal('hide');
        }
      })

      $('#btnPreVenda').on('click', async function() {
        if (permissaoAcessoLoja.INCLUI == 'N') {
          msgAlerta('Usuário sem permissão para efetuar Vendas.');
          return;
        }
        if (await VerificaERetornaDataCaixaEmAberto()) {
          setCookie("idMaquina", gerarGuid(), 365);
          if (bUsaMFe) {
            window.location.href = "venda/create"
          } else {
            parent.abrirEmNovaAbaIFrame('Venda', '<?php echo BASE_URI; ?>/venda/create')
          }
        }
      });

      $('#btnDevolucao').on('click', function() {
        if (permissaoAcessoLoja.INCLUI == 'N') {
          msgAlerta('Usuário sem permissão para efetuar Devoluções.');
          return;
        }
        if (bUsaMFe) {
          window.location.href = "devolucao/create"
        } else {
          // if (!parent.verificaTelaAberta('<?php echo BASE_URI; ?>/venda/create')) {
          setCookie("idMaquina", gerarGuid(), 365);
          parent.abrirEmNovaAbaIFrame('Devolução', '<?php echo BASE_URI; ?>/devolucao/create')
          // } else {
          //   msgAlerta('Tela de venda aberta em outra aba, feche e tente novamente!')

          //   return;
          // }
        }
      });

      if (permissaoAgrupamento.INCLUI == 'S') {
        $('#btnAgrupaVendas').removeClass('d-none');
      }

      await verificaPermissoes('LOJA');
      verificaSeTemIdNaMaquina();
      const idMaquina = 'JsonVenda-' + getCookie('idMaquina');

      $('#tabela-parcelas').DataTable({
        destroy: true,
        order: false,
        filter: false,
        paginate: false,
        search: false,
        "scrollCollapse": true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar (geral): ",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "columnDefs": [{
            "render": $.fn.dataTable.render.moment('DD/MM/YYYY'),
            "targets": 3,
          },
          {
            "targets": [5, 6, 7],
            "visible": false
          }
        ]
      });

      $('#txtValorPresente').on('change', function() {

        $("#txtsaldo_a_pagar").html(parseFloat($(this).val()).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $('#txtValorParcela').val(parseFloat($(this).val()).toFixed(2));

      });

      $('#btn-botao-presente').on('click', async function() {
        event.preventDefault();

        if (permissaoAcessoLoja.INCLUI == 'N') {
          msgAlerta('Usuário sem permissão para utilizar Cartão Presente');
          return;
        }

        const parametrosLoja = await BuscaParametrosLoja();
        if (parametrosLoja[3].VALOR === '') {
          msgAlerta('Necessário definir o parametro de cliente padrão para utilizar o Cartão Presente. ');
          return;
        }

        $('#txtNumeroPresente').val('');
        $('#txtValorPresente').val('0.00');
        $('#modal-cartao-presente').modal('show');
        limpaValor('#txtClientePresente');
        $('#txtClientePresente').on('blur', function() {
          $('#btnProximo1').focus();
        });
        limpaValor('#txtMoeda');
        limpaValor('#txtCondicaoDePagamento');
        $('#txtValorParcela').val('0.00');
        $('#tabela-parcelas').DataTable().clear().draw(false);
        if ($($('fieldset')[0]).css('display') == 'none') {
          $('input[name="previous"]').trigger('click');
        }
      });

      $('#btnProximo1').on('keypress', async function() {
        $('#btnProximo1').trigger('click');
      });

      ipInterno = '<?php echo IP_INTERNO; ?>';
      ipExterno = '<?php echo IP_EXTERNO; ?>';
      basicAuth = '<?php echo BASIC_AUTH; ?>';
      //Date range picker
      $('#reservation').daterangepicker()
      //Date range picker with time picker
      //Date range as a button
      await controlaECF();

      $('#btnLimparFiltros').on('click', function() {
        $('#txtDataDe').val('1200-01-01')
        $('#txtDataAte').val('2500-12-01')
        $('#txtCliente').val('')
        $('#txtVendedorFiltro').val('')
        $('#txtCaixaFiltro').val('')
        $('#txtVenda').val('');
        $('#txtCodSeq').val('');
        $('#txtTipoVendaFiltro').val('');
        $('#txtNFe').val('');
        $('#txtNFCe').val('');
        $('#txtCupom').val('');
        $('#cbSemNFCE').prop('checked', false);
        $('#cbSemNFE').prop('checked', false);
        // $('#rg_status').val('Todos').trigger('change');
      });

      $('#btnAddCondicao').on('click', async function() {


        async function retornaMoedaUsaTef(sMoeda) {
          const json = await retornaJsonPesquisaPadrao(`{"tabela": "MOEDA", "camposSelect": ["TEF"], "where": ["CODMOE = '${sMoeda}' "] }`);

          if (json) {
            if (json[0].TEF == 'S') {
              return true
            }
            return false
          }

        }
        if ($('#txtMoeda').val() == '') {
          msgErro('Informe uma moeda para continuar.');
          return;
        }
        if ($('#txtCondicaoDePagamento').val() == '') {
          msgErro('Informe uma condição de pagamento para continuar.');
          return;
        }
        if ($('#txtValorParcela').val() <= 0) {
          msgErro('Informe um valor para continuar.');
          return;
        }

        $('#card-lista-parcelas').removeClass('d-none');
        const saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().substring(8).replace('.', '')).replace(
          ',', '.'));
        let valor = parseFloat($('#txtValorParcela').val()).toFixed(2);
        let troco = 0;

        if (saldo_a_pagar <= 0) {
          msgAlerta('Não há saldo a pagar.');
          return;
        }

        if (saldo_a_pagar < valor) {
          troco = valor - saldo_a_pagar;
          valor = saldo_a_pagar;
          msgAlerta('Inserido valor de: ' + valor + ', troco: ' + troco);
        }

        const tabela = $('#tabela-parcelas').DataTable();

        const total_parcelas = pegaChave('#txtNrParcelas');
        const iCodCondicao = $('#txtCondicaoDePagamento').attr('data-chave');
        const vValor = parseFloat(valor / total_parcelas).toFixed(2);
        const arr_venctos = await RetornaVencimentos(iCodCondicao);
        const codMoeda = $('#txtMoeda').attr('data-chave');
        const descMoeda = $('#txtMoeda').attr('data-desc');
        const usaTef = await retornaMoedaUsaTef(codMoeda);

        let dados = [];
        for (let index = 0; index < total_parcelas; index++) {
          dados = [
            codMoeda,
            iCodCondicao,
            index + 1,
            arr_venctos[index],
            vValor,
            descMoeda,
            usaTef,
            valor
          ];
          tabela.row.add(dados).draw(false);
        }

        const saldo = saldo_a_pagar - valor;
        $("#txtsaldo_a_pagar").html(parseFloat(saldo).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));
        limpaValor('#txtCondicaoDePagamento');
        $('#txtValorParcela').val(parseFloat(saldo));
        limpaValor('#txtMoeda');
        $('#txtMoeda').focus();
        if (parseFloat(saldo) == 0) {
          $('#condicoesCartao').addClass('d-none');
        }
      });

      $('#btn-limpa-tabela-parcelas').on('click', function() {
        var valor = parseFloat($('#txtValorPresente').val()).toFixed(2);
        $('#tabela-parcelas').DataTable().rows()
          .remove()
          .draw(false);
        $("#txtsaldo_a_pagar").html(parseFloat(valor).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        limpaValor('#txtMoeda');
        limpaValor('#txtCondicaoDePagamento');
        $('#txtValorParcela').val(valor);
        $('#condicoesCartao').removeClass('d-none');
        $('#card-lista-parcelas').addClass('d-none');
      });

      var current_fs, next_fs, previous_fs; //fieldsets
      var opacity;

      function preencheFormaPagamento() {
        const tabela = $('#tabela-parcelas').DataTable().rows().data().toArray().map((tabela) => {
          const objeto = {
            moeda: tabela[0],
            Qtde_Parcela: tabela[1],
            condicaoPagamento: tabela[1],
            valor: $('#txtValorPresente').val(),
            UsaTef: tabela[6],
          }
          return objeto
        });

        const condicao = tabela.filter((value, i) => tabela[i].moeda.indexOf(value.moeda) == i)

        const tablesNovas = condicao.map((filtrado) => {
          const objeto = {
            Moeda: filtrado.moeda,
            CodCondivenda: filtrado.condicaoPagamento,
            Qtde_Parcela: filtrado.moeda,
            Valor: filtrado.valor,
            UsaTef: filtrado.UsaTef,
          }
          return objeto
        })

        return tablesNovas
      }

      function preencheParcelas() {
        const parcelas = [];
        for (let i = 0; i < $('#tabela-parcelas').DataTable().data().length; i++) {
          const data = $('#tabela-parcelas').DataTable().row(i).data();
          const parcela = {
            Moeda: data[0],
            CondicaoPagamento: data[1],
            Parcela: data[2],
            Vencimento: data[3] + 'T00:00:00Z',
            Valor: data[4],
            UsaTef: data[6],
          }

          parcelas.push(parcela);
        }
        return parcelas;
      }

      let options = {
        onKeyPress(cpf, ev, el, op) {
          let masks = ["000.000.000-000", "00.000.000/0000-00"];
          $('#txtCpfNFCE').mask(cpf.length > 14 ? masks[1] : masks[0], op)
        },
      }

      if ($('#txtCpfNFCE').length > 11) {
        $('#txtCpfNFCE').mask("00.000.000/0000-00", options);
      } else {
        $('#txtCpfNFCE').mask('000.000.000-00#', options)
      }


      async function preencheParcelasImpressao() {
        ///impressao depois de gravar o cartao presente, alterando aqui, verificar se nao é necessário alterar na preencheParcelaReimpressao() -- Bruno 20/04/2023
        var parcelas = [];
        for (let i = 0; i < $('#tabela-parcelas').DataTable().rows().count(); i++) {
          var data = $('#tabela-parcelas').DataTable().row(i).data();

          const indice = await retornaJsonPesquisaPadrao(`{"tabela": "MOEDA_ECF", "camposSelect": ["MOEDA_ECF"], "WHERE": ["MOEDA = '''${data[0]}''' AND SERIE_ECF = '${getCookie('serie_ecf')}'"] }`)

          var parcela = new Object();
          parcela.codigo = data[0];
          parcela.Indice = indice.length > 0 ? indice[0].MOEDA_ECF : '';
          parcela.Descricao = data[5];
          parcela.Valor = parseFloat(data[7]);
          parcelas.push(parcela);
        }
        const parcelasFiltradas = parcelas.filter((parcela, i) => parcelas[i].codigo.indexOf(parcela.codigo) == i);
        return parcelas;
      }

      $('#modal-cartao-presente').on('shown.bs.modal', async function() {
        $('#txtNumeroPresente').focus();
        const sNumero = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
        $('#txtNumeroPresente').val(sNumero);
      });

      $('#btn-concluir').on('click', async function() {
        try {
          $.LoadingOverlay('show');

          if ($('#tabela-parcelas').DataTable().rows().count() == 0) {
            msgAlerta('Necessário informar as condições de pagamento.');
            return;
          }
          var saldo_a_pagar = parseFloat(($("#txtsaldo_a_pagar").html().substring(8).replace('.', ''))
            .replace(
              ',', '.'));
          if (saldo_a_pagar > 0) {
            msgErro('Cartão de presente com saldo a pagar, verifique.');
            return;
          }

          const objCartaoPresente = {
            CodCli: $('#txtClientePresente').attr('data-chave'),
            Numero: $('#txtNumeroPresente').val(),
            ValorCartao: $('#txtValorPresente').val(),
            FormaPagamento: preencheFormaPagamento(),
            Parcelas: preencheParcelas(),
            Bandeira: $('#select_bandeira').val(),
            dataVenc: pegaValor('#txtDataPresente'),
            antecipacao: $('#cbLancarAntecipacao').prop('checked') ? 'S' : 'N'
          };

          const bUsaTef = objCartaoPresente.FormaPagamento.filter((obj) => obj.UsaTef == true).length > 0;

          if (bUsaTef) {
            await chamaTefCartaoPresente(objCartaoPresente);
            return;
          } else {
            await gravaCartaoPresente(objCartaoPresente);
            return;
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      async function chamaTefCartaoPresente(objetoCartaoPresente) {
        try {
          const url = '/tef/vendamanualtef?';
          const response = await requisicao_ecf('POST', url, '', JSON.stringify(objetoCartaoPresente), 300000);

          if (!response) {
            msgErro('Erro ao comunicar com a API Local, verifique.');
            return false;
          }

          const jsonRetorno = await response.text();
          if (response.status != 200) {
            msgErro(jsonRetorno);
            return false;
          }

          await gravaCartaoPresente(objetoCartaoPresente);


        } catch (error) {
          return false;
          console.error(error);
        }
      }

      $('#txtNumeroPresente').on('blur', async function() {
        await RotinaSaidaNumeroPresente();
      });

      async function consultaBlocoXpendente() {
        const json = await retornaJsonPesquisaPadrao(`{"tabela": "VENDA_BLOCOX", "camposSelect": ["DATA_MOV", "RECIBO", "SERIE_ECF", "TIPO"], "where": ["IMPRESSO = 'N' AND EMP_ID=${getCookie('emp_id')} AND RECIBO IS NOT NULL "] }`);
        for (let i = 0; i < json.length; i++) {
          json[i].RECIBO != '' && await consultaBlocoXGoverno(json[i].DATA_MOV, json[i].SERIE_ECF, json[i].RECIBO);
        }
      }

      async function consultaBlocoXGoverno(data_mov, serie_ecf, recibo) {
        const url = '/sisplan/cupom/v1/blocoxreducao?';
        const tr = $('#tabela-blocox-redz tr.selected')[0];
        const data = $('#tabela-blocox-redz').DataTable().row($(tr)).data();
        if (recibo == '') {
          msgErro('Registro selecionado não possui recibo para consultar.');
          return;
        }
        const dataMov = moment(data_mov).format('DD/MM/YYYY');

        const params = `DATA_MOV=${dataMov}&SERIE=${serie_ecf}&RECIBO=${recibo}`;

        const response = await requisicao('GET', url, params, null);

        if (!response) {
          return;
        }
        if (response.status != 200) {
          return;
        }

        const json = await response.text();

        if (json != '') {
          msgAlerta(json);
        }

        await emiteBlocoXpendente(dataMov, serie_ecf);
      }

      async function emiteBlocoXpendente(dataMov, serie_ecf) {
        try {
          const url = '/sisplan/cupom/v1/blocoxreducao?';

          const response = await requisicao('POST', url, `DATA_MOV=${dataMov}&SERIE_ECF=${serie_ecf}`);

        } catch (error) {
          console.error(error);
        }
      }

      async function VerificaEMostraCartaoPresente(sCartaoPresente) {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const _params =
          `JSON={ "tabela":"receber", "camposSelect":["DT_EMISSAO", "DT_VENCTO", "VALOR2 VALOR", "VALOR_PAGO"], "where": ["CARTAO_PRESENTE= '${sCartaoPresente}'"]}`;
        try {
          const response = await requisicao('GET', _url, _params, null);
          if (!response) {
            msgErro('Erro ao buscar dados do cartão presente.');
            return;
          }

          if (response.status != 200) {
            msgErro('Erro ao buscar dados do cartão presente.');
            return;
          }

          const jsonStr = await response.json();
          if (jsonStr['RESULT'][0].length == 0) {
            return false;
          }

          const dados = jsonStr['RESULT'][0][0];

          $('#txtCartaoPresenteVisualiza').val(sCartaoPresente);
          $('#txtEmissaoVisualiza').val(dados.DT_EMISSAO.slice(0, 10));
          $('#txtVencimentoVisualiza').val(dados.DT_VENCTO.slice(0, 10));
          $('#txtValorVisualiza').val('R$ ' + dados.VALOR.toFixed(2));
          $('#txtValorUtilizadoVisualiza').val('R$ ' + dados.VALOR_PAGO.toFixed(2));
          $('#txtValorRestanteVisualiza').val('R$ ' + String((parseFloat(dados.VALOR) - parseFloat(dados.VALOR_PAGO)).toFixed(2)));

          $('#modalVisualizaCartaoPresente').modal('show');
          $('#modalVisualizaCartaoPresente').css('z-index', '99999');

          return true;

        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar dados do cartão presente.');
          return;
        }
      }

      $('#btnConfirmarVisuCartao').on('click', function() {
        $('#modalVisualizaCartaoPresente').modal('hide');
      });

      $('#btnImprimirCartaoPresente').on('click', async function() {
        const PesquisaCartaoPresente = {
          tabela: "RECEBER",
          camposSelect: [
            'RECEBER.CODCLI',
            'ENTIDADE.CNPJ',
            'RECEBER.LANCAMENTO',
            'RECEBER.NUMERO',
            'RECEBER.OBS',
            'RECEBER.STATUS',
            'RECEBER.EMP_ID',
            'RECEBER.MOEDA'
          ],
          innerJoin: [{
            "tabela": "ENTIDADE",
            "condicao": "RECEBER.CODCLI = ENTIDADE.CODCLI"
          }, ],
          where: [
            `RECEBER.CARTAO_PRESENTE = '${$('#txtCartaoPresenteVisualiza').val()}'`
          ]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCartaoPresente));

        const PesquisaDuplicataPaga = {
          tabela: "RECEBER",
          camposSelect: [
            'RECEBER.CODCLI',
            'ENTIDADE.CNPJ',
            'RECEBER.LANCAMENTO',
            'RECEBER.NUMERO',
            'RECEBER.OBS',
            'RECEBER.STATUS',
            'RECEBER.EMP_ID',
            'RECEBER.MOEDA',
            'MOEDA.DESCRICAO',
            'RECEBER.VALOR2'
          ],
          innerJoin: [{
              "tabela": "ENTIDADE",
              "condicao": "RECEBER.CODCLI = ENTIDADE.CODCLI"
            },
            {
              "tabela": "MOEDA",
              "condicao": "RECEBER.MOEDA = MOEDA.CODMOE"
            },
          ],
          where: [
            `RECEBER.LANCAMENTO = '${jsonStr[0].LANCAMENTO}' AND RECEBER.STATUS = 'DUPL'`
          ]
        };

        const jsonStrDup = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaDuplicataPaga));

        const cartaoPresente = {};
        cartaoPresente.CNPJ = jsonStrDup[0].CNPJ;
        cartaoPresente.Valor = parseFloat(jsonStrDup[0].VALOR2).toFixed(2);
        cartaoPresente.Observacao = '';
        cartaoPresente.FormaPagamento = await preencheParcelaReimpressao(jsonStrDup);
        cartaoPresente.Lista = [];
        cartaoPresente.nrCartaoPresente = $('#txtCartaoPresenteVisualiza').val();
        cartaoPresente.nrAntecipacao = "";
        cartaoPresente.lancouAntecipacao = "N";

        await imprimirComprovantePresente(cartaoPresente);

        $('#modalVisualizaCartaoPresente').modal('hide');
      });

      async function preencheParcelaReimpressao(moedaParcelas) {
        ///impressao do botao de imprimir do modal de visualizar o cartao presente, alterando aqui, verificar se nao é necessário alterar na preencheParcelaImpressao() -- Bruno 20/04/2023
        const parcelas = [];
        for (let i = 0; i < moedaParcelas.length; i++) {
          const data = moedaParcelas[i];
          const pesquisaMoeda = await retornaJsonPesquisaPadrao(`{"tabela": "MOEDA_ECF", "camposSelect": ["MOEDA_ECF"], "WHERE": ["MOEDA = '''${data.MOEDA}''' AND SERIE_ECF = '${getCookie('serie_ecf')}'"] }`)
          const parcela = new Object();
          parcela.codigo = data.MOEDA;
          parcela.Indice = pesquisaMoeda.length > 0 ? pesquisaMoeda[0].MOEDA_ECF : '';
          parcela.Descricao = data.DESCRICAO;
          parcela.Valor = parseFloat(data.VALOR2).toFixed(2);
          parcelas.push(parcela);
        }
        return parcelas;
      }

      function NaoTemCaixaVinculado() {
        return !sessionStorage.getItem('g_caixa_logado') || sessionStorage.getItem('g_caixa_logado') == 'undefined';
      }

      async function VinculaCaixaComUsuario() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
        const _usuarioCaixa =
          `JSON={"tabela": "VENDA_CAIXA", 
          "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.DEPOSITO", "DEPOSITO.DESCRICAO AS DESC_DEPOSITO", "VENDA_CAIXA.REGIAO", "REGIAO.DESCRICAO AS DESC_REGIAO"], 
          "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}' AND VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"],
          "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}],
          "leftjoin": [{"tabela" : "DEPOSITO", "condicao" : "DEPOSITO.CODIGO = VENDA_CAIXA.DEPOSITO"},
                       {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = VENDA_CAIXA.REGIAO"}]}`;
        try {
          const response = await requisicao('GET', _url, _usuarioCaixa, null);
          if (!response) {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length >= 1) {
              const sCaixa = '[' + jsonStr['RESULT'][0][0].NRCAIXA + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
              const sDeposito = jsonStr['RESULT'][0][0].DEPOSITO != '' ? '[' + jsonStr['RESULT'][0][0].DEPOSITO + '] - ' + jsonStr['RESULT'][0][0].DESC_DEPOSITO : '';
              const sTabelaPreco = jsonStr['RESULT'][0][0].REGIAO != '' ? '[' + jsonStr['RESULT'][0][0].REGIAO + '] - ' + jsonStr['RESULT'][0][0].DESC_REGIAO : '';

              if (paramVen54 == '2') { //consultar apenas os caixas vinculados ao usuário
                $('#btn-caixa').pesquisa(
                  '#txtCaixa',
                  'CODIGO',
                  'DESCRICAO',
                  `/sisplan/funcoes/v1/pesquisa?JSON={ 
                    "tabela":"caixa_loja", 
                    "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
                    "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
                    "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
                  }`,
                  'Pesquisa Caixa',
                  'caixa_loja'
                );

                $('#txtCaixa').autocompleta(
                  2,
                  `JSON={ 
                    "tabela":"caixa_loja", 
                    "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
                    "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
                    "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
                  }`
                );

                $('#btn-caixa-filtro').pesquisa(
                  '#txtCaixaFiltro',
                  'CODIGO',
                  'DESCRICAO',
                  `/sisplan/funcoes/v1/pesquisa?JSON={ 
                    "tabela":"caixa_loja", 
                    "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
                    "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
                    "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
                  }`,
                  'Pesquisa Caixa',
                  'caixa_loja'
                );

                $('#txtCaixaFiltro').autocompleta(
                  2,
                  `JSON={ 
                    "tabela":"caixa_loja", 
                    "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
                    "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
                    "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
                  }`
                );
              }

              if (usuarioNaoTrocouCaixaComSenhaSupervisor) {
                sessionStorage.setItem('g_caixa_logado', sCaixa);
              } else {
                if (NaoTemCaixaVinculado()) {
                  sessionStorage.setItem('g_caixa_logado', sCaixa);
                }
              }
              sessionStorage.setItem('g_deposito_vendedor_caixa', sDeposito);
              sessionStorage.setItem('g_tabpreco_vendedor_caixa', sTabelaPreco);
              if (!bPodeConsultarCaixas) {
                $("#btn-limpa-caixa2").attr("disabled", true);
                $("#txtCaixaFiltro").attr("disabled", true);
                $("#btn-caixa-filtro").attr("disabled", true);
                $("#btn-limpa-caixa").attr("disabled", true);
                $('#btn-impostor').removeClass('d-none');
                $('#btn-caixa').addClass('d-none');
              }
            }
          } else {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas vinculados ao usuário.');
          return;
        }

      }

      async function VerificaUnicoRegistro() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const _paramsCaixa =
          `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`;
        const _paramsVende =
          `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": ["ATIVO = 'S'"]}`;
        try {
          const response = await requisicao('GET', _url, _paramsCaixa, null);
          if (!response) {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length == 1) {
              const sCaixa = '[' + jsonStr['RESULT'][0][0].CODIGO + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
              sessionStorage.setItem('g_caixa_logado', sCaixa);
            } else {
              sessionStorage.setItem('g_caixa_logado', undefined);
            }
          } else {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas disponíveis.');
          return;
        }
        try {
          const response = await requisicao('GET', _url, _paramsVende, null);
          if (!response) {
            msgErro('Erro ao buscar vendedores disponíveis.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length == 1) {
              const sCaixa = '[' + jsonStr['RESULT'][0][0].CODREP + '] - ' + jsonStr['RESULT'][0][0].NOME;
              sessionStorage.setItem('g_vendedor_logado', sCaixa);
            }
          } else {
            msgErro('Erro ao buscar vendedores disponíveis.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar vendedores disponíveis.');
          return;
        }
      }

      async function RotinaSaidaNumeroPresente() {
        if ($('#txtNumeroPresente').val() == '') {
          return;
        }

        if (await VerificaEMostraCartaoPresente($('#txtNumeroPresente').val())) {
          $('#txtNumeroPresente').val('');
        }
      }

      async function imprimirComprovantePresente(objeto) {
        const params = `JSON=${encodeURIComponent(JSON.stringify(objeto))}`;
        let url;
        if (bUsaECF == 1) {
          url = `/cupom/imprimircupompresente?`;
          // const params = `NRCUPOM=${cupom}&NRVENDA=${venda}&TIPO_REL_GERENCIAL=${sRelParam}`;

          try {
            var response = await requisicao_ecf('POST', url, params, '', 30000);

            if (!response) {
              return;
            }
            //pegar dados pra update
            if (response.status != 200) {
              msgErro('Erro ao imprimir cupom gerencial.');
              return;
            } else {
              return;
            }
          } catch (error) {
            msgErro('Erro ao imprimir cupom gerencial.');
            return;
          }
        } else {
          try {
            $.LoadingOverlay('show');
            try {
              url = `/sisplan/impressao/v1/imprimircupompresente?`;
              const bImprimeAutomatico = await verificaImprimirAutomatico('CartaoPresente');
              let arquivo = await GeraRelatorio(`${url}CARTAO_PRESENTE=${objeto.nrCartaoPresente}&NUMERO_ANTECIPACAO=${objeto.nrAntecipacao}&LANCOU_ANTECIPACAO=${objeto.lancouAntecipacao}`, 'GET', 1000000, false, 'CartaoPresente');
              if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                  window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
              }

            } catch (error) {
              console.error(error);
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        }
      }

      async function gravaCartaoPresente(objeto) {
        try {
          var response = await requisicao('POST', '/Sisplan/Vendas/V1/CartaoPresente?',
            `CAIXA=${pegaChave(sessionStorage.getItem('g_caixa_logado'))}&JSON=${encodeURIComponent(JSON.stringify(objeto))}`, null);

          if (!response) {
            $.LoadingOverlay("hide");
            msgErro('Erro ao gerar cartão presente, tente novamente.');
            return;
          }

          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro('Erro ao gerar cartão presente, tente novamente.');
            return;
          }
          const nrAntecipacao = await response.text();
          const valor = parseFloat($('#txtValorPresente').val()).toFixed(2);
          const objImpressao = {};
          objImpressao.CNPJ = pegaChave('#txtCNPJPresente');
          objImpressao.Valor = valor;
          objImpressao.Observacao = '';
          objImpressao.FormaPagamento = await preencheParcelasImpressao();
          objImpressao.Lista = [];
          objImpressao.nrCartaoPresente = $('#txtNumeroPresente').val();
          objImpressao.nrAntecipacao = nrAntecipacao;
          objImpressao.lancouAntecipacao = $("#cbLancarAntecipacao").prop("checked") ? "S" : "N";
          await imprimirComprovantePresente(objImpressao);
          $('#btn-limpa-tabela-parcelas').trigger('click');
          $('#modal-cartao-presente').modal('hide');
          $('#divtxtMoeda').removeClass('col-9');
          $('#divtxtMoeda').addClass('col-12');
          $('#divSelectBandeira').addClass('d-none');
        } catch (error) {
          console.error(error);
          $.LoadingOverlay("hide");
          msgErro('Erro ao gerar cartão presente, tente novamente.');
          return;
        }
      }

      function proximoFieldSet() {
        current_fs = $('fieldset.active');
        next_fs = $('fieldset.active').next();

        //Add Class Active
        $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

        //show the next fieldset
        next_fs.show();
        //hide the current fieldset with style
        current_fs.animate({
          opacity: 0
        }, {
          step: function(now) {
            // for making fielset appear animation
            opacity = 1 - now;

            current_fs.css({
              'display': 'none',
              'position': 'relative'
            });
            next_fs.css({
              'opacity': opacity
            });
          },
          duration: 600
        });
        $('#txtMoeda').focus();

        $('#txtCondicaoDePagamento').on('blur', function() {
          $('#txtValorParcela').focus();
        });

        $('#txtValorParcela').on('blur', function() {
          $('#btnAddCondicao').focus();
        });

        addBandeira();
        $('#txtMoeda').on('blur', async function() {
          if ($('#txtMoeda').val() != '') {
            let dadosMoeda = [];
            dadosMoeda = await retornaMoeda(pegaChave('#txtMoeda'));
            if (dadosMoeda.RESULT[0][0].TIPO == 3 && dadosMoeda.RESULT[0][0].TEF == 'N') {
              $('#divtxtMoeda').removeClass('col-12');
              $('#divtxtMoeda').addClass('col-9');
              $('#divSelectBandeira').removeClass('d-none');
            } else {
              $('#divtxtMoeda').removeClass('col-9');
              $('#divtxtMoeda').addClass('col-12');
              $('#divSelectBandeira').addClass('d-none');
            }
            await rotinaSaidaMoedaPresente();
          }
        });

      };

      async function addBandeira() {
        var dados = await RetornaBandeiras();
        for (const bandeira of dados) {
          var optionText = bandeira.DESCRICAO;
          var optionValue = bandeira.DESCRICAO;
          $('#select_bandeira').append(`<option value="${optionValue}">
                                                     ${optionText}
                                                  </option>`);

        }
      }

      async function RetornaBandeiras() {
        var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
        var _params = `JSON={ "tabela":"bandeira", "camposSelect":["id_bandeira", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

        try {
          var response = await requisicao('GET', _url, _params, null);

          if (!response) {
            return;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }
          return jsonStr['RESULT'][0];
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar as bandeiras de cartões');
        }
      }

      async function retornaMoeda(iMoeda) {
        let url = `/sisplan/funcoes/v1/pesquisa?`;

        try {
          let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"moeda", "camposSelect":["TIPO", "TEF"], "where": ["moeda.codmoe = ${iMoeda}"] }`,
            null
          );

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          return jsonStr;
        } catch (error) {
          console.error(error);
          msgErro("Não foi possível buscar os dados de pagamento da moeda.");
        }
      }

      $('#btnAddCondicao').on('keypress', function() {
        $('#btnAddCondicao').trigger('click');
      });

      $('#btnAddCondicao').on('blur', function() {
        const pegaSaldoAPagar = parseFloat(($("#txtsaldo_a_pagar").html().substring(8).replace('.', '')).replace(
          ',', '.'));
        if (pegaSaldoAPagar == 0) {
          $('#btn-concluir').focus();
        }
      });

      $(".previous").click(function() {
        if ($('#tabela-parcelas').DataTable().rows().count() > 0) {
          msgAlerta('Condições de pagamento já informadas, necessário limpar para voltar.');
          return;
        }

        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();

        //Remove class active
        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");

        //show the previous fieldset
        previous_fs.show();

        //hide the current fieldset with style
        current_fs.animate({
          opacity: 0
        }, {
          step: function(now) {
            // for making fielset appear animation
            opacity = 1 - now;

            current_fs.css({
              'display': 'none',
              'position': 'relative'
            });
            previous_fs.css({
              'opacity': opacity
            });
          },
          duration: 600
        });
      });


      $.validator.setDefaults({
        submitHandler: function() {
          event.preventDefault();
          proximoFieldSet();
        }
      });
      $('#msform').validate({
        rules: {
          txtNumeroPresente: {
            required: true
          },
          txtValorPresente: {
            required: true
          },
          txtDataPresente: {
            required: true
          },
          txtClientePresente: {
            required: true
          }
        },
        messages: {
          txtNumeroPresente: {
            required: "Informe um número válido"
          },
          txtValorPresente: {
            required: "Informe um valor válido"
          },
          txtDataPresente: {
            required: "Informe uma data válida"
          },
          txtClientePresente: {
            required: "Informe um cliente válido"
          },

        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function(element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function(element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });

      async function usuarioMasterOuSupervisor() {
        try {
          const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

          return usuario[0].TIPO != 0;

        } catch (error) {
          console.error(error);
        }
      }

      const idEmpresa = getCookie('emp_id');
      const bNaoUsaNRCupom = $("#menu_fiscal").css("display") == 'none';
      const bUsaNFCE = await CopiaParametro('VENDA', 6);
      const bUsaECF = await CopiaParametro('VENDA', 8);
      const bUsaNFE = await CopiaParametro('VENDA', 20);
      const bUtilizaWhatsapp = utilizaWhatsapp();
      const bUsaCFE = ['1', '3'].includes(await CopiaParametro('VENDA', 18));
      const bUsaMFe = ['2', '4'].includes(await CopiaParametro('VENDA', 18));
      const bPodeConsultarCaixas = ((paramVen54 == '1') || (paramVen54 == '2'));
      const bTipoUsuario = await usuarioMasterOuSupervisor();
      const bIntegracaoiShopp = await CopiaParametro('VENDA', 68);
      const ocultaCupomTroca = parametrosVenda[79] == "1";
      await setarDataAtual('txtDataPresente', false, 30);

      $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      var sSeparador = "' - '";


      $('#btn-NFCe').pesquisa_serverside(
        ['#txtNFCe'],
        ['NOTA_NFCE.FATURA'],
        ['ENTIDADE.NOME'],
        `{
    "tabela": "VENDA",
    "camposSelect": ["NOTA_NFCE.FATURA", "VENDA.CODVEN", "ENTIDADE.NOME"],
    "leftjoin": [
      {
        "tabela": "ENTIDADE",
        "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"
      }
    ],
    "innerjoin": [
      {
        "tabela": "NOTA_NFCE",
        "condicao": "VENDA.CODVEN = NOTA_NFCE.CODVEN AND VENDA.EMP_ID = NOTA_NFCE.EMP_ID"
      }
    ],
    "where": ["VENDA.EMP_ID = ${getCookie('emp_id')}" , "NOTA_NFCE.FATURA IS NOT NULL"]
  }`,
        'Pesquisa NFC-e'
      );

      $('#btn-NFe').pesquisa_serverside(
        ['#txtNFe'],
        ['NOTA.FATURA'],
        ['ENTIDADE.NOME'],
        `{
    "tabela": "VENDA",
    "camposSelect": ["NOTA.FATURA", "VENDA.CODVEN", "ENTIDADE.NOME"],
    "leftjoin": [
      {
        "tabela": "ENTIDADE",
        "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"
      }
    ],
    "innerjoin": [
      {
        "tabela": "NOTA",
        "condicao": "VENDA.CODVEN = NOTA.CODVEN AND VENDA.EMP_ID = NOTA.EMP_ID"
      }
    ],
    "where": ["VENDA.EMP_ID = ${getCookie('emp_id')}" ,"NOTA.FATURA IS NOT NULL"]
  }`,
        'Pesquisa NF-e'
      );
      $('#btn-Cupom').pesquisa_serverside(['#txtCupom'], ['VENDA.NRCUPOM'], ['ENTIDADE.NOME'], `{"tabela":"VENDA", "camposSelect":[ "VENDA.NRCUPOM", "ENTIDADE.NOME"],  "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "VENDA.CODCLI = ENTIDADE.CODCLI"}],  "where":["VENDA.EMP_ID = ${getCookie('emp_id')}", "VENDA.NRCUPOM IS NOT NULL"]}`, 'Pesquisa Número de Cupom');

      $('#txtNFCe').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "NOTA_NFCE.FATURA CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"}], "innerjoin": [{"tabela": "NOTA_NFCE", "condicao": "VENDA.CODVEN = NOTA_NFCE.CODVEN AND VENDA.EMP_ID = NOTA_NFCE.EMP_ID"}], "where": ["venda.emp_id = ${idEmpresa}" ,"NOTA_NFCE.FATURA IS NOT NULL"]}`);
      $('#txtNFe').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "NOTA.FATURA CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"}], "innerjoin": [{"tabela": "NOTA", "condicao": "VENDA.CODVEN = NOTA.CODVEN AND VENDA.EMP_ID = NOTA.EMP_ID"}], "where": ["venda.emp_id = ${idEmpresa}" ,"NOTA.FATURA IS NOT NULL"]}`);
      $('#txtCupom').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.NRCUPOM CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"}], "where": ["venda.emp_id = ${idEmpresa}" , "VENDA.NRCUPOM IS NOT NULL"]}`);


      // $('#txtNFe').autocompleta(2, 'JSON={ "tabela":"VENDA", "camposSelect":[ "NOTA.FATURA", "ENTIDADE.NOME"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"}], "innerjoin": [{"tabela": "NOTA", "condicao": "VENDA.CODVEN = NOTA.CODVEN AND VENDA.EMP_ID = NOTA.EMP_ID"}], "where": ["venda.emp_id = ' + getCookie('emp_id') + '" ,"NOTA.FATURA IS NOT NULL"]');
      // $('#txtNFe').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "NOTA.FATURA CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "VENDA.CODCLI = ENTIDADE.CODCLI"}], "innerjoin": [{"tabela": "NOTA", "condicao": "VENDA.CODVEN = NOTA.CODVEN AND VENDA.EMP_ID = NOTA.EMP_ID"}], "where": ["venda.emp_id = ${getCookie('emp_id')}" ,"NOTA.FATURA IS NOT NULL"]`);


      $('#txtVenda').autocompleta(2, 'JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven CHAVE", "(venda.codcli || ' + sSeparador + ' ||entidade.nome) DESCRICAO" ], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["venda.emp_id = ' + getCookie('emp_id') + '"]}');
      $('#txtVendedorFiltro').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep CHAVE", "nome descricao", "fantasia", "cnpj" ], "where": ["ativo = 'S'"]}`);
      $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S'"] }`);
      $('#txtAlterarVendedor').autocompleta(2, `JSON={ "tabela":"represen", "camposSelect":[ "codrep CHAVE", "nome descricao", "fantasia", "cnpj" ], "where": ["ativo = 'S'"]}`);
      $('#txtNaturezaNFCE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
      $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"] }`);
      $('#txtClienteNFE').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      $("#txtOperacaoNota").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
      $("#txtOperacaoNfce").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
      $('#txtTipoVendaFiltro').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
      $('#txtClienteMinhasVendas').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": [] }`);
      $('#txtVendaMinhasVendas').autocompleta(2, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "(VENDA.CODCLI || ${sSeparador} ||ENTIDADE.NOME) DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}, {"tabela" : "ITVENDA", "condicao" : "ITVENDA.CODVEN = VENDA.CODVEN"}], "groupby" : ["VENDA.CODVEN", "VENDA.CODCLI", "ENTIDADE.NOME"], "where": ["VENDA.EMP_ID = ${getCookie('emp_id')}", "ITVENDA.CODREP = '${pegaChave(sessionStorage.getItem('g_vendedor_logado'))}'", "(VENDA.AGRUPADA IS NULL OR VENDA.AGRUPADA = 'N')"]}`);


      $('#btn-AlterarVendedor').pesquisa('#txtAlterarVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen","camposSelect": ["codrep", "nome"],"where": ["ativo = 'S'"]}`, 'Pesquisa Representante', 'represen');
      $('#btn-NaturezaNFCE').pesquisa('#txtNaturezaNFCE', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": null}', 'Pesquisa Natureza', 'natureza');
      $('#btn-NaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-ClienteNFE').pesquisa('#txtClienteNFE', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome" ], "where": null}', 'Pesquisa Cliente', 'entidade');
      $('#btnClienteNFCE').pesquisa_serverside(['#txtClienteNFCE', "#txtCpfNFCE"], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ${parametrosVenda[65] == '1' ? ["ENTIDADE.TIPO = '1' AND ENTIDADE.CONS_FINAL = 'Sim'"] : "null"} }`, 'Pesquisa de Cliente', () => {
        $("#txtCpfNFCE").val(pegaChave("#txtCpfNFCE"));
      });
      $("#btnOperacaoNota").pesquisa("#txtOperacaoNota", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");
      $("#btnOperacaoNfce").pesquisa("#txtOperacaoNfce", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");
      $('#btnClienteMinhasVendas').pesquisa_serverside(['#txtClienteMinhasVendas'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa Cliente');
      $('#btnVendaMinhasVendas').pesquisa('#txtVendaMinhasVendas', 'CODVEN', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "(VENDA.CODCLI || ${sSeparador} ||ENTIDADE.NOME) CLIENTE" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}, {"tabela" : "ITVENDA", "condicao" : "ITVENDA.CODVEN = VENDA.CODVEN"}], "groupby" : ["VENDA.CODVEN", "VENDA.CODCLI", "ENTIDADE.NOME"], "where": ["VENDA.EMP_ID = ${getCookie('emp_id')}", "ITVENDA.CODREP = '${pegaChave(sessionStorage.getItem('g_vendedor_logado'))}'", "(VENDA.AGRUPADA IS NULL OR VENDA.AGRUPADA = 'N')"]}`, 'Pesquisa Venda', 'VENDA');


      $("#btnAOperacaoNota").on("click", function() {
        $("#txtOperacaoNota").val("");
      });
      $("#btnAOperacaoNfce").on("click", function() {
        $("#txtOperacaoNfce").val("");
      });

      $("#btn-limpa-AlterarVendedor").on("click", function() {
        $("#txtAlterarVendedor").val("");
      });

      $("#btnLimpaClienteMinhasVendas").on("click", function() {
        $("#txtClienteMinhasVendas").val("");
      });

      $("#btnLimpaVendaMinhasVendas").on("click", function() {
        $("#txtVendaMinhasVendas").val("");
      });

      //Initialize Select2 Elements
      $('.select2').select2();

      //Initialize Select2 Elements
      $('.select2bs4').select2({
        theme: 'bootstrap4'
      });
      if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login"
        return;
      }

      await VinculaCaixaComUsuario();

      $('#btn-impostor').on('click', async function() {
        function abrePesquisaCaixa() {
          usuarioNaoTrocouCaixaComSenhaSupervisor = false;
          sessionStorage.setItem('usuarioTrocouCaixaVinculadoComSenhaSupervisor', 'true');
          $('#btn-caixa').trigger('click');
        }
        await senhaSupervisor(
          `Usuário com caixa vinculado.`,
          abrePesquisaCaixa);
      });

      if (NaoTemCaixaVinculado()) {
        await VerificaUnicoRegistro();
        if (NaoTemCaixaVinculado()) {
          $("#modal-vendedor").modal("show");
        } else {
          $("#txtCaixaFiltro").val(sessionStorage.getItem('g_caixa_logado'));
        }
      } else {
        if (sessionStorage.getItem('g_caixa_logado') != 'undefined') {
          if (!bPodeConsultarCaixas) {
            $("#txtCaixaFiltro").val(sessionStorage.getItem('g_caixa_logado'));
          }
        }

        // var hostname = `JsonVenda-${sessionStorage.getItem('g_idAba')}-${getCookie('idMaquina')}`;
        // if ($("#txtCaixaFiltro").val() != "") {
        //   response = await carregaVendaNaoSalva(hostname);
        //   if (response.status == 200) {
        //     var jsonStr = await response.json();
        //     var venda = jsonStr.codVen != null ? jsonStr.codVen : 'vendapendente';
        //     if (jsonStr.devolucao) {
        //       window.location.href = "<?php echo BASE_URI; ?>/devolucao/" + venda;
        //     } else {
        //       window.location.href = "<?php echo BASE_URI; ?>/venda/" + venda;
        //     }
        //   }
        // }
      }

      $("#modal-vendedor").on('hidden.bs.modal', async function() {
        sessionStorage.setItem('g_caixa_logado', $("#txtCaixa").val());
      })

      async function carregaVendaNaoSalva(sNomeMaquina) {
        var response;
        var myHeaders = new Headers();
        myHeaders.append('pragma', 'no-cache');
        myHeaders.append('cache-control', 'no-cache');
        try {
          response = await fetch(`<?php echo BASE_URI; ?>/${sNomeMaquina}.txt`, {
            headers: myHeaders,
            method: 'GET',
            body: null,
          }, );
        } catch (error) {
          console.log(error);
          return;
        }
        return response;
      }

      function retornaBotaoOpcoes(mostraDuplicarVenda = false, nrVenda) {
        var retorno = '<div style="text-align:center;"> ' +
          '   <div class="dropdown"> ' +
          '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
          '      ' + nrVenda + ' ' +
          '    </button> ' +
          '    <div class="dropdown-menu dropDownVenda" style="z-index: 999999; max-height: 380px !important; min-heigth: 380px !important; overflow-y: scroll; scrollbar-color: var(--drop-down-theme);"> ' +
          '    <a id="btn-alterar-venda" class="dropdown-item" href="">Alterar</a>' +
          '    <a id="btn-cancelar-venda" class="dropdown-item" href="">Cancelar</a>' +
          '    <div class="dropdown-divider"></div>' +
          `    <a id="btn-imprimir-venda" class="dropdown-item" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Venda.FR3"' : '' } href="">Imprimir</a>` +
          `    <a id="btn-imprimir-carne" class="dropdown-item" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Carne.FR3"' : '' } href="">Imprimir Carnê</a>` +
          `    <a id="btn-imprimir-resumo" class="dropdown-item pr-0" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Venda_Resumo.FR3"' : '' } href="">Imprimir Resumo</a>` +
          '    <a id="btnImprimirFinalizacao" class="dropdown-item" href="">Imp. Finalização.</a>' +
          '    <div class="dropdown-divider"></div>' +
          `    <a id="btnFinalizarAtendimento" class="dropdown-item" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout Atendimento_Finalizado.FR3"' : '' } href="">Finalizar Atend.</a>` +
          '    <a id="btnReimpressaoTEF" class="dropdown-item" href="">Reimpressão TEF</a>' +
          '    <a id="btnCriarPedido" class="dropdown-item" href="">Criar Pedido</a>';

        if (!ocultaCupomTroca) {
          retorno += '<a id="btn-imp-cupom-troca" class="dropdown-item" href="">Cupom de Troca</a>'
        }

        if (mostraDuplicarVenda) {
          retorno += ' <a id="btn-duplicar-venda" class="dropdown-item btn-duplicar-venda" href="">Duplicar Venda</a>';
        }
        // if (bTipoUsuario) { 
        //   retorno += '<div class="dropdown-divider"></div>';
        //   retorno += '<a id="btn-alterar-vendedor" class="dropdown-item" href="">Alterar Vendedor</a>';
        // }
        if (bUsaNFCE != 0) {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-gerar-nfce" class="dropdown-item" href="">Gerar NFCe</a>';
        }
        if (bUsaNFE != 0) {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-gerar-nfe" class="dropdown-item" href="">Gerar NFe</a>';
        }
        if (bUsaCFE) {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-gerar-cfe" class="dropdown-item" href="">Gerar CFe</a>';
        }
        if (bUsaECF != 0) {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-imp-cupom" class="dropdown-item" href="">Cupom Fiscal</a>';
        }
        if (bUtilizaWhatsapp) {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-enviar-wpp" class="dropdown-item" href="">Enviar WhatsApp</a>';
        }
        if (bIntegracaoiShopp == '1') {
          retorno += '<div class="dropdown-divider"></div>';
          retorno += '<a id="btn-integrar-ishopp" class="dropdown-item" href="">Integrar iShopp</a>';
        }
        retorno += '</div>' +
          '  </div>' +
          '</div>';

        return retorno;
      }

      async function atualizaTotais(filtro) {
        try {
          const ID_COLUNA_VALOR = parametrosVenda[56] == '1' ? 8 : 7;
          const ID_COLUNA_QTDE_ITENS = parametrosVenda[56] == '1' ? 9 : 8;

          var val_total = $('#tabelaVendas').DataTable().column(ID_COLUNA_VALOR, {
            search: filtro
          }).data().sum();
          var total_venda = $('#tabelaVendas').DataTable().column(ID_COLUNA_VALOR, {
            search: filtro
          }).data().count();
          var total_itens = $('#tabelaVendas').DataTable().column(ID_COLUNA_QTDE_ITENS, {
            search: filtro
          }).data().sum();
        } catch (error) {
          val_total = 0;
          total_venda = 0;
          total_itens = 0;
        }

        // var val_total = 0;

        // for (let i = 0; i < $('#tabelaVendas').DataTable().data().length; i++) {
        //   const element = $('#tabelaVendas').DataTable().data()[i];
        //   if (element.FECHADA == 1){
        //     val_total += element.VALOR; 
        //   }
        // }
        const data = $('#tabelaVendas').DataTable().rows().data().toArray();

        data.forEach((current) => {
          // multiplica por 2, por já ter somado na variável lá em cima, mesmo quando era devolução/troca,
          // então tem que descontar o que somou lá e ainda subtrair a quantidade/valor das devoluções encontradas.
          if (current.STATUS === "DEVOLUCAO/TROCA") {
            total_venda = total_venda - 2;
            total_itens = total_itens - (current.QTDE_DEV * 2);
            val_total = ArredondarValor(val_total -= Number(current.VALOR * 2), 2);
          }
        });

        $("#txt_val_total").html(parseFloat(val_total).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));
        $("#txt_total_vendas").html(total_venda < 0 ? 0 : total_venda);
        $("#txt_total_itens").html(parseFloat(total_itens).toLocaleString('pt-BR', {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2
        }));
      }

      async function liberarVenda(iCodVen) {
        try {
          $.LoadingOverlay("show");
          var response = await requisicao('POST', '/sisplan/controleedicao/v1/controleedicao?', `valor=${iCodVen}&tela=LOJA`, null);

          if (!response) {
            $.LoadingOverlay("hide");
            return false;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgAlerta(jsonStr.mensagem);
            return false;
          } else {
            $.LoadingOverlay("hide");
            return true;
          }
        } catch (error) {
          console.error(error);
          $.LoadingOverlay("hide");
          msgErro('Não foi possível alterar a venda: ' + error)
        }
      };

      async function retornaVendaConvertidaEmCupom(sVenda) {
        var _url = '/sisplan/Cupom/v1/Cupom?';
        try {
          const NrSerie = getCookie('serie_ecf');
          var response = await requisicao('POST', _url, `VENDA=${sVenda}&NRSERIE=${NrSerie}`, null);

          if (!response) {
            return;
          }

          var jsonStr = await response.json()
          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
          }

          return jsonStr;
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível buscar os dados do produto.');
        }
      }

      async function buscaVendas() {
        try {
          let dataSet = [];
          let dataSetCols = [];
          let separador = "' - '";
          let verdadeiro = "'S'";
          let sDataIni = "'" + $('#txtDataDe').val() + "'";
          let sDataFim = "'" + $('#txtDataAte').val() + "'";
          let empresa = getCookie('empresa');
          const emitido = $('#cbEmitido').prop('checked');
          const devolvido = $('#cbDevolvido').prop('checked');
          const pendente = $('#cbPendente').prop('checked');
          const agrupada = $('#cbAgrupada').prop('checked');
          var sCliente = pegaChave('#txtCliente', sCliente);
          var sCaixa = pegaChave('#txtCaixaFiltro', sCaixa);
          var sVendedor = pegaChave('#txtVendedorFiltro', sVendedor);
          const codSeqDia = $('#txtCodSeq').val();
          var sVenda = pegaChave('#txtVenda', sVenda);
          let sNrcupom = pegaChave('#txtCupom');
          let sNFCe = pegaChave('#txtNFCe');
          let sNFe = pegaChave('#txtNFe');
          var sTipoVenda = pegaChave('#txtTipoVendaFiltro', sTipoVenda);
          let sParams = '';
          let iEmpID = getCookie('emp_id');
          const semNFe = $('#cbSemNFCE').prop('checked');
          const semNFCe = $('#cbSemNFCE').prop('checked');

          if (sCliente != '') {
            sParams += " AND VENDA.CODCLI = '" + sCliente + "'";
          }
          if (sVendedor != '') {
            sParams += " AND VENDA.CODREP = '" + sVendedor + "'";
          }
          if (sCaixa != '') {
            sParams += " AND VENDA.NRCAIXA = '" + sCaixa + "'";
          }
          if (sVenda != '') {
            sParams += " AND VENDA.CODVEN = " + sVenda;
          }
          if (sTipoVenda != '') {
            sParams += " AND VENDA.TIPO_VENDA = " + sTipoVenda;
          }
          if (codSeqDia != '') {
            sParams += " AND VENDA.SEQ_DIA = " + codSeqDia;
          }
          if ($('#txtNFCe').val() != '') {
            sParams += ` AND VENDA.CODVEN IN (SELECT CODVEN FROM [NOTA_NFCE] WHERE FATURA = '${sNFCe}') AND VENDA.CODVEN IN (SELECT CODVEN FROM [NOTA_NFCE] WHERE FATURA = '${sNFCe}' AND CODVEN = VENDA.CODVEN) `

          }
          if ($('#txtNFe').val() != '') {
            sParams += ` AND VENDA.CODVEN IN (SELECT CODVEN FROM [NOTA] WHERE FATURA = '${sNFe}') AND VENDA.CODVEN IN (SELECT CODVEN FROM [NOTA] WHERE FATURA = '${sNFe}' AND CODVEN = VENDA.CODVEN) `
          }
          if ($('#txtCupom').val() != '') {
            sParams += ` AND VENDA.NRCUPOM = '${sNrcupom}'`
          }

          if (semNFe) {
            sParams += `AND NOT EXISTS (SELECT CODVEN FROM [NOTA] NOTA WHERE NOTA.CODVEN = VENDA.CODVEN) `;
          }

          if (semNFCe) {
            sParams += `AND NOT EXISTS (SELECT CODVEN FROM [NOTA_NFCE] NOTA_NFCE WHERE NOTA_NFCE.CODVEN = VENDA.CODVEN) `;
          }


          sParams += " AND VENDA.EMP_ID = " + iEmpID;
          const canceladas = $('#checkCanceladas').prop('checked') ? '1' : '0';
          const todos = canceladas == '1' && emitido && devolvido && pendente && agrupada || canceladas == '0' && !emitido && !devolvido && !pendente && !agrupada;
          var opcao = '';
          let whereStatus = `AND ( `;
          if (emitido) {
            if (agrupada) {
              whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1))`;
            } else {
              whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S'))`;
            }
          }
          if (devolvido) {
            if (whereStatus != `AND ( `) {
              whereStatus += ' OR ';
            }
            whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND (((VENDA.TROCA = 1) OR (VENDA.DEVOLUCAO = 1)) AND VENDA.ORCAMENTO = 0))`;
          }
          if (pendente) {
            if (whereStatus != `AND ( `) {
              whereStatus += ' OR ';
            }
            whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0)`;
          }

          if (canceladas == 1) {
            if (whereStatus != `AND ( `) {
              whereStatus += ' OR ';
            }
            whereStatus += `((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S') OR (((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO = 'S') AND VENDA.TIPO_VENDA = 1)))`;
          }
          if (agrupada) {
            if (whereStatus != `AND ( `) {
              whereStatus += ' OR ';
            }
            if (canceladas == 0) {
              whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND VENDA.TIPO_VENDA = 1 AND ((SELECT CANCELADA FROM [VENDA] WHERE CODVEN = VENDA.CDAGRUPADA) = 0))`
            } else {
              whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND VENDA.TIPO_VENDA = 1)`;
            }

          }
          whereStatus += ') ';

          if (todos) {
            whereStatus = '';
          }

          if (whereStatus != 'AND ( ) ') {
            opcao = whereStatus;
          }

          const pesquisaVendas = {
            camposSelect: [],

            tabela: "venda",
            leftjoin: [{
                tabela: "entidade",
                condicao: "entidade.codcli = venda.codcli"
              },
              {
                tabela: "itvenda",
                condicao: "itvenda.codven = venda.codven and itvenda.emp_id = venda.emp_id"
              },
              {
                tabela: "venda_tipo",
                condicao: "venda.tipo_venda = venda_tipo.id"
              }
            ],
            groupby: [],
            orderby: ["venda.codven desc"],
            where: []
          }


          if (parametrosVenda[56] == '1') {
            pesquisaVendas.camposSelect.push('venda.seq_dia COD_SEQ');
            pesquisaVendas.groupby.push('venda.seq_dia');
          }

          pesquisaVendas.groupby = pesquisaVendas.groupby.concat([
            "venda.codven",
            "venda.codcli",
            "entidade.nome",
            "venda.fechada",
            "venda.consig_finalizado",
            "venda_tipo.descricao",
            "venda.nrcaixa",
            "venda.data",
            "venda.hr_venda",
            "venda.valor",
            "venda.fechada",
            "venda.cancelada",
            "venda.troca",
            "venda.emp_id",
            "venda.devolucao",
            "venda.orcamento",
            "venda.impresso",
            "VENDA.TIPO_VENDA",
            "venda.CDAGRUPADA",
            "VENDA.AGRUPADA",
            "VENDA.DEVOLUCAO"
          ]);

          // pesquisaVendas.camposSelect = pesquisaVendas.camposSelect.concat([
          //   "venda.codven venda",
          //   `venda.codcli %2B ${separador} %2B entidade.nome cliente`,

          pesquisaVendas.camposSelect = pesquisaVendas.camposSelect.concat([
            "venda.codven venda",
            `venda.codcli|| ${separador}||entidade.nome cliente`,
            // `VENDA.CODCLI || ' - "'  || ENTIDADE.NOME || '"' AS CLIENTE, ` +
            `CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'Pendente'` +
            `WHEN ((SELECT CANCELADA FROM VENDA_001 V1 WHERE V1.CODVEN = VENDA.CDAGRUPADA AND V1.EMP_ID=VENDA.EMP_ID) = 1 ) THEN 'CANCELADA'` +
            `WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND VENDA.TIPO_VENDA = 1) THEN 'AGRUPADA'` +
            `WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'` +
            `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'Fechada'` +
            `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'Devolucao/Troca'` +
            `ELSE 'Orcamento' END status`,
            "venda_tipo.descricao as TIPO_VENDA",
            "venda.nrcaixa", "venda.data",
            "venda.hr_venda", "venda.valor",
            "sum(itvenda.quantidade) qtde_itens",
            "(select SUM(ITV_DEV.QUANTIDADE) itens from [itvenda] itv_dev where itv_dev.codven = venda.codven and itv_dev.emp_id = venda.emp_id and itv_dev.troca='S') qtde_dev",
            "venda.fechada",
            "venda.CDAGRUPADA",
            "VENDA.DEVOLUCAO"
          ]);

          if ($('#menu_fiscal').css('display') != 'none') {
            pesquisaVendas.camposSelect.push('venda.nrcupom');
            pesquisaVendas.groupby.push('venda.nrcupom');
            $('#d_cf').removeClass('d-none')
          }

          if (parametrosVenda[6] != '0') {
            pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [NOTA_NFCE] NOTA_NFCE WHERE NOTA_NFCE.CODVEN = VENDA.CODVEN) FATURA_NFCE');
            $('#d_nfce').removeClass('d-none')
            // $('#d_cf').addClass('d-none')
          }

          if (parametrosVenda[18] != '0') {
            pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [CFE] cfe where cfe.codven = venda.codven) FATURA_CFE');
          }

          if (parametrosVenda[20] != '0') {
            pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [NOTA] nota where nota.codven = venda.codven) FATURA_NFE');
            $('#d_nfe').removeClass('d-none')
          }

          if (sVenda !== '') {
            pesquisaVendas.where.push(`venda.codven = ${sVenda} and venda.emp_id = ${iEmpID}`);
          } else {
            pesquisaVendas.where.push(`(data >= ${sDataIni} and data <= ${sDataFim}) ${opcao} ${sParams}`);
          }

          if (!agrupada && !todos) {
            pesquisaVendas.where.push(`((VENDA.AGRUPADA IS NULL OR VENDA.AGRUPADA = '' OR VENDA.AGRUPADA = 'N') OR (VENDA.TIPO_VENDA = 2))`);
          }

          const _url = `/sisplan/funcoes/v1/pesquisa?empresa=${empresa}&JSON=${JSON.stringify(pesquisaVendas)}`;
          const response = await requisicao('GET', '', _url, '', 300000);

          const result = await response.json();
          if (response.status != 200) {
            msgErro(result['RESULT'][0].mensagem)
            return
          }

          if (result.RESULT[0].length == '0') {
            if ($('#tabelaVendas tr>td:not(".dataTables_empty")').length === 0) {
              $('#tabelaVendas').DataTable({
                destroy: true,
                sort: true,
                order: [],
                colReorder: true,
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
              });
            }
            $('#tabelaVendas').DataTable().clear().draw(false);
            atualizaTotais('none');
            return;
          }

          if (result['RESULT'][0]) {
            if (!result['RESULT'][0]) {
              dataSet.push(result['RESULT'][0]);
            } else {
              dataSet = result['RESULT'][0];
            }

            const ID_COLUNA_VENDA = parametrosVenda[56] == '1' ? 1 : 0;
            const ID_COLUNA_STATUS = parametrosVenda[56] == '1' ? 3 : 2;
            const ID_COLUNA_DATA = parametrosVenda[56] == '1' ? 6 : 5;
            const ID_COLUNA_HORA = parametrosVenda[56] == '1' ? 7 : 6;
            const ID_COLUNA_VALOR = parametrosVenda[56] == '1' ? 8 : 7;
            const ID_COLUNA_FECHADA = parametrosVenda[56] == '1' ? 11 : 10;
            const ID_COLUNA_QTDE_ITENS = parametrosVenda[56] == '1' ? [9, 10] : [8, 9];

            //se chegar aqui deu tudo certo
            if (!$.isEmptyObject(dataSet[0])) {
              // preciso dinamicamente ter a relação com o nome das colunas para tabela

              var keys = Object.keys(dataSet[0]);
              for (var k in keys) {
                dataSetCols.push({
                  'title': keys[k],
                  'data': keys[k],
                });
              }

              dataSetCols[ID_COLUNA_STATUS].render = function(data, type, row) {
                if (row["STATUS"] == 'PENDENTE') {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-green mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                } else if (row["STATUS"].toUpperCase() == 'AGRUPADA') {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-purple mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                } else if (row["STATUS"].toUpperCase() == 'CANCELADA') {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-red mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                } else if (row["STATUS"].toUpperCase() == 'FECHADA') {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-blue mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                } else if (row["STATUS"].toUpperCase() == 'DEVOLUCAO/TROCA') {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-yellow mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                } else {
                  return '<div class="d-flex mr-3"><i class="fas fa-circle text-grey mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
                }
              }

              dataSetCols[ID_COLUNA_VENDA].render = function(data, type, row) {
                return retornaBotaoOpcoes(row.STATUS != 'PENDENTE', row.VENDA);
              }

              // dataSetCols[ID_COLUNA_DATA].type = 'date-br';
              dataSetCols[ID_COLUNA_DATA].render = function(data, type, row) {
                var isIE = function() {
                  if (/MSIE/i ['test'](navigator['userAgent']) == true || /Edge/i ['test'](navigator[
                      'userAgent']) == true) {
                    return true;
                  } else {
                    return false;
                  }
                }
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
                } else {
                  x = data.slice(0, 10).split('-');
                  return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
                  return $.datepicker.formatDate("dd/mm/Y", new Date(data)) + row['HR_VENDA'].slice('10');
                }
              }
              $('#colunas').html('');
              dataSetCols.map((coluna) => {
                $('#colunas').append(`<th>${coluna.title}</th>`)
              });
              $('#tabelaVendas').DataTable({
                autoWidth: false,
                destroy: true,
                colReorder: true,
                order: [],
                filter: false,
                sort: true,
                "scrollCollapse": true,
                "columnDefs": [{
                    "render": function(data) {
                      return parseFloat(data).toLocaleString('pt-br', {
                        style: 'currency',
                        currency: 'BRL'
                      });
                    },
                    "targets": ID_COLUNA_HORA,
                  },
                  {
                    "render": function(data) {
                      return parseFloat(data).toLocaleString('pt-BR', {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 2
                      })
                    },
                    "targets": ID_COLUNA_VALOR,
                    "className": 'pr-4 text-right'
                  },
                  {
                    "targets": ID_COLUNA_QTDE_ITENS,
                    "className": 'pr-4 text-right'
                  }
                ],
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                },
                "data": dataSet,
                "columns": dataSetCols,
              });

              atualizaTotais('none');
            } else {
              $('#tabelaVendas').DataTable({
                autoWidth: false,
                colReorder: true,
                destroy: true,
                order: [],
                filter: false,
                sort: true,
                "scrollCollapse": true,
                "columnDefs": [{
                    "render": function(data) {
                      return parseFloat(data).toLocaleString('pt-BR', {
                        maximumFractionDigits: 2,
                        minimumFractionDigits: 2
                      })
                    },
                    "targets": ID_COLUNA_VALOR,
                    "className": 'pr-4 text-right'
                  },
                  {
                    "targets": ID_COLUNA_QTDE_ITENS,
                    "className": 'pr-4 text-right'
                  }
                ],
                "language": {
                  "sEmptyTable": "Nenhum registro encontrado",
                  "sInfo": "_TOTAL_ registros",
                  "sInfoEmpty": " 0 registros",
                  "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                  "sInfoPostFix": "",
                  "sInfoThousands": ".",
                  "sLengthMenu": "_MENU_ resultados",
                  "sLoadingRecords": "Carregando...",
                  "sProcessing": "Processando...",
                  "sZeroRecords": "Nenhum registro encontrado",
                  "sSearch": "Pesquisar (geral): ",
                  "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                  },
                  "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                  }
                }
              });
              atualizaTotais('none');
            }
            if ($('#tabelaVendas').DataTable().rows().count() < 6) {
              $('#tabelaVendas').css('min-height', '350px');
            }
            $.LoadingOverlay("hide");
          } else {
            atualizaTotais('none');
            $.LoadingOverlay("hide");
          }

          const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

          // adiciona o botão na tabela e adiciona a função de abrir o modal
          $('#tabelaVendas_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
          $('#tabelaVendas_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
          $('#buttonExcel').prop('title', 'Exportar')

          $('#buttonColVis').on('click', async function() {
            $.LoadingOverlay('show');
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          });

          $('#buttonExcel').on('click', async function() {

            const pesquisaVendas = {
              camposSelect: [],

              tabela: "venda",
              leftjoin: [{
                  tabela: "entidade",
                  condicao: "entidade.codcli = venda.codcli"
                },
                {
                  tabela: "itvenda",
                  condicao: "itvenda.codven = venda.codven and itvenda.emp_id = venda.emp_id"
                },
                {
                  tabela: "venda_tipo",
                  condicao: "venda.tipo_venda = venda_tipo.id"
                }
              ],
              groupby: [],
              orderby: listaOrdenacao,
              where: []
            }


            if (parametrosVenda[56] == '1') {
              pesquisaVendas.camposSelect.push('venda.seq_dia COD_SEQ');
              pesquisaVendas.groupby.push('venda.seq_dia');
            }

            pesquisaVendas.groupby = pesquisaVendas.groupby.concat([
              "venda.codven",
              "venda.codcli",
              "entidade.nome",
              "venda.fechada",
              "venda.consig_finalizado",
              "venda_tipo.descricao",
              "venda.nrcaixa",
              "venda.data",
              "venda.hr_venda",
              "venda.valor",
              "venda.fechada",
              "venda.cancelada",
              "venda.troca",
              "venda.emp_id",
              "venda.devolucao",
              "venda.orcamento",
              "venda.impresso",
              "VENDA.TIPO_VENDA",
              "venda.CDAGRUPADA",
              "VENDA.AGRUPADA",
              "VENDA.DEVOLUCAO"
            ]);

            pesquisaVendas.camposSelect = pesquisaVendas.camposSelect.concat([
              "venda.codven venda",
              `venda.codcli|| ${separador}||entidade.nome cliente`,
              `CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'Pendente'` +
              `WHEN ((SELECT CANCELADA FROM VENDA_001 V1 WHERE V1.CODVEN = VENDA.CDAGRUPADA AND V1.EMP_ID=VENDA.EMP_ID) = 1 ) THEN 'CANCELADA'` +
              `WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND VENDA.TIPO_VENDA = 1) THEN 'AGRUPADA'` +
              `WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'` +
              `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'Fechada'` +
              `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'Devolucao/Troca'` +
              `ELSE 'Orcamento' END status`,
              "venda_tipo.descricao as TIPO_VENDA",
              "venda.nrcaixa", "venda.data",
              "venda.hr_venda", "venda.valor",
              "sum(itvenda.quantidade) qtde_itens",
              "(select SUM(ITV_DEV.QUANTIDADE) itens from [itvenda] itv_dev where itv_dev.codven = venda.codven and itv_dev.emp_id = venda.emp_id and itv_dev.troca='S') qtde_dev",
              "venda.fechada",
              "venda.CDAGRUPADA",
              "VENDA.DEVOLUCAO"
            ]);

            if ($('#menu_fiscal').css('display') != 'none') {
              pesquisaVendas.camposSelect.push('venda.nrcupom');
              pesquisaVendas.groupby.push('venda.nrcupom');
              $('#d_cf').removeClass('d-none')
            }

            if (parametrosVenda[6] != '0') {
              pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [NOTA_NFCE] NOTA_NFCE WHERE NOTA_NFCE.CODVEN = VENDA.CODVEN) FATURA_NFCE');
              $('#d_nfce').removeClass('d-none')
              // $('#d_cf').addClass('d-none')
            }

            if (parametrosVenda[18] != '0') {
              pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [CFE] cfe where cfe.codven = venda.codven) FATURA_CFE');
            }

            if (parametrosVenda[20] != '0') {
              pesquisaVendas.camposSelect.push('(SELECT MAX(FATURA) FATURA FROM [NOTA] nota where nota.codven = venda.codven) FATURA_NFE');
              $('#d_nfe').removeClass('d-none')
            }

            if (sVenda !== '') {
              pesquisaVendas.where.push(`venda.codven = ${sVenda} and venda.emp_id = ${iEmpID}`);
            } else {
              pesquisaVendas.where.push(`(data >= ${sDataIni} and data <= ${sDataFim}) ${opcao} ${sParams}`);
            }

            if (!agrupada && !todos) {
              pesquisaVendas.where.push(`((VENDA.AGRUPADA IS NULL OR VENDA.AGRUPADA = '' OR VENDA.AGRUPADA = 'N') OR (VENDA.TIPO_VENDA = 2))`);
            }

            const url = `/sisplan/funcoes/v1/pesquisa?empresa=${empresa}&JSON=${JSON.stringify(pesquisaVendas)}`;

            await exportaCSV('', url, true, null, 'Vendas', '#tabelaVendas');
          })

          $('#tabelaVendas').DataTable().columns().every(
            function() {
              if ((colunasInvisiveis.acessoVenda).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
              }
            });

          $('#tabelaVendas th').on('click', function() {
            listaOrdenacao = adicionaOrdenacao(
              retornaDataSrcColuna($('#tabelaVendas'), $(this)),
              listaOrdenacao
            );
          });
          var tabelaVenda = $('#tabelaVendas').DataTable();
          tabelaVenda.on('draw.dt', function() {
            const info = tabelaVenda.page.info();
            const paginaAtual = info.page + 1;

            if (paginaAtual === info.pages) {
              if ((info.end - info.start) < 10) {
                $('.dropDownVenda').each((i, t) => {
                  $($('.dropDownVenda')[i]).addClass('dropVenda');
                });
              }
            }
          });


        } catch (error) {
          console.error(error);
          atualizaTotais('none');
          $.LoadingOverlay("hide");
        }
      }

      $('#modal-ColunasVisiveis').on('show.bs.modal', function() {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaVendas').DataTable().columns().every(function() {
          cols.push({
            'title': $(this.header()).text(),
            'data': this.dataSrc()
          })
        });

        adicionaColunas(cols.filter(e => e.data != 'HR_VENDA' && e.data != 'FECHADA' && e.data != 'VENDA'), colunasInvisiveis.acessoVenda ?? ['HR_VENDA', 'FECHADA'])
      })

      async function validaSeVendaJaEstaFaturada(codven) {
        try {
          const pesquisa = {
            camposSelect: ['VENDA_TIPO.FECHA_VENDA',
              `(SELECT MAX(FATURA) FATURA ` +
              ` FROM [NOTA] NOTA1 ` +
              ` WHERE NOTA1.CODVEN = VENDA.CODVEN` +
              ` AND NOTA1.EMP_ID= VENDA.EMP_ID` +
              ` AND NOTA1.IMPRESSO <> 'C' ` +
              ` AND (NOT EXISTS (SELECT NOTA_REF FROM [NOTA] NOTA WHERE NOTA.NOTA_REF = NOTA1.CHAVE_NFE AND NOTA.NOTA_REF <> ''))` +
              `) FATURA_NFE`
            ],
            tabela: 'VENDA',
            leftJoin: [{
              tabela: 'VENDA_TIPO',
              condicao: 'VENDA_TIPO.ID = VENDA.TIPO_VENDA'
            }],
            where: [`VENDA.CODVEN = ${codven} AND VENDA.EMP_ID = ${getCookie('emp_id')}`]
          }
          const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (!response) {
            return;
          }
          const vendaFaturada = ((response[0].FECHA_VENDA != 'S') && (response[0].FATURA_NFE != ''));
          return vendaFaturada;
        } catch (error) {
          console.error(error);
        }
      }

      //alteracao de venda
      $('#tabelaVendas').on('click', '#btn-alterar-venda', async function() {
        event.preventDefault();
        setCookie("idMaquina", gerarGuid(), 365);
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        const vendaJaEstaFaturada = await validaSeVendaJaEstaFaturada(data.VENDA);
        if (vendaJaEstaFaturada) {
          msgAlerta('Venda já está faturada, impossível alterar.');
          return;
        }
        if (((data.FECHADA == 1) || (data.STATUS == 'FECHADA')) || (data.STATUS == 'CANCELADA') || (data.STATUS == 'DEVOLUCAO/TROCA') || (data.STATUS == 'AGRUPADA')) {
          msgAlerta('Impossível alterar venda fechada, cancelada ou devolução.');
          return;
        }
        var vendaLiberada = await liberarVenda(data.VENDA);
        if (vendaLiberada) {
          // window.location.href = "venda/" + data.VENDA;
          parent.abrirEmNovaAbaIFrame('Venda', `<?php echo BASE_URI; ?>/venda/${data.VENDA}`);
        }
      });

      $('#btn_confirmar_alterarVendedor').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          try {
            const url = '/sisplan/vendas/v1/alteravendedor?';
            const vendedor = pegaChave('#txtAlterarVendedor');
            const codVenda = $('#txtVendaVendedor').val();

            if (vendedor == '') {
              msgAlerta('Vendedor não informado');
              return;
            }
            if (codVenda == '') {
              msgAlerta('Código da venda não informado');
              return;
            }

            const response = await requisicao('POST', url, `CODVEN=${codVenda}&NOVOVENDEDOR=${vendedor}&CODUSUARIO=${getCookie('cod_usuario')}`, '', 15000);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.mensagem)
              return;
            }

            toastr.success(
              'Vendedor Alterado com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: async () => {
                  $('#txtAlterarVendedor').val('');
                  $('#txtVendaVendedor').val('');
                  $('#modalAlterarVendedor').modal('hide');
                  await buscaVendas();
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });

          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#tabelaVendas').on('click', '#btn-alterar-vendedor', async function() {
        event.preventDefault();
        const data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        try {
          if (data.FECHADA == 1 || data.DEVOLUCAO == 1) {
            $('#txtVendaVendedor').val(data.VENDA);
            $('#modalAlterarVendedor').modal('show');
          } else {
            msgAlerta('Venda deve estar fechada para mudar o vendendor.');
            return;
          }

        } catch (error) {
          console.log(error);
        }
      });

      $('#tabelaVendas').on('click', '#btn-gerar-nfce', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        if (data.FECHADA == 1) {
          const paramOperacaoFiscal = await CopiaParametro('VENDA', 57);
          const paramNatureza = await CopiaParametro('VENDA', 7);
          insereValor('#txtNaturezaNFCE', paramNatureza);
          insereValor('#txtOperacaoNfce', paramOperacaoFiscal)
          var sCodCli = data.CLIENTE.substr(0, data.CLIENTE.indexOf('-') - 1);
          const nomeCliente = data.CLIENTE.substring(data.CLIENTE.indexOf('-')+2);
          var sCNPJ = await RetornaCNPJ(sCodCli);
          $('#txtCpfNFCE').val(sCNPJ);
          $('#txtCodVen').val(data.VENDA);
          insereValor("#txtClienteNFCE", sCodCli, nomeCliente);
          $('#modal-nfce').modal('show');
        } else {
          msgAlerta('Venda deve estar fechada para gerar NFC-e.');
          return;
        }
        if (bNaoUsaNRCupom == true) {
          data.NRCUPOM = '';
        }
        if (bUsaNFCE == 0) {
          data.FATURA_NFCE = '';
        }
        if (bUsaCFE == 0) {
          data.FATURA_CFE = '';
        }
        if (bUsaNFE == 0) {
          data.FATURA_NFE = '';
        }
        if (data.FATURA_NFE != '' || data.FATURA_NFCE != '' || data.FATURA_CFE != '' || data.NRCUPOM != '') {
          await msgAlerta('Já existe documento fiscal para essa venda, deseja continuar?', () => {}, () => {
            $('#modal-nfce').modal('hide')
          }, () => {});
        }
      });

      $('#tabelaVendas').on('click', '#btn-gerar-nfe', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();

        $('#btn-NaturezaNFE').unbind();
        if (data.STATUS == 'DEVOLUCAO/TROCA') {
          $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '2'"] }`);
          $('#btn-NaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '2'"]}`, 'Pesquisa Natureza', 'natureza');
        } else {
          $('#txtNaturezaNFE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
          $('#btn-NaturezaNFE').pesquisa('#txtNaturezaNFE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
        }

        if ((data.TIPO_VENDA == 'CONSIGNADO') || (data.FECHADA == 1) || (data.STATUS == 'DEVOLUCAO/TROCA')) {
          const parametroOperacaoPadrao = await CopiaParametro('VENDA', 47);
          var sCodCli = data.CLIENTE.substr(0, data.CLIENTE.indexOf('-') - 1);
          let clienteNfe = data.CLIENTE.split(' - ');
          $('#txtCodVen').val(data.VENDA);
          insereValor('#txtClienteNFE', clienteNfe[0], clienteNfe[1]);
          if (parametroOperacaoPadrao != '') {
            $('#txtOperacaoNota').val(parametroOperacaoPadrao);
            if (data.STATUS == 'DEVOLUCAO/TROCA') {
              $('#txtOperacaoNota').val(await CopiaParametro('VENDA', 53));
            }
          }
          $('#modalNFE').modal('show');
        } else {
          msgAlerta('Venda deve estar fechada para gerar NF-e.');
          return;
        }
        if (bNaoUsaNRCupom == true) {
          data.NRCUPOM = '';
        }
        if (bUsaNFCE == 0) {
          data.FATURA_NFCE = '';
        }
        if (bUsaCFE == 0) {
          data.FATURA_CFE = '';
        }
        if (bUsaNFE == 0) {
          data.FATURA_NFE = '';
        }
        if (data.FATURA_NFE != '' || data.FATURA_NFCE != '' || data.FATURA_CFE != '' || data.NRCUPOM != '') {
          await msgAlerta('Já existe documento fiscal para essa venda, deseja continuar?', () => {}, () => {
            $('#modalNFE').modal('hide')
          }, () => {});
        }
      });

      $('#modalNFE').on('hidden.bs.modal', function() {
        $('#txtOperacaoNota').val('');
      });


      $('#tabelaVendas').on('click', '#btn-gerar-cfe', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        if ((data.FECHADA == 1) || (data.STATUS == 'DEVOLUCAO/TROCA')) {
          const paramNatureza = parametrosVenda[19];
          const paramOperacao = parametrosVenda[67];
          const cliente = data.CLIENTE.substr(0, data.CLIENTE.indexOf('-') - 1);
          const cpfCnpj = await RetornaCNPJ(cliente);
          $('#txtNaturezaCFe').val(paramNatureza);
          $('#txtOperacaoCFe').val(paramOperacao);
          $('#txtCpfCFe').val(cpfCnpj);
          $('#modalCFe').modal('show');
          $('#btn_confirmar_cfe').off();
          $('#btn_confirmar_cfe').on('click', async function() {
            await rotinaCliqueConfirmarCFE(false, cliente, data.VENDA);
          });
        } else {
          msgAlerta('Venda deve estar fechada para gerar CF-e.');
          return;
        }
        if (bNaoUsaNRCupom == true) {
          data.NRCUPOM = '';
        }
        if (bUsaNFCE == 0) {
          data.FATURA_NFCE = '';
        }
        if (bUsaCFE == 0) {
          data.FATURA_CFE = '';
        }
        if (bUsaNFE == 0) {
          data.FATURA_NFE = '';
        }
        if (data.FATURA_NFE != '' || data.FATURA_NFCE != '' || data.FATURA_CFE != '' || data.NRCUPOM != '') {
          await msgAlerta('Já existe documento fiscal para essa venda, deseja continuar?', () => {}, () => {
            $('#modalCFe').modal('hide')
          }, () => {});
        }
      });

      $('#btn_confirmar_nfe').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          const operacao = pegaChave('#txtOperacaoNota');
          let validacao = ''
          if (operacao != '') {
            validacao = $('#txtClienteNFE').val() != ''
          } else {
            validacao = $('#txtNaturezaNFE').val() != '' && $('#txtClienteNFE').val() != ''
          }
          if (validacao) {
            const nota = {};
            nota.NATUREZA = $('#txtNaturezaNFE').val();
            nota.CLIENTE = $('#txtClienteNFE').val();
            nota.CODVEN = $('#txtCodVen').val();
            nota.OPERACAO = $('#txtOperacaoNota').val();

            const jsonNota = JSON.stringify(nota);

            // window.location.href = `<?php echo BASE_URI; ?>/faturamento/${criptografaUrl(jsonNota)}`;

            if (parent && parent.abrirEmNovaAbaIFrame) {
              parent.abrirEmNovaAbaIFrame('Faturamento Geral', `<?php echo BASE_URI; ?>/faturamento`, `/${criptografaUrl(jsonNota)}`);
              parent.removerTelaCheia();

              let iframe = parent.document.querySelector('#panel--sisplan_web-loja iframe');
              let src = iframe.getAttribute("src");
              iframe.setAttribute("src", src);
            } else {
              console.error("A função do pai não está definida ou não pode ser acessada.");
            }

          } else {
            msgAlerta('Favor preencher os campos para continuar.')
          }

        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#tabelaVendas').on('click', '#btn-imp-cupom', async function() {
        event.preventDefault();
        try {
          var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
          if (data.FECHADA == 1) {
            if (bNaoUsaNRCupom == true) {
              data.NRCUPOM = '';
            }
            if (bUsaNFCE == 0) {
              data.FATURA_NFCE = '';
            }
            if (bUsaCFE == 0) {
              data.FATURA_CFE = '';
            }
            if (bUsaNFE == 0) {
              data.FATURA_NFE = '';
            }
            if (data.NRCUPOM != '' || data.FATURA_CFE != '' || data.FATURA_NFE != '' || data.FATURA_NFCE != '') {
              msgAlerta('Venda já possui Documento Fiscal vinculado, impossível continuar.');
              return;
            }
            $.LoadingOverlay("show");
            var jsonCupom = await retornaVendaConvertidaEmCupom(data.VENDA);
            if (['Requer Z', 'Bloqueada'].includes($('#txtEstadoECF').html())) {
              msgErro('Impressora fiscal bloqueada ou com Redução Z pendente, verifique.');
              return false;
            }
            await ImprimirCupomGerencial(jsonCupom.codVenda, jsonCupom.nrCupom);
            if (await ImprimirCupomFiscal(JSON.stringify(jsonCupom), jsonCupom)) {
              await toastr.success(
                'Cupom Impresso com sucesso!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: async function() {
                    $.LoadingOverlay("hide");
                    buscaVendas();
                  }
                }
              ).css({
                "margin-top": "50%",
                "width": "500px",
                "max-width": "500px"
              });
            } else {
              await toastr.error(
                'Erro ao imprimir Cupom: ' + getCookie('erro_impressao_cupom'),
                'Erro', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: async function() {
                    $.LoadingOverlay("hide");
                  }
                }
              ).css({
                "margin-top": "0%",
                "width": "500px",
                "max-width": "500px"
              });
            }

            //montar o json do cupom e enviar na rotina ImprimirCupomFiscal....
          } else {
            msgAlerta('Venda deve estar fechada para imprimir Cupom Fiscal.');
            return;
          }
        } finally {
          $.LoadingOverlay("hide");
        }
        f
      });

      $('#tabelaVendas').on('click', '#btn-imp-cupom-troca', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        await abreCupomTroca();
        insereValor('#venda-cupom-troca', data.VENDA, data.VENDA);
        $('#venda-cupom-troca').attr('disabled', true);
        $('#btn-venda-cupom-troca').attr('disabled', true);
        $('#btn-limpa-venda-cupom-troca').attr('disabled', true);
        await buscaItensCupomTroca(data.VENDA);
      });

      $('#tabelaVendas').on('click', '#btn-enviar-wpp', async function() {
        event.preventDefault();
        try {
          $.LoadingOverlay("show");
          const data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
          const cliente = data.CLIENTE;
          const valor = data.VALOR;
          const bDevolucao = data.STATUS == "DEVOLUCAO/TROCA";

          if (cliente.indexOf('CONSUMIDOR FINAL') >= 0) {
            msgAlerta('Não é possível enviar WhatsApp para Consumidor Final.');
            return;
          }

          const codcli = cliente.substr(0, cliente.indexOf('-') - 1);
          const nome = cliente.split('-')[1].trim();
          const numero = await getWhatsapp(codcli);
          if (numero == '') {
            msgAlerta('Número de telefone do cliente inválido, verifique o cadastro.');
            return;
          }
          await enviarRomaneioWpp(data.VENDA, numero, nome, valor, "<?php echo BASE_URI; ?>", bDevolucao ? "DEVOLUCAO" : "VENDA");
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#tabelaVendas').on('click', '#btn-integrar-ishopp', async function() {
        event.preventDefault();
        try {
          $.LoadingOverlay("show");
          const data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
          const empId = getCookie('emp_id');
          const pesquisa = {
            camposSelect: ['VENDA.NR_INTEGRACAO'],
            tabela: 'VENDA',
            where: [`VENDA.CODVEN = '${data.VENDA}' AND VENDA.EMP_ID = ${empId}`]
          }
          const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

          if (jsonStr[0].NR_INTEGRACAO != '') {
            msgAlerta(`Venda: ${data.VENDA} já integrada com Shopping. Número Integração: ${jsonStr[0].NR_INTEGRACAO}`);
            return;
          }

          await geraVendaIShopp(data.VENDA);
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      async function retornaInfoEmpresa() {
        try {
          let url = `/sisplan/funcoes/v1/pesquisa?`;
          let response = await requisicao('GET', url, `JSON={ 
        "tabela":"empresa", 
        "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert"], 
        "where": ["emp_id = ${getCookie('emp_id')}"] 
      }`, null);
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }
          return jsonStr.RESULT[0][0];
        } catch (error) {
          console.error(error);
          msgErro('Erro ao retornar dados da empresa, Erro: ');
        }
      };

      $('#btn_confirmar_nfce').on('click', async function() {
        try {
          const infoEmpresa = await retornaInfoEmpresa();
          $('#btn_confirmar_nfce').prop('disabled', true);
          const codcli = pegaChave("#txtClienteNFCE");
          const clienteExterior = await clienteDoExterior(codcli);
          if ((clienteExterior) && (parametrosVenda[3].VALOR === '')) {
            msgAlerta('Necessário definir o parametro de cliente padrão da venda para cliente do exterior. ');
            return;
          }

          if (clienteExterior) {
            insereValor('#txtCpfNFCE', '000.000.000-00');
          }

          if (($('#txtClienteNFCE').val().split(' - ')[1].substring(0, 16).toUpperCase() != 'CONSUMIDOR FINAL') &&
            ((infoEmpresa.EMP_ESTADO != 'MG') ||
              (infoEmpresa.EMP_ESTADO != 'RS')) &&
            (!valida_cpf_cnpj($('#txtCpfNFCE').val()))) {
            if (!((infoEmpresa.EMP_ESTADO == 'RS') && ($('#txtCpfNFCE').val() == ''))) {
              msgAlerta('CPF/CNPJ inválido, verifique.');
              $('#txtCpfNFCE').val('');
              $('#txtCpfNFCE').focus();
              return;
            }
          }

          // if (!valida_cpf_cnpj($('#txtCpfNFCE').val())) {
          //   msgAlerta('CPF/CNPJ inválido, verifique.');
          //   $('#txtCpfNFCE').val('');
          //   $('#txtCpfNFCE').focus();
          //   return;
          // }

          if ($('#txtCpfNFCE').val() == '') {
            msgAlerta('Necessário informar um CPF/CNPJ.');
            return;
          }

          if (($('#txtNaturezaNFCE').val() == '') && ($('#txtOperacaoNfce').val() == '')) {
            msgAlerta('Favor informar natureza ou operação.');
            return;
          }


          try {
            $.LoadingOverlay("show");
            //faz a requisição na api passando os dados..
            var _natureza = pegaChave('#txtNaturezaNFCE', _natureza);
            var _cpf = $('#txtCpfNFCE').val();
            var _obs = $('#txtInfoAdicionaisNFCE').val();
            var _codven = $('#txtCodVen').val();
            var _operacao = pegaChave('#txtOperacaoNfce');

            try {
              var _url = '/Sisplan/NFCE/v1/ConverteVenda?';
              var _params = `CNPJ=${_cpf}&NATUREZA=${_natureza}&OBSERVACAO=${_obs}&CODVEN=${_codven}&CODOPERACAO=${_operacao}&CODCLI=${codcli}`;
              var response = await requisicao('POST', _url, _params, null, 60000);

              if (!response) {
                msgErro('Erro ao gerar NFC-e');
                return;
              }

              if (response.status != 200) {
                var jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
              }

              toastr.success(
                'NFC-e gravada com sucesso, necessário!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: function() {
                    window.location.href = '<?php echo BASE_URI; ?>/nfce';
                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            } catch (error) {
              console.error(error);
            }
          } finally {
            $.LoadingOverlay("hide");
          }
        } finally {
          $('#btn_confirmar_nfce').prop('disabled', false);
        }
      });

      $('#tabelaVendas').on('dblclick', 'tr', async function() {
        event.preventDefault();
        setCookie("idMaquina", gerarGuid(), 365);
        var data = $('#tabelaVendas').DataTable().row($(this)).data();
        if (((data.FECHADA == 1) || (data.STATUS == 'FECHADA')) || (data.STATUS == 'CANCELADA') || (data.STATUS == 'DEVOLUCAO/TROCA') || (data.STATUS == 'AGRUPADA')) {
          msgAlerta('Impossível alterar venda fechada, cancelada ou devolução.');
          return;
        }
        var vendaLiberada = await liberarVenda(data.VENDA);
        if (vendaLiberada) {
          parent.abrirEmNovaAbaIFrame('Venda', `<?php echo BASE_URI; ?>/venda/${data.VENDA}`);
          // window.location.href = "venda/" + data.VENDA;
        }
      });

      async function buscaDadosAoCancelar(codven) {
        try {
          const pesquisa = {
            tabela: 'ITVENDA',
            camposSelect: ['ITVENDA.CODVENORIG'],
            leftJoin: [{
              tabela: 'VENDA',
              condicao: 'VENDA.CODVEN = ITVENDA.CODVEN AND VENDA.EMP_ID = ITVENDA.EMP_ID'
            }],
            where: [`ITVENDA.CODVENORIG = '${codven}' AND VENDA.EMP_ID = ${getCookie('emp_id')} AND VENDA.CANCELADA = 0`]
          }
          const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
          if (!response) {
            return;
          }
          const comparaCampos = ((response[0].CODVENORIG == codven));
          return comparaCampos;
        } catch (error) {
          console.error(error);
        }
      }

      $('#tabelaVendas').on('click', '#btn-cancelar-venda', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        const bFaturaPossuiProtocolo = await verificaFaturaVenda(data.FATURA_NFE, data.FATURA_NFCE);

        if (bFaturaPossuiProtocolo) {
          msgAlerta('Venda possui fatura sem protocolo, deseja mesmo cancelar?',
            () => {
              callBack();
              rotinaGeraLog('ACESSO_VENDA', data.VENDA, `USUÁRIO CONFIRMOU O CANCELAMENTO DA VENDA ${data.VENDA}, QUE POSSUI FATURA SEM PROTOCOLO`)
            },
            undefined,
            undefined,
            undefined);
        } else {
          callBack();
        }

        async function callBack() {
          var verificaDevolucaoVinculada = await buscaDadosAoCancelar(data.VENDA);
          $("#title-cancelar").html(data.VENDA);
          if (bUsaECF != 0) {
            $("#txt_cancelar_cupom").val(data.NRCUPOM);
          }
          if (verificaDevolucaoVinculada == true) {
            msgAlerta('Venda possui devolução vinculada! Não foi possível cancelar.')
            return
          }
          $("#modal-cancelar").modal("show");
        }

      });

      $('#checkCanceladas').prop('checked', true);

      $('#cbEmitido').prop('checked', JSON.parse(getCookie('emitido') == '' ? true : getCookie('emitido')));
      $('#cbPendente').prop('checked', JSON.parse(getCookie('pendente') == '' ? true : getCookie('pendente')));
      $('#cbDevolvido').prop('checked', JSON.parse(getCookie('devolvido') == '' ? true : getCookie('devolvido')));
      $('#checkCanceladas').prop('checked', JSON.parse(getCookie('canceladas') == '' ? true : getCookie('canceladas')));
      $('#cbAgrupada').prop('checked', JSON.parse(getCookie('agrupada') == '' ? true : getCookie('agrupada')));
      await buscaVendas();

      setCookie('enviando_comando', 'false');
      if (bUsaECF == '1') {
        if (await maquinaTemImpressora()) {
          await habilitaPanelImpressora(true);
          await buscaStatusImpressora();
          if (($('#txtStatusECF').html() == " Offline ") || ($('#txtEstadoECF').html() == "Desconectado")) {
            conectaECF(ipInterno, ipExterno, basicAuth);
          }
          if ($('#txtEstadoECF').html() == 'Requer Z') {
            msgAlerta(
              'Impressora com Redução Z pendente, para emitir, utilize o menu fiscal localizado a direita.');
          }
        }
      }

      $("#confirmar_dados").on('click', function() {
        sessionStorage.setItem('g_vendedor_logado', $("#txtVendedor").val());
        sessionStorage.setItem('g_caixa_logado', $("#txtCaixa").val());
        $("#modal-vendedor").modal("hide");

        if ($('#txtCaixa').val() != $('#txtCaixaFiltro').val()) {
          if (!bPodeConsultarCaixas) {
            $('#txtCaixaFiltro').val($('#txtCaixa').val());
          }
          buscaVendas();
        }
      });

      $("#confirmar_obs").on('click', async function() {
        if (await CopiaParametro('VENDA', 45) == '1') {
          await cancelaVenda();
        } else {
          await senhaSupervisor('', cancelaVenda);
        }
      });

      async function cancelaVenda() {
        $.LoadingOverlay("show");
        try {

          const venda = $("#title-cancelar").html();
          const cupom = $("#txt_cancelar_cupom").val();
          const ultimoCupom = await RetornaUltimoCupomImpressora();
          let respostaCancelamentoTEF = [true];
          const bUtilizaCashbackCRMBonus = parametrosVenda[72] == '2';
          const obs = $('#txtObs').val();

          if (obs == "") {
            msgAlerta('Observação não informada');
            return;
          }

          if (!await validaCancelamento(obs, venda, ultimoCupom)) {
            $("#modal-cancelar").modal("hide");
            return;
          }

          const bTef = await possuiTef(venda);

          if (bTef) {
            msgAlerta(`A venda ${venda} possui pagamento efetuado pela TEF.\nVocê tem a opção de estornar o pagamento ou simplesmente cancelar a venda.\nGostaria de prosseguir com o estorno do pagamento?`,
              async () => {
                  $.LoadingOverlay("show");
                  try {
                    respostaCancelamentoTEF = await verificaECancelaTEF(venda, cupom, bTef);
                    if (respostaCancelamentoTEF[0]) {
                      await rotinaGeraLog("ACESSO_VENDA", venda, "USUÁRIO OPTOU POR ESTORNAR O PAGAMENTO DA TEF", "Exclusão");
                      await callBackCancelamento();
                    }
                  } finally {
                    $.LoadingOverlay("hide");
                  }
                },
                async () => {
                    await rotinaGeraLog("ACESSO_VENDA", venda, "USUÁRIO OPTOU POR NÃO ESTORNAR O PAGAMENTO DA TEF E EFETUAR SOMENTE O CANCELAMENTO DA VENDA", "Exclusão");
                    await callBackCancelamento();
                  },
                  undefined,
                  async () => {
                      await rotinaGeraLog("ACESSO_VENDA", venda, "USUÁRIO OPTOU POR NÃO ESTORNAR O PAGAMENTO DA TEF E EFETUAR SOMENTE O CANCELAMENTO DA VENDA", "Exclusão");
                      await callBackCancelamento();
                    },
                    true);
          } else {
            await callBackCancelamento();
          }

          async function callBackCancelamento() {
            $.LoadingOverlay("show");
            try {

              if (!respostaCancelamentoTEF[0]) {
                return;
              }

              if ((bUsaECF != 0) && (cupom != '')) {
                if (!await CancelaUltimoCupom()) {
                  msgErro('Somente é possível cancelar o último cupom emitido');
                  return;
                }
              }

              const response = await requisicao('POST', '/Sisplan/Vendas/V1/Cancelar?', `OBS=${obs}&CODVEN=${venda}&CONSIG_FINALIZADO=N&MOV_ESTOQUE=S`, '', 90000);

              const jsonStr = await response.json();
              if (response.status != 200) {
                $("#modal-cancelar").modal("hide");
                msgErro(jsonStr.mensagem);
                return;
              }

              await excluiVendaIShopp(venda);

              if (bUtilizaCashbackCRMBonus) {
                await cancelarCRMBonus(venda);
              }

              $("#modal-cancelar").modal("hide");

              if (respostaCancelamentoTEF[1] != '' && respostaCancelamentoTEF[1]) {
                await msgErro(respostaCancelamentoTEF[1], () => {
                  window.location.href = '<?php echo BASE_URI; ?>/loja'
                }, () => {
                  window.location.href = '<?php echo BASE_URI; ?>/loja'
                })
              } else {
                window.location.href = '<?php echo BASE_URI; ?>/loja';
              }
            } finally {
              $.LoadingOverlay("hide");
            }
          }

        } catch (error) {
          console.error(error);
          $("#modal-cancelar").modal("hide");
        } finally {
          $.LoadingOverlay("hide");
        }
      }

      $("#btn-parametros").on('click', function() {
        $("#txtVendedor").val(sessionStorage.getItem('g_vendedor_logado'));
        $('#txtVendedor').attr('data-selecionado', true);
        $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));
        if (!bPodeConsultarCaixas) {
          $("#txtCaixaFiltro").val(sessionStorage.getItem('g_caixa_logado'));
        }
        $('#txtCaixa').attr('data-selecionado', true);
        $("#modal-vendedor").modal("show");
      });

      if ((!sessionStorage.getItem('g_vendedor_logado')) || (sessionStorage.getItem('g_vendedor_logado') == '')) {
        const usuarioLogado = sessionStorage.getItem('cod_usuario');
        const params = {
          tabela: 'acesso_usuarios',
          camposSelect: ['acesso_usuarios.codrep, represen.nome'],
          LeftJoin: [{
            "tabela": "represen",
            "condicao": "represen.codrep = acesso_usuarios.codrep"
          }],
          where: [`acesso_usuarios.codigo = '${usuarioLogado}'`]
        };

        const response = await retornaJsonPesquisaPadrao(JSON.stringify(params));

        if (!response) {
          return;
        }
        const vendedorDoUsuario = response[0].CODREP;
        const nomeVendedor = response[0].NOME;

        if (vendedorDoUsuario != '') {
          const sCaixa = '[' + vendedorDoUsuario + '] - ' + nomeVendedor;
          sessionStorage.setItem('g_vendedor_logado', sCaixa);

          insereValor('#txtVendedor', vendedorDoUsuario, nomeVendedor)
        }
      };

      $("#btn-relatorio").on('click', async function() {
        var url = `/sisplan/impressao/v1/venda?`;
        $.LoadingOverlay("show");
        const bImprimeAutomatico = await verificaImprimirAutomatico('Venda');
        var arquivo = await GeraRelatorio(url, 'GET', 15000, false, 'Venda');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open('<?php echo BASE_URI; ?>/relatorios_api/pdf/' + arquivo, '_blank');
          }
          await limparRelatorios();
        }
        $.LoadingOverlay("hide");
      });

      $('#tabelaVendas').on('click', '#btn-imprimir-venda', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        await imprimirRomaneio(data.VENDA, "<?php echo BASE_URI; ?>");
      });

      $('#tabelaVendas').on('click', '#btn-imprimir-carne', async function() {
        event.preventDefault();
        var data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        if (data.FECHADA == 1) {
          await imprimirCarne(data.VENDA, "<?php echo BASE_URI; ?>");
        } else {
          msgAlerta('A venda deve estar fechada para a impressão de carnês.');
        }
      });

      $('#tabelaVendas').on('click', '#btn-imprimir-resumo', async function() {
        event.preventDefault();
        const data = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        try {
          $.LoadingOverlay("show");
          let url = `/sisplan/impressao/v1/vendaresumo?codven=${data.VENDA}`;
          try {
            const bImprimeAutomatico = await verificaImprimirAutomatico('Venda_Resumo');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Venda_Resumo');
            if (arquivo != undefined) {
              if (!bImprimeAutomatico) {
                window.open(`${"<?php echo BASE_URI; ?>"}/relatorios_api/pdf/${arquivo}`, "_blank");
              }
              await limparRelatorios();
            }
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });

      $('#tabelaVendas').on('click', '#btn-duplicar-venda', async function() {
        event.preventDefault();
        const tabelaDados = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();

        if (tabelaDados.STATUS != 'PENDENTE') {
          const numeroVenda = tabelaDados.VENDA;
          msgAlerta("Tem certeza que deseja duplicar a venda " + numeroVenda + "?", async () => {
            $.LoadingOverlay('show')
            try {
              await duplicarVenda(numeroVenda);
            } finally {
              $.LoadingOverlay('hide')
            }
          });
        } else {
          msgAlerta('Somente é possivel duplicar vendas canceladas');
          return;
        }
      })

      $('#tabelaVendas').on('click', '.btnVerificaOpcoes', async function() {
        event.preventDefault();
        const tabelaDados = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();

        if (tabelaDados.STATUS == 'PENDENTE') {
          $('.btn-duplicar-venda').addClass('d-none');
        } else {
          $('.btn-duplicar-venda').removeClass('d-none');
        }
      });

      $('#tabelaVendas', this).on('search.dt', function() {
        atualizaTotais('applied');
      });

      $('#btnConsultar').on('click', async function() {
        await setCookie('emitido', $('#cbEmitido').prop('checked'));
        await setCookie('devolvido', $('#cbDevolvido').prop('checked'));
        await setCookie('pendente', $('#cbPendente').prop('checked'));
        await setCookie('canceladas', $('#checkCanceladas').prop('checked'));
        await setCookie('agrupada', $('#cbAgrupada').prop('checked'));
        buscaVendas();
        $('#modal-filtros').modal('hide');
      });

      jQuery.fn.dataTable.Api.register('sum()', function() {
        return this.flatten().reduce(function(a, b) {
          return (a * 1) + (b * 1); // cast values in-case they are strings
        });
      });

      async function duplicarVenda(numeroVenda) {
        const url = '/sisplan/vendas/v1/duplicarvenda?';
        params = `CODVEN=${numeroVenda}`;
        const response = await requisicao('POST', url, params, 90000);
        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem)
          return;
        }

        toastr.success(
          'Venda duplicada com sucesso!',
          'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden: async () => {
              const vendaLiberada = await liberarVenda(jsonStr.codigo);
              if (vendaLiberada) {
                window.location.href = "venda/" + jsonStr.codigo;
              }
            }
          }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      };

      const bTEFConfigurada = await pingTEF();

      if (bTEFConfigurada) {
        $('#btn-solicitaAdm').removeClass('d-none');
      } else {
        $('#btn-solicitaAdm').addClass('d-none');
      }

      await consultaBlocoXpendente();

      $('#btn-vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome", "fantasia", "cnpj", "ativo" ], "where": ["ativo = 'S'"]}`, 'Pesquisa Vendedor', 'represen');
      $('#btn-vendedorFiltro').pesquisa('#txtVendedorFiltro', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome", "fantasia", "cnpj", "ativo" ], "where": ["ativo = 'S'"]}`, 'Pesquisa Vendedor', 'represen');
      if (paramVen54 != '2') {
        $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
        $('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
        $('#btn-caixa-filtro').pesquisa('#txtCaixaFiltro', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
        $('#txtCaixaFiltro').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
      }
      $('#btn-cliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
      var sSeparador = "' - '";
      let iEmpID = getCookie('emp_id');
      $('#btn-venda').pesquisa('#txtVenda', 'CODVEN', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven", "(venda.codcli || ${sSeparador} ||entidade.nome) CLIENTE" ], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["venda.emp_id = ${iEmpID}"]}`, 'Pesquisa Venda', 'venda');
      $('#btnPesquisaTipoVenda').pesquisa('#txtTipoVendaFiltro', 'ID', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa Tipo Venda', 'VENDA_TIPO');

      $('#btn-limpa-NFe').on('click', function() {
        $('#txtNFe').val('');
      });
      $('#btn-limpa-NFCe').on('click', function() {
        $('#txtNFCe').val('');
      });
      $('#btn-limpa-Cupom').on('click', function() {
        $('#txtCupom').val('');
      });
      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
      });
      $('#btn-limpa-caixa').on('click', function() {
        $('#txtCaixaFiltro').val('');
      });
      $('#btn-limpa-caixa2').on('click', function() {
        $('#txtCaixa').val('');
      });
      $('#btn-limpa-vendedor').on('click', function() {
        $('#txtVendedor').val('');
      });
      $('#btn-limpa-vendedorFiltro').on('click', function() {
        $('#txtVendedorFiltro').val('');
      });
      $('#btn-limpa-venda').on('click', function() {
        $('#txtVenda').val('');
      });
      $('#btn-limpa-NaturezaNFCE').on('click', function() {
        $('#txtNaturezaNFCE').val('');
      });
      $('#btn-limpa-NaturezaNFE').on('click', function() {
        $('#txtNaturezaNFE').val('');
      });
      $('#btn-limpa-ClienteNFE').on('click', function() {
        $('#txtClienteNFE').val('');
      });
      $('#btnLimpaTipoVenda').on('click', function() {
        $('#txtTipoVendaFiltro').val('');
      });

      // rotinas aba geral
      $('#txtClientePresente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": [] }`, ['#txtCNPJPresente'], ['CNPJ'], ['CNPJ']);
      $('#btn-cliente-presente').pesquisa_serverside(['#txtClientePresente', '#txtCNPJPresente'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
      $('#btn-limpa-cliente-presente').on('click', function() {
        limpaValor('#txtClientePresente');
        limpaValor('#txtCNPJPresente');
      });


      const tipoBase = await retornaDatabase();
      let where = '';
      if (tipoBase != 'ORACLE') {
        where = `AND RECEBER.CARTAO_PRESENTE <> ''`
      }

      $(`#btnNumeroPresente`).pesquisa_serverside([`#txtNumeroPresente`, `#txtNumeroInvisivel`], ['RECEBER.CARTAO_PRESENTE', 'ENTIDADE.NOME'], ['RECEBER.CARTAO_PRESENTE', 'ENTIDADE.NOME'], `{"tabela":"RECEBER", "camposSelect":[ "RECEBER.CARTAO_PRESENTE", "RECEBER.CODCLI", "ENTIDADE.NOME"], "leftjoin": [{"tabela": "ENTIDADE", "condicao": "RECEBER.CODCLI = ENTIDADE.CODCLI"}], "where": ["RECEBER.CARTAO_PRESENTE IS NOT NULL ${where}"]}`, 'Pesquisa Receber', '', [true, false]);
      $('#btnLimpaNumeroPresente').on('click', function() {
        limpaValor('#txtNumeroPresente');
      });

      function incluiDinheiro() {
        if ($('#txtMoeda').attr('data-chave') == 0) {
          insereValor('#txtNrParcelas', 1, 1);
        }
      }
      $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe CHAVE", "cast(moeda.cdcondi as varchar(50)) codcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}],"where": ["MOEDA.ATIVO = 'S'"]}`, ['#txtCondicaoDePagamento'], ['CODCONDI'], ['DESC_COND']);
      $('#btn-moeda').pesquisa_array(['#txtMoeda', '#txtCondicaoDePagamento'], ['CODMOE', 'CODCONDI'], ['DESCRICAO', 'DESC_COND'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "moeda.codmoe", "cast(moeda.cdcondi as varchar(50)) codcondi", "condicao.descricao desc_cond", "moeda.descricao", "moeda.baixa_ante", "moeda.tipo"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["MOEDA.ATIVO = 'S'"]}`, 'Pesquisa Moeda', 'moeda');
      $('#btn-limpa-moeda').on('click', function() {
        limpaValor('#txtMoeda')
      });

      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
      $('#btn-limpa-condicao').on('click', function() {
        limpaValor('#txtCondicaoDePagamento')
        $('#txtNrParcelas').val('');
      });
    });

    // solicita ADM tef
    $('#btn-solicitaAdm').on('click', async function() {
      let response;
      let jsonStr;

      try {
        response = await requisicao_ecf('GET', '/tef/solicitadm?', '');

        if (!response) {
          return;
        }
      } catch (error) {
        console.error(error);
      }
    });

    $('#btnMinhasVendas').on('click', async function() {
      await consultarMinhasVendas();
      $('#modalMinhasVendas').modal('show');
    });

    $('#btnAgrupaVendas').on('click', async function() {
      // window.location.href = 'agrupamento_venda'
      parent.abrirEmNovaAbaIFrame('Agrupamento Venda', `<?php echo BASE_URI; ?>/agrupamento_venda`);
    });

    $('#btnConsultarMinhasVendas').on('click', async function() {
      await consultarMinhasVendas();
    });

    $('#btnFecharMinhasVendas').on('click', function() {
      $('#modalMinhasVendas').modal('hide');
    });

    $('#btnImprimirMinhasVendas').on('click', async function() {
      await imprimirMinhasVendas();
    });

    async function filtrosMinhasVendas() {
      const sCodRep = pegaChave(sessionStorage.getItem('g_vendedor_logado'));
      const sDataDe = $('#txtDataDeMinhasVendas').val();
      const sDataAte = $('#txtDataAteMinhasVendas').val();
      const sCliente = pegaChave('#txtClienteMinhasVendas');
      const sCodVen = pegaChave('#txtVendaMinhasVendas');
      const bSequenciaDia = parametrosVenda[56] == '1';

      if (sCodRep == '' || !sCodRep) {
        msgAlerta('Cadastro de usuário não contém um representante informado, verifique!');
        return;
      }

      if (sDataDe == '' || sDataAte == '') {
        msgAlerta('Informe uma data válida!');
        return;
      }

      const params = `CODREP=${sCodRep}` +
        `&DATA_DE=${sDataDe}` +
        `&DATA_ATE=${sDataAte}` +
        `&CODCLI=${sCliente}` +
        `&CODVEN=${sCodVen}` +
        `&SEQDIA=${bSequenciaDia}`;

      return params;
    }

    async function consultarMinhasVendas() {
      const filtrosConsulta = await filtrosMinhasVendas();

      if (filtrosConsulta == undefined) {
        return;
      }

      const COLUNA_STATUS = parametrosVenda[56] == '1' ? 3 : 2;
      const COLUNA_DATA = parametrosVenda[56] == '1' ? 4 : 3;

      try {
        $.LoadingOverlay('show');

        if ($.fn.DataTable.isDataTable('#tabelaMinhasVendas')) {
          $('#tabelaMinhasVendas').DataTable().clear().draw();
        }

        const response = await requisicao('GET', '/Sisplan/Vendas/V1/minhasvendas?', `${filtrosConsulta}`, '', 90000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem)
          return;
        }

        let dataSetCols = [];

        let keys = Object.keys(jsonStr[0]);

        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        }
        dataSetCols[COLUNA_STATUS].render = function(data, type, row) {
          if (row["STATUS"] == 'PENDENTE') {
            return '<div class="d-flex"><i class="fas fa-circle text-green mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          } else if (row["STATUS"].toUpperCase() == 'AGRUPADA') {
            return '<div class="d-flex"><i class="fas fa-circle text-purple mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          } else if (row["STATUS"].toUpperCase() == 'CANCELADA') {
            return '<div class="d-flex"><i class="fas fa-circle text-red mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          } else if (row["STATUS"].toUpperCase() == 'FECHADA') {
            return '<div class="d-flex"><i class="fas fa-circle text-blue mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          } else if (row["STATUS"].toUpperCase() == 'DEVOLUCAO/TROCA') {
            return '<div class="d-flex"><i class="fas fa-circle text-yellow mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          } else {
            return '<div class="d-flex"><i class="fas fa-circle text-grey mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
          }
        }

        $('#tabelaMinhasVendas').DataTable({
          paging: true,
          filter: false,
          info: true,
          order: false,
          destroy: true,
          autoWidth: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          data: jsonStr,
          columns: dataSetCols,
          columnDefs: [{
              render: render = function(data, type, row) {
                let isIE = function() {
                  if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                    return true;
                  }
                  return false;

                };
                if (isIE()) {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                }
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;

              },
              targets: COLUNA_DATA,
            },
            {
              "render": function(data) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              "targets": [4, 7],
              "className": 'pr-4 text-right'
            },
            {
              "targets": [5, 6, 8],
              "className": 'pr-4 text-right'
            }
          ],
        });

      } catch (error) {
        console.log(error);
      } finally {
        $.LoadingOverlay('hide');
      }
    }

    async function imprimirMinhasVendas() {
      try {
        $.LoadingOverlay('show');
        try {
          let url = `/sisplan/impressao/v1/relminhasvendas?`;

          const filtros = await filtrosMinhasVendas();

          if (filtros == undefined) {
            return;
          }

          const bImprimeAutomatico = await verificaImprimirAutomatico('RelMinhasVendas');
          let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 1000000, false, 'RelMinhasVendas');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }

        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }

    async function cancelarCRMBonus(codVen) {
      try {
        const pesquisa = {
          tabela: 'CRMBONUS',
          camposSelect: ['ID_CASHBACK', 'ID_CLIENTE', 'CELULAR'],
          where: [`CODVEN = ${codVen}`]
        };

        const jsonPesquisa = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonPesquisa.length <= 0) {
          return;
        }

        const response = await requisicao("GET", "/sisplan/crmbonus/v1/cancelar?", `ID_CASHBACK=${jsonPesquisa[0].ID_CASHBACK}&ID_CLIENTE=${jsonPesquisa[0].ID_CLIENTE}&CELULAR=${jsonPesquisa[0].CELULAR}&CODVEN=${codVen}`);

        if (!response) {
          throw msgAlerta("Não foi possível cancelar o CRMBonus.");
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          throw msgAlerta(jsonStr.mensagem);
        }

      } catch (error) {
        console.error(error);
      }
    }

    async function verificaFaturaVenda(faturaNFE, faturaNFCE) {

      if (faturaNFE != '') {

        const pesquisaNFE = {
          tabela: 'NOTA',
          camposSelect: ['NOTA.FATURA'],
          where: [`NOTA.FATURA = '${faturaNFE}' AND (NOTA.PROTOCOLO_NFE = '' OR NOTA.PROTOCOLO_NFE IS NULL)}`]
        }
        const responseNFE = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNFE));

        if (!responseNFE) {
          return false;
        }

        if (responseNFE.length > 0) {
          return true;
        }

      } else if (faturaNFCE != '') {

        const pesquisaNFCE = {
          tabela: 'NOTA_NFCE',
          camposSelect: ['NOTA_NFCE.FATURA'],
          where: [`NOTA_NFCE.FATURA = '${faturaNFCE}' AND (NOTA_NFCE.PROTOCOLO_NFCE = '' OR NOTA_NFCE.PROTOCOLO_NFCE IS NULL)`]
        }
        const responseNFCE = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNFCE));

        if (!responseNFCE) {
          return false;
        }

        if (responseNFCE.length > 0) {
          return true;
        }

      }

      return false;

    };

    $('#cbDataDeAtual').on('change', function() {
      localStorage.setItem("cbDataDeAtual", $('#cbDataDeAtual').prop('checked'));
    })

    function pegaDataRetorno() {
      const dataAtual = new Date();
      dataAtual.setDate(dataAtual.getDate() + 30);

      const ano = dataAtual.getFullYear();
      const mes = String(dataAtual.getMonth() + 1).padStart(2, '0');
      const dia = String(dataAtual.getDate()).padStart(2, '0');

      const dataFormatada = `${ano}-${mes}-${dia}`;
      return dataFormatada
    }

    $('#tabelaVendas').on('click', '#btnFinalizarAtendimento', async function() {
      event.preventDefault();
      $.LoadingOverlay("show");
      try {
        const sujestaoData = pegaDataRetorno()
        const venda = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data();
        const atendimentoFinalizado = await validaAtendimentoFinalizado(venda.VENDA);

        if (atendimentoFinalizado) {
          throw msgAlerta("Atendimento já finalizado!");
        }

        if (venda.DATA < formataData(new Date())) {
          throw msgAlerta("Não é possível finalizar um atendimento feito em outro dia!");
        }

        msgAlertaComInput(`Você está finalizando o atendimento, insira a data de previsão de retorno e clique em "Sim" para confirmar'`,
          async () => {
              let dataRetorno = $('#dtRetorno').val()
              await finalizarAtendimento(venda, dataRetorno);
            },
            () => {},
            () => {},
            () => {},
            true,
            sujestaoData);

      } finally {
        $.LoadingOverlay("hide");
      }
    });

    $('#tabelaVendas').on('click', '#btnCriarPedido', async function(e) {
      event.preventDefault()
      $.LoadingOverlay('show')
      try {
        const codven = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data().VENDA
        const response = await requisicao("POST", `/sisplan/vendas/v1/criapedido?`, `CODVEN=${codven}`, '', 60000);

        const jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem)
          return;
        }

        toastr.success(
          `Pedido: ${jsonStr.mensagem} criado com sucesso!`,
          'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.log(error)
      } finally {
        $.LoadingOverlay('hide')
      }
    });

    $('#tabelaVendas').on('click', '#btnImprimirFinalizacao', async function() {
      event.preventDefault();
      $.LoadingOverlay("show");
      try {
        const linhaSelecionada = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data()
        const codCli = linhaSelecionada.CLIENTE.split('-')[0].trim()
        const data = formataDataBonita(linhaSelecionada.DATA)
        const codVen = linhaSelecionada.VENDA
        const vendaIsFinalizada = await buscaValor('VENDA', 'ATEND_FINALIZADO', 'CODVEN', codVen);
        if (vendaIsFinalizada.ATEND_FINALIZADO != 'S') {
          throw msgAlerta('Atendimento não foi finalizado, impossível imprimir o relatório.')
        }
        const urlImpressao = `/sisplan/impressao/v1/imprimiratendimentofinalizado?CODCLI=${codCli}&DATA=${data}`;

        const arquivo = await GeraRelatorio(`${urlImpressao}&`, "GET", 15000, false, 'Atendimento_Finalizado');
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    });

    async function gravaDataPrevisao(codCli, dataRetorno) {
      try {
        $.LoadingOverlay('show');
        try {
          let ocorrencia = {};
          ocorrencia.NUMERO = await RetornaProximo('NUMERO', 'CLI_HISTORICO', 'NUMERO', 6);
          ocorrencia.ASSUNTO = 'DATA DE PREVISÃO PARA RETORNO DO ATENDIMENTO';
          ocorrencia.ATIVO = 'S';
          ocorrencia.DATA = formataData(new Date());
          ocorrencia.DT_PREV_RETORNO = dataRetorno;
          ocorrencia.AVISA_CAD = 'N';
          ocorrencia.AVISA_EXP = 'N';
          ocorrencia.AVISA_NOTA = 'N';
          ocorrencia.AVISA_PED = 'N';
          ocorrencia.BLOQUEAR_FAT = 'N';
          ocorrencia.CODCLI = codCli;
          ocorrencia.USUARIO = getCookie('g_usuario_logado');
          ocorrencia.DT_ENTREGA = '1899-12-30';
          ocorrencia.OBS = 'DATA DE PREVISÃO PARA RETORNO DO ATENDIMENTO';

          const url = `/sisplan/cliente/v1/incluiocorrencia?`;
          const response = await requisicao("POST", url, `JSON=${JSON.stringify(ocorrencia)}`, '', 60000);

          if (response.status != 200) {
            const jsonMsg = await response.json();
            msgAlerta(jsonMsg.mensagem);
            return;
          };

          // criaMensagemSucesso('Ocorrência inclusa com sucesso!', desabilitaInclusao);

        } catch (e) {
          console.log(e);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }

    async function finalizarAtendimento(venda, dataRetorno) {
      $.LoadingOverlay("show");
      try {
        const codCli = venda.CLIENTE.split("-")[0].trim();
        const nome = venda.CLIENTE.split("-")[1].trim();
        const cadastraEntidadeBloqueada = parametrosEntidade[2].VALOR == "1";
        const vendasDiaAtual = await buscaVendasDiaAtual(codCli);
        const urlImpressao = `/sisplan/impressao/v1/imprimiratendimentofinalizado?CODCLI=${codCli}`;
        const celular = await getWhatsapp(codCli);
        const parametrosMensagem = [`CODCLI: ${codCli}`, `EMP_ID: ${getCookie("emp_id")}`];
        const objMsgWpp = [];

        objMsgWpp.push({
          CELULAR: celular,
          NOME: nome,
          PARAMETROSMENSAGEM: parametrosMensagem.toString(),
          MENSAGEMPERSONALIZADA: ""
        });

        if (cadastraEntidadeBloqueada) {
          await alterarBloqueioCliente(codCli, true, "LOJA", false);
        }
        if (dataRetorno < formataData(new Date())) {
          throw msgAlerta('Data de retorno não pode ser menor que a data atual, verifique!');
        }
        await gravaDataPrevisao(codCli, dataRetorno)
        await atualizarAtendimentoFinalizado(vendasDiaAtual);

        const arquivo = await GeraRelatorio(`${urlImpressao}&`, "GET", 15000, false, 'Atendimento_Finalizado');
        const base64 = await transformaPDFemBase64(`${BASE_URI}/relatorios_api/pdf/${arquivo}`);
        await enviarMsgPersonalizadaWpp("ATENDIMENTO_FINALIZADO", objMsgWpp, base64);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    async function validaAtendimentoFinalizado(codVen) {
      const pesquisa = {
        tabela: 'VENDA',
        camposSelect: ["ATEND_FINALIZADO"],
        where: [`CODVEN = ${codVen}`, `EMP_ID = ${getCookie("emp_id")}`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      if (jsonStr[0].ATEND_FINALIZADO == "S") {
        return true;
      }

      return false;
    }

    async function atualizarAtendimentoFinalizado(listaVendas) {
      try {

        const response = await requisicao('PUT', '/sisplan/vendas/v1/atualizaratendimentofinalizado?', `VENDAS=${listaVendas.toString()}`);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          jsonEntidade['RESULT'][0].mensagem;
          return;
        }

      } catch (error) {
        console.error(error);
      }
    }

    async function buscaVendasDiaAtual(codCli) {
      const dataBase = await retornaDatabase();
      try {

        const pesquisa = {
          tabela: 'VENDA',
          camposSelect: ["CODVEN"],
          where: [`DATA = ${dataBase == "ORACLE" ? `DATE '${formataData(new Date())}'` : `'${formataData(new Date())}'`}`, `EMP_ID = ${getCookie("emp_id")}`, `CODCLI = '${codCli}'`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr.length > 0) {
          return jsonStr.map(codigos => codigos.CODVEN);
        }

      } catch (error) {
        console.error(error);
      }
    }

    $("#tabelaVendas").on("click", "#btnReimpressaoTEF", async function() {
      event.preventDefault();
      $.LoadingOverlay("show");
      const codVen = $('#tabelaVendas').DataTable().row($(this).parents('tr')).data().VENDA;
      try {
        if (await possuiTef(codVen)) {
          await reimpressaoTEF(codVen);
        } else {
          throw msgAlerta("Não é possível realizar a operação, venda não finalizada com máquina TEF.");
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    })

    async function reimpressaoTEF(codVen) {
      const comprovanteTEF = await retornaComprovanteTEF(codVen);
      const url = `/tef/reimpressaotef?`;
      const params = `COMPROVANTE_TEF=${encodeURIComponent(comprovanteTEF)}`;

      if (comprovanteTEF == "") {
        throw msgAlerta("Nenhum comprovante encontrado para realizar a reimpressão.")
      }

      try {

        const response = await requisicao_ecf("GET", url, params, "", 300000);

        if (!response) {
          throw msgAlerta("Não foi possível reimprimir comprovante da máquina TEF.");
        }

        const resp = await response.text();
        if (response.status != 200) {
          throw msgAlerta(resp != '' ? resp : 'Não foi possível reimprimir comprovante da máquina TEF.');
        }

        criaMensagemSucesso('Reimpressão realizada com sucesso!');

      } catch (error) {
        console.error(error);
      }

    }

    async function retornaComprovanteTEF(codVen) {
      const url = `/sisplan/vendas/v1/retornacomprovantetef?`;
      try {

        const response = await requisicao('GET', url, `CODVEN=${codVen}`);

        if (!response) {
          msgAlerta("Não foi possível consultar o comprovante da máquina TEF.");
          return "";
        }

        if (response.status != 200) {
          msgAlerta("Não foi possível consultar o comprovante da máquina TEF.");
          return "";
        }

        const jsonStr = await response.json();

        if (jsonStr.length > 0) {
          return formataArquivoTEF(jsonStr[0].DADOS_TEF);
        }

        return "";

      } catch (error) {
        console.error(error);
      }
    }

    async function formataArquivoTEF(arquivo) {
      const regex = /\d{3}-\d{3} = .*?(?=\s*\d{3}-\d{3}|$)/g;
      const separacaoArquivo = arquivo.match(regex);
      let arquivoFormatado = "";

      separacaoArquivo.forEach(parteArquivo => {
        arquivoFormatado += parteArquivo + "\\n";
      })

      return arquivoFormatado;

    }

    async function rotinaSaidaMoedaPresente() {
      const codCondMoeda = pegaChave("#txtCondicaoDePagamento");
      const codMoeda = pegaChave("#txtMoeda");
      if (codMoeda == "0") {
        $("#txtNrParcelas").val("1");
      } else {
        const dadosMoeda = await RetornaDadosMoeda(codMoeda);
        insereValor("#txtNrParcelas", dadosMoeda['RESULT'][0][0].NRPAR, dadosMoeda['RESULT'][0][0].NRPAR)
      }
    };

    async function carregaValoresPadroes() {
      const pesquisa = {
        camposSelect: ['CAMPO', 'VALOR'],
        tabela: 'TABPADRAO',
        where: [`TABELA = 'LOJA'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      jsonStr.map(item => {
        switch (item.CAMPO) {
          case "LANCAR_ANTECIPACAO": {
            $("#cbLancarAntecipacao").prop("checked", item.VALOR == "Sim");
            break;
          }
        }
      });
    };

    $(function() {
      $('.valoresInput').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2,
        allowZero: true,
        defaultZero: true,
        selectAllOnFocus: true
      });
    })
  </script>

</body>

</html>