/* eslint-disable prefer-destructuring */
$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: "#tourGeral",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os dados gerais da nota.",
          position: "top",
        },
      },
      {
        element: "#txtCliente",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtDeposito",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#avancar1",
        popover: {
          title: "Botão Avançar",
          description:
            "Clique aqui para avançar para a aba itens, onde será possível adicionar itens e após isso, adicionar duplicatas e/ou gravar a nota.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await setarDataAtual("txtDataEmissao");
  await setarDataAtual("txtDataSaida");

  componenteFiltro('tabPreco', false, false, 'TabPrecoVenda');

  criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '200px');
  criaDataTablePadrao('#tabelaPedidos', false, false, false, false, true, true, '200px');
  validaCookiePedido();

  let currentFs;
  let nextFs;
  let previousFs; // fieldsets
  let opacity;

  const bUsaIndice = await CopiaParametro("FATURAMENTO", 3) == '1';

  await verificaPermissoes('FATURAMENTO');

  await vencimentoCertificado();

  if (notaUrl == 'create') {
    await carregaValoresPadroes();
  }

  await carregaValoresPadroesFinanceiro();

  const usaProdMaterial = await CopiaParametro("VENDA", 17);
  await consultaClienteRepresentante();
  $('#radioProduto').prop('checked', usaProdMaterial == '0');
  $('#radioMaterial').prop('checked', usaProdMaterial == '1');
  $('#radioProduto').trigger('change');

  const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
  const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

  if (depositoUsuario != 'null') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${depositoUsuario}}`);
    $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
  } else if (depositosEmpresaLogada != '') {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`);
    $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
  } else {
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`);
    $('#btnDeposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
  }

  if (depositosEmpresaLogada != '') {
    $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"PA_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, DT_MVTO DESCRICAO"], "where": ["OPERACAO = 'E' AND DEPOSITO IN (${depositosEmpresaLogada})"] }`, [], [], []);
    $("#btnDocumentoMovimentacao").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MVTO"], `{"tabela":"PA_MOV", "camposSelect":[ "NUM_DOCTO", "DT_MVTO"], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MVTO"], "where": ["OPERACAO  = 'E' AND DEPOSITO IN (${depositosEmpresaLogada})"]}`, "Pesquisa Documento");
  } else {
    $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"PA_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, DT_MVTO DESCRICAO"], "where": ["OPERACAO = 'E'"] }`, [], [], []);
    $("#btnDocumentoMovimentacao").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MVTO"], `{"tabela":"PA_MOV", "camposSelect":[ "NUM_DOCTO", "DT_MVTO"], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MVTO"], "where": ["OPERACAO  = 'E'"]}`, "Pesquisa Documento");
  }

  try {
    let response = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"material",
      "camposSelect":["CODIGO"],
      "where": ["1=1"], "limit": 10}`,
      null
    );
    let jsonStr = await response.json();

    if (jsonStr.RESULT[0].length < 1) {
      $(".escondeRadio").addClass("d-none");
    }
  } catch (error) {
    console.error(error);
  }

  $('body').keydown(function (e) {
    if (e.keyCode == 117) {
      e.preventDefault();
      $('#modalImportacao').modal('show');
    }
  });

  $("#txtVolumes").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 0,
  });
  $("#txtPesoBruto").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtPesoLiq").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtDescontoTotal").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtFreteTotal").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtDespesaTotal").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtValorRef").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });
  $("#txtPesoRef").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtPercIndice").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  if (bUsaIndice) {
    $('#txtPercIndice').removeClass('d-none');
  }

  $(".next").click(async function () {
    let validator = $("#msform").validate();
    let erros = 0;

    if ($(this).attr("id") == "avancar1") {
      if ($("#txtDeposito").val() != "") {
        const deposito = await buscaValor(
          "DEPOSITO",
          "ATIVO",
          "CODIGO",
          pegaChave("#txtDeposito")
        );

        if (deposito.ATIVO != "S") {
          msgAlerta(
            "Depósito inativo, impossível realizar faturamento no mesmo!"
          );
          return;
        }
      }

      validator.element("#txtCliente");
      validator.element("#txtDeposito");
      if ($("#rgTransportador").val() != "9") {
        validator.element("#txtTransportadora");
        if (
          validator.element("#txtCliente") &&
          validator.element("#txtDeposito") &&
          validator.element("#txtTransportadora")
        ) {
          erros = 0;
        } else {
          erros = 1;
        }
      } else if (
        validator.element("#txtCliente") &&
        validator.element("#txtDeposito")
      ) {
        erros = 0;
      } else {
        erros = 1;
      }

      try {
        let nota = {};
        nota.NATUREZA = pegaChave("#txtNatureza", nota.NATUREZA);
        if ($("#txtReducao").val() != "") {
          nota.OPERACAO = pegaChave("#txtReducao", nota.OPERACAO);
        }

        if ($('#txtNumeroVenda').val() == '') {
          let response = await requisicao(
            "GET",
            "/Sisplan/NFe/v1/MovimentaEstoque?",
            `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
            null
          );
          let jsonStr = await response.json();
          $("#movEstoqueCheck").prop("checked", jsonStr == -1);
        } else {
          $("#movEstoqueCheck").prop("checked", false);
        }
      } catch (error) {
        console.error(error);
      }

      if (bNaturezaDevolucao && ($('#tabelaNotasRef').DataTable().rows().count() == 0)) {
        msgAlerta('Nota com natureza de devolução e nenhuma nota referenciada, impossível continuar.\nFavor referenciar ao menos uma nota.');
        return;
      }
    }

    if ($(this).attr("id") == "avancarItens") {

      if ($("#txtNatureza").val() == "") {
        if ($(`#txtCFOP-0`).val() == '') {
          msgAlerta('Item sem natureza informada, favor verificar.');
          return;
        } else {
          $("#txtNatureza").val($(`#txtCFOP-0`).val());
        }
      }

      if (!validaDadosItens()) {
        return;
      }

      if (($('#txtFreteTotal').val() > 0) && (($('txtTransportadora').val() == '') || ($('#rgTransportador').val() == '9'))) {
        erros = 1;
        msgAlerta('Necessário preencher os campos de transporte (Frete por Conta e Transportadora).');
        return;
      }

      erros = 0;
      if ($("#financeiroFs").hasClass("d-none")) {
        setTimeout(function () {
          $("#avancarFinanceiro").trigger("click");
        }, 150);
      }
      if (
        parseFloat(
          $("#txtValorNota")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        ) == 0
      ) {
        msgAlerta("Valor da nota igual ou inferior a R$0.00, favor verificar.");
        erros = 1;
      } else if (
        parseFloat(
          $("#txtValorNota")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
            .replace(";", "-")
        ) < 0
      ) {
        msgAlerta("Valor da nota igual ou inferior a R$0.00, favor verificar.");
        erros = 1;
      }
    }

    if (
      $(this).attr("id") == "avancarFinanceiro" &&
      !$("#financeiroFs").hasClass("d-none")
    ) {
      validator.element("#txtMoeda");
      validator.element("#txtHistorico");
      validator.element("#txtBanco");
      validator.element("#txtSituacao");
      validator.element("#txtClasseGer");
      if (
        validator.element("#txtMoeda") &&
        validator.element("#txtHistorico") &&
        validator.element("#txtBanco") &&
        validator.element("#txtSituacao") &&
        validator.element("#txtClasseGer")
      ) {
        erros = 0;
      } else {
        erros = 1;
      }
      const naturezaGeraReceber = await buscaNaturezaGeraReceber();
      const regraGeraReceber = await buscaRegraGeraReceber();

      if (naturezaGeraReceber) {
        if ($("#tabelaDuplicatas").DataTable().data().toArray().length <= 0) {
          throw msgAlerta("Natureza informada gera receber e os vencimentos não foram informados, necessário preencher os vencimentos para prosseguir.");
        }
      }

      if (regraGeraReceber) {
        if ($("#tabelaDuplicatas").DataTable().data().toArray().length <= 0) {
          throw msgAlerta("Operação informada gera receber e os vencimentos não foram informados, necessário preencher os vencimentos para prosseguir.");
        }
      }

    }

    if (erros == 0) {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      await calculaPesoItens();
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
    }
  });

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtCliente: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtTransportadora: {
        required: true,
      },
      "txtProduto-0": {
        required: true,
      },
      "txtQuantidade-0": {
        required: true,
      },
      "txtPreco-0": {
        required: true,
      },
      txtNatureza: {
        required: true,
      },
      txtMoeda: {
        required: true,
      },
      txtHistorico: {
        required: true,
      },
      txtBanco: {
        required: true,
      },
      txtSituacao: {
        required: true,
      },
      txtClasseGer: {
        required: true,
      },
    },
    messages: {
      txtCliente: {
        required: "Informe um cliente válido.",
      },
      txtNatureza: {
        required: "Informe uma natureza válida.",
      },
      txtDeposito: {
        required: "Informe um depósito válido.",
      },
      txtTransportadora: {
        required: "Informe uma transportadora válida.",
      },
      "txtProduto-0": {
        required: "Informe um produto válido.",
      },
      "txtQuantidade-0": {
        required: "Informe uma quantidade válida.",
      },
      "txtPreco-0": {
        required: "Informe um preço válido.",
      },
      txtMoeda: {
        required: "Informe uma moeda válida.",
      },
      txtHistorico: {
        required: "Informe um histórico válido.",
      },
      txtBanco: {
        required: "Informe um banco válido.",
      },
      txtSituacao: {
        required: "Informe uma situação válida.",
      },
      txtClasseGer: {
        required: "Informe uma classe válida.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $(".previous").click(async function () {
    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();

    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");

    previousFs.show();

    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
    await calculaPesoItens();
    $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
  });

  $(".radio-group .radio").click(function () {
    $(this).parent().find(".radio").removeClass("selected");
    $(this).addClass("selected");
  });

  $(".submit").click(function () {
    return false;
  });
});

let queryString = window.location.href;
let parametros = queryString.split("/");
let notaUrl = parametros[parametros.length - 1];
let calculaPeso = "";
let estaNaArqLocal = "";
let bNaturezaDevolucao = false;
let decimais = parseInt(CopiaParametro("SISTEMA", 1)) + 2;

if (notaUrl != "create") {
  let notaVenda = jQuery.parseJSON(descriptografaUrl(parametros[parametros.length - 1]));

  insereValor("#txtNumeroVenda", notaVenda.CODVEN, pegaDescricao(notaVenda.CLIENTE));
  $("#txtOperacaoVenda").val(notaVenda.OPERACAO);
  $("#txtReducao").val(notaVenda.OPERACAO);
  $("#txtNaturezaVenda").val(notaVenda.NATUREZA);
  $("#txtNatureza").val(notaVenda.NATUREZA);
  $("#txtCliente").val(notaVenda.CLIENTE);

  $('#tabelaVendas').DataTable().row.add([botaoSelecionarGrid(), notaVenda.CODVEN, notaVenda.CLIENTE]).draw(false);

  let vendas = [];
  $('#tabelaVendas').DataTable().rows().data().map((item) => { vendas.push(item[1]) });

  escondeFs();
  faturarVenda(notaVenda.CODVEN, pegaChave(notaVenda.NATUREZA), pegaChave(notaVenda.OPERACAO), vendas, pegaChave("#txtCliente"));

  $("#movEstoqueCheck").prop("checked", false);

  $("#txtCliente").val(notaVenda.CLIENTE);
  $("#txtCliente").trigger("blur");
  if (notaVenda.CODVEN != '') {
    buscaNFCEVinculado();
    buscaNFEVinculado(notaVenda.CODVEN);
  }
}

async function carregaValoresPadroes() {
  const pesquisa = {
    camposSelect: ['CAMPO', 'VALOR'],
    tabela: 'TABPADRAO',
    where: [`TABELA = 'NOTA'`]
  }
  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

  jsonStr.map(item => {
    switch (item.CAMPO) {
      case 'NATUREZA': {
        if (item.VALOR != '') {
          insereValor('#txtNatureza', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          insereValor('#txtNaturezaVenda', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          insereValor('#txtNaturezaNota', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
          insereValor('#txtNaturezaMovimentacao', item.VALOR, { tabela: 'NATUREZA', campoBusca: 'DESCRICAO', campoWhere: 'NATUREZA', valorWhere: item.VALOR });
        }
        break;
      }
      case 'OPERACAO': {
        if (item.VALOR != '') {
          insereValor('#txtReducao', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          insereValor('#txtOperacaoVenda', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          insereValor('#txtOperacaoNota', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          insereValor('#txtOperacaoMovimentacao', item.VALOR, { tabela: 'OPER_FISCAL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
        }
        break;
      }
      case 'DEPOSITO': {
        if (item.VALOR != '') {
          insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
        }
        break;
      }
      case 'PRESENCA': {
        if (item.VALOR != '') {
          $('#rgPresenca').val(item.VALOR).change();
        }
        break;
      }
      case 'MOEDA': {
        if (item.VALOR != '') {
          insereValor('#txtMoeda', item.VALOR, { tabela: 'MOEDA', campoBusca: 'DESCRICAO', campoWhere: 'CODMOE', valorWhere: item.VALOR });
        }
        break;
      }
      case 'HISTORICO': {
        if (item.VALOR != '') {
          insereValor('#txtHistorico', item.VALOR, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: item.VALOR });
        }
        break;
      }
      case 'BANCO': {
        if (item.VALOR != '') {
          insereValor('#txtBanco', item.VALOR, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: item.VALOR });
        }
        break;
      }
      case 'SITUACAO': {
        if (item.VALOR != '') {
          insereValor('#txtSituacao', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
        }
        break;
      }
      case 'CLASSE_GERENCIAL': {
        if (item.VALOR != '') {
          insereValor('#txtClasseGer', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
        }
        break;
      }
    }
  });
};

async function carregaValoresPadroesFinanceiro() {
  const pesquisa = {
    camposSelect: ['CAMPO', 'VALOR'],
    tabela: 'TABPADRAO',
    where: [`TABELA = 'NOTA'`]
  }
  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

  jsonStr.map(async item => {
    switch (item.CAMPO) {
      case 'MOEDA': {
        if (item.VALOR != '') {
          const descMoeda = await buscaValor('MOEDA', 'DESCRICAO', 'CODMOE', item.VALOR);
          insereValor('#txtMoeda', item.VALOR, descMoeda.DESCRICAO);
        }
        break;
      }
      case 'HISTORICO': {
        if (item.VALOR != '') {
          const descHistorico = await buscaValor('HISTCP', 'DESCRICAO', 'HISTORICO', item.VALOR);
          insereValor('#txtHistorico', item.VALOR, descHistorico.DESCRICAO);
        }
        break;
      }
      case 'BANCO': {
        if (item.VALOR != '') {
          const descBanco = await buscaValor('CADBAN', 'NOME_BANCO', 'BANCO', item.VALOR);
          insereValor('#txtBanco', item.VALOR, descBanco.NOME_BANCO);
        }
        break;
      }
      case 'SITUACAO': {
        if (item.VALOR != '') {
          const descSituacao = await buscaValor('TABSIT', 'DESCRICAO', 'CODIGO', item.VALOR);
          insereValor('#txtSituacao', item.VALOR, descSituacao.DESCRICAO);
        }
        break;
      }
      case 'CLASSE_GERENCIAL': {
        if (item.VALOR != '') {
          const descClasse = await buscaValor('CLASSE_GER', 'DESCRICAO', 'CODIGO', item.VALOR);
          insereValor('#txtClasseGer', item.VALOR, descClasse.DESCRICAO);
        }
        break;
      }
    }
  });
};

async function atualizaTotaisNota(indice) {
  let desconto = parseFloat($("#txtDescontoTotal").val());
  let totValorNota;
  let totQtde;
  let totalIcms;
  let totalIpi;
  let valorBruto;
  let totalPis;
  let totalCofins;
  let baseIcmsst;
  let totalIcmsst;
  let baseIpi;
  let baseIcms;
  let basePisCofins;

  if (desconto != 0) {
    aplicaDesconto();
  } else {
    try {
      if (
        $("#txtValorNota")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totValorNota = 0;
      } else {
        totValorNota = parseFloat(
          $("#txtValorNota")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtBasePISCOFINS")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        basePisCofins = 0;
      } else {
        basePisCofins = parseFloat(
          $("#txtBasePISCOFINS")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtBaseIPI")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        baseIpi = 0;
      } else {
        baseIpi = parseFloat(
          $("#txtBaseIPI")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtBaseICMS")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        baseIcms = 0;
      } else {
        baseIcms = parseFloat(
          $("#txtBaseICMS")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtBaseICMS")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totValorItens = 0;
      } else {
        totValorItens = parseFloat(
          $("#txtBaseICMS")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      totQtde = 0;

      if (
        $("#txtValorICMS")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totalIcms = 0;
      } else {
        totalIcms = parseFloat(
          $("#txtValorICMS")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtTotalIPI")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totalIpi = 0;
      } else {
        totalIpi = parseFloat(
          $("#txtTotalIPI")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtValorBruto")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        valorBruto = 0;
      } else {
        valorBruto = parseFloat(
          $("#txtValorBruto")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtValorPIS")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totalPis = 0;
      } else {
        totalPis = parseFloat(
          $("#txtValorPIS")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtValorCofins")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totalCofins = 0;
      } else {
        totalCofins = parseFloat(
          $("#txtValorCofins")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtBaseICMSST")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        baseIcmsst = 0;
      } else {
        baseIcmsst = parseFloat(
          $("#txtBaseICMSST")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      if (
        $("#txtValorICMSST")
          .html()
          .substring(8)
          .replace(".", "")
          .replace(",", ".") == ""
      ) {
        totalIcmsst = 0;
      } else {
        totalIcmsst = parseFloat(
          $("#txtValorICMSST")
            .html()
            .substring(8)
            .replace(".", "")
            .replace(",", ".")
        );
      }

      desconto = parseFloat($("#txtDescontoTotal").val());

      const i =
        typeof indice !== "string"
          ? indice[0].id.split("-")[1]
          : Number(indice);

      if ($(seletorPorNome("txtProduto", i)).val() != "") {
        if (
          $(seletorPorNome("txtPreco", i)).val() != "" &&
          $(seletorPorNome("txtQuantidade", i)).val() != ""
        ) {
          let nota = {};
          nota.CODCLI = pegaChave("#txtCliente", nota.CODCLI);
          nota.DTEMISSAO = $("#txtDataEmissao").val();
          nota.DESCONTO = $("#txtDescontoTotal").val();
          nota.NATUREZA = pegaChave(
            seletorPorNome("txtCFOP", i),
            nota.NATUREZA
          );
          nota.OPERACAO = pegaChave("#txtReducao", nota.OPERACAO);
          nota.ESTOQUE = "S";
          if ($("#txtNumeroVenda").val() != "") {
            nota.ESTOQUE = "N";
            nota.CODVEN = pegaChave("#txtNumeroVenda", nota.CODVEN);
          }
          nota.ESTOQUE = $("#movEstoqueCheck").prop("checked") ? "S" : "N";
          nota.CODVEN = pegaChave("#txtNumeroVenda");

          if ($("#consumidorFinal").prop("checked")) {
            nota.CONSUMIDORFINAL = "Sim";
          } else {
            nota.CONSUMIDORFINAL = "Nao";
          }
          if ($("#gerarDifal").prop("checked")) {
            nota.GERARDIFAL = "Sim";
          } else {
            nota.GERARDIFAL = "Nao";
          }
          let arrayItem = [];
          if (
            $(seletorPorNome("txtProduto", i)).attr("data-codigo") !=
            undefined &&
            $(seletorPorNome("txtProduto", i)).attr("data-codigo") != ""
          ) {
            let item = {};
            item.CODIGO = $(seletorPorNome("txtProduto", i)).attr("data-codigo");
            item.COR = $(seletorPorNome("txtProduto", i)).attr("data-cor");
            item.TIPOITEM = $(seletorPorNome("txtProduto", i)).attr("data-tipo");
            if (item.TIPOITEM == 'P') {
              item.TAMANHO = $(seletorPorNome("txtProduto", i)).attr("data-tam");
            }
            item.DEPOSITO = pegaChave("#txtDeposito", item.DEPOSITO);
            item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", i)).val());
            item.PRECO = parseFloat($(seletorPorNome("txtPreco", i)).val());
            item.NATUREZA = pegaChave(
              seletorPorNome("txtCFOP", i),
              item.NATUREZA
            );
            item.VALOR = item.PRECO * item.QTDE;
            if (
              nota.DESCONTO != 0 &&
              nota.DESCONTO != "" &&
              nota.DESCONTO != undefined
            ) {
              let divideRateio = 0;
              let rateio = 0;
              divideRateio = $("#txtValorBruto")
                .html()
                .substring(8)
                .replace(".", "")
                .replace(",", ".");
              rateio =
                (parseFloat(nota.DESCONTO) *
                  parseFloat(item.VALOR.toFixed(2))) /
                divideRateio;
              item.VALORDESC = parseFloat(rateio.toFixed(2));
            }
            item.PERCIPI = parseFloat($(seletorPorNome("txtIPI", i)).val());
            item.PERCICMS = parseFloat($(seletorPorNome("txtICMS", i)).val());
            item.ENQUADRA = pegaChave(
              seletorPorNome("txtEnquadra", i),
              item.ENQUADRA
            );
            item.CLACSOSN = pegaChave(
              seletorPorNome("txtCsosn", i),
              item.CLACSOSN
            );
            item.CLATRIB = pegaChave(
              seletorPorNome("txtCstIcms", i),
              item.CLATRIB
            );
            item.CLAIPI = pegaChave(
              seletorPorNome("txtCstIpi", i),
              item.CLAIPI
            );
            item.CLAPIS = pegaChave(
              seletorPorNome("txtCstPis", i),
              item.CLAPIS
            );
            item.CLACOFINS = pegaChave(
              seletorPorNome("txtCstCofins", i),
              item.CLACOFINS
            );
            item.CLAFIS = pegaChave(seletorPorNome("txtNCM", i), item.CLAFIS);
            arrayItem.push(item);
          }
          nota.ITENS = arrayItem;

          try {
            let response = await requisicao(
              "GET",
              "/Sisplan/NFe/v1/RetornaValItem?",
              `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
              null
            );
            let jsonStr = await response.json();

            if (((!jsonStr.itens[0].possuiEstoque) && (nota.CODVEN == '')) && isChecked('#movEstoqueCheck')) {
              msgAlerta('Item com quantidade insuficiente, favor verificar.');
              $(`#txtQuantidade-${i}`).val('0.00');
              return;
            }

            $(`#txtICMS-${i}`).val(
              parseFloat(jsonStr.itens[0].percICMS).toFixed(2)
            );
            $(`#txtIPI-${i}`).val(
              parseFloat(jsonStr.itens[0].percIpi).toFixed(2)
            );

            if (jsonStr.itens[0].geraDupli == 'S') {
              $("#financeiroFs").removeClass("d-none");
              $("#personal").removeClass("d-none");
              $("#progressbar li").css("width", "25%");
            }

            insereValor(
              seletorPorNome("txtCFOP", i),
              jsonStr.itens[0].natureza,
              jsonStr.itens[0].descNatureza
            );
            insereValor(
              seletorPorNome("txtNCM", i),
              jsonStr.itens[0].claFis,
              jsonStr.itens[0].descClaFis
            );
            insereValor(
              seletorPorNome("txtEnquadra", i),
              jsonStr.itens[0].enquadra,
              jsonStr.itens[0].descEnquadra
            );
            insereValor(
              seletorPorNome("txtCsosn", i),
              jsonStr.itens[0].claCSOSN,
              jsonStr.itens[0].descClaCSOSN
            );
            insereValor(
              seletorPorNome("txtCstIcms", i),
              jsonStr.itens[0].claTrib,
              jsonStr.itens[0].descClaTrib
            );
            insereValor(
              seletorPorNome("txtCstIpi", i),
              jsonStr.itens[0].claIPI,
              jsonStr.itens[0].descClaIPI
            );
            insereValor(
              seletorPorNome("txtCstPis", i),
              jsonStr.itens[0].claPis,
              jsonStr.itens[0].descClaPis
            );
            insereValor(
              seletorPorNome("txtCstCofins", i),
              jsonStr.itens[0].claCofins,
              jsonStr.itens[0].descClaCofins
            );
            limpaValoresIncorretos(seletorPorNome("txtCFOP", i));
            limpaValoresIncorretos(seletorPorNome("txtNCM", i));
            limpaValoresIncorretos(seletorPorNome("txtEnquadra", i));
            limpaValoresIncorretos(seletorPorNome("txtCsosn", i));
            limpaValoresIncorretos(seletorPorNome("txtCstIcms", i));
            limpaValoresIncorretos(seletorPorNome("txtCstIpi", i));
            limpaValoresIncorretos(seletorPorNome("txtCstPis", i));
            limpaValoresIncorretos(seletorPorNome("txtCstCofins", i));

            let valorProduto = $(seletorPorNome("txtValorProduto", i)).val();
            let valorBrutoProduto = $(seletorPorNome("txtValorBruto", i)).val();
            let totalValorItensProduto = $(
              seletorPorNome("txtTotValorItens", i)
            ).val();
            let totalIcmsProduto = $(seletorPorNome("txtTotalIcms", i)).val();
            let totalIpiProduto = $(seletorPorNome("txtTotalIpi", i)).val();
            let totalPisProduto = $(seletorPorNome("txtTotalPis", i)).val();
            let totalCofinsProduto = $(seletorPorNome("txtTotalCofins", i)).val();
            let totalICMSSTProduto = $(seletorPorNome("txtTotalICMSST", i)).val();
            let totalBaseICMSSTProduto = $(seletorPorNome("txtBaseST", i)).val();
            let totalBaseICMSProduto = $(seletorPorNome("txtBaseICMS", i)).val();
            let totalBaseIPIProduto = $(seletorPorNome("txtBaseIPI", i)).val();
            let totalBasePISCOFINSProduto = $(seletorPorNome("txtBasePISCOFINS", i)).val();

            totValorNota += jsonStr.itens[0].valorLiq - valorProduto;
            valorBruto += jsonStr.itens[0].valor - valorBrutoProduto;
            totValorItens += jsonStr.itens[0].baseICMS - totalValorItensProduto;
            totalIcms += jsonStr.itens[0].valorICMS - totalIcmsProduto;
            totalIpi += jsonStr.itens[0].valorIPI - totalIpiProduto;
            totalPis += jsonStr.itens[0].valorPis - totalPisProduto;
            totalCofins += jsonStr.itens[0].valorCofins - totalCofinsProduto;
            totalIcmsst += jsonStr.itens[0].valorICMSST - totalICMSSTProduto;
            baseIcmsst += jsonStr.itens[0].baseICMSST - totalBaseICMSSTProduto;
            baseIcms += jsonStr.itens[0].baseICMS - totalBaseICMSProduto;
            baseIpi += jsonStr.itens[0].baseIPI - totalBaseIPIProduto;
            basePisCofins += jsonStr.itens[0].basePisCofins - totalBasePISCOFINSProduto;

            $(seletorPorNome("txtValorProduto", i)).val(jsonStr.itens[0].valorLiq);
            $(seletorPorNome("txtValorBruto", i)).val(jsonStr.itens[0].valor);
            $(seletorPorNome("txtTotQtde", i)).val(jsonStr.itens[0].qtde);
            $(seletorPorNome("txtTotValorItens", i)).val(jsonStr.itens[0].baseICMS);
            $(seletorPorNome("txtTotalIcms", i)).val(jsonStr.itens[0].valorICMS);
            $(seletorPorNome("txtTotalIpi", i)).val(jsonStr.itens[0].valorIPI);
            $(seletorPorNome("txtTotalPis", i)).val(jsonStr.itens[0].valorPis);
            $(seletorPorNome("txtTotalCofins", i)).val(jsonStr.itens[0].valorCofins);
            $(seletorPorNome("txtTotalICMSST", i)).val(jsonStr.itens[0].valorICMSST);
            $(seletorPorNome("txtBaseST", i)).val(jsonStr.itens[0].baseICMSST);
            $(seletorPorNome("txtBaseICMS", i)).val(jsonStr.itens[0].baseICMS);
            $(seletorPorNome("txtBaseIPI", i)).val(jsonStr.itens[0].baseIPI);
            $(seletorPorNome("txtBasePISCOFINS", i)).val(jsonStr.itens[0].basePisCofins);
          } catch (error) {
            console.error(error);
          }
        }
      }
    } finally {
      let itens = $(".itens");
      for (let y = 0; y < itens.length; y++) {
        if ($(seletorPorNome("txtProduto", y)).val() != "") {
          totQtde += parseFloat($(seletorPorNome("txtQuantidade", y)).val());
        }
      }
    }

    totQtde = totQtde.toFixed(2);

    $("#txtDesconto").html(
      parseFloat(desconto).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtBaseICMSST").html(
      parseFloat(baseIcmsst).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorICMSST").html(
      parseFloat(totalIcmsst).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorPIS").html(
      parseFloat(totalPis).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorCofins").html(
      parseFloat(totalCofins).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorNota").html(
      parseFloat(totValorNota).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorFinanceiro").html(
      parseFloat(totValorNota).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    // $("#txtBaseICMS").html(
    //   parseFloat(totValorItens).toLocaleString("pt-BR", {
    //     style: "currency",
    //     currency: "BRL",
    //   })
    // );

    $("#txtBaseICMS").html(
      parseFloat(baseIcms).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtBaseIPI").html(
      parseFloat(baseIpi).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtBasePISCOFINS").html(
      parseFloat(basePisCofins).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorICMS").html(
      parseFloat(totalIcms).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtTotalIPI").html(
      parseFloat(totalIpi).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtValorBruto").html(
      parseFloat(valorBruto).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    $("#txtQuantidade").html(parseFloat(totQtde));

    simulaFinanceiro();
  }
}

$("#btnConfirmarDesc").click(async function () {
  aplicaDesconto();
  $("#modalDesconto").modal("hide");
});

$("#btnConfirmarFrete").click(async function () {
  aplicaDesconto();
  $("#modalFrete").modal("hide");
});

$("#btnConfirmarDespesa").click(async function () {
  aplicaDesconto();
  $("#modalDespesa").modal("hide");
});

$("#txtDespesaTotal, #txtFreteTotal, #txtDescontoTotal").change(async function () {
  calculaTotaisItens();
});

function retornaBotaoExcluir() {
  return (
    '<div class="divBtnOpcoes"> ' +
    '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
    '</div>'
  );
}

function seletorPorNome(name, i) {
  return `.item-${i}>div>input[name*="${name}"]`;
}

function limpaValoresIncorretos(seletor) {
  if ($(seletor).val() == "[] - ") {
    $(seletor).val("");
  }
}

function incrementaProdutoExistente(sCodigo, sCor, sTam, iQtde) {
  let retorno = false;
  $(".itens")
    .toArray()
    .forEach((item, index) => {
      if (
        $(seletorPorNome("txtProduto", index)).attr("data-codigo") == sCodigo &&
        $(seletorPorNome("txtProduto", index)).attr("data-cor") == sCor &&
        $(seletorPorNome("txtProduto", index)).attr("data-tam") == sTam
      ) {
        $(seletorPorNome("txtQuantidade", index)).val(
          +$(seletorPorNome("txtQuantidade", index)).val() + iQtde
        );
        retorno = true;
      }
    });
  return retorno;
}

function removeProdutosVazios() {
  const ultimoIndice = $(".itens").length - 1;
  $(".itens")
    .toArray()
    .forEach((item, indice) => {
      if (
        indice != ultimoIndice &&
        $(seletorPorNome("txtProduto", indice)).val() === ""
      ) {
        $($(`.item-${indice}>button:eq(1)`)[0]).click();
      }
    });
}

async function aplicaDesconto() {
  $.LoadingOverlay("show");
  let desconto = $("#txtDescontoTotal").val();
  let frete = $("#txtFreteTotal").val();
  let despesa = $("#txtDespesaTotal").val();
  let totValorNota = 0;
  let totValorItens = 0;
  let totQtde = 0;
  let totalIcms = 0;
  let totalIpi = 0;
  let valorBruto = 0;
  let totalPis = 0;
  let totalCofins = 0;
  let totalIcmsst = 0;
  let baseIcmsst = 0;
  let baseIpi = 0;
  let baseIcms = 0;
  let basePisCofins = 0;

  try {
    let itens = $(".itens");
    for (let i = 0; i < itens.length; i++) {
      if ($(seletorPorNome("txtProduto", i)).val() != "") {
        if (
          $(seletorPorNome("txtPreco", i)).val() != "" &&
          $(seletorPorNome("txtQuantidade", i)).val() != ""
        ) {
          let nota = {};
          nota.CODCLI = pegaChave("#txtCliente", nota.CODCLI);
          nota.DTEMISSAO = $("#txtDataEmissao").val();
          nota.DESCONTO = $("#txtDescontoTotal").val();
          nota.NATUREZA = pegaChave(
            seletorPorNome("txtCFOP", i),
            nota.NATUREZA
          );
          nota.OPERACAO = pegaChave("#txtReducao", nota.OPERACAO);
          nota.VALFRETE = $("#txtFreteTotal").val();
          nota.VALDESPESAS = $("#txtDespesaTotal").val();
          // nota.VALOR = totValorNota.toFixed(2);
          nota.ESTOQUE = "S";
          if ($("#txtNumeroVenda").val() != "") {
            nota.ESTOQUE = "N";
            nota.CODVEN = pegaChave("#txtNumeroVenda", nota.CODVEN);
          }
          nota.ESTOQUE = $("#movEstoqueCheck").prop("checked") ? "S" : "N";

          if ($("#consumidorFinal").prop("checked")) {
            nota.CONSUMIDORFINAL = "Sim";
          } else {
            nota.CONSUMIDORFINAL = "Nao";
          }
          if ($("#gerarDifal").prop("checked")) {
            nota.GERARDIFAL = "Sim";
          } else {
            nota.GERARDIFAL = "Nao";
          }
          let arrayItem = [];
          if (
            $(seletorPorNome("txtProduto", i)).attr("data-codigo") !=
            undefined &&
            $(seletorPorNome("txtProduto", i)).attr("data-codigo") != ""
          ) {
            let item = {};
            item.CODIGO = $(seletorPorNome("txtProduto", i)).attr("data-codigo");
            item.COR = $(seletorPorNome("txtProduto", i)).attr("data-cor");
            item.TIPOITEM = $(seletorPorNome("txtProduto", i)).attr("data-tipo");
            if (item.TIPOITEM == 'P') {
              item.TAMANHO = $(seletorPorNome("txtProduto", i)).attr("data-tam");
            }
            item.DEPOSITO = pegaChave("#txtDeposito", item.DEPOSITO);
            item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", i)).val());
            item.PRECO = parseFloat($(seletorPorNome("txtPreco", i)).val());
            item.NATUREZA = pegaChave(
              seletorPorNome("txtCFOP", i),
              item.NATUREZA
            );
            item.VALOR = item.PRECO * item.QTDE;
            if (
              nota.DESCONTO != 0 &&
              nota.DESCONTO != "" &&
              nota.DESCONTO != undefined
            ) {
              let divideRateio = 0;
              let rateio = 0;
              divideRateio = $("#txtValorBruto")
                .html()
                .substring(8)
                .replace(".", "")
                .replace(",", ".");
              rateio =
                (parseFloat(nota.DESCONTO) *
                  parseFloat(item.VALOR.toFixed(2))) /
                divideRateio;
              item.VALORDESC = parseFloat(rateio.toFixed(2));
            }
            if (
              nota.VALFRETE != 0 &&
              nota.VALFRETE != "" &&
              nota.VALFRETE != undefined
            ) {
              let divideRateio = 0;
              let rateio = 0;
              divideRateio = $("#txtValorBruto")
                .html()
                .substring(8)
                .replace(".", "")
                .replace(",", ".");
              rateio =
                (parseFloat(nota.VALFRETE) *
                  parseFloat(item.VALOR.toFixed(2))) /
                divideRateio;
              item.VALORFRETE = parseFloat(rateio.toFixed(2));
            }
            if (
              nota.VALDESPESAS != 0 &&
              nota.VALDESPESAS != "" &&
              nota.VALDESPESAS != undefined
            ) {
              let divideRateio = 0;
              let rateio = 0;
              divideRateio = $("#txtValorBruto")
                .html()
                .substring(8)
                .replace(".", "")
                .replace(",", ".");
              rateio =
                (parseFloat(nota.VALDESPESAS) *
                  parseFloat(item.VALOR.toFixed(2))) /
                divideRateio;
              item.VALORDESP = parseFloat(rateio.toFixed(2));
            }
            item.PERCIPI = parseFloat($(seletorPorNome("txtIPI", i)).val());
            item.PERCICMS = parseFloat($(seletorPorNome("txtICMS", i)).val());
            item.ENQUADRA = pegaChave(
              seletorPorNome("txtEnquadra", i),
              item.ENQUADRA
            );
            item.CLACSOSN = pegaChave(
              seletorPorNome("txtCsosn", i),
              item.CLACSOSN
            );
            item.CLATRIB = pegaChave(
              seletorPorNome("txtCstIcms", i),
              item.CLATRIB
            );
            item.CLAIPI = pegaChave(
              seletorPorNome("txtCstIpi", i),
              item.CLAIPI
            );
            item.CLAPIS = pegaChave(
              seletorPorNome("txtCstPis", i),
              item.CLAPIS
            );
            item.CLACOFINS = pegaChave(
              seletorPorNome("txtCstCofins", i),
              item.CLACOFINS
            );
            item.CLAFIS = pegaChave(seletorPorNome("txtNCM", i), item.CLAFIS);
            arrayItem.push(item);
          }
          nota.ITENS = arrayItem;
          if (nota.ITENS.length > 0) {
            try {
              let response = await requisicao(
                "GET",
                "/Sisplan/NFe/v1/RetornaValItem?",
                `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
                null,
                300000
              );
              let jsonStr = await response.json();

              $(seletorPorNome("txtICMS", i)).val(
                parseFloat(jsonStr.itens[0].percICMS).toFixed(2)
              );
              $(seletorPorNome("txtIPI", i)).val(
                parseFloat(jsonStr.itens[0].percIpi).toFixed(2)
              );

              if (jsonStr.itens[0].geraDupli == 'S') {
                $("#financeiroFs").removeClass("d-none");
                $("#personal").removeClass("d-none");
                $("#progressbar li").css("width", "25%");
              }

              insereValor(
                seletorPorNome("txtCFOP", i),
                jsonStr.itens[0].natureza,
                jsonStr.itens[0].descNatureza
              );
              insereValor(
                seletorPorNome("txtNCM", i),
                jsonStr.itens[0].claFis,
                jsonStr.itens[0].descClaFis
              );
              insereValor(
                seletorPorNome("txtEnquadra", i),
                jsonStr.itens[0].enquadra,
                jsonStr.itens[0].descEnquadra
              );
              insereValor(
                seletorPorNome("txtCsosn", i),
                jsonStr.itens[0].claCSOSN,
                jsonStr.itens[0].descClaCSOSN
              );
              insereValor(
                seletorPorNome("txtCstIcms", i),
                jsonStr.itens[0].claTrib,
                jsonStr.itens[0].descClaTrib
              );
              insereValor(
                seletorPorNome("txtCstIpi", i),
                jsonStr.itens[0].claIPI,
                jsonStr.itens[0].descClaIPI
              );
              insereValor(
                seletorPorNome("txtCstPis", i),
                jsonStr.itens[0].claPis,
                jsonStr.itens[0].descClaPis
              );
              insereValor(
                seletorPorNome("txtCstCofins", i),
                jsonStr.itens[0].claCofins,
                jsonStr.itens[0].descClaCofins
              );

              $(`#txtBaseIPI${i}`).val(jsonStr.itens[0].baseIPI);
              $(`#txtBaseICMS${i}`).val(jsonStr.itens[0].baseICMS);
              $(`#txtBasePISCOFINS${i}`).val(jsonStr.itens[0].basePisCofins);

              limpaValoresIncorretos(seletorPorNome("txtCFOP", i));
              limpaValoresIncorretos(seletorPorNome("txtNCM", i));
              limpaValoresIncorretos(seletorPorNome("txtEnquadra", i));
              limpaValoresIncorretos(seletorPorNome("txtCsosn", i));
              limpaValoresIncorretos(seletorPorNome("txtCstIcms", i));
              limpaValoresIncorretos(seletorPorNome("txtCstIpi", i));
              limpaValoresIncorretos(seletorPorNome("txtCstPis", i));
              limpaValoresIncorretos(seletorPorNome("txtCstCofins", i));

              $(`#txtValorProduto${i}`).val(jsonStr.itens[0].valorLiq);
              $(`#txtValorBruto${i}`).val(jsonStr.itens[0].valor);
              $(`#txtTotQtde${i}`).val(jsonStr.itens[0].qtde);
              $(`#txtTotValorItens${i}`).val(jsonStr.itens[0].baseICMS);
              $(`#txtTotalIcms${i}`).val(jsonStr.itens[0].valorICMS);
              $(`#txtTotalIpi${i}`).val(jsonStr.itens[0].valorIPI);
              $(`#txtTotalPis${i}`).val(jsonStr.itens[0].valorPis);
              $(`#txtTotalCofins${i}`).val(jsonStr.itens[0].valorCofins);
              $(`#txtTotalICMSST${i}`).val(jsonStr.itens[0].valorICMSST);
              $(`#txtBaseST${i}`).val(jsonStr.itens[0].baseICMSST);
              $(`#txtBaseIPI${i}`).val(jsonStr.itens[0].baseIPI);
              $(`#txtBaseICMS${i}`).val(jsonStr.itens[0].baseICMS);
              $(`#txtBasePISCOFINS${i}`).val(jsonStr.itens[0].basePisCofins);

              totValorNota += jsonStr.itens[0].valorLiq;
              valorBruto += jsonStr.itens[0].valor;
              totQtde += jsonStr.itens[0].qtde;
              totValorItens += jsonStr.itens[0].baseICMS;
              totalIcms += jsonStr.itens[0].valorICMS;
              totalIpi += jsonStr.itens[0].valorIPI;
              totalPis += jsonStr.itens[0].valorPis;
              totalCofins += jsonStr.itens[0].valorCofins;
              totalIcmsst += jsonStr.itens[0].valorICMSST;
              baseIcmsst += jsonStr.itens[0].baseICMSST;
              baseIcms += jsonStr.itens[0].baseICMS;
              baseIpi += jsonStr.itens[0].baseIPI;
              basePisCofins += jsonStr.itens[0].basePisCofins;
            } catch (error) {
              console.error(error);
            }
          }
        }
      }
    }
  } finally {
    $.LoadingOverlay("hide");
  }

  totQtde = totQtde.toFixed(2);

  if (parseFloat(totalIpi) == 0 || totalIpi == "" || isNaN(totalIpi)) {
    totalIpi = 0;
  }

  if (
    parseFloat($("#txtDescontoTotal").val()) == 0 ||
    $("#txtDescontoTotal").val() == "" ||
    isNaN($("#txtDescontoTotal").val())
  ) {
    desconto = 0;
    $("#txtDescontoTotal").val(desconto);
  }
  if (
    parseFloat($("#txtFreteTotal").val()) == 0 ||
    $("#txtFreteTotal").val() == "" ||
    isNaN($("#txtFreteTotal").val())
  ) {
    frete = 0;
    $("#txtFreteTotal").val(frete);
  }
  if (
    parseFloat($("#txtDespesaTotal").val()) == 0 ||
    $("#txtDespesaTotal").val() == "" ||
    isNaN($("#txtDespesaTotal").val())
  ) {
    despesa = 0;
    $("#txtDespesaTotal").val(despesa);
  }

  totValorNota =
    parseFloat(valorBruto) +
    parseFloat(frete) +
    parseFloat(despesa) +
    parseFloat(totalIpi) +
    parseFloat(totalIcmsst) -
    parseFloat(desconto);

  if (parseFloat(totValorNota) < 0) {
    $("#txtDescontoTotal").val("");
    msgAlerta(
      "Valor de desconto maior que o valor total da nota, impossível continuar."
    );
    return;
  }

  // totValorNota -= desconto;
  $("#txtDesconto").html(
    parseFloat(desconto).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtBaseICMSST").html(
    parseFloat(baseIcmsst).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorICMSST").html(
    parseFloat(totalIcmsst).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorFrete").html(
    parseFloat(frete).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorDespesa").html(
    parseFloat(despesa).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorPIS").html(
    parseFloat(totalPis).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorCofins").html(
    parseFloat(totalCofins).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorNota").html(
    parseFloat(totValorNota).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorFinanceiro").html(
    parseFloat(totValorNota).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  // $("#txtBaseICMS").html(
  //   parseFloat(totValorItens).toLocaleString("pt-BR", {
  //     style: "currency",
  //     currency: "BRL",
  //   })
  // );

  $("#txtBaseICMS").html(
    parseFloat(baseIcms).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtBaseIPI").html(
    parseFloat(baseIpi).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtBasePISCOFINS").html(
    parseFloat(basePisCofins).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorICMS").html(
    parseFloat(totalIcms).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtTotalIPI").html(
    parseFloat(totalIpi).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorBruto").html(
    parseFloat(parseFloat(valorBruto)).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtQuantidade").html(parseFloat(totQtde));

  simulaFinanceiro();
}

async function calculaTotaisItens() {
  $.LoadingOverlay("show");
  let desconto = $("#txtDescontoTotal").val();
  let frete = $("#txtFreteTotal").val();
  let despesa = $("#txtDespesaTotal").val();
  let totValorNota = 0;
  let totValorItens = 0;
  let totQtde = 0;
  let totalIcms = 0;
  let totalIpi = 0;
  let valorBruto = 0;
  let totalPis = 0;
  let totalCofins = 0;
  let totalIcmsst = 0;
  let baseIcmsst = 0;
  let baseIpi = 0;
  let baseIcms = 0;
  let basePisCofins = 0;

  try {
    let itens = $(".itens");

    let nota = {};
    nota.CODCLI = pegaChave("#txtCliente", nota.CODCLI);
    nota.DTEMISSAO = $("#txtDataEmissao").val();
    nota.DESCONTO = $("#txtDescontoTotal").val();
    nota.NATUREZA = pegaChave('#txtNatureza') != '' ? pegaChave('#txtNatureza') : pegaChave(seletorPorNome("txtCFOP", 0), nota.NATUREZA);
    nota.OPERACAO = pegaChave("#txtReducao", nota.OPERACAO);
    nota.VALFRETE = $("#txtFreteTotal").val();
    nota.VALDESPESAS = $("#txtDespesaTotal").val();
    nota.ESTOQUE = "S";
    if ($("#txtNumeroVenda").val() != "") {
      nota.ESTOQUE = "N"; nota.CODVEN = pegaChave("#txtNumeroVenda", nota.CODVEN);
    };
    nota.ESTOQUE = $("#movEstoqueCheck").prop("checked") ? "S" : "N";

    if ($("#consumidorFinal").prop("checked")) {
      nota.CONSUMIDORFINAL = "Sim";
    } else {
      nota.CONSUMIDORFINAL = "Nao";
    }
    if ($("#gerarDifal").prop("checked")) {
      nota.GERARDIFAL = "Sim";
    } else {
      nota.GERARDIFAL = "Nao";
    }

    let arrayItem = [];
    for (let i = 0; i < itens.length; i++) {
      if ($(seletorPorNome("txtProduto", i)).val() != "" && $(seletorPorNome("txtPreco", i)).val() != "" && $(seletorPorNome("txtQuantidade", i)).val() != "") {
        if ($(seletorPorNome("txtProduto", i)).attr("data-codigo") != undefined && $(seletorPorNome("txtProduto", i)).attr("data-codigo") != "") {
          let item = {};
          item.CODIGO = $(seletorPorNome("txtProduto", i)).attr("data-codigo");
          item.COR = $(seletorPorNome("txtProduto", i)).attr("data-cor");
          item.TIPOITEM = $(seletorPorNome("txtProduto", i)).attr("data-tipo");
          if (item.TIPOITEM == 'P') {
            item.TAMANHO = $(seletorPorNome("txtProduto", i)).attr("data-tam");
          }
          item.DEPOSITO = pegaChave("#txtDeposito", item.DEPOSITO);
          item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", i)).val());
          item.PRECO = parseFloat($(seletorPorNome("txtPreco", i)).val());
          item.NATUREZA = pegaChave(
            seletorPorNome("txtCFOP", i),
            item.NATUREZA
          );
          item.VALOR = item.PRECO * item.QTDE;
          if (nota.DESCONTO != 0 && nota.DESCONTO != "" && nota.DESCONTO != undefined) {
            let divideRateio = 0;
            let rateio = 0;
            divideRateio = $("#txtValorBruto").html().substring(8).replace(".", "").replace(",", ".");
            rateio = (parseFloat(nota.DESCONTO) * parseFloat(item.VALOR.toFixed(2))) / divideRateio;
            item.VALORDESC = parseFloat(rateio.toFixed(2));
          }
          if (nota.VALFRETE != 0 && nota.VALFRETE != "" && nota.VALFRETE != undefined) {
            let divideRateio = 0;
            let rateio = 0;
            divideRateio = $("#txtValorBruto").html().substring(8).replace(".", "").replace(",", ".");
            rateio = (parseFloat(nota.VALFRETE) * parseFloat(item.VALOR.toFixed(2))) / divideRateio;
            item.VALORFRETE = parseFloat(rateio.toFixed(2));
          }
          if (nota.VALDESPESAS != 0 && nota.VALDESPESAS != "" && nota.VALDESPESAS != undefined) {
            let divideRateio = 0;
            let rateio = 0;
            divideRateio = $("#txtValorBruto").html().substring(8).replace(".", "").replace(",", ".");
            rateio = (parseFloat(nota.VALDESPESAS) * parseFloat(item.VALOR.toFixed(2))) / divideRateio;
            item.VALORDESP = parseFloat(rateio.toFixed(2));
          }
          item.PERCIPI = parseFloat($(seletorPorNome("txtIPI", i)).val());
          item.PERCICMS = parseFloat($(seletorPorNome("txtICMS", i)).val());
          item.ENQUADRA = pegaChave(seletorPorNome("txtEnquadra", i), item.ENQUADRA);
          item.CLACSOSN = pegaChave(seletorPorNome("txtCsosn", i), item.CLACSOSN);
          item.CLATRIB = pegaChave(seletorPorNome("txtCstIcms", i), item.CLATRIB);
          item.CLAIPI = pegaChave(seletorPorNome("txtCstIpi", i), item.CLAIPI);
          item.CLAPIS = pegaChave(seletorPorNome("txtCstPis", i), item.CLAPIS);
          item.CLACOFINS = pegaChave(seletorPorNome("txtCstCofins", i), item.CLACOFINS);
          item.CLAFIS = pegaChave(seletorPorNome("txtNCM", i), item.CLAFIS);
          arrayItem.push(item);
        }
      }
    }

    nota.ITENS = arrayItem;

    if (nota.ITENS.length == 0) {
      return;
    }

    try {
      const response = await requisicao("POST", "/Sisplan/NFe/v1/RetornaValItem?", '', JSON.stringify(nota), 300000);
      const jsonStr = await response.json();

      jsonStr.itens.map((item, index) => {
        $(seletorPorNome("txtICMS", index)).val(parseFloat(item.percICMS).toFixed(2));
        $(seletorPorNome("txtIPI", index)).val(parseFloat(item.percIpi).toFixed(2));

        if (item.geraDupli == 'S') {
          $("#financeiroFs").removeClass("d-none");
          $("#personal").removeClass("d-none");
          $("#progressbar li").css("width", "25%");
        }

        insereValor(seletorPorNome("txtCFOP", index), item.natureza, item.descNatureza);
        insereValor(seletorPorNome("txtNCM", index), item.claFis, item.descClaFis);
        insereValor(seletorPorNome("txtEnquadra", index), item.enquadra, item.descEnquadra);
        insereValor(seletorPorNome("txtCsosn", index), item.claCSOSN, item.descClaCSOSN);
        insereValor(seletorPorNome("txtCstIcms", index), item.claTrib, item.descClaTrib);
        insereValor(seletorPorNome("txtCstIpi", index), item.claIPI, item.descClaIPI);
        insereValor(seletorPorNome("txtCstPis", index), item.claPis, item.descClaPis);
        insereValor(seletorPorNome("txtCstCofins", index), item.claCofins, item.descClaCofins);

        $(`#txtBaseIPI${index}`).val(item.baseIPI);
        $(`#txtBaseICMS${index}`).val(item.baseICMS);
        $(`#txtBasePISCOFINS${index}`).val(item.basePisCofins);

        limpaValoresIncorretos(seletorPorNome("txtCFOP", index));
        limpaValoresIncorretos(seletorPorNome("txtNCM", index));
        limpaValoresIncorretos(seletorPorNome("txtEnquadra", index));
        limpaValoresIncorretos(seletorPorNome("txtCsosn", index));
        limpaValoresIncorretos(seletorPorNome("txtCstIcms", index));
        limpaValoresIncorretos(seletorPorNome("txtCstIpi", index));
        limpaValoresIncorretos(seletorPorNome("txtCstPis", index));
        limpaValoresIncorretos(seletorPorNome("txtCstCofins", index));

        $(`#txtValorProduto${index}`).val(item.valorLiq);
        $(`#txtValorBruto${index}`).val(item.valor);
        $(`#txtTotQtde${index}`).val(item.qtde);
        $(`#txtTotValorItens${index}`).val(item.baseICMS);
        $(`#txtTotalIcms${index}`).val(item.valorICMS);
        $(`#txtTotalIpi${index}`).val(item.valorIPI);
        $(`#txtTotalPis${index}`).val(item.valorPis);
        $(`#txtTotalCofins${index}`).val(item.valorCofins);
        $(`#txtTotalICMSST${index}`).val(item.valorICMSST);
        $(`#txtBaseST${index}`).val(item.baseICMSST);
        $(`#txtBaseIPI${index}`).val(item.baseIPI);
        $(`#txtBaseICMS${index}`).val(item.baseICMS);
        $(`#txtBasePISCOFINS${index}`).val(item.basePisCofins);

        totValorNota += item.valorLiq;
        valorBruto += item.valor;
        totQtde += item.qtde;
        totValorItens += item.baseICMS;
        totalIcms += item.valorICMS;
        totalIpi += item.valorIPI;
        totalPis += item.valorPis;
        totalCofins += item.valorCofins;
        totalIcmsst += item.valorICMSST;
        baseIcmsst += item.baseICMSST;
        baseIcms += item.baseICMS;
        baseIpi += item.baseIPI;
        basePisCofins += item.basePisCofins;
      });

    } catch (error) {
      console.error(error);
    }

  } finally {
    $.LoadingOverlay("hide");
  }

  totQtde = totQtde.toFixed(2);

  if (parseFloat(totalIpi) == 0 || totalIpi == "" || isNaN(totalIpi)) {
    totalIpi = 0;
  }

  if (parseFloat($("#txtDescontoTotal").val()) == 0 || $("#txtDescontoTotal").val() == "" || isNaN($("#txtDescontoTotal").val())) {
    desconto = 0;
    $("#txtDescontoTotal").val(desconto);
  }
  if (parseFloat($("#txtFreteTotal").val()) == 0 || $("#txtFreteTotal").val() == "" || isNaN($("#txtFreteTotal").val())) {
    frete = 0;
    $("#txtFreteTotal").val(frete);
  }
  if (parseFloat($("#txtDespesaTotal").val()) == 0 || $("#txtDespesaTotal").val() == "" || isNaN($("#txtDespesaTotal").val())) {
    despesa = 0;
    $("#txtDespesaTotal").val(despesa);
  }

  totValorNota = parseFloat(valorBruto) + parseFloat(frete) + parseFloat(despesa) + parseFloat(totalIpi) + parseFloat(totalIcmsst) - parseFloat(desconto);

  if (parseFloat(totValorNota) < 0) {
    $("#txtDescontoTotal").val("");
    msgAlerta("Valor de desconto maior que o valor total da nota, impossível continuar.");
    return;
  }

  $("#txtDesconto").html(parseFloat(desconto).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtBaseICMSST").html(parseFloat(baseIcmsst).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorICMSST").html(parseFloat(totalIcmsst).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorFrete").html(parseFloat(frete).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorDespesa").html(parseFloat(despesa).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorPIS").html(parseFloat(totalPis).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorCofins").html(parseFloat(totalCofins).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorNota").html(parseFloat(totValorNota).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorFinanceiro").html(parseFloat(totValorNota).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtBaseICMS").html(parseFloat(baseIcms).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtBaseIPI").html(parseFloat(baseIpi).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtBasePISCOFINS").html(parseFloat(basePisCofins).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorICMS").html(parseFloat(totalIcms).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtTotalIPI").html(parseFloat(totalIpi).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtValorBruto").html(parseFloat(parseFloat(valorBruto)).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
  $("#txtQuantidade").html(parseFloat(totQtde));

  simulaFinanceiro();
};

$("#txtNumeroVenda").autocompleta(
  2,
  `JSON={ "tabela":"venda", "camposSelect":["venda.codven CHAVE, entidade.nome DESCRICAO"], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": ["venda.emp_id = ${getCookie(
    "emp_id"
  )}"] }`
);
$("#btnNumeroVenda").pesquisa(
  "#txtNumeroVenda",
  "VENDA",
  "CLIENTE",
  `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"venda", "camposSelect":[ "venda.codven as venda", "entidade.nome as cliente" ], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": ["venda.emp_id = ${getCookie(
    "emp_id"
  )}"], "orderBy": ["venda.codven desc"]}`,
  "Pesquisa Venda",
  "venda"
);
$("#btnANumeroVenda").on("click", function () {
  $("#txtNumeroVenda").val("");
});

$("#btn-limpa-cliente").on("click", function () {
  $("#txtCliente").val("");
  $("#txtCNPJ").val("");
  $("#txtCliente").trigger("blur");
});

$("#txtClienteNota").autocompleta(
  3,
  `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`,
  ["#txtCNPJ"],
  ["CNPJ"],
  ["CNPJ"]
);

$("#btnClienteNota").pesquisa_serverside(
  ["#txtClienteNota", "#txtCNPJ"],
  ["CODCLI", "CNPJ"],
  ["NOME", "CNPJ"],
  `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`,
  "Pesquisa Cliente"
);

$("#btnAClienteNota").on("click", function () {
  $("#txtClienteNota").val("");
});

$("#txtClienteMovimentacao").autocompleta(
  3,
  `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`,
  ["#txtCNPJ"],
  ["CNPJ"],
  ["CNPJ"]
);

$("#btnClienteMovimentacao").pesquisa_serverside(
  ["#txtClienteMovimentacao", "#txtCNPJ"],
  ["CODCLI", "CNPJ"],
  ["NOME", "CNPJ"],
  `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`,
  "Pesquisa Cliente"
);

$("#btnAClienteMovimentacao").on("click", function () {
  $("#txtClienteMovimentacao").val("");
});

$("#btnADocumentoMovimentacao").on("click", function () {
  $("#txtDocumento").val("");
});

$("#btn-limpa-representante").on("click", function () {
  $("#txtRepresentante").val("");
});

$("#txtNaturezaVenda").autocompleta(
  1,
  `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
);
$("#btnNaturezaVenda").pesquisa(
  "#txtNaturezaVenda",
  "NATUREZA",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`,
  "Pesquisa Natureza",
  "natureza"
);
$("#btnANaturezaVenda").on("click", function () {
  $("#txtNaturezaVenda").val("");
});


$("#txtNaturezaNota").autocompleta(
  1,
  `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
);
$("#btnNaturezaNota").pesquisa(
  "#txtNaturezaNota",
  "NATUREZA",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`,
  "Pesquisa Natureza",
  "natureza"
);
$("#btnANaturezaNota").on("click", function () {
  $("#txtNaturezaNota").val("");
});

$("#txtNaturezaMovimentacao").autocompleta(
  1,
  `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
);
$("#btnNaturezaMovimentacao").pesquisa(
  "#txtNaturezaMovimentacao",
  "NATUREZA",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`,
  "Pesquisa Natureza",
  "natureza"
);
$("#btnANaturezaMovimentacao").on("click", function () {
  $("#txtNaturezaMovimentacao").val("");
});

$("#txtNaturezaLote").autocompleta(
  1,
  `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
);
$("#btnNaturezaLote").pesquisa(
  "#txtNaturezaLote",
  "NATUREZA",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`,
  "Pesquisa Natureza",
  "natureza"
);
$("#btnANaturezaLote").on("click", function () {
  $("#txtNaturezaLote").val("");
});

$("#txtTabPrecoMovimentacao").autocompleta(
  1,
  `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO"], "where": null }`
);
$("#btnTabPrecoMovimentacao").pesquisa(
  "#txtTabPrecoMovimentacao",
  "REGIAO",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}`,
  "Pesquisa Tabela de Preço",
  "REGIAO"
);
$("#btnATabPrecoMovimentacao").on("click", function () {
  $("#txtTabPrecoMovimentacao").val("");
});

$("#txtNatureza").autocompleta(
  1,
  `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
);
$("#btn-natureza").pesquisa(
  "#txtNatureza",
  "NATUREZA",
  "DESCRICAO",
  `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ativo = 'S'"]}`,
  "Pesquisa Natureza",
  "natureza"
);
$("#btn-limpa-natureza").on("click", function () {
  $("#txtNatureza").val("");
});

$("#txtReducao").autocompleta(
  1,
  `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
);
$("#btnReducao").pesquisa(
  "#txtReducao",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Operação",
  "oper_fiscal"
);
$("#btnAReducao").on("click", function () {
  $("#txtReducao").val("");
});

$("#txtOperacaoVenda").autocompleta(
  1,
  `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
);
$("#btnOperacaoVenda").pesquisa(
  "#txtOperacaoVenda",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Operação",
  "oper_fiscal"
);
$("#btnAOperacaoVenda").on("click", function () {
  $("#txtOperacaoVenda").val("");
});

$("#txtOperacaoNota").autocompleta(
  1,
  `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
);
$("#btnOperacaoNota").pesquisa(
  "#txtOperacaoNota",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Operação",
  "oper_fiscal"
);
$("#btnAOperacaoNota").on("click", function () {
  $("#txtOperacaoNota").val("");
});

$("#txtOperacaoMovimentacao").autocompleta(
  1,
  `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
);
$("#btnOperacaoMovimentacao").pesquisa(
  "#txtOperacaoMovimentacao",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Operação",
  "oper_fiscal"
);
$("#btnAOperacaoMovimentacao").on("click", function () {
  $("#txtOperacaoMovimentacao").val("");
});

$("#txtOperacaoLote").autocompleta(
  1,
  `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
);
$("#btnOperacaoLote").pesquisa(
  "#txtOperacaoLote",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Operação",
  "oper_fiscal"
);
$("#btnAOperacaoLote").on("click", function () {
  $("#txtOperacaoLote").val("");
});

// $("#txtDeposito").autocompleta(
//   1,
//   `JSON={ "tabela":"deposito", "camposSelect":["codigo CHAVE, DESCRICAO DESCRICAO"], "where": ["ativo = 'S'"] }`
// );
// $("#btnDeposito").pesquisa(
//   "#txtDeposito",
//   "CODIGO",
//   "DESCRICAO",
//   `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao" ], "where": ["ativo = 'S'"]}`,
//   "Pesquisa Depósito",
//   "deposito"
// );
$("#btnADeposito").on("click", function () {
  $("#txtDeposito").val("");
});

$("#txtTransportadora").autocompleta(
  2,
  `JSON={ "tabela":"tabtran", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`
);
$("#btn-transportadora").pesquisa(
  "#txtTransportadora",
  "CODIGO",
  "NOME",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtran", "camposSelect":[ "codigo", "nome" ], "where": null}',
  "Pesquisa Transportadora",
  "tabtran"
);
$("#btn-limpa-transportadora").on("click", function () {
  $("#txtTransportadora").val("");
});

$("#txtSituacao").autocompleta(
  1,
  `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$("#btn-situacao").pesquisa(
  "#txtSituacao",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Situação",
  "tabsit"
);
$("#btn-limpa-situacao").on("click", function () {
  $("#txtSituacao").val("");
});

$("#txtClasseGer").autocompleta(
  1,
  `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$("#btn-classeGer").pesquisa(
  "#txtClasseGer",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Classe Gerencial",
  "classe_ger"
);
$("#btn-limpa-classeGer").on("click", function () {
  $("#txtClasseGer").val("");
});

$("#txtMoeda").autocompleta(
  1,
  `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`
);
$("#btnMoeda").pesquisa(
  "#txtMoeda",
  "CODMOE",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}',
  "Pesquisa Moeda",
  "moeda"
);
$("#btnAMoeda").on("click", function () {
  $("#txtMoeda").val("");
});

$("#txtHistorico").autocompleta(
  1,
  `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`
);
$("#btn-historico").pesquisa(
  "#txtHistorico",
  "HISTORICO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}',
  "Pesquisa Histórico",
  "histcp"
);
$("#btn-limpa-historico").on("click", function () {
  $("#txtHistorico").val("");
});

$("#txtBanco").autocompleta(
  1,
  `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`
);
$("#btn-banco").pesquisa(
  "#txtBanco",
  "BANCO",
  "NOME_BANCO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}',
  "Pesquisa Banco",
  "cadban"
);
$("#btn-limpa-banco").on("click", function () {
  $("#txtBanco").val("");
});

$("#txtModeloDocto").autocompleta(
  1,
  `JSON={ "tabela":"TIPO_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$("#btnModeloDocto").pesquisa(
  "#txtModeloDocto",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}',
  "Pesquisa Tipo Docto",
  "TIPO_FISCAL"
);
$("#btnAModeloDocto").on("click", function () {
  $("#txtModeloDocto").val("");
  $("#txtModeloDocto").trigger("blur");
});

$("#txtInfCompl").autocompleta(
  1,
  `JSON={ "tabela":"TABREF", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": null }`
);
$("#btnInfCompl").pesquisa(
  "#txtInfCompl",
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABREF", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}',
  "Pesquisa Tipo Docto",
  "TABREF"
);
$("#btnAInfCompl").on("click", function () {
  $("#txtInfCompl").val("");
});

$(`#txtEnquadra`).autocompleta(
  1,
  `JSON={ "tabela":"enquadra", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnEnquadra`).pesquisa(
  `#txtEnquadra`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"enquadra", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnAEnquadra`).on("click", function () {
  $(`#txtEnquadra`).val("");
});
$(`#txtCsosn`).autocompleta(
  1,
  `JSON={ "tabela":"tabcsosn", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnCsosn`).pesquisa(
  `#txtCsosn`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabcsosn", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnACsosn`).on("click", function () {
  $(`#txtCsosn`).val("");
});
$(`#txtCstIcms`).autocompleta(
  1,
  `JSON={ "tabela":"tabtri", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnCstIcms`).pesquisa(
  `#txtCstIcms`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtri", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnACstIcms`).on("click", function () {
  $(`#txtCstIcms`).val("");
});
$(`#txtCstIpi`).autocompleta(
  1,
  `JSON={ "tabela":"tabipi", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnCstIpi`).pesquisa(
  `#txtCstIpi`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabipi", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnACstIpi`).on("click", function () {
  $(`#txtCstIpi`).val("");
});
$(`#txtCstPis`).autocompleta(
  1,
  `JSON={ "tabela":"tabpis", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnCstPis`).pesquisa(
  `#txtCstPis`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabpis", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnACstPis`).on("click", function () {
  $(`#txtCstPis`).val("");
});
$(`#txtCstCofins`).autocompleta(
  1,
  `JSON={ "tabela":"tabcofins", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`
);
$(`#btnCstCofins`).pesquisa(
  `#txtCstCofins`,
  "CODIGO",
  "DESCRICAO",
  '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabcofins", "camposSelect":[ "codigo", "descricao" ], "where": null}',
  "Pesquisa Enquadramento IPI",
  "enquadra"
);
$(`#btnACstCofins`).on("click", function () {
  $(`#txtCstCofins`).val("");
});

$('#txtSetorLote').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
$('#btnSetorLote').pesquisa_serverside(['#txtSetorLote'], ['CODIGO'], ['DESCRICAO'], '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Setor');
$('#btnASetorLote').on('click', function () {
  $('#txtSetorLote').val('');
});

$('#txtParteLote').autocompleta(1, 'JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
$('#btnParteLote').pesquisa_serverside(['#txtParteLote'], ['CODIGO'], ['DESCRICAO'], '{ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Parte');
$('#btnAParteLote').on('click', function () {
  $('#txtParteLote').val('');
});

$('#btnNotaRef').pesquisa_serverside(
  ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
  ['NOTA.FATURA', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
  ['NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
  `{"tabela":"NOTA", 
    "camposSelect":[ "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.VALOR", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"], 
    "leftjoin": [ 
      {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}
    ],
    "where": ["NOTA.EMP_ID = ${getCookie('emp_id')}"],
    "camposWhereServerSide": ["NOTA.FATURA", "NOTA.SERIE", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"]
   }`,
  'Pesquisa Nota',
);

$(`#btnANotaRef`).on("click", function () {
  $(`#txtNotaRef`).val("");
  $(`#txtDataNotaRef`).val("");
  $(`#txtCodcliNotaRef`).val("");
  $(`#txtValorNotaRef`).val("");
});

$('#btnPedido').pesquisa_serverside(
  ['#txtPedido', '#txtDeposito', '#txtCliente'],
  ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
  ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME'],
  `{"tabela":"PEDIDO", 
    "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
    "leftjoin": [ 
      {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
      {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
      {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
    ],
    "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
    "having": ["SUM(PED_ITEN.QTDE) > 0"],
    "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]
   }`,
  'Pesquisa Pedido',
  () => { $('#txtPedido').trigger('blur'); }
);

$('#btnAPedido').on('click', function () { $('#txtPedido').val(''); });

$('#txtChaveRef').on('keypress', function (event) {
  var regex = new RegExp("^[0-9]+$");
  var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
  if (!regex.test(key)) {
    event.preventDefault(); return false;
  }
});

$(
  "#edtVencimento1, #edtVencimento2, #edtVencimento3, #edtVencimento4, #edtVencimento5, #edtVencimento6, #edtVencimento7, #edtVencimento8, #edtVencimento9, #edtVencimento10, #edtVencimento11, #edtVencimento12"
).on("input", function () {
  let c = this.selectionStart;
  let r = /[^0-9]/gi;
  let v = $(this).val();
  if (r.test(v)) {
    $(this).val(v.replace(r, ""));
    c--;
  }
  this.setSelectionRange(c, c);
});

$("#txtCliente").change(async function () {
  let codcli = pegaChave("#txtCliente");
  try {
    let responseOperadora = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"entidade", "camposSelect":["bloqueio", "cons_final"], 
              "where": ["codcli = '${codcli}'"]}`,
      null
    );

    let jsonStr = await responseOperadora.json();

    if (jsonStr.RESULT[0][0].BLOQUEIO == "S" && !confirm("Cliente bloqueado, deseja continuar mesmo assim?")) {
      $("#txtCliente").val("");
      $("#txtCliente").trigger("blur");
    }

    $("#consumidorFinal").prop("checked", jsonStr.RESULT[0][0].CONS_FINAL == "Sim");
    criarToolTipCliente(codcli);
    buscaGerarDifal();
  } catch (error) {
    console.error(error);
  }
});



function trocaIdClass(seletor, indice) {
  const classe = seletor.substring(1);
  $(`${seletor}-${indice}`)
    .addClass(`${classe}-atual`)
    .removeClass(`${classe}-${indice}`);
  $(`${seletor}-atual`)
    .addClass(`${classe}-${indice - 1}`)
    .removeClass(`${classe}-atual`);
}

async function DeleteItem(id) {
  let itens = $(".itens");
  for (let i = 0; i < itens.length; i++) {
    if (i == id) {
      $(`.item-${i}`).addClass(`removido`).removeClass(`item-${i}`);
    } else if (i > id) {
      $(`.item-${i}`).addClass(`atual`).removeClass(`item-${i}`);
      $(`.atual`)
        .addClass(`item-${i - 1}`)
        .removeClass(`atual`);

      trocaIdClass(`.btn-limpa`, i);
      trocaIdClass(`.btn-edit`, i);
      trocaIdClass(`.btn-add`, i);
      trocaIdClass(`.txtItem`, i);
      $(`.contador.item-${i - 1}>span`).html(i);
    }
  }
}

$("#radioProduto, #radioMaterial, #cbTodos, #cbAtivoStatus, #cbInativo, #cbContemEstoque").on("change", async function () {
  if ($("#txtProduto-0").val() == "") {
    $(".btn-limpa-0").trigger("click");
  }
  if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
    $("#tabelaProdutos").DataTable().destroy();
    $("#tabelaProdutos").empty();
  }
  await buscaProdutos();
});

async function buscaDeposito() {
  if ($("#txtReducao").val() != "") {
    const codigo = pegaChave($("#txtReducao").val());
    const dadosSelect = {
      tabela: `oper_fiscal`,
      camposSelect: [`oper_fiscal.deposito_saida, deposito.descricao`],
      LeftJoin: [
        {
          tabela: "deposito",
          condicao: "deposito.codigo = oper_fiscal.deposito_saida",
        },
      ],
      where: [`oper_fiscal.codigo = '${codigo}'`],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(
      JSON.stringify(dadosSelect)
    );

    if (retornoSelect[0].DEPOSITO_SAIDA != "") {
      insereValor("#txtDeposito", retornoSelect[0].DEPOSITO_SAIDA, retornoSelect[0].DESCRICAO);
    } else {
      insereValor("#txtDeposito", "0000", "GERAL");
    }
  } else {
    insereValor("#txtDeposito", "0000", "GERAL");
  }
}

async function AddItens() {
  let itens = $(".itens");

  $("#items-wrap").append(
    `<div class="row itens" ${parseInt(itens.length) != 0 ? 'style="margin-top:3px"' : ""
    }>
                <div class="item-${itens.length} contador col-1">
                  <span id="item-${itens.length}">${itens.length + 1}</span>
            </div>
            <div class="item-${itens.length} col-lg-4 col-12">
            ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtProduto-${itens.length}">Item</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" class="inputs input-default focus form-control classeProduto txtItem-${itens.length}" style="margin-left:5px;"
                              id="txtProduto-${itens.length
    }" name="txtProduto-${itens.length
    }" placeholder="${$("#radioProduto").is(":checked")
      ? "Produto (F4 para pesquisar)"
      : "Material (F4 para pesquisar)"
    }" readonly>
                              <div class="input-group-append">
                              <a id="btn-produto-${itens.length}">
                              <i class="fas fa-search text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i> 
                              </a>
                              <a id="btn-limpa-produto-${itens.length}">
                              <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                              </a>
                          </div>
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                      ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtQuantidade-${itens.length}">Qtde.</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" maxlength="10" class="inputs input-default focus form-control maskItens classeQuantidade"
                              min="0" id="txtQuantidade-${itens.length
    }" name="txtQuantidade-${itens.length}"
                              class="form-control" placeholder="Qtde.">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                  ${itens.length == 0
      ? '<label data-error="wrong" data-success="right" for="txtPreco">Preço</label>'
      : ""
    }
                      <div class="input-group">
                          <input type="text" maxlength="8" class="inputs input-default focus form-control maskItens classePreco"
                              min="0" id="txtPreco-${itens.length
    }" name="txtPreco-${itens.length
    }" class="form-control"
                              placeholder="Preco">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                  ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtCFOP${itens.length}">CFOP</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" class="inputs input-default focus form-control classeNatureza"
                              id="txtCFOP-${itens.length}" name="txtCFOP-${itens.length
    }"
                              class="form-control" placeholder="CFOP" value="${$(
      "#txtNatureza"
    ).val()}">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                  ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtIPI-${itens.length}">IPI %</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" step='0.01' value='0.00' class="inputs input-default focus form-control maskItens"
                              min="0" value="0" id="txtIPI-${itens.length
    }" name="txtIPI-${itens.length}"
                              class="form-control" placeholder="IPI %">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                  ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtICMS-${itens.length}">ICMS %</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" step='0.01' value='0.00' class="inputs input-default focus form-control maskItens"
                              min="0" value="0" id="txtICMS-${itens.length
    }" name="txtICMS-${itens.length}"
                              class="form-control" placeholder="ICMS %">
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12">
                  ${itens.length == 0
      ? `<label data-error="wrong" data-success="right" for="txtNCM-${itens.length}">NCM</label>`
      : ""
    }
                      <div class="input-group">
                          <input type="text" class="inputs input-default focus form-control" id="txtNCM-${itens.length
    }" name="txtNCM-${itens.length
    }" class="form-control" placeholder="NCM">
                      </div>
                  </div>
                  <div class="col-lg-1 col-12">
                      <div class="btn-group grupo_botao item-${itens.length
    }" role="group" aria-label="Basic example">
                          <button type="button" class="btn btn-opcao bg-light nofocus btn-edit-${itens.length
    }">
                              <i class="fas fa-edit text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i> 
                          </button>
                          <button type="button" class="btn btn-opcao bg-light nofocus btn-limpa-${itens.length
    }">
                              <i class="fas fa-trash text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                          </button>
                          <button type="button" class="btn btn-opcao bg-light nofocus btn-add-${itens.length
    }">
                              <i class="fas fa-plus text-red" style="font-weight: bold;margin-left: 10px;font-size: 18px;"></i>
                          </button>
                      </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12 d-none">
                    <div>
                      <input type="text" class="d-none input-default focus form-control" id="txtDescontoPronto${itens.length
    }" 
                      name="txtDescontoPronto${itens.length
    }" class="form-control">
                    </div>
                  </div>
                  <div class="item-${itens.length} col-lg-1 col-12 d-none">
                    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtValorProduto${itens.length
    }" name="txtValorProduto${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtValorBruto${itens.length
    }" name="txtValorBruto${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control classeValorReserva">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotQtde${itens.length
    }" name="txtTotQtde${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotValorItens${itens.length
    }" name="txtTotValorItens${itens.length
    }" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotalIcms${itens.length
    }" name="txtTotalIcms${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotalIpi${itens.length
    }" name="txtTotalIpi${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotalPis${itens.length
    }" name="txtTotalPis${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotalCofins${itens.length
    }" name="txtTotalCofins${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtTotalICMSST${itens.length
    }" name="txtTotalICMSST${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtBaseST${itens.length
    }" name="txtBaseST${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  
                  <input type="text" class="d-none input-default focus form-control" id="txtEnquadra${itens.length
    }" name="txtEnquadra${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtCsosn${itens.length
    }" name="txtCsosn${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtCstIcms${itens.length
    }" name="txtCstIcms${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtCstIpi${itens.length
    }" name="txtCstIpi${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtCstPis${itens.length
    }" name="txtCstPis${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtCstCofins${itens.length
    }" name="txtCstCofins${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtBaseIPI${itens.length
    }" name="txtBaseIPI${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtBaseICMS${itens.length
    }" name="txtBaseICMS${itens.length}" class="form-control">
    </div>
    </div>
    <div class="item-${itens.length} col-lg-1 col-12 d-none">
    <div>
                  <input type="text" class="d-none input-default focus form-control" id="txtBasePISCOFINS${itens.length
    }" name="txtBasePISCOFINS${itens.length}" class="form-control">
    </div>
    </div>
</div>
`
  );
  $(`.item-${itens.length}:not(:first-child)`).css("padding", "0 1.3px 0 0");
  $(".maskItens").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  if (isNaN(decimais)) {
    decimais = 2;
  }

  $(".classePreco").maskMoney({
    decimal: ".",
    thousands: "",
    precision: decimais
  });

  let id = `.btn-limpa-${itens.length}`;

  $(`#txtProduto-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 115) {
      $(`#btn-produto-${itens.length}`).trigger("click");
    }
    if (e.keyCode == 13) {
      $(`#txtQuantidade-${itens.length}`).focus();
    }
  });

  $(`#txtQuantidade-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`#txtPreco-${itens.length}`).focus();
    }
  });
  $(`#txtPreco-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`#txtCFOP-${itens.length}`).focus();
    }
  });

  $(`#txtIPI-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`#txtICMS-${itens.length}`).focus();
    }
  });
  $(`#txtICMS-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`#txtNCM-${itens.length}`).focus();
    }
  });

  $(`#txtProduto-${itens.length}`).on("change, blur", function () {
    adicionaHint(`#txtProduto-${itens.length}`);
  });
  $(`#txtCFOP-${itens.length}`).autocompleta(
    1,
    `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
  );

  $(`#txtCFOP-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`#txtIPI-${itens.length}`).focus();
    }
  });

  $(`#txtCFOP-${itens.length}`).on("change, blur", function () {
    adicionaHint(`#txtCFOP-${itens.length}`);
  });

  $(`#txtNCM-${itens.length}`).autocompleta(
    1,
    `JSON={ "tabela":"tabfis", "camposSelect":["codigo CHAVE, DESCRICAO DESCRICAO"], "where": [] }`
  );

  $(`#txtNCM-${itens.length}`).keyup(function (e) {
    if (e.keyCode == 13) {
      $(`.btn-add-${itens.length}`).trigger("click");
    }
  });

  $(`#txtNCM-${itens.length}`).on("change, blur", function () {
    adicionaHint(`#txtNCM-${itens.length}`);
  });

  $(`#btn-limpa-produto-${itens.length}`).on("click", function () {
    const codProduto = $(`#txtProduto-${itens.length}`).attr("data-codigo");
    const documento = $(`#txtProduto-${itens.length}`).attr("data-documento");
    if (documento != '' && codProduto != '' && codProduto != undefined) {
      rotinaGeraLog('FATURAMENTO', codProduto, `Item ${codProduto} excluido da importacao da movimentacao ${documento}`, 'Exclusão');
    }
    $(`#txtProduto-${itens.length}`).val("");
    $(`#txtProduto-${itens.length}`).attr("data-codigo", "");
    $(`#txtProduto-${itens.length}`).attr("data-cor", "");
    $(`#txtProduto-${itens.length}`).attr("data-tam", "");
  });

  $(`.btn-edit-${itens.length}`).on("click", function () {
    $("#txtEnquadra").val($(`#txtEnquadra${itens.length}`).val());
    $("#txtCsosn").val($(`#txtCsosn${itens.length}`).val());
    $("#txtCstIcms").val($(`#txtCstIcms${itens.length}`).val());
    $("#txtCstIpi").val($(`#txtCstIpi${itens.length}`).val());
    $("#txtCstPis").val($(`#txtCstPis${itens.length}`).val());
    $("#txtCstCofins").val($(`#txtCstCofins${itens.length}`).val());
    $("#txtIndiceAlteracao").val(itens.length);
    $(`#modalTribProd`).modal("show");
  });

  $(`.btn-add-${itens.length}`).on("click", function () {
    let qtdeProd = $(".itens");
    let elemento = $(this).attr("class").split("-");
    elemento = elemento[elemento.length - 1];
    if (
      parseInt(elemento) === qtdeProd.length - 1 &&
      $(`#txtProduto-${elemento}`).val() != ""
    ) {
      AddItens();
      $(`#txtProduto-${parseInt(elemento) + 1}`).focus();
    }
  });

  $(`#btn-produto-${itens.length}`).on("click", function () {
    $("#idLinha").val(this.id.split("-")[2]);
    $("#modalProduto").modal("show");
    if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
      $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
    }
    $("#txtProdutoCodigo").val("");
    $("#txtProdutoDescricao").val("");
  });

  $(`#txtPreco-${itens.length}, #txtNCM-${itens.length}`).on(
    "change",
    function () {
      atualizaTotaisNota($(this));
    }
  );

  $(`#txtCFOP-${itens.length}`).on("change", function () {
    $(`#txtICMS-${itens.length}`).val("");
    $(`#txtIPI-${itens.length}`).val("");
    $(`#txtNCM-${itens.length}`).val("");
    $(`#txtNCM-${itens.length}`).val("");
    $(`#txtEnquadra${itens.length}`).val("");
    $(`#txtCsosn${itens.length}`).val("");
    $(`#txtCstIcms${itens.length}`).val("");
    $(`#txtCstIpi${itens.length}`).val("");
    $(`#txtCstPis${itens.length}`).val("");
    $(`#txtCstCofins${itens.length}`).val("");
    atualizaTotaisNota($(this));
  });

  $(`#txtQuantidade-${itens.length}`).on("change", function () {
    if ($(`#txtPreco-${itens.length}`).val() != "") {
      atualizaTotaisNota($(this));
    }
  });

  $(`#txtICMS-${itens.length}`).change(async function () {
    if ($(`#txtICMS-${itens.length}`).val() == "") {
      $(`#txtICMS-${itens.length}`).val("0.00");
    }
    atualizaTotaisNota($(this));
  });

  $(`#txtIPI-${itens.length}`).change(async function () {
    if ($(`#txtIPI-${itens.length}`).val() == "") {
      $(`#txtIPI-${itens.length}`).val("0.00");
    }
  });

  $(`#txtProduto-${itens.length}`).blur(async function () {
    $(`#txtCFOP-${itens.length}`).val($("#txtNatureza").val());
  });
  addEvent(id);
  return itens.length;
}

$("#modalProduto").on("shown.bs.modal", function () {
  if ($.fn.DataTable.isDataTable("#tabelaProdutos")) {
    $("#tabelaProdutos").DataTable().columns.adjust().draw(false);
  }
  $("#txtProdutoCodigo").focus();
});

$("#txtProdutoDescricao").on("focusout", function () {
  $("#btnConsultarProduto").focus();
});

$("#btnConsultarProduto").on("keypress", function () {
  $("#btnConsultarProduto").trigger("click");
});

$("#modalProduto").on("hidden.bs.modal", function () {
  const id = $("#idLinha").val();
  $(`#txtProduto-${id}`).trigger("blur");
  $(`#txtProduto-${id}`).focus();
});

$("#txtProdutoCodigo").change(async function () {
  await buscaProdutos();
});

$("#txtProdutoCodigo2").change(async function () {
  await buscaProdutos();
});

$("#txtProdutoBarra").change(async function () {
  await buscaProdutos();
});

$("#txtProdutoDescricao").change(async function () {
  await buscaProdutos();
});

$("#btnConsultarProduto").on("click", async function () {
  await buscaProdutos();
});

$("#txtBarraBipar").on('blur', async function () {
  if ($(this).val() == '') {
    return;
  }

  await buscaProdutoBarra();
});

$("#btn_confirmar_produto").click(function () {
  let data = $("#tabelaProdutos").dataTable().api().row(".selected").data();
  const id = $("#idLinha").val();
  $(`#txtProduto-${id}`).val(
    `${data.CODIGO} ${data.DESCRICAO} - ${data.COR} ${data.DESC_COR}${$("#radioProduto").is(":checked") ? ` - ${data.TAM}` : ""
    }`
  );
  $(`#txtProduto-${id}`).attr("data-codigo", data.CODIGO);
  $(`#txtProduto-${id}`).attr("data-descricao", data.DESCRICAO);
  $(`#txtProduto-${id}`).attr("data-cor", data.COR);
  $(`#txtProduto-${id}`).attr("data-documento", '');
  $(`#txtPreco-${id}`).val(data.PRECO);
  if ($("#radioProduto").is(":checked")) {
    $(`#txtProduto-${id}`).attr("data-tam", data.TAM);
  }
  $(`#txtProduto-${id}`).attr(
    "data-tipo",
    $("#radioProduto").is(":checked") ? "P" : "M"
  );
  $("#modalProduto").modal("hide");
});

function addEvent(element) {
  $(element).blur(function () {
    let itens = $(".itens");
    let id = $(this).attr("class").split("-");
    id = id[id.length - 1];
    if (
      parseInt(id) === itens.length - 1 &&
      $(`#txtProduto-${id}`).val() != ""
    ) {
      AddItens();
      $(`#txtProduto-${parseInt(id) + 1}`).focus();
    }
  });

  $(element).on("click", async function () {
    let itens = $(".itens");
    let id = $(this).attr("class").split("-");
    id = id[id.length - 1];
    const idInput = $(`.txtItem-${id}`)[0].id;
    const codProduto = $(`#${idInput}`).attr("data-codigo");
    const documento = $(`#${idInput}`).attr("data-documento");
    if (documento != '' && codProduto != '' && codProduto != undefined) {
      rotinaGeraLog('FATURAMENTO', codProduto, `Item ${codProduto} excluido da importacao da movimentacao ${documento}`, 'Exclusão');
    }
    if (itens.length === 1) {
      itens = [];
      $(`.item-${id}`).closest(".row").remove();
      await AddItens();
    } else {
      await DeleteItem(id);
      $(`.removido`).closest(".row").remove();
      if (id == 0) {
        $($(`.itens > .item-0 > .input-group`)[0]).css("margin-top", "8%");
        $($(`.itens > .item-0 > .input-group`)[1]).css("margin-top", "33%");
        $($(`.itens > .item-0 > .input-group`)[2]).css("margin-top", "33%");
        $($(`.itens > .item-0 > .input-group`)[3]).css("margin-top", "33%");
        $($(`.itens > .item-0 > .input-group`)[4]).css("margin-top", "33%");
        $($(`.itens > .item-0 > .input-group`)[5]).css("margin-top", "33%");
        $($(`.itens > .item-0 > .input-group`)[6]).css("margin-top", "33%");
      }
    }
    await aplicaDesconto();
  });
}

$("#btnConfirmarTrib").on("click", function () {
  const indice = $("#txtIndiceAlteracao").val();
  $(`#txtEnquadra${indice}`).val($("#txtEnquadra").val());
  $(`#txtCsosn${indice}`).val($("#txtCsosn").val());
  $(`#txtCstIcms${indice}`).val($("#txtCstIcms").val());
  $(`#txtCstIpi${indice}`).val($("#txtCstIpi").val());
  $(`#txtCstPis${indice}`).val($("#txtCstPis").val());
  $(`#txtCstCofins${indice}`).val($("#txtCstCofins").val());

  atualizaTotaisNota(indice);

  $(`#modalTribProd`).modal("hide");
});

async function buscaProdutoBarra() {
  try {
    let sWhere, paramsRequisicao;
    const bProdutoMaterial = $("#radioProduto").is(":checked");
    const sBarra = pegaValor('#txtBarraBipar');

    if (bProdutoMaterial) {
      sWhere = `AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRACLI = '${sBarra}') AND PA_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}'`;
      paramsRequisicao = `JSON={
      "tabela":"pa_iten",
      "camposSelect":["pa_iten.codigo",  "produto.descricao", "pa_iten.cor", "cadcor.descricao desc_cor", "pa_iten.tam", "COALESCE(tabpreco.preco_00, 0) preco_00" ],
      "leftjoin": [
        {"tabela" : "produto", "condicao" : "produto.codigo = pa_iten.codigo"}, 
        {"tabela" : "cadcor", "condicao" : "cadcor.cor= pa_iten.cor"},
        {"tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam"},
        {"tabela" : "venda_caixa", "condicao" : "venda_caixa.emp_id = ${getCookie('emp_id')} and venda_caixa.usuario = '${getCookie('usuario')}'"},
        {"tabela" : "tabpreco", "condicao" : "tabpreco.regiao = venda_caixa.regiao and tabpreco.codigo = pa_iten.codigo"}
      ]
      "where": ["produto.ativo = 'S' ${sWhere}"], "limit": 1000}`;
    } else {
      sWhere = `AND MAT_ITEN.BARRA = '${sBarra}' AND MAT_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}'`;
      paramsRequisicao = `JSON={
		    "tabela":"mat_iten",
		    "camposSelect":["mat_iten.codigo",  "material.descricao", "mat_iten.cor", "cadcor.descricao desc_cor", "COALESCE(tabpreco.preco_00, 0) preco_00" ],
		    "leftjoin": [
		    	{"tabela" : "material", "condicao" : "material.codigo = mat_iten.codigo"}, 
    			{"tabela" : "cadcor", "condicao" : "cadcor.cor= mat_iten.cor"},
          {"tabela" : "venda_caixa", "condicao" : "venda_caixa.emp_id = ${getCookie('emp_id')} and venda_caixa.usuario = '${getCookie('usuario')}'"},
          {"tabela" : "tabpreco", "condicao" : "tabpreco.regiao = venda_caixa.regiao and tabpreco.codigo = mat_iten.codigo"}
        ]
        "where": ["material.ativo = 'S' ${sWhere}"], "limit": 1000}`;
    }

    const response = await requisicao("GET", `/sisplan/funcoes/v1/pesquisa?`, paramsRequisicao, null, 20000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    if (jsonStr.RESULT[0].length == 0) {
      msgAlerta('Barra não encontrada para esse depósito.');
      $('#txtBarraBipar').val('');
      return;
    }

    const data = jsonStr.RESULT[0][0];
    let index = 0;
    let achouIndex = false;

    for (let i = 0; i < $('.classeProduto').length; i++) {
      if ($(`#txtProduto-${i}`).attr("data-codigo") == data.CODIGO
        && $(`#txtProduto-${i}`).attr("data-cor") == data.COR
        && $(`#txtProduto-${i}`).attr("data-TAM") == data.TAM
        && $(`#txtPreco-${i}`).val() == data.PRECO_00) {
        achouIndex = true;
        index = i;
      } else if (($(`#txtProduto-${i}`).val() == '') && (index == 0)) {
        achouIndex = true;
        index = i;
      }
    }

    if (!achouIndex) {
      index = $('.classeProduto').length;
      $(`.btn-add-${$('.classeProduto').length - 1}`).trigger('click');
    }

    $(`#txtProduto-${index}`).val(`${data.CODIGO} ${data.DESCRICAO} - ${data.COR} ${data.DESC_COR}${bProdutoMaterial ? ` - ${data.TAM}` : ""}`);
    $(`#txtProduto-${index}`).attr("data-codigo", data.CODIGO);
    $(`#txtProduto-${index}`).attr("data-descricao", data.DESCRICAO);
    $(`#txtProduto-${index}`).attr("data-cor", data.COR);
    $(`#txtProduto-${index}`).attr("data-documento", '');
    if (bProdutoMaterial) {
      $(`#txtProduto-${index}`).attr("data-tam", data.TAM);
    }
    $(`#txtProduto-${index}`).attr("data-tipo", bProdutoMaterial ? "P" : "M");
    $(`#txtQuantidade-${index}`).val($(`#txtQuantidade-${index}`).val() == '' ? 1 : parseFloat($(`#txtQuantidade-${index}`).val()) + 1);
    $(`#txtPreco-${index}`).val(data.PRECO_00);
    $(`#txtPreco-${index}`).trigger('change');
  } finally {
    $('#txtBarraBipar').val('');
    $('#txtBarraBipar').focus();
  }
}

async function buscaProdutos(background = false) {
  let sBarra = $("#txtProdutoBarra").val();
  let sCodigo = $("#txtProdutoCodigo").val();
  let sCodigo2 = $("#txtProdutoCodigo2").val();
  let sDescricao = $("#txtProdutoDescricao").val().toUpperCase();

  const sDeposito = pegaChave('#txtDeposito');
  const bContemEstoque = $('#cbContemEstoque').prop('checked');
  const tabPrecoVenda = pegaChave(await CopiaParametro("VENDA", 2));
  const bPrecoCorTam = (await CopiaParametro("VENDA", 5)) == '1';


  let urlRequisicao;
  let paramsRequisicao;

  if ($("#radioProduto").is(":checked")) {
    let inputStatus = $('input[name="cbStatus"]:checked');
    const status = inputStatus.attr('id') === 'cbTodos' ? '' : ` AND PRODUTO.ATIVO = '${inputStatus.val()}'`;

    let sWhere = `1=1 ${status}`;

    if (sBarra != "") {
      sWhere += ` AND PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRACLI = '${sBarra}' `;
    }
    if (sCodigo != "") {
      sWhere += ` AND PA_ITEN.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `;
    }
    if (sCodigo2 != "") {
      sWhere += ` AND PRODUTO.CODIGO2 LIKE ('[PERCENTUAL]${sCodigo2}[PERCENTUAL]') `;
    }
    if (sDescricao != "") {
      sWhere += ` AND UPPER(PRODUTO.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]')`;
    }

    if (bContemEstoque) {
      sWhere += ` AND PA_ITEN.QUANTIDADE > 0  AND PA_ITEN.DEPOSITO = '${sDeposito}'`;
    }

    urlRequisicao = `/sisplan/funcoes/v1/pesquisa?`;
    paramsRequisicao = `JSON={
      "tabela":"pa_iten",
      "camposSelect":[
        "pa_iten.codigo", "produto.codigo2",  "produto.descricao", "pa_iten.cor", "cadcor.descricao desc_cor", "pa_iten.tam", 
        "CASE WHEN '${bPrecoCorTam ? '1' : 'N'}' = '1' THEN preco_cor_tam.preco ELSE tabpreco.preco_00 END preco" 
      ],
      "innerjoin": [
        {"tabela" : "produto", "condicao" : "produto.codigo = pa_iten.codigo"}
      ],
      "leftjoin": [
        {"tabela" : "cadcor", "condicao" : "cadcor.cor= pa_iten.cor"},
        {"tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam"},
        {"tabela" : "tabpreco", "condicao" : "tabpreco.regiao = '${tabPrecoVenda}' and tabpreco.codigo = pa_iten.codigo"},
        {"tabela" : "preco_cor_tam", "condicao" : "preco_cor_tam.regiao = '${tabPrecoVenda}' and preco_cor_tam.codigo = pa_iten.codigo and preco_cor_tam.cor = pa_iten.cor and preco_cor_tam.tam = pa_iten.tam"}
      ],
      "groupby": [ "pa_iten.codigo", "produto.codigo2", "produto.descricao", "pa_iten.cor", "cadcor.descricao", "pa_iten.tam", "faixa_iten.posicao", "preco_cor_tam.preco", "tabpreco.preco_00" ],
      "orderby": [ "pa_iten.codigo", "pa_iten.cor", "faixa_iten.posicao" ],
      "where": ["${sWhere}"], 
      "limit": 1000
    }`;

  } else {
    let inputStatus = $('input[name="cbStatus"]:checked');
    const status = inputStatus.attr('id') === 'cbTodos' ? '' : ` AND MATERIAL.ATIVO = '${inputStatus.val()}'`;

    let sWhere = `1=1 ${status}`;

    if (sBarra != "") {
      sWhere += ` AND MAT_ITEN.BARRA = '${sBarra}'`;
    }
    if (sCodigo != "") {
      sWhere += ` AND MAT_ITEN.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `;
    }
    if (sCodigo2 != "") {
      sWhere += ` AND MATERIAL.CODIGO2 LIKE ('[PERCENTUAL]${sCodigo2}[PERCENTUAL]') `;
    }
    if (sDescricao != "") {
      sWhere += ` AND UPPER(MATERIAL.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]')`;
    }

    if (bContemEstoque) {
      sWhere += ` AND MAT_ITEN.QTDE > 0 AND MAT_ITEN.DEPOSITO = '${sDeposito}'`;
    }

    urlRequisicao = `/sisplan/funcoes/v1/pesquisa?`;
    paramsRequisicao = `JSON={
		    "tabela":"mat_iten",
		    "camposSelect":["mat_iten.codigo", "material.codigo2",  "material.descricao", "mat_iten.cor", "cadcor.descricao desc_cor", "tabpreco.preco_00 preco" ],
		    "leftjoin": [
		    	{"tabela" : "material", "condicao" : "material.codigo = mat_iten.codigo"}, 
    			{"tabela" : "cadcor", "condicao" : "cadcor.cor= mat_iten.cor"},
          {"tabela" : "tabpreco", "condicao" : "tabpreco.regiao = '${tabPrecoVenda}' and tabpreco.codigo = mat_iten.codigo"}
        ],
		    "groupby": [ "mat_iten.codigo",  "material.codigo2", "material.descricao", "mat_iten.cor", "cadcor.descricao", "tabpreco.preco_00" ],
		    "orderby": [ "mat_iten.codigo", "mat_iten.cor" ],"where": ["${sWhere}"], "limit": 1000}`;
  }

  let dataSet = [];
  let dataSetCols = [];
  try {
    try {
      if (!background) {
        $.LoadingOverlay("show");
      }
      let response = await requisicao(
        "GET",
        urlRequisicao,
        paramsRequisicao,
        null,
        20000
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (!$.isEmptyObject(jsonStr.RESULT[0])) {
        dataSet = jsonStr.RESULT[0];
        let keys = Object.keys(dataSet[0]);
        keys.forEach((value) => {
          dataSetCols.push({
            title: value,
            data: value,
          });
        });

        tabelaProdutos = $("#tabelaProdutos").DataTable({
          paging: false,
          filter: false,
          info: true,
          order: false,
          autoWidth: true,
          destroy: true,
          keys: true,
          scrollY: "300px",
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          columns: dataSetCols,
          data: dataSet,
        });

        $("#tabelaProdutos tbody").on("click", "tr", function () {
          $("#tabelaProdutos")
            .dataTable()
            .$("tr.selected")
            .removeClass("selected");
          $(this).addClass("selected");
        });

        if (sBarra != "") {
          $("#tabelaProdutos tbody tr").addClass("selected");
          $("#btn_confirmar_produto").click();
        }

        $("#tabelaProdutos tbody").on("dblclick", "tr", function () {
          document.firstElementChild.style.zoom = "reset";
          $("#tabelaProdutos")
            .dataTable()
            .$("tr.selected")
            .removeClass("selected");
          $(this).addClass("selected");
          $("#btn_confirmar_produto").click();
        });
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados do produto.");
    }
  } finally {
    if (!background) {
      $.LoadingOverlay("hide");
    }
  }
}

buscaProdutos(TruncaDecimaisNova);

AddItens();

buscaEspecie();

async function buscaEspecie() {
  const pesquisaParam = {
    tabela: 'EMPRESA',
    camposSelect: ['EMP_ESPECIE'],
    where: [`EMP_ID = '${getCookie('emp_id')}'`]
  };
  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  if (jsonStr.length == 0) {
    return;
  }

  insereValor('#txtEspecie', jsonStr[0].EMP_ESPECIE);
}

$(".collapse")
  .on("shown.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })
  .on("hidden.bs.collapse", function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

    clicked
      .parent()
      .find(".fa-angle-down")
      .removeClass("fa-angle-down")
      .addClass("fa-angle-right");
  });

$("#tabelaDuplicatas").DataTable({
  paging: false,
  filter: false,
  info: false,
  order: false,
  scrollY: "193px",
  destroy: true,
  language: {
    sEmptyTable: "Nenhum registro encontrado",
    sInfo: "_TOTAL_ registros",
    sInfoEmpty: " 0 registros",
    sInfoFiltered: "(Filtrados de _MAX_ registros)",
    sInfoPostFix: "",
    sInfoThousands: ".",
    sLengthMenu: "_MENU_ resultados",
    sLoadingRecords: "Carregando...",
    sProcessing: "Processando...",
    sZeroRecords: "Nenhum registro encontrado",
    sSearch: "Pesquisar (geral): ",
    oPaginate: {
      sNext: "Próximo",
      sPrevious: "Anterior",
      sFirst: "Primeiro",
      sLast: "Último",
    },
    oAria: {
      sSortAscending: ": Ordenar colunas de forma ascendente",
      sSortDescending: ": Ordenar colunas de forma descendente",
    },
  },
});

async function RetornaVencimentos(arrDias) {
  let arrVencimentos = [];
  try {
    let dataAtual = new Date();
    for (let index = 0; index < arrDias.length; index++) {
      if (arrDias[index] != "") {
        let novoPrazo = new Date();
        novoPrazo.setDate(dataAtual.getDate() + parseInt(arrDias[index]));

        const response = await requisicao("GET", "/sisplan/nfe/v1/datavencimento?", `CODCLI=${pegaChave('#txtCliente')}&DATA=${formataData(novoPrazo)}`);
        const jsonStr = await response.text();

        let novaData = jsonStr.split('/')[2] + '-' + jsonStr.split('/')[1] + '-' + jsonStr.split('/')[0];
        novaData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${index}" name="txtDataRec" value="${novaData}"></input>`
        arrVencimentos.push(novaData);
      }
    }
    return arrVencimentos;
  } catch (error) {
    console.error(error);
  }
}

$("#edtVencimento1").change(async function () {
  await simulaFinanceiro();
});
$("#edtVencimento2").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento3").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento4").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento5").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento6").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento7").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento8").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento9").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento10").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento11").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});
$("#edtVencimento12").change(async function () {
  if ($(this).val() == 0) {
    $(this).val('');
  }
  await simulaFinanceiro();
});

async function simulaFinanceiro() {
  let parcelas = [];
  for (let i = 0; i < 12; i++) {
    if ($(`#edtVencimento${i + 1}`).val() != "") {
      parcelas.push($(`#edtVencimento${i + 1}`).val());
    }
  }
  let i = 1;
  let diferenca;
  let valorNota = $("#txtValorNota")
    .html()
    .substring(8)
    .replace(".", "")
    .replace(",", ".");
  let vValor = parseFloat((valorNota / parcelas.length).toFixed(2));
  if (
    valorNota > vValor * parcelas.length ||
    valorNota < vValor * parcelas.length
  ) {
    diferenca = (valorNota - vValor * parcelas.length).toFixed(2);
  }
  let guardaValor = vValor;
  let arrVenctos = await RetornaVencimentos(parcelas);
  $("#tabelaDuplicatas").DataTable().rows().remove().draw(false);
  parcelas.forEach((element) => {
    if (element != "") {
      if (diferenca > 0 || i == 0) {
        vValor = (vValor + parseFloat(diferenca)).toFixed(2);
        diferenca = 0;
      } else {
        vValor = guardaValor;
      }
      if (diferenca < 0 && i == parcelas.length) {
        vValor = (vValor + parseFloat(diferenca)).toFixed(2);
      }
      vValor = `<input type="text" maxlength="8" class="classeValorFin inputs input-default focus form-control maskItens" min="0" id="txtValorRec-${i}" name="txtValorRec-${i}" value="${vValor}">`;
      $("#tabelaDuplicatas")
        .DataTable()
        .row.add([i, arrVenctos[i - 1], vValor])
        .draw(false);
    }
    i++;
  });
  focuValor();
}

function focuValor() {
  $('.classeValorFin').on('focusout', function () {
    $(this).val($(this).val().replace(',', '.'));
    let parcelas = [];
    let diferenca = 0;
    let vValor = 0;
    for (let i = 0; i < 12; i++) {
      if ($(`#edtVencimento${i + 1}`).val() != "") {
        parcelas.push($(`#edtVencimento${i + 1}`).val());
        vValor += parseFloat($(`#txtValorRec-${i + 1}`).val());
      }
    }

    let valorNota = $("#txtValorNota")
      .html()
      .substring(8)
      .replace(".", "")
      .replace(",", ".");

    vValor = parseFloat((valorNota - vValor).toFixed(2));

    const valAtual = parseFloat($(`#txtValorRec-${parcelas.length}`).val());
    if (parseFloat((vValor + valAtual).toFixed(2)) > 0) {
      $(`#txtValorRec-${parcelas.length}`).val(parseFloat((vValor + valAtual).toFixed(2)));
    } else {
      msgAlerta('Valor das parcelas é superior ao total da nota, recalculo será efetuado!');
      simulaFinanceiro();
    }
  });
}

$("#txtValorNota, #txtQuantidade").bind("DOMSubtreeModified", function () {
  setTimeout(() => {
    $(this).css("color", "red");
  }, 200);
  setTimeout(() => {
    $(this).css("color", "inherit");
  }, 2000);
});

$('#txtNumeroVenda').blur(async function () {
  try {
    if ($('#txtNumeroVenda').val() == '') {
      return;
    }

    const codven = pegaChave('#txtNumeroVenda');
    const cliente = pegaDescricao('#txtNumeroVenda');
    let vendaImportada = false;

    $('#tabelaVendas').DataTable().rows().data().map((item) => {
      if (codven == item[1]) {
        vendaImportada = true;
      }
    });

    if (vendaImportada) {
      msgAlerta('Venda já selecionada.');
      return;
    }

    $('#tabelaVendas').DataTable().row.add([botaoSelecionarGrid(), codven, cliente]).draw(false);
    $('#check_todos').prop('checked', false);
    $('#check_todos').trigger('click');
  } finally {
    if (pegaChave('#txtNumeroVenda')) {
      await validaVendaDevolucao(pegaChave('#txtNumeroVenda'));
    }
    $('#txtNumeroVenda').val('');
  }
});

$('#txtPedido').autocompleta(1, `JSON={"tabela":"PEDIDO", 
    "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
    "leftjoin": [ 
      {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
      {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
      {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
    ],
    "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
    "having": ["SUM(PED_ITEN.QTDE) > 0"],
    "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]}`);
$('#txtPedido').blur(async function () {
  try {
    if ($('#txtPedido').val() == '') {
      return;
    }

    const pedido = pegaChave('#txtPedido');
    const cliente = pegaDescricao('#txtPedido');
    let vendaImportada = false;

    $('#tabelaPedidos').DataTable().rows().data().map((item) => {
      if (pedido == item[0]) {
        vendaImportada = true;
      }
    });

    if (vendaImportada) {
      msgAlerta('Pedido já selecionado.');
      return;
    }

    $('#tabelaPedidos').DataTable().row.add([pedido, cliente, retornaBotaoExcluir()]).draw(false);
  } finally {
    $('#txtPedido').val('');
  }
});

async function validaVendaDevolucao(sCodven) {
  const pesquisaParam = {
    tabela: "VENDA",
    camposSelect: ["DEVOLUCAO"],
    where: [`CODVEN = ${sCodven}`],
  };

  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  $('#btnNaturezaVenda').unbind();
  if (jsonStr[0].DEVOLUCAO == '1') {
    $('#txtNaturezaVenda').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '2'"] }`);
    $('#btnNaturezaVenda').pesquisa('#txtNaturezaVenda', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '2'"]}`, 'Pesquisa Natureza', 'natureza');
  } else {
    $('#txtNaturezaVenda').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S' and TP_BASE = '1'"] }`);
    $('#btnNaturezaVenda').pesquisa('#txtNaturezaVenda', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": ["ATIVO = 'S' and TP_BASE = '1'"]}`, 'Pesquisa Natureza', 'natureza');
  }
}

$('#checkTodasEmpresas').on('change', async function () {
  $("#btnNumeroVenda").off();
  if (isChecked('#checkTodasEmpresas')) {
    $("#txtNumeroVenda").autocompleta(
      2,
      `JSON={ "tabela":"venda", "camposSelect":["venda.codven CHAVE, entidade.nome DESCRICAO"], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": null }`
    );
    $("#btnNumeroVenda").pesquisa(
      "#txtNumeroVenda",
      "VENDA",
      "CLIENTE",
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"venda", "camposSelect":[ "venda.codven as venda", "entidade.nome as cliente" ], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": null, "orderBy": ["venda.codven desc"]}`,
      "Pesquisa Venda",
      "venda"
    );
  } else {
    $("#txtNumeroVenda").autocompleta(
      2,
      `JSON={ "tabela":"venda", "camposSelect":["venda.codven CHAVE, entidade.nome DESCRICAO"], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": ["venda.emp_id = ${getCookie(
        "emp_id"
      )}"] }`
    );
    $("#btnNumeroVenda").pesquisa(
      "#txtNumeroVenda",
      "VENDA",
      "CLIENTE",
      `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"venda", "camposSelect":[ "venda.codven as venda", "entidade.nome as cliente" ], "leftjoin": [{"tabela" : "entidade", "condicao" : "venda.codcli = entidade.codcli"}], "where": ["venda.emp_id = ${getCookie(
        "emp_id"
      )}"], "orderBy": ["venda.codven desc"]}`,
      "Pesquisa Venda",
      "venda"
    );
  }

  carregaEmpresasDisponiveis();

  $('#txtNumeroVenda').blur(async function () {
    try {
      if ($('#txtNumeroVenda').val() == '') {
        return;
      }

      const codven = pegaChave('#txtNumeroVenda');
      const cliente = pegaDescricao('#txtNumeroVenda');
      let vendaImportada = false;

      $('#tabelaVendas').DataTable().rows().data().map((item) => {
        if (codven == item[1]) {
          vendaImportada = true;
        }
      });

      if (vendaImportada) {
        msgAlerta('Venda já selecionada.');
        return;
      }

      $('#tabelaVendas').DataTable().row.add([botaoSelecionarGrid(), codven, cliente]).draw(false);
      $('#check_todos').prop('checked', false);
      $('#check_todos').trigger('click');
    } finally {
      if (pegaChave('#txtNumeroVenda')) {
        await validaVendaDevolucao(pegaChave('#txtNumeroVenda'));
      }
      $('#txtNumeroVenda').val('');
    }
  });
});

$('#cbTodasEmpPedido').on('change', async function () {
  $("#btnPedido").off();
  if (isChecked('#cbTodasEmpPedido')) {
    $('#txtPedido').autocompleta(1, `JSON={"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": null}`);

    $('#btnPedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito', '#txtCliente'],
      ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": null
       }`,
      'Pesquisa Pedido',
      () => { $('#txtPedido').trigger('blur'); }
    );
  } else {
    $('#txtPedido').autocompleta(1, `JSON={"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]}`);

    $('#btnPedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito', '#txtCliente'],
      ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]
       }`,
      'Pesquisa Pedido',
      () => { $('#txtPedido').trigger('blur'); }
    );
  }

  $('#txtPedido').blur(async function () {
    try {
      if ($('#txtPedido').val() == '') {
        return;
      }

      const pedido = pegaChave('#txtPedido');
      const cliente = pegaDescricao('#txtPedido');
      let pedidoImportado = false;

      $('#tabelaPedidos').DataTable().rows().data().map((item) => {
        if (pedido == item[0]) {
          pedidoImportado = true;
        }
      });

      if (pedidoImportado) {
        msgAlerta('Pedido já selecionado.');
        return;
      }

      $('#tabelaPedidos').DataTable().row.add([pedido, cliente, retornaBotaoExcluir()]).draw(false);
    } finally {
      $('#txtPedido').val('');
    }
  });
});

$('#cbSomenteExpedidos').on('change', async function () {
  $("#btnPedido").off();
  if (isChecked('#cbSomenteExpedidos')) {
    setCookie('faturar_ped_somente_exp', isChecked('#cbSomenteExpedidos') ? 'S' : 'N', 30);
    $('#cbTodasEmpPedido').prop('checked', false);
    $('#txtPedido').autocompleta(1, `JSON={"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"},
          {"tabela": "PEDIDO3", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "where": ["EXISTS(SELECT PEDIDO3.NUMERO FROM [PEDIDO3] PEDIDO3 WHERE PEDIDO.NUMERO = PEDIDO3.NUMERO) AND PEDIDO3.QTDE > 0"]}`);

    $('#btnPedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito', '#txtCliente'],
      ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"},
          {"tabela": "PEDIDO3", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "where": ["EXISTS(SELECT PEDIDO3.NUMERO FROM [PEDIDO3] PEDIDO3 WHERE PEDIDO.NUMERO = PEDIDO3.NUMERO) AND PEDIDO3.QTDE > 0"]
       }`,
      'Pesquisa Pedido',
      () => { $('#txtPedido').trigger('blur'); }
    );
  } else {
    $('#txtPedido').autocompleta(1, `JSON={"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]}`);

    $('#btnPedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito', '#txtCliente'],
      ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"},
          {"tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO"}
        ],
        "groupby": [ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI" ],
        "having": ["SUM(PED_ITEN.QTDE) > 0"],
        "where": ["PEDIDO.EMP_ID = ${getCookie('emp_id')}"]
       }`,
      'Pesquisa Pedido',
      () => { $('#txtPedido').trigger('blur'); }
    );
  }

  $('#txtPedido').blur(async function () {
    try {
      if ($('#txtPedido').val() == '') {
        return;
      }

      const pedido = pegaChave('#txtPedido');
      const cliente = pegaDescricao('#txtPedido');
      let pedidoImportado = false;

      $('#tabelaPedidos').DataTable().rows().data().map((item) => {
        if (pedido == item[0]) {
          pedidoImportado = true;
        }
      });

      if (pedidoImportado) {
        msgAlerta('Pedido já selecionado.');
        return;
      }

      $('#tabelaPedidos').DataTable().row.add([pedido, cliente, retornaBotaoExcluir()]).draw(false);
    } finally {
      $('#txtPedido').val('');
    }
  });
});

$('#tabelaPedidos').on('click', '#btn-excluir', async function () {
  $('#tabelaPedidos').DataTable().row($(this).parents('tr')).remove().draw(false);
});

$("#btn-importar-venda").on("click", function () {
  $("#modal-importar-venda").modal("show");
});

$('#tabImpPedido').on('click', function () {
  setTimeout(() => {
    $('#tabelaPedidos').DataTable().columns.adjust().draw(false);
  }, 250);
});

$('#modal-importar-venda').on('shown.bs.modal', async function () {
  $('#tabelaVendas').DataTable().columns.adjust().draw(false);

  const paramsVenda = await BuscaParametrosVenda();

  if (paramsVenda[5] == '1') {
    $('#divPrazoVenda').addClass('d-none');
  } else {
    $('#divPrazoVenda').removeClass('d-none');
  }
});

$("#btnDesconto").on("click", function () {
  $("#modalDesconto").modal("show");
});

$("#btnFrete").on("click", function () {
  $("#modalFrete").modal("show");
});

$("#btnDespesa").on("click", function () {
  $("#modalDespesa").modal("show");
});

$("#btn_confirmar_venda").on("click", function () {
  const tabela = $("#tabelaVendas").DataTable().rows(".selected").data();
  if ($('#tabelaVendas').DataTable().rows(".selected").count() == 0) {
    msgAlerta("Nenhuma venda selecionada para importar, favor verificar.");
    return;
  }

  if ($("#txtOperacaoVenda").val() == "") {
    if ($("#txtNaturezaVenda").val() == "") {
      msgAlerta("Informe uma natureza para continuar.");
      return;
    }
  }

  // insereValor('#txtNumeroVenda', $('#tabelaVendas').DataTable().rows(0).data()[0][1], $('#tabelaVendas').DataTable().rows(0).data()[0][2]);
  insereValor('#txtNumeroVenda', tabela[0][1], tabela[0][2]);

  const numeroVenda = pegaChave("#txtNumeroVenda");
  const naturezaVenda = pegaChave("#txtNaturezaVenda");
  const operacaoVenda = pegaChave("#txtOperacaoVenda");
  $("#txtNatureza").val($("#txtNaturezaVenda").val());

  let vendas = [];
  // $('#tabelaVendas').DataTable().rows().data().map((item) => { vendas.push(item[1]) });
  tabela.map((item) => {
    vendas.push(item[1]);
  });
  escondeFs();
  faturarVenda(numeroVenda, naturezaVenda, operacaoVenda, vendas);

  $("#movEstoqueCheck").prop("checked", false);

  $("#modal-importar-venda").modal("hide");
});

async function faturarVenda(iVenda, iNatureza, iOperacao, iVendas, sCodcli = '') {
  $.LoadingOverlay("show");
  try {
    let separador = " - ";
    let totValorNota = 0;
    let totValorItens = 0;
    let totQtde = 0;
    let totalIcms = 0;
    let totalIpi = 0;
    let valorBruto = 0;
    let totalPis = 0;
    let totalCofins = 0;
    let desconto = $("#txtDescontoTotal").val();
    let frete = $("#txtFreteTotal").val();
    let totalIcmsst = 0;
    let baseIcmsst = 0;
    let baseIcms = 0;
    let baseIpi = 0;
    let basePisCofins = 0;

    try {
      let nota = {};
      nota.CODVEN = iVenda;
      nota.NATUREZA = iNatureza;
      if (iOperacao != "") {
        nota.OPERACAO = iOperacao;
      }
      nota.ESTOQUE = "N";
      nota.VENDAS = iVendas.toString();
      nota.CODCLI = sCodcli;

      if (!isChecked('#checkTodasEmpresas')) {
        nota.EMPID = getCookie('emp_id');
      } else {
        nota.EMPID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length)).join(',')
          : getCookie('emp_id');
      }

      let response = await requisicao("GET", "/Sisplan/NFe/v1/ConverteVenda?", `JSON=${encodeURIComponent(JSON.stringify(nota))}&PRECO_TAB_PRECO=${pegaChave('#txtTabPrecoVenda')}&PRECO_PRAZO=${$('#selectPrazoVenda').val()}`, null, 600000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      const arrDados = jsonStr;

      if (iNatureza == "" && iOperacao != "") {
        if (arrDados.natureza != "") {
          descNatureza = await BuscaDescricao("natureza", "descricao", "natureza", arrDados.natureza);
          insereValor("#txtNatureza", arrDados.natureza, descNatureza.DESCRICAO);
        } else {
          msgAlerta(
            "Itens sem natureza informada na regra. Favor informar uma natureza manualmente."
          );
        }
      }

      if (notaUrl == "create") {
        insereValor("#txtCliente", arrDados.codCli, arrDados.nome);
        $("#txtCliente").trigger("blur");
      }
      insereValor("#txtRepresentante", arrDados.codRep, arrDados.nomeRep);
      insereValor('#txtTransportadora', arrDados.transportadora, arrDados.nomeTransportadora);
      $('#txtVolumes').val(arrDados.volumes);
      $('#rgTransportador').val(arrDados.tipoTransporte).change();
      if ($('#rgPresenca').val() == '') {
        $('#rgPresenca').val(arrDados.indPresenca).change();
      }
      desconto = arrDados.desconto > 0 ? arrDados.desconto.toFixed(2) : "0.00";
      frete = arrDados.valFrete > 0 ? arrDados.valFrete.toFixed(2) : "0.00";
      acres = arrDados.acres > 0 ? arrDados.acres.toFixed(2) : "0.00";

      $("#txtReducao").val($("#txtOperacaoVenda").val());
      await buscaDeposito();

      const { itens } = arrDados;

      let index = $(".itens").length - 1;
      while (index != 0) {
        await DeleteItem(index);
        $(`.removido`).closest(".row").remove();
        index--;
      }

      let ultimoID = $(".itens").length - 1;
      await itens.forEach(async function () {
        await AddItens();
      });

      if (itens.length > 0) {
        if (itens[0].deposito != '') {
          insereValor('#txtDeposito', itens[0].deposito, itens[0].descDeposito);
        }
      }

      for (let i = 0; i < itens.length; i++) {
        const item = itens[i];
        $(`#txtProduto-${ultimoID}`).val(`${item.codigo} ${item.descricao}${separador}${item.cor} ${item.descCor}${separador}${item.tamanho}`);
        $(`#txtProduto-${ultimoID}`).attr("data-codigo", item.codigo);
        $(`#txtProduto-${ultimoID}`).attr("data-descricao", item.descricao);
        $(`#txtProduto-${ultimoID}`).attr("data-cor", item.cor);
        if (item.tipoItem == "P") {
          $(`#txtProduto-${ultimoID}`).attr("data-tam", item.tamanho);
        }
        $(`#txtProduto-${ultimoID}`).attr("data-tipo", item.tipoItem);

        $(`#txtQuantidade-${ultimoID}`).val(item.qtde);
        $(`#txtPreco-${ultimoID}`).val(item.precoLiq);

        insereValor(`#txtCFOP-${ultimoID}`, arrDados.natureza, "NATUREZA");

        $(`#txtICMS-${i}`).val(parseFloat(item.percICMS).toFixed(2));
        $(`#txtIPI-${i}`).val(parseFloat(item.percIpi).toFixed(2));

        insereValor(`#txtCFOP-${i}`, item.natureza, item.descNatureza);
        insereValor(`#txtNCM-${i}`, item.claFis, item.descClaFis);
        insereValor(`#txtEnquadra${i}`, item.enquadra, item.descEnquadra);
        insereValor(`#txtCsosn${i}`, item.claCSOSN, item.descClaCSOSN);
        insereValor(`#txtCstIcms${i}`, item.claTrib, item.descClaTrib);
        insereValor(`#txtCstIpi${i}`, item.claIPI, item.descClaIPI);
        insereValor(`#txtCstPis${i}`, item.claPis, item.descClaPis);
        insereValor(`#txtCstCofins${i}`, item.claCofins, item.descClaCofins);

        limpaValoresIncorretos(seletorPorNome("txtCFOP", i));
        limpaValoresIncorretos(seletorPorNome("txtNCM", i));
        limpaValoresIncorretos(seletorPorNome("txtEnquadra", i));
        limpaValoresIncorretos(seletorPorNome("txtCsosn", i));
        limpaValoresIncorretos(seletorPorNome("txtCstIcms", i));
        limpaValoresIncorretos(seletorPorNome("txtCstIpi", i));
        limpaValoresIncorretos(seletorPorNome("txtCstPis", i));
        limpaValoresIncorretos(seletorPorNome("txtCstCofins", i));

        totValorNota += item.valorLiq;
        valorBruto += item.valor;
        totQtde += item.qtde;
        totValorItens += item.baseICMS;
        totalIcms += item.valorICMS - item.valICMSDif;
        totalIpi += item.valorIPI;
        totalPis += item.valorPis;
        totalCofins += item.valorCofins;
        totalIcmsst += item.valorICMSST;
        baseIcmsst += item.baseICMSST;
        baseIcms += item.baseICMS;
        baseIpi += item.baseIPI;
        basePisCofins += item.basePisCofins;

        $(`#txtValorProduto${i}`).val(item.valorLiq);
        $(`#txtValorBruto${i}`).val(item.valor);
        $(`#txtTotQtde${i}`).val(item.qtde);
        $(`#txtTotValorItens${i}`).val(item.baseICMS);
        $(`#txtTotalIcms${i}`).val(item.valorICMS);
        $(`#txtTotalIpi${i}`).val(item.valorIPI);
        $(`#txtTotalPis${i}`).val(item.valorPis);
        $(`#txtTotalCofins${i}`).val(item.valorCofins);
        $(`#txtTotalICMSST${i}`).val(item.valorICMSST);
        $(`#txtBaseST${i}`).val(item.baseICMSST);
        $(`#txtBaseIPI${i}`).val(item.baseIPI);
        $(`#txtBaseICMS${i}`).val(item.baseICMS);
        $(`#txtBasePISCOFINS${i}`).val(item.basePisCofins);

        ultimoID++;
      }

      totQtde = totQtde.toFixed(2);

      if (parseFloat(totalIpi) == 0 || totalIpi == "" || isNaN(totalIpi)) {
        totalIpi = 0;
      }

      totValorNota += totalIpi + totalIcmsst;

      $("#txtFreteTotal").val(frete);
      $("#txtDescontoTotal").val(desconto);
      $("#txtDespesaTotal").val(acres);

      $("#txtDesconto").html(
        parseFloat(desconto).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorPIS").html(
        parseFloat(totalPis).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorCofins").html(
        parseFloat(totalCofins).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorNota").html(
        parseFloat(totValorNota).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorFinanceiro").html(
        parseFloat(totValorNota).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtBaseICMS").html(
        parseFloat(baseIcms).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtBaseIPI").html(
        parseFloat(baseIpi).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtBasePISCOFINS").html(
        parseFloat(basePisCofins).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtBaseICMSST").html(
        parseFloat(baseIcmsst).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorICMSST").html(
        parseFloat(totalIcmsst).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorICMS").html(
        parseFloat(totalIcms).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtTotalIPI").html(
        parseFloat(totalIpi).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      $("#txtValorBruto").html(
        parseFloat(valorBruto).toLocaleString("pt-BR", {
          style: "currency",
          currency: "BRL",
        })
      );

      if ((parseFloat(desconto) > 0) || (parseFloat(frete) > 0) || (parseFloat(acres) > 0)) {
        await aplicaDesconto();
      }

      $("#txtQuantidade").html(parseFloat(totQtde));

      simulaFinanceiro();
      await calculaPesoItens();
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da venda.");
    }
  } finally {
    await buscaMensagem();
    $("#txtCliente").trigger("change");
    $("#txtReducao").trigger("blur");
    $('#movEstoqueCheck').prop('disabled', true);
    $('#txtNatureza').trigger('blur');
    await buscaInfosFinanceirasCliente();
    $.LoadingOverlay("hide");
  }
}

async function BuscaDescricao(Tabela, CampoBusca, CampoWhere, Codigo) {
  const dadosSelect = {
    tabela: `${Tabela}`,
    camposSelect: [`${CampoBusca}`],
    where: [`${CampoWhere} = '${Codigo}'`],
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(
    JSON.stringify(dadosSelect)
  );
  if (!retornoSelect) {
    return;
  }
  let Descricao = retornoSelect[0];
  return Descricao;
}


$("#txtNatureza").on("blur", async function () {

  let itens = $(".itens");
  for (let i = 0; i < itens.length; i++) {
    $(seletorPorNome("txtCFOP", i)).val($("#txtNatureza").val());
    $(seletorPorNome("txtICMS", i)).val("0.00");
    $(seletorPorNome("txtIPI", i)).val("0.00");
    $(seletorPorNome("txtNCM", i)).val("");
    $(seletorPorNome("txtEnquadra", i)).val("");
    $(seletorPorNome("txtCsosn", i)).val("");
    $(seletorPorNome("txtCstIcms", i)).val("");
    $(seletorPorNome("txtCstIpi", i)).val("");
    $(seletorPorNome("txtCstPis", i)).val("");
    $(seletorPorNome("txtCstCofins", i)).val("");
  }
  aplicaDesconto();
  escondeFs();
  buscaMensagem();
  buscaGerarDifal();
});

async function buscaGerarDifal() {
  $.LoadingOverlay("show");
  try {
    let codNatureza = pegaChave("#txtNatureza");
    let responseNat = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"natureza", "camposSelect":["NAO_GERA_DIFAL"], 
            "where": ["natureza = '${codNatureza}'"]}`,
      null
    );
    let jsonNat = await responseNat.json();
    $("#gerarDifal").prop("checked", (codNatureza.startsWith('2') || codNatureza.startsWith('6')) && $("#consumidorFinal").prop("checked") && jsonNat.RESULT[0][0].NAO_GERA_DIFAL != 'S');
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function buscaMensagem() {
  if ($("#txtNatureza").val() != "") {
    let codNatureza = pegaChave("#txtNatureza");
    try {
      let responseOperadora = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"natureza", "camposSelect":["mensagem", "NAO_GERA_DIFAL", "TIPO", "FINALIDADE_NFE"], 
              "where": ["natureza = '${codNatureza}'"]}`,
        null
      );
      let jsonStr = await responseOperadora.json();
      $("#txtDados").val(jsonStr.RESULT[0][0].MENSAGEM);

      if (jsonStr.RESULT[0][0].NAO_GERA_DIFAL == "S") {
        $("#gerarDifal").prop("checked", false);
      }
      const possuiNotasReferenciadas = $('#tabelaNotasRef').DataTable().data().toArray().length > 0;
      bNaturezaDevolucao = (jsonStr.RESULT[0][0].TIPO == 'D') || (jsonStr.RESULT[0][0].FINALIDADE_NFE == '4');
      if (bNaturezaDevolucao && possuiNotasReferenciadas) {
        $('#tabelaNotasRef').DataTable().data().toArray().forEach(nota => {
          const chaveNotaReferenciada = nota[14];
          const dadosAntigos = $("#txtDados").val();
          $("#txtDados").val(`${dadosAntigos} REF. A NF: ${chaveNotaReferenciada}\r\n`);
        });
      }
    } catch (error) {
      console.error(error);
    }
  }
}

async function escondeFs() {
  let natureza = {};
  natureza.NATUREZA = pegaChave("#txtNatureza", natureza.NATUREZA);
  natureza.CODVEN = pegaChave("#txtNumeroVenda", natureza.CODVEN);
  natureza.ESTOQUE = "N";
  try {
    let response = await requisicao(
      "GET",
      "/Sisplan/NFe/v1/Faturamento?",
      `JSON=${encodeURIComponent(JSON.stringify(natureza))}`,
      null
    );

    if (!response) {
      $.LoadingOverlay("hide");
      return;
    }
    let jsonStr = await response.json();

    if (jsonStr == 0) {
      $("#financeiroFs").addClass("d-none");
      $("#personal").addClass("d-none");
      $("#progressbar li").css("width", "33.3333%");
    } else {
      $("#financeiroFs").removeClass("d-none");
      $("#personal").removeClass("d-none");
      $("#progressbar li").css("width", "25%");
    }
  } catch (error) {
    console.error(error);
  }
}

async function calculaPesoItens() {
  if (calculaPeso == "") {
    calculaPeso = (await CopiaParametro("FATURAMENTO", 0)) == 1;
  }
  if (!calculaPeso) {
    return;
  }
  try {
    const qtdeItens = $(".itens").length;
    let itens = [];
    for (let i = 0; i < qtdeItens; i++) {
      if (
        $(`#txtProduto-${i}`).val() != "" &&
        $(`#txtQuantidade-${i}`).val() != ""
      ) {
        let item = {};
        item.TIPOITEM = $(`#txtProduto-${i}`).attr("data-tipo");
        item.CODIGO = $(`#txtProduto-${i}`).attr("data-codigo");
        item.QTDE = $(`#txtQuantidade-${i}`).val();
        itens.push(item);
      }
    }

    if (!(itens.length > 0)) {
      $("#txtPesoBruto").val("0");
      $("#txtPesoLiq").val("0");
      return;
    }

    const nota = {
      ITENS: itens,
    };
    const url = "/sisplan/nfe/v1/calculapeso?";
    const params = JSON.stringify(nota);
    const response = await requisicao("POST", url, '', params);
    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      return;
    }

    if (jsonStr.pesoBruto > 0) {
      $("#txtPesoBruto").val(jsonStr.pesoBruto);
    }
    if (jsonStr.pesoLiquido > 0) {
      $("#txtPesoLiq").val(jsonStr.pesoLiquido);
    }
  } catch (error) {
    console.error(error);
  }
}

$("#ultimoVoltar").click(async function () {
  if ($("#financeiroFs").hasClass("d-none")) {
    setTimeout(function () {
      $("#voltarFinanceiro").trigger("click");
    }, 100);
  }
});

$("#radioEntrada, #radioSaida").on("change", function () {
  $("#tabelaImportarNotas").empty();
  $("#txtSerie").val("");
  $("#txtNota").val("");
  $("#txtNaturezaNota").val("");
  $("#txtClienteNota").val("");
  if ($("#radioEntrada").is(":checked")) {
    $("#divClienteNota").removeClass("d-none");
  } else {
    $("#divClienteNota").addClass("d-none");
  }
});

function preencheSerie() {
  $('#txtSerie').val($('#txtNota').attr('data-desc'));
}

$("#radioEntrada, #radioSaida").on("change", function () {
  $("#tabelaImportarNotas").empty();
  $("#txtSerie").val("");
  $("#txtNota").val("");
  $("#txtNaturezaNota").val("");
  $("#txtClienteNota").val("");
  if ($("#radioEntrada").is(":checked")) {
    $("#divClienteNota").removeClass("d-none");
  } else {
    $("#divClienteNota").addClass("d-none");
  }
  $("#btnPesquisaNota").unbind();
  if ($('#radioSaida').is(':checked')) {
    $("#txtNota").autocompleta(3, `JSON={ "tabela":"NOTA", "camposSelect":["FATURA CHAVE", "SERIE DESCRICAO"], "where": null}`, undefined, undefined, undefined, () => { preencheSerie(); });
    $('#btnPesquisaNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], '{"tabela":"NOTA", "camposSelect":["NOTA.FATURA", "NOTA.SERIE", "ENTIDADE.NOME", "NOTA.EMP_ID"], "leftjoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}]}', 'Pesquisa de Nota', () => { preencheSerie(); });
  } else {
    $("#txtNota").autocompleta(3, `JSON={ "tabela":"NOTA_ENTRA", "camposSelect":["NOTAFISCAL CHAVE", "SERIE DESCRICAO"], "where": null}`, undefined, undefined, undefined, () => { preencheSerie(); });
    $('#btnPesquisaNota').pesquisa_serverside(['#txtNota'], ['NOTA_ENTRA.NOTAFISCAL'], ['NOTA_ENTRA.SERIE'], '{"tabela":"NOTA_ENTRA", "camposSelect":["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE", "ENTIDADE.NOME", "NOTA_ENTRA.EMP_ID"], "leftjoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA_ENTRA.CODCLI_CTA_ORDEM"}]}', 'Pesquisa de Nota', () => { preencheSerie(); });
  }
}).trigger('change');

$('#btnApagaNota').on('click', function () {
  $("#txtNota, #txtSerie").val('')
})

$("#btn-consulta-imp-notas").on("click", async function () {
  const bNatOperacao = (pegaValor('#txtNaturezaNota') == '') && (pegaValor('#txtOperacaoNota') == '');

  if ($("#txtSerie").val() == "" || pegaChave("#txtNota") == "" || bNatOperacao) {
    msgAlerta("Necessário informar todos os dados para consultar.");
    return;
  }
  if ($("#radioEntrada").is(":checked") && $("#txtClienteNota").val() == "") {
    msgErro("Necessário informar um cliente para consultar.");
    return;
  }

  let sSerie = $("#txtSerie").val();
  let sNota = pegaChave("#txtNota");
  let sNatureza = $("#txtNaturezaNota").val();
  let sCliente = pegaChave("#txtClienteNota");

  if (estaNaArqLocal == "") {
    await validaArqLocal();
  }

  await preencheItensTabela(
    sSerie,
    sNota,
    sNatureza,
    sCliente,
    $("#radioEntrada").is(":checked")
  );
});

async function preencheItensTabela(
  sSerie,
  sNota,
  sNatureza,
  sCliente,
  bEntrada
) {
  let tabela = "";
  let campos = "";
  let leftjoin = "";
  let where = "";
  let dataSet = [];
  let dataSetCols = [];

  $.LoadingOverlay("show");
  try {
    if (!bEntrada) {
      tabela = "NOTAITEN";
      campos = `"NOTAITEN.CODIGO", "NOTAITEN.DESCRICAO", "NOTAITEN.COR", "CADCOR.DESCRICAO DESC_COR", "NOTAITEN.TAMANHO TAM", "NOTAITEN.QTDE QTDE_ORIG", "NOTAITEN.QTDE QTDE_IMP", "NOTAITEN.PRECO", "NOTAITEN.TIPO_IT TIPO"`;
      where = `FATURA = '${sNota}' AND SERIE = '${sSerie}'`;
    } else {
      tabela = "NF_ENTRA_ITEN";
      campos = `"NF_ENTRA_ITEN.CODIGO", "NF_ENTRA_ITEN.DESCRICAO", "NF_ENTRA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "NF_ENTRA_ITEN.TAM", "NF_ENTRA_ITEN.QTDE QTDE_ORIG", "NF_ENTRA_ITEN.QTDE QTDE_IMP", "NF_ENTRA_ITEN.VALOR PRECO", "NF_ENTRA_ITEN.TIPO"`;
      where = `NUMERO = '${sNota}' AND SERIE = '${sSerie}' AND CODCRE = '${sCliente}'`;
    }
    leftjoin = `{"tabela": "CADCOR", "condicao": "CADCOR.COR = ${tabela}.COR"}`;

    const url = `/sisplan/funcoes/v1/pesquisa?`;
    const params = `JSON={"tabela": "${tabela}","camposSelect": [${campos}], "leftjoin": [${leftjoin}],"where": ["${where}"]}`;
    const response = await requisicao("GET", url, params, 15000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.mensagem);
    }

    if ($.isEmptyObject(jsonStr.RESULT[0])) {
      msgAlerta("Nenhuma nota encontrada, favor verificar os dados.");
      return;
    }

    dataSet = jsonStr.RESULT[0];
    let keys = Object.keys(jsonStr.RESULT[0][0]);

    for (let k in keys) {
      dataSetCols.push({
        title: keys[k],
        data: keys[k],
      });
    }

    dataSetCols[6].render = function (data, type, row) {
      return retornaInputQtde(data);
    };

    $("#tabelaImportarNotas").DataTable({
      destroy: true,
      select: true,
      keys: false,
      searching: false,
      lengthChange: false,
      scrollY: "300px",
      scrollCollapse: true,
      paging: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columns: dataSetCols,
      data: dataSet,
    });

    $(".inputqtde").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#btn_confirmar_nota").on("click", async function () {
      if ($("#tabelaImportarNotas").DataTable().rows().count() == 0) {
        msgAlerta("Selecione uma nota válida para importar.");
        return;
      }

      const bNatOperacao = (pegaValor('#txtNaturezaNota') == '') && (pegaValor('#txtOperacaoNota') == '');
      if ($("#txtSerie").val() == "" || pegaChave("#txtNota") == "" || bNatOperacao) {
        msgAlerta("Necessário informar todos os dados para importar.");
        return;
      }
      if ($("#radioEntrada").is(":checked") && $("#txtClienteNota").val() == "") {
        msgErro("Necessário informar um cliente para importar.");
        return;
      }
      await importaCapaNota(sSerie, sNota, sNatureza, sCliente, bEntrada, $("#txtOperacaoNota").val());
      await buscaDeposito();
      await importaItensNota(sNatureza);
      await escondeFs();

      if ((pegaValor('#txtCFOP-0') != '') && (pegaValor('#txtNatureza') == '')) {
        insereValor('#txtNatureza', pegaValor('#txtCFOP-0'));
      }

      await buscaMensagem();
      await criarToolTipCliente(pegaChave('#txtCliente'));
    });
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function importaCapaNota(
  sSerie,
  sNota,
  sNatureza,
  sCliente,
  bEntrada,
  sOperacao = ""
) {
  let tabela = "";
  let campos = "";
  let leftjoin = "";
  let where = "";

  $.LoadingOverlay("show");
  try {
    if (!bEntrada) {
      tabela = "NOTA";
      campos = `"NOTA.CODCLI", "ENTIDADE.NOME"`;
      where = `FATURA = '${sNota}' AND SERIE = '${sSerie}'`;
    } else {
      tabela = "NOTA_ENTRA";
      campos = `"NOTA_ENTRA.CREDOR CODCLI", "ENTIDADE.NOME"`;
      where = `NOTAFISCAL = '${sNota}' AND SERIE = '${sSerie}' AND CREDOR = '${sCliente}'`;
    }
    leftjoin = `{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = ${tabela}.${bEntrada ? "CREDOR" : "CODCLI"
      }"}`;

    const url = `/sisplan/funcoes/v1/pesquisa?`;
    const params = `JSON={"tabela": "${tabela}","camposSelect": [${campos}], "leftjoin": [${leftjoin}],"where": ["${where}"]}`;
    const response = await requisicao("GET", url, params, null);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.mensagem);
    }

    if ($.isEmptyObject(jsonStr.RESULT[0])) {
      msgAlerta("Nenhuma nota encontrada, favor verificar os dados.");
      return;
    }

    insereValor(
      "#txtCliente",
      jsonStr.RESULT[0][0].CODCLI,
      jsonStr.RESULT[0][0].NOME
    );
    $("#txtCliente").trigger("blur");
    insereValor("#txtNatureza", sNatureza);
    insereValor("#txtReducao", sOperacao);

    if (sOperacao != '') {
      const sPresenca = await buscaValor('OPER_FISCAL', 'PRESENCA', 'CODIGO', pegaChave('#txtReducao'));
      if (sPresenca.PRESENCA != '') {
        $('#rgPresenca').val(sPresenca.PRESENCA).change();
      }
    }
  } finally {
    $('#txtNatureza').trigger('blur');
    $("#modal-importar-venda").modal("hide");
    $.LoadingOverlay("hide");
  }
}

async function importaItensNota(sNatureza) {
  $.LoadingOverlay("show");
  try {
    let ultimoID = 0;
    $("#tabelaImportarNotas")
      .DataTable()
      .rows()
      .data()
      .map((item, index) => {
        if ($($(".inputqtde")[index]).val() != "") {
          $(`#txtProduto-${ultimoID}`).val(
            `${item.CODIGO} ${item.DESCRICAO} - ${item.COR} ${item.DESC_COR}${item.TIPO == "P" ? ` - ${item.TAM}` : ""
            }`
          );
          $(`#txtQuantidade-${ultimoID}`).val($($(".inputqtde")[index]).val());
          $(`#txtPreco-${ultimoID}`).val(item.PRECO);
          $(`#txtCFOP-${ultimoID}`).val(sNatureza);

          $(`#txtProduto-${ultimoID}`).attr("data-codigo", item.CODIGO);
          $(`#txtProduto-${ultimoID}`).attr("data-descricao", item.DESCRICAO);
          $(`#txtProduto-${ultimoID}`).attr("data-cor", item.COR);
          if (item.TIPO == "P") {
            $(`#txtProduto-${ultimoID}`).attr("data-tam", item.TAM);
          }
          $(`#txtProduto-${ultimoID}`).attr("data-tipo", item.TIPO);
          ultimoID += 1;
          AddItens();
        }
      });
    await aplicaDesconto();
  } finally {
    $.LoadingOverlay("hide");
  }
}

function retornaInputQtde(qtde) {
  return `<input type="text" class="input-default focus inputqtde" value="${qtde}">`;
}

async function validaArqLocal() {
  try {
    let response = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"arqlocal", 
          "camposSelect":["arquivo"], 
          "where": ["arquivo = 'NOTA_001'"]}`,
      null
    );

    if (!response) {
      return;
    }
    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    estaNaArqLocal = jsonStr.RESULT[0].length > 0;
  } catch (error) {
    console.error(error);
  }
}

$("#rgTipoItem, #rgEntradaSaida").on("change", function () {
  const tipoMov = $("#rgEntradaSaida").val() == 0 ? "E" : "S";
  $("#txtDocumento").val("");
  $("#btnDocumentoMovimentacao").unbind();
  const tipoItem = $("#rgTipoItem").val();

  if (tipoItem == 0) {
    $('#precoCusto').prop('disabled', false);
    $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"PA_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, DT_MVTO DESCRICAO"], "where": ["OPERACAO = '${tipoMov}'"] }`, [], [], []);
    $("#btnDocumentoMovimentacao").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MVTO"], `{"tabela":"PA_MOV", "camposSelect":[ "NUM_DOCTO", "DT_MVTO"], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MVTO"], "where": ["OPERACAO  = '${tipoMov}'"]}`, "Pesquisa Documento");
  } else {
    $('#precoCusto').prop('disabled', true);
    $('#precoCusto').prop('checked', false);
    $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"MAT_MOV", "camposSelect":["DISTINCT NUM_DOCTO CHAVE, DT_MOVTO DESCRICAO"], "where": ["OPERACAO = '${tipoMov}'"] }`, [], [], []);
    $("#btnDocumentoMovimentacao").pesquisa("#txtDocumento", "NUM_DOCTO", "DT_MOVTO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_MOV", "camposSelect":[ "DISTINCT NUM_DOCTO", "DT_MOVTO" ], "where": ["OPERACAO = '${tipoMov}'"]}`, "Pesquisa Documento", "MAT_MOV");
  }
});

let documentos = [];
$("#btn_confirmar_movimentacao").on("click", async function () {
  const documento = pegaChave("#txtDocumento");
  const cliente = $("#txtClienteMovimentacao").val();
  const natureza = $("#txtNaturezaMovimentacao").val();
  const regiao = pegaChave("#txtTabPrecoMovimentacao") != '' ? pegaChave("#txtTabPrecoMovimentacao") : $("#precoCusto").prop("checked") ? 'CUSTO' : '';
  const operacao = $("#txtOperacaoMovimentacao").val();
  const tipo = $("#rgTipoItem").val() == 0 ? "P" : "M";

  let validacao = "";
  if (operacao != "") {
    validacao =
      documento == "" || cliente == "" || regiao == "" || operacao == "";
  } else {
    validacao =
      documento == "" || cliente == "" || natureza == "" || regiao == "";
  }

  if (validacao) {
    msgAlerta("Necessário preencher os campos para realizar a importação.");
    return;
  }

  if (documentos.length > 0) {
    if (!await verificaMovimentacaoImportada(documento)) {
      documentos.push(documento);
    } else {
      msgAlerta(`Impossível continuar, documento ${documento} já importado!`);
      return;
    }
  } else {
    documentos.push(documento);
  }

  $.LoadingOverlay("show");
  try {
    const itensMov = await retornaItensMov(documento, regiao, tipo, $("#precoCusto").prop("checked"));
    await preencheCapaNota(
      cliente,
      natureza,
      operacao,
      itensMov[0].DEPOSITO,
      itensMov[0].DESC_DEPOSITO
    );
    await buscaDeposito();
    await preencheItensMovimentacao(itensMov, natureza, tipo, $("#agrupItensMov").prop("checked"), false, true);
    await escondeFs();

  } finally {
    await calculaPesoItens();
    await criarToolTipCliente(pegaChave('#txtClienteMovimentacao'));
    $("#txtCliente").trigger('blur');
    $("#modal-importar-venda").modal("hide");
    $.LoadingOverlay("hide");
  }
});

async function verificaMovimentacaoImportada(documento) {
  for (let i = 0; i < documentos.length; i++) {
    if (documentos[i] == documento) {
      return true;
    }
  }
  return false;
}

async function preencheItensMovimentacao(itens, natureza, tipo, agrup = true, bPedido = false, bMov = false) {
  itens.forEach(async (item) => {
    const index = $(".itens").length - 1;
    if ((!agrup) || (!incrementaProdutoExistente(item.CODIGO, item.COR, tipo == "P" ? item.TAMANHO : "", +item.QTDE))) {
      $(`#txtProduto-${index}`).val(`${item.CODIGO} ${item.DESCRICAO} - ${item.COR} ${item.DESC_COR}${tipo == "P" ? ` - ${item.TAMANHO}` : ""}`);
      $(`#txtQuantidade-${index}`).val(item.QTDE);
      $(`#txtPreco-${index}`).val(item.PRECO_00);
      $(`#txtCFOP-${index}`).val(natureza);

      $(`#txtProduto-${index}`).attr("data-codigo", item.CODIGO);
      $(`#txtProduto-${index}`).attr("data-descricao", item.DESCRICAO);
      $(`#txtProduto-${index}`).attr("data-cor", item.COR);
      const documento = pegaChave('#txtDocumento');
      if (documento != '') {
        $(`#txtProduto-${index}`).attr("data-documento", documento);
      }

      if (tipo == "P") {
        $(`#txtProduto-${index}`).attr("data-tam", item.TAMANHO);
      }
      $(`#txtProduto-${index}`).attr("data-tipo", tipo);

      if (bPedido) {
        $(`#txtProduto-${index}`).attr("data-pedido", item.NUMERO);
      }

      await AddItens();
    }
    // if ($(`#txtProduto-${index}`).val() != '' && $(`#txtQuantidade-${index}`).val() != '' && $(`#txtPreco-${index}`).val() != '') {
    //   $(`#txtQuantidade-${index}`).trigger("change");
    // }
  });
  removeProdutosVazios();

  setTimeout(async () => {
    // await aplicaDesconto();
    await calculaTotaisItens();
    if ((pegaValor('#txtCFOP-0') != '') && (pegaValor('#txtNatureza') == '')) {
      insereValor('#txtNatureza', pegaValor('#txtCFOP-0'));
    }
    if (bPedido) {
      await validaDescontoPedido(itens[0].PER_DESC);

      if ((itens[0].IND_QTDE != 100) && (await CopiaParametro("FATURAMENTO", 3) == '1')) {
        await recalculaValorIndice(itens[0].IND_QTDE, 2);
      }
    }
  }, 1000);

  if (natureza == "") {
    await VerificaItensAdicionaNatureza(itens);
  }
}

async function VerificaItensAdicionaNatureza(itens) {
  itemSemNatureza = false;
  itens.forEach(async () => {
    const index = $(".itens").length - 1;
    if (
      $(`#txtCFOP-${index}`).val() == "" &&
      $(`#txtProduto-${index}`).val() != ""
    ) {
      itemSemNatureza = true;
      return false;
    }
  });
  if (itemSemNatureza == false) {
    $("#txtNatureza").val($(`#txtCFOP-0`).val());
  }
}

function preencheCapaNota(cliente, natureza, operacao, deposito, descDeposito) {
  $("#txtCliente").val(cliente);
  $("#txtCliente").trigger("blur");
  $("#txtNatureza").val(natureza);
  $("#txtReducao").val(operacao);
  insereValor("#txtDeposito", deposito, descDeposito);
}

async function retornaItensMov(documento, regiao, tipo, bCusto) {
  try {
    const tipoMov = $("#rgEntradaSaida").val() == 0 ? "E" : "S";
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    let tabela = "PA_MOV";
    let tabelaItem = "PRODUTO";
    const usaPrecoCorTam = await CopiaParametro("VENDA", 5) == 1;
    let campoPreco = usaPrecoCorTam ? 'PRECO_COR_TAM.PRECO PRECO_00'
      : `(SELECT TABPRECO.PRECO_00 FROM TABPRECO_001 TABPRECO WHERE TABPRECO.REGIAO = '${regiao}' AND TABPRECO.CODIGO = PA_MOV.CODIGO) PRECO_00`;
    campoPreco = ((bCusto) && (tipo != 'M')) ? 'PRODUTO.CUSTO PRECO_00' : campoPreco;
    let camposSelect = `"PA_MOV.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "PA_MOV.NUM_DOCTO", "PA_MOV.CODIGO", "PRODUTO.DESCRICAO", "PA_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "PA_MOV.TAMANHO", "PA_MOV.QTDE", "${campoPreco}"`;
    let operacao = ` AND PA_MOV.OPERACAO='${tipoMov}'`;

    if (tipo == "M") {
      tabela = "MAT_MOV";
      tabelaItem = "MATERIAL";
      camposSelect = `"MAT_MOV.DEPOSITO", "DEPOSITO.DESCRICAO DESC_DEPOSITO", "MAT_MOV.NUM_DOCTO", "MAT_MOV.CODIGO", "MATERIAL.DESCRICAO", "MAT_MOV.COR", "CADCOR.DESCRICAO DESC_COR", "MAT_MOV.QTDE", "${campoPreco}"`;
      operacao = ` AND MAT_MOV.OPERACAO='${tipoMov}'`;
    }

    const tabelaDePreco = (usaPrecoCorTam && !bCusto) ? {
      tabela: 'PRECO_COR_TAM',
      condicao: `PRECO_COR_TAM.CODIGO = ${tabela}.CODIGO AND PRECO_COR_TAM.COR = ${tabela}.COR AND PRECO_COR_TAM.TAM = ${tabela == 'PA_MOV' ? 'PA_MOV.TAMANHO' : "'0'"}`
    } : ''
    const params = `JSON={
      "tabela": "${tabela}",
      "camposSelect": [${camposSelect}], 
      "leftjoin": [{"tabela": "${tabelaItem}", "condicao": "${tabelaItem}.CODIGO = ${tabela}.CODIGO"},
                   {"tabela": "CADCOR", "condicao": "CADCOR.COR = ${tabela}.COR"},
                   ${tabelaDePreco != '' ? JSON.stringify(tabelaDePreco) + ',' : ''}
                   {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = ${tabela}.DEPOSITO"}],
      "where": ["${tabela}.NUM_DOCTO = '${documento}' ${tabelaDePreco != '' ? `AND ${tabelaDePreco.tabela}.REGIAO = '${regiao}'` : ''} ${operacao}" ]}`;
    const response = await requisicao("GET", url, params, '', 360000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.mensagem);
    }

    if ($.isEmptyObject(jsonStr.RESULT[0])) {
      msgAlerta(
        "Nenhuma movimentação encontrada com itens cadastrados na tabela de preço informada, favor verificar os dados."
      );
      return;
    }

    return jsonStr.RESULT[0];
  } catch (error) {
    console.error(error);
  }
}

async function retornaItensPedido(sPedidos) {
  let pesquisaParam = ''
  if (isChecked('#cbSomenteExpedidos')) {
    pesquisaParam = {
      tabela: "PED_ITEN",
      camposSelect: [
        "PEDIDO.CODCLI",
        "PEDIDO.NUMERO",
        "PEDIDO.CODREP",
        "PEDIDO.FINANCEIRO",
        "PEDIDO.BLOQUEIO",
        "PEDIDO.PGTO",
        "REPRESEN.NOME NOME_REPRESEN",
        "ENTIDADE.NOME",
        "PEDIDO.DEPOSITO",
        "DEPOSITO.DESCRICAO DESC_DEPOSITO",
        "PEDIDO.NATUREZA",
        "NATUREZA.DESCRICAO DESC_NATUREZA",
        "PEDIDO.OPERACAO",
        "OPER_FISCAL.DESCRICAO DESC_OPERACAO",
        "PED_ITEN.CODIGO",
        "CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO",
        "PED_ITEN.TIPO",
        "PED_ITEN.COR",
        "CADCOR.DESCRICAO DESC_COR",
        "PED_ITEN.TAM TAMANHO",
        "PEDIDO3.QTDE",
        "PED_ITEN.PRECO PRECO_00",
        "PEDIDO.FRETE",
        "PEDIDO.TAB_TRANS",
        "TABTRAN.NOME DESC_TRANS",
        "PEDIDO.MOEDA",
        "PEDIDO.HISTORICO",
        "HISTCP.DESCRICAO DESC_HISTORICO",
        "PEDIDO.CLASSE_GER",
        "CLASSE_GER.DESCRICAO DESC_CLASSE",
        "PEDIDO.PER_DESC",
        "PEDIDO.IND_QTDE"
      ],
      leftJoin: [
        { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = PEDIDO.NATUREZA' },
        { tabela: 'OPER_FISCAL', condicao: 'OPER_FISCAL.CODIGO = PEDIDO.OPERACAO' },
        { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PEDIDO.DEPOSITO' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = PEDIDO.CODREP' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = PED_ITEN.COR' },
        { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO = PEDIDO.TAB_TRANS' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = PEDIDO.HISTORICO' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PEDIDO.CLASSE_GER' },
      ],
      innerJoin: [
        { tabela: 'PEDIDO3', condicao: 'PEDIDO3.NUMERO = PED_ITEN.NUMERO AND PEDIDO3.CODIGO = PED_ITEN.CODIGO AND PEDIDO3.TAM = PED_ITEN.TAM AND PEDIDO3.COR = PED_ITEN.COR AND PEDIDO3.ORDEM = PED_ITEN.ORDEM' },
      ],
      where: [`PED_ITEN.NUMERO IN (${sPedidos}) AND PEDIDO3.QTDE > 0`],
    };
  } else {
    pesquisaParam = {
      tabela: "PED_ITEN",
      camposSelect: [
        "PEDIDO.CODCLI",
        "PEDIDO.NUMERO",
        "PEDIDO.CODREP",
        "PEDIDO.FINANCEIRO",
        "PEDIDO.BLOQUEIO",
        "PEDIDO.PGTO",
        "REPRESEN.NOME NOME_REPRESEN",
        "ENTIDADE.NOME",
        "PEDIDO.DEPOSITO",
        "DEPOSITO.DESCRICAO DESC_DEPOSITO",
        "PEDIDO.NATUREZA",
        "NATUREZA.DESCRICAO DESC_NATUREZA",
        "PEDIDO.OPERACAO",
        "OPER_FISCAL.DESCRICAO DESC_OPERACAO",
        "PED_ITEN.CODIGO",
        "CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO",
        "PED_ITEN.TIPO",
        "PED_ITEN.COR",
        "CADCOR.DESCRICAO DESC_COR",
        "PED_ITEN.TAM TAMANHO",
        "PED_ITEN.QTDE",
        "PED_ITEN.PRECO PRECO_00",
        "PEDIDO.FRETE",
        "PEDIDO.TAB_TRANS",
        "TABTRAN.NOME DESC_TRANS",
        "PEDIDO.MOEDA",
        "PEDIDO.HISTORICO",
        "HISTCP.DESCRICAO DESC_HISTORICO",
        "PEDIDO.CLASSE_GER",
        "CLASSE_GER.DESCRICAO DESC_CLASSE",
        "PEDIDO.PER_DESC",
        "PEDIDO.IND_QTDE"
      ],
      leftJoin: [
        { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = PEDIDO.NATUREZA' },
        { tabela: 'OPER_FISCAL', condicao: 'OPER_FISCAL.CODIGO = PEDIDO.OPERACAO' },
        { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PEDIDO.DEPOSITO' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = PEDIDO.CODREP' },
        { tabela: 'CADCOR', condicao: 'CADCOR.COR = PED_ITEN.COR' },
        { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO = PEDIDO.TAB_TRANS' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = PEDIDO.HISTORICO' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PEDIDO.CLASSE_GER' },
      ],
      where: [`PED_ITEN.NUMERO IN (${sPedidos}) AND PED_ITEN.QTDE > 0`],
    };
  }

  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  return jsonStr;
}

$("#btn_confirmar_pedido").on("click", async function () {

  if ($('#tabelaPedidos').DataTable().rows().count() == 0) {
    msgAlerta("Nenhum pedido selecionada para importar, favor verificar.");
    return;
  }

  $.LoadingOverlay("show");
  try {
    let pedidos = '';
    $('#tabelaPedidos').DataTable().rows().data().map((item) => {
      pedidos += pedidos == '' ? `'${item[0]}'` : `,'${item[0]}'`;
    });

    const itensPedido = await retornaItensPedido(pedidos);
    insereCondicoesPgto(itensPedido[0].PGTO);

    let pedidosBloqueadosComercial = verificarBloqueioComercial(itensPedido)
    if (pedidosBloqueadosComercial) {
      throw msgAlerta(`Pedidos: ${pedidosBloqueadosComercial} estão bloqueados no comercial, impossível realizar a importação!`)
    }

    if (itensPedido.length == 0) {
      msgAlerta('Pedido não possui quantidades pendentes para faturar, favor verificar.');
      return;
    }

    insereValor('#txtCliente', itensPedido[0].CODCLI, itensPedido[0].NOME);
    insereValor('#txtRepresentante', itensPedido[0].CODREP, itensPedido[0].NOME_REPRESEN);
    $("#txtCliente").trigger("blur");
    insereValor('#txtNatureza', itensPedido[0].NATUREZA, itensPedido[0].DESC_NATUREZA);
    insereValor('#txtReducao', itensPedido[0].OPERACAO, itensPedido[0].DESC_OPERACAO);
    insereValor('#txtTransportadora', itensPedido[0].TAB_TRANS, itensPedido[0].DESC_TRANS);
    insereValor('#txtMoeda', itensPedido[0].MOEDA, (await buscaValor('MOEDA', ['DESCRICAO'], 'CODMOE', itensPedido[0].MOEDA)).DESCRICAO);
    insereValor('#txtHistorico', itensPedido[0].HISTORICO, itensPedido[0].DESC_HISTORICO);
    insereValor('#txtClasseGer', itensPedido[0].CLASSE_GER, itensPedido[0].DESC_CLASSE);

    // $('#txtFreteTotal').val((await buscaValor('PEDIDO', 'FRETE', 'NUMERO', itensPedido[0].NUMERO)).FRETE);
    $('#txtFreteTotal').val(itensPedido[0].FRETE);
    $('#txtPercIndice').val(itensPedido[0].IND_QTDE);

    insereValor('#txtPedido', $('#tabelaPedidos').DataTable().rows(0).data()[0][0], $('#tabelaPedidos').DataTable().rows(0).data()[0][1]);

    await preencheItensMovimentacao(itensPedido, pegaValor('#txtNatureza'), itensPedido[0].TIPO, false, true);
    await escondeFs();

  } finally {
    await calculaPesoItens();
    $("#modal-importar-venda").modal("hide");
    $.LoadingOverlay("hide");
  }
});

function verificarBloqueioComercial(pedidos) {
  let arrPedidosBloqueados = pedidos.reduce((acc, item) => {
    if (item.BLOQUEIO === '0') {
      acc.push(item.NUMERO);
    }
    return acc;
  }, []);

  let arrFiltrado = arrPedidosBloqueados.filter((value, index, self) => self.indexOf(value) === index);

  if (arrFiltrado.length > 0) {
    return arrFiltrado;
  } else {
    return false;
  }
}

async function validaDescontoPedido(percDesc) {
  try {
    if ((percDesc > 0) && ($('#tabelaPedidos').DataTable().rows().count() == 1)) {
      const valNota = parseFloat($('#txtValorNota').text().replace('R$ ', '').replaceAll('.', '').replace(',', '.'));
      const valDesc = valNota * (percDesc / 100);
      insereValor('#txtDescontoTotal', TruncaDecimaisNova(2, valDesc));
      await calculaTotaisItens();
    }
  } catch { }
}

$("#modalReferenciar").on("shown.bs.modal", function () {
  $("#tabelaNotasRef").DataTable().columns.adjust().draw(false);
});

$("#btn-referenciar-nota").on("click", function () {
  $("#modalReferenciar").modal("show");
});

$("#tabelaNotasRef").DataTable({
  paging: false,
  filter: false,
  info: false,
  destroy: true,
  ordering: false,
  scrollY: "150px",
  language: {
    sEmptyTable: "Nenhuma nota adicionada",
    sInfo: "_TOTAL_ registros",
    sInfoEmpty: " 0 registros",
    sInfoFiltered: "(Filtrados de _MAX_ registros)",
    sInfoPostFix: "",
    sInfoThousands: ".",
    sLengthMenu: "_MENU_ resultados",
    sLoadingRecords: "Carregando...",
    sProcessing: "Processando...",
    sZeroRecords: "Nenhuma nota adicionada",
    sSearch: "Pesquisar",
    oPaginate: {
      sNext: "Próximo",
      sPrevious: "Anterior",
      sFirst: "Primeiro",
      sLast: "Último",
    },
    oAria: {
      sSortAscending: ": Ordenar colunas de forma ascendente",
      sSortDescending: ": Ordenar colunas de forma descendente",
    },
  },
});

$("#btnAddNotaRef").click(async function () {
  if (
    (($("#txtNotaRef").val() == "" && $("#txtChaveRef").val() == "") ||
      $("#txtModeloDocto").val() == "" ||
      $("#txtInfCompl").val() == "") &&
    !["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))
  ) {
    msgAlerta("Campos obrigatórios não informados, favor verificar.");
    return;
  }
  if (
    ($("#txtNumCoo").val() == "" || $("#txtSeqEcf").val() == "") &&
    ["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))
  ) {
    msgAlerta("Campos obrigatórios não informados, favor verificar.");
    return;
  }
  await addNotaRef();
  limpaCamposNotaRef();
});

async function retornaFaturaSemEmpId(sFatura, sSerie) {
  if (estaNaArqLocal == "") {
    await validaArqLocal();
  }

  if (estaNaArqLocal == true) {
    sFatura = sFatura.substring(0, sFatura.length - getCookie('emp_id').length)
  }

  if (await buscaValor('EMPRESA', 'EMP_CONTR_SERIE', 'EMP_ID', getCookie('emp_id')) == 'S') {
    sFatura = sFatura.substring(0, sFatura.length - sSerie.length);
  }

  return sFatura;
};

async function addNotaRef() {
  const chave = $("#txtChaveRef").val() == '' ? pegaChave('#txtChaveNotaRef') : $("#txtChaveRef").val();
  let fatura = pegaChave("#txtNotaRef");
  const serie = pegaDescricao("#txtNotaRef");
  const codcli = pegaChave("#txtCodcliNotaRef");
  const emissao = (!$('#divRefData').hasClass('d-none') && (pegaValor('#txtDataRef') != '')) ? (pegaValor('#txtDataRef').split('-')[2] + '/' + pegaValor('#txtDataRef').split('-')[1] + '/' + pegaValor('#txtDataRef').split('-')[0]) : pegaChave("#txtDataNotaRef").slice(0, 10);
  const indoper = $("#radioEntradaAquisicao").is(":checked") ? "0" : "1";
  const indemit = $("#radioEmissaoPropria").is(":checked") ? "0" : "1";
  const tipodoc = pegaChave("#txtModeloDocto");
  const codref = pegaChave("#txtInfCompl");
  const peso = $("#txtPesoRef").val() == "" ? "0.00" : $("#txtPesoRef").val();
  const valor = $("#txtValorRef").val() == "" ? "0.00" : $("#txtValorRef").val();
  const numCoo = $("#txtNumCoo").val();
  const seqEcf = $("#txtSeqEcf").val();
  const valorNf = $("#txtValorNotaRef").val() == "" ? "0.00" : pegaChave("#txtValorNotaRef");

  if ((tipodoc == '55') && (indemit == '0')) {
    fatura = await retornaFaturaSemEmpId(fatura, serie);
  }

  if (emissao == '') {
    msgAlerta('Data de emissão não informada, verifique!');
    return;
  }

  const notaJaAdicionada = $("#tabelaNotasRef").DataTable().data().toArray().filter(notas => notas[13] == chave).length > 0;

  if (notaJaAdicionada) {
    msgAlerta('Nota já adicionada, verifique.');
    return;
  }

  $("#tabelaNotasRef")
    .DataTable()
    .row.add([
      fatura,
      serie,
      codcli,
      emissao,
      indoper,
      indemit,
      tipodoc,
      codref,
      peso,
      valor,
      valorNf,
      numCoo,
      seqEcf,
      retornaBotaoExcluirNota(),
      chave,
    ])
    .draw(false);
}

function limpaCamposNotaRef() {
  $("#txtNotaRef").val("");
  // $("#txtModeloDocto").val("");
  // $("#txtInfCompl").val("");
  $("#txtPesoRef").val("");
  $("#txtValorRef").val("");
  $("#txtNumCoo").val("");
  $("#txtSeqEcf").val("");
  $("#txtChaveRef").val("");
  $("#txtDataRef").val("");
  $("#txtModeloDocto").trigger("blur");
  $("#txtDataNotaRef").val("");
  $("#txtChaveNotaRef").val("");
}

function retornaBotaoExcluirNota() {
  return (
    '<div style="text-align:center;"> ' +
    '   <button class="btn btn-info btn-sm" id="btnExcluirNotaRef" type="button"> ' +
    "      Excluir" +
    "   </button> " +
    "</div>"
  );
}

$("#tabelaNotasRef").on("click", "#btnExcluirNotaRef", async function () {
  let table = $("#tabelaNotasRef").DataTable();
  table.row($(this).parents("tr")).remove().draw(false);
});

$("#radioEmissaoPropria, #radioTerceirosRef").on("change", function () {
  $("#txtNotaRef").val("");
  $('#btnNotaRef').unbind();
  if ($("#radioEmissaoPropria").prop("checked")) {
    $('#btnNotaRef').pesquisa_serverside(
      ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
      ['NOTA.FATURA', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
      ['NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
      `{"tabela":"NOTA", 
        "camposSelect":[ "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.VALOR", ""NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}
        ],
        "where": ["NOTA.EMP_ID = ${getCookie('emp_id')}"],
        "camposWhereServerSide": ["NOTA.FATURA", "NOTA.SERIE", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"]
       }`,
      'Pesquisa Nota',
    );
  } else {
    $('#btnNotaRef').pesquisa_serverside(
      ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtValorNotaRef'],
      ['NOTA_ENTRA.NOTAFISCAL', 'NOTA_ENTRA.DT_EMISSAO', 'NOTA_ENTRA.CREDOR', 'NOTA_ENTRA.VALOR'],
      ['NOTA_ENTRA.SERIE', 'NOTA_ENTRA.DT_EMISSAO', 'NOTA_ENTRA.CREDOR', 'NOTA_ENTRA.VALOR'],
      `{"tabela":"NOTA_ENTRA", 
        "camposSelect":["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE", "NOTA_ENTRA.DT_EMISSAO", "NOTA_ENTRA.VALOR", "NOTA_ENTRA.CREDOR", "ENTIDADE.NOME"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA_ENTRA.CREDOR"}
        ],
        "where": ["NOTA_ENTRA.EMP_ID = ${getCookie('emp_id')}"],
        "camposWhereServerSide": ["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE", "NOTA_ENTRA.CREDOR", "ENTIDADE.NOME"]
       }`,
      'Pesquisa Nota',
    );
  }
  $('#txtModeloDocto').trigger('blur');
});

$("#btnConfirmarNotaRef").on("click", function () {
  $("#modalReferenciar").modal("hide");
  if (bNaturezaDevolucao) {
    $('#txtNatureza').trigger('blur');
  }
});

$("#txtModeloDocto").on("blur", function () {
  if (isChecked('#radioTerceirosRef')) {
    return;
  }

  if (["2B", "2C", "2D", "37"].includes(pegaChave("#txtModeloDocto"))) {
    $("#divNotaRef").addClass("d-none");
    $("#divInfCompl").addClass("d-none");

    $("#divNumCoo").removeClass("d-none");
    $("#divSeqEcf").removeClass("d-none");

    $("#txtDataNotaRef").val("[1899-01-01] - 1899-01-01");

  } else {
    $("#divNotaRef").removeClass("d-none");
    $("#divInfCompl").removeClass("d-none");

    $("#divNumCoo").addClass("d-none");
    $("#divSeqEcf").addClass("d-none");

    $("#txtNumCoo").val("");
    $("#txtSeqEcf").val("");

    $('#btnNotaRef').unbind();
    if (pegaChave("#txtModeloDocto") == '65') {
      $('#btnNotaRef').pesquisa_serverside(
        ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
        ['NOTA_NFCE.FATURA', 'NOTA_NFCE.DT_EMISSAO', 'NOTA_NFCE.CODCLI', 'NOTA_NFCE.CHAVE_NFCE', 'NOTA_NFCE.VALOR'],
        ['NOTA_NFCE.SERIE', 'NOTA_NFCE.DT_EMISSAO', 'NOTA_NFCE.CODCLI', 'NOTA_NFCE.CHAVE_NFCE', 'NOTA_NFCE.VALOR'],
        `{"tabela":"NOTA_NFCE", 
          "camposSelect":[ "NOTA_NFCE.FATURA", "NOTA_NFCE.SERIE", "NOTA_NFCE.DT_EMISSAO", "NOTA_NFCE.VALOR", "NOTA_NFCE.CODCLI", "ENTIDADE.NOME", "NOTA_NFCE.CHAVE_NFCE"], 
          "leftjoin": [ 
            {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA_NFCE.CODCLI"}
          ],
          "where": ["NOTA_NFCE.EMP_ID = ${getCookie('emp_id')}"],
          "camposWhereServerSide": ["NOTA_NFCE.FATURA", "NOTA_NFCE.SERIE", "NOTA_NFCE.CODCLI", "ENTIDADE.NOME", "NOTA_NFCE.CHAVE_NFCE"]
         }`,
        'Pesquisa NFCE',
      );

    } else if (pegaChave("#txtModeloDocto") == '59') {
      $('#btnNotaRef').pesquisa_serverside(
        ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
        ['CFE.FATURA', 'CFE.DT_EMISSAO', 'CFE.CODCLI', 'CFE.CHAVE_CFE', 'CFE.VALOR'],
        ['CFE.SERIE_SAT', 'CFE.DT_EMISSAO', 'CFE.CODCLI', 'CFE.CHAVE_CFE', 'CFE.VALOR'],
        `{"tabela":"CFE", 
          "camposSelect":[ "CFE.FATURA", "CFE.SERIE_SAT", "CFE.DT_EMISSAO", "CFE.VALOR", "CFE.CODCLI", "ENTIDADE.NOME", "CFE.CHAVE_CFE"], 
          "leftjoin": [ 
            {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = CFE.CODCLI"}
          ],
          "where": ["CFE.EMP_ID = ${getCookie('emp_id')}"],
          "camposWhereServerSide": ["CFE.FATURA", "CFE.SERIE_SAT", "CFE.CODCLI", "ENTIDADE.NOME", "CFE.CHAVE_CFE"]
         }`,
        'Pesquisa CFE',
      );

    } else {
      $('#btnNotaRef').pesquisa_serverside(
        ['#txtNotaRef', '#txtDataNotaRef', '#txtCodcliNotaRef', '#txtChaveNotaRef', '#txtValorNotaRef'],
        ['NOTA.FATURA', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
        ['NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.CODCLI', 'NOTA.CHAVE_NFE', 'NOTA.VALOR'],
        `{"tabela":"NOTA", 
          "camposSelect":[ "NOTA.FATURA", "NOTA.SERIE", "NOTA.DT_EMISSAO", "NOTA.VALOR", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"], 
          "leftjoin": [ 
            {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = NOTA.CODCLI"}
          ],
          "where": ["NOTA.EMP_ID = ${getCookie('emp_id')}"],
          "camposWhereServerSide": ["NOTA.FATURA", "NOTA.SERIE", "NOTA.CODCLI", "ENTIDADE.NOME", "NOTA.CHAVE_NFE"]
         }`,
        'Pesquisa Nota',
      );
    }
  }
});

$("#txtReducao").on("blur", async function () {
  const operacao = pegaChave("#txtReducao");
  const retorno = operacao == '' ? null : (await BuscaDescricao("OPER_FISCAL", "TP_FRETE", "CODIGO", operacao));
  if (operacao == "") {
    return;
  }
  if (!retorno || retorno.TP_FRETE == null) {
    $("#rgTransportador").val('9');
    return;
  }

  $("#rgTransportador").val(retorno.TP_FRETE).change();
  $("#rgPresenca").val((await BuscaDescricao("OPER_FISCAL", "PRESENCA", "CODIGO", operacao)).PRESENCA).change();

  $('#txtNatureza').trigger('blur');
});

$("#btnReferenciarPorNota").on("click", function () {
  $("#divRefNota").removeClass("d-none");
  $("#divRefChave").addClass("d-none");
  $("#divRefData").addClass("d-none");
});

$("#btnReferenciarPorChave").on("click", function () {
  $("#divRefNota").addClass("d-none");
  $("#divRefChave").removeClass("d-none");
  $("#divRefData").removeClass("d-none");
});

$("#txtCliente").on('blur change', async function () {
  if ($("#txtCliente").val() != "") {
    await criarToolTipCliente(pegaChave("#txtCliente"));
    $("#dropdown").trigger("change");
    await buscaInfosFinanceirasCliente(pegaChave('#txtCliente'));
  }
});

$('#rgPresenca').on('change', async function () {
  const operacaoPresencial = $('#rgPresenca').val() == '1';
  if (operacaoPresencial) {
    msgAlerta('Presença marcada como Operação Presencial, deseja alterar o endereço de entrega para o endereço da Empresa?', () => $('#dropdown').val('3').change());
  }
});

$('#txtPercIndice').on('blur', async function () {
  if ($('#txtPercIndice').val() == '') {
    $('#txtPercIndice').val('0.00');
  }

  const indice = $('#txtPercIndice').val();
  let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;
  if (isNaN(decimais)) {
    decimais = 2;
  }
  await recalculaValorIndice(indice, decimais);
});

async function buscaInfosFinanceirasCliente(sCodcli) {
  const pesquisaParam = {
    tabela: "ENTIDADE",
    camposSelect: [
      "ENTIDADE.CLASSE",
      "ENTIDADE.HISTORICO",
      "ENTIDADE.BANCO",
      "ENTIDADE.SIT_DUP",
      "CLASSE_GER.DESCRICAO DESC_CLASSE",
      "HISTCP.DESCRICAO DESC_HISTORICO",
      "CADBAN.NOME_BANCO DESC_BANCO",
      "TABSIT.DESCRICAO DESC_SIT",
      "ENTIDADE.CODREP",
      "REPRESEN.NOME NOME_REP"
    ],
    leftJoin: [
      { tabela: 'CLASSE_GER', condicao: `CLASSE_GER.CODIGO = ENTIDADE.CLASSE` },
      { tabela: 'HISTCP', condicao: `HISTCP.HISTORICO = ENTIDADE.HISTORICO` },
      { tabela: 'CADBAN', condicao: `CADBAN.BANCO = ENTIDADE.BANCO` },
      { tabela: 'TABSIT', condicao: `TABSIT.CODIGO = ENTIDADE.SIT_DUP` },
      { tabela: 'REPRESEN', condicao: `REPRESEN.CODREP = ENTIDADE.CODREP` }
    ],
    where: [`ENTIDADE.CODCLI = '${sCodcli}'`],
  };

  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

  if (jsonStr.length == 0) {
    return;
  }

  insereValor('#txtClasseGer', jsonStr[0].CLASSE, jsonStr[0].DESC_CLASSE);
  insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESC_HISTORICO);
  insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].DESC_BANCO);
  insereValor('#txtSituacao', jsonStr[0].SIT_DUP, jsonStr[0].DESC_SIT);
  insereValor('#txtRepresentante', jsonStr[0].CODREP, jsonStr[0].NOME_REP);
};

async function recalculaValorIndice(sIndice, iDecimais) {
  $.LoadingOverlay('show');
  try {
    $('.classePreco').map((index) => {
      const precoReserva = $($('.classeValorReserva')[index]).val();
      let preco = $($('.classePreco')[index]).val();
      if (precoReserva > 0) {
        preco = precoReserva;
      }
      if ((!(preco > 0)) || ((sIndice == 0) && (precoReserva == ''))) {
        return;
      }
      if ((sIndice == 0) && (precoReserva > 0)) {
        $($('.classePreco')[index]).val(precoReserva);
        return;
      }
      $($('.classeValorReserva')[index]).val(preco);
      $($('.classePreco')[index]).val(TruncaDecimaisNova(iDecimais, preco * (1 - (sIndice / 100))));
    });
    $('#txtDescontoTotal').val('0');
    await aplicaDesconto();
  } finally {
    $.LoadingOverlay('hide');
  }
};

async function criarToolTipCliente(cliente) {
  const pesquisaParam = {
    tabela: "ENTIDADE",
    camposSelect: [
      "ENTIDADE.CEP",
      "ENTIDADE.ENDERECO",
      "ENTIDADE.BAIRRO",
      "ENTIDADE.NUMERO",
      "ENTIDADE.COMPLEMENTO",
      "ENTIDADE.CEP_ENT",
      "ENTIDADE.END_ENT",
      "ENTIDADE.BAIRRO_ENT",
      "ENTIDADE.NUM_ENT",
      "ENTIDADE.COMP_ENT",
      "ENTIDADE.CEP_COB",
      "ENTIDADE.END_COB",
      "ENTIDADE.BAIRRO_COB",
      "ENTIDADE.NUM_COB",
      "ENTIDADE.COMP_COB",
    ],
    where: [`ENTIDADE.CODCLI = '${cliente}'`],
  };
  const pesquisaEmpresaParam = {
    tabela: "EMPRESA",
    camposSelect: [
      "EMP_NUMERO",
      "EMP_BAIRRO",
      "EMP_CIDADE",
      "EMP_ENDERECO",
      "EMP_CEP",
      "EMP_ESTADO",
      "EMP_COMPL_CONT",
    ],
    where: [`EMP_ID = '${getCookie('emp_id')}'`],
  };

  const enderecoEmpresa = await retornaJsonPesquisaPadrao(
    JSON.stringify(pesquisaEmpresaParam)
  );


  const jsonStr = await retornaJsonPesquisaPadrao(
    JSON.stringify(pesquisaParam)
  );

  if (jsonStr[0].CEP == '') {
    msgErro('Cliente sem endereço cadastrado, verifique.');
    limpaValor('#txtCliente');
    console.error('Cliente sem endereço cadastrado');
    return;
  }

  const cidade = await buscaCidade(jsonStr[0].CEP);
  const cidadeEnt = await buscaCidade(jsonStr[0].CEP_ENT);
  const cidadeCob = await buscaCidade(jsonStr[0].CEP_COB);

  $(`#enderecoPadrao`).attr("data-cep", jsonStr[0].CEP);
  $(`#enderecoPadrao`).attr("data-endereco", jsonStr[0].ENDERECO);
  $(`#enderecoPadrao`).attr("data-bairro", jsonStr[0].BAIRRO);
  $(`#enderecoPadrao`).attr("data-numero", jsonStr[0].NUMERO);
  $(`#enderecoPadrao`).attr("data-cidade", cidade.NOME);
  $(`#enderecoPadrao`).attr("data-cod_uf", cidade.COD_UF);
  $(`#enderecoPadrao`).attr("data-complemento", jsonStr[0].COMPLEMENTO);

  $(`#enderecoEntrega`).attr("data-cep", jsonStr[0].CEP_ENT);
  $(`#enderecoEntrega`).attr("data-endereco", jsonStr[0].END_ENT);
  $(`#enderecoEntrega`).attr("data-bairro", jsonStr[0].BAIRRO_ENT);
  $(`#enderecoEntrega`).attr("data-numero", jsonStr[0].NUM_ENT);
  $(`#enderecoEntrega`).attr("data-cidade", cidadeEnt.NOME);
  $(`#enderecoEntrega`).attr("data-cod_uf", cidadeEnt.COD_UF);
  $(`#enderecoEntrega`).attr("data-complemento", jsonStr[0].COMP_ENT);

  $(`#enderecoCobranca`).attr("data-cep", jsonStr[0].CEP_COB);
  $(`#enderecoCobranca`).attr("data-endereco", jsonStr[0].END_COB);
  $(`#enderecoCobranca`).attr("data-bairro", jsonStr[0].BAIRRO_COB);
  $(`#enderecoCobranca`).attr("data-numero", jsonStr[0].NUM_COB);
  $(`#enderecoCobranca`).attr("data-cidade", cidadeCob.NOME);
  $(`#enderecoCobranca`).attr("data-cod_uf", cidadeCob.COD_UF);
  $(`#enderecoCobranca`).attr("data-complemento", jsonStr[0].COMP_COB);

  $(`#enderecoEmpresa`).attr("data-cep", enderecoEmpresa[0].EMP_CEP);
  $(`#enderecoEmpresa`).attr("data-endereco", enderecoEmpresa[0].EMP_ENDERECO);
  $(`#enderecoEmpresa`).attr("data-bairro", enderecoEmpresa[0].EMP_BAIRRO);
  $(`#enderecoEmpresa`).attr("data-numero", enderecoEmpresa[0].EMP_NUMERO);
  $(`#enderecoEmpresa`).attr("data-cidade", enderecoEmpresa[0].EMP_CIDADE);
  $(`#enderecoEmpresa`).attr("data-cod_uf", enderecoEmpresa[0].EMP_ESTADO);
  $(`#enderecoEmpresa`).attr("data-complemento", enderecoEmpresa[0].EMP_COMPL_CONT);

  $(`#enderecoPadrao`).prop(
    "title",
    `CEP: ${jsonStr[0].CEP} \n` +
    `ENDEREÇO: ${jsonStr[0].ENDERECO} \n` +
    `BAIRRO: ${jsonStr[0].BAIRRO} \n` +
    `NUMERO: ${jsonStr[0].NUMERO} \n` +
    `CIDADE: ${cidade.NOME} \n` +
    `UF: ${cidade.COD_UF} \n` +
    `COMPLEMENTO: ${jsonStr[0].COMPLEMENTO}`
  );
  $(`#enderecoEntrega`).prop(
    "title",
    `CEP: ${jsonStr[0].CEP_ENT} \n` +
    `ENDEREÇO: ${jsonStr[0].END_ENT} \n` +
    `BAIRRO: ${jsonStr[0].BAIRRO_ENT} \n` +
    `NUMERO: ${jsonStr[0].NUM_ENT} \n` +
    `CIDADE: ${cidadeEnt.NOME} \n` +
    `UF: ${cidadeEnt.COD_UF} \n` +
    `COMPLEMENTO: ${jsonStr[0].COMP_ENT}`
  );
  $(`#enderecoCobranca`).prop(
    "title",
    `CEP: ${jsonStr[0].CEP_COB} \n` +
    `ENDEREÇO: ${jsonStr[0].END_COB} \n` +
    `BAIRRO: ${jsonStr[0].BAIRRO_COB} \n` +
    `NUMERO: ${jsonStr[0].NUM_COB} \n` +
    `CIDADE: ${cidadeCob.NOME} \n` +
    `UF: ${cidadeCob.COD_UF} \n` +
    `COMPLEMENTO: ${jsonStr[0].COMP_COB}`
  );

  $(`#enderecoEmpresa`).prop(
    "title",
    `CEP: ${enderecoEmpresa[0].EMP_CEP} \n` +
    `ENDEREÇO: ${enderecoEmpresa[0].EMP_ENDERECO} \n` +
    `BAIRRO: ${enderecoEmpresa[0].EMP_BAIRRO} \n` +
    `NUMERO: ${enderecoEmpresa[0].EMP_NUMERO} \n` +
    `CIDADE: ${enderecoEmpresa[0].EMP_CIDADE} \n` +
    `UF: ${enderecoEmpresa[0].EMP_ESTADO} \n` +
    `COMPLEMENTO: ${enderecoEmpresa[0].EMP_COMPL_CONT}`
  );

  if (!$(`#enderecoPadrao`).attr("data-cep") ||
    !$(`#enderecoEntrega`).attr("data-cep") ||
    !$(`#enderecoCobranca`).attr("data-cep") ||
    !$(`#enderecoEmpresa`).attr("data-cep")) {
    msgErro('Cliente sem endereço cadastrado, verifique');
    limpaValor('#txtCliente');
    return;
  }

}

async function buscaCidade(cep) {
  const pesquisaCodMun = {
    tabela: "CADCEP",
    camposSelect: ["CADCEP.CODMUN"],
    where: [`CADCEP.CEP = '${cep}'`],
  };

  const getCodMun = await retornaJsonPesquisaPadrao(
    JSON.stringify(pesquisaCodMun)
  );

  const pesquisaCidade = {
    tabela: "CIDADE",
    camposSelect: ["CIDADE.NOME, CIDADE.COD_UF"],
    where: [`CIDADE.CODIGO = '${getCodMun[0].CODMUN}'`],
  };

  const getCidade = await retornaJsonPesquisaPadrao(
    JSON.stringify(pesquisaCidade)
  );
  return getCidade[0];
}

$("#dropdown").on("change", async function () {
  if ($(this).val() != '') {
    const enderecoSelecionado = $(`#dropdown > option[value=${$(this).val()}]`).prop("title");
    $(this).prop("title", enderecoSelecionado);
  }
});

$("#dropdown").trigger("change");

function validaDadosItens() {
  let [qtde, preco, cfop] = [false, false, false];

  $(".classeProduto").map((index, item) => {
    if (item.value != '') {
      if ($($(".classeQuantidade")[index]).val() == '') {
        qtde = true;
      }
      if ($($(".classePreco")[index]).val() == '') {
        preco = true;
      }
      if ($($(".classeNatureza")[index]).val() == '') {
        cfop = true;
      }
    }
  });

  if (qtde || preco || cfop) {
    msgAlerta('Um ou mais itens sem natureza, quantidade ou preço informado.\nFavor voltar a aba de itens e verificar.');
    return false;
  }

  return true;
}

async function retornaInformacaoEmpresa() {
  try {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let response = await requisicao('GET', url, `JSON={ 
      "tabela":"empresa", 
      "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert"], 
      "where": ["emp_id = ${getCookie('emp_id')}"] 
    }`, null);
    if (!response) {
      return;
    }
    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    return jsonStr.RESULT[0][0];
  } catch (error) {
    console.error(error);
    msgErro('Erro ao retornar dados da empresa, Erro: ');
  }
}

async function retornaLoteNfe() {
  try {
    const url = `/sisplan/nfe/v1/finalizanfe?`;
    const response = await requisicao('GET', url, '', null);
    if (!response) {
      return;
    }
    const lote = await response.text();
    if (response.status != 200) {
      return;
    }
    return lote;
  } catch (error) {
    console.error(error);
  }
}

async function buscaFuncionario() {
  const codUsuario = getCookie('cod_usuario');
  try {
    const pesquisaParam = {
      tabela: 'ACESSO_USUARIOS',
      camposSelect: ['ACESSO_USUARIOS.CODFUN', 'PESSOAL.NOME'],
      leftJoin: [{ tabela: 'PESSOAL', condicao: 'PESSOAL.CODIGO = ACESSO_USUARIOS.CODFUN' }],
      where: [`ACESSO_USUARIOS.CODIGO = '${codUsuario}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr.length > 0 ? jsonStr[0].CODFUN : '';

  } catch (error) {
    console.error(error);
  }
};

$("#gravar").click(async function () {
  try {
    $(this).attr('disabled', true);
    if (!validaDadosItens()) {
      return;
    }
    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2) == '1';
    try {
      $.LoadingOverlay("show");

      let vendas = [];
      $('#tabelaVendas').DataTable().rows().data().map((item) => { vendas.push(item[1]) });

      let pedidos = '';
      let pedidoReceber = '';
      $('#tabelaPedidos').DataTable().rows().data().map((item) => {
        pedidos += pedidos == '' ? `'${item[0]}'` : `,'${item[0]}'`;
        pedidoReceber = item[0];
      });

      let nota = {};

      nota.CODVEN = pegaChave("#txtNumeroVenda", nota.CODVEN);
      nota.COD_USUARIO = await buscaFuncionario();
      nota.VENDAS = vendas.toString();
      nota.PEDIDOS = pedidos;
      nota.ESTOQUE = $("#movEstoqueCheck").prop("checked") ? "S" : "N";
      nota.CODCLI = pegaChave("#txtCliente", nota.CODCLI);
      nota.CODREP = pegaChave("#txtRepresentante", nota.CODREP);
      nota.NATUREZA = pegaChave("#txtNatureza", nota.NATUREZA);
      nota.OPERACAO = pegaChave("#txtReducao", nota.OPERACAO);
      nota.TRANSPORTADORA = pegaChave("#txtTransportadora", nota.TRANSPORTADORA);
      nota.DTEMISSAO = $("#txtDataEmissao").val();
      nota.DTSAIDA = $("#txtDataSaida").val() == '' ? null : $("#txtDataSaida").val();
      nota.VOLUMES = $("#txtVolumes").val();
      nota.ESPECIE = $("#txtEspecie").val();
      nota.PESOBRUTO = $("#txtPesoBruto").val();
      nota.PESOLIQUIDO = $("#txtPesoLiq").val();
      nota.VALFRETE = $("#txtValorFrete").html().substring(8).replace(".", "").replace(",", ".");
      nota.VALDESPESAS = $("#txtValorDespesa").html().substring(8).replace(".", "").replace(",", ".");
      nota.CIF = $("#rgTransportador").val();
      nota.INDPRESENCA = $("#rgPresenca").val();
      nota.CODVEN = pegaChave("#txtNumeroVenda", nota.CODVEN);
      nota.VALOR = $("#txtValorNota").html().substring(8).replace(".", "").replace(",", ".");
      nota.VALORBRUTO = $("#txtValorBruto").html().substring(8).replace(".", "").replace(",", ".");
      nota.DESCONTO = $("#txtDesconto").html().substring(8).replace(".", "").replace(",", ".");
      nota.MENSAGEM = $("#txtDados").val();
      nota.INDICE = $("#txtPercIndice").val() != '' ? $("#txtPercIndice").val() : 0;
      if (nota.CODVEN > 0) {
        const histVenda = await buscaValor('RECEBER', 'HISTORICO', 'NRO_CUPOM', nota.CODVEN);
        if (histVenda) {
          nota.HISTORICO = histVenda.HISTORICO;
        }
      }
      if ($("#consumidorFinal").prop("checked")) {
        nota.CONSUMIDORFINAL = "Sim";
      } else {
        nota.CONSUMIDORFINAL = "Nao";
      }
      if ($("#gerarDifal").prop("checked")) {
        nota.GERARDIFAL = "Sim";
      } else {
        nota.GERARDIFAL = "Nao";
      }

      $('#tabelaNotasRef').DataTable().rows().data().map(item => {
        if (item[6] == '55') {
          nota.MENSAGEM = `NFe Ref.: ${item[0]} - Série Ref.: ${item[1]} \r\n` + nota.MENSAGEM;
        }
      });

      const nomeEntrega = $("#dropdown").find(":selected").text();

      if (nomeEntrega == "Padrão") {
        nota.CLI_CEP = $("#enderecoPadrao").attr("data-cep");
        nota.CLI_END = $("#enderecoPadrao").attr("data-endereco");
        nota.CLI_BAIRRO = $("#enderecoPadrao").attr("data-bairro");
        nota.CLI_NUM = $("#enderecoPadrao").attr("data-numero");
        nota.CLI_COMPL = $("#enderecoPadrao").attr("data-complemento");
        nota.CLI_ENT_NOME = pegaDescricao('#txtCliente');
      } else if (nomeEntrega == "Entrega") {
        nota.CLI_CEP = $("#enderecoEntrega").attr("data-cep");
        nota.CLI_END = $("#enderecoEntrega").attr("data-endereco");
        nota.CLI_BAIRRO = $("#enderecoEntrega").attr("data-bairro");
        nota.CLI_NUM = $("#enderecoEntrega").attr("data-numero");
        nota.CLI_COMPL = $("#enderecoEntrega").attr("data-complemento");
        nota.CLI_ENT_NOME = pegaDescricao('#txtCliente');
      } else if (nomeEntrega == "Cobrança") {
        nota.CLI_CEP = $("#enderecoCobranca").attr("data-cep");
        nota.CLI_END = $("#enderecoCobranca").attr("data-endereco");
        nota.CLI_BAIRRO = $("#enderecoCobranca").attr("data-bairro");
        nota.CLI_NUM = $("#enderecoCobranca").attr("data-numero");
        nota.CLI_COMPL = $("#enderecoCobranca").attr("data-complemento");
        nota.CLI_ENT_NOME = pegaDescricao('#txtCliente');
      } else if (nomeEntrega == "Empresa") {
        nota.CLI_CEP = $("#enderecoEmpresa").attr("data-cep");
        nota.CLI_END = $("#enderecoEmpresa").attr("data-endereco");
        nota.CLI_BAIRRO = $("#enderecoEmpresa").attr("data-bairro");
        nota.CLI_NUM = $("#enderecoEmpresa").attr("data-numero");
        nota.CLI_COMPL = $("#enderecoEmpresa").attr("data-complemento");
        nota.CLI_ENT_NOME = getCookie('g_nome_empresa_logada').split(getCookie('empresa').replace('_', '') + ' - ')[1];
      }

      let qtdeItens = $(".itens").length;
      let arrayItens = [];
      let ajustaDesconto = 0;
      let ajustaFrete = 0;
      let ajustaDespesa = 0;
      for (let index = 0; index < qtdeItens; index++) {
        if (
          $(seletorPorNome("txtProduto", index)).attr("data-codigo") !=
          undefined &&
          $(seletorPorNome("txtProduto", index)).attr("data-codigo") != ""
        ) {
          let item = {};
          item.CODIGO = $(seletorPorNome("txtProduto", index)).attr(
            "data-codigo"
          );

          item.DESCRICAO = $(seletorPorNome("txtProduto", index)).attr(
            "data-descricao"
          );

          if (item.DESCRICAO == undefined || item.DESCRICAO == '') {
            item.DESCRICAO = pegaDescricao(
              seletorPorNome("txtProduto", index),
              item.DESCRICAO
            );
          }

          item.TIPOITEM = $(seletorPorNome("txtProduto", index)).attr(
            "data-tipo"
          );
          item.QUALIDADE = '1';
          item.QTDE = parseFloat($(seletorPorNome("txtQuantidade", index)).val());
          item.COR = $(seletorPorNome("txtProduto", index)).attr("data-cor");
          if (item.TIPOITEM == "P") {
            item.TAMANHO = $(seletorPorNome("txtProduto", index)).attr(
              "data-tam"
            );
          } else {
            item.TAMANHO = '0';
          }
          item.PRECO = parseFloat($(seletorPorNome("txtPreco", index)).val());
          const soma = +(parseFloat(item.PRECO) * parseFloat(item.QTDE)).toFixed(4); // necessário para ter o mesmo resultado de arredondamento da venda
          item.VALOR = await TruncaDecimais(2, soma);
          item.NATUREZA = pegaChave(
            seletorPorNome("txtCFOP", index),
            item.NATUREZA
          );
          item.PERCICMS = parseFloat($(seletorPorNome("txtICMS", index)).val());
          item.PERCIPI = parseFloat($(seletorPorNome("txtIPI", index)).val());
          item.CLAFIS = pegaChave(seletorPorNome("txtNCM", index), item.CLAFIS);
          item.ENQUADRA = pegaChave(
            seletorPorNome("txtEnquadra", index),
            item.ENQUADRA
          );
          item.CLACSOSN = pegaChave(
            seletorPorNome("txtCsosn", index),
            item.CLACSOSN
          );
          item.CLATRIB = pegaChave(
            seletorPorNome("txtCstIcms", index),
            item.CLATRIB
          );
          item.CLAIPI = pegaChave(
            seletorPorNome("txtCstIpi", index),
            item.CLAIPI
          );
          item.CLAPIS = pegaChave(
            seletorPorNome("txtCstPis", index),
            item.CLAPIS
          );
          item.CLACOFINS = pegaChave(
            seletorPorNome("txtCstCofins", index),
            item.CLACOFINS
          );
          item.DEPOSITO = pegaChave("#txtDeposito", item.DEPOSITO);
          item.PEDIDO = !!$(seletorPorNome("txtProduto", index)).attr("data-pedido") ? $(seletorPorNome("txtProduto", index)).attr("data-pedido") : (pegaChave('#txtPedido') != '' ? pegaChave('#txtPedido') : nota.CODVEN);
          item.EMPENHO = "N";
          item.NUM_DOC_IMP = !!$(seletorPorNome("txtProduto", index)).attr("data-documento") ? $(seletorPorNome("txtProduto", index)).attr("data-documento") : pegaChave('#txtDocumento');
          if (nota.DESCONTO != 0 && nota.DESCONTO != "") {
            let rateioDesconto =
              (parseFloat(nota.DESCONTO) * parseFloat(item.VALOR)) /
              parseFloat(nota.VALORBRUTO);
            item.VALORDESC = rateioDesconto.toFixed(2);
            ajustaDesconto += parseFloat(item.VALORDESC);
          }
          if (nota.VALFRETE != 0 && nota.VALFRETE != "") {
            let rateioFrete =
              (parseFloat(nota.VALFRETE) * parseFloat(item.VALOR)) /
              parseFloat(nota.VALORBRUTO);
            item.VALORFRETE = rateioFrete.toFixed(2);
            ajustaFrete += parseFloat(item.VALORFRETE);
          }
          if (nota.VALDESPESAS != 0 && nota.VALDESPESAS != "") {
            let rateioDespesa =
              (parseFloat(nota.VALDESPESAS) * parseFloat(item.VALOR)) /
              parseFloat(nota.VALORBRUTO);
            item.VALORDESP = rateioDespesa.toFixed(2);
            ajustaDespesa += parseFloat(item.VALORDESP);
          }
          arrayItens.push(item);
        }
      }
      let diferencaDesconto =
        nota.DESCONTO - parseFloat(ajustaDesconto.toFixed(2));
      let diferencaFrete = nota.VALFRETE - parseFloat(ajustaFrete.toFixed(2));
      let diferencaDespesa =
        nota.VALDESPESAS - parseFloat(ajustaDespesa.toFixed(2));
      nota.ITENS = arrayItens;

      if (diferencaDesconto != 0) {
        let guardaDesconto = nota.ITENS[0].VALORDESC;
        nota.ITENS[0].VALORDESC =
          parseFloat(guardaDesconto) + parseFloat(diferencaDesconto.toFixed(2));
      }
      if (diferencaFrete != 0) {
        let guardaFrete = nota.ITENS[0].VALORFRETE;
        nota.ITENS[0].VALORFRETE =
          parseFloat(guardaFrete) + parseFloat(diferencaFrete.toFixed(2));
      }
      if (diferencaDespesa != 0) {
        let guardaDespesa = nota.ITENS[0].VALORDESP;
        nota.ITENS[0].VALORDESP =
          parseFloat(guardaDespesa) + parseFloat(diferencaDespesa.toFixed(2));
      }
      const qtdeParcelas = $('#tabelaDuplicatas').DataTable().data().column($('#tabelaDuplicatas').DataTable().data().length)[0].toString();
      let arrayDuplicatas = [];
      for (
        let index = 0;
        index < $("#tabelaDuplicatas").DataTable().rows().count();
        index++
      ) {
        let data = $("#tabelaDuplicatas").DataTable().row(index).data();
        let duplicata = {};
        duplicata.DT_VENCTO = $(`#txtDataRec-${index}`).val();// data[1];
        duplicata.VALOR2 = $(`#txtValorRec-${index + 1}`).val();//data[2];
        duplicata.MOEDA = pegaChave("#txtMoeda", duplicata.MOEDA);
        duplicata.HISTORICO = pegaChave("#txtHistorico", duplicata.HISTORICO);
        duplicata.BANCO = pegaChave("#txtBanco", duplicata.BANCO);
        duplicata.SITUACAO = pegaChave("#txtSituacao", duplicata.SITUACAO);
        duplicata.CLASSE = pegaChave("#txtClasseGer", duplicata.CLASSE);
        duplicata.DT_EMISSAO = nota.DTEMISSAO;
        duplicata.VALOR = nota.VALOR;
        duplicata.FRETE = nota.VALFRETE / +qtdeParcelas;
        duplicata.PEDIDO = pedidoReceber;

        arrayDuplicatas.push(duplicata);
      }
      nota.DUPLICATAS = arrayDuplicatas;

      let arrNotasRef = [];
      $("#tabelaNotasRef")
        .DataTable()
        .rows()
        .data()
        .map((nota) => {
          const notaRef = {
            NOTA_REF: nota[0],
            SERIE_REF: nota[1],
            CODCLI_REF: nota[2],
            DATA_REF: `${nota[3].split('/').length > 1 ? nota[3].split('/')[2] + '-' + nota[3].split('/')[1] + '-' + nota[3].split('/')[0] : nota[3]}T00:00:00Z`,
            IND_OPER: nota[4],
            IND_EMIT: nota[5],
            TIPO_FISCAL_REF: nota[6],
            COD_REF: nota[7],
            PESO: nota[8],
            VALOR: nota[10],
            NUM_COO: nota[11],
            SEQ_ECF: nota[12],
            CHAVE_NFE: nota[14],
          };
          arrNotasRef.push(notaRef);
        });
      nota.NOTASREF = arrNotasRef;

      let response = await requisicao(
        "POST",
        "/Sisplan/NFe/v1/Faturamento?",
        "",
        `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
        600000
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem, vaiParaNfeImpressao);
        return;
      }

      if (documentos.length > 0) {
        await rotinaGeraLog('FATURAMENTO', jsonStr.fatura, `Movimentacoes ${documentos} foram importadas na nota ${jsonStr.fatura}`, 'Inclusão');
      }


      async function vaiParaNfeImpressao() {
        if ((await CopiaParametro("FATURAMENTO", 1)) == 1) {
          // window.location.href = `${BASE_URI}/nfeimpressao`;
          parent.document.querySelector('#menu_impressao_nfe .nav-link').click();

          var iframe = parent.document.querySelector('#panel--sisplan_web-faturamento-create iframe');
          var src = iframe.getAttribute("src");
          iframe.setAttribute("src", src);
        }
      }

      const transmiteImprimirnfe = (await CopiaParametro("FATURAMENTO", 1)) == 2;
      const transmiteNota = (await CopiaParametro("FATURAMENTO", 1)) == 1;
      let mensagem = '';

      if ((transmiteNota) || (transmiteImprimirnfe)) {
        let pFinalidade = 0;

        if (nota.NATUREZA != '') {
          pFinalidade = (await buscaValor("NATUREZA", "FINALIDADE_NFE", "NATUREZA", nota.NATUREZA)).FINALIDADE_NFE;
          --pFinalidade; //necessário decrementar pois no backend é incrementado, se não fizer isso se a finalidade da natureza for "normal", irá ficar como "complemento"
        }

        const responseTransmissao = await requisicao('POST', '/Sisplan/NFE/v1/GerarNFE?', `SERIE=${jsonStr.serie}&FATURA=${jsonStr.fatura}&FINALIDADE=${pFinalidade}&JUSTIFICATIVA=${''}&TIPO_TRANSMISSAO=${0}&CERTA3=${usaCertificadoA3 ? '1' : '0'}`, null, 60000);

        if (responseTransmissao.status != 200) {
          jsonStr = await responseTransmissao.json();
          msgErro(jsonStr.mensagem);
        }

        if (usaCertificadoA3 && (responseTransmissao.status == 200)) {
          const xml = await responseTransmissao.text();
          const loteNfe = await retornaLoteNfe();
          const empClasse = await retornaInformacaoEmpresa();

          // TRANSMITE NA API LOCAL
          const responseLocal = await requisicao_ecf('POST', '/nfe/gerar?', `CLASSEEMPRESA=${JSON.stringify(empClasse)}&LOTE=${loteNfe}`, xml, 120000);
          if (responseLocal.status != 200) {
            const mensagemErro = await responseLocal.text();
            msgErro(mensagemErro);
            return;
          }
          const retornoNota = await responseLocal.json();

          // FINALIZA TRANSMISSÃO NA API WEB
          const reponseApiWeb = await requisicao(
            'POST',
            '/sisplan/nfe/v1/finalizanfe?',
            `FATURA=${jsonStr.fatura}&SERIE=${jsonStr.serie}&TIPO_TRANSMISSAO=${0}`,
            JSON.stringify(retornoNota),
            60000
          );
          if (!response) {
            return;
          }
          if (reponseApiWeb.status != 200) {
            const mensagemRetorno = await reponseApiWeb.json();
            msgErro(mensagemRetorno.mensagem);
            return;
          }
        }

        if (responseTransmissao.status == 200) {
          await imprimirBoleto(jsonStr.fatura);
          if (transmiteImprimirnfe) {
            await imprimirNFe(jsonStr.fatura, jsonStr.serie);
          }
          mensagem = await enviarEmail(jsonStr.fatura, jsonStr.serie);
          await enviaWhatsNFE(jsonStr.fatura, jsonStr.serie, pegaChave('#txtCliente'), pegaDescricao('#txtCliente'));
        }

      }

      mensagem = mensagem == undefined ? '' : mensagem;

      $.LoadingOverlay("hide");
      toastr
        .success(transmiteNota ? `Nota gravada e gerada com sucesso! ${mensagem}, Você está sendo redirecionado para página de impressão.` : `Nota gravada com sucesso! ${mensagem}, Você está sendo redirecionado para página de impressão.`, "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            // window.location.href = `${BASE_URI}/nfeimpressao`;
            let abaAtiva = parent.document.querySelector('#listaAbas li.active')
            if (abaAtiva.length !== 0) {
              parent.document.querySelector('#menu_impressao_nfe .nav-link').click();
              // Fecha a aba ativa
              abaAtiva.children[0].click();

            } else {
              console.error("Aba ativa não encontrada.");
            }
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do faturamento: ${error}`);
    }
  } finally {
    $(this).attr('disabled', false);
  }
});

async function buscaNFEVinculado(sCodven) {

  if (buscaValor('VENDA', 'DEVOLUCAO', 'CODVEN', sCodven) != '1') {
    return;
  }

  const pesquisaNFCE = {
    tabela: "NOTA",
    camposSelect: [
      "NOTA.CHAVE_NFE",
      "NOTA.FATURA",
      "NOTA.SERIE",
      "NOTA.CODCLI",
      "NOTA.DT_EMISSAO",
      "NOTA.CODVEN"
    ],
    where: [`NOTA.CHAVE_NFE <> '' AND CODVEN IN (SELECT CODVENORIG FROM [ITVENDA] WHERE CODVEN = ${pegaChave('#txtNumeroVenda')}) AND EMP_ID = ${getCookie('emp_id')}`],
  };

  const jsonNFCE = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNFCE));

  if (jsonNFCE.length > 0) {
    const fatura = await retornaFaturaSemEmpId(jsonNFCE[0].FATURA, jsonNFCE[0].SERIE);

    $("#tabelaNotasRef")
      .DataTable()
      .row.add([
        fatura,
        jsonNFCE[0].SERIE,
        jsonNFCE[0].CODCLI,
        jsonNFCE[0].DT_EMISSAO.split('-')[2] + '/' + jsonNFCE[0].DT_EMISSAO.split('-')[1] + '/' + jsonNFCE[0].DT_EMISSAO.split('-')[0],
        0,
        0,
        55,
        '01',
        "0.00",
        "0.00",
        "0.00",
        '',
        '',
        retornaBotaoExcluirNota(),
        jsonNFCE[0].CHAVE_NFE,
      ])
      .draw(false);
  }
}

async function buscaNFCEVinculado() {

  const pesquisaNFCE = {
    tabela: "NOTA_NFCE",
    camposSelect: [
      "NOTA_NFCE.CHAVE_NFCE",
      "NOTA_NFCE.FATURA",
      "NOTA_NFCE.SERIE",
      "NOTA_NFCE.CODCLI",
      "NOTA_NFCE.DT_EMISSAO",
      "NOTA_NFCE.CODVEN"
    ],
    where: [`CODVEN IN (SELECT CODVENORIG FROM [ITVENDA] WHERE CODVEN = ${pegaChave('#txtNumeroVenda')})`],
  };

  const jsonNFCE = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaNFCE));

  if (jsonNFCE.length > 0) {

    msgAlerta(`Existe um NFC-e gerado na venda ${jsonNFCE[0].CODVEN}, gostaria de referenciar automaticamente?`,
      () => { callBack(); })

    function callBack() {
      $("#tabelaNotasRef")
        .DataTable()
        .row.add([
          jsonNFCE[0].FATURA,
          jsonNFCE[0].SERIE,
          jsonNFCE[0].CODCLI,
          jsonNFCE[0].DT_EMISSAO.split('-')[2] + '/' + jsonNFCE[0].DT_EMISSAO.split('-')[1] + '/' + jsonNFCE[0].DT_EMISSAO.split('-')[0],
          0,
          0,
          65,
          '01',
          "0.00",
          "0.00",
          "0.00",
          '',
          '',
          retornaBotaoExcluirNota(),
          jsonNFCE[0].CHAVE_NFCE,
        ])
        .draw(false);
    }

  }

}

async function imprimirBoleto(fatura) {
  const url = `/sisplan/impressao/v1/imprimirboletofat?FATURA=${fatura}&TRANSMITIR=S&EMAIL=N`;
  try {
    $.LoadingOverlay("show");
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico('NFEBoleto');
      const arquivo = await GeraRelatorio(url + '&', 'GET', 1000000, false, 'NFEBoleto');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/` + arquivo, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
};

async function imprimirNFe(fatura, serie) {
  const layoutNFE = await CopiaParametro('EXPEDICAO', 3) == 0 ? 'NFE' : 'NFESimplificada';

  let url = layoutNFE == 'NFE' ? '/sisplan/nfe/v1/imprimirnfe?' : '/sisplan/nfe/v1/imprimirnfesimplificada?';
  url += `FATURA=${fatura}&SERIE=${serie}`;

  // const url = `/sisplan/nfe/v1/imprimirnfe?FATURA=${fatura}&SERIE=${serie}`;
  try {
    $.LoadingOverlay("show");
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico(layoutNFE);
      const arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, layoutNFE);
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/` + arquivo, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
};

async function enviarEmail(fatura, serie) {
  const bEmail = await CopiaParametro("FATURAMENTO", 7) == '1';

  if (!bEmail) {
    return
  }

  const url = '/sisplan/nfe/v1/enviaremail?';
  try {
    try {
      $.LoadingOverlay("show");
      const response = await requisicao('POST', url, `FATURA=${fatura}&SERIE=${serie}&CODUSUARIO=${getCookie('cod_usuario')}`, null, 300000);
      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem)
        return;
      }

      return jsonStr.mensagem;
    } catch (error) {
      console.error(error);
      msgErro('Erro ao enviar e-mail');
    }
  } finally {
    $.LoadingOverlay("hide");
  }
};

function insereCondicoesPgto(sPagto) {
  for (let i = 0; i < 36; i += 3) {
    const id = '#edtVencimento' + (i == 0 ? 1 : ((i / 3) + 1));
    $(id).val(((sPagto.substring(i, 3 + i)).replace(/^(0+)(\d)/g, "$2")).trim());
  }
};

async function buscaNaturezaGeraReceber() {
  try {
    const codNatureza = pegaChave("#txtNatureza");

    if (codNatureza == "") {
      return false;
    }

    const responseNat = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"NATUREZA", "camposSelect":["DUPLI"], 
            "where": ["NATUREZA = '${codNatureza}'"]}`,
      null
    );

    if (!responseNat) {
      return false;
    }

    if (responseNat.status != 200) {
      return false;
    }

    const jsonNat = await responseNat.json();

    if (jsonNat.RESULT[0].length <= 0) {
      return false;
    }

    return jsonNat.RESULT[0][0].DUPLI == "S";

  } catch (error) {
    console.error(error);
  }

}

async function buscaRegraGeraReceber() {
  try {
    const codOperacao = pegaChave("#txtReducao");

    if (codOperacao == "") {
      return false;
    }

    const responseOperacao = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"REGRA_FISCAL", 
    "camposSelect":["REGRA_FISCAL.DUPLI"], 
    "innerJoin": [{"tabela": "OPER_FISCAL", "condicao": "OPER_FISCAL.CODIGO = REGRA_FISCAL.COD_OPER"}],
    "where": ["REGRA_FISCAL.COD_OPER = '${codOperacao}'", "REGRA_FISCAL.ATIVO = 'S'",  "EXISTS(SELECT VALOR FROM EMP_VALOR EMP_VALOR WHERE TABELA = 'REGRA_FISCAL' AND EMP_ID = ${getCookie('emp_id')} AND EMP_VALOR.VALOR = REGRA_FISCAL.NUM_CONTROLE)"]}`);

    if (!responseOperacao) {
      return false;
    }

    if (responseOperacao.status != 200) {
      return false;
    }

    const jsonOperacao = await responseOperacao.json();

    if (jsonOperacao.RESULT[0].length <= 0) {
      return false;
    }

    return jsonOperacao.RESULT[0].filter(dados => dados.DUPLI == "S").length > 0;

  } catch (error) {
    console.error(error);
  }
}

async function consultaClienteRepresentante() {
  const parametroVenda77 = await CopiaParametro("VENDA", 77) == '1';
  let sWhere = '';
  const parametroVenda65 = await CopiaParametro('VENDA', 65) == '2';
  if (parametroVenda65) {
    sWhere = ` AND ENTIDADE.TIPO_ENTIDADE LIKE '[PERCENTUAL]C[PERCENTUAL]'`;
  }
  if (parametroVenda77) {
    const vendedor = await buscaVendedorUsuario();
    const deposito = await buscaDepositoUltimoMovimento(vendedor.CODREP);
    const selectTxtClienteMovimento = {
      tabela: "ENTIDADE",
      camposSelect: ["CODCLI CHAVE", "NOME DESCRICAO", "CNPJ"],
      where: [`ENTIDADE.REG_ESTADO = '${deposito.REGIAO}' AND ENTIDADE.NOME <> 'CONSUMIDOR FINAL' AND ENTIDADE.ATIVO = 'S'`]
    }
    const selectBtnClienteUltimoMovimento = {
      tabela: "ENTIDADE",
      camposSelect: ["CODCLI", "NOME", "FANTASIA", "CNPJ"],
      where: [`REG_ESTADO = '${deposito.REGIAO}' AND NOME <> 'CONSUMIDOR FINAL' AND ATIVO = 'S' ${sWhere}`]
    }
    insereValor('#txtRepresentante', vendedor.CODREP, vendedor.NOME);
    $("#txtRepresentante").prop('disabled', true);
    $("#btn-representante").prop('disabled', true);
    $("#btn-limpa-representante").prop('disabled', true);
    $('#txtCliente').unbind('autocompleta');
    $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtClienteMovimento)}`);
    $("#btn-cliente").pesquisa_serverside(
      ["#txtCliente", "#txtCNPJ"],
      ["CODCLI", "CNPJ"],
      ["NOME", "CNPJ"],
      JSON.stringify(selectBtnClienteUltimoMovimento),
      "Pesquisa Cliente"
    );
  } else {
    $("#txtCliente").autocompleta(
      3,
      `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S' ${sWhere}"] }`,
      ["#txtCNPJ"],
      ["CNPJ"],
      ["CNPJ"]
    );

    $("#btn-cliente").pesquisa_serverside(
      ["#txtCliente", "#txtCNPJ"],
      ["CODCLI", "CNPJ"],
      ["NOME", "CNPJ"],
      `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S' ${sWhere}"]}`,
      "Pesquisa Cliente"
    );

    $("#txtRepresentante").autocompleta(
      3,
      `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,
      [],
      [],
      []
    );
    $("#btn-representante").pesquisa_array(
      ["#txtRepresentante"],
      ["CODREP"],
      ["NOME"],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,
      "Pesquisa Represen",
      "represen"
    );
  }
}

// fatura lote aqui pra baixo
$('#txtLote, #txtSetorLote, #txtParteLote').on('blur', async function () {
  const lote = pegaValor('#txtLote');
  const setor = pegaChave('#txtSetorLote');
  const parte = pegaChave('#txtParteLote');

  if ((lote == '') || (setor == '') || (parte == '')) {
    return;
  }

  await buscaNaturezaLote(lote, setor, parte);
});

async function buscaNaturezaLote(sLote, sSetor, sParte) {
  $.LoadingOverlay('show');
  try {
    const objPesquisa = {
      tabela: "FACCAO",
      camposSelect: [
        "FACCAO.CODCLI",
        "ENTIDADE.NOME",
        "NATUREZA.NATUREZA",
        "NATUREZA.DESCRICAO",
        "OF1.DEPOSITO",
        "DEPOSITO.DESCRICAO DESC_DEPOSITO"
      ],
      leftJoin: [
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = FACCAO.CODCLI' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = ENTIDADE.NATUREZA' },
        { tabela: 'OF1', condicao: 'OF1.NUMERO = FACCAO.NUMERO' },
        { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = OF1.DEPOSITO' }
      ],
      where: [`FACCAO.NUMERO = '${sLote}' AND FACCAO.OP = '${sSetor}' AND FACCAO.PARTE = '${sParte}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(objPesquisa));

    if (jsonStr.length == 0) {
      return;
    }

    insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
    insereValor('#txtNaturezaLote', jsonStr[0].NATUREZA, jsonStr[0].DESCRICAO);

    if (jsonStr[0].DEPOSITO != '') {
      insereValor('#txtDeposito', jsonStr[0].DEPOSITO, jsonStr[0].DESC_DEPOSITO);
    }
  } finally {
    $.LoadingOverlay('hide');
  }
}

$('#btn_confirmar_lote').on('click', async function () {
  const lote = pegaValor('#txtLote');
  const setor = pegaChave('#txtSetorLote');
  const parte = pegaChave('#txtParteLote');
  const natureza = pegaChave('#txtNaturezaLote');
  const operacao = pegaChave('#txtOperacaoLote');

  if ([lote, setor, parte].includes('')) {
    msgAlerta('Algum campo obrigatório vazio, favor verificar.')
    return;
  }

  if ((natureza == '') && (operacao == '')) {
    msgAlerta('Campos natureza e operação estão vazios, necessário preencher um dos dois para continuar.')
    return;
  }

  await importaLote(lote, setor, parte);
});

async function importaLote(sLote, sSetor, sParte) {
  $.LoadingOverlay('show');
  try {
    const response = await requisicao("GET", "/sisplan/nfe/v1/itenslote?", `LOTE=${sLote}&SETOR=${sSetor}&PARTE=${sParte}&AGRUPA=${$(":radio[name='agrupitenspor']").index($(":radio[name='agrupitenspor']:checked"))}`);

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }

    const jsonStr = await response.json();

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum dado a ser importado, favor verificar o lote.');
      limpaValor('#txtLote');
      return;
    }

    insereValor('#txtNatureza', pegaValor('#txtNaturezaLote'));
    insereValor('#txtReducao', pegaValor('#txtOperacaoLote'));

    await preencheItensLote(jsonStr, pegaValor('#txtNaturezaLote'));

    $('#modal-importar-venda').modal('hide');

  } catch (error) {
    console.error(error);
  } finally {
    $.LoadingOverlay('hide');
  }
};

async function preencheItensLote(itens, natureza) {
  itens.forEach(async (item) => {
    const index = $(".itens").length - 1;
    $(`#txtProduto-${index}`).val(`${item.CODIGO} ${item.DESCRICAO} - ${item.COR} COR - ${item.TAM}`);
    $(`#txtQuantidade-${index}`).val(item.QTDE);
    $(`#txtPreco-${index}`).val(item.PRECO_00);
    $(`#txtCFOP-${index}`).val(natureza);
    $(`#txtProduto-${index}`).attr("data-codigo", item.CODIGO);
    $(`#txtProduto-${index}`).attr("data-descricao", item.DESCRICAO);
    $(`#txtProduto-${index}`).attr("data-cor", item.COR);
    $(`#txtProduto-${index}`).attr("data-tam", item.TAMANHO);
    $(`#txtProduto-${index}`).attr("data-tipo", 'P');

    await AddItens();
  });
  removeProdutosVazios();

  setTimeout(async () => {
    await calculaTotaisItens();
    if ((pegaValor('#txtCFOP-0') != '') && (pegaValor('#txtNatureza') == '')) {
      insereValor('#txtNatureza', pegaValor('#txtCFOP-0'));
    }
  }, 1000);

  if (natureza == "") {
    await VerificaItensAdicionaNatureza(itens);
  }
}
// fim fatura lote

function botaoSelecionarGrid() {
  return (
    '<div class="form-check">' +
    '<input type="checkbox" class="align-self-center checkVendas" value"" checked>' +
    '</div>'
  );
};

$('#btnConsultarVendas').on('click', async function () {
  await buscaVendas();
});

$('#check_todos').on('click', async function () {
  $('.checkVendas').prop('checked', $('#check_todos').prop('checked'));
  addSelected($('#check_todos').prop('checked'));
});

function addSelected(add = true) {
  for (let i = 0; i < $('#tabelaVendas').DataTable().rows().data().length; i++) {
    if (add) {
      $($("table#tabelaVendas tr")[i + 1]).addClass("selected");
    } else {
      $($("table#tabelaVendas tr")[i + 1]).removeClass("selected");
    }
  }
};

async function buscaVendas() {
  $.LoadingOverlay('show');
  try {
    if (($.fn.DataTable.isDataTable('#tabelaVendas')) && ($('#tabelaVendas').DataTable().rows().count() > 0)) {
      $('#tabelaVendas').DataTable().clear().draw();
    }

    const url = '/sisplan/nfe/v1/buscavendas?';
    const filtros = retornaFiltros();
    const response = await requisicao('GET', url, filtros, null, 50000);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.mensagem)
      return;
    }

    jsonStr.forEach(function (item) {
      item.SEL = botaoSelecionarGrid();
    });

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum registro encontrado!');
      return;
    }

    jsonStr.forEach((item) => {
      $('#tabelaVendas').DataTable().row.add([item.SEL, item.VENDA, item.CLIENTE]).draw(false);
    });

    $('#check_todos').prop('checked', false);
    $('#check_todos').trigger('click');
  } catch (error) {
    msgAlerta('Erro na rotina buscaVendas: ', error.message);
  } finally {
    $.LoadingOverlay('hide');
  }
}

function retornaFiltros() {
  const dataDe = pegaValor('#txtDtEmiVendasDe');
  const dataAte = pegaValor('#txtDtEmiVendasAte');
  const emitido = isChecked('#cbEmitido');
  const pendente = isChecked('#cbPendente');
  const agrupada = isChecked('#cbAgrupada');
  const devolvido = isChecked('#cbDevolvido');
  const cancelada = isChecked('#cbCancelada');
  const emp_id = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
    : [getCookie('emp_id')];

  return `DATADE=${dataDe}&DATAATE=${dataAte}&EMITIDO=${emitido}&PENDENTE=${pendente}&AGRUPADA=${agrupada}&DEVOLVIDO=${devolvido}&CANCELADA=${cancelada}&EMP_ID=${emp_id}`;
}

function validaCookiePedido() {
  $('#cbSomenteExpedidos').prop('checked', getCookie('faturar_ped_somente_exp') == 'S');
  if (getCookie('faturar_ped_somente_exp') == 'S') {
    $('#cbSomenteExpedidos').change();
  }
}