/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#tutLeft',
                popover: {
                    title: 'Campos para cadastro',
                    description: 'Neste campos, adicionamos os dados para incluir na tabela.',
                    position: 'top'

                }
            },
            {
                element: '#tabelatuto',
                popover: {
                    title: 'Tabela de tamanhos',
                    description: 'Nesta tabela constará as faixas adicionadas.',
                    position: 'top'

                }
            },
            {
                element: '#checkAtivo',
                popover: {
                    title: 'Ativo',
                    description: 'Aqui, definimos a faixa de tamanho como ativa.',
                    position: 'top'

                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Campos Obrigatórios',
                    description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                    position: 'top'

                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'O campo de descrição é preenchido automaticamente com os tamanhos após gravar o registro.',
                    position: 'top'

                }
            },
            {
                element: '#txtTamanho',
                popover: {
                    title: 'Tamanhos',
                    description: 'Neste campo, adicionamos os tamanhos, podemos consultar os tamanhos clicando na lupa.',
                    position: 'top'

                }
            },
            {
                element: '#txtPerc',
                popover: {
                    title: 'Percentual',
                    description: 'Aqui adicionamos a porcentagem por tamanho.',
                    position: 'top'

                }
            },
            {
                element: '#btnIncluir',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Ao clicar, adicionamos o tamanho na tabela.',
                    position: 'top'

                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar a faixa.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let faixa = parametros[parametros.length - 1];
    let listaTam = [];

    $('#txtCodigo').prop('disabled', true);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('FAIXATAMANHO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/faixatamanho`;
    });


    $('#tabelaPrecos').DataTable({
        paging: false,
        filter: false,
        info: false,
        ordering: true,
        destroy: true,
        scrollY: "215px",
        scrollCollapse: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }

        },
        "columnDefs": [{
            "targets": [0],
            "visible": false
        }]
    });

    $(document).ready(async function () {

        $(function () {
            $('#txtPerc').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
            });
        });

        $("#btnIncluir").click(function () {
            if (($("#msform").validate().element("#txtTamanho"))) {
                limpaCampos();
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe um tamanho.",
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"tabtam", "camposSelect":[ "TAM chave", "ID_TAM descricao"], "where": null}`);

        $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'ID_TAM', `/sisplan/funcoes/v1/pesquisa?JSON={ 
            "tabela":"tabtam", "camposSelect":[ "TAM", "ID_TAM"]}`, 'Pesquisa Tamanho', 'tabtam');
        $('#btnATamanho').on('click', function () {
            $('#txtTamanho').val('');
        });

        if (faixa != '' && faixa != 'create') {

            if (await liberarRegistro('FAIXATAMANHO', faixa) == false) {
                window.location.href = '../faixatamanho';
            } else {
                carregaDados(faixa);
            }
        }

        async function carregaDados(faixaUrl) {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"faixa", 
                            "camposSelect":["codigo", "descricao", "ativo", "descricao2"], 
                            "where": ["codigo = '${faixaUrl}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtDescricao2').val(jsonStr.RESULT[0][0].DESCRICAO2);

                    if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    } else {
                        $('#checkAtivo').prop('checked', false);
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"faixa_iten", 
                            "camposSelect":["posicao", "tamanho", "percentual"], 
                            "where": ["faixa = '${faixaUrl}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    console.log(jsonStr.RESULT[0].length);

                    for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
                        let ordem = jsonStr.RESULT[0][i].POSICAO;
                        let tamanho = jsonStr.RESULT[0][i].TAMANHO;
                        let percentual = jsonStr.RESULT[0][i].PERCENTUAL;

                        if (parseFloat(percentual) > 0) {
                            percentual = jsonStr.RESULT[0][i].PERCENTUAL;
                        } else {
                            percentual = '0.00';
                        }
                        $('#tabelaPrecos').DataTable().row.add([ordem, tamanho, percentual]).order([0, 'desc']).draw(false);
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        async function limpaCampos() {
            if ($('#txtTamanho').val() != '') {
                try {
                    $.LoadingOverlay("show");
                    addTamanho();
                    $('#txtTamanho').val('');
                    $('#txtPerc').val('');
                    $('#txtDescricao2').val('');

                } finally {
                    $.LoadingOverlay('hide');
                }
            } else {
                msgAlerta('Informe um tamanho para incluir.');

            }
        };

        async function addTamanho() {
            let tamanho = pegaChave('#txtTamanho');
            let descricao;
            if (!listaTam.includes(tamanho)) {
                let percentual = $('#txtPerc').val();
                let ordem = $('#tabelaPrecos').DataTable().rows().count() + 1;
                $('#tabelaPrecos').DataTable().row.add([ordem, tamanho, percentual]).order([0, 'desc']).draw(false);
                if (ordem == 1) {
                    descricao = tamanho;
                } else {
                    descricao = `${$('#txtDescricao').val()}/${tamanho}`;
                }
                $('#txtDescricao').val(descricao);
                listaTam.push(tamanho);
            } else {
                msgAlerta('Tamanho já está na faixa.');
            }
        };

        $(".submit").click(function () {
            return false;
        });
    });
    $("#btnGravar").click(

        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    let faixaClasse = {};

                    faixaClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('faixa', 'faixa', 'CODIGO', 2) : $('#txtCodigo').val();
                    faixaClasse.DESCRICAO = $('#txtDescricao').val();
                    faixaClasse.DESCRICAO2 = $('#txtDescricao2').val();

                    if ($('#checkAtivo').prop('checked')) {
                        faixaClasse.ATIVO = 'S';
                    } else {
                        faixaClasse.ATIVO = 'N';
                    }

                    let arrayTamanhos = [];
                    for (let index = 0; index < $('#tabelaPrecos').DataTable().rows().count(); index++) {
                        let data = $('#tabelaPrecos').DataTable().row(index).data();
                        let tamanho = {};
                        tamanho.FAIXA = faixaClasse.CODIGO;
                        tamanho.POSICAO = data[0];
                        tamanho.TAMANHO = data[1];
                        if (data[2] > 0) {
                            tamanho.PERCENTUAL = data[2];
                        } else {
                            tamanho.PERCENTUAL = data[2];
                        };
                        arrayTamanhos.push(tamanho);
                    }
                    faixaClasse.TAMANHOS = arrayTamanhos;

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/faixa?', `JSON=${encodeURIComponent(JSON.stringify(faixaClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                         Faixa: ${faixaClasse.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/faixatamanho`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da região: ${error}`);
            }

        });
});