$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta dos funcionários.",
          position: "right",
        },
      },
      {
        element: "#btn-novoFuncionario",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um funcionário.",
          position: "right",
        },
      },
      {
        element: "#tabelaFuncionario",
        popover: {
          title: "Tabela Funcionários",
          description: "Aqui estão os dados dos funcionários.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos('EXTRATO');

  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  if (colunas == null || colunas.extrato == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, extrato: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }

  $("#btnConfirmarColunas").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const novasColunas = retornaNovasColunasInvisiveis();

      localStorage.setItem(
        "colunasInvisiveisRelatorios",
        JSON.stringify({ ...colunas, extrato: novasColunas })
      );

      $("#tabelaDados").DataTable().columns().visible(true);

      $("#tabelaDados")
        .DataTable()
        .columns()
        .every(function () {
          if (novasColunas.indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        });
    } finally {
      $.LoadingOverlay("hide");
      $("#modal-ColunasVisiveis").modal("hide");
    }
  });

  componenteFiltro('conta');

  $('#btnContaImportacao').pesquisa_serverside(['#txtContaImportacao'], ['CONTA'], ['DESCRICAO'], '{"tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"], "where": null}', 'Pesquisa de Conta');
  $('#txtContaImportacao').autocompleta(1, 'JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#btnBancoImportacao').pesquisa_serverside(['#txtBancoImportacao'], ['BANCO'], ['NOME_BANCO'], '{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"], "where": null}', 'Pesquisa de Banco');
  $('#txtBancoImportacao').autocompleta(1, 'JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}');

  $('#btnClassePagar').pesquisa_serverside(['#txtClassePagar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Classe');
  $('#txtClassePagar').autocompleta(1, 'JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#btnClasseBaixaPagar').pesquisa_serverside(['#txtClasseBaixaPagar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Classe');
  $('#txtClasseBaixaPagar').autocompleta(1, 'JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#btnHistoricoPagar').pesquisa_serverside(['#txtHistoricoPagar'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
  $('#txtHistoricoPagar').autocompleta(1, 'JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#btnHistoricoBaixaPagar').pesquisa_serverside(['#txtHistoricoBaixaPagar'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Histórico');
  $('#txtHistoricoBaixaPagar').autocompleta(1, 'JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
  $('#btnSituacaoPagar').pesquisa_serverside(['#txtSituacaoPagar'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Situação');
  $('#txtSituacaoPagar').autocompleta(1, 'JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

  $('#btnLimpaContaImportacao').on('click', function () {
    $('#txtContaImportacao').val('');
  });

  $('#btnLimpaBancoImportacao').on('click', function () {
    $('#txtBancoImportacao').val('');
  });

  $('#btnLimpaClassePagar').on('click', function () {
    $('#txtClassePagar').val('');
  });

  $('#btnLimpaClasseBaixaPagar').on('click', function () {
    $('#txtClasseBaixaPagar').val('');
  });

  $('#btnLimpaHistoricoPagar').on('click', function () {
    $('#txtHistoricoPagar').val('');
  });

  $('#btnLimpaHistoricoBaixaPagar').on('click', function () {
    $('#txtHistoricoBaixaPagar').val('');
  });

  $('#btnLimpaSituacaoPagar').on('click', function () {
    $('#txtSituacaoPagar').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('.campoValorDecimal').on('input', function () {
    if (($(this).val()).split('.')[1]?.length > 2) {
      $(this).val(($(this).val()).slice(0, -1));
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      await buscaDados();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaDados() {
    try {

      const filtros = await retornaFiltros();

      const response = await requisicao('GET', '/sisplan/extrato/v1/buscadados?', filtros, '', 600000);
      if (!response) {
        return;
      }

      const data = await response.json();

      if ($.fn.DataTable.isDataTable('#tabelaDados')) {
        $('#tabelaDados').DataTable().destroy();
        $('#tabelaDados').empty();
      };

      const cols = [{
        data: 'LANCTO',
        title: 'Lançamento'
      },
      {
        data: 'CONTA',
        title: 'Conta'
      },
      {
        data: 'DESC_CONTA',
        title: 'Desc. Conta'
      },
      {
        data: 'DOCTO',
        title: 'Documento'
      },
      {
        data: 'DT_CONT',
        title: 'Data Cont.'
      },
      {
        data: 'OBSERVACAO',
        title: 'Observação'
      },
      {
        data: 'OPERACAO',
        title: 'Operação'
      },
      {
        data: 'VALOR',
        title: 'Valor'
      },
      {
        data: 'CONCILIADO',
        title: 'Conciliado'
      },
      {
        data: 'SALDO_ANT',
        title: 'Saldo Ant.'
      },
      {
        data: 'SALDO',
        title: 'Saldo'
      }];

      $("#tabelaDados").DataTable({
        order: false,
        sort: true,
        paging: true,
        destroy: true,
        lengthChange: true,
        searching: true,
        info: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: data,
        columns: cols,
        columnDefs: [
          {
            targets: [0],
            render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            targets: [7, 9, 10],
            render: function (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            },
            "className": 'pr-4 text-right'
          },
          {
            type: 'date-br',
            targets: [4],
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              } else {
                return '';
              }

            },
          },
        ],
        rowCallback: async function (row, data) {
          if ((data.OPERACAO == 'D')) {
            $(row).css('background-color', 'rgb(255, 75, 83)');
          }
        },
      }).draw(false);

      await buscaSaldoAnterior();

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaDados_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaDados_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const filtros = await retornaFiltros();
        await exportaCSV('/sisplan/extrato/v1/buscadados?', filtros, false, null, "Relatório de Extrato", "#tabelaDados", formataCampos());
      })

      $('#tabelaDados').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.extrato).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

      $('#modal-filtros').modal('hide');
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    }
  };

  $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );

    $("#tabelaDados")
      .DataTable()
      .columns()
      .every(function () {
        cols.push({
          title: $(this.header()).text(),
          data: this.dataSrc(),
        });
      });
    adicionaColunas(cols, colunasInvisiveis.extrato ?? []);
  });

  function formataCampos() {
    retorno =
      "dados = dados.map((key) => { \n" +
      `let v1 = key.SALDO_ANT 
      if (typeof v1 == 'string') {
      v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2);
      } else {
      v1 = parseFloat(v1).toFixed(2); }
      let v2 = key.SALDO 
      if (typeof v2 == 'string') {
      v2 = parseFloat(v2.replace(".", "").replace(",", ".")).toFixed(2);
      } else {
      v2 = parseFloat(v2).toFixed(2); }` +
      "return {...key, SALDO_ANT: v1, SALDO: v2 } \n" +
      "}) \n";
    return retorno;
  }

  function retornaBotaoOpcoes(sCodigo) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + sCodigo + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '       <button class="dropdown-item" id="btn-alterar">Alterar</button> ' +
      '       <button class="dropdown-item" id="btn-excluir">Excluir</button> ' +
      '</div>';
    return retorno;
  }

  async function retornaFiltros() {

    const filtros = `PERIODO_DE=${$('#txtDataIni').val() == '' ? '1200-01-01' : $('#txtDataIni').val()}`+
                    `&PERIODO_ATE=${$('#txtDataFim').val() == '' ? '2500-12-31' : $('#txtDataFim').val()}`+
                    `&DOCUMENTO=${$('#txtDocto').val()}`+
                    `&CONTA=${pegaChave('#txtConta')}`+
                    `&TIPO=${$('#txtTipo').val()}`+
                    `&OBSERVACAO=${$('#txtObs').val()}`+
                    `&VALOR_DE=${parseFloat($('#txtValorIni').val())}`+
                    `&VALOR_ATE=${parseFloat($('#txtValorFim').val())}`;
    return filtros;
  };

  async function buscaSaldoAnterior() {
    try {
      const data = $('#txtDataIni').val() != '' ? $('#txtDataIni').val() : '2500-12-31';

      const credito = (await buscaValor('EXTRATO', 'SUM(VALOR) VALOR', `DT_CONT < '${data}' AND OPERACAO`, 'C')).VALOR;
      const debito = (await buscaValor('EXTRATO', 'SUM(VALOR) VALOR', `DT_CONT < '${data}' AND OPERACAO`, 'D')).VALOR;

      const result = parseFloat(credito - debito).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      });

      $('#txtSaldoAnterior').val(result == 'NaN' ? '0,00' : result);

      if (result < 0) {
        $('#txtSaldoAnterior').css('color', 'red!important');
      } else if (result > 0) {
        $('#txtSaldoAnterior').css('color', 'green!important');
      } else {
        $('#txtSaldoAnterior').css('color', 'black!important');
      }
    } catch (e) {

    }
  }

  $('#tabelaDados').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
      if (data.CONCILIADO == 'S') {
        msgErro('Esse registro já está conciliado. Impossível continuar.');
        return;
      }
      msgAlerta('Tem certeza que deseja excluir esse registro?', () => { }, () => { }, async () => {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      const response = await requisicao("DELETE", "/sisplan/extrato/v1/excluiregistro?", `&LANCTO=${data.LANCTO}`, null);
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#btnConsultar').trigger('click');
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível realizar a exclusão: ${e}`);
    }
  };

  $('#tabelaDados').on('click', '#btn-alterar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaDados').DataTable().row($(this).parents('tr')).data();
      if (data.CONCILIADO == 'S') {
        msgErro('Esse registro já está conciliado. Impossível continuar.');
        return;
      }

      window.location.href = `extrato/${data.LANCTO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  limparFiltros();

  $('#btnIncluir').on('click', function () {
    window.location.href = `extrato/create`;
  });

  async function leArquivoXLS(file) {
    var file = document.querySelector('input[type=file]').files[0];
    var name = file.name.toUpperCase();
    var reader = new FileReader();

    reader.onload = function (e) {
      var data = e.target.result;
      var cfb = XLS.CFB.read(data, { type: 'binary' });
      var wb = XLS.parse_xlscfb(cfb);
      wb.SheetNames.forEach(function (sheetName) {
        var sCSV = XLS.utils.make_csv(wb.Sheets[sheetName]);
        // var oJS = XLS.utils.sheet_to_row_object_array(wb.Sheets[sheetName]);

        const objRetorno = transformStringEmArray(sCSV);
        $('#conteudoFormatado').val(JSON.stringify(objRetorno))
      });
    };
    reader.readAsBinaryString(file);
  }

  $('#btnArquivoImportacao').on('click', function (e) {
    e.preventDefault();
    if ($('#txtOpcaoImportacao').val() == '' || $('#txtOpcaoImportacao').val() == null || $('#txtOpcaoImportacao').val() == undefined) {
      msgErro('É necessário informar uma opção de importação, favor verificar.');
      return;
    }
    $('#mdModalUpload').trigger('click');
  });

  $('#mdModalUpload').on('change', async function () {
    let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
    $('#txtArquivoImportacao').val(nomeAnexo);

    let file = document.getElementById('mdModalUpload').files[0];
    let reader = new FileReader();

    switch ($('#txtOpcaoImportacao').val()) {
      case '':
        msgErro('É necessário informar uma opção de importação, favor verificar.');
        return;
      case '0':
        dados = leArquivoPosicao(reader, file);
        break;
      case '1':
        dados = leArquivoExcel(reader, file, nomeAnexo);
        break;
      case '2':
        dados = leArquivoTXT(reader, file);
        break;
      case '3':
        dados = leArquivoOFX(reader, file);
        break;
      case '4':
        dados = leArquivoHtml(reader, file);
        break;
      default:
        break
    }
  });

  function leArquivoPosicao(reader, file) {
    try {
      reader.onload = function (e) {
        $('#fileContent').text(e.target.result);
      }
      reader.readAsText(file);

    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`)
      return;
    }
  };

  function leArquivoExcel(reader, file, name) {
    try {

      const extension = (name.split('.')[name.split('.').length - 1]);
      if (extension == 'csv') {
        reader.onload = function (e) {
          $('#fileContent').text(e.target.result);
        }
        reader.readAsText(file);
      } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
        reader.onload = function (e) {
          const data = new Uint8Array(e.target.result);
          const workbook = XLSX.read(data, { type: 'array' });
          const sheetName = workbook.SheetNames[0];
          const sheet = workbook.Sheets[sheetName];

          // Get the range of the sheet
          const range = XLSX.utils.decode_range(sheet['!ref']);
          let resultString = '';

          for (let R = range.s.r; R <= range.e.r; ++R) {
            for (let C = range.s.c; C <= range.e.c; ++C) {
              const cellAddress = { c: C, r: R };
              const cellRef = XLSX.utils.encode_cell(cellAddress);
              const cell = sheet[cellRef];
              let cellValue = cell ? cell.v : null;

              if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                const serialDate = cellValue;
                const jsDate = excelSerialToJSDate(serialDate);
                cellValue = formatDate(jsDate);
              }

              resultString += `${cellValue},`;
            }
            resultString = resultString.slice(0, -1); // Remove the trailing comma
            resultString += ';';
          }

          $('#fileContent').text(resultString);
        }
        reader.readAsArrayBuffer(file);

      }
    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`)
      return;
    }
  }

  function leArquivoTXT(reader, file) {
    try {
      reader.onload = function (e) {
        $('#fileContent').text(e.target.result);
      }
      reader.readAsText(file);

    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`)
      return;
    }
  }

  function leArquivoOFX(reader, file) {
    try {
      reader.onload = function (e) {
        $('#fileContent').text(e.target.result);
      }
      reader.readAsText(file);

    } catch (e) {
      msgErro(`Não foi possível ler o arquivo: ${e}`);
      return;
    }
  }

  function leArquivoHtml(reader, file) {
    reader.onload = function (e) {
      const data = new Uint8Array(e.target.result);
      const workbook = XLSX.read(data, { type: 'array' });
      const sheetName = workbook.SheetNames[0];
      const sheet = workbook.Sheets[sheetName];

      // Get the range of the sheet
      const range = XLSX.utils.decode_range(sheet['!ref']);
      let resultString = '';

      for (let R = range.s.r; R <= range.e.r; ++R) {
        for (let C = range.s.c; C <= range.e.c; ++C) {
          const cellAddress = { c: C, r: R };
          const cellRef = XLSX.utils.encode_cell(cellAddress);
          const cell = sheet[cellRef];
          resultString += `${cell ? cell.v : null},`;
        }
        resultString = resultString.slice(0, -1); // Remove the trailing comma
        resultString += ';';
      }

      $('#fileContent').text(resultString);
    }
    reader.readAsArrayBuffer(file);
  }

  $('#btnImportar').on('click', function () {
    $('#modal-importar').modal('show');
    $('#txtDataImportacao').val(formataData(new Date()));
  });

  $('#btnConsultarImportacao').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      if ($('#txtArquivoImportacao').val() == '') {
        msgErro('Arquivo não selecionado, favor verificar.');
        return;
      }

      await buscaDadosImportacao();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function retornaFiltrosImportacao() {
    let filtros = {
      BANCO: pegaChave('#txtBancoImportacao'),
      CONTA: pegaChave('#txtContaImportacao'),
      ARQUIVO: $('#txtArquivoImportacao').val(),
      SALDO: $('#txtSaldoImportacao').val(),
      LINHAINI: $('#txtLinhaImportacao').val(),
      ULTIMA_LINHA: $('#cbUltimaLinha').prop('checked'),
      DATA_VALIDA: $('#cbDataValida').prop('checked'),
      TIPO_IMPORTACAO: $('#txtOpcaoImportacao').val(),
      DATA_ARQ: $('#txtDataImportacao').val()
    };

    return filtros;
  }

  async function buscaDadosImportacao() {
    try {

      function retornaBotaoSel(meta, data) {
        let marcado = '';
        if (data == 'S') {
          marcado = 'checked';
        }

        return `<div class="icheck-primary" style="max-width: 20px">
                  <input type="checkbox" ${marcado} id="check_col_${meta.col}_row_${meta.row}" class="campoSel">
                  <label for="check_col_${meta.col}_row_${meta.row}"></label>
                </div>`

      };

      function retornaInputObs(meta, data) {

        return `<div class="relative">
                  <input type="text" class="input-default focus form-control validate" value="${data}" id="obsgrid_${meta.row}" placeholder="Observação">
                  <label for="check_col_${meta.col}_row_${meta.row}"></label>
                </div>`

      };

      const filtros = retornaFiltrosImportacao();

      const dados = retornaDados();

      const response = await requisicao('POST', '/sisplan/extrato/v1/carregaimportacao?', '', `JSON=${encodeURIComponent(JSON.stringify(filtros))}&DADOS=${dados}`, 600000);
      if (!response) {
        return;
      }

      const data = await response.json();
      if (response.status != 200) {
        msgErro(data.mensagem);
        return;
      }

      if ($.fn.DataTable.isDataTable('#tabelaImportacao')) {
        $('#tabelaImportacao').DataTable().destroy();
        $('#tabelaImportacao').empty();
      }

      const cols = [{
        data: 'SEL',
        title: `<div class="form-group icheck-primary m-0 p-0 d-flex align-items-center" id="containerSelTodos">
                  <input type="checkbox" class="input-default focus form-control validate" id="cbSelecionarTodos" name="cbSelecionarTodos">
                  <label for="cbSelecionarTodos" style="width: 45px">Sel</label>
                </div>`
      },
      {
        data: 'DOCTO',
        title: 'Documento'
      },
      {
        data: 'DT_CONT',
        title: 'Data Contabilização'
      },
      {
        data: 'VALOR',
        title: 'Valor'
      },
      {
        data: 'CONTA',
        title: 'Conta'
      },
      {
        data: 'OPERACAO',
        title: 'Operação'
      },
      {
        data: 'OBS',
        title: 'Observação'
      },
      {
        data: 'CHAVE',
        title: 'Chave'
      }];

      $("#tabelaImportacao").DataTable({
        order: false,
        sort: true,
        paging: false,
        destroy: true,
        lengthChange: false,
        searching: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: data,
        columns: cols,
        columnDefs: [
          {
            targets: [0],
            render: function (data, type, row, meta) {
              return retornaBotaoSel(meta, data);
            }
          },
          {
            targets: [3],
            render: function (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            },
          },
          {
            type: 'date-br',
            targets: [2],
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              } else {
                return '';
              }

            },
          },
          {
            type: 'date-br',
            targets: [6],
            render: function (data, type, row, meta) {
              return retornaInputObs(meta, data);
            }
          },
        ],
        rowCallback: async function (row, data) {
          $(`#check_col_0_row_${row._DT_RowIndex}`).off('change');

          $(`#check_col_0_row_${row._DT_RowIndex}`).on('change', function () {
            let indice = (this.id).split('_')[4];
            let d = $('#tabelaImportacao').DataTable().row(indice).data();

            d.OBS = $(`#obsgrid_${row._DT_RowIndex}`).val();

            if ($(this).prop('checked')) {
              d.SEL = 'S';
            } else {
              d.SEL = 'N';
            }

            $('#tabelaImportacao').DataTable().row(indice).data(d).draw(false);
          })
        },
      }).draw(false);

      $('#cbSelecionarTodos').on('change', function () {
        if ($('#cbSelecionarTodos').prop('checked')) {
          $('.campoSel').prop('checked', true);
        } else {
          $('.campoSel').prop('checked', false);
        }
        $('.campoSel').trigger('change');
      });

      $('#tabelaImportacao thead th').each(function () {
        $(this)[0].style.verticalAlign = 'top';
      });

      if ($('#tabelaImportacao').DataTable().data().length > 0) {
        $($('#tabelaImportacao thead tr th')[0]).css('width', '50px');
        $('#tabelaImportacao thead tr th label').css('width', '30px');
      }

      $('#btnConfirmarImportacao').removeClass('d-none');
      $('#btnCriarAPImportacao').removeClass('d-none');
      $('#btnCriarAntecipacaoImportacao').removeClass('d-none');
      $('#divSaldoFinalImportacao').removeClass('d-none');

      calculaSaldoFinal();
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    }
  };

  function retornaDados() {
    let info = $('#fileContent').text();
    let opcao = $('#txtOpcaoImportacao').val();
    let arquivo = $('#txtArquivoImportacao').val();
    let ext = (arquivo.split('.'))[(arquivo.split('.')).length - 1];
    let dados = '';

    switch (opcao) {
      case '0':
        dados = formataDadosText(info);
        break;
      case '1':
        dados = formataDadosExcel(info, ext);
        break;
      case '2':
        dados = formataDadosText(info);
        break;
      case '3':
        dados = formataDadosText(info);
        break;
      case '4':
        dados = formataDadosExcel(info);
        break;
      default:
        break;
    }

    return dados;
  }

  function formataDadosText(info) {
    return encodeURIComponent(JSON.stringify(((info.replaceAll('\r', '')).split('\n')).filter(item => item != '')));
  }

  function formataDadosExcel(info, ext) {
    let char1, char2;
    if (ext == 'csv') {
      char1 = '\n';
      char2 = ';';
    } else {
      char1 = ';';
      char2 = ',';
    }

    let data = (info.split(char1)).filter(item => item != '');
    let arrayRetorno = [];

    let firstLine = data[0].split(char2);

    firstLine = firstLine.map(e => {
      return e.normalize("NFD").replaceAll('R$', '').replace(/[\u0300-\u036f]/g, '').replace(/[^\w\s]/gi, '').replaceAll('.', '').replaceAll(',', '').toUpperCase().trim();
    })

    let index1 = (firstLine).indexOf('DOCTO');
    let index2 = (firstLine).indexOf('DATA');
    let index3 = (firstLine).indexOf('VALOR');
    let index4 = (firstLine).indexOf('HISTORICO');

    data.map((e, i) => {
      if (i != 0) {
        let d = e.split(char2);
        if (d[index1] == 'null' && d[index2] == 'null' && d[index3] == 'null' && d[index4] == 'null') {
          return;
        }

        let v1, v2, v3, v4;

        v1 = d[index1] == 'null' || d[index1] == undefined ? '' : d[index1];
        try {
          v2 = d[index2] == 'null' || d[index2] == undefined ? formataData(new Date()) : formataDataComTraco(d[index2]);
        } catch (e) {
          msgErro(`Data inválida na linha ${i} - ${e}`);
          console.log(e);
        }
        try {
          v3 = d[index3] == 'null' || d[index3] == '' || d[index3] == undefined ? 0 : parseFloat(d[index3]);
        } catch (e) {
          msgErro(`Valor inválido na linha ${i} - ${e}`);
          console.log(e);
        }
        v4 = d[index4] == 'null' || d[index4] == undefined ? '' : d[index4];

        arrayRetorno.push({
          DOCTO: v1,
          DATA: v2,
          VALOR: v3,
          HISTORICO: v4
        });
      }
    });

    return encodeURIComponent(JSON.stringify(arrayRetorno));
  }

  $('#txtOpcaoImportacao').on('change', function () {
    if ($(this).val() == '1') {
      $('#txtLinhaImportacao').prop('disabled', true);
    } else {
      $('#txtLinhaImportacao').prop('disabled', false);
    }
    $('#txtArquivoImportacao').val('');
    $('#mdModalUpload').val('');
  });

  function excelSerialToJSDate(serial) {
    let utc_days = Math.floor(serial - 25569);
    let utc_value = utc_days * 86400;
    let date_info = new Date(utc_value * 1000);

    let fractional_day = serial - Math.floor(serial) + 0.0000001;

    let total_seconds = Math.floor(86400 * fractional_day);

    let seconds = total_seconds % 60;

    total_seconds -= seconds;

    let hours = Math.floor(total_seconds / (60 * 60));
    let minutes = Math.floor(total_seconds / 60) % 60;

    return new Date(date_info.getFullYear(), date_info.getMonth(), date_info.getDate(), hours, minutes, seconds);
  }

  function formatDate(date) {
    let day = date.getDate();
    let month = date.getMonth() + 1; // Months are zero-based
    let year = date.getFullYear();

    // Add leading zeros if needed
    day = day < 10 ? '0' + day : day;
    month = month < 10 ? '0' + month : month;

    return day + '/' + month + '/' + year;
  }

  $('#btnFecharImportacao').on('click', function () {
    if ($.fn.DataTable.isDataTable('#tabelaImportacao')) {
      if ($('#tabelaImportacao').DataTable().data().length > 0) {
        msgAlerta('Tem certeza que deseja cancelar o procedimento?', () => { }, () => { }, () => { $('#modal-importar').modal('hide') });
      }
    } else {
      $('#modal-importar').modal('hide');
    }
  });

  $('#txtContaImportacao').on('blur', async function () {
    if ($(this).val() != '') {
      $.LoadingOverlay('show');
      try {
        try {

          const infoConta = (await buscaValor('CADCONTA', 'BANCO, ATIVO', 'CONTA', pegaChave(this)));

          if (infoConta.ATIVO == 'N') {
            msgErro('Conta inativa, impossível continuar.', () => {
              $('#txtContaImportacao').val('');
              $('#txtContaImportacao').focus();
            }, () => {
              $('#txtContaImportacao').val('');
              $('#txtContaImportacao').focus();
            });
            return;
          }

          const banco = infoConta.BANCO;

          const c = (await buscaValor('EXTRATO', 'SUM(VALOR) VALOR', `OPERACAO = 'C' AND CONTA`, pegaChave(this))).VALOR;
          const d = (await buscaValor('EXTRATO', 'SUM(VALOR) VALOR', `OPERACAO = 'D' AND CONTA`, pegaChave(this))).VALOR;
          const r = parseFloat(c - d).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });

          $('#txtSaldoImportacao').val(r);

          const infoBanco = (await buscaValor('CADBAN', 'NOME_BANCO, ULT_LINHA_EXT, LINHA_EXT', 'BANCO', banco));

          if (infoBanco == undefined) {
            return;
          }

          insereValor('#txtBancoImportacao', banco, infoBanco.NOME_BANCO);
          $('#cbUltimaLinha').prop('checked', infoBanco.ULT_LINHA_EXT == 'S');
          $('#txtLinhaImportacao').val(parseInt(infoBanco.LINHA_EXT));

        } catch (e) {
          msgErro(`Não foi possível buscar os dados da conta: ${e}`);
          console.log(e);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });

  $('#txtBancoImportacao').on('blur', async function () {
    if ($(this).val() != '') {
      $.LoadingOverlay('show');
      try {
        try {

          let banco = await buscaValor('CADCONTA', 'BANCO', 'CONTA', pegaChave('#txtContaImportacao'));

          banco = banco == undefined ? '' : banco.BANCO;

          if (pegaChave(this) != banco) {
            msgErro(`Conta não pertence ao banco informado, favor verificar.`, () => {
              $('#txtBancoImportacao').val('');
              $('#txtBancoImportacao').focus();
            }, () => {
              $('#txtBancoImportacao').val('');
              $('#txtBancoImportacao').focus();
            });
            return;
          }
        } catch (e) {
          msgErro(`Não foi possível buscar os dados do banco: ${e}`);
          console.log(e);
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });

  $('#btnConfirmarImportacao').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const data = $('#tabelaImportacao').DataTable().data().toArray();

      if (data.length == 0) {
        msgErro('Arquivo não carregado, favor verificar.');
        return;
      };

      const dataSel = data.filter(item => item.SEL == 'S');

      if (dataSel == undefined || dataSel.length == 0) {
        msgErro('Nenhum registro selecionado, favor verificar.');
        return;
      };

      let array = [];

      dataSel.map((e, i) => {
        let dt_cont = e.DT_CONT != '' ? e.DT_CONT : '1899-01-01';
        array.push({
          CONTA: e.CONTA,
          DOCTO: e.DOCTO,
          DT_CONT: dt_cont,
          VALOR: e.VALOR,
          OPERACAO: e.OPERACAO,
          OBS: $(`#obsgrid_${i}`).val(),
          CHAVE: e.CHAVE
        });
      });

      let obj = { IMPEXTRATO: array };

      const filtros = retornaFiltrosImportacao();

      const response = await requisicao('POST', '/sisplan/extrato/v1/gravaimportacao?', '', `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&JSON=${encodeURIComponent(JSON.stringify(obj))}`, 600000);
      if (!response) {
        return;
      }

      const dados = await response.text();
      if (response.status != 200) {
        msgAlerta(dados);
        return;
      };

      if (dados != '') {
        msgAlerta(`Os documentos ${dados} já foram importados anteriormente, deseja importá-los com novos números de documento?`, () => { }, () => { sucesso() }, async () => { await geraNovosDocumentos(dados, obj) }, () => { sucesso() });
      } else {
        sucesso();
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function sucesso() {
    toastr.success("Importação efetuada com sucesso!", "Confirmação", {
      toastClass: "success",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      onHidden() {
        $('#modal-importar').modal('hide');
      },
    }).css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
  };

  async function geraNovosDocumentos(data, obj) {
    $.LoadingOverlay('show');
    try {
      try {
        let listaDocto = data.split(',');
        let listaDados = obj.IMPEXTRATO;
        let newArray = [];
        for (let i = 0; i < listaDocto.length; i++) {
          newArray.push(listaDados.filter(e => e.DOCTO == listaDocto[i].trim())[0]);
        };

        let newObj = { IMPEXTRATO: newArray }

        const filtros = retornaFiltrosImportacao();

        const response = await requisicao('POST', '/sisplan/extrato/v1/gravanovodocto?', '', `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&JSON=${encodeURIComponent(JSON.stringify(newObj))}`, 600000);
        if (!response) {
          return;
        }

        const dados = await response.text();
        if (response.status != 200) {
          msgAlerta(dados.mensagem);
          return;
        };

        sucesso();
      } catch (e) {
        console.log(e);
        msgErro(`Não foi possível gravar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#modal-importar').on('hide.bs.modal', function () {
    $('#btnConfirmarImportacao').addClass('d-none');
    $('#txtContaImportacao').val('');
    $('#txtBancoImportacao').val('');
    $('#txtDataImportacao').val('');
    $('#txtSaldoImportacao').val('');
    $('#txtArquivoImportacao').val('');
    $('#mdModalUpload').val('');
    $('#txtOpcaoImportacao').val('');
    $('#txtLinhaImportacao').val('0');
    $('#cbUltimaLinha').prop('checked', false);
    $('#cbDataValida').prop('checked', false);
    $('#txtSaldoFinalImportacao').val('');

    if ($.fn.DataTable.isDataTable('#tabelaImportacao')) {
      $('#tabelaImportacao').DataTable().destroy();
      $('#tabelaImportacao').empty();
    }
  });

  $('#btnCriarAPImportacao').on('click', async function () {
    $('#txtTipoModal').val('PAG');
    await criarPagar();
  });

  $('#btnCriarAntecipacaoImportacao').on('click', async function () {
    $('#txtTipoModal').val('REC');
    await criarPagar();
  });

  async function criarPagar() {
    $.LoadingOverlay('show');
    try {
      try {

        const data = $('#tabelaImportacao').DataTable().data().toArray();

        if (data.length == 0) {
          msgErro('Arquivo não carregado, favor verificar.');
          return;
        };

        const dataSel = data.filter(item => item.SEL == 'S');

        if (dataSel == undefined || dataSel.length == 0) {
          msgErro('Nenhum registro selecionado, favor verificar.');
          return;
        };

        let array = [];

        dataSel.map((e) => {
          let dt_cont = e.DT_CONT != '' ? e.DT_CONT : '1899-01-01';
          array.push({
            CONTA: e.CONTA,
            DOCTO: e.DOCTO,
            DT_CONT: dt_cont,
            VALOR: e.VALOR,
            OPERACAO: e.OPERACAO,
            OBS: e.OBS,
            CHAVE: e.CHAVE
          });
        });

        let obj = { IMPEXTRATO: array };

        const filtros = retornaFiltrosImportacao();

        const response = await requisicao('POST', '/sisplan/extrato/v1/carregapagar?', '', `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&JSON=${encodeURIComponent(JSON.stringify(obj))}`, 600000);
        if (!response) {
          return;
        }

        const dados = await response.json();
        if (response.status != 200) {
          msgAlerta(dados.mensagem);
          return;
        }

        const cols = [
          {
            title: 'Codcre',
            data: 'CODCRE'
          },
          {
            title: 'Nome',
            data: 'NOME'
          },
          {
            title: 'Valor',
            data: 'VALOR'
          },
          {
            title: 'Data',
            data: 'DATA'
          },
          {
            title: 'Classe',
            data: 'CLASSE_GER'
          },
          {
            title: 'Desc. Classe',
            data: 'DESC_CLASSE_GER'
          },
          {
            title: 'Histórico',
            data: 'HISTORICO'
          },
          {
            title: 'Desc. Histórico',
            data: 'DESC_HISTORICO'
          },
          {
            title: 'Situação',
            data: 'SITUACAO'
          },
          {
            title: 'Desc. Situação',
            data: 'DESC_SITUACAO'
          },
          {
            title: 'Obs',
            data: 'OBS'
          },
          {
            title: 'Classe Baixa',
            data: 'CLASSE_BAIXA'
          },
          {
            title: 'Desc. Classe Baixa',
            data: 'DESC_CLASSE_BAIXA'
          },
          {
            title: 'Histórico Baixa',
            data: 'HIST_BAIXA'
          },
          {
            title: 'Desc. Histórico Baixa',
            data: 'DESC_HIST_BAIXA'
          },
          {
            title: 'Num. AP',
            data: 'NUM_AP'
          },
          {
            title: 'Dupli',
            data: 'DUPLI'
          },
          {
            title: 'Lançamento',
            data: 'LANCTO'
          }
        ];

        $("#tabelaPagar").DataTable({
          order: false,
          sort: true,
          paging: false,
          destroy: true,
          lengthChange: false,
          searching: false,
          info: false,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          data: dados,
          columns: cols,
          columnDefs: [
            {
              targets: [2],
              render: function (data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2,
                });
              },
            },
            {
              type: 'date-br',
              targets: [3],
              render(data) {
                if (data) {
                  return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                } else {
                  return '';
                }

              },
            },
          ],
        }).draw(false);

        $('#divControlePagar div div div button').prop('disabled', true);
        $('#divControlePagar div div input').prop('disabled', true)
        $('#divControlePagar div button').prop('disabled', true)

        $('#modal-pagar').modal('show');

        $('#tabelaPagar tbody').unbind('click');
        $('#tabelaPagar tbody').on('click', 'tr', function () {
          if ($('#tabelaPagar').DataTable().data().length > 0) {
            if ($(this).hasClass('selected')) {
              $(this).removeClass('selected');
              limpaCamposPagar();
            } else {
              $('#tabelaPagar').DataTable().$('tr.selected').removeClass('selected');
              $(this).addClass('selected');
              $('#txtIdPagar').val($("#tabelaPagar").DataTable().row(this).index());
              preencheCamposPagar($("#tabelaPagar").DataTable().row($(this)).data());
            }
          }
        });

      } catch (e) {
        msgErro(`Não foi possível buscar os dados: ${e}`);
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function limpaCamposPagar() {
    $('#divControlePagar div div div button').prop('disabled', true);
    $('#divControlePagar div div input').val('')
    $('#divControlePagar div div input').prop('disabled', true)
    $('#divControlePagar div button').prop('disabled', true)
  };

  function preencheCamposPagar(data) {
    $('#divControlePagar div div div button').prop('disabled', false);
    $('#divControlePagar div div input').prop('disabled', false);
    $('#divControlePagar div button').prop('disabled', false);

    insereValor('#txtClassePagar', data.CLASSE_GER, data.DESC_CLASSE_GER);
    insereValor('#txtClasseBaixaPagar', data.CLASSE_BAIXA, data.DESC_CLASSE_BAIXA);
    insereValor('#txtHistoricoPagar', data.HISTORICO, data.DESC_HISTORICO);
    insereValor('#txtHistoricoBaixaPagar', data.HIST_BAIXA, data.DESC_HIST_BAIXA);
    insereValor('#txtSituacaoPagar', data.SITUACAO, data.DESC_SITUACAO);
  };

  $('#btnAtualizarPagar').on('click', function () {
    let data = $("#tabelaPagar").DataTable().row($('#txtIdPagar').val()).data();

    if ($('#txtClassePagar').val() != '') {
      data.CLASSE_GER = pegaChave('#txtClassePagar');
      data.DESC_CLASSE_GER = pegaDescricao('#txtClassePagar');
    };

    if ($('#txtClasseBaixaPagar').val() != '') {
      data.CLASSE_BAIXA = pegaChave('#txtClasseBaixaPagar');
      data.DESC_CLASSE_BAIXA = pegaDescricao('#txtClasseBaixaPagar');
    };

    if ($('#txtHistoricoPagar').val() != '') {
      data.HISTORICO = pegaChave('#txtHistoricoPagar');
      data.DESC_HISTORICO = pegaDescricao('#txtHistoricoPagar');
    };

    if ($('#txtHistoricoBaixaPagar').val() != '') {
      data.HIST_BAIXA = pegaChave('#txtHistoricoBaixaPagar');
      data.DESC_HIST_BAIXA = pegaDescricao('#txtHistoricoBaixaPagar');
    };

    if ($('#txtSituacaoPagar').val() != '') {
      data.SITUACAO = pegaChave('#txtSituacaoPagar');
      data.DESC_SITUACAO = pegaDescricao('#txtSituacaoPagar');
    }

    $("#tabelaPagar").DataTable().row($('#txtIdPagar').val()).data(data).draw(false);
    limpaCamposPagar();
    $('#tabelaPagar').DataTable().$('tr.selected').removeClass('selected');
  });

  $('#btnFecharPagar').on('click', function () {
    msgAlerta('Tem certeza que deseja cancelar o procedimento?', () => { }, () => { }, () => { $('#modal-pagar').modal('hide') });
  });

  $('#modal-pagar').on('hide.bs.modal', function () {
    if ($.fn.DataTable.isDataTable('#tabelaPagar')) {
      $('#tabelaPagar').DataTable().destroy();
      $('#tabelaPagar').empty();
    };
  });

  $('#btnConfirmarPagar').on('click', async function () {

    if ($('#btnAtualizarPagar').prop('disabled') == false) {
      msgErro('Existe uma alteração em andamento, favor verificar e clicar em Atualizar Informações.');
      return;
    };

    $.LoadingOverlay('show');
    try {
      await gravaReceberPagar();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function gravaReceberPagar() {
    try {
      const data = $('#tabelaPagar').DataTable().data().toArray();

      if (data.length == 0) {
        msgErro('Nenhum registro carregado, favor verificar.');
        return;
      };

      let array = [];

      data.map((e) => {
        array.push({
          CODCRE: e.CODCRE,
          NOME: e.NOME,
          VALOR: e.VALOR,
          DATA: e.DATA,
          CLASSE_GER: e.CLASSE_GER,
          DESC_CLASSE_GER: e.DESC_CLASSE_GER,
          HISTORICO: e.HISTORICO,
          DESC_HISTORICO: e.DESC_HISTORICO,
          SITUACAO: e.SITUACAO,
          DESC_SITUACAO: e.DESC_SITUACAO,
          OBS: e.OBS,
          CLASSE_BAIXA: e.CLASSE_BAIXA,
          DESC_CLASSE_BAIXA: e.DESC_CLASSE_BAIXA,
          HIST_BAIXA: e.HIST_BAIXA,
          DESC_HIST_BAIXA: e.DESC_HIST_BAIXA,
          NUM_AP: e.NUM_AP,
          DUPLI: e.DUPLI,
          LANCTO: e.LANCTO
        });
      });

      let obj = { EXTRATOPAGAR: array };

      const filtros = retornaFiltrosImportacao();

      const tipo = $('#txtTipoModal').val();

      const response = await requisicao('POST', '/sisplan/extrato/v1/gravapagar?', '', `FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&JSON=${encodeURIComponent(JSON.stringify(obj))}&TIPO=${tipo}`, 600000);
      if (!response) {
        return;
      }

      const dados = await response.json();
      if (response.status != 200) {
        msgAlerta(dados.mensagem);
        return;
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal-pagar').modal('hide');
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (e) {
      msgErro(`Não foi possível gravar os dados: ${e}`);
      console.log(e);
    }
  };

  $('#txtCriaAntecipacao').on('click', async function () {
    $('#txtTipoModal').val('REC');
    await criarPagar();
  });

  $('#btnImprimir').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      const filtros = await retornaFiltros();
      const url = `/sisplan/impressao/v1/imprimirrelextratocc?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelExtratoCC');
      let arquivo = await GeraRelatorio(`${url + filtros}&`, "GET", 15000, false, 'RelExtratoCC');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  function calculaSaldoFinal() {
    try {
      let opcao = $('#txtOpcaoImportacao').val();
      let d, c, result, inicial;

      switch (opcao) {
        case '0':
          inicial = parseFloat($('#txtSaldoImportacao').val().replaceAll('.', '').replaceAll(',', '.'));
          d = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'D' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);
          c = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'C' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);

          result = parseFloat(c - d).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });

          $('#txtSaldoFinalImportacao').val(result);
          break;
        case '1':
          $('#txtSaldoFinalImportacao').val('0,00');
          break;
        case '2':
          $('#txtSaldoFinalImportacao').val($('#txtSaldoImportacao').val());
          d = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'D' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);
          c = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'C' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);

          result = parseFloat(d - c).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });

          $('#txtSaldoFinalImportacao').val(result);
          break;
        case '3':
          d = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'D' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);
          c = $('#tabelaImportacao').DataTable().data().toArray().map((item) => { return item.OPERACAO == 'C' ? item.VALOR : 0 }).reduce((accumulator, currentValue) => accumulator + currentValue, 0);

          result = parseFloat(d - c).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });

          $('#txtSaldoFinalImportacao').val(result);
          break;
        case '4':
          break;
        default:
          break;
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível calcular o saldo final: ${e}`);
    }
  }

  if (localStorage.getItem('lancarExtrato') == 'true'){
    $('#btnIncluir').trigger('click');

    localStorage.removeItem('lancarExtrato');
  }
});
