$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });

    driver.defineSteps([
      {
        element: '#tutoPedido',
        popover: {
          title: 'Dados do Pedido',
          description: 'Insira um pedido para iniciar a expedição do mesmo.',
          position: 'bottom'
        }
      }, {
        element: '#divProduto',
        popover: {
          title: 'Tabela de Itens',
          description: 'Aqui serão carregados os itens do pedido após digitar o número.',
          position: 'bottom'
        }
      }, {
        element: '#barraBipar',
        popover: {
          title: 'Campo Barra',
          description: 'Campo de bipagem de barra, para realizar a conferência.',
          position: 'bottom'
        }
      }, {
        element: '#btnMais',
        popover: {
          title: 'Botão Estornar',
          description: 'Ao clicar nesse botão, as barras bipadas serão para estornar os itens do grid.',
          position: 'bottom'
        }
      }, {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Ao clicar nesse botão, a expedição será gravada.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const bTransmiteNota = ['1', '2'].includes(await CopiaParametro('FATURAMENTO', 1));
  const bUsaCertificadoA3 = (await CopiaParametro('FATURAMENTO', 2)) == 1;
  const bFaturaParcial = (await CopiaParametro('EXPEDICAO', 0)) == 1;
  const bNaoPermiteParcial = (await CopiaParametro('EXPEDICAO', 0)) == 2;
  const somAtivo = localStorage.getItem('@prodEntrada.somAtivo') ?? 'false';
  const largMinima = $('.content-wrapper').css('min-height');
  const layoutNFE = await CopiaParametro('EXPEDICAO', 3) == 0 ? 'NFE' : 'NFESimplificada';
  const bVolumeManual = (await CopiaParametro('EXPEDICAO', 5)) == 1;
  const bControlaEstoque = (await CopiaParametro('EXPEDICAO', 6)) == 1;
  const bEnviaEmail = await CopiaParametro('FATURAMENTO', 7) == '1';

  let pPercAlemPedido = await CopiaParametro('EXPEDICAO', 9);

  if (pPercAlemPedido == '') {
    pPercAlemPedido = 0;
  } else {
    pPercAlemPedido = parseFloat(pPercAlemPedido);
  }

  let visualizaBarra = Boolean;
  let barrasLidas = [];
  let idInterval;

  validaCampoVolume();
  adicionaPesquisaAutocompleta();
  focaCampoPedido();
  validaSomBipagem();
  addInvervalTelaCheia();

  await buscaFuncionario();
  await validaEdicao();
  await vencimentoCertificado();
  await buscaEspecieEmpresa();

  $('#txtPedido').on('blur', async function () {
    const pedido = $('#txtPedido').val();

    if ((pedido == '') || (pedido.split('')[0] == '[')) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const pesquisaParam = {
        tabela: 'PEDIDO',
        camposSelect: ['PEDIDO.CODCLI', 'ENTIDADE.NOME', 'PEDIDO.DEPOSITO', 'DEPOSITO.DESCRICAO', 'PEDIDO.OPERACAO', 'PEDIDO.NATUREZA'],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PEDIDO.DEPOSITO' }
        ],
        where: [`PEDIDO.NUMERO = '${pedido}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Número de pedido não existe, favor verificar.');
        $('#txtPedido').val('');
        return;
      }

      if ((jsonStr[0].OPERACAO == 0) && (jsonStr[0].NATUREZA == '')) {
        msgAlerta('Pedido não possui operação ou natureza cadastrada, favor verificar.');
        $('#txtPedido').val('');
        return;
      }

      if (await pedidoCancelado(pedido)) {
        msgAlerta('Pedido cancelado ou já faturado, impossível expedir.');
        $('#txtPedido').val('');
        return;
      }

      insereValor('#txtPedido', pedido, jsonStr[0].NOME);
      insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtDeposito', jsonStr[0].DEPOSITO, jsonStr[0].DESCRICAO);

      await buscaPedidoComSemReserva();
      $('#txtBarra').focus();
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      atualizaTotais();
      atualizaVolumes();
      $.LoadingOverlay('hide');
    }
  });

  $('#txtPedidoBusca').on('blur', async function () {
    const pedido = $('#txtPedidoBusca').val();

    if ((pedido == '') || (pedido.split('')[0] == '[')) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const pesquisaParam = {
        tabela: 'PEDIDO',
        camposSelect: ['ENTIDADE.NOME'],
        leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }],
        where: [`PEDIDO.NUMERO = '${pedido}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Número de pedido não existe, favor verificar.');
        $('#txtPedidoBusca').val('');
        return;
      }

      insereValor('#txtPedidoBusca', pedido, jsonStr[0].NOME);

      await buscaNotaPedido();

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtBarra').on('blur', async function () {
    await saidaBarra();
  });

  $('#txtBarraEstorno').on('blur', async function () {
    try {
      const barra = $('#txtBarraEstorno').val();
      if (barra == '') {
        return;
      }
      if (($('#modal-warning').data('bs.modal') || {})._isShown == true) {
        $('#txtBarraEstorno').val('');
        return;
      }
      await confereBarra(false, barra);
    } finally {
      atualizaTotais();
    }
  });

  $('#txtBarra').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#txtBarra').trigger('blur');
      $('#txtBarra').focus();
    }
  });

  $('#txtBarraEstorno').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#txtBarraEstorno').trigger('blur');
      $('#txtBarraEstorno').focus();
    }
  });

  $('#txtQtde').on('keypress', function (event) {
    var regex = new RegExp("^[0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault(); return false;
    }
  });

  $('#txtQtde').on('blur', function () {
    if ($('#txtQtde').val() == '') {
      $('#txtQtde').val('1');
    }
  });

  $('#txtPedido').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#txtPedido').trigger('blur');
    }
  });

  $('#txtPedidoBusca').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#txtPedidoBusca').trigger('blur');
    }
  });

  $('#tabelaItens tbody').on('click', 'tr', async function () {
    $("#tabelaItens tbody tr td")[0].click();
    $('#tabelaItens tbody tr.selected').removeClass('selected');
    $(this).addClass('selected');
  });

  $('#btnMais').on('click', function () {
    $('#barraBipar').addClass('d-none');
    $('#barraEstorno').removeClass('d-none');
    $('#txtBarraEstorno').focus();
  });

  $('#btnMenos').on('click', function () {
    $('#barraEstorno').addClass('d-none');
    $('#barraBipar').removeClass('d-none');
    $('#txtBarra').focus();
  });

  $('#btnDesistir').on('click', function () {
    msgAlerta('Deseja mesmo abandonar essa expedição? Todos os itens conferidos serão perdidos.', abandonaExpedicao)
  });

  $('#btnGravar').on('click', async function () {
    if ($('#txtPedido').val() == '') {
      msgAlerta('Nenhum pedido informado.')
      return;
    };
    await gravaDados();
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/expedicao_mat`;
  });

  $('#btnMaisInfo').on('click', () => {
    $('#modal-infos').modal('show')
  });

  $('#btnNfe').on('click', () => {
    $('#modal-nfe').modal('show')
  });

  $('#modal-nfe').on('hidden.bs.modal', function (_) {
    limpaCamposNota();
  });

  $('#btnImprimir').on('click', async function () {
    const fatura = pegaValor('#txtFatura');
    const serie = pegaValor('#txtSerie');
    const chave = pegaValor('#txtChave');

    if (fatura == '' || serie == '') {
      msgAlerta('Nenhuma nota selecionada, favor verificar.');
      return;
    }

    if (chave == '') {
      msgAlerta('Nota não transmitida, impossível imprimir');
      return;
    }

    await imprimeNotaModal(fatura, serie);
  });

  $('#btnTelaCheia').on('click', function (e) {
    abreTelaCheia();
  });

  $('#btnTelaReduzida').on('click', function (e) {
    fechaTelaCheia();
  });

  $('body').keydown(function (e) {
    const keyCode = e.keyCode || e.which
    if (((window.event.which === 13) || (window.event.which === 9)) && (getCookie('expedicao_tela_cheia') == 'true')) {
      abreTelaCheia();
    }
    if (window.event.which === 113) {

      if (largMinima == $('.content-wrapper').css('min-height')) {
        abreTelaCheia();
        return;
      }
      fechaTelaCheia();
    }
  });

  function addInvervalTelaCheia() {
    const invervalo = setInterval(() => {
      if (largMinima == $('.content-wrapper').css('min-height')) {
        fechaTelaCheia(false);
      } else {
        abreTelaCheia(false);
      }
    }, 200);
  };

  function abreTelaCheia(executaCloseFullScreen = true) {
    try {
      const elem = document.querySelector('body');

      $('body').addClass('sidebar-collapse');
      $('#btnTelaCheia').addClass('d-none');
      $('#btnTelaReduzida').removeClass('d-none');

      if (executaCloseFullScreen) {
        if (elem.requestFullscreen) {
          elem.requestFullscreen();
        } else if (elem.mozRequestFullScreen) {
          elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
          elem.webkitRequestFullscreen();
        } else if (elem.msRequestFullscreen) {
          elem.msRequestFullscreen();
        }

        setCookie('expedicao_tela_cheia', true, 30);
      }

    } finally {
      if ($.fn.DataTable.isDataTable("#tabelaItens")) {
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
      }
    }
  };

  function fechaTelaCheia(executaCloseFullScreen = true) {
    try {
      $('body').removeClass('sidebar-collapse');
      $('#btnTelaCheia').removeClass('d-none');
      $('#btnTelaReduzida').addClass('d-none');

      if (executaCloseFullScreen) {
        if (document.exitFullscreen) {
          document.exitFullscreen();
        }
        else if (document.mozCancelFullScreen) {
          document.mozCancelFullScreen();
        }
        else if (document.webkitExitFullscreen) {
          document.webkitExitFullscreen();
        }
        else if (document.msExitFullscreen) {
          document.msExitFullscreen();
        }

        setCookie('expedicao_tela_cheia', false, 30);
      }

    } finally {
      if ($.fn.DataTable.isDataTable("#tabelaItens")) {
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
      }
    }
  };

  async function abandonaExpedicao() {
    await deletaRegistro('EXPEDICAO', getCookie('usuario'), pegaChave('#txtPedido'));

    if ($(window.location.href.split('/')).get(-1) != 'create') {
      window.location.href = 'create';
    }

    $('#txtCaixa').val('');
    $('#txtPedido').val('');
    $('#txtReserva').val('');
    $('#txtDeposito').val('');
    $('#txtCliente').val('');
    $('#txtTotal').val('0');
    $('#txtConferidas').val('0');
    $('#txtSaldo').val('0');
    $('#txtPedido').prop('disabled', false);
    $('#txtPedido').prop('readonly', false);
    $('#btnPedido').prop('disabled', false);
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().rows().remove().draw();
    };
    $('#btnDesistir').addClass('d-none');
    $('#btnVoltar').removeClass('d-none');
    $('#txtReserva').empty();

    escondeBloqueiaCampos(false);
    clearInterval(idInterval);

    barrasLidas = [];
    idInterval = null;

    $('#timerExp').text('00:00').addClass('d-none');
  };

  function focaCampoPedido() {
    $('#txtPedido').focus();
  };

  function validaCampoVolume() {
    if (bVolumeManual) {
      $('#divCliente').addClass('col-2');
      $('#divCliente').removeClass('col-3');
      $('#divVolumes').removeClass('d-none');
    }
  };

  function validaSomBipagem() {
    $('.somAtivo').on('click', function () {
      $(this).addClass('d-none');
      localStorage.setItem("@prodEntrada.somAtivo", false);
      $('.somInativo').removeClass('d-none');
    });

    $('.somInativo').on('click', function () {
      $(this).addClass('d-none');
      localStorage.setItem("@prodEntrada.somAtivo", true);
      $('.somAtivo').removeClass('d-none');
    });

    if (somAtivo == 'true') {
      $($('.somInativo')[0]).trigger('click');
    }
  };

  function addBarraLida(sBarra, sDados, sQtde) {
    let achouBarra = false;

    barrasLidas.map(item => {
      if (item.BARRALOTE == sBarra) {
        achouBarra = true;
      }
    });

    if (!achouBarra) {
      sDados.QTDE = sQtde;
      barrasLidas.push({ BARRALOTE: sBarra, ...sDados });
    }
  };

  function removeBarraLida(sBarra) {
    let achouBarra = false;

    barrasLidas.map(item => {
      if (item.BARRALOTE == sBarra) {
        achouBarra = true;
      }
    });

    if (achouBarra) {
      barrasLidas = $.grep(barrasLidas, function (valor) {
        return valor.BARRALOTE !== sBarra;
      });
    }
  };

  function validaGravar() {
    const qtdeBipada = $('#tabelaItens').DataTable().column(23, {}).data().sum();

    if (qtdeBipada == 0) {
      return false;
    }
    return true;
  };

  function validaExpedicaoParcial() {
    const qtdeBipada = $('#tabelaItens').DataTable().column(23, {}).data().sum();
    const qtdeTotal = $('#tabelaItens').DataTable().column(6, {}).data().sum();

    if (qtdeBipada != qtdeTotal) {
      return true;
    }
    return false;
  };

  function escondeBloqueiaCampos(bReserva) {
    if (bReserva) {
      $('#divReserva').removeClass('d-none');
      $('#divDeposito').removeClass('col-4');
      $('#divDeposito').addClass('col-2');
      return;
    }
    $('#divReserva').addClass('d-none');
    $('#divDeposito').addClass('col-4');
    $('#divDeposito').removeClass('col-2');
  };

  function bloqueiaCampos() {
    $('#txtPedido').prop('disabled', true);
    $('#txtPedido').prop('readonly', true);
    $('#btnPedido').prop('disabled', true);
    $('#btnDesistir').removeClass('d-none');
    $('#btnVoltar').addClass('d-none');
  };

  function bloqueiaCamposVisualizacao() {
    $('#txtPedido').prop('disabled', true);
    $('#txtPedido').prop('readonly', true);
    $('#btnPedido').prop('disabled', true);
    $('#txtFuncionario').prop('disabled', true);
    $('#txtFuncionario').prop('readonly', true);
    $('#btnFuncionario').prop('disabled', true);
    $('#btnAFuncionario').prop('disabled', true);
    $('#txtFuncionario').prop('disabled', true);
    $('#txtObservacao').prop('readonly', true);
    $('#txtObservacao').prop('disabled', true);
    $('#btnGravar').addClass('d-none');
    $('#btnDesistir').addClass('d-none');
    $('#divQtde').addClass('d-none');
    $('#barraBipar').addClass('d-none');
    $('.escondeEdicao').addClass('d-none');
  };

  function corrigeCamposJson(arrItens) {
    let itensFormatados = [];
    arrItens.map((item) => {
      itensFormatados.push({
        codigo: `<div class="icheck-primary d-inline"><span class="fas fa-times-circle" style="color:#EEAD2D"></span></div>  ` + item.CODIGO,
        descricao: item.DESCRICAO,
        cor: item.COR,
        descCor: item.DESCCOR,
        tam: item.TAM,
        qualidade: item.QUALIDADE,
        qtde: item.QTDE,
        barra: '',
        barra28: '',
        barraCli: '',
        ordem: item.ORDEM,
        qtdeF: item.QTDE_F,
        lote: '',
        local: '',
        reserva: item.RESERVA,
        baixados: item.BAIXADOS,
        bloqueio: item.BLOQUEIO,
        idItemPed: item.IDITEMPED,
        posicao: item.POSICAO,
        idReserva: item.IDRESERVA,
        idPaIten: 0,
        endLocal: '',
        descEndLocal: item.DESC_END_LOCAL,
        QTDE_CONF: item.QTDE_CONF,
        QTDE_EST: item.QTDE_EST
      });
    });
    return itensFormatados;
  };

  function retornaClassePedido3() {
    let arrItens = [];
    let bTudoBipado = true;
    let barrasLidasFinal = [];

    barrasLidas.map((item) => {
      barrasLidasFinal.push(item.BARRALOTE);

      const itPedido = {
        CODIGO: item.codigo.split('</div>  ')[1],
        COR: item.cor,
        QTDE: item.QTDE,
        QTDEF: item.qtdeF,
        PESOL: 0,
        PESO: 0,
        TAM: item.tam,
        ORDEM: item.ordem,
        DEPOSITO: pegaChave('#txtDeposito'),
        QUALIDADE: item.qualidade,
        DATA: `${new Date().toJSON().slice(0, 10)}T00:00:00Z`,
        IDPAITEN: item.idPaIten,
        DESCRICAO: item.descricao,
        DESCCOR: item.descCor,
        IDPEDITEN: item.idItemPed,
        QTDEDIST: 0,
        SEQCAIXA: 0,
        IDRESERVA: item.idReserva,
        BARRA28: item.barra28,
        BARRA: item.barra,
        BARRACLI: item.barraCli,
        FUNCIONARIO: pegaChave('#txtFuncionario'),
        ENDLOCAL: item.endLocal,
        DESCENDLOCAL: item.descEndLocal,
        LOTE: item.BARRALOTE,
        TIPO: 'M'
      }
      if (itPedido.QTDE > 0) {
        arrItens.push(itPedido);
      }
      if (item.qtde > item.QTDE_CONF) {
        bTudoBipado = false;
      }
    });

    return {
      EXPLOJAWEB: true,
      EXPMATERIALWEB: true,
      NUMERO: pegaChave('#txtPedido'),
      CAIXA: $('#txtCaixa').val(),
      RESERVA: $('#txtReserva').val() > 0 ? $('#txtReserva').val() : 0,
      DEPOSITO: pegaChave('#txtDeposito'),
      FUNCIONARIO: pegaChave('#txtFuncionario'),
      BARRASLIDAS: barrasLidasFinal,
      ITENS: arrItens,
      FATURAR: false,
      VOLUMES: pegaValor('#txtVolumes') > 0 ? pegaValor('#txtVolumes') : '1',
      ESPECIE: pegaValor('#txtEspecie') != '' ? pegaValor('#txtEspecie') : 'VOLUME'
    }
  };

  function retornaHoraMinSeg(totalSegundos) {
    function retornaHMSstring(num) {
      return (num < 10 ? '0' : '') + num;
    }

    let horas = Math.floor(totalSegundos / 3600);
    totalSegundos = totalSegundos % 3600;

    let minutos = Math.floor(totalSegundos / 60);
    totalSegundos = totalSegundos % 60;

    let segundos = Math.floor(totalSegundos);

    horas = retornaHMSstring(horas);
    minutos = retornaHMSstring(minutos);
    segundos = retornaHMSstring(segundos);

    return (minutos + ':' + segundos);
  };

  function iniciaTimer() {
    $('#timerExp').removeClass('d-none');
    let segundosCorridos = 0;
    idInterval = setInterval(function () {
      segundosCorridos += 1;
      $('#timerExp').text(retornaHoraMinSeg(segundosCorridos));
    }, 1000);
  };

  function limpaCamposNota(bPedido = false, bNota = false) {
    if (!bPedido) {
      $('#txtPedidoBusca').val('');
    }
    if (!bNota) {
      $('#txtNota').val('');
    }
    $('#txtFatura').val('');
    $('#txtSerie').val('');
    $('#txtChave').val('');
    $('#txtProtocolo').val('');
    $('#txtDtEmissao').val('');
  };

  async function imprimeNotaModal(sFatura, sSerie) {
    let url = layoutNFE == 'NFE' ? '/sisplan/nfe/v1/imprimirnfe?' : '/sisplan/nfe/v1/imprimirnfesimplificada?';
    url += `FATURA=${sFatura}&SERIE=${sSerie}`;
    try {
      $.LoadingOverlay("show");
      try {
        const bImprimeAutomatico = await verificaImprimirAutomatico(layoutNFE);
        var arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, layoutNFE);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(BASE_URI + '/relatorios_api/pdf/' + arquivo, '_blank');
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function buscaNotaPedido() {
    limpaCamposNota(true);

    const pedido = $('#txtPedidoBusca').attr('data-chave');

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'NOTAITEN',
        camposSelect: ['NOTA.FATURA', 'NOTA.SERIE', 'NOTA.DT_EMISSAO', 'NOTA.PROTOCOLO_NFE', 'NOTA.CHAVE_NFE'],
        leftJoin: [{ tabela: 'NOTA', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' }],
        where: [`NOTAITEN.PEDIDO = '${pedido}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Nenhuma nota encontrada, favor verificar.');
        $('#txtPedidoBusca').val('');
        return;
      }

      insereValor('#txtNota', jsonStr[0].FATURA, jsonStr[0].SERIE);
      insereValor('#txtFatura', jsonStr[0].FATURA);
      insereValor('#txtSerie', jsonStr[0].SERIE);
      insereValor('#txtChave', jsonStr[0].CHAVE_NFE);
      insereValor('#txtProtocolo', jsonStr[0].PROTOCOLO_NFE);
      insereValor('#txtDtEmissao', jsonStr[0].DT_EMISSAO);

    } catch {
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaPedidoNota() {
    limpaCamposNota(false, true);

    const nota = $('#txtNota').attr('data-chave');

    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'NOTA',
        camposSelect: ['NOTA.FATURA', 'NOTA.SERIE', 'NOTAITEN.PEDIDO', 'ENTIDADE.NOME', 'NOTA.DT_EMISSAO', 'NOTA.PROTOCOLO_NFE', 'NOTA.CHAVE_NFE'],
        leftJoin: [
          { tabela: 'NOTAITEN', condicao: 'NOTA.FATURA = NOTAITEN.FATURA AND NOTA.SERIE = NOTAITEN.SERIE' },
          { tabela: 'ENTIDADE', condicao: 'NOTA.CODCLI = ENTIDADE.CODCLI' }
        ],
        where: [`NOTA.FATURA = '${nota}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Nenhuma nota encontrada, favor verificar.');
        $('#txtPedidoBusca').val('');
        return;
      }

      insereValor('#txtPedidoBusca', jsonStr[0].PEDIDO, jsonStr[0].NOME);
      insereValor('#txtFatura', jsonStr[0].FATURA);
      insereValor('#txtSerie', jsonStr[0].SERIE);
      insereValor('#txtChave', jsonStr[0].CHAVE_NFE);
      insereValor('#txtProtocolo', jsonStr[0].PROTOCOLO_NFE);
      insereValor('#txtDtEmissao', jsonStr[0].DT_EMISSAO);

    } catch {
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function pedidoCancelado(sPedido) {
    const pesquisaParam = {
      tabela: 'PED_ITEN',
      camposSelect: ['CODIGO'],
      where: [`NUMERO = '${sPedido}' AND QTDE > 0`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return !(jsonStr.length > 0)
  };

  async function validaGravacao() {
    let bTudoBipado = true;

    $('#tabelaItens').DataTable().data().map((item) => {
      if (item.qtde > item.QTDE_CONF) {
        bTudoBipado = false;
      }
    });

    if (bTudoBipado) {
      clearInterval(idInterval);
      await gravaDados();
    };
  };

  async function validaEdicao() {
    try {
      const caixaBase = $(window.location.href.split('/')).get(-1);

      if (caixaBase == 'create') {
        return;
      };

      $('#divCaixa').removeClass('d-none');

      const caixa = atob(caixaBase).split(',');

      if (caixa[1] == 'true') {
        await editaExpedicao(caixa[0]);
      } else {
        await visualizaCaixa(caixa[0]);
      }
    } finally {
      atualizaTotais();
    }
  };

  function validaTotalExpedido() {
    $('#tabelaItens').DataTable().rows().data().map((item, index) => {
      if (item.qtde == item.QTDE_CONF) {
        item.codigo = item.codigo.replace('times-circle', 'check-circle').replace('#EEAD2D', 'green');
        $('#tabelaItens').DataTable().row(index).data(item).draw(false);
      }
    })
  };

  function criaTabelaItens(data, columns) {
    if (visualizaBarra) {
      criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', data, columns, [10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24], [], [], [], {}, 2, '', '', false, [], [6, 11, 23]);
    } else {
      criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', data, columns, [7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 24], [], [], [], {}, 2, '', '', false, [], [6, 11, 23]);
    }
  };

  function atualizaVolumes() {
    let qtdeVol = Math.floor(pegaValor('#txtTotal') > 50);
    if (qtdeVol == 0) {
      qtdeVol = 1;
    }
    if (bVolumeManual) {
      insereValor('#txtVolumes', qtdeVol);
    }
  };

  function atualizaTotais() {
    if (!$.fn.DataTable.isDataTable('#tabelaItens')) {
      return;
    };

    const total = $("#tabelaItens").DataTable().column(6, {}).data().sum();
    const conferidas = $("#tabelaItens").DataTable().column(23, {}).data().sum();
    const saldo = total - conferidas;

    insereValor('#txtTotal', total);
    insereValor('#txtConferidas', conferidas);
    insereValor('#txtSaldo', saldo);
  };

  async function confereBarra(biparEstornar, barra) {
    try {
      let bPassouPrimeiraVez = false;

      async function bipaBarra(arrIndices, bParamExec = false) {
        const indice = arrIndices[0];
        let retorno = 0;

        const dadosItem = $('#tabelaItens').DataTable().row(indice).data();

        if ((((dadosItem.QTDE_CONF + (dadosBarra.QTDE)) <= dadosItem.qtde) || bPassouPrimeiraVez) && biparEstornar) {
          if (bControlaEstoque && ((dadosItem.QTDE_CONF + dadosBarra.QTDE) > dadosItem.QTDE_EST)) {
            retorno = 5;
          } else {
            dadosItem.QTDE_CONF += dadosBarra.QTDE;
            addBarraLida(barra, dadosItem, dadosBarra.QTDE);
            if (dadosItem.QTDE_CONF == dadosItem.qtde) {
              dadosItem.codigo = dadosItem.codigo.replace('times-circle', 'check-circle').replace('#EEAD2D', 'green');
            }
            retorno = 0;
          }
        } else if (biparEstornar && (dadosItem.QTDE_CONF < dadosItem.qtde)) {
          retorno = 1;
        } else if (biparEstornar) {
          retorno = 2;
        } else if (!biparEstornar && ((dadosItem.QTDE_CONF - dadosBarra.QTDE) >= 0)) {
          dadosItem.codigo = dadosItem.codigo.replace('check-circle', 'times-circle').replace('green', '#EEAD2D');
          dadosItem.QTDE_CONF -= dadosBarra.QTDE;
          retorno = 0;
          removeBarraLida(barra);
        } else if (!biparEstornar && ((dadosItem.QTDE_CONF - dadosBarra.QTDE) < 0) && (dadosBarra.QTDE > 1)) {
          retorno = 3;
        } else {
          retorno = 4;
        }

        $('#tabelaItens').DataTable().row(indice).data(dadosItem).draw(false);
        $($('#tabelaItens tbody tr')[indice]).click();
        $('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));

        if ((arrIndices.length > 1) && (retorno != 0)) {
          arrIndices.shift();
          return await bipaBarra(arrIndices);
        } else if (retorno == 1) {
          if (pPercAlemPedido > 0 && !bPassouPrimeiraVez) {
            msgAlerta(
              'Deseja expedir além da quantidade do pedido? (valor será calculado com base no parâmetro de % a mais aceito)',
              async function () {
                let qtde = dadosBarra.QTDE;
                let qtdeComPerc = (dadosItem.qtde * (1 + (pPercAlemPedido / 100))) - dadosItem.QTDE_CONF;
                if (qtde >= qtdeComPerc) {
                  qtde = qtdeComPerc;
                }
                dadosBarra.QTDE = TruncaDecimaisNova(2, qtde);
                bPassouPrimeiraVez = true;
                return await bipaBarra(arrIndices, true);
              },
              async function () {
                dadosBarra.QTDE = dadosItem.qtde - dadosItem.QTDE_CONF;
                bPassouPrimeiraVez = true;
                return await bipaBarra(arrIndices, true);
              },
              undefined,
              undefined,
              true
            );
          } else if (!bPassouPrimeiraVez) {
            dadosBarra.QTDE = dadosItem.qtde - dadosItem.QTDE_CONF;
            bPassouPrimeiraVez = true;
            return await bipaBarra(arrIndices);
          }
        } else if (!bParamExec) {
          return retorno;
        } else {
          await validaGravacao();
          atualizaTotais();
        }
      };

      const dados = $('#tabelaItens').DataTable().rows().data();

      const dadosBarra = await retornaDadosBarra(barra);

      let indices = [];
      dados.map((item, idx) => { if (item.codigo.split('</div>  ')[1] == dadosBarra.CODIGO && item.cor == dadosBarra.COR) { indices.push(idx) } });

      if (indices.length == 0) {
        msgAlerta('Nenhuma barra localizada');
        SomAlerta(BASE_URI, true);
        return;
      }

      let achouBarra = false;

      barrasLidas.map(item => {
        if (item.BARRALOTE == barra) {
          achouBarra = true;
        }
      });

      if (achouBarra && biparEstornar) {
        msgAlerta('Lote já bipado, favor verificar.');
        return;
      }

      const retorno = await bipaBarra(indices);
      switch (retorno) {
        case 0: {
          SomAlerta();
          break;
        }
        case 1: {
          msgAlerta('Impossível bipar quantidade maior do que há de pendente.');
          SomAlerta(BASE_URI, true);
          break;
        }
        case 2: {
          msgAlerta('Quantidade total do item já conferida');
          SomAlerta(BASE_URI, true);
          break;
        }
        case 3: {
          msgAlerta('Impossível estornar quantidade maior do que a conferida.');
          SomAlerta(BASE_URI, true);
          break;
        }
        case 4: {
          msgAlerta('Toda a quantidade já foi estornada.');
          SomAlerta(BASE_URI, true);
          break;
        }
        case 5: {
          msgAlerta('Estoque insuficiente para o item bipado.');
          SomAlerta(BASE_URI, true);
          break;
        }
      }

    } finally {
      $(`#txtBarra${biparEstornar ? '' : 'Estorno'}`).val('');
      $(`#txtBarra${biparEstornar ? '' : 'Estorno'}`).focus();
      $('#txtQtde').val('1');
    }
  };

  async function retornaDadosBarra(sLote) {
    const pesquisaParam = {
      tabela: 'MAT_ITEN',
      camposSelect: ['MAT_ITEN.CODIGO', 'MAT_ITEN.COR', 'MAT_ITEN.QTDE'],
      where: [`MAT_ITEN.LOTE = '${sLote}' AND MAT_ITEN.DEPOSITO = '${pegaChave('#txtDeposito')}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      return '';
    }
    return jsonStr[0];
  };

  async function buscaFuncionario() {
    const codUsuario = getCookie('cod_usuario');
    try {
      const pesquisaParam = {
        tabela: 'ACESSO_USUARIOS',
        camposSelect: ['ACESSO_USUARIOS.CODFUN', 'PESSOAL.NOME', 'ACESSO_USUARIOS.VISUALIZA_BARRA_EXP'],
        leftJoin: [{ tabela: 'PESSOAL', condicao: 'PESSOAL.CODIGO = ACESSO_USUARIOS.CODFUN' }],
        where: [`ACESSO_USUARIOS.CODIGO = '${codUsuario}'`]
      }
      const jsonStr = (await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam)))[0];

      visualizaBarra = jsonStr.VISUALIZA_BARRA_EXP == 'S';

      if (jsonStr.CODFUN == '') {
        return;
      }

      insereValor('#txtFuncionario', jsonStr.CODFUN, jsonStr.NOME);

    } catch (error) {
      console.error(error);
    }
  };

  async function buscaPedidoComSemReserva() {
    const pedido = $('#txtPedido').attr('data-chave');

    escondeBloqueiaCampos(false);
    await buscaPedidoSemReserva(pedido);
  };

  async function editaExpedicao(sCaixa) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: [
          'PEDIDO3.NUMERO', 'PEDIDO3.CODIGO', 'PRODUTO.DESCRICAO', 'PEDIDO3.COR', 'CADCOR.DESCRICAO DESCCOR', 'PEDIDO3.TAM', 'PEDIDO3.QUALIDADE', 'PA_ITEN.LOTE',
          'PED_ITEN.QTDE', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', '1 ORDEM', 'PEDIDO3.QTDE_F', 'PA_ITEN.LOCAL', '0 RESERVA',
          '0 BAIXADOS', `'0' BLOQUEIO`, 'PED_ITEN.ID_ITEM_PED IDITEMPED', '0 POSICAO', '0 IDRESERVA', 'PA_ITEN.ID_PA_ITEN IDPAITEN', 'PRODUTO.LOCAL ENDLOCAL',
          'CAD_LOC_ESTOQ.DESCRICAO DESC_END_LOCAL', 'PEDIDO3.QTDE QTDE_CONF', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI', 'ENTIDADE.NOME', 'DEPOSITO.DESCRICAO DESC_DEPOSITO',
          'PA_ITEN.QUANTIDADE QTDE_EST'
        ],
        leftJoin: [
          { tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = PEDIDO3.CODIGO AND PA_ITEN.COR = PEDIDO3.COR AND PA_ITEN.TAM = PEDIDO3.TAM AND PA_ITEN.DEPOSITO = PEDIDO3.DEPOSITO AND PA_ITEN.TIPO = PEDIDO3.QUALIDADE' },
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO3.NUMERO AND PED_ITEN.CODIGO = PEDIDO3.CODIGO AND PED_ITEN.COR = PEDIDO3.COR AND PED_ITEN.TAM = PEDIDO3.TAM AND PED_ITEN.DEPOSITO = PEDIDO3.DEPOSITO AND PED_ITEN.QUALIDADE = PEDIDO3.QUALIDADE' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = PEDIDO3.COR' },
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PEDIDO3.CODIGO' },
          { tabela: 'CAD_LOC_ESTOQ', condicao: 'CAD_LOC_ESTOQ.CODIGO = PRODUTO.LOCAL' },
          { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PEDIDO3.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PEDIDO.DEPOSITO' }
        ],
        where: [`PEDIDO3.CAIXA = '${sCaixa}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Caixa não encontrada.', null, null, () => { window.location.href = 'create'; });
        return;
      };

      insereValor('#txtCaixa', sCaixa);
      insereValor('#txtPedido', jsonStr[0].NUMERO, jsonStr[0].NOME);
      insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtDeposito', jsonStr[0].DEPOSITO, jsonStr[0].DESC_DEPOSITO);

      let itensFormatados = corrigeCamposJson(jsonStr);

      const keys = Object.keys(itensFormatados[0]);
      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k].toUpperCase(),
          'data': keys[k]
        });
      };

      criaTabelaItens(itensFormatados, dataSetCols);
      validaTotalExpedido();
      bloqueiaCampos();

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
      if ($.fn.DataTable.isDataTable('#tabelaItens')) {
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
      }
    }
  };

  async function visualizaCaixa(sCaixa) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: [
          'PEDIDO3.NUMERO', 'PEDIDO3.CODIGO', 'PRODUTO.DESCRICAO', 'PEDIDO3.COR', 'CADCOR.DESCRICAO DESCCOR', 'PEDIDO3.TAM', 'PEDIDO3.QUALIDADE', 'PA_ITEN.LOTE',
          '(PEDIDO3.QTDE_F [SOMA] PEDIDO3.QTDE) QTDE', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', '1 ORDEM', 'PEDIDO3.QTDE_F', 'PA_ITEN.LOCAL', '0 RESERVA',
          '0 BAIXADOS', `'0' BLOQUEIO`, 'PED_ITEN.ID_ITEM_PED IDITEMPED', '0 POSICAO', '0 IDRESERVA', 'PA_ITEN.ID_PA_ITEN IDPAITEN', 'PRODUTO.LOCAL ENDLOCAL',
          'CAD_LOC_ESTOQ.DESCRICAO DESC_END_LOCAL', '(PEDIDO3.QTDE_F [SOMA] PEDIDO3.QTDE) QTDE_CONF', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI', 'ENTIDADE.NOME', 'DEPOSITO.DESCRICAO DESC_DEPOSITO'
        ],
        leftJoin: [
          { tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = PEDIDO3.CODIGO AND PA_ITEN.COR = PEDIDO3.COR AND PA_ITEN.TAM = PEDIDO3.TAM AND PA_ITEN.DEPOSITO = PEDIDO3.DEPOSITO AND PA_ITEN.TIPO = PEDIDO3.QUALIDADE' },
          { tabela: 'PED_ITEN', condicao: 'PED_ITEN.NUMERO = PEDIDO3.NUMERO AND PED_ITEN.CODIGO = PEDIDO3.CODIGO AND PED_ITEN.COR = PEDIDO3.COR AND PED_ITEN.TAM = PEDIDO3.TAM AND PED_ITEN.DEPOSITO = PEDIDO3.DEPOSITO AND PED_ITEN.QUALIDADE = PEDIDO3.QUALIDADE' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = PEDIDO3.COR' },
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PEDIDO3.CODIGO' },
          { tabela: 'CAD_LOC_ESTOQ', condicao: 'CAD_LOC_ESTOQ.CODIGO = PRODUTO.LOCAL' },
          { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PEDIDO3.NUMERO' },
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO = PEDIDO.DEPOSITO' }
        ],
        where: [`PEDIDO3.CAIXA = '${sCaixa}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Caixa não encontrada.', null, null, () => { window.location.href = 'create'; });
        return;
      };

      insereValor('#txtCaixa', sCaixa);
      insereValor('#txtPedido', jsonStr[0].NUMERO, jsonStr[0].NOME);
      insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtDeposito', jsonStr[0].DEPOSITO, jsonStr[0].DESC_DEPOSITO);

      jsonStr.map((item) => {
        item.QTDE_EST = 0;
      });

      let itensFormatados = corrigeCamposJson(jsonStr);

      const keys = Object.keys(itensFormatados[0]);
      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k].toUpperCase(),
          'data': keys[k]
        });
      };

      criaTabelaItens(itensFormatados, dataSetCols);
      validaTotalExpedido();
      bloqueiaCamposVisualizacao();

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
      if ($.fn.DataTable.isDataTable('#tabelaItens')) {
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
      }
    }
  };

  async function buscaPedidoSemReserva(pedido) {
    try {
      const pesquisaParam = {
        tabela: 'PED_ITEN',
        camposSelect: [
          'DISTINCT PED_ITEN.CODIGO', 'MATERIAL.DESCRICAO', 'PED_ITEN.COR', 'CADCOR.DESCRICAO DESCCOR', 'PED_ITEN.TAM',
          'MAT_ITEN.QUALIDADE', 'PED_ITEN.QTDE QTDE', '1 ORDEM', `COALESCE(PEDIDO3.CAIXA, '') CAIXA`,
          'COALESCE(PEDIDO3.QTDE_F, 0) QTDE_F', '0 RESERVA', '0 BAIXADOS', `'0' BLOQUEIO`, 'PED_ITEN.ID_ITEM_PED IDITEMPED', '0 POSICAO',
          '0 IDRESERVA', 'MATERIAL.LOCAL ENDLOCAL', 'CAD_LOC_ESTOQ.DESCRICAO DESC_END_LOCAL', 'COALESCE(PEDIDO3.QTDE, 0) QTDE_CONF',
          '0 QTDE_EST'
        ],
        leftJoin: [
          { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PED_ITEN.NUMERO' },
          { tabela: 'PEDIDO3', condicao: 'PEDIDO3.NUMERO = PED_ITEN.NUMERO AND PEDIDO3.CODIGO = PED_ITEN.CODIGO AND PEDIDO3.COR = PED_ITEN.COR AND PEDIDO3.TAM = PED_ITEN.TAM AND PEDIDO3.DEPOSITO = PEDIDO.DEPOSITO AND PEDIDO3.QUALIDADE = PED_ITEN.QUALIDADE' },
          { tabela: 'MAT_ITEN', condicao: `MAT_ITEN.CODIGO = PED_ITEN.CODIGO AND MAT_ITEN.COR = PED_ITEN.COR AND MAT_ITEN.DEPOSITO = PEDIDO.DEPOSITO AND MAT_ITEN.QUALIDADE = '1'` },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = PED_ITEN.COR' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' },
          { tabela: 'CAD_LOC_ESTOQ', condicao: 'CAD_LOC_ESTOQ.CODIGO = MATERIAL.LOCAL' }
        ],
        where: [`PED_ITEN.NUMERO = '${pedido}' AND PED_ITEN.QTDE > 0`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Pedido não possui quantidades pendendes para expedir.');
        await abandonaExpedicao();
        return;
      };

      jsonStr.map(item => {
        if (item.CAIXA != '') {
          $('#txtCaixa').val(item.CAIXA);
        }
      });

      let itensFormatados = corrigeCamposJson(jsonStr);

      const keys = Object.keys(itensFormatados[0]);
      let dataSetCols = [];

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k].toUpperCase(),
          'data': keys[k]
        });
      };

      criaTabelaItens(itensFormatados, dataSetCols);
      validaTotalExpedido();
      bloqueiaCampos();

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
      if ($.fn.DataTable.isDataTable('#tabelaItens')) {
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
      }
    }
  };

  async function gravaDados() {

    if (!validaGravar()) {
      msgAlerta('Nenhum item bipado, favor verificar.');
      return;
    }

    if (bNaoPermiteParcial && validaExpedicaoParcial()) {
      msgAlerta('Necessário bipar todos os itens para realizar a expedição, favor verificar.');
      return;
    }

    const pedido3 = retornaClassePedido3();

    const registroLiberado = await verificarRegistro('EXPEDICAO', pedido3.NUMERO);
    if (!registroLiberado) {
      return;
    }
    await liberarRegistro('EXPEDICAO', pedido3.NUMERO);

    setTimeout(async () => {
      // if (!pedido3.FATURAR) {
      //   msgAlerta('Deseja faturar essa expedição?', async function () { pedido3.FATURAR = true; await realizaFaturamentoExpedicao(pedido3) }, async function () { await realizaFaturamentoExpedicao(pedido3) });
      // } else {
      await realizaFaturamentoExpedicao(pedido3);
      // }
    }, 200);
  };

  async function realizaFaturamentoExpedicao(pedido3) {
    $.LoadingOverlay('show');
    try {
      const response = await requisicao('POST', '/expedicao?', '', JSON.stringify(pedido3), 120000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem.mensagem, null, null, () => { window.location.href = 'create' }, () => { window.location.href = 'create' });
        return;
      }

      let relogarTela = true;

      if (bTransmiteNota && jsonStr.resultado.faturar) {
        if (await transmiteNota(jsonStr.resultado.fatura, jsonStr.resultado.serie)) {
          if (bEnviaEmail) {
            await enviaEmail(jsonStr.resultado.fatura, jsonStr.resultado.serie);
          }
          await imprimeSigep(jsonStr.resultado.fatura, jsonStr.resultado.serie);
          await imprimeNota(jsonStr.resultado.fatura, jsonStr.resultado.serie);
        } else {
          relogarTela = false;
        }
      }

      if (relogarTela) {
        await criaMensagemSucesso('Expedição realizada com sucesso.', () => { window.location.href = 'create' });
      }

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function enviaEmail(sFatura, sSerie) {

    try {
      try {
        $.LoadingOverlay("show");
        const response = await requisicao('POST', '/sisplan/nfe/v1/enviaremail?', `FATURA=${sFatura}&SERIE=${sSerie}&CODUSUARIO=${getCookie('cod_usuario')}`, null, 300000);
        if (!response) {
          return;
        }
        const jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem)
          return;
        }
        await msgSucesso(jsonStr.mensagem);
      } catch (error) {
        console.error(error);
        msgErro('Erro ao enviar e-mail');
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function transmiteNota(sFatura, sSerie) {
    const responseTransmissao = await requisicao('POST', '/Sisplan/NFE/v1/GerarNFE?', `SERIE=${sSerie}&FATURA=${sFatura}&FINALIDADE=${0}&JUSTIFICATIVA=${''}&TIPO_TRANSMISSAO=${0}&CERTA3=${bUsaCertificadoA3 ? '1' : '0'}`, null, 120000);

    if (responseTransmissao.status != 200) {
      jsonStr = await responseTransmissao.json();
      msgAlerta(jsonStr.mensagem, null, null, () => { window.location.href = 'create' }, () => { window.location.href = 'create' });
      return false;
    }

    if (bUsaCertificadoA3 && (responseTransmissao.status == 200)) {
      const xml = await responseTransmissao.text();
      const loteNfe = await retornaLoteNfe();
      const empClasse = await retornaInformacaoEmpresa();

      // TRANSMITE NA API LOCAL
      const responseLocal = await requisicao_ecf('POST', '/nfe/gerar?', `CLASSEEMPRESA=${JSON.stringify(empClasse)}&LOTE=${loteNfe}`, xml, 120000);
      if (responseLocal.status != 200) {
        const mensagemErro = await responseLocal.text();
        msgAlerta(mensagemErro, null, null, () => { window.location.href = 'create' }, () => { window.location.href = 'create' });
        return false;
      }
      const retornoNota = await responseLocal.json();

      // FINALIZA TRANSMISSÃO NA API WEB
      const reponseApiWeb = await requisicao(
        'POST',
        '/sisplan/nfe/v1/finalizanfe?',
        `FATURA=${sFatura}&SERIE=${sSerie}&TIPO_TRANSMISSAO=${0}`,
        JSON.stringify(retornoNota),
        60000
      );
      if (!response) {
        return false;
      }
      if (reponseApiWeb.status != 200) {
        const mensagemRetorno = await reponseApiWeb.json();
        msgAlerta(mensagemRetorno.mensagem, null, null, () => { window.location.href = 'create' }, () => { window.location.href = 'create' });
        return false;
      }
    };
    return true;
  };

  async function imprimeNota(sFatura, sSerie) {
    let url = layoutNFE == 'NFE' ? '/sisplan/nfe/v1/imprimirnfe?' : '/sisplan/nfe/v1/imprimirnfesimplificada?';
    url += `FATURA=${sFatura}&SERIE=${sSerie}`;
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico(layoutNFE);
      const arquivo = await GeraRelatorio(url + '&', 'PUT', 15000, false, layoutNFE);
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(BASE_URI + '/relatorios_api/pdf/' + arquivo, '_blank');
        }
        await limparRelatorios();
        window.location.href = 'create';
      }
    } catch (error) {
      console.error(error);
      window.location.href = 'create';
    }
  };

  async function imprimeSigep(sFatura, sSerie) {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimiretiqsigep?`;
        const filtros = `FATURA=${sFatura}&SERIE=${sSerie}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('EtiqSigep');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'EtiqSigep');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.log(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function retornaInformacaoEmpresa() {
    try {
      let url = `/sisplan/funcoes/v1/pesquisa?`;
      let response = await requisicao('GET', url, `JSON={ 
        "tabela":"empresa", 
        "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert"], 
        "where": ["emp_id = ${getCookie('emp_id')}"] 
      }`, null);
      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      return jsonStr.RESULT[0][0];
    } catch (error) {
      console.error(error);
      msgErro('Erro ao retornar dados da empresa, Erro: ');
    }
  };

  async function retornaLoteNfe() {
    try {
      const url = `/sisplan/nfe/v1/finalizanfe?`;
      const response = await requisicao('GET', url, '', null);
      if (!response) {
        return;
      }
      const lote = await response.text();
      if (response.status != 200) {
        return;
      }
      return lote;
    } catch (error) {
      console.error(error);
    }
  };

  async function buscaEspecieEmpresa() {
    try {
      const pesquisaParam = {
        tabela: 'EMPRESA',
        camposSelect: ['EMP_ESPECIE'],
        where: [`EMP_ID = ${getCookie('emp_id')}`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        return;
      };

      insereValor('#txtEspecie', jsonStr[0].EMP_ESPECIE);
    } catch (error) {
      console.error(error);
    }
  };

  function adicionaPesquisaAutocompleta() {
    $('#btnPedido').pesquisa_serverside(
      ['#txtPedido', '#txtDeposito', '#txtCliente'],
      ['PEDIDO.NUMERO', 'PEDIDO.DEPOSITO', 'PEDIDO.CODCLI'],
      ['ENTIDADE.NOME', 'DEPOSITO.DESCRICAO', 'ENTIDADE.NOME', 'PEDIDO.PED_CLI'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO", "PEDIDO.PED_CLI"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"}
        ],
        "where": null
       }`,
      'Pesquisa Pedido',
      buscaPedidoComSemReserva
    );

    $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null }`);
    $('#btnFuncionario').pesquisa('#txtFuncionario', "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO", "NOME"], "where": null}`, "Pesquisa Funcionário", "PESSOAL");
    $('#btnAFuncionario').on('click', function () { $('#txtFuncionario').val(''); });

    $('#btnPedidoBusca').pesquisa_serverside(
      ['#txtPedidoBusca'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'],
      `{"tabela":"PEDIDO", 
        "camposSelect":[ "PEDIDO.NUMERO", "PEDIDO.DEPOSITO", "PEDIDO.CODCLI", "ENTIDADE.NOME", "DEPOSITO.DESCRICAO"], 
        "leftjoin": [ 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"},
          {"tabela": "DEPOSITO", "condicao": "DEPOSITO.CODIGO = PEDIDO.DEPOSITO"}
        ],
        "where": null
       }`,
      'Pesquisa Pedido',
      buscaNotaPedido
    );
    $('#btnAPedidoBusca').on('click', function () { limpaCamposNota(); });

    $('#btnNota').pesquisa_serverside(
      ['#txtNota', '#txtaaaaaa'],
      ['FATURA', 'DT_EMISSAO'],
      ['SERIE', 'DT_EMISSAO'],
      `{"tabela":"nota", "camposSelect":[ "FATURA", "SERIE", "DT_EMISSAO" ], "where": null}`,
      'Pesquisa Nota',
      buscaPedidoNota
    );
    $('#txtNota').autocompleta(3, `JSON={ "tabela":"NOTA", "camposSelect":["FATURA CHAVE, SERIE DESCRICAO"], "where": [] }`, undefined, undefined, undefined, buscaPedidoNota);
    $('#btnANota').on('click', function () { limpaCamposNota(); });

    $('#txtVolumes').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 0,
    });
  };

  async function saidaBarra() {
    try {
      const barra = $('#txtBarra').val();
      if (barra == '') {
        return;
      }
      if ($('#txtPedido').val() == '') {
        $('#txtBarra').val('');
        return;
      }
      if (($('#modal-warning').data('bs.modal') || {})._isShown == true) {
        $('#txtBarra').val('');
        return;
      }
      await confereBarra(true, barra);
      await validaGravacao();
      if (!idInterval) {
        iniciaTimer();
      };
    } finally {
      atualizaTotais();
    }
  }
});