$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta das posições.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma posição.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description: "Clique aqui para imprimir os dados.",
          position: "top",
        },
      },
      {
        element: "#tabelaDados",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das posições.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("EXTRATO_CARTAO");

  $('#tabStone').trigger('click')
  $('#tabRede').trigger('click')
  function parseExcel(file) {
    var reader = new FileReader();

    reader.onload = function (e) {
      var data = e.target.result;
      var workbook = XLSX.read(data, {
        type: 'binary'
      });

      workbook.SheetNames.forEach(function (sheetName) {
        var XL_row_object = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[sheetName]);
        var json_object = JSON.stringify(XL_row_object);
        console.log(json_object);
      })
    };

    reader.onerror = function (ex) {
      console.log(ex);
    };

    reader.readAsBinaryString(file);
  };

  async function leArquivoXLS(file) {
    var file = document.querySelector('#mdModalUpload').files[0];
    var name = file.name.toUpperCase();
    var reader = new FileReader();

    reader.onload = function (e) {
      var data = e.target.result;
      var cfb = XLS.CFB.read(data, { type: 'binary' });
      var wb = XLS.parse_xlscfb(cfb);
      wb.SheetNames.forEach(function (sheetName) {
        var sCSV = XLS.utils.make_csv(wb.Sheets[sheetName]);
        // var oJS = XLS.utils.sheet_to_row_object_array(wb.Sheets[sheetName]);

        const objRetorno = transformStringEmArray(sCSV);
        $('#conteudoFormatado').val(JSON.stringify(objRetorno))
      });
    };
    reader.readAsBinaryString(file);
  }

  function transformStringEmArray(string) {
    let newObj = {}
    const linhas = string.trim().split('\n');

    let cabecalhoIndex = 0;
    for (let i = 0; i < linhas.length; i++) {
      if (linhas[i].startsWith("Status,Tipo de Lançamento")) {
        cabecalhoIndex = i;
        break;
      }
    }
    const dadosSemCabecalho = linhas.slice(cabecalhoIndex);

    const cabecalho = dadosSemCabecalho[0].split(',');
    const dados = [];

    for (let i = 1; i < dadosSemCabecalho.length; i++) {
      let noEmpty = dadosSemCabecalho[i].replace(/,,/g, ',-,');
      if (noEmpty.endsWith(',')) {
        noEmpty = noEmpty.slice(0, -1) + ',-';
      }
      const colunas = noEmpty.match(/(".*?"|[^",]+)/g);

      const objeto = {};

      for (let j = 0; j < cabecalho.length; j++) {
        objeto[cabecalho[j]] = colunas[j];
      }

      dados.push(objeto);

      newObj = dados.map((item) => ({
        status: item['Status'],
        tipoLancamento: item['Tipo de Lançamento'],
        descricao: item['Descrição'],
        banco: item['Banco'],
        agencia: item['Agência'],
        conta: item['Conta'],
        gravame: item['Gravame'],
        instituicaoCnpj: item['CNPJ da instituição origem da negociação'],
        instituicaoNome: item['Nome da instituição origem da negociação'],
        estabelecimento: item['Estabelecimento'],
        dataPagamento: item['Data de pagamento'],
        dataLancamento: item['Data do lançamento'],
        dataAutorizacao: item['Data da autorização da venda'],
        bandeira: item['Bandeira'],
        formaPagamento: item['Forma de Pagamento'],
        parcela: item['Número da parcela'],
        quantidadeParcelas: item['Quantidade de parcelas'],
        numeroCartão: item['Número do cartão'],
        codigoTransação: item['Código da transação'],
        tID: item['TID'],
        codigoAutorização: item['Código de autorização'],
        nsu: item['NSU'],
        valorBruto: removeCaracteres(item['Valor bruto']),
        valorLiquido: removeCaracteres(item['Valor líquido']),
        valorPendente: removeCaracteres(item['Valor pendente']),
        recebaRapido: removeCaracteres(item['Receba Rápido']),
        tipoCaptura: removeCaracteres(item['Tipo de captura']),
        taxaAntecipacao: removeCaracteres(item['Taxa de antecipação']),
        valorEntrada: removeCaracteres(item['Valor da entrada']),
        taxas: removeCaracteres(item['Taxas (%)']),
        codigoVenda: item['Código da venda'],
        numeroMaquina: item['Número da máquina'],
        periodoConsiderado: item['Período considerado'],
        numeroOperacao: item['Número da operação'],
        fatura: item['Número da nota fiscal'],
        ID: item['ID'],
        valorDescontado: item['Valor descontado'],
        valorTotal: item['Valor total'],
        canalVenda: item['Canal de venda'],
        resumoOperacao: item['Resumo da operação'],
        tarifa: item['Tarifa'],
        taxaEmbarque: item['Taxa de embarque'],
        numeroPedido: item['Número do pedido'],
      }));
    }

    return newObj;
  }

  async function leArquivoXLSX(arquivo, belluno = false) {
    try {
      let rows = await readXlsxFile(arquivo);
      const objeto = rows.slice(2, -1).map((dados) => ({
        dataVenda: dados[0],
        tipo: dados[1],
        nsu: belluno ? dados[2].slice(0, -3) : dados[2],
        parcela: belluno ? dados[2].slice(-2) : '01',
        cliente: dados[3],
        totalParcelas: dados[4],
        taxaCaptura: dados[5],
        bandeira: dados[6],
        dataCredito: dados[7],
        valorBruto: parseDouble(dados[8]),
        captura: dados[9],
        antecipacao: dados[10],
        estornado: dados[11],
        prazo: dados[12],
        valorLiquido: parseDouble(dados[13]),
      }));
      return objeto

    } catch (err) {
      console.log(err)
    }
  }

  function somarDias(dataBase, diasASomar) {
    const dataResultante = new Date(dataBase);
    dataResultante.setDate(dataResultante.getDate() + diasASomar);
    return dataResultante;
  }


  async function leArquivoXLSXRede(arquivo) {
    const dataBase = new Date(1899, 11, 30)
    try {
      let rows = await readXlsxFile(arquivo);
      const objeto = rows.slice(2, -1).map((dados) => ({
        dataRecebimento: formataData(somarDias(dataBase, dados[0])) + 'T00:00:00.000Z',
        dataOriginalVenda: formataData(somarDias(dataBase, dados[1])) + 'T00:00:00.000Z',
        dataOriginalVencimento: formataData(somarDias(dataBase, dados[2])) + 'T00:00:00.000Z',
        valorBruto: dados[3],
        valorDuplicata: dados[3],
        valorTaxa: dados[5],
        valorMDRDescontado: dados[6],
        valorLiquido: dados[7],
        negociada: dados[8],
        percentual: dados[9],
        nsu: dados[10],
        TID: dados[11],
        numeroPedido: dados[12],
        numeroAutorizacao: dados[13],
        resumoVendasNumeroLote: dados[14],
        nomeEstabelecimento: dados[15],
        estabelecimento: dados[16],
        numeroCartao: dados[17],
        indicadorTransacaoTokenizada: dados[18],
        codigoIATA: dados[19],
        modalidade: dados[20],
        bandeira: dados[21],
        numeroParcelas: dados[22],
        parcela: dados[23],
        banco: dados[24],
        agencia: dados[25],
        contaCorrente: dados[26],
        cancelamentoContestacao: dados[27],
        dataCancelamento: dados[28],
        status: dados[29],
      }));
      return objeto

    } catch (err) {
      console.log(err)
    }
  }

  async function leArquivoStone(arquivo) {
    try {
      let rows = await readXlsxFile(arquivo);
      if (rows.length < 2) {
        throw new Error('O arquivo não contém dados suficientes.');
      }
      //Recebe a primeira posição do array pois é o cabeçalho
      const cabecalho = rows[0];
      //Recebe o restante das informações
      const dadosSemCabecalho = rows.slice(1);
      //Monta o novo nome do cabeçalho com base no que veio no arquivo, verificar que podem ser unificados os model no backend futuramente
      const novoNome = {
        'STONE ID': 'nsu',
        'BANDEIRA': 'bandeira',
        'VALOR BRUTO': 'valor',
        'VALOR BRUTO': 'valorPago',
        // 'STONE ID': 'nossoNumero',
        'DESCONTO DE MDR': 'valorTarifa',
        'DESCONTO DE ANTECIPAÇÃO': 'taxaAntecipacao',
        'DATA DO ÚLTIMO STATUS': 'dataPagamento',
        'Nº DA PARCELA': 'parcela',
        'VALOR LÍQUIDO': 'valorLiquido',
        'DATA DE VENCIMENTO': 'dataVencimento',
        'ÚLTIMO STATUS': 'ultimoStatus',
        'CATEGORIA': 'categoria',
        'CHAVE EXTERNA': 'chaveExterna',
        'DOCUMENTO': 'documento',
        'HORA DA VENDA': 'horaVenda',
        'NOME FANTASIA': 'nomeFantasia',
        'N° CARTÃO': 'numeroCartao',
        'N° DA PARCELA': 'numeroParcela',
        'QTD DE PARCELAS': 'quantidadeParcelas',
        'STONECODE': 'stoneCode',
        'TIPO': 'tipo',
      };

      const objeto = dadosSemCabecalho.map((dados, i) => {
        const objetoLinha = {};
        //Aqui ele pega o cabeçalho e substitui pelo novo ao longo do loop, depois insere o dado respectivo dentro do objetoLinha (nsu: 123456)
        cabecalho.forEach((coluna, j) => {
          const nomePropriedade = novoNome[coluna] || coluna;
          if (nomePropriedade == 'horaVenda' || nomePropriedade == 'dataPagamento') {
            objetoLinha[nomePropriedade] = formataDateTimeTZ(dados[j])
          } else if (nomePropriedade == 'dataVencimento') {
            // objetoLinha[nomePropriedade] = formataDateBarraHifen(dados[j])
            objetoLinha[nomePropriedade] = dados[j].split('/').reverse().join('-');
          } else {
            objetoLinha[nomePropriedade] = dados[j]
          }
        });
        return objetoLinha;
      });

      return objeto;

    } catch (err) {
      console.log(err)
    }
  }

  async function leArquivoCSV(arquivo) {
    Papa.parse(document.querySelector('#mdModalUpload').files[0], {
      download: true,
      header: true,
      skipEmptyLines: true,
      complete: function (answer) {
        $('#conteudoFormatado').val(JSON.stringify(answer.data))
      }
    });
  }

  $(async function () {
    var modalUploadArquivo = $("#mdModalUpload");
    var BotaoArquivo = $("#btnArquivo");
    BotaoArquivo.click(function () {
      modalUploadArquivo.click();
    });

    modalUploadArquivo.change(async function () {
      let arquivo = document.querySelector('#mdModalUpload').files[0];
      let name = arquivo.name.toUpperCase();
      $('#txtArquivo').val(name)
      let readerArchive = new FileReader();

      readerArchive.onload = async function (e) {
        let fileContent = e.target.result;
        $('#conteudoFormatado').text(fileContent);
      };
      if (name.indexOf('PAGARME') !== -1) {
        if (name.indexOf('.XLSX') !== -1 || name.indexOf('.XLS') !== -1) {
          $('#tabGenerico').html(name)
          // tabAtivaDesativa('#tabGenerico');
        }
      }
      else if (name.indexOf('MAGALU') !== -1) {
        if (name.indexOf('.CSV') !== -1) {
          // tabAtivaDesativa('#tabGenericoCSV');
        } else {
          // tabAtivaDesativa('#tabGenerico');
        }
      }
      else if (name.indexOf('YAPAY') !== -1) {
        // tabAtivaDesativa('#tabGenerico');
      }
      else if (name.indexOf('PIX') !== -1) {
        // tabAtivaDesativa('#tabGenerico');
      }
      else if (name.indexOf('BELLUNO') !== -1) {
        $('#tabGenerico').html(name)
        let belluno = await leArquivoXLSX(arquivo, true)
        $('#conteudoFormatado').val(JSON.stringify(belluno))
        // tabAtivaDesativa('#tabGenerico');
      }
      else if (name.indexOf('JUNO') !== -1) {
        // tabAtivaDesativa('#tabJunoPay');
      }
      else if (name.indexOf('STONE') !== -1) {
        $('#txtNomeArquivoStone').val(name)
        let stone = await leArquivoStone(arquivo)
        $('#conteudoFormatado').val(JSON.stringify(stone))
        // tabAtivaDesativa('#tabStone');
      }
      else if (name.indexOf('CIELO') !== -1 && (name.indexOf('.XLXS') !== -1 || name.indexOf('.XLS') !== -1)) {
        $('#txtNomeArquivoCielo').val(name)
        let cielo = await leArquivoXLS(arquivo)
        $('#conteudoFormatado').val(JSON.stringify(cielo))
        // tabAtivaDesativa('#tabCielo');
      }
      else if (name.indexOf('REDE') !== -1 || name.indexOf('.XLSX') !== -1 || (name.indexOf('CMP') !== -1 || name.indexOf('REDECARD') !== -1) || name.indexOf('CMP') !== -1) {
        let rede = await leArquivoXLSXRede(arquivo)
        $('#conteudoFormatado').val(JSON.stringify(rede))
        $('#txtNomeArquivoRede').val(name)
        // tabAtivaDesativa('#tabGenerico');
      }
      else if (name.indexOf('CIELO') !== -1 || name.indexOf('.TXT') !== -1) {
        $('#txtNomeArquivoCielo').val(name)
        readerArchive.readAsText(arquivo)
        // tabAtivaDesativa('#tabCielo');
      }
      else if (name.indexOf('GETNET') !== -1) {
        // tabAtivaDesativa('#tabGenerico');
      }
      else if (name.indexOf('SAFRA') !== -1) {
        $('#txtNomeArquivoSafra').val(name)
        readerArchive.readAsText(arquivo)
        // tabAtivaDesativa('#tabSafra');
      } else if (name.indexOf('PAGSEG') !== -1) {
        // tabAtivaDesativa('#tabPagSeguro');
      }
    });
  });
});
