$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "txtRazao") {
                    $("#documentoCollapse").collapse("show");
                } else if (Element.node.id == "txtCNPJ") {
                    $("#enderecoCollapse").collapse("show");
                } else if (Element.node.id == "txtCepCobranca") {
                    $("#fiscalCollapse").collapse("show");
                } else if (Element.node.id == "fiscalCollapse") {
                    $("#cerfificadoCollapse").collapse("show");
                }
            },
        });
        driver.defineSteps([
            {
                element: "#geralCollapse",
                popover: {
                    title: "Dados Gerais",
                    description: "Aqui estão os campos gerais do cadastro.",
                    position: "top",
                },
            },
            {
                element: "#txtRazao",
                popover: {
                    title: "Campos Obrigatórios",
                    description:
                        "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#documentoCollapse",
                popover: {
                    title: "Documento",
                    description:
                        "Aqui estão os campos de documento do cadastro.",
                    position: "top",
                },
            },
            {
                element: "#txtCNPJ",
                popover: {
                    title: "Campos Obrigatórios",
                    description:
                        "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#enderecoCollapse",
                popover: {
                    title: "Endereço",
                    description:
                        "Aqui estão os campos de endereço do cadastro.",
                    position: "top",
                },
            },
            {
                element: "#txtCepCobranca",
                popover: {
                    title: "CEP",
                    description:
                        "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#fiscalCollapse",
                popover: {
                    title: "Fiscal",
                    description:
                        "Aqui estão os campos fiscais do cadastro.",
                    position: "top",
                },
            },
            {
                element: "#cerfificadoCollapse",
                popover: {
                    title: "Certificado",
                    description:
                        "Aqui é selecionado o certificado digital.",
                    position: "top",
                },
            },
            {
                element: "#btnGravar",
                popover: {
                    title: "Botão Gravar",
                    description: "Clique aqui para gravar o cadastro.",
                    position: "left",
                },
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description: "Clique aqui para voltar à aba acesso.",
                    position: "left",
                },
            },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let empresa = parametros[parametros.length - 1];

    const sisplanSs = await retornaSisplanSaas();

    $("#btnVoltar").on("click", async function () {
        window.location.href = `${BASE_URI}/empresa`;
    });

    if ((empresa == 'create') && (getCookie('cod_usuario') == '0000')) {
        $('#txtEmpPat').attr('readonly', false);
        $('#txtCNPJ').attr('readonly', false);
        $('#txtIE').attr('readonly', false);
        const options = {
            onKeyPress(cpf, ev, el, op) {
                $("#txtCNPJ").mask("00.000.000/0000-00", op);
            },
        };
        $("#txtCNPJ").mask("00.000.000/0000-00", options);
    }

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#txtCNPJ").change(async function () {
        try {
            if (empresa == 'create') {
                $.LoadingOverlay("show");
                try {

                    let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                    if (validaCNPJ != false) {
                        $("#txtCNPJ").val(validaCNPJ);
                    }

                    const pesquisaParam = {
                        tabela: "EMPRESA",
                        camposSelect: [
                            "EMP_CNPJ",
                        ],
                        where: [`EMP_CNPJ = '${validaCNPJ}'`]
                    };

                    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

                    if (jsonStr.length > 0) {
                        msgAlerta('CNPJ informado já existe para outra empresa, verifique.');
                        $(this).val('');
                        return;
                    }
                } catch (error) {
                    console.log(error);
                }

                // if (!valida_cpf_cnpj($("#txtCNPJ").val())) {
                //     $("#txtCNPJ").rules("add", "valida_cpf_cnpj");
                //     $("#txtCNPJ").focus();
                // }
            }
        } finally {
            $.LoadingOverlay("hide");
        }

    });

    jQuery.validator.addMethod("valida_cpf_cnpj", function (value) {
        return valida_cpf_cnpj(value);
    });


    $("#msform").validate({
        debug: false,
        ignore: "",
        rules: {
            txtEmpPat: {
                required: true,
            },
            txtRazao: {
                required: true,
            },
            txtCNPJ: {
                required: true,
                valida_cpf_cnpj: false,
            },
            txtCepCobranca: {
                required: true
            }
        },
        messages: {
            txtEmpPat: {
                required: 'Informe um EMP_PAT válido'
            },
            txtRazao: {
                required: "Informe uma razão social",
            },
            txtCNPJ: {
                required: "Informe um CNPJ/CPF válido.",
                valida_cpf_cnpj: "Informe um CNPJ/CPF válido.",
            },
            txtCepCobranca: {
                required: "Informe um CEP válido"
            }
        },
        errorElement: "span",
        errorPlacement(error, element) {
            error.addClass("invalid-feedback");
            element.closest(".form-group").append(error);
        },
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        invalidHandler(e, validator) {
            if (validator.errorList.length) {
                console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
                if (validator.errorList[0].element.id == "txtCepCobranca") {
                    if (!$("#enderecoCollapse").hasClass("show")) {
                        $("#enderecoCollapse").collapse("show");
                    }
                }


                let id = $(
                    $(`#${$(validator.errorList[0].element).prop("id")}`)
                        .closest(".card-body")
                        .closest(".collapse")
                ).prop("id");
                if ((!$(`#${id}`).hasClass('show')) && id != "multiCollapseExample1") {
                    $(`a[href='#${id}']`).trigger("click");
                }
            }
        }
    });

    $('#txtDeposito').pesquisa_variosServerside(1, '{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#btnDeposito').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa Depósito');
    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').empty().trigger('change');
    });

    $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');
    $('#btnMoeda').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'Pesquisa Moeda');
    $('#btnLimpaMoeda').on('click', function () {
        $('#txtMoeda').empty().trigger('change');
    });

    $('#logoEmp').on('change', function (e) {
        const leitorDeArquivos = new FileReader();
        const previaDaImagem = document.querySelector('.imagem');
        const inputArquivo = document.querySelector('.upload');

        let imagemEnviada = inputArquivo.files[0];
        leitorDeArquivos.readAsDataURL(imagemEnviada);
        leitorDeArquivos.addEventListener('loadend', function (load) {
            previaDaImagem.src = load.target.result;
        });
    });

    $('#txtRegimeEspecial').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtPercPis').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtPercCofins').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtPercPisEntrada').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtPercCofinsEntrada').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtTelefone').mask('(00) 0000-00009');

    $("#txtCepCobranca").change(async function () {
        try {
            let retorno = await BuscaECadastraCep($("#txtCepCobranca"));
            $("#txtCidadeCobranca").val(retorno[0].toUpperCase());
            $("#txtUFCobranca").val(retorno[1].toUpperCase());
            $("#txtRuaCobranca").val(retorno[2].toUpperCase());
            $("#txtBairroCobranca").val(retorno[3].toUpperCase());
        } catch (error) {
            msgErro("CEP Inválido, verifique.");
            $(this).val('');
        }
    });

    if (empresa != "" && empresa != "create") {
        carregaDados(empresa);
    }

    async function carregaDados(empresa) {
        try {
            $.LoadingOverlay("show");
            $('#txtCNPJ').prop('disabled', 'disabled');
            $('#txtIE').prop('disabled', 'disabled');
            jsonPesquisa = {
                "tabela": "EMPRESA",
                "camposSelect": ["EMP_PAT", "EMP_NOME", "EMP_FANTASIA", "EMP_TELEFONE", "EMP_EMAIL", "EMP_EAN_INI", "EMP_EAN_FIM", "EMP_CNPJ", "EMP_INSCRICAO",
                    "EMP_INSCR_MUNICIPAL", "EMP_CST_NFSE", "EMP_CNAE", "EMP_CEP", "EMP_CIDADE", "EMP_ESTADO", "EMP_BAIRRO", "EMP_ENDERECO",
                    "EMP_NUMERO", "EMP_TIPONF", "EMP_SERIENF", "EMP_SERIENFCE", "EMP_SERIENFS", "EMP_SERIEMDFE","EMP_CRT", "EMP_IMP_ESP", "EMP_MES_ESP", "EMP_MOD_BC", `REPLACE(EMP_CERT,'"','') EMP_CERT`, "EMP_DTBLOCOX",
                    "EMP_DEPOSITO", "NR_TEIACARD", "EMP_MOEDA", "EMP_PIS", "EMP_COD_PIS", "EMP_COFINS", "EMP_COD_COFINS", "EMP_PIS_ENTR", "EMP_COFINS_ENTR",
                    "EMP_CSRT_CNPJ", "EMP_CSRT_NOME", "EMP_CSRT_EMAIL", "EMP_CSRT_FONE", "EMP_CSRT_ID", "EMP_CSRT", "EMP_DEMO"],
                "where": [`EMP_ID = '${empresa}'`]
            };

            try {
                let response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON=${JSON.stringify(jsonPesquisa)}`,
                    null
                );
                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtEmpPat').val(jsonStr.RESULT[0][0].EMP_PAT);
                $("#txtRazao").val(jsonStr.RESULT[0][0].EMP_NOME);
                $("#txtFantasia").val(jsonStr.RESULT[0][0].EMP_FANTASIA);
                $("#txtTelefone").val(jsonStr.RESULT[0][0].EMP_TELEFONE);
                $("#txtEmail").val(jsonStr.RESULT[0][0].EMP_EMAIL);
                $("#txtEan13Ini").val(jsonStr.RESULT[0][0].EMP_EAN_INI);
                $("#txtEan13Fim").val(jsonStr.RESULT[0][0].EMP_EAN_FIM);
                $("#txtEmpPatDemo").val(jsonStr.RESULT[0][0].EMP_DEMO);

                $("#txtCNPJ").val(jsonStr.RESULT[0][0].EMP_CNPJ);
                $("#txtIE").val(jsonStr.RESULT[0][0].EMP_INSCRICAO);
                $("#txtEmissor").val(jsonStr.RESULT[0][0].EMP_INSCR_MUNICIPAL);
                $("#txtCSTNatOP").val(jsonStr.RESULT[0][0].EMP_CST_NFSE);
                $("#txtCNAE").val(jsonStr.RESULT[0][0].EMP_CNAE);

                $("#txtCepCobranca").val(jsonStr.RESULT[0][0].EMP_CEP);
                $("#txtCidadeCobranca").val(jsonStr.RESULT[0][0].EMP_CIDADE);
                $("#txtUFCobranca").val(jsonStr.RESULT[0][0].EMP_ESTADO);
                $("#txtBairroCobranca").val(jsonStr.RESULT[0][0].EMP_BAIRRO);
                $("#txtRuaCobranca").val(jsonStr.RESULT[0][0].EMP_ENDERECO);
                $("#txtNumeroCobranca").val(jsonStr.RESULT[0][0].EMP_NUMERO);

                $("#txtTipoNF").val(jsonStr.RESULT[0][0].EMP_TIPONF);
                $("#txtSerieNF").val(jsonStr.RESULT[0][0].EMP_SERIENF);
                $("#txtSerieNFCe").val(jsonStr.RESULT[0][0].EMP_SERIENFCE);
                $("#txtSerieNFSe").val(jsonStr.RESULT[0][0].EMP_SERIENFS);
                $("#txtSerieMDFe").val(jsonStr.RESULT[0][0].EMP_SERIEMDFE);
                $("#select_crt").val(jsonStr.RESULT[0][0].EMP_CRT).change();
                $("#txtRegimeEspecial").val(jsonStr.RESULT[0][0].EMP_IMP_ESP);
                $("#txtNumeroTeiaCard").val(jsonStr.RESULT[0][0].NR_TEIACARD);
                $("#txtPercPis").val(jsonStr.RESULT[0][0].EMP_PIS);
                $("#txtCstPis").val(jsonStr.RESULT[0][0].EMP_COD_PIS);
                $("#txtPercCofins").val(jsonStr.RESULT[0][0].EMP_COFINS);
                $("#txtCstCofins").val(jsonStr.RESULT[0][0].EMP_COD_COFINS);
                $("#txtPercPisEntrada").val(jsonStr.RESULT[0][0].EMP_PIS_ENTR);
                $("#txtPercCofinsEntrada").val(jsonStr.RESULT[0][0].EMP_COFINS_ENTR);

                $('#txtCnpjCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT_CNPJ);
                $('#txtContatoCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT_NOME);
                $('#txtEmailCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT_EMAIL);
                $('#txtTelefoneCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT_FONE);
                $('#txtIdCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT_ID);
                $('#txtCsrt').val(jsonStr.RESULT[0][0].EMP_CSRT);

                $("#txtMes").val(jsonStr.RESULT[0][0].EMP_MES_ESP);
                $("#select_bcicms").val(jsonStr.RESULT[0][0].EMP_MOD_BC).change();
                $("#txtDtBlocoX").val(jsonStr.RESULT[0][0].EMP_DTBLOCOX);
                $("#txtNumeroTeiaCard").val(jsonStr.RESULT[0][0].NR_TEIACARD);

                if (jsonStr.RESULT[0][0].EMP_DEPOSITO) {
                    const responseDeposito = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "DEPOSITO", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${jsonStr.RESULT[0][0].EMP_DEPOSITO})"]}`)

                    if (!responseDeposito) {
                        return;
                    }

                    const jsonDeposito = await responseDeposito.json();
                    if (responseDeposito.status != 200) {
                        msgAlerta(jsonDeposito.RESULT[0].mensagem);
                        return;
                    }

                    await insereValorPesquisaVarios('txtDeposito', 'CODIGO', 'DESCRICAO', jsonDeposito.RESULT[0]);
                }

                if (jsonStr.RESULT[0][0].EMP_MOEDA) {
                    const responseMoeda = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "MOEDA", "camposSelect": ["CODMOE", "DESCRICAO"], "where": ["CODMOE IN (${jsonStr.RESULT[0][0].EMP_MOEDA})"]}`)

                    if (!responseMoeda) {
                        return;
                    }

                    const jsonMoeda = await responseMoeda.json();
                    if (responseMoeda.status != 200) {
                        msgAlerta(jsonMoeda.RESULT[0].mensagem);
                        return;
                    }

                    await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', jsonMoeda.RESULT[0]);
                }

                let modbc = jsonStr.RESULT[0][0].EMP_MOD_BC;
                let certificadoAtual = jsonStr.RESULT[0][0].EMP_CERT;

                try {
                    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2) == '1';

                    let certificados;

                    if (usaCertificadoA3) {
                        const responseLocal = await requisicao_ecf('GET', '/nfe/consultacertificado?', '', null);
                        if (!responseLocal) {
                            $.LoadingOverlay("hide");
                            return;
                        }
                        certificados = await responseLocal.json();
                    } else {
                        const response = await requisicao('GET', '/sisplan/empresa/v1/retornacert?', '', null);
                        if (!response) {
                            $.LoadingOverlay("hide");
                            return;
                        }
                        jsonStr = await response.json();

                        if (jsonStr.json != '') {
                            certificados = jQuery.parseJSON(jsonStr.json);
                        }
                    };

                    let i = 1;
                    certificados.forEach(element => {
                        if (sisplanSs) {
                            $("#select_bandeira2").append(new Option(element, i));
                        } else {
                            $("#select_bandeira").append(new Option(element, i));
                        };
                        i += 1;
                    });
                } catch (error) {
                    console.error(error);
                };

                try {
                    response = await requisicao('GET', '/sisplan/empresa/v1/retornalogo?', `EMPID=${empresa}`, '');
                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    }
                    jsonStr = await response.json();

                    $('#logoEmpresa').attr('src', `data:image/png;base64,${jsonStr.mensagem}`);

                } catch (error) {
                    console.error(error);
                }

                if (sisplanSs) {
                    $('#select_bandeira2 option').each(function () {
                        if ($(this).text() == certificadoAtual) {
                            $(this).attr('selected', true).change();
                        }
                    });
                } else {
                    $('#select_bandeira option').each(function () {
                        if ($(this).text() == certificadoAtual) {
                            $(this).attr('selected', true).change();
                        }
                    });

                };

                $('#select_bcicms option').each(function () {
                    if ($(this).val() == modbc) {
                        $(this).attr('selected', true).change();
                    }
                });

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da empresa: ${error}`);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $(".radio-group .radio").click(function () {
        $(this).parent().find(".radio").removeClass("selected");
        $(this).addClass("selected");
    });

    $(".submit").click(function () {
        return false;
    });

    $('#txtEmpPat').on('change', async function () {
        const valor = $(this).val();

        if (valor.indexOf('_') == -1) {
            msgAlerta('Necessário seguir o padrão de EMP_PAT do Sisplan, ex: _002');
            $(this).val('');
        }

        const pesquisaParam = {
            tabela: "EMPRESA",
            camposSelect: [
                "EMP_PAT",
            ],
            where: [`EMP_PAT = '${valor}'`]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length > 0) {
            msgAlerta('EMP_PAT informado já existe para outra empresa, verifique.');
            $(this).val('');
        }
    });

    $("#btnGravar").click(async function () {
        try {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();
            let certs;

            if (erros == 0) {
                $.LoadingOverlay("show");

                if (sisplanSs) {
                    certs = $('#select_bandeira2 :selected').text() == "Selecione um certificado" ? '' : $('#select_bandeira2 :selected').text();
                } else {
                    certs = $('#select_bandeira :selected').text() == "Selecione um certificado" ? '' : $('#select_bandeira :selected').text();
                };

                let empresaClasse = {
                    EMP_ID: empresa,
                    EMP_PAT: $('#txtEmpPat').val(),
                    CNPJ: $("#txtCNPJ").val(),
                    NOME: $("#txtRazao").val().toUpperCase(),
                    FANTASIA: $("#txtFantasia").val().toUpperCase(),
                    TELEFONE: $("#txtTelefone").val(),
                    EMAIL: $("#txtEmail").val(),
                    EAN_INI: $("#txtEan13Ini").val(),
                    EAN_FIM: $("#txtEan13Fim").val(),
                    INSCRICAO: $("#txtIE").val(),
                    INSCR_MUNICIPAL: $("#txtEmissor").val(),
                    CST_NFSE: $("#txtCSTNatOP").val(),
                    CNAE: $("#txtCNAE").val(),
                    CEP: $("#txtCepCobranca").val(),
                    CIDADE: $("#txtCidadeCobranca").val(),
                    ESTADO: $("#txtUFCobranca").val(),
                    BAIRRO: $("#txtBairroCobranca").val(),
                    ENDERECO: $("#txtRuaCobranca").val(),
                    NUMERO: $("#txtNumeroCobranca").val(),
                    TIPONF: $("#txtTipoNF").val(),
                    SERIENF: $("#txtSerieNF").val(),
                    SERIENFCE: $("#txtSerieNFCe").val(),
                    SERIENFS: $("#txtSerieNFSe").val(),
                    SERIEMDFE: $("#txtSerieMDFe").val(),
                    CRT: $("#select_crt").val(),
                    IMP_ESP: $("#txtRegimeEspecial").val(),
                    MES_ESP: $("#txtMes").val(),
                    MOD_BC: $("#select_bcicms").val(),
                    CERT: certs,
                    VALIDADE_CERT: '',
                    EMP_DTBLOCOX: $('#txtDtBlocoX').val(),
                    EMP_DEPOSITO: await formataListas($('#txtDeposito').val().toString()),
                    NR_TEIACARD: $("#txtNumeroTeiaCard").val(),
                    EMP_MOEDA: await formataListas($("#txtMoeda").val().toString()),
                    PERCENTUALPIS: $('#txtPercPis').val(),
                    CSTPIS: $('#txtCstPis').val(),
                    PERCENTUALCOFINS: $('#txtPercCofins').val(),
                    CSTCOFINS: $('#txtCstCofins').val(),
                    PISENTRADA: $('#txtPercPisEntrada').val(),
                    COFINSENTRADA: $('#txtPercCofinsEntrada').val(),
                    EMP_CSRT_CNPJ: $('#txtCnpjCsrt').val() == '' ? '04071299000126' : $('#txtCnpjCsrt').val(),
                    EMP_CSRT_NOME: $('#txtContatoCsrt').val() == '' ? 'Osmar Schwartz' : $('#txtContatoCsrt').val(),
                    EMP_CSRT_EMAIL: $('#txtEmailCsrt').val() == '' ? 'suporte@sisplansistemas.com.br' : $('#txtEmailCsrt').val(),
                    EMP_CSRT_FONE: $('#txtTelefoneCsrt').val() == '' ? '04733806100' : $('#txtTelefoneCsrt').val(),
                    EMP_CSRT_ID: $('#txtIdCsrt').val(),
                    EMP_CSRT: $('#txtCsrt').val(),
                    EMP_DEMO: ($('#txtEmpPatDemo').val() != '' && $('#txtEmpPatDemo').val().substring(0,1) != '_' ? '_' + $('#txtEmpPatDemo').val() : $('#txtEmpPatDemo').val())
                };

                if (empresaClasse.CERT != '') {
                    let empresa;
                    if (sisplanSs) {
                        empresa = $('#select_bandeira2 :selected').text().split(', OU=')[0].replace('CN=', '').split(':')[0];
                    } else {
                        empresa = $('#select_bandeira :selected').text().split(', OU=')[0].replace('CN=', '').split(':')[0];
                    }
                    try {
                        let response = await requisicao('GET', '/sisplan/funcoes/v1/listacertificado?', '', '');
                        if (!response) {
                            $.LoadingOverlay("hide");
                            return;
                        }
                        let jsonStr = await response.json();
                        let { certificados } = jsonStr;
                        certificados.forEach(element => {
                            if ((element.razaoSocial == empresa) && (empresaClasse.VALIDADE_CERT < element.vencimento.slice(0, 10))) {
                                empresaClasse.VALIDADE_CERT = element.vencimento.slice(0, 10);
                                empresaClasse.SERIE_CERT = element.nrSerie;
                            }
                        });
                    } catch (error) {
                        console.error(error);
                    }
                }

                if ($('input[type=file]')[0].files.length > 0) {
                    empresaClasse.LOGO = $('.imagem')[0].src.replace('data:image/bmp;base64,', '');
                } else {
                    empresaClasse.LOGO = '';
                }

                let response = await requisicao(
                    "POST",
                    "/sisplan/empresa/v1/empresa?", '',
                    `JSON=${JSON.stringify(empresaClasse)}`,
                    30000
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }

                $.LoadingOverlay("hide");
                toastr
                    .success("Cadastro efetuado com sucesso!", "Confirmação", {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/empresa`;
                        },
                    })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
            }
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados da empresa: ${error}`);
        }
    });

    $("#txtNumeroTeiaCard").on("input", function () {
        if (!this.value.match(/^\d*$/)) {
            this.value = this.value.slice(0, -1);
        }
    });

    $('#btnLimpaCertificadoSaas').click(function () {
        $('#txtCertificadoSaas').val('');
    });

    $('#btnCertificadoSaas').click(function () {
        $('#fileCertificadoSaas').click();
    });

    $('#fileCertificadoSaas').change(function () {
        $('#txtCertificadoSaas').val($(this).val().split('\\').pop());
    });

    $('#btnSenhaCertificadoSaas').on('click', function () {
        if ($('#iconBtnSenhaCertificadoSaas').hasClass('fa-eye-slash')) {
            $('#iconBtnSenhaCertificadoSaas').removeClass('fa-eye-slash');
            $('#iconBtnSenhaCertificadoSaas').addClass('fa-eye');
            $('#txtSenhaCertificadoSaas').attr('type', 'password');
        } else {
            $('#iconBtnSenhaCertificadoSaas').removeClass('fa-eye');
            $('#iconBtnSenhaCertificadoSaas').addClass('fa-eye-slash');
            $('#txtSenhaCertificadoSaas').attr('type', 'text');
        };
    });

    $('#btnEnviaCertificadoSaas').on('click', async function () {
        if ($('#txtCertificadoSaas').val() == '') {
            msgErro('Campo vazio, favor carregar um certificado! Tente novamente.');
            return;
        };

        if ($('#txtSenhaCertificadoSaas').val() == '') {
            msgErro('Campo senha vazio, favor informar a senha do certificado! Tente novamemte.');
            return;
        };
        const file = $('#fileCertificadoSaas')[0].files[0];
        const reader = new FileReader();

        reader.readAsDataURL(file);

        reader.addEventListener('loadend', async function (load) {
            const base64string = load.target.result.split('base64,')[1];
            const gravouCert = await gravaCertificado(base64string);

            if (gravouCert.retorno) {
                msgAlerta('Certificado gravado e importado com sucesso! Clique em confirmar para recarregar a página para buscarmos o certificado importado.', () => {
                    window.location.href = window.location.href;
                });        
            } else {
                msgErro(gravouCert.msg);
                return;
            };
        });
    });

    async function gravaCertificado(base64) {
        $.LoadingOverlay('show');
        try {
            const senhaCertificado = $('#txtSenhaCertificadoSaas').val();
            const cnpj = $('#txtCNPJ').val().replaceAll('.', '').replaceAll('-', '').replaceAll('/', '');
            const _url = '/sisplan/empresa/v1/gravacertificadosaas?'
            const response = await requisicao('POST', _url, '', `SENHA_CERTIFICADO=${senhaCertificado}&CNPJ=${cnpj}&CERTIFICADO=${base64}`, 60000);
            let jsonStr;
            let object
            if (!response) {
                object = {
                    retorno: false,
                    msg: 'Certificado não foi importado, favor verifique!'
                };
                return object
            };

            if (response.status != 200) {
                jsonStr = await response.json();
                object = {
                    retorno: false,
                    msg: jsonStr.mensagem
                };
                return object
            };

            try {
                jsonStr = await response.json();
                object = {
                    retorno: true,
                    msg: jsonStr.msg
                };
                return object
            } catch (e) {
                object = {
                    retorno: true,
                    msg: 'ok'
                };
                return object
            };
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function retornaSisplanSaas() {
        const sisplanSaas = Boolean(await verificaSisplanSaas());

        if (sisplanSaas) {
            $('#tabcertificado1').addClass('d-none');
            $('#cerfificadoAba').addClass('d-none');
            $('#tabcertificado2').removeClass('d-none');
            $('#cerfificadoAba2').removeClass('d-none');
        } else {
            $('#tabcertificado1').removeClass('d-none');
            $('#cerfificadoAba').removeClass('d-none');
            $('#cerfificadoAba2').addClass('d-none')
            $('#tabcertificado2').addClass('d-none');
        };

        return sisplanSaas
    };
});