$(document).ready(async function () {
  

  const queryString = window.location.href;
  const parametros = queryString.split("/");
  const base64 = parametros[parametros.length - 1];
  const descriptografado = atob(base64);
  const [tipo, codigo, cor, periodo] = descriptografado.split('###');


  const separaCodigo = (codigo) => codigo.split('-')[0].trim();
  async function buscaOrdensAgrupadas(numero, aEmitir = false) {
    const url = aEmitir ? `/sisplan/disponibilidadetecidos/v1/buscaordensaemitiragrupadas?` : `/sisplan/disponibilidadetecidos/v1/buscaordensemitidasagrupadas?`;
    const response = await requisicao("GET", url, `&NUMERO=${separaCodigo(numero)}`, '', 1800000);
    if (!response) {
      return;
    }

    const data = await response.json();
    const dadosTratados = data.map((item => [item.CODIGO, item.ROTEIRO, item.ORIGEM_CASADO, item.AGRUPAMENTO]));
    $('#tabela-ordens-agrupamento').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados,
      columnDefs: [
        {
          targets: [1],
          render: (data) => `<button data-roteiro="${data}" class="btn btn-secondary btn-sm btn-roteiro">${data}</button>`
        }
      ]
    });

    $('.btn-roteiro').off();
    $('.btn-roteiro').on('click', async function () {
      const roteiro = $(this).attr('data-roteiro');
      const url = `/sisplan/disponibilidadetecidos/v1/buscaroteiro?`;
      const response = await requisicao("GET", url, `&ROTEIRO=${separaCodigo(roteiro)}`, '', 1800000);

      if (!response) {
        return;
      }

      $('#modal-roteiro-roteiro').html(roteiro);
      const data = await response.json();
      const dadosTratados = data.map((item => [item.CODIGO, item.DESCRICAO]));
      $('#tabela-roteiro').DataTable({
        bPaginate: false,
        destroy: true,
        colReorder: false,
        reoder: false,
        order: false,
        search: false,
        filter: false,
        info: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: dadosTratados
      });

      $('#modal-roteiro-operacoes').modal('show');
    });
  }
  const formataDataTabela = (data) => {
    if (!data) {
      return '';
    }
    const [dataParte, horaParte] = data.split(' ');
    const [ano, mes, dia] = dataParte.split('-');
    const dataFormatada = `${dia}/${mes}/${ano} ${horaParte != '00:00:00' ? horaParte : ''}`;
    return dataFormatada;
  };

  const url = tipo == 'aemitir' ? `/sisplan/disponibilidadetecidos/v1/buscaordensaemitir?` 
                                : `/sisplan/disponibilidadetecidos/v1/buscaordensemitidas?`;
  const response = await requisicao("GET", url, `&CODIGO=${separaCodigo(codigo)}&COR=${separaCodigo(cor)}&PERIODO=${periodo}`, '', 1800000);

  if (!response) {
    return;
  }

  const data = await response.json();
  const dadosTratados = data.map((item => [item.NUMERO, item.ROTEIRO, item.CODIGO, item.COR, formataDataTabela(item.PREVISAO).trim(), item.ROLOS_PROG, item.ROLOS, item.AGRUPAMENTO, item.AGRUPAMENTO_CASADO, item.RGB]));
  $('#tabela-ordens-emitidas').DataTable({
    bPaginate: false,
    destroy: true,
    colReorder: false,
    reoder: false,
    order: false,
    search: false,
    filter: false,
    info: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data: dadosTratados,
    columnDefs: [
      {
        targets: [9],
        visible: false
      },
      {
        targets: [3],
        // eslint-disable-next-line arrow-body-style
        render: (data, type, row) => {
          const cor = row[9];
          const partes = [];

          // Itera sobre a string original em incrementos de 3 caracteres
          for (let i = 0; i < cor.length; i += 3) {
            // Extrai uma parte de 3 caracteres
            const parte = cor.substring(i, i + 3);
            // Adiciona a parte ao array
            partes.push(parte);
          }


          const corRGB = `rgb(${partes[0]}, ${partes[1]}, ${partes[2]})`;

          return `<div style="border-bottom: 8px solid ${corRGB};">${data}</div>`;
        }
      },
      {
        targets: [1],
        render: (data) => `<button data-roteiro="${data}" class="btn btn-secondary btn-sm btn-roteiro">${data}</button>`
      },
      {
        targets: [0],
        render: (data, type, row) => `<div title="Abrir detalhamento da Ordem de Produção" data-ordem="${data}" class="btn-detalhamento-ob clicavel">${data}</div>`
      }
    ]
  });

  $('.btn-detalhamento-ob').off();
  $('.btn-detalhamento-ob').on('click', async function () {
    try {
      const ordem = $(this).attr('data-ordem');
      const url = `/sisplan/disponibilidadetecidos/v1/buscadetalhamentoob?`;
      const response = await requisicao("GET", url, `&ORDEM=${separaCodigo(ordem)}`, '', 1800000);

      if (!response) {
        return;
      }
      const data = await response.json();

      $('#modal-detalhes-numero').html(ordem);
      $('#modal-detalhes-ordem').modal('show');
      $('#txtDetalhePeriodo').val(data[0].SEMANA);
      $('#txtDetalheAgrupamento').val(data[0].PARTIDA_TINT);
      $('#txtDetalheMaquina').val(data[0].MAQUINA);
      $('#txtDetalheObs').val(data[0].OBS);
      $('#txtDetalheObs2').val(data[0].OBS2);
      $('#txtDetalheEstagioAtual').val(data[0].FASE);
    } catch (error) {
      console.log(error);
    }
  });


  $('.btn-roteiro').off();
  $('.btn-roteiro').on('click', async function () {
    const roteiro = $(this).attr('data-roteiro');
    const url = `/sisplan/disponibilidadetecidos/v1/buscaroteiro?`;
    const response = await requisicao("GET", url, `&ROTEIRO=${separaCodigo(roteiro)}`, '', 1800000);

    if (!response) {
      return;
    }

    $('#modal-roteiro-roteiro').html(roteiro);
    const data = await response.json();
    const dadosTratados = data.map((item => [item.CODIGO, item.DESCRICAO]));
    $('#tabela-roteiro').DataTable({
      bPaginate: false,
      destroy: true,
      colReorder: false,
      reoder: false,
      order: false,
      search: false,
      filter: false,
      info: false,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosTratados
    });

    $('#modal-roteiro-operacoes').modal('show');
  });


  const lista = $('#tabela-ordens-emitidas').DataTable().data().toArray();
  const listaAgrupada = lista.reduce((acumulador, atual) => {
    const data = atual[4];
    if (!acumulador[data]) {
      acumulador[data] = 0;
    }
    acumulador[data] += atual[6];
    return acumulador;
  }, {});
  const listaAdaptada = Object.entries(listaAgrupada).map(([data, valor]) => [data, valor]);


  $('#tabela-ordens-data').DataTable({
    bPaginate: false,
    destroy: true,
    colReorder: false,
    reoder: false,
    order: false,
    search: false,
    filter: false,
    info: false,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    autoWidth: true,
    data: listaAdaptada,
  });

  $('#title').html(tipo =="aemitir" ? 'Ordens a emitir' : 'Ordens Emitidas');
  // $('#modal-ordens-emitidas').modal('show');
  $('#tabela-ordens-emitidas tbody').unbind('click');
  $('#tabela-ordens-emitidas tbody').on('click', 'tr', async function () {
    if ($('#tabela-ordens-emitidas').DataTable().data().length > 0) {
      const data = $('#tabela-ordens-emitidas').DataTable().row($(this)).data();
      if (data[8] == 'SIM') {
        await buscaOrdensAgrupadas(data[7], true);
      } else {
        if ($.fn.DataTable.isDataTable('#tabela-ordens-agrupamento')) {
          $('#tabela-ordens-agrupamento').DataTable().clear().draw(false);
        }
      }
      $('#tabela-ordens-emitidas').DataTable().$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
    }
  });

  if ($('#tabela-ordens-emitidas').DataTable().data().toArray().length > 0) {
    $('#tabela-ordens-emitidas tbody tr:eq(0)').trigger('click');
  }

});