$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnNovaCompra',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaSituacao',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma Cor Compra.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaCorCompra',
                popover: {
                    title: 'Tabela Cor Compra',
                    description: 'Aqui estão os dados cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CORCOMPRA");

    componenteFiltro('produto', true, false);
    componenteFiltro('material', true, false);
    componenteFiltro('fornecedor', true, false);
    componenteFiltro('cor', true, false);
    componenteFiltro('codfornecedor', false, false);

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await fazConsulta();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#dtAttDe').val('1200-01-01');
        $('#dtAttAte').val('2500-12-31');
        $('#rdPadrao').prop('checked', false)
        $('#rdTodosTipo').prop('checked', true)
        $('#rdTodosFornecedor').prop('checked', true)
        $('#rdTodosProdutos').prop('checked', true)
        $('#rdTodosMateriais').prop('checked', true)
        $('#txtSituacaoConsulta').val('');
        $('#txtProduto').empty().trigger('change');
        $('#txtMaterial').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtFornecedor').empty().trigger('change');
        $('#txtCodfornecedor').val('');
    });

    $('#btnNovaCompra').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "corcompra/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#tabelaCorCompra').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCorCompra').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('SITUACAODUPLICATA', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `corcompra/${data.CODIGO}`; // Lembrar, vai ter que passar minimo 2 parametros
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCorCompra').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCorCompra').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('SITUACAODUPLICATA', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `situacaoduplicata/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCorCompra').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCorCompra").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    //Funções

    $("#btnImprimir").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            const filtros =  await buscaParametros();
            const url = `/sisplan/impressao/v1/acessocorcompra?${filtros}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('AcessoCorCompra');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'AcessoCorCompra');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/cadastros/v1/situacaoduplicata?", `CODIGO=${(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function fazConsulta() {
        $.LoadingOverlay('show');
        try {
            const jsonStr = await retornaDados();

            if (jsonStr.length == 0) {
                msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
                $('#tabelaCorCompra').DataTable().clear().draw();
                return;
            }

            const cols = [
                {
                    data: 'COR',
                    title: 'Cor'
                },
                {
                    data: 'DESC_COR',
                    title: 'Desc. Cor'
                },
                {
                    data: 'CODCLI',
                    title: 'Fornecedor'
                },
                {
                    data: 'NOME',
                    title: 'Nome Fornecedor'
                },
                {
                    data: 'COD_ENTRADA',
                    title: 'Cod. Fornecedor'
                },
                {
                    data: 'COR1',
                    title: 'Cor Fornecedor'
                },
                {
                    data: 'DIAS_PREPARACAO',
                    title: 'Dias Preparação'
                },
                {
                    data: 'OBS',
                    title: 'Obs'
                },
                {
                    data: 'CODIGO',
                    title: 'Código'
                },
                {
                    data: 'DESCRICAO',
                    title: 'Descrição'
                },
                {
                    data: 'TP_ITEM',
                    title: 'Tipo Item'
                },
                {
                    data: 'DIAS',
                    title: 'Dias'
                },
                {
                    data: 'PRECO',
                    title: 'Preço'
                },
                {
                    data: 'PERC_IPI',
                    title: 'Perc. Ipi'
                },
                {
                    data: 'DT_ATUALIZA',
                    title: 'Data Atualiza'
                },
                {
                    data: 'QTDE_MIN',
                    title: 'Qtde. Min.'
                },
                {
                    data: 'PADRAO',
                    title: 'Padrão'
                },
                {
                    data: 'CLI_ATIVO',
                    title: 'Fornecedor Ativo'
                },
                {
                    data: 'MAT_ATIVO',
                    title: 'Material Ativo'
                },
                {
                    data: 'PROD_ATIVO',
                    title: 'Produto Ativo'
                },
                {
                    data: 'QTDE_MAX',
                    title: 'Qtde. Max.'
                }
            ];

            $("#tabelaCorCompra").DataTable({
                destroy: true,
                filter: false,
                lengthChange: false,
                serverside: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: jsonStr,
                columns: cols,
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(data);
                        }
                    },
                    {
                        type: 'date-br',
                        targets: [14],
                        render: function (data) {
                            if (data != undefined) {
                                x = data.slice(0, 10).split('-');
                                return `${x[2]}/${x[1]}/${x[0]}`;
                            } else {
                                return ''
                            }
                        }
                    }
                ]
            });
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        }
        finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaDados() {
        try {
            let params = await buscaParametros();
            const response = await requisicao('GET', '/sisplan/cadastros/v1/buscacorcompra?', params, '', 15000);

            if (!response) {
                return;
            }

            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            return response.json();
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados.');
        }
    }

    async function buscaParametros() {
        let pAttDe = $('#dtAttDe').val();
        let pAttAte = $('#dtAttAte').val();
        let pProduto = await formataListas($('#txtProduto').val().toString());
        let pMaterial = await formataListas($('#txtMaterial').val().toString());
        let pCor = await formataListas($('#txtCor').val().toString());
        let pFornecedor = await formataListas($('#txtFornecedor').val().toString());
        let pCodFornecedor = pegaChave('#txtCodfornecedor');
        let pTipoItem = isChecked('#rdMaterial') ? 1 : (isChecked('#rdProduto') ? 2 : 0);
        let pStatusFornecedor = isChecked('#rdFornecedorAtivo') ? 1 : (isChecked('#rdFornecedorInativo') ? 2 : 0);
        let pStatusProduto = isChecked('#rdProdutoAtivo') ? 1 : (isChecked('#rdProdutoInativo') ? 2 : 0);
        let pStatusMaterial = isChecked('#rdMaterialAtivo') ? 1 : (isChecked('#rdMaterialInativo') ? 2 : 0);
        let pPadrao = isChecked('#rdPadrao') ? 1 : 0;

        let retorno =
            `ATTDE=${pAttDe}` +
            `&ATTATE=${pAttAte}` +
            `&PRODUTO=${pProduto}` +
            `&MATERIAL=${pMaterial}` +
            `&COR=${pCor}` +
            `&FORNECEDOR=${pFornecedor}` +
            `&CODFORNECEDOR=${pCodFornecedor}` +
            `&TIPOITEM=${pTipoItem}` +
            `&STATUSFORNECEDOR=${pStatusFornecedor}` +
            `&STATUSPRODUTO=${pStatusProduto}` +
            `&STATUSMATERIAL=${pStatusMaterial}` +
            `&PADRAO=${pPadrao}`;
        return retorno;
    };

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };
});