$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#campostour',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Código',
        description: 'O campo de código é preenchido automaticamente após gravar o registro.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Neste campo adicionamos a descrição para a ordem de impressão.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a ordem de impressão.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {


  $('#btnVoltar').on('click', async function () {
    window.location.href = `${BASE_URI}/confimpressao`;
  });

  $(document).ready(function () {

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida."
        },
      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $('.radio-group .radio').click(function () {
      $(this).parent().find('.radio').removeClass('selected');
      $(this).addClass('selected');
    });

    $(".submit").click(function () {
      return false;
    });
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let confimpressao = parametros[parametros.length - 1];
  let pqCodigoDescricao = Boolean;
  let conf;

  $('#modalOrdem').on('hidden.bs.modal', function () {
    $('#txtOrdenacao').val('');
    $('#txtSeparador').val('');
    $('.itemAdd').removeClass('addSelecionado');
  });

  $('#btnCodigoItem').on('click', function () {
    pqCodigoDescricao = true;
    $('#txtOrdenacao').val($('#txtCodigoItem').val());
    $('#txtSeparador').val($('#txtSeparadorCodigo').val());
    preencheItens($('#txtOrdenacao').val(), $('#txtSeparador').val());
    $('#modalOrdem').modal('show');
  });

  $('#btnDescricaoItem').on('click', function () {
    pqCodigoDescricao = false;
    $('#txtOrdenacao').val($('#txtDescricaoItem').val());
    $('#txtSeparador').val($('#txtSeparadorDescricao').val());
    preencheItens($('#txtOrdenacao').val(), $('#txtSeparador').val());
    $('#modalOrdem').modal('show');
  });

  $('#btnConfirmar').on('click', function () {
    if (pqCodigoDescricao) {
      $('#txtCodigoItem').val($('#txtOrdenacao').val());
      $('#txtSeparadorCodigo').val($('#txtSeparador').val());
    } else {
      $('#txtDescricaoItem').val($('#txtOrdenacao').val());
      $('#txtSeparadorDescricao').val($('#txtSeparador').val());
    }
    $('#modalOrdem').modal('hide');
  });

  $('.itemAdd').on('click', function () {
    const item = $(this).val();
    const separador = $('#txtSeparador').val() != '' ? $('#txtSeparador').val() : $(pqCodigoDescricao ? `#txtSeparadorCodigo` : `#txtSeparadorDescricao`).val();
    const arrItens = $('#txtOrdenacao').val().split(separador);
    let novoArrItens = [];

    $('#txtSeparador').val(separador);

    if ($(this).hasClass('addSelecionado')) {
      novoArrItens = separador != '' ? jQuery.grep(arrItens, function (value) { return value != item }) : '';
      $('#txtOrdenacao').val(novoArrItens.toString().replaceAll(',', separador));
      $(this).removeClass('addSelecionado');
      return;
    }

    if (separador == '') {
      msgAlerta('Separador não pode ser vazio, favor verificar.');
      return;
    }

    $(this).addClass('addSelecionado');

    if (arrItens[0] == '') {
      $('#txtOrdenacao').val(item);
      return;
    }

    $('#txtOrdenacao').val($('#txtOrdenacao').val() + separador + item);
  });

  function preencheItens(sOrdenacao, sSeparador) {
    const arrItens = sSeparador != '' ? sOrdenacao.split(sSeparador) : [sOrdenacao];
    $('.itemAdd').map((indexItem) => {
      arrItens.map((item) => {
        if ($($('.itemAdd')[indexItem]).val() == item) {
          $($('.itemAdd')[indexItem]).addClass('addSelecionado');
        }
      });
    });
  }

  if (confimpressao != '' && confimpressao != 'create') {
    try {
      $.LoadingOverlay("show");
      try {
        const codigoConf = $(window.location.href.split('/')).get(-1);
        const pesquisaParam = {
          tabela: 'FATCONF_XML',
          camposSelect: ['CODIGO', 'DESCRICAO', 'PADRAO_LOJA', 'CONF'],
          where: [`CODIGO = '${codigoConf}'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        conf = jsonStr[0].CONF.split('^');
  
        $('#txtCodigo').val(codigoConf);
        $('#txtDescricao').val(jsonStr[0].DESCRICAO);
        jsonStr[0].PADRAO_LOJA == 'S' ? $('#checkPadrao').prop('checked', true) : $('#checkPadrao').prop('checked', false);
        $('#txtCodigoItem').val(conf[0]);
        $('#txtSeparadorCodigo').val(conf[0].split('#')[2]);
        $('#txtDescricaoItem').val(conf[1]);
        $('#txtSeparadorDescricao').val(conf[1].split('#')[2]);
        conf.splice(0,2);

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados da ordenação: ${error}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        confimpressao = {};

        confimpressao.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('FATCONF_XML', 'FATCONF_XML', 'CODIGO', 0) : $('#txtCodigo').val();
        confimpressao.DESCRICAO = $('#txtDescricao').val().toUpperCase();
        confimpressao.PADRAO = $('#checkPadrao').is(':checked') ? 'S' : 'N';
        confimpressao.CODIGOITEM = $('#txtCodigoItem').val();
        confimpressao.DESCITEM = $('#txtDescricaoItem').val();
        confimpressao.CONF = conf ? conf.toString().replaceAll(',','^') : '';

        let response = await requisicao('POST', '/sisplan/cadastros/v1/confimpressao?', `JSON=${encodeURIComponent(JSON.stringify(confimpressao))}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
          `Cadastro efetuado com sucesso!
           Ordenação: ${confimpressao.CODIGO}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/confimpressao`;
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados da ordenação: ${error}`);
      }
    }
  });
});