/* eslint-disable no-shadow */
/* eslint-disable prefer-destructuring */
$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let urlEntrada = parametros[parametros.length - 1];

  async function verificaItens() {
    let table = $("#tabelaAddProduto").DataTable();
    let linha = table.rows()[0].length;

    for (let i = 0; i < linha; i++) {
      data = table.rows().data()[i];

      if ($(".txtProduto")[i].value == "") {
        if (i == 0) {
          if (urlEntrada != "create") {
            msgAlerta("Nenhum produto informado.");
          }
          return "";
        }
        $($(".btn-exclui-Prod")[i]).trigger("click");
      }
    }
  }

  function mantemDuasCasasDecimais(valor, quantidadeCaracteres) {
    if (valor.toString().indexOf('.') > -1) {
      return parseFloat(valor.toString().substring(0, valor.toString().indexOf('.') + quantidadeCaracteres));
    }
    return valor;
  };

  async function retornaValoresItens(linhaAtual) {
    try {
      let table = $("#tabelaAddProduto").DataTable();
      let data = table.rows().data()[0];

      let naturezaServ = $("#txtNaturezaServ")
        .val()
        .substring(1, $("#txtNaturezaServ").val().indexOf("] - "));
      let tpDoc = $("#txtTpDoc")
        .val()
        .substring(1, $("#txtTpDoc").val().indexOf("] - "));
      let tpMovimentacao = $("#txttpMovimentacao")
        .val()
        .substring(1, $("#txttpMovimentacao").val().indexOf("] - "));

      let nota = {};

      nota.CREDOR = pegaChave($("#txtFornecedor").val(), nota.CREDOR);
      if ($("#txtOperacao").val() != "") {
        nota.OPERACAO = pegaChave($("#txtOperacao").val(), nota.OPERACAO);
      }

      nota.FRETE = $("#txtFreteConhecimento").val();
      nota.FRETENF = $("#txtFreteNF").val();
      nota.DESPESA = $("#txtOutrasDesp").val();
      nota.DESCONTO = $("#txtDesconto").val();
      nota.NATUREZA = pegaChave("#txtNatureza", nota.NATUREZA);

      let i = linhaAtual;

      let arrayItens = [];

      if ($(`#txtQuantidade`).val() == "") {
        msgAlerta(
          `Item: ${$(
            `#txtCodigo-`
          ).val()} sem Quantidade informada. Será necessário excluir o item ou informar uma quantidade.`
        );
        return "";
      }
      if ($(`#txtValorProd`).val() == "") {
        msgAlerta(
          `Item: ${$(
            `#txtCodigo-`
          ).val()} sem valor informado. Será necessário excluir o item ou informar um valor.`
        );
        return "";
      }
      if ($(".txtProduto")[i].value == "") {
        if (urlEntrada != "create") {
          msgAlerta("Nenhum produto informado.");
        }
        return "";
      }

      let NFentraItem = {};
      NFentraItem.CLAFIS = pegaChave($(".txtNCM")[i].value, NFentraItem.CLAFIS);
      NFentraItem.CODIGO = $($(".txtProduto")[i]).attr('data-codigo');
      NFentraItem.CODCRE = pegaChave("#txtFornecedor", NFentraItem.CODCRE);
      NFentraItem.COR = $($(".txtProduto")[i]).attr('data-cor');
      NFentraItem.CSOSN = data[61];
      NFentraItem.DEPOSITO = data[62];
      NFentraItem.DESCRICAO = data[63];
      NFentraItem.ESTOQUE = data[64];
      NFentraItem.NUMERO = data[69];
      NFentraItem.NATUREZA = pegaChave("#txtNatureza", NFentraItem.NATUREZA);
      NFentraItem.NATUREZA_ORIG = naturezaServ;
      NFentraItem.VALOR = $(".txtPreco")[i].value;
      NFentraItem.PERC_II = data[65];
      NFentraItem.QTDE = $(".txtQtde")[i].value;
      NFentraItem.SERIE = $("#txtSerie").val();
      NFentraItem.TOTAL = data[67];
      NFentraItem.TAM = $($(".txtProduto")[i]).attr('data-tam');
      NFentraItem.TIPO = $($(".txtProduto")[i]).attr('data-tipo');
      NFentraItem.TIPO_DOC = tpDoc;
      NFentraItem.TIPO_MOV = tpMovimentacao;

      if ($($(".txtNCM")[i[0]]).val() != "") {
        NFentraItem.DT_FABRICACAO = data[77] != "" ? data[77] : "1899-12-30";
        NFentraItem.DT_VALIDADE = data[78] != "" ? data[78] : "1899-12-30";

        // FISCAL
        NFentraItem.NUMERO_FCI = data[71];
        NFentraItem.INF_PROD = data[72];

        // ICMS
        NFentraItem.CLATRIB = pegaChave(data[75], NFentraItem.CLATRIB);
        NFentraItem.ALIQ_DIF = data[16];
        NFentraItem.ALIQ_SIMPLES = data[73];
        NFentraItem.BASE_ICMS_ST = data[20];
        NFentraItem.BASE_ICMSST_ENT = data[21];
        NFentraItem.BASE_ICMS = data[22];
        NFentraItem.ISENTA_ICMS = data[25];
        NFentraItem.VLR_ICMS = data[31];
        NFentraItem.VALOR_ICMSST_ENT = data[32];
        NFentraItem.VAL_CRED_SIMPLES = data[33];
        NFentraItem.VAL_ICMS_DIF = data[34];
        NFentraItem.VLR_ICMS_ST = data[35];
        NFentraItem.PERC_ICMS_REDUZ = data[74];
        NFentraItem.ICMS = data[66];
        NFentraItem.OUTRAS_ICMS = data[27];

        // IPI
        NFentraItem.CODIPI = pegaChave(data[24], NFentraItem.CODIPI);
        NFentraItem.PERC_IPI = data[76];
        NFentraItem.BASE_IPI = data[19];
        NFentraItem.VLR_IPI = data[36];
        NFentraItem.OUTRAS_IPI = data[28];
        NFentraItem.ISENTA_IPI = data[23];

        // PIS
        NFentraItem.CLA_PIS = pegaChave(data[57], NFentraItem.CLA_PIS);
        NFentraItem.BASE_PIS = data[18];
        NFentraItem.ALIQ_PIS = data[14];
        NFentraItem.VAL_PIS = data[37];

        // COFINS
        NFentraItem.CLA_COFINS = pegaChave(data[58], NFentraItem.CLA_COFINS);
        NFentraItem.BASE_COFINS = data[17];
        NFentraItem.ALIQ_COFINS = data[13];
        NFentraItem.VAL_COFINS = data[38];
      }

      if (data[79] != "") {
        NFentraItem.MANTER_VALOR = data[79];
      } else {
        NFentraItem.MANTER_VALOR = "N";
      }

      arrayItens.push(NFentraItem);

      nota.ITENS = arrayItens;

      let response = await requisicao(
        "POST",
        "/Sisplan/EntradaNF/V1/RetornaValores?",
        `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  async function validaNaturezaItens() {
    if ($('#txtNatureza').val() != '') {
      return;
    };
    let natureza;
    $('.txtCFOP').map((index) => {
      if (index == 0) {
        natureza = $($('.txtCFOP')[index]).val();
      }
      if ($($('.txtCFOP')[index]).val() == '') {
        natureza = '';
      }
    });
    if ((natureza == '') || (natureza == '[] - ')) {
      return;
    };
    natureza = pegaChave(natureza);
    natureza = `[${natureza}] - ${(await buscaValor('NATUREZA', ['DESCRICAO'], 'NATUREZA', natureza)).DESCRICAO}`;
    insereValor('#txtNatureza', natureza);
  };

  async function RetornaValoresNF(alteraNatureza) {
    try {
      let table = $("#tabelaAddProduto").DataTable();
      let data = table.rows().data()[0];
      let linha = table.rows()[0].length;

      let naturezaServ = $("#txtNaturezaServ")
        .val()
        .substring(1, $("#txtNaturezaServ").val().indexOf("] - "));
      let tpDoc = $("#txtTpDoc")
        .val()
        .substring(1, $("#txtTpDoc").val().indexOf("] - "));
      let tpMovimentacao = $("#txttpMovimentacao")
        .val()
        .substring(1, $("#txttpMovimentacao").val().indexOf("] - "));

      let nota = {};

      nota.CREDOR = pegaChave($("#txtFornecedor").val(), nota.CREDOR);
      if ($("#txtOperacao").val() != "") {
        nota.OPERACAO = pegaChave($("#txtOperacao").val(), nota.OPERACAO);
      }
      nota.FRETE = $("#txtFreteConhecimento").val();
      nota.FRETENF = $("#txtFreteNF").val();
      nota.DESPESA = $("#txtOutrasDesp").val();
      nota.DESCONTO = $("#txtDesconto").val();
      nota.NATUREZA = pegaChave("#txtNatureza", nota.NATUREZA);

      let arrayItens = [];

      for (let i = 0; i < linha; i++) {
        data = table.rows().data()[i];

        if ($(".txtProduto")[i].value == "") {
          if (urlEntrada != "create") {
            msgAlerta("Nenhum produto informado.");
          }
          return "";
        }

        let NFentraItem = {};
        NFentraItem.CLAFIS = pegaChave($(".txtNCM")[i].value, NFentraItem.CLAFIS);
        NFentraItem.CODIGO = $($(".txtProduto")[i]).attr('data-codigo');
        NFentraItem.CODCRE = pegaChave("#txtFornecedor", NFentraItem.CODCRE);
        NFentraItem.COR = $($(".txtProduto")[i]).attr('data-cor');
        NFentraItem.CSOSN = data[61];
        NFentraItem.DEPOSITO = data[62];
        NFentraItem.DESCRICAO = data[63];
        NFentraItem.ESTOQUE = data[64];
        NFentraItem.NUMERO = data[69];
        NFentraItem.NATUREZA = pegaChave(
          $(".txtCFOP")[i].value,
          NFentraItem.NATUREZA
        );
        NFentraItem.NATUREZA_ORIG = naturezaServ;
        NFentraItem.VALOR = $(".txtPreco")[i].value;
        NFentraItem.PERC_II = data[65];
        NFentraItem.QTDE = $(".txtQtde")[i].value;
        NFentraItem.SERIE = $("#txtSerie").val();
        NFentraItem.TOTAL = data[67];
        NFentraItem.TAM = $($(".txtProduto")[i]).attr('data-tam');
        NFentraItem.TIPO = $($(".txtProduto")[i]).attr('data-tipo');
        NFentraItem.TIPO_DOC = tpDoc;
        NFentraItem.TIPO_MOV = tpMovimentacao;

        if (alteraNatureza != true) {
          NFentraItem.DT_FABRICACAO = data[77] != "" ? data[77] : "1899-12-30";
          NFentraItem.DT_VALIDADE = data[78] != "" ? data[78] : "1899-12-30";

          // FISCAL
          NFentraItem.NUMERO_FCI = data[71];
          NFentraItem.INF_PROD = data[72];

          // ICMS
          NFentraItem.CLATRIB = pegaChave(data[75], NFentraItem.CLATRIB);
          NFentraItem.ALIQ_DIF = data[16];
          NFentraItem.ALIQ_SIMPLES = data[73];
          NFentraItem.BASE_ICMS_ST = data[20];
          NFentraItem.BASE_ICMSST_ENT = data[21];
          NFentraItem.BASE_ICMS = data[22];
          NFentraItem.ISENTA_ICMS = data[25];
          NFentraItem.VLR_ICMS = data[31];
          NFentraItem.VALOR_ICMSST_ENT = data[32];
          NFentraItem.VAL_CRED_SIMPLES = data[33];
          NFentraItem.VAL_ICMS_DIF = data[34];
          NFentraItem.VLR_ICMS_ST = data[35];
          NFentraItem.PERC_ICMS_REDUZ = data[74];
          NFentraItem.ICMS = data[66];
          NFentraItem.OUTRAS_ICMS = data[27];

          // IPI
          NFentraItem.CODIPI = pegaChave(data[24], NFentraItem.CODIPI);
          NFentraItem.PERC_IPI = data[76];
          NFentraItem.BASE_IPI = data[19];
          NFentraItem.VLR_IPI = data[36];
          NFentraItem.OUTRAS_IPI = data[28];
          NFentraItem.ISENTA_IPI = data[23];

          // PIS
          NFentraItem.CLA_PIS = pegaChave(data[57], NFentraItem.CLA_PIS);
          NFentraItem.BASE_PIS = data[18];
          NFentraItem.ALIQ_PIS = data[14];
          NFentraItem.VAL_PIS = data[37];

          // COFINS
          NFentraItem.CLA_COFINS = pegaChave(data[58], NFentraItem.CLA_COFINS);
          NFentraItem.BASE_COFINS = data[17];
          NFentraItem.ALIQ_COFINS = data[13];
          NFentraItem.VAL_COFINS = data[38];
        }

        if (data[79] != "") {
          NFentraItem.MANTER_VALOR = data[79];
        } else {
          NFentraItem.MANTER_VALOR = "N";
        }

        arrayItens.push(NFentraItem);
      }

      nota.ITENS = arrayItens;

      let response = await requisicao(
        "POST",
        "/Sisplan/EntradaNF/V1/RetornaValores?",
        "",
        `JSON=${encodeURIComponent(JSON.stringify(nota))}`,
        30000
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  let Colunas = [
    "Número",
    "Item",
    "Qtde",
    "Preço",
    "CFOP",
    "IPI",
    "ICMS",
    "NCM",
    "Ações",
    "AdicionarLinha",
    "CODIGO2",
    "COD_REGRA",
    "TIPO_VENDA",
    "ALIQ_COFINS",
    "ALIQ_PIS",
    "ALIQ_SIMPLES",
    "ALIQ_DIF",
    "BASE_COFINS",
    "BASE_PIS",
    "BASE_IPI",
    "BASE_ICMS_ST",
    "BASE_ICMSST_ENT",
    "BASE_ICMS",
    "ISENTA_IPI",
    "IPI",
    "ISENTA_ICMS",
    "LOTE",
    "OUTRAS_ICMS",
    "OUTRAS_IPI",
    "TIPO",
    "VALOR",
    "VALOR_ICMS",
    "VALOR_ICMSST_ENT",
    "VAL_CRED_SIMPLES",
    "VAL_ICMS_DIF",
    "VLR_ICMS_ST",
    "VLR_IPI",
    "VAL_PIS",
    "VAL_COFINS",
    "CODIPI",
    "CODFIS",
    "CODTRIB",
    "COD_REGRA",
    "COMPRI",
    "DEPOSITO",
    "DESCNCM",
    "DESCRICAO",
    "ESTOQUE",
    "IPI",
    "LARGURA",
    "LOCAL",
    "TIPO_VENDA",
    "TP_BAIXA",
    "TRIBUTACAO",
    "UNIDADE",
    "CODIGO",
    "CODCRE",
    "CLA_PIS",
    "CLA_COFINS",
    "CODIPI",
    "COR",
    "CSOSN",
    "DEPOSITO",
    "DESCRICAO",
    "ESTOQUE",
    "PERC_II",
    "PERC_ICMS_REDUZ",
    "TOTAL",
    "TAM",
    "NOTAFISCAL",
    "CLATRIB",
  ];

  // autocompleta
  $("#txtNatureza").autocompleta(
    1,
    `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": ["tp_base = '2' and ativo = 'S'"]}`
  );
  $("#txtNaturezaItens").autocompleta(
    1,
    `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`
  );
  $("#txtNaturezaServ").autocompleta(
    1,
    `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": ["ativo = 'S' and tipo = 'S'"]}`
  );
  $("#txtNaturezaImp").autocompleta(
    1,
    `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": ["tp_base = '2' and ativo = 'S'"]}`
  );
  $("#txtOperacao").autocompleta(
    1,
    `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtOperacaoImp").autocompleta(
    1,
    `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txttpMovimentacao").autocompleta(
    1,
    `JSON={ "tabela":"tabbai", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtDeposito").autocompleta(
    1,
    `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["empresa = '${getCookie('empresa').replace('_', '')}'"]}`
  );
  $("#txtCSTICMS").autocompleta(
    1,
    `JSON={ "tabela":"tabtri", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtCSTIPI").autocompleta(
    1,
    `JSON={ "tabela":"tabipi", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtCSTPIS").autocompleta(
    1,
    `JSON={ "tabela":"tabpis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtCSTCofins").autocompleta(
    1,
    `JSON={ "tabela":"tabcofins", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtNCM").autocompleta(
    1,
    `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtTpDoc").autocompleta(
    1,
    `JSON={ "tabela":"tipo_fiscal", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtClasseGer").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtFornecedor").autocompleta(
    3,
    `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": ["ativo = 'S'"]}`
  );
  $("#txtSituacao").autocompleta(
    1,
    `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtBanco").autocompleta(
    1,
    `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`
  );
  $("#txtConta").autocompleta(
    1,
    `JSON={ "tabela":"cadconta", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtHistorico").autocompleta(
    1,
    `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`
  );
  $("#txtEmpresa").autocompleta(
    1,
    `JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat, '_', '') chave", "emp_nome descricao"], "where": null}`
  );

  // pesquisa campo
  $("#btn-ClasseGer").pesquisa(
    "#txtClasseGer",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-Situacao").pesquisa(
    "#txtSituacao",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Situação",
    "tabsit"
  );
  $("#btn-Banco").pesquisa(
    "#txtBanco",
    "BANCO",
    "NOME_BANCO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`,
    "Pesquisa Banco",
    "cadban"
  );
  $("#btn-Conta").pesquisa(
    "#txtConta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "codigo", "conta", "descricao"]}`,
    "Pesquisa Conta",
    "cadconta"
  );
  $("#btn-Operacao").pesquisa(
    "#txtOperacao",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Operação",
    "oper_fiscal"
  );
  $("#btn-OperacaoImp").pesquisa(
    "#txtOperacaoImp",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Operação",
    "oper_fiscal"
  );
  $("#btn-Historico").pesquisa(
    "#txtHistorico",
    "HISTORICO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`,
    "Pesquisa Histórico",
    "histcp"
  );
  $("#btn-Fornecedor").pesquisa(
    "#txtFornecedor",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"], "where": ["ativo = 'S'"]}`,
    "Pesquisa Fornecedor",
    "entidade"
  );
  $("#btn-Natureza").pesquisa(
    "#txtNatureza",
    "NATUREZA",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"], "where": ["tp_base = '2' and ativo = 'S'"]}`,
    "Pesquisa Natureza",
    "natureza"
  );
  $("#btn-NaturezaFiscal").pesquisa(
    "#txtNaturezaFiscal",
    "natureza",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`,
    "Pesquisa Natureza",
    "natureza"
  );
  $("#btnNaturezaImp").pesquisa(
    "#txtNaturezaImp",
    "NATUREZA",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"], "where": ["tp_base = '2' and ativo = 'S'"]}`,
    "Pesquisa Natureza",
    "natureza"
  );
  $("#btn-NaturezaServ").pesquisa(
    "#txtNaturezaServ",
    "NATUREZA",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"], "where": ["ativo = 'S' and tipo = 'S'"]}`,
    "Pesquisa Natureza Serv",
    "natureza"
  );
  $("#btn-tpMovimentacao").pesquisa(
    "#txttpMovimentacao",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabbai", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Tipo Movimentação",
    "tabbai"
  );

  $('#btn-Deposito').pesquisa(
    '#txtDeposito',
    'CODIGO',
    'DESCRICAO',
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"], "where": ["empresa = '${getCookie('empresa').replace('_', '')}'"]}`,
    'Pesquisa Depósito',
    'deposito'
  );

  $("#btn-CSTICMS").pesquisa(
    "#txtCSTICMS",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtri", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST",
    "tabpis"
  );
  $("#btn-CSTIPI").pesquisa(
    "#txtCSTIPI",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabipi", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST",
    "tabpis"
  );
  $("#btn-CSTPIS").pesquisa(
    "#txtCSTPIS",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabpis", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST",
    "tabpis"
  );
  $("#btn-CSTCofins").pesquisa(
    "#txtCSTCofins",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabcofins", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST",
    "tabpis"
  );
  $("#btn-NCM").pesquisa(
    "#txtNCM",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabfis", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa NSU",
    "tabfis"
  );
  $("#btn-TpDoc").pesquisa(
    "#txtTpDoc",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tipo_fiscal", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Tipo Documento",
    "tipo_fiscal"
  );
  $("#btnEmpresa").pesquisa(
    "#txtEmpresa",
    "EMPRESA",
    "EMP_NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat, '_', '') EMPRESA", "EMP_NOME"]}`,
    "Pesquisa Empresa",
    "empresa"
  );

  // limpa campo
  $("#btn-limpa-Operacao").on("click", function () {
    $("#txtOperacao").val("");
  });
  $("#btn-limpa-OperacaoImp").on("click", function () {
    $('#buscarTribNota').prop('disabled', false);
    $("#txtOperacaoImp").val("");
  });
  $("#btn-limpa-NCM").on("click", function () {
    $("#txtNCM").val("");
  });
  $("#btn-limpa-Fornecedor").on("click", function () {
    $("#txtFornecedor").val("");
  });
  $("#btn-limpa-Natureza").on("click", function () {
    $("#txtNatureza").val("");
    $("#txtNatureza").trigger("blur");
  });
  $("#btn-limpa-NaturezaItens").on("click", function () {
    $("#txtNaturezaItens").val("");
  });
  $("#btn-limpa-NaturezaServ").on("click", function () {
    $("#txtNaturezaServ").val("");
  });
  $("#btn-limpa-tpMovimentacao").on("click", function () {
    $("#txttpMovimentacao").val("");
  });
  $("#btn-limpa-Deposito").on("click", function () {
    $("#txtDeposito").val("");
  });
  $("#btn-limpa-CSTICMS").on("click", function () {
    $("#txtCSTICMS").val("");
  });
  $("#btn-limpa-CSTIPI").on("click", function () {
    $("#txtCSTIPI").val("");
  });
  $("#btn-limpa-CSTPIS").on("click", function () {
    $("#txtCSTPIS").val("");
  });
  $("#btn-limpa-CSTCofins").on("click", function () {
    $("#txtCSTCofins").val("");
  });
  $("#btn-limpa-TpDoc").on("click", function () {
    $("#txtTpDoc").val("").change();
  });
  $("#btn-limpa-ClasseGer").on("click", function () {
    $("#txtClasseGer").val("");
  });
  $("#btn-limpa-Fornecedor").on("click", function () {
    $("#txtFornecedor").val("");
  });
  $("#btn-limpa-Situacao").on("click", function () {
    $("#txtSituacao").val("");
  });
  $("#btn-limpa-Banco").on("click", function () {
    $("#txtBanco").val("");
  });
  $("#btn-limpa-Conta").on("click", function () {
    $("#txtConta").val("");
  });
  $("#btn-limpa-Historico").on("click", function () {
    $("#txtHistorico").val("");
  });
  $("#btnAEmpresa").on("click", function () {
    $("#txtEmpresa").val("");
    $('#txtNumeroNota').val('');
    $('#btnNumeroNota').val('');
    $('#btnANumeroNota').val('');
    $('#txtNumeroNota').prop('disabled', true);
    $('#btnNumeroNota').prop('disabled', true);
    $('#btnANumeroNota').prop('disabled', true);
  });
  $("#btnANaturezaImp").on("click", function () {
    $("#txtNaturezaImp").val("");
  });
  $("#btnANumeroNota").on("click", function () {
    $("#txtNumeroNota").val("");
  });

  // abrir modais
  $("#btnBases").on("click", function () {
    $("#modal-Bases").modal("show");
  });
  $("#btnFinanceiro").on("click", function () {
    $("#modal-Financeiro").modal("show");
  });
  $("#btnDadosAdicionais").on("click", function () {
    $("#modal-DadosAdicionais").modal("show");
  });
  $("#btnEnergiaTelefonia").on("click", function () {
    $("#modal-EnergiaTelefonia").modal("show");
  });

  $("#txtProdutoCodigo").change(function () {
    $("#btnConsultarProduto").trigger("click");
  });

  $(
    "#txtFreteConhecimento, #txtFreteNF, #txtOutrasDesp, #txtDesconto, #txtOperacao, #txtBaseICMSISS"
  ).change(async function () {
    try {
      $.LoadingOverlay("show");

      await verificaItens();

      let qtdeLinhas = $(".txtCFOP").length;
      let retorno = await RetornaValoresNF(false);

      // TOTAIS
      $("#txtValordaNF").val(retorno.valor.toFixed(2));
      $("#txtValorContabilização").val(" ");
      // PRODUTO/MATERIAL
      $("#txtBaseICMSISS").val(retorno.base_icm.toFixed(2));
      $("#txtBaseICMSST1").val(retorno.base_icms_st.toFixed(2));
      $("#txtBaseIPI").val(retorno.base_ipi.toFixed(2));

      $("#txtOutrasICMSISS").val(retorno.outras_icm.toFixed(2));
      $("#txtValorICMSST").val(retorno.valor_icms_st.toFixed(2));
      $("#txtOutrasIPI").val(retorno.outras_ipi.toFixed(2));
      $("#txtDifICMSSTRecolher").val(
        retorno.val_dif_icmsst.toFixed(2)
      );

      $("#txtIsentoICMSISS").val(retorno.isenta_icm.toFixed(2));
      $("#txtBaseICMSST2").val(retorno.base_icmsst_ent.toFixed(2));
      $("#txtIsentoIPI").val(retorno.isenta_ipi.toFixed(2));
      $("#txtValorProdutos").val(retorno.val_produtos.toFixed(2));

      $("#txtValorICMSISS").val(retorno.valor_icm.toFixed(2));
      $("#txtValorICMSSTCalc").val(
        retorno.valor_icmsst_ent.toFixed(2)
      );
      $("#txtValorIPI").val(retorno.valor_ipi.toFixed(2));
      $("#txtValorEstoqueCardex").val(retorno.val_cardex.toFixed(2));
      // GERAL - GERAL
      $("#txtBaseCofins").val(retorno.base_cofins.toFixed(2));
      $("#txtDiferencialAliquota").val(retorno.aliq_dif.toFixed(2));

      $("#txtValorCofins").val(retorno.valor_retcofins.toFixed(2));
      $("#txtDiferencialValor").val(retorno.val_icms_dif.toFixed(2));

      $("#txtBasePIS2").val(retorno.base_pis.toFixed(2));
      $("#txtAliqCredSimplesNac").val(
        retorno.aliq_simples.toFixed(2)
      );

      if (retorno.deposito != '') {
        insereValor('#txtDeposito', retorno.deposito, retorno.desc_deposito);
      }

      $("#txtValorPIS2").val(retorno.valor_retpis.toFixed(2));
      $("#txtValCredSimplesNac").val(
        retorno.val_cred_simples.toFixed(2)
      );
      // GERAL - BENEFÍCIO FISCAL
      $("#txtPerc").val(retorno.perc_benef_fiscal.toFixed(2));
      $("#txtValor").val(retorno.valor_benef_fiscal.toFixed(2));

      for (let i = 0; i < qtdeLinhas; i++) {
        let linhaatual = i;
        let data = $("#tabelaAddProduto").DataTable().row(linhaatual).data();

        if (
          $(".txtPreco")[linhaatual].value != "0.00" &&
          $(".txtPreco")[linhaatual].value != "" &&
          $(".txtQtde")[linhaatual].value != "0.00" &&
          $(".txtQtde")[linhaatual].value != ""
        ) {
          try {
            $(".txtICMS")[linhaatual].value =
              retorno.itens[i].icms.toFixed(2);
            $(".txtIPI")[linhaatual].value =
              retorno.itens[i].perc_ipi.toFixed(2);
            $(".txtNCM")[
              linhaatual
            ].value = `[${retorno.itens[i].clafis}] - ${retorno.itens[i].desc_clafis}`;
            $(".txtCFOP")[
              linhaatual
            ].value = `[${retorno.itens[i].natureza}] - ${retorno.itens[i].desc_natureza}`;
            // FISCAL
            data[71] = retorno.itens[i].numero_fci;
            data[72] = retorno.itens[i].inf_prod;
            // ICMS
            data[75] = `[${retorno.itens[i].clatrib}] - ${retorno.itens[i].desc_Clatrib}`;
            data[32] = retorno.itens[i].valor_icmsst_ent.toFixed(2);
            data[21] = retorno.itens[i].base_icmsst_ent.toFixed(2);
            data[20] = retorno.itens[i].base_icms_st.toFixed(2);
            data[22] = retorno.itens[i].base_icms.toFixed(2);
            data[66] = retorno.itens[i].icms.toFixed(2);
            data[27] = retorno.itens[i].outras_icms.toFixed(2);
            data[73] = retorno.itens[i].aliq_simples.toFixed(2);
            data[33] = retorno.itens[i].val_cred_simples.toFixed(2);
            data[35] = retorno.itens[i].vlr_icms_st.toFixed(2);
            data[74] = retorno.itens[i].perc_icms_reduz.toFixed(2);
            data[31] = retorno.itens[i].vlr_icms.toFixed(2);
            data[25] = retorno.itens[i].isenta_icms.toFixed(2);
            data[16] = retorno.itens[i].aliq_dif.toFixed(2);
            data[34] = retorno.itens[i].val_icms_dif.toFixed(2);
            // IPI
            data[24] = `[${retorno.itens[i].codipi}] - ${retorno.itens[i].desc_codipi}`;
            data[19] = retorno.itens[i].base_ipi.toFixed(2);
            data[76] = retorno.itens[i].perc_ipi.toFixed(2);
            data[36] = retorno.itens[i].vlr_ipi.toFixed(2);
            data[28] = retorno.itens[i].outras_ipi.toFixed(2);
            data[23] = retorno.itens[i].isenta_ipi.toFixed(2);
            // PIS
            data[57] = `[${retorno.itens[i].cla_pis}] - ${retorno.itens[i].desc_cla_pis}`;
            data[18] = retorno.itens[i].base_pis.toFixed(2);
            data[14] = retorno.itens[i].aliq_pis.toFixed(2);
            data[37] = retorno.itens[i].val_pis.toFixed(2);
            // COFINS
            data[58] = `[${retorno.itens[i].cla_cofins}] - ${retorno.itens[i].desc_cla_cofins}`;
            data[17] = retorno.itens[i].base_cofins.toFixed(2);
            data[13] = retorno.itens[i].aliq_cofins.toFixed(2);
            data[38] = retorno.itens[i].val_cofins.toFixed(2);
          } catch (error) {
            console.error(error);
          }
        }
      }
    } finally {
      await validaNaturezaItens();
      $.LoadingOverlay("hide");
    }
  });

  $("#txtNatureza").blur(async function () {
    if (($($(".txtProduto")[0]).val() != '') && ($("#txtNatureza").val() != '')) {
      msgAlerta("Deseja alterar a natureza de todos os itens?", async function () {
        $(".txtCFOP").val($("#txtNatureza").val());

        try {
          $.LoadingOverlay("show");

          await verificaItens();

          let qtdeLinhas = $(".txtCFOP").length;
          let retorno = await RetornaValoresNF(true);

          // TOTAIS
          $("#txtValordaNF").val(retorno.valor.toFixed(2));
          $("#txtValorContabilização").val(" ");
          // PRODUTO/MATERIAL
          $("#txtBaseICMSISS").val(retorno.base_icm.toFixed(2));
          $("#txtBaseICMSST1").val(retorno.base_icms_st.toFixed(2));
          $("#txtBaseIPI").val(retorno.base_ipi.toFixed(2));

          $("#txtOutrasICMSISS").val(retorno.outras_icm.toFixed(2));
          $("#txtValorICMSST").val(retorno.valor_icms_st.toFixed(2));
          $("#txtOutrasIPI").val(retorno.outras_ipi.toFixed(2));
          $("#txtDifICMSSTRecolher").val(
            retorno.val_dif_icmsst.toFixed(2)
          );

          $("#txtIsentoICMSISS").val(retorno.isenta_icm.toFixed(2));
          $("#txtBaseICMSST2").val(
            retorno.base_icmsst_ent.toFixed(2)
          );
          $("#txtIsentoIPI").val(retorno.isenta_ipi.toFixed(2));
          $("#txtValorProdutos").val(retorno.val_produtos.toFixed(2));

          $("#txtValorICMSISS").val(retorno.valor_icm.toFixed(2));
          $("#txtValorICMSSTCalc").val(
            retorno.valor_icmsst_ent.toFixed(2)
          );
          $("#txtValorIPI").val(retorno.valor_ipi.toFixed(2));
          $("#txtValorEstoqueCardex").val(
            retorno.val_cardex.toFixed(2)
          );
          // GERAL - GERAL
          $("#txtBaseCofins").val(retorno.base_cofins.toFixed(2));
          $("#txtDiferencialAliquota").val(
            retorno.aliq_dif.toFixed(2)
          );

          $("#txtValorCofins").val(
            retorno.valor_retcofins.toFixed(2)
          );
          $("#txtDiferencialValor").val(
            retorno.val_icms_dif.toFixed(2)
          );

          $("#txtBasePIS2").val(retorno.base_pis.toFixed(2));
          $("#txtAliqCredSimplesNac").val(
            retorno.aliq_simples.toFixed(2)
          );

          $("#txtValorPIS2").val(retorno.valor_retpis.toFixed(2));
          $("#txtValCredSimplesNac").val(
            retorno.val_cred_simples.toFixed(2)
          );
          // GERAL - BENEFÍCIO FISCAL
          $("#txtPerc").val(retorno.perc_benef_fiscal.toFixed(2));
          $("#txtValor").val(retorno.valor_benef_fiscal.toFixed(2));

          for (let i = 0; i < qtdeLinhas; i++) {
            let linhaatual = i;
            let data = $("#tabelaAddProduto")
              .DataTable()
              .row(linhaatual)
              .data();

            if (
              $(".txtPreco")[linhaatual].value != "0.00" &&
              $(".txtPreco")[linhaatual].value != "" &&
              $(".txtQtde")[linhaatual].value != "0.00" &&
              $(".txtQtde")[linhaatual].value != ""
            ) {
              try {
                $(".txtICMS")[linhaatual].value =
                  retorno.itens[i].icms.toFixed(2);
                $(".txtIPI")[linhaatual].value =
                  retorno.itens[i].perc_ipi.toFixed(2);
                $(".txtNCM")[
                  linhaatual
                ].value = `[${retorno.itens[i].clafis}] - ${retorno.itens[i].desc_clafis}`;
                $(".txtCFOP")[
                  linhaatual
                ].value = `[${retorno.itens[i].natureza}] - ${retorno.itens[i].desc_natureza}`;

                // FISCAL
                data[71] = retorno.itens[i].numero_fci;
                data[72] = retorno.itens[i].inf_prod;
                // ICMS
                data[75] = `[${retorno.itens[i].clatrib}] - ${retorno.itens[i].desc_Clatrib}`;
                data[32] =
                  retorno.itens[i].valor_icmsst_ent.toFixed(2);
                data[21] =
                  retorno.itens[i].base_icmsst_ent.toFixed(2);
                data[20] = retorno.itens[i].base_icms_st.toFixed(2);
                data[22] = retorno.itens[i].base_icms.toFixed(2);
                data[66] = retorno.itens[i].icms.toFixed(2);
                data[27] = retorno.itens[i].outras_icms.toFixed(2);
                data[73] = retorno.itens[i].aliq_simples.toFixed(2);
                data[33] =
                  retorno.itens[i].val_cred_simples.toFixed(2);
                data[35] = retorno.itens[i].vlr_icms_st.toFixed(2);
                data[74] =
                  retorno.itens[i].perc_icms_reduz.toFixed(2);
                data[31] = retorno.itens[i].vlr_icms.toFixed(2);
                data[25] = retorno.itens[i].isenta_icms.toFixed(2);
                data[16] = retorno.itens[i].aliq_dif.toFixed(2);
                data[34] = retorno.itens[i].val_icms_dif.toFixed(2);
                // IPI
                data[24] = `[${retorno.itens[i].codipi}] - ${retorno.itens[i].desc_codipi}`;
                data[19] = retorno.itens[i].base_ipi.toFixed(2);
                data[76] = retorno.itens[i].perc_ipi.toFixed(2);
                data[36] = retorno.itens[i].vlr_ipi.toFixed(2);
                data[28] = retorno.itens[i].outras_ipi.toFixed(2);
                data[23] = retorno.itens[i].isenta_ipi.toFixed(2);
                // PIS
                data[57] = `[${retorno.itens[i].cla_pis}] - ${retorno.itens[i].desc_cla_pis}`;
                data[18] = retorno.itens[i].base_pis.toFixed(2);
                data[14] = retorno.itens[i].aliq_pis.toFixed(2);
                data[37] = retorno.itens[i].val_pis.toFixed(2);
                // COFINS
                data[58] = `[${retorno.itens[i].cla_cofins}] - ${retorno.itens[i].desc_cla_cofins}`;
                data[17] = retorno.itens[i].base_cofins.toFixed(2);
                data[13] = retorno.itens[i].aliq_cofins.toFixed(2);
                data[38] = retorno.itens[i].val_cofins.toFixed(2);
              } catch (error) {
                console.error(error);
              }
            }
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });
    }
  });

  async function addItensSequencia(tabela) {
    let linhaSelecionada = 0;

    let table = $(`#tabelaAddProduto`).DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      autoWidth: false,
      destroy: true,
      columnDefs: [
        {
          targets: [
            10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
            27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
            44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
            61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
            78, 79,
          ],
          visible: false,
        },
      ],
    });

    $(".txtQtde").maskMoney({ decimal: ".", thousands: "", precision: 2 });
    $(".txtPreco").maskMoney({ decimal: ".", thousands: "", precision: 2 });
    $(".txtIPI").maskMoney({ decimal: ".", thousands: "", precision: 2 });
    $(".txtICMS").maskMoney({ decimal: ".", thousands: "", precision: 2 });

    $(".txtNCM").autocompleta(
      1,
      `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
    );
    $(".txtCFOP").autocompleta(
      1,
      `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": ["tp_base = '2'"]}`
    );

    // chama pesquisa do produto/material
    $(`#${tabela.modalPesquisa}`).on("shown.bs.modal", function () {
      $("#txtProdutoCodigo").focus();
    });

    $("#txtProdutoDescricao").on("focusout", function () {
      $(`#${tabela.btnConfirmaConsultar}`).focus();
    });

    // excluir a linha
    $(`.${tabela.classbtnExcluir}`).unbind("click");
    $(`.${tabela.classbtnExcluir}`).on("click", async function () {
      limpaTotalizador();
      if (table.rows()[0].length != 1) {
        table
          .row($(this).closest("tr")[0].rowIndex - 1)
          .remove()
          .draw(false);

        for (let i = 0; i < table.rows()[0].length; i++) {
          $($(`.${tabela.contador}`)[i]).html(1 + i);
          const sPreco = $('.txtPreco')[i].value;
          const sQtde = $('.txtQtde')[i].value;

          atualizarTotalizador(sPreco, sQtde)
        }
      }
    });

    function atualizarTotalizador(sPreco, sQtde) {
      let sPrecoTotal = parseFloat($('#txtPrecoTot').html());
      let sQtdeTotal = parseFloat($('#txtQtdeTot').html());
      sPrecoTotal = sPrecoTotal + parseFloat(sPreco);
      sQtdeTotal = sQtdeTotal + parseFloat(sQtde);

      $('#txtPrecoTot').html(mantemDuasCasasDecimais(sPrecoTotal, 3));
      $('#txtQtdeTot').html(mantemDuasCasasDecimais(sQtdeTotal, 3));
    }

    function limpaTotalizador() {
      $('#txtPrecoTot').html('0,00');
      $('#txtQtdeTot').html('0');
    }

    // adiciona a linha
    if (table.row().length == 0) {
      table.row.add(tabela.campos).draw(false);
    }

    $("#chamaLoop").unbind("click");
    $("#chamaLoop").click(async function () {
      addItensSequencia(tabela);
    });

    $(`.${tabela.inputCodigo}`).unbind("click");
    $(`.${tabela.inputCodigo}`).on("click", function () {
      linhaSelecionada = table.row($(this).closest("tr"))[0][0];
      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).addClass('addProdutoFocus');
      setTimeout(() => {
        $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).removeClass('addProdutoFocus');
      }, 400);
    });

    $(`.${tabela.addLinha}`).unbind("click");
    $(`.${tabela.addLinha}`).on("click", function () {
      if ($($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).val() != '') {
        if (
          $(`.${tabela.addLinha}`).length == $(this).closest("tr")[0].rowIndex
        ) {
          table.row.add(tabela.campos).draw(false);
          $($(`.${tabela.contador}`)[$(`.${tabela.addLinha}`).length - 1]).html(
            $(`.${tabela.addLinha}`).length
          );

          $($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).addClass('addProdutoFocus');
          setTimeout(() => {
            $($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).removeClass('addProdutoFocus'); addItensSequencia(tabela);
          }, 400);

          // addItensSequencia(tabela);
        }
      }
    });

    $(`.${tabela.addLinha}`).unbind("keyup");
    $(`.${tabela.addLinha}`).keyup(function (e) {
      if (e.keyCode == 9) {
        if ($($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).val() != '') {
          if (
            $(`.${tabela.addLinha}`).length == $(this).closest("tr")[0].rowIndex
          ) {
            table.row.add(tabela.campos).draw(false);
            $($(`.${tabela.contador}`)[$(`.${tabela.addLinha}`).length - 1]).html(
              $(`.${tabela.addLinha}`).length
            );

            $($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).addClass('addProdutoFocus');
            setTimeout(() => {
              $($(`.${tabela.inputCodigo}`)[$(`.${tabela.addLinha}`).length - 1]).removeClass('addProdutoFocus'); addItensSequencia(tabela);
            }, 400);

            // addItensSequencia(tabela);
          }
        }
      }
    });

    async function limpaCamposEdt(tipoExclusao) {
      if (tipoExclusao == false) {
        $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).val("");
        $($(".txtQtde")[linhaSelecionada]).val("");
        $($(".txtPreco")[linhaSelecionada]).val("");
        $($(".txtCFOP")[linhaSelecionada]).val("");
        $($(".txtIPI")[linhaSelecionada]).val("");
        $($(".txtICMS")[linhaSelecionada]).val("");
        $($(".txtNCM")[linhaSelecionada]).val("");
        $("#txtCSTICMS").val("");
        $("#txtNaturezaItens").val("");
        $("#txtPercICMS").val("");
        $("#txtCSTIPI").val("");
        $("#txtCSTCofins").val("");
        $(`#txtAliquotaPIS`).val("");
        $(`#txtAliquotaCOFINS`).val("");
        $(`#txtDifAliq`).val("");
        $(`#txtCredSN`).val("");
        $(`#txtBaseCOFINS3`).val("");
        $(`#txtBaseICMS`).val("");
        $(`#txtBaseST`).val("");
        $(`#txtBaseSTCalc`).val("");
        $(`#txtBaseIPI2`).val("");
        $(`#txtBasePIS`).val("");
        $(`#txtProdutoDescricao`).val("");
        $(`#txtIsentasICMS`).val("");
        $(`#txtIsentasIPI`).val("");
        $(`#txtOutrasICMS`).val("");
        $(`#txtOutrasIPI2`).val("");
        $(`#txtQTDE`).val("");
        $(`#txtValorProd`).val("");
        $(`#txtValorCOFINS2`).val("");
        $(`#txtValorCredSN`).val("");
        $(`#txtValorDifAliq`).val("");
        $(`#txtValorPIS`).val("");
        $(`#txtValorProd`).val("");
        $(`#txtValorSTCalc`).val("");
        $(`#txtValorICMS`).val("");
        $(`#txtValorST`).val("");
        $(`#txtValorIPI2`).val("");
        $(`#txtNumeroFCI`).val("");
        $(`#txtInfAdProd`).val("");
        $(`#txtCredSN`).val("");
        $(`#txtCST20`).val("");
        $(`#txtCSTICMS`).val("");
        $(`#txtPercentIPI`).val("");
        $("#txtCSTPIS").val("");
        $(`#DtFabricacao`).val("");
        $(`#txtDtValidaEstoque`).val("");
        $("#manterDigitado").prop("checked", false);

        $(`#${tabela.idTabela}`).DataTable().row().remove().draw(false);
        await addItensSequencia(Produto);
      } else {
        $(`#txtAliquotaPIS`).val("");
        $(`#txtAliquotaCOFINS`).val("");
        $(`#txtDifAliq`).val("");
        $(`#txtCredSN`).val("");
        $(`#txtBaseCOFINS3`).val("");
        $(`#txtBaseICMS`).val("");
        $(`#txtBaseST`).val("");
        $(`#txtBaseSTCalc`).val("");
        $(`#txtBaseIPI2`).val("");
        $(`#txtBasePIS`).val("");
        $(`#txtCSTCofins`).val("");
        $(`#txtCSTIPI`).val("");
        $(`#txtCor`).val("");
        $(`#txtNCM`).val("");
        $(`#txtProdutoDescricao`).val("");
        $(`#txtEstoque`).val("");
        $(`#txtIsentasICMS`).val("");
        $(`#txtIsentasIPI`).val("");
        $(`#txtLote`).val("");
        $(`#txtOutrasICMS`).val("");
        $(`#txtOutrasIPI2`).val("");
        $(`#txtIPI`).val("");
        $(`#txtCST20`).val("");
        $(`#txtQTDE`).val("");
        $(`#txtTam`).val("");
        $(`#txtValorProd`).val("");
        $(`#txtValorCOFINS2`).val("");
        $(`#txtValorCredSN`).val("");
        $(`#txtValorDifAliq`).val("");
        $(`#txtValorPIS`).val("");
        $(`#txtValorProd`).val("");
        $(`#txtValorSTCalc`).val("");
        $(`#txtValorICMS`).val("");
        $(`#txtValorST`).val("");
        $(`#txtValorIPI2`).val("");
        $(`#txtNumeroFCI`).val("");
        $(`#txtInfAdProd`).val("");
        $("#txtPercICMS").val("");
        $(`#txtCredSN`).val("");
        $(`#txtCST20`).val("");
        $(`#txtCSTICMS`).val("");
        $(`#txtPercentIPI`).val("");
        $("#txtCSTPIS").val("");
        $(`#DtFabricacao`).val("");
        $(`#txtDtValidaEstoque`).val("");
        $("#manterDigitado").prop("checked", false);
      }
    }

    async function transfereItensGrid(linhaSelecionada) {
      try {
        $.LoadingOverlay("show");

        let table = $(`#${tabela.idTabela}`).DataTable();
        let data = table.row(linhaSelecionada).data();

        $("#txtPercICMS").val(data[66]);
        $("#txtCSTIPI").val(data[24]);
        $("#txtNCM").val(data[45]);
        $("#txtNumeroFCI").val(data[71]);
        $("#txtAliquotaCOFINS").val(data[13]);
        $("#txtAliquotaPIS").val(data[14]);
        $("#txtDifAliq").val(data[16]);
        $("#txtBaseCOFINS3").val(data[17]);
        $("#txtBasePIS").val(data[18]);
        $("#txtBaseIPI2").val(data[19]);
        $("#txtBaseST").val(data[20]);
        $("#txtBaseSTCalc").val(data[21]);
        $("#txtBaseICMS").val(data[22]);
        $("#txtIsentasIPI").val(data[23]);
        $("#txtIsentasICMS").val(data[25]);
        $("#txtOutrasICMS").val(data[27]);
        $("#txtOutrasIPI2").val(data[28]);
        $("#txtValorICMS").val(data[31]);
        $("#txtValorSTCalc").val(data[32]);
        $("#txtValorCredSN").val(data[33]);
        $("#txtValorDifAliq").val(data[34]);
        $("#txtValorST").val(data[35]);
        $("#txtValorIPI2").val(data[36]);
        $("#txtValorPIS").val(data[37]);
        $("#txtValorCOFINS2").val(data[38]);
        $(`#txtInfAdProd`).val(data[72]);
        $(`#txtCredSN`).val(data[73]);
        $(`#txtCST20`).val(data[74]);
        $(`#txtCSTICMS`).val(data[75]);
        $(`#txtPercentIPI`).val(data[76]);
        $("#txtCSTPIS").val(data[57]);
        $("#txtCSTCofins").val(data[58]);
        $(`#DtFabricacao`).val(data[77] != "" ? data[77] : "1899-12-30");
        $(`#txtDtValidaEstoque`).val(data[78] != "" ? data[78] : "1899-12-30");
        if (data[79] == "S") {
          $("#manterDigitado").prop("checked", true);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
    $("#btnGravaEdicao").unbind("click");
    $("#btnGravaEdicao").on("click", async function () {
      let table = $(`#${tabela.idTabela}`).DataTable();
      let data = table.row(linhaSelecionada).data();
      let valorInputProduto = $(
        $(`.${tabela.inputCodigo}`)[linhaSelecionada]
      ).val();

      if ($("#manterDigitado").prop("checked")) {
        data[79] = "S";
      } else {
        data[79] = "N";
      }

      let precoTotal = 0;
      let qtdeTotal = 0;
      let icms = $(".txtICMS")[linhaSelecionada].value;
      let ipi = $(".txtIPI")[linhaSelecionada].value;
      let ncm = $(".txtNCM")[linhaSelecionada].value;
      let cfop = $(".txtCFOP")[linhaSelecionada].value;
      let preco = $(".txtPreco")[linhaSelecionada].value;
      let qtde = $(".txtQtde")[linhaSelecionada].value;

      precoTotal = + precoTotal + preco;
      qtdeTotal = +qtdeTotal + qtde;

      if (data[79] == "S") {
        data[24] = $("#txtCSTIPI").val();
        data[45] = $("#txtNCM").val();
        data[13] = $("#txtAliquotaCOFINS").val();
        data[14] = $("#txtAliquotaPIS").val();
        data[16] = $("#txtDifAliq").val();
        data[17] = $("#txtBaseCOFINS3").val();
        data[18] = $("#txtBasePIS").val();
        data[19] = $("#txtBaseIPI2").val();
        data[20] = $("#txtBaseST").val();
        data[21] = $("#txtBaseSTCalc").val();
        data[22] = $("#txtBaseICMS").val();
        data[23] = $("#txtIsentasIPI").val();
        data[25] = $("#txtIsentasICMS").val();
        data[27] = $("#txtOutrasICMS").val();
        data[28] = $("#txtOutrasIPI2").val();
        data[31] = $("#txtValorICMS").val();
        data[32] = $("#txtValorSTCalc").val();
        data[33] = $("#txtValorCredSN").val();
        data[34] = $("#txtValorDifAliq").val();
        data[35] = $("#txtValorST").val();
        data[36] = $("#txtValorIPI2").val();
        data[37] = $("#txtValorPIS").val();
        data[38] = $("#txtValorCOFINS2").val();
        data[55] = $($(`.${tabela.inputCodigo}`)[linhaSelecionada])
          .val()
          .split(" ")
          .shift();
        data[56] = $("#txtFornecedor").val();
        data[57] = $("#txtCSTPIS").val();
        data[58] = $("#txtCSTCofins").val();
        data[59] = $("#txtCSTIPI").val();
        data[62] = $("#txtDeposito").val();
        data[63] = $(`#txtProdutoDescricao`).val();
        data[66] = $("#txtPercICMS").val();
        data[69] = $(`#txtNotaFiscal`).val();
        data[70] = $("#txtCSTICMS").val();
        data[71] = $(`#txtNumeroFCI`).val();
        data[72] = $(`#txtInfAdProd`).val();
        data[73] = $(`#txtCredSN`).val();
        data[74] = $(`#txtCST20`).val();
        data[75] = $(`#txtCSTICMS`).val();
        data[76] = $(`#txtPercentIPI`).val();
        data[77] = $(`#DtFabricacao`).val();
        data[78] = $(`#txtDtValidaEstoque`).val();

        $(`#${tabela.idTabela}`)
          .DataTable()
          .row(linhaSelecionada)
          .data(data)
          .draw(false);
        $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).val(valorInputProduto);

        await addItensSequencia(Produto);

        $(".txtICMS")[linhaSelecionada].value = $("#txtPercICMS").val();
        $(".txtIPI")[linhaSelecionada].value = $(`#txtPercentIPI`).val();
      } else {
        data[77] = $(`#DtFabricacao`).val();
        data[78] = $(`#txtDtValidaEstoque`).val();

        $(`#${tabela.idTabela}`)
          .DataTable()
          .row(linhaSelecionada)
          .data(data)
          .draw(false);
        $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).val(valorInputProduto);

        await addItensSequencia(Produto);

        $(".txtICMS")[linhaSelecionada].value = icms;
        $(".txtIPI")[linhaSelecionada].value = ipi;
      }

      $(".txtNCM")[linhaSelecionada].value = ncm;
      $(".txtCFOP")[linhaSelecionada].value = cfop;
      $(".txtPreco")[linhaSelecionada].value = preco;
      $(".txtQtde")[linhaSelecionada].value = qtde;

      $(`#${tabela.modalEditar}`).modal("hide");


      await atualizaInputTotal(precoTotal.slice(1), qtdeTotal.slice(1));
      if ($("#txtNSU").val() != '') {
        try {
          const xml = await buscaValor('XML_NOTAS', 'ARQUIVO', 'CHAVE_NFE', `${$("#txtNSU").val()}' AND OPERACAO = 'E`);
          if (xml.ARQUIVO != '') {//valida se a entrada foi por xml para desabilitar os campos
            $($(".btn-exclui-Prod")[linhaSelecionada]).prop("disabled", true);
            $($(".addProduto")[linhaSelecionada]).prop("disabled", true);
            $($(".txtQtde")[linhaSelecionada]).prop("disabled", true);
            $($(".txtPreco")[linhaSelecionada]).prop("disabled", true);
          }
        } catch (error) {
          console.log(error);
        }
      }
    });

    async function atualizaInputTotal(sPreco, sQtde) {
      let inputPreco = parseFloat($('#txtPrecoTot').html());
      let inputQtde = parseFloat($('#txtQtdeTot').html());

      inputPreco = inputPreco + parseFloat(sPreco);
      inputQtde = inputQtde + parseFloat(sQtde);

      $('#txtPrecoTot').html(mantemDuasCasasDecimais(inputPreco, 3));
      $('#txtQtdeTot').html(mantemDuasCasasDecimais(inputQtde, 3));
    }

    async function retornaColunas(sNomeColuna) {
      return Colunas.indexOf(sNomeColuna);
    }

    $(`.${tabela.btnConsulta}`).unbind("click");
    $(`.${tabela.btnConsulta}`).on("click", function () {
      linhaSelecionada = table.row($(this).closest("tr"))[0][0];

      let tabelaProdutos = $(`#${tabela.idTabPesquisa}`).DataTable({
        paging: true,
        filter: false,
        info: true,
        order: false,
        autoWidth: true,
        destroy: true,
        keys: true,
        // "scrollY": "200px",
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
      });

      tabelaProdutos.clear().draw();

      $(`#${tabela.modalPesquisa}`).modal("show");
      $("#txtProdutoCodigo").val("");
      $("#txtProdutoDescricao").val("");
    });

    $(`.${tabela.inputCodigo}`).unbind("keyup");
    $(`.${tabela.inputCodigo}`).keyup(function (e) {
      if (e.keyCode == 115) {
        linhaSelecionada = table.row($(this).closest("tr"))[0];
        $(`.${tabela.btnConsulta}`).trigger("click");
      }
    });

    $(`.${tabela.btnConfirmaConsultar}`).unbind("keypress");
    $(`#${tabela.btnConfirmaConsultar}`).on("keypress", function () {
      $(`#${tabela.btnConfirmaConsultar}`).trigger("click");
    });

    $(`#${tabela.btnConfirmaConsultar}`).unbind("click");
    $(`#${tabela.btnConfirmaConsultar}`).on("click", async function () {
      await buscaProdutos();
    });

    $(`.${tabela.classbtnEditar}`).unbind("click");
    $(`.${tabela.classbtnEditar}`).on("click", async function () {
      linhaSelecionada = table.row($(this).closest("tr"))[0];
      if ($($(`.${tabela.inputCodigo}`)[linhaSelecionada]).val() == "") {
        msgAlerta("Informe um Produto");
        return;
      }
      let data = $($(`.${tabela.inputCodigo}`)[linhaSelecionada])
        .val()
        .split(" ")
        .shift();

      await limpaCamposEdt(true);
      await buscarInformacaoProduto(data, $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr('data-tipo'));
      await transfereItensGrid(linhaSelecionada);

      $(`#${tabela.modalEditar}`).modal("show");
    });

    $("#btn-limpa-Produto").on("click", async function () {
      await limpaCamposEdt(false);
    });

    $(`#${tabela.idTabPesquisa} tbody`).unbind("click");
    $(`#${tabela.idTabPesquisa} tbody`).on("dblclick", "tr", function () {
      document.firstElementChild.style.zoom = "reset";
      $(`#${tabela.idTabPesquisa}`)
        .dataTable()
        .$("tr.selected")
        .removeClass("selected");
      $(this).addClass("selected");
      $(`#${tabela.btnConfirmarItem}`).click();
    });

    $(`#${tabela.btnConfirmarItem}`).unbind("click");
    $(`#${tabela.btnConfirmarItem}`).click(async function () {
      let table = $(`#${tabela.idTabela}`).DataTable();
      let data = $(`#${tabela.idTabPesquisa}`)
        .dataTable()
        .api()
        .row(".selected")
        .data();
      let data2 = table.rows(linhaSelecionada).data();

      if (($("#txtProdutoCodigo").val() != "") && $('#radioProduto').is(':checked')) {
        let jsonStr = await buscarInformacaoProduto(data.CODIGO, $('#radioProduto').is(':checked') ? 'P' : 'M');

        data2[await retornaColunas("CODFIS")] = jsonStr[0].CODFIS;
        data2[await retornaColunas("CODIGO2")] = jsonStr[0].CODIGO2;
        data2[await retornaColunas("CODIPI")] = jsonStr[0].CODIPI;
        data2[await retornaColunas("CODTRIB")] = jsonStr[0].CODTRIB;
        data2[await retornaColunas("COD_REGRA")] =
          jsonStr[0].COD_REGRA;
        data2[await retornaColunas("COMPRI")] = jsonStr[0].COMPRI;
        data2[await retornaColunas("DEPOSITO")] = jsonStr[0].DEPOSITO;
        data2[await retornaColunas("DESCNCM")] = jsonStr[0].DESCNCM;
        data2[await retornaColunas("DESCRICAO")] =
          jsonStr[0].DESCRICAO;
        data2[await retornaColunas("ESTOQUE")] = jsonStr[0].ESTOQUE;
        data2[await retornaColunas("LARGURA")] = jsonStr[0].LARGURA;
        data2[await retornaColunas("LOCAL")] = jsonStr[0].LOCAL;
        data2[await retornaColunas("TIPO_VENDA")] =
          jsonStr[0].TIPO_VENDA;
        data2[await retornaColunas("TP_BAIXA")] = jsonStr[0].TP_BAIXA;
        data2[await retornaColunas("TRIBUTACAO")] =
          jsonStr[0].TRIBUTACAO;
        data2[await retornaColunas("UNIDADE")] = jsonStr[0].UNIDADE;
        data2[60] = data.COR;
        if ($('#radioProduto').is(':checked')) {
          data2[67] = data.TAM;
        }

        $(`#${tabela.idTabela}`)
          .DataTable()
          .rows(linhaSelecionada)
          .data(data2)
          .draw(false);
      }

      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).val(
        `${data.CODIGO} ${data.DESCRICAO} - ${data.COR} ${data.DESC_COR}${$('#radioProduto').is(':checked') ? ` - ${data.TAM}` : ''}`
      );

      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr(
        "data-codigo",
        data.CODIGO
      );
      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr(
        "data-descricao",
        data.DESCRICAO
      );
      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr(
        "data-cor",
        data.COR
      );
      $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr(
        "data-tipo",
        $('#radioProduto').is(':checked') ? 'P' : 'M'
      );
      if ($('#radioProduto').is(':checked')) {
        $($(`.${tabela.inputCodigo}`)[linhaSelecionada]).attr(
          "data-tam",
          data.TAM
        );
      }

      await addItensSequencia(Produto);

      $(`#${tabela.modalPesquisa}`).modal("hide");
    });

    $(".txtPreco, .txtQtde, .txtCFOP").unbind("change");
    $(".txtPreco, .txtQtde, .txtCFOP").change(async function () {
      let linhaatual = table.row($(this).closest("tr"))[0];
      let data = table.row(linhaatual).data();
      linhaSelecionada = table.row($(this).closest("tr"))[0];

      if (
        $(".txtPreco")[linhaatual].value != "0.00" &&
        $(".txtPreco")[linhaatual].value != "" &&
        $(".txtQtde")[linhaatual].value != "0.00" &&
        $(".txtQtde")[linhaatual].value != ""
      ) {
        try {
          $.LoadingOverlay("show");
          try {
            let retorno = await retornaValoresItens(linhaatual);

            $(".txtICMS")[linhaatual].value =
              retorno.itens[0].icms.toFixed(2);
            $(".txtIPI")[linhaatual].value =
              retorno.itens[0].perc_ipi.toFixed(2);
            $(".txtNCM")[
              linhaatual
            ].value = `[${retorno.itens[0].clafis}] - ${retorno.itens[0].desc_clafis}`;
            $(".txtCFOP")[
              linhaatual
            ].value = `[${retorno.itens[0].natureza}] - ${retorno.itens[0].desc_natureza}`;

            // FISCAL
            data[71] = retorno.itens[0].numero_fci;
            data[72] = retorno.itens[0].inf_prod;
            // ICMS
            data[75] = `[${retorno.itens[0].clatrib}] - ${retorno.itens[0].desc_Clatrib}`;
            data[32] = retorno.itens[0].valor_icmsst_ent.toFixed(2);
            data[21] = retorno.itens[0].base_icmsst_ent.toFixed(2);
            data[20] = retorno.itens[0].base_icms_st.toFixed(2);
            data[22] = retorno.itens[0].base_icms.toFixed(2);
            data[66] = retorno.itens[0].icms.toFixed(2);
            data[27] = retorno.itens[0].outras_icms.toFixed(2);
            data[73] = retorno.itens[0].aliq_simples.toFixed(2);
            data[33] = retorno.itens[0].val_cred_simples.toFixed(2);
            data[35] = retorno.itens[0].vlr_icms_st.toFixed(2);
            data[74] = retorno.itens[0].perc_icms_reduz.toFixed(2);
            data[31] = retorno.itens[0].vlr_icms.toFixed(2);
            data[25] = retorno.itens[0].isenta_icms.toFixed(2);
            data[16] = retorno.itens[0].aliq_dif.toFixed(2);
            data[34] = retorno.itens[0].val_icms_dif.toFixed(2);
            // IPI
            data[24] = `[${retorno.itens[0].codipi}] - ${retorno.itens[0].desc_codipi}`;
            data[19] = retorno.itens[0].base_ipi.toFixed(2);
            data[76] = retorno.itens[0].perc_ipi.toFixed(2);
            data[36] = retorno.itens[0].vlr_ipi.toFixed(2);
            data[28] = retorno.itens[0].outras_ipi.toFixed(2);
            data[23] = retorno.itens[0].isenta_ipi.toFixed(2);
            // PIS
            data[57] = `[${retorno.itens[0].cla_pis}] - ${retorno.itens[0].desc_cla_pis}`;
            data[18] = retorno.itens[0].base_pis.toFixed(2);
            data[14] = retorno.itens[0].aliq_pis.toFixed(2);
            data[37] = retorno.itens[0].val_pis.toFixed(2);
            // COFINS
            data[58] = `[${retorno.itens[0].cla_cofins}] - ${retorno.itens[0].desc_cla_cofins}`;
            data[17] = retorno.itens[0].base_cofins.toFixed(2);
            data[13] = retorno.itens[0].aliq_cofins.toFixed(2);
            data[38] = retorno.itens[0].val_cofins.toFixed(2);

            transfereItensGrid(linhaSelecionada);
            $("#btnGravaEdicao").trigger("click");
          } catch (error) {
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      }
    });
    
    function atualizaItensReferenciados() {
      let arrayCodigos = [];
      let arrayCores = [];
      let arrayTamanhos = [];
  
      const data = $('#tabelaItensReferenciados').DataTable().data().toArray();
  
      for (let i = 0; i < data.length; i++) {
        arrayCodigos.push(data[i].CODIGO);
        arrayCores.push(data[i].COR);
        arrayTamanhos.push(data[i].TAM)
      }
  
      for (let i = 0; i < $('.txtProduto').length; i++) {
        if ($($('.txtProduto')[i]).attr("data-tipo") == 'P') {
          if ((arrayCodigos.indexOf($($('.txtProduto')[i]).attr("data-codigo")) != -1)
            && (arrayCores.indexOf($($('.txtProduto')[i]).attr("data-cor")) != -1)
            && (arrayTamanhos.indexOf($($('.txtProduto')[i]).attr("data-TAM")) != -1)) {
            $($('.contador')[i]).css('background-color', 'rgb(65,193,57)');
          } else {
            $($('.contador')[i]).css('background-color', 'rgb(220,53,69)');
          }
        } else {
          if ((arrayCodigos.indexOf($($('.txtProduto')[i]).attr("data-codigo")) != -1)
            && (arrayCores.indexOf($($('.txtProduto')[i]).attr("data-cor")) != -1)) {
            $($('.contador')[i]).css('background-color', 'rgb(65,193,57)');
          } else {
            $($('.contador')[i]).css('background-color', 'rgb(220,53,69)');
          }
        }
      }
    }

    $('.txtPreco, .txtQtde, .txtCFOP').on('blur', function () {
      setTimeout(() => {
        atualizaItensReferenciados();
      }, 700)
    })

    async function buscarInformacaoProduto(codigo, tipo = 'P') {
      try {
        $.LoadingOverlay("show");
        try {
          sEmpresa = getCookie("empresa");

          let response = await requisicao(
            "GET",
            "/Sisplan/EntradaNF/V1/BuscaItem?",
            `CODIGO=${codigo}&EMP_PAT=${sEmpresa}&TIPO=${tipo}`,
            null
          );

          if (!response) {
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro("Erro ao Buscar as Informações dos Produtos");
        }
      } finally {
        $.LoadingOverlay("hide");
        // eslint-disable-next-line no-unsafe-finally
        return jsonStr;
      }
    }

    $('#radioProduto, #radioMaterial').unbind("change");
    $('#radioProduto, #radioMaterial').on('change', async function () {
      $(`#${tabela.idTabPesquisa}`).DataTable().destroy();
      $(`#${tabela.idTabPesquisa}`).empty();
      await buscaProdutos();
    });

    async function buscaProdutos() {
      let sCodigo = $("#txtProdutoCodigo").val();
      let sDescricao = $("#txtProdutoDescricao").val().toUpperCase();
      let sWhere = "";
      let urlRequisicao = `/sisplan/funcoes/v1/pesquisa?`;
      let paramsRequisicao;

      if ($('#radioProduto').is(':checked')) {
        if (sCodigo != "") {
          sWhere = `AND PA_ITEN.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `;
        }
        if (sDescricao != "") {
          sWhere += `AND UPPER(PRODUTO.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]')`;
        }
        paramsRequisicao = `JSON={
                "tabela":"pa_iten",
                "camposSelect":["pa_iten.codigo",  "replace(produto.descricao, '-', '') descricao", "pa_iten.cor", "cadcor.descricao desc_cor", "pa_iten.tam" ],
                "leftjoin": [{"tabela" : "produto", "condicao" : "produto.codigo = pa_iten.codigo"}, 
                             {"tabela" : "cadcor", "condicao" : "cadcor.cor= pa_iten.cor"},
                             {"tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam"}],
                "groupby": [ "pa_iten.codigo",  "produto.descricao", "pa_iten.cor", "cadcor.descricao", "pa_iten.tam", "faixa_iten.posicao" ],
                "orderby": [ "pa_iten.codigo", "pa_iten.cor", "faixa_iten.posicao" ],"where": ["1=1 ${sWhere}"], "limit": 1000}`;

      } else {
        if (sCodigo != "") {
          sWhere = `AND MAT_ITEN.CODIGO LIKE ('[PERCENTUAL]${sCodigo}[PERCENTUAL]') `;
        }
        if (sDescricao != "") {
          sWhere += `AND UPPER(MATERIAL.DESCRICAO) LIKE ('[PERCENTUAL]${sDescricao}[PERCENTUAL]')`;
        }
        paramsRequisicao = `JSON={
                "tabela":"mat_iten",
                "camposSelect":["mat_iten.codigo",  "replace(material.descricao, '-', '') descricao", "mat_iten.cor", "cadcor.descricao desc_cor"],
                "leftjoin": [{"tabela" : "material", "condicao" : "material.codigo = mat_iten.codigo"}, 
                             {"tabela" : "cadcor", "condicao" : "cadcor.cor = mat_iten.cor"}],
                "groupby": [ "mat_iten.codigo",  "material.descricao", "mat_iten.cor", "cadcor.descricao" ],
                "orderby": [ "mat_iten.codigo", "mat_iten.cor" ],"where": ["1=1 ${sWhere}"], "limit": 1000}`;
      }
      let dataSet = [];
      let dataSetCols = [];
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            urlRequisicao,
            paramsRequisicao,
            null,
            20000
          );

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          if (!$.isEmptyObject(jsonStr.RESULT[0])) {
            dataSet = jsonStr.RESULT[0];
            let keys = Object.keys(dataSet[0]);

            keys.forEach((value) => {
              dataSetCols.push({
                title: value,
                data: value,
              });
            });

            tabelaProdutos = $(`#${tabela.idTabPesquisa}`).DataTable({
              paging: true,
              filter: false,
              info: true,
              order: false,
              autoWidth: true,
              destroy: true,
              keys: true,
              // "scrollY": "200px",
              language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                  sNext: "Próximo",
                  sPrevious: "Anterior",
                  sFirst: "Primeiro",
                  sLast: "Último",
                },
                oAria: {
                  sSortAscending: ": Ordenar colunas de forma ascendente",
                  sSortDescending: ": Ordenar colunas de forma descendente",
                },
              },
              columns: dataSetCols,
              data: dataSet,
            });

            $(`#${tabela.idTabPesquisa} tbody`).unbind("click");
            $(`#${tabela.idTabPesquisa} tbody`).on("click", "tr", function () {
              $(`#${tabela.idTabPesquisa}`)
                .dataTable()
                .$("tr.selected")
                .removeClass("selected");
              $(this).addClass("selected");
            });

            $(`#${tabela.idTabPesquisa} tbody`).unbind("dblclick");
            $(`#${tabela.idTabPesquisa} tbody`).on(
              "dblclick",
              "tr",
              function () {
                document.firstElementChild.style.zoom = "reset";
                $(`#${tabela.idTabPesquisa}`)
                  .dataTable()
                  .$("tr.selected")
                  .removeClass("selected");
                $(this).addClass("selected");
                $(`#${tabela.btnConfirmarItem}`).click();
              }
            );
          }
        } catch (error) {
          console.error(error);
          msgErro("Não foi possível buscar os dados do produto.");
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }
  // fim da funcao additenssequencia

  let Produto = {};
  Produto.idTabela = "tabelaAddProduto"; // tabela principal do item
  Produto.idTabPesquisa = "tabelaProdutos"; // tabela de consulta
  Produto.classbtnExcluir = "btn-exclui-Prod"; // botao para excluir a linha
  Produto.classbtnEditar = "btn-edit"; // botao para editar o item
  Produto.inputCodigo = "txtProduto";
  Produto.btnConsulta = "btn-Produto"; //
  Produto.btnConfirmaConsultar = "btnConsultarProduto";
  Produto.contador = "itemProd";
  Produto.addLinha = "addProduto";
  Produto.modalEditar = "modalEditarProduto";
  Produto.modalPesquisa = "modalProduto";
  Produto.btnConfirmarItem = "btn_confirmar_produto";
  Produto.numeroColunasInvisivel = [
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
    67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
  ];
  Produto.campos = [
    `<div class="itemProd contador" style="margin-left: 7px">1</div>`,
    `<td>
        <div class="input-group" style="min-width: 270px;">
            <input type="text" class="input-default focus form-control txtProduto" name="txtProduto" placeholder="Produto (F4 para pesquisar)" style="min-width: 180px;" readonly>
            <div class="input-group-append">
                <a class="btn-Produto">
                    <i class="fas fa-search text-red" style="font-weight: bold;margin-left: 10px;margin-right: 10px;font-size: 18px;"></i>
                </a>
            </div>
        </div>
    </td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtQtde" min="0" name="txtQtde" placeholder="Quantidade"></td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtPreco" min="0" name="txtPreco" placeholder="Preço"></td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtCFOP" min="0" name="txtCFOP" placeholder="CFOP"></td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtIPI" min="0" value="0.00" name="txtIPI" placeholder="IPI %"></td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtICMS" min="0" value="0.00" name="txtICMS" placeholder="ICMS %"></td>`,
    `<td><input type="text" style="max-width: 101px;" class="input-default focus form-control txtNCM" min="0" name="txtNCM" placeholder="NCM"></td>`,
    `<div>
        <div class="btn-group grupo_botao item-exclui float-left" role="group" aria-label="Basic example">
            <button type="button" class="btn btn-opcao bg-light nofocus btn-edit" style="border: 1px solid var(--blue-color)">
                <i class="fas fa-edit text-red" style="font-weight: bold;margin: 0 12px 0 14px; font-size: 18px;"></i>
            </button>
            <button type="button" class="btn btn-opcao bg-light nofocus btn-exclui-Prod" style="border: 1px solid var(--blue-color)">
                <i class="fas fa-trash text-red" style="font-weight: bold; margin: 0 14px 0 14px; font-size: 18px;"></i>
            </button>
        </div>
    </div>`,
    `<button type="button" class="adicionar addProduto nofocus" style="border: 1px solid var(--blue-color)"><i class="fas fa-plus"></i></button>`,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
    ``,
  ];
  addItensSequencia(Produto);
});
