$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if (Element.node.id == "gravar") {
          $(".driver-next-btn").on("click", location.reload());
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == "formcard1") {
          $(".driver-close-btn").on("click", location.reload());
        }
      },
    });

    driver.defineSteps([
      {
        element: "#campostuor",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#checkAtivo",
        popover: {
          title: "Ativo",
          description:
            "Aqui, definimos a coleção como ativa.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para a Coleção.",
          position: "top",
        },
      },
      {
        element: "#txtMeta",
        popover: {
          title: "Meta",
          description:
            "Neste campo, adicionamos a meta da Coleção.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a coleção.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $("#txtTaxaCartao").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#checkAtivo").attr("checked", true);

  $(document).ready(function () {
    $("#txtMeta").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("COLECAO", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/colecao`;
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let colecao = parametros[parametros.length - 1];

  if (colecao != "" && colecao != "create") {
    if ((await liberarRegistro("COLECAO", colecao)) == false) {
      window.location.href = "../colecao";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"colecao", 
                    "camposSelect":["codigo", "descricao", "ativo", "replicacao", "meta", "dt_inicio", "dt_final"], 
                    "where": ["codigo = '${colecao}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
          $("#txtMeta").val(jsonStr.RESULT[0][0].META);
          $("#txtDataInicio").val(jsonStr.RESULT[0][0].DT_INICIO);
          $("#txtDataFim").val(jsonStr.RESULT[0][0].DT_FINAL);

          if (jsonStr.RESULT[0][0].ATIVO == "S") {
            $("#checkAtivo").prop("checked", true);
          } else {
            $("#checkAtivo").prop("checked", false);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let colecaoClasse = {};

        colecaoClasse.CODIGO =
          $("#txtCodigo").val() == ""
            ? await RetornaProximo("colecao", "colecao", "CODIGO", 2)
            : $("#txtCodigo").val();
        colecaoClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        colecaoClasse.META = $("#txtMeta").val();
        colecaoClasse.DT_INICIO = pegaValor('#txtDataInicio') == '' ? '1200-01-01' : pegaValor('#txtDataInicio');
        colecaoClasse.DT_FINAL = pegaValor('#txtDataFim') == '' ? '2500-12-31' : pegaValor('#txtDataFim');        

        if ($("#checkAtivo").prop("checked")) {
          colecaoClasse.ATIVO = "S";
        } else {
          colecaoClasse.ATIVO = "N";
        }

        let response = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/colecao?",
          `JSON=${encodeURIComponent(JSON.stringify(colecaoClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(
            `Cadastro efetuado com sucesso!
                         Coleção: ${colecaoClasse.CODIGO}`,
            "Confirmação",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/colecao`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
