/* eslint-disable camelcase */
async function avancarPag() {
    if ($("#txtDescricao").val() == '') {
        $("#txtDescricao").val(' ');
    }
    if ($("#txtTipo").val() == '') {
        $("#txtTipo").val('Normal');
    }
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'checkTour') {
                    $('#voltar').trigger('click');
                };
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#codigotuto',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#desctuto',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro.',
                position: 'top'
            }
        },
        {
            element: '#tipotabelatuto',
            popover: {
                title: 'Tipo',
                description: 'Aqui selecionamos o tipo para a classe gerencial.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#checkTour',
            popover: {
                title: 'Opções',
                description: 'Aqui estão algumas configurações da classe gerencial.',
                position: 'right'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique nesse botão para gravar a classe gerencial.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    $('#txtCodigo').attr('maxlength', 6)

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let classe = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/classegerencial`;
    });

    let current_fs; let next_fs; let previous_fs; // fieldsets
    let opacity;

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricao: {
                required: true,
            },
            txtTipo: {
                required: true,
            }
        },
        messages: {
            txtDescricao: {
                required: "Informe uma descrição válida."
            },
            txtTipo: {
                required: "Selecione um tipo válido."
            }

        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    $(".next").click(function () {

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            current_fs = $(this).parent();
            next_fs = $(this).parent().next();

            $("#progressbar li").eq($("fieldset").index(next_fs)).addClass("active");

            next_fs.show();
            current_fs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    current_fs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    next_fs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        }
    });

    $(".previous").click(function () {

        current_fs = $(this).parent();
        previous_fs = $(this).parent().prev();

        $("#progressbar li").eq($("fieldset").index(current_fs)).removeClass("active");
        previous_fs.show();
        current_fs.animate({
            opacity: 0
        }, {
            step(now) {
                opacity = 1 - now;
                current_fs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previous_fs.css({
                    'opacity': opacity
                });
            },
            duration: 600
        });
    });

    $('#txtConta').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO chave", "CONTA descricao"], "where": null}`);
    $('#btnConta').pesquisa('#txtConta', 'CODIGO', 'CONTA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "CONTA"]}`, 'Pesquisa Conta', 'CONTA_CONT');
    $('#btnExcluiConta').on('click', function () { $('#txtConta').val(''); });

    $('#txtResponsavel').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": null}`);
    $('#btnResponsavel').pesquisa('#txtResponsavel', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Responsável', 'ACESSO_USUARIOS');
    $('#btnExcluiResponsavel').on('click', function () { $('#txtResponsavel').val(''); });

    $('#txtClasseTitulo').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["TP_CONTA = 'T'"]}`);
    $('#btnClasseTitulo').pesquisa('#txtClasseTitulo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["TP_CONTA = 'T'"]}`, 'Pesquisa Classe Título', 'CLASSE_GER');
    $('#btnLimpaClasseTitulo').on('click', function () { $('#txtClasseTitulo').val(''); });

    if (classe != '' && classe != 'create') {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"CLASSE_GER", 
                            "camposSelect":["CLASSE_GER.CONTA", "CLASSE_GER.DESCRICAO", "CLASSE_GER.OPERACAO", "ACESSO_USUARIOS.NOME",
                                            "CLASSE_GER.TIPO", "CLASSE_GER.TP_CONTA", "CLASSE_GER.LANCA_RATEIO", "CLASSE_GER.RESPONSAVEL", 
                                            "CLASSE_GER.TP_CUSTO", "CLASSE_GER.IMPORTACAO", "CLASSE_GER.ATIVO", "CLASSE_GER.COD_CONTA",
                                            "CLASSE_GER.AGRUPAMENTO", "CLASSE_GER.CONTA_TITULO"], 
                            "leftjoin": [{"tabela": "ACESSO_USUARIOS", "condicao": "CLASSE_GER.RESPONSAVEL = ACESSO_USUARIOS.CODIGO"}],
                            "where": ["CLASSE_GER.CODIGO = '${classe}'"]}`, null);
                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                jsonStr = jsonStr.RESULT[0][0];

                $('#txtCodigo').val(classe);
                $('#txtDescricao').val(jsonStr.DESCRICAO);
                insereValor(jsonStr.COD_CONTA != '' ? '#txtConta' : '', jsonStr.COD_CONTA, jsonStr.CONTA);
                insereValor(jsonStr.RESPONSAVEL != '' ? '#txtResponsavel' : '', jsonStr.RESPONSAVEL, jsonStr.NOME);
                $('#txtTipo').val(jsonStr.TIPO).change();
                $('#txtAgrupamento').val(jsonStr.AGRUPAMENTO).change();
                jsonStr.TP_CONTA == 'T' ? $('#inputTitulo').prop('checked', true) : $('#inputAnalitica').prop('checked', true);
                jsonStr.OPERACAO == '+' ? $('#inputCredito').prop('checked', true) : $('#inputDebito').prop('checked', true);
                jsonStr.TP_CUSTO == 'F' ? $('#inputFixo').prop('checked', true) : $('#inputVariavel').prop('checked', true);
                $('#checkAtivo').prop('checked', jsonStr.ATIVO == 'S');
                $('#checkImportacao').prop('checked', jsonStr.IMPORTACAO == 'S');
                $('#checkAbrirDist').prop('checked', jsonStr.LANCA_RATEIO == 'S');

                if (jsonStr.TP_CONTA != 'T') {
                    $('#divClasseTitulo').removeClass('d-none')
                }
                insereValor('#txtClasseTitulo', jsonStr.CONTA_TITULO, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: jsonStr.CONTA_TITULO });
                
                
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da classe gerencial: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('input[name="Conta"]').on('change', function (e) {
        if ($('#inputAnalitica').is(':checked')) {
            $('#divClasseTitulo').removeClass('d-none')
        }
        if ($('#inputTitulo').is(':checked')) {
            $('#divClasseTitulo').addClass('d-none')
            $('#txtClasseTitulo').val('')
        }
    })

    $("#btnGravar").click(
        async function () {
            try {
                $.LoadingOverlay("show");

                let objClasse = {
                    CODIGO: $('#txtCodigo').val() == '' ? await RetornaProximo('CLASSE_GER', 'CLASSE_GER', 'CODIGO', 4) : $('#txtCodigo').val(),
                    DESCRICAO: $('#txtDescricao').val().toUpperCase(),
                    COD_CONTA: pegaChave('#txtConta'),
                    RESPONSAVEL: pegaChave('#txtResponsavel'),
                    CONTA: pegaDescricao('#txtConta'),
                    CONTA_TITULO: pegaChave('#txtClasseTitulo'),
                    TIPO: $('#txtTipo').val(),
                    AGRUPAMENTO: $('#txtAgrupamento').val(),
                    TP_CONTA: $('#inputTitulo').prop('checked') ? 'T' : 'A',
                    OPERACAO: $('#inputCredito').prop('checked') ? '+' : '-',
                    TP_CUSTO: $('#inputFixo').prop('checked') ? 'F' : 'V',
                    ATIVO: $('#checkAtivo').prop('checked') ? 'S' : 'N',
                    IMPORTACAO: $('#checkImportacao').prop('checked') ? 'S' : 'N',
                    LANCA_RATEIO: $('#checkAbrirDist').prop('checked') ? 'S' : 'N'
                };

                let response = await requisicao('POST', '/sisplan/cadastros/v1/classegerencial?', `JSON=${encodeURIComponent(JSON.stringify(objClasse))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    'Cadastro efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/classegerencial`;
                    }
                }).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da classe gerencial: ${error}`);
            }
        });
});