/* eslint-disable prefer-destructuring */


$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        };
        if ((Element.node.id == 'avancar2')) {
          $('#avancar2').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'contas') {
          $('#voltar').trigger('click');
        }
        if (Element.node.id == 'tipoDep') {
          $('#voltar2').trigger('click');
        }
        if (Element.node.id == 'configuracao') {
          $('#voltar3').trigger('click');
        }
      }

    });

    driver.defineSteps([{
      element: '#divGeral',
      popover: {
        title: 'Dados de Cadastro Geral',
        description: 'Esses são os campos que você informará os dados gerais de cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigoMarkup',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricaoMarkup',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "top",
      },
    }
    ]);

    driver.start();
  });
});

$(document).ready(async function () {
  function ajustaTabelas() {
    // $("#tabelaIndiceMarkup").DataTable().columns.adjust().draw(false);
    $("#tabelaEstados").DataTable().columns.adjust().draw(false);
    // $("#tabelaOrcamento").DataTable().columns.adjust().draw(false);
    // $("#tabelaGrupoProduto").DataTable().columns.adjust().draw(false);
  }

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let markup = parametros[parametros.length - 1];

  let contaFs = 1;

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CADMARKUP', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/cadmarkup`;
  });

  $('#tabelaIndiceMarkup').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $('#tabelaGrupoProduto').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $('#tabelaEstados').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollY: '150px',
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $('#tabelaOrcamento').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  $(document).ready(async function () {
    let currentFs; let nextFs; let previousFs;
    let opacity;

    $(".next").click(function () {
      contaFs += 1;

      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {

        currentFs = $(this).parent();
        nextFs = $(this).parent().next();

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate({
          opacity: 0
        }, {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              'display': 'none',
              'position': 'relative'
            });
            nextFs.css({
              'opacity': opacity
            });
          },
          duration: 600
        });
      }

      ajustaTabelas();
    });

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtmarkup: {
          required: true,
        },
        txtClasse: {
          required: true,
        },
        txtHistorico: {
          required: true,
        }
      },
      messages: {
        txtmarkup: {
          required: "Informe uma descrição válida.",
        },
        txtClasse: {
          required: "Informe uma classe válida."
        },
        txtHistorico: {
          required: "Informe um histórico válido."
        }

      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $(".previous").click(function () {
      contaFs -= 1;

      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          previousFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    });

    $('#account').on('click', function () {
      if (markup != 'create') {
        if (contaFs == 2) {
          $('#voltar').trigger('click');
        }
        if (contaFs == 3) {
          $('#voltar').trigger('click');
        }
      }
    });

    $('#personal').on('click', function () {
      if (markup != 'create') {
        if (contaFs == 1) {
          $('#avancar1').trigger('click');
          // $($('fieldset')[0]).css('display', 'none');
        }
        if (contaFs = 3) {
          $('#voltar3').trigger('click');
        }
      }
    });

    $('#confirm').on('click', function () {
      if (markup != 'create') {
        if (contaFs == 1) {
          $('#avancar1').trigger('click');
          $('#avancar2').trigger('click');
          $($('fieldset')[0]).css('display', 'none');
          $($('fieldset')[1]).css('display', 'none');
        }
        if (contaFs == 2) {
          $('#avancar2').trigger('click');
          $($('fieldset')[0]).css('display', 'none');
          $($('fieldset')[1]).css('display', 'none');
        }
      }
    });
  });

  $('input').keyup(function () {
    $(this).val($(this).val().toUpperCase());
  });


  const permissaoUsuarioLogado = await permissaoAcessos("CADMARKUP");
  await insereIndiceNaTabela();
  await buscaTributacao();
  await buscaMarkup();

  if ($.fn.DataTable.isDataTable("#tabelaMarkup") &&
    $.fn.DataTable.isDataTable("#tabelaIndice") &&
    $.fn.DataTable.isDataTable("#tabelaTributacao")) {
    $("#tabelaMarkup").DataTable().columns.adjust().draw(false);
    $("#tabelaIndice").DataTable().columns.adjust().draw(false);
    $("#tabelaTributacao").DataTable().columns.adjust().draw(false);
  }

  $('#btnLimpaDolar').on('click', function () { $('#txtDolar').val('') });
  $('#btnLimpaIndice').on('click', function () { $('#txtIndices').val('') });
  $('#btnLimpaEuro').on('click', function () { $('#txtEuro').val('') });
  $('#btnLimpaFixo').on('click', function () { $('#txtFixo').val('') });

  $('#txtIndice').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
  $('#btnIndice').pesquisa('#txtIndice', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Índice', 'CAD_MARKUP');
  $('#btnLimpaIndice').on('click', function () {
    $('#txtIndice').val('');
  });

  $('#txtClienteRef').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", " NOME DESCRICAO"], "where": null}`);
  // $('#btnClienteRef').pesquisa('#txtClienteRef', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');
  $('#btnClienteRef').pesquisa_serverside(['#txtClienteRef'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
  $('#btnLimpaClienteRef').on('click', function () {
    $('#txtClienteRef').val('');
  });

  $('#txtRepresentanteRef').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnRepresentanteRef').pesquisa('#txtRepresentanteRef', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'CODREP');
  $('#btnLimpaRepresentanteRef').on('click', function () {
    $('#txtRepresentanteRef').val('');
  });

  $('#txtUsuarioOrc').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnUsuarioOrc').pesquisa('#txtUsuarioOrc', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Usuários', 'ACESSO_USUARIOS');
  $('#btnLimpaUsuarioOrc').on('click', function () {
    $('#txtUsuarioOrc').val('');
  });

  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnLimpaGrupoProduto').on('click', function () {
    $('#txtGrupoProduto').val('');
  });

  $('#txtCodigoOrigem').autocompleta(1, `JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["EMP_ID='${getCookie('emp_id')}'"]}`);
  $('#btnCodigoOrigem').pesquisa('#txtCodigoOrigem', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAD_MARKUP", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["EMP_ID='${getCookie('emp_id')}'"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnLimpaCodigoOrigem').on('click', function () {
    $('#txtCodigoOrigem').val('')
  });

  $('#btnAbreCadIndice').on('click', function () {
    $('#modalCadIndice').modal('show');
  })
  //IndiceA
  async function buscaIndice(botao = false, indice) {
    let response = '';
    try {
      $.LoadingOverlay("show");
      if (!botao) {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"INDICE_PRECO", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": ["1=1"]}`, null);
      } else {
        response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"INDICE_PRECO", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": ["1=1 AND DESCRICAO='${indice}'"]}`, null);
      }

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr;

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function insereIndiceNaTabela() {
    let data = await buscaIndice(false, '');
    $('#tabelaIndice').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: true,
      destroy: true,
      lengthChange: false,
      serverside: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },

      "autoWidth": false,
      "data": data.RESULT[0],
      "columns": [{
        "data": "CODIGO"
      },
      {
        "data": "DESCRICAO"
      },
      {
        "data": "TIPO"
      }]
    });
  }

  $("#tabelaIndice tbody").on("click", "tr", function () {
    $("#tabelaIndice")
      .dataTable()
      .$("tr.selected")
      .removeClass("selected");
    $(this).addClass("selected");
  });

  async function verificaSeIndiceExiste() {
    let indice = await buscaValor('INDICE_PRECO', 'TIPO', 'TIPO', $('#selectTipoIndice').val());
    let descricao = await buscaValor('INDICE_PRECO', 'DESCRICAO', 'DESCRICAO', $('#txtDescricaoIndice').val());
    if (!!indice && indice.TIPO != '0 - INDICE') {
      throw msgAlerta(`Tipo ${indice.TIPO} já cadastrado, verifique`);
    }

    if (!!descricao) {
      throw msgAlerta(`Índice já cadastrado, verifique`);
    }
  }

  $('#btnGravarIndice').on('click', async function () {
    await verificaSeIndiceExiste();
    $.LoadingOverlay('show');
    try {
      const indice = {
        CODIGO: $('#txtIndice').val() == '' ? await RetornaProximo('INDICE_PRECO', 'INDICE_PRECO', 'CODIGO', 3) : pegaChave('#txtIndice'),
        DESCRICAO: $('#txtDescricaoIndice').val(),
        TIPO: $('#selectTipoIndice').val()
      }

      const response = await requisicao('POST', '/sisplan/markup/v1/indice?', `JSON=${JSON.stringify(indice)}`, 15000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Cadastro efetuado com sucesso!
        Índice: ${indice.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

      await insereIndiceNaTabela(false, '');
      await limpaCamposIndice();

    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#btnCancelarIndice').trigger('click')
    }
  });

  $('#btnAlterarIndice').on('click', function () {
    if ($('#tabelaIndice').DataTable().rows().data().length == 0) {
      throw msgAlerta('Nenhum registro para alterar, verifique!')
    }
    $('#txtDescricaoIndice').attr('readonly', false);
    $('#txtDescricaoIndice').attr('disabled', false);
    $('#selectTipoIndice').attr('readonly', false);
    $('#selectTipoIndice').attr('disabled', false);
    $('#btnExcluirIndice').addClass('d-none');
    $('#btnIncluirIndice').addClass('d-none');
    $('#btnAlterarIndice').addClass('d-none');
    $('#btnGravarIndice').removeClass('d-none');
    $('#btnCancelarIndice').removeClass('d-none');
    limpaCamposIndice();
  });

  $('#btnIncluirIndice').on('click', function () {
    $('#txtDescricaoIndice').attr('readonly', false);
    $('#txtDescricaoIndice').attr('disabled', false);
    $('#selectTipoIndice').attr('readonly', false);
    $('#selectTipoIndice').attr('disabled', false);
    $('#btnExcluirIndice').addClass('d-none');
    $('#btnIncluirIndice').addClass('d-none');
    $('#btnAlterarIndice').addClass('d-none');
    $('#btnGravarIndice').removeClass('d-none');
    $('#btnCancelarIndice').removeClass('d-none');
    limpaCamposIndice();
  });

  $('#btnCancelarIndice').on('click', function () {
    $('#txtDescricaoIndice').attr('readonly', true);
    $('#txtDescricaoIndice').attr('disabled', true);
    $('#selectTipoIndice').attr('readonly', true);
    $('#selectTipoIndice').attr('disabled', true);
    $('#btnExcluirIndice').removeClass('d-none');
    $('#btnIncluirIndice').removeClass('d-none');
    $('#btnAlterarIndice').removeClass('d-none');
    $('#btnGravarIndice').addClass('d-none');
    $('#btnCancelarIndice').addClass('d-none');
    $("#tabelaIndice tr:eq(1)").trigger("click");
    limpaCamposIndice()
  });

  async function limpaCamposIndice() {
    $('#txtId').val('')
    $('#txtIndice').val('');
    $('#txtDescricaoIndice').val('');
    $('#selectTipoIndice').val('0 - INDICE');
    $("#tabelaIndice").dataTable().$("tr.selected").removeClass("selected");
  }

  $('#tabelaIndice').on('click', 'tr', async function () {
    const data = $('#tabelaIndice').DataTable().row($(this)).data();
    $('#txtIndice').val(data.CODIGO);
    $('#txtDescricaoIndice').val(data.DESCRICAO);
    $('#selectTipoIndice').val(data.TIPO);
  });

  $('#btnExcluirIndice').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      let tr = $('#tabelaIndice tr.selected')[0];
      let data = {
        CODIGO: $('#tabelaIndice').DataTable().row($(tr)).data().CODIGO
      }

      let validaSeUtiliza = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_INDICE", "camposSelect":[ "COUNT(*) as QTDE"], "where": ["1=1 AND CODIGO='${data.CODIGO}' AND EMP_ID='${getCookie('emp_id')}'"]}`, 15000);

      let jsonStr = await validaSeUtiliza.json();
      if (jsonStr.RESULT[0][0].QTDE > 0) {
        msgAlerta('Impossivel excluir índice usado nos markups.');
        return;
      }

      const response = await requisicao('DELETE', '/sisplan/markup/v1/indice?', `JSON=${JSON.stringify(data)}`, 15000);

      if (!response) {
        return;
      }

      if (response.status == 200) {
        let tr = $('#tabelaIndice tr.selected')[0];
        const data = $("#tabelaIndice").DataTable().row($(tr));
        data.remove().draw(false);
      }
      await limpaCamposIndice();

    } catch (error) {
      console.log(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  //Markups
  await preencheSelectIndice()

  async function preencheSelectIndice() {
    let data = await buscaIndice(false, '')
    for (let i = 0; i < data.RESULT[0].length; i++) {
      $('#selectTipoIndiceMarkup').append($('<option>', {
        value: data.RESULT[0][i].DESCRICAO,
        text: data.RESULT[0][i].DESCRICAO
      }));
    }
  }

  async function buscaTabelaCadMarkup(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"CAD_MARKUP", "camposSelect":["CAD_MARKUP.DESCRICAO", "CAD_MARKUP.DIAS", "CAD_MARKUP.CODIGO", "CAD_MARKUP.CODCLI", "CAD_MARKUP.CODREP",
        "CAD_MARKUP.PADRAO", "CAD_MARKUP.TAXA", "CAD_MARKUP.QUEBRA", "CAD_MARKUP.FRETE", "CAD_MARKUP.ATIVO", "CAD_MARKUP.CRED_IMP", "CAD_MARKUP.LUCRO_REAL",
        "CAD_MARKUP.QTDE_PECAS", "CAD_MARKUP.CONSUMIDOR_FINAL", "CAD_MARKUP.IE_DESTINATARIO", "CAD_MARKUP.CUSTO_IND_VALOR", "CAD_MARKUP.EMP_ID", "CAD_MARKUP.OBS",
        "ENTIDADE.NOME NOME_CLIENTE", "REPRESEN.NOME NOME_REPRESEN"],
        "leftjoin": [
          {"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = CAD_MARKUP.CODREP"}, 
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = CAD_MARKUP.CODCLI"}
          ], 
        "where": ["1=1", "CAD_MARKUP.CODIGO='${sCodigo}'"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr.RESULT[0][0];

    } catch (err) {
      console.log(err);
    }
  }

  async function buscaTabelaPrecoParam(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"PRECO_PARAM", "camposSelect":["PRECO_PARAM.CODIGO", "PRECO_PARAM.DES_INDICE_E", "PRECO_PARAM.DES_INDICE_N", "PRECO_PARAM.NOME", "PRECO_PARAM.PRAZO_1", "PRECO_PARAM.PRAZO_2", "PRECO_PARAM.PRAZO_3",
        "PRECO_PARAM.PRAZO_4", "PRECO_PARAM.PRAZO_5", "PRECO_PARAM.PRAZO_6", "PRECO_PARAM.PRAZO_7", "PRECO_PARAM.DIAS_PADRAO", "PRECO_PARAM.ETIQUETA", "PRECO_PARAM.COR", 
        "PRECO_PARAM.COLECAO", "PRECO_PARAM.PADRAO", "PRECO_PARAM.MARKUP", "PRECO_PARAM.COFINS", "PRECO_PARAM.COMISAO", "PRECO_PARAM.COMISAO_EXP", "PRECO_PARAM.CONTR_SOCIAL", 
        "PRECO_PARAM.CUSTO_MIN", "PRECO_PARAM.FINANCEIRO", "PRECO_PARAM.FIXO", "PRECO_PARAM.FRETE", "PRECO_PARAM.FRETE_EXP", "PRECO_PARAM.ICMS", "PRECO_PARAM.INDICE_E", 
        "PRECO_PARAM.INDICE_N", "PRECO_PARAM.IRPJ", "PRECO_PARAM.MARGEM", "PRECO_PARAM.MARKTING", "PRECO_PARAM.PERDA", "PRECO_PARAM.TAXA", "PRECO_PARAM.VOLUME", "PRECO_PARAM.COMISSAO1", 
        "PRECO_PARAM.COMISSAO2", "PRECO_PARAM.COMISSAO3", "PRECO_PARAM.COMISSAO4", "PRECO_PARAM.COMISSAO5", "PRECO_PARAM.COMISSAO6", "PRECO_PARAM.MARGEM_1", "PRECO_PARAM.MARGEM_2", 
        "PRECO_PARAM.MARGEM_3", "PRECO_PARAM.MARGEM_4", "PRECO_PARAM.MARGEM_5", "PRECO_PARAM.MARGEM_6", "PRECO_PARAM.MARGEM_7", "PRECO_PARAM.ID_PRE", "PRECO_PARAM.EMP_ID"],
        "where": ["1=1", "PRECO_PARAM.CODIGO='${sCodigo}'"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr.RESULT[0][0];

    } catch (err) {
      console.log(err);
    }
  }

  async function buscaTabelaPrecoIndice(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"PRECO_INDICE", "camposSelect":["PRECO_INDICE.CODCLI", "PRECO_INDICE.CODIGO", "INDICE_PRECO.TIPO", "PRECO_INDICE.DESCRICAO", "PRECO_INDICE.ETIQUETA", 
        "PRECO_INDICE.COR", "PRECO_INDICE.COLECAO", "PRECO_INDICE.RECEITA", "PRECO_INDICE.VARIANTE", "PRECO_INDICE.MARKUP", "PRECO_INDICE.INDICE", "PRECO_INDICE.IND_EXP"],
        "leftjoin": [{"tabela": "INDICE_PRECO", "condicao": "INDICE_PRECO.CODIGO = PRECO_INDICE.CODIGO"}], 
        "where": ["1=1", "PRECO_INDICE.MARKUP='${sCodigo}'"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr.RESULT[0];

    } catch (err) {
      console.log(err);
    }
  }

  async function buscaTabelaUfMarkup(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={
        "tabela":"MARKUP_UF", "camposSelect":["MARKUP_UF.*", "TABUF.DESCRICAO"],
        "leftjoin": [{"tabela": "TABUF", "condicao": "MARKUP_UF.UF = TABUF.CODIGO"}], 
        "orderby": ["TABUF.CODIGO"]
        "where": ["1=1", "MARKUP_UF.CODIGO='${sCodigo}'"]}`, 15000);
      let jsonStr = await response.json();
      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0]
      }

      let response2 = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={
        "tabela":"TABUF", "camposSelect":["TABUF.CODIGO UF", "TABUF.DESCRICAO", "'N' SEL"],
        "orderby": ["TABUF.CODIGO"]}`, 15000);
      let jsonStr2 = await response2.json()
      return jsonStr2.RESULT[0]

    } catch (err) {
      console.log(err);
    }
  }

  async function buscaTabelaMarkupUsuario(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"MARKUP_USUARIO", "camposSelect":["MARKUP_USUARIO.*", "ACESSO_USUARIOS.NOME"], 
        "leftjoin": [
          {"tabela": "ACESSO_USUARIOS", "condicao": "MARKUP_USUARIO.USUARIO = ACESSO_USUARIOS.CODIGO"}
        ], 
        "where": ["1=1", "MARKUP_USUARIO.MARKUP='${sCodigo}' AND MARKUP_USUARIO.EMP_ID=${getCookie('emp_id')}"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr.RESULT[0];

    } catch (err) {
      console.log(err);
    }
  }

  async function buscaTabelaMarkupGrupo(sCodigo) {
    try {
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"MARKUP_GRUPO", "camposSelect":["MARKUP_GRUPO.CODIGO", "MARKUP_GRUPO.GRUPO_PROD", "MARKUP_GRUPO.QTDE_DE", "MARKUP_GRUPO.QTDE_ATE", "GRUPO_PA.DESCRICAO"], 
        "leftjoin": [
          {"tabela": "GRUPO_PA", "condicao": "MARKUP_GRUPO.GRUPO_PROD = GRUPO_PA.CODIGO"}
        ], 
        "where": ["1=1", "MARKUP_GRUPO.CODIGO='${sCodigo}' AND MARKUP_GRUPO.EMP_ID=${getCookie('emp_id')}"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr.RESULT[0];

    } catch (err) {
      console.log(err);
    }
  }

  $('#btnAbrirOrcamento').on('click', function () {
    $('#modalOrcamento-titulo').html('Adicionar Usuários para Orçamento');
    $('#modalOrcamento').modal('show');
  });

  function verificarRegistroDuplicado(novoRegistro) {
    let tabelaOrcamento = $('#tabelaOrcamento').DataTable().column(1).data().toArray()
    for (let i = 0; i < tabelaOrcamento.length; i++) {
      if (novoRegistro === tabelaOrcamento[i]) {
        throw msgAlerta('Usuário já está cadastrado para orçamento, verifique!');
      }
    }
  }

  function retornaBotaoOpcoes() {
    return '<div style="text-align:center; display: flex; gap: 2px;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnRemoverUsuario" type="button"> ' +
      '      Remover' +
      '   </button> ' +
      '</div>'
  };

  $('#btnConfirmaUsuario').on('click', async function () {
    if ($('#txtUsuarioOrc').val() == '') {
      return msgAlerta('Nenhum usuário informado.');
    }

    const codUsuario = pegaChave('#txtUsuarioOrc');
    const descUsuario = pegaDescricao('#txtUsuarioOrc');
    verificarRegistroDuplicado(codUsuario);

    $('#tabelaOrcamento').DataTable().row.add([
      retornaBotaoOpcoes(),
      codUsuario,
      descUsuario,
    ]).draw(false);

    $('#txtUsuarioOrc').val('');
  });

  $('#tabelaOrcamento').on('click', '#btnRemoverUsuario', async function () {
    let table = $('#tabelaOrcamento').DataTable();
    table
      .row($(this).parents('tr'))
      .remove()
      .draw(false);
  });


  if (markup != '' && markup != 'create') {
    $('#account').css('cursor', 'pointer');
    $('#personal').css('cursor', 'pointer');
    $('#confirm').css('cursor', 'pointer');

    try {
      let cadMarkup = await buscaTabelaCadMarkup(markup);
      let precoParam = await buscaTabelaPrecoParam(markup);
      let precoIndice = await buscaTabelaPrecoIndice(markup);
      let ufMarkup = await buscaTabelaUfMarkup(markup);
      let markupUsuario = await buscaTabelaMarkupUsuario(markup);
      let markupGrupo = await buscaTabelaMarkupGrupo(markup);

      $('#txtCodigoMarkup').val(cadMarkup.CODIGO);
      $('#txtDescricaoMarkup').val(cadMarkup.DESCRICAO);
      insereValor('#txtClienteRef', cadMarkup.CODCLI, cadMarkup.NOME_CLIENTE);
      insereValor('#txtRepresentanteRef', cadMarkup.CODREP, cadMarkup.NOME_REPRESEN);
      cadMarkup.IE_DESTINATARIO != '' ? $('#selectIEDestinatario').val(cadMarkup.IE_DESTINATARIO) : $('#selectIEDestinatario').val(0);

      $('#txtJuros').val(cadMarkup.TAXA);
      $('#txtDiasPadrao').val(cadMarkup.DIAS);
      $('#txtQuebra').val(cadMarkup.QUEBRA);
      $('#txtCredImposto').val(cadMarkup.CRED_IMP);
      $('#txtQtdePecas').val(cadMarkup.QTDE_PECAS);
      $('#txtFrete').val(cadMarkup.FRETE);

      cadMarkup.PADRAO == 'S' ? $('#cbPadraoMarkup').prop('checked', true) : $('#cbPadraoMarkup').prop('checked', false);
      cadMarkup.CONSUMIDOR_FINAL == 'S' ? $('#cbConsumidorFinal').prop('checked', true) : $('#cbConsumidorFinal').prop('checked', false);
      cadMarkup.CUSTO_IND_VALOR == 'S' ? $('#cbCustoIndValor').prop('checked', true) : $('#cbCustoIndValor').prop('checked', false);
      cadMarkup.ATIVO == 'S' ? $('#cbAtivo').prop('checked', true) : $('#cbAtivo').prop('checked', false)

      $('#txtObservacao').val(cadMarkup.OBS);

      $('#txtPrazo1').val(precoParam.PRAZO_1);
      $('#txtPrazo2').val(precoParam.PRAZO_2);
      $('#txtPrazo3').val(precoParam.PRAZO_3);
      $('#txtPrazo4').val(precoParam.PRAZO_4);
      $('#txtPrazo5').val(precoParam.PRAZO_5);
      $('#txtPrazo6').val(precoParam.PRAZO_6);
      $('#txtPrazo7').val(precoParam.PRAZO_7);

      $('#txtComissao1').val(precoParam.COMISSAO1);
      $('#txtComissao2').val(precoParam.COMISSAO2);
      $('#txtComissao3').val(precoParam.COMISSAO3);
      $('#txtComissao4').val(precoParam.COMISSAO4);
      $('#txtComissao5').val(precoParam.COMISSAO5);
      $('#txtComissao6').val(precoParam.COMISSAO6);

      $('#txtMargem1').val(precoParam.MARGEM_1);
      $('#txtMargem2').val(precoParam.MARGEM_2);
      $('#txtMargem3').val(precoParam.MARGEM_3);
      $('#txtMargem4').val(precoParam.MARGEM_4);
      $('#txtMargem5').val(precoParam.MARGEM_5);
      $('#txtMargem6').val(precoParam.MARGEM_6);
      $('#txtMargem7').val(precoParam.MARGEM_7);

      precoIndice.map(item => {
        let totalRegistros = $('#tabelaIndiceMarkup').DataTable().data().toArray().length + 1;
        $('#tabelaIndiceMarkup').DataTable().row.add([
          item.CODIGO,
          item.DESCRICAO,
          `<input style="width: 60%;" type="number" id="txtNacional_${totalRegistros}" class="input-default form-control" value="${item.INDICE}">`,
          `<input style="width: 60%;" type="number" id="txtExportacao_${totalRegistros}" class="input-default form-control disabled readonly" value="${item.IND_EXP}">`,
          item.TIPO
        ]).draw(false);
      });

      markupGrupo.map(item => {
        $('#tabelaGrupoProduto').DataTable().row.add([
          item.CODIGO,
          item.GRUPO_PROD,
          item.DESCRICAO,
          item.QTDE_DE,
          item.QTDE_ATE
        ]).draw(false);
      });

      markupUsuario.map(item => {
        $('#tabelaOrcamento').DataTable().row.add([
          retornaBotaoOpcoes(),
          item.USUARIO,
          item.NOME,
        ]).draw(false);
      });

      $('#tabelaEstados').DataTable().rows().remove().draw(false);
      let row = 0;
      for (let i = 0; i < ufMarkup.length; i++) {
        const dados = ufMarkup[i];
        $('#tabelaEstados').DataTable().row.add([botaoSelecionarGrid(dados.SEL, row), `${dados.UF} - ${dados.DESCRICAO}`]).draw(false);
        row++
      }

    } catch (err) {
      console.log(err);
    }
  } else {

    let ufMarkup = await buscaTabelaUfMarkup(markup);

    $('#tabelaEstados').DataTable().rows().remove().draw(false);
    let row = 0;
    for (let i = 0; i < ufMarkup.length; i++) {
      const dados = ufMarkup[i];
      $('#tabelaEstados').DataTable().row.add([botaoSelecionarGrid(dados.SEL, row), `${dados.UF} - ${dados.DESCRICAO}`]).draw(false);
      row++
    }
  }

  function validaIndice(indice) {
    const data = $('#tabelaIndiceMarkup').DataTable().data().toArray()
    for (let i = 0; i < data.length; i++) {
      if (data[i][1] === indice) {
        throw msgAlerta('Índice já cadastrado, verifique.');
      }
    }
  }

  $('#btnIncluirIndiceMarkup').on('click', async function () {
    if ($('#selectTipoIndiceMarkup').val() == '') {
      return;
    }
    validaIndice($('#selectTipoIndiceMarkup').val())
    let totalRegistros = $('#tabelaIndiceMarkup').DataTable().data().toArray().length + 1;
    let indice = await buscaIndice(true, $('#selectTipoIndiceMarkup').val())
    $('#tabelaIndiceMarkup').DataTable().row.add([
      indice.RESULT[0][0].CODIGO,
      indice.RESULT[0][0].DESCRICAO,
      `<input style="width: 60%;" type="number" id="txtNacional_${totalRegistros}" class="input-default form-control" value="">`,
      `<input style="width: 60%;" type="number" id="txtExportacao_${totalRegistros}" class="input-default form-control disabled readonly" value="">`,
      indice.RESULT[0][0].TIPO,
    ]).draw(false);
  });

  function validaDiasPadrao() {
    let controle = 1;
    let compara = 0;
    for (let i = 0; i < $('.cPrazo').length; i++) {
      if ($('#txtDiasPadrao').val() === $('#txtPrazo' + controle).val()) {
        compara++;
      }
      controle++;
    };
    if (compara === 0) {
      throw msgAlerta('Dias padrão não informado em nenhum prazo, impossível continuar.');
    }
  }

  function validaPrazo() {
    let controle = 1;
    let compara = 0;
    if ($('#txtPrazo1').val() === '0') {
      throw msgAlerta('Primeiro prazo não pode ser zero. Impossível continuar.');
    }
    for (let i = 0; i < $('.cPrazo').length; i++) {
      if ($('#txtPrazo' + controle).val() == '') {
        compara++;
      }
      controle++;
    };
    if (compara === 7) {
      throw msgAlerta('Necessário informar algum prazo.');
    }
  }

  $('#btnGravarMarkup').on('click', async function () {
    validaPrazo();
    validaDiasPadrao();

    if (!$('#txtCodigoMarkup').val()) {
      throw msgAlerta('Código não informado, verifique.')
    }
    if (!$('#txtDescricaoMarkup').val()) {
      throw msgAlerta('Descrição não informada, verifique.')
    }

    if (!!await buscaValor('CAD_MARKUP', 'DESCRICAO', 'DESCRICAO', $('#txtDescricaoMarkup').val()) && $('#txtCodigoMarkup') == '') {
      throw msgAlerta('Markup com a Descrição já cadastrada, verifique.')
    }

    $.LoadingOverlay('show');
    try {
      const markup = {
        CODIGO: $('#txtCodigoMarkup').val(),
        DESCRICAO: $('#txtDescricaoMarkup').val(),
        CODCLI: pegaChave('#txtClienteRef'),
        CODREP: pegaChave('#txtRepresentanteRef'),
        IE_DESTINATARIO: $('#selectIEDestinatario').val(),
        TAXA: $('#txtJuros').val(),
        DIAS: $('#txtDiasPadrao').val(),
        QUEBRA: $('#txtQuebra').val(),
        CRED_IMP: $('#txtCredImposto').val(),
        FRETE: $('#txtFrete').val(),
        OBS: $('#txtObservacao').val(),
        QTDE_PECAS: $('#txtQtdePecas').val(),
        PADRAO: $('#cbPadraoMarkup').is(':checked') ? 'S' : 'N',
        ATIVO: $('#cbAtivo').is(':checked') ? 'S' : 'N',
        CONSUMIDOR_FINAL: $('#cbConsumidorFinal').is(':checked') ? 'S' : 'N',
        CUSTO_IND_VALOR: $('#cbCustoIndValor').is(':checked') ? 'S' : 'N',
        EMP_ID: getCookie('emp_id'),
        PrecoParam: paramPrecoParam(),
        Orcamento: paramMarkupUsuario(),
        GrupoProduto: paramGrupoProduto(),
        PrecoIndice: paramPrecoIndice(),
        Estados: paramEstadosMarkup()
      }

      let response = await requisicao('POST', '/sisplan/markup/v1/markup?', '', JSON.stringify(markup), 20000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Markup: ${$('#txtCodigoMarkup').val()}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadmarkup`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (err) {
      console.log(err);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function paramPrecoParam() {
    let arrPrecoParam = [];
    const precoParam = {
      PRAZO_1: $('#txtPrazo1').val(),
      PRAZO_2: $('#txtPrazo2').val(),
      PRAZO_3: $('#txtPrazo3').val(),
      PRAZO_4: $('#txtPrazo4').val(),
      PRAZO_5: $('#txtPrazo5').val(),
      PRAZO_6: $('#txtPrazo6').val(),
      PRAZO_7: $('#txtPrazo7').val(),
      COMISSAO1: $('#txtComissao1').val(),
      COMISSAO2: $('#txtComissao2').val(),
      COMISSAO3: $('#txtComissao3').val(),
      COMISSAO4: $('#txtComissao4').val(),
      COMISSAO5: $('#txtComissao5').val(),
      COMISSAO6: $('#txtComissao6').val(),
      MARGEM_1: $('#txtMargem1').val(),
      MARGEM_2: $('#txtMargem2').val(),
      MARGEM_3: $('#txtMargem3').val(),
      MARGEM_4: $('#txtMargem4').val(),
      MARGEM_5: $('#txtMargem5').val(),
      MARGEM_6: $('#txtMargem6').val(),
      MARGEM_7: $('#txtMargem7').val(),
      EMP_ID: getCookie('emp_id')
    }
    arrPrecoParam.push(precoParam)
    return arrPrecoParam;
  }

  function paramPrecoIndice() {
    let arrPrecoIndice = [];
    i = 1;
    $('#tabelaIndiceMarkup').DataTable().rows().data().map(item => {
      arrPrecoIndice.push({
        CODIGO: item[0],
        MARKUP: $('#txtCodigoMarkup'),
        DESCRICAO: item[1],
        INDICE: $(`#txtNacional_${i}`).val(),
        IND_EXP: $(`#txtExportacao_${i}`).val(),
        TIPO: item[4],
        EMP_ID: getCookie('emp_id')
      })
      i++
    });
    return arrPrecoIndice;
  };

  function paramEstadosMarkup() {
    let arrEstados = [];
    i = 0;
    $('#tabelaEstados').DataTable().rows().data().map(item => {
      arrEstados.push({
        CODIGO: $('#txtCodigoMarkup').val(),
        SEL: isChecked(`#check_col_${i}`) ? 'S' : 'N',
        UF: item[1].split(' ')[0],
      })
      i++
    });
    return arrEstados;
  };

  function paramMarkupUsuario() {
    if ($("#tabelaOrcamento").DataTable().rows()[0].length === 0) {
      return;
    }
    let arrOrcamento = [];
    i = 1;
    $('#tabelaOrcamento').DataTable().rows().data().map(item => {
      arrOrcamento.push({
        MARKUP: $('#txtCodigoMarkup').val(),
        USUARIO: item[1],
      })
      i++
    });
    return arrOrcamento;
  };

  function paramGrupoProduto() {
    if ($("#tabelaGrupoProduto").DataTable().rows()[0].length === 0) {
      return;
    }
    let arrGrupo = [];
    $('#tabelaGrupoProduto').DataTable().rows().data().map(item => {
      arrGrupo.push({
        CODIGO: item[0],
        GRUPO_PROD: item[1],
        QTDE_DE: item[3],
        QTDE_ATE: item[4],
      })
    });
    return arrGrupo;
  };

  $('#btnManutencaoMarkup').on('click', function () {
    bloqueiaCampos(false);
    $('#btnModalDuplicaMarkup').addClass('d-none');
    $('#btnExcluirMarkup').addClass('d-none');
    $('#btnManutencaoMarkup').addClass('d-none');
    $('#btnCancelarMarkup').removeClass('d-none');
    $('#btnGravarMarkup').removeClass('d-none');
  });

  $('#btnCancelarMarkup').on('click', async function () {
    $('#btnModalDuplicaMarkup').removeClass('d-none');
    $('#btnExcluirMarkup').removeClass('d-none');
    $('#btnManutencaoMarkup').removeClass('d-none');
    $('#btnCancelarMarkup').addClass('d-none');
    $('#btnGravarMarkup').addClass('d-none');
    bloqueiaCampos(true)
    let selectedRow = $('#tabelaMarkup tr.selected');
    $('#tabelaMarkup tr').filter(function () {
      return $(this).is(selectedRow);
    }).trigger('click');
  });

  //Indices
  $("#tabelaIndiceMarkup tbody").on("click", "tr", function () {
    $("#tabelaIndiceMarkup").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  $('#btnRemoverIndice').on('click', async function () {
    const data = $("#tabelaIndiceMarkup tr.selected");
    $("#tabelaIndiceMarkup").DataTable().row(data).remove().draw();
  });

  $('#btnIncluirGrupoProduto').on('click', async function () {
    if (!$('#txtGrupoProduto').val()) {
      msgAlerta('Grupo de produto não informado, verifique')
      return;
    }

    if ($('#txtQtdeDe').val() <= 0) {
      msgAlerta('Informe uma quantidade maior que zero')
      return;
    }

    if ($('#txtQtdeAte').val() <= 0) {
      msgAlerta('Informe uma quantidade maior que zero')
      return;
    }

    $('#tabelaGrupoProduto').DataTable().row.add([
      $('#txtCodigoMarkup').val(),
      pegaChave('#txtGrupoProduto'),
      pegaDescricao('#txtGrupoProduto'),
      $('#txtQtdeDe').val(),
      $('#txtQtdeAte').val()
    ]).draw(false);

    $('#txtGrupoProduto').val('');
    $('#txtQtdeDe').val('');
    $('#txtQtdeAte').val('');
  });

  $("#tabelaOrcamento tbody").on("click", "tr", function () {
    $("#tabelaOrcamento").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  $('#btnRemoverGrupoProduto').on('click', function () {
    const data = $("#tabelaGrupoProduto tr.selected");
    $("#tabelaGrupoProduto").DataTable().row(data).remove().draw();
  });

  $("#tabelaMarkup tbody").on("click", "tr", function () {
    $("#tabelaMarkup").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  $("#tabelaGrupoProduto tbody").on("click", "tr", function () {
    $("#tabelaGrupoProduto").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  async function retornaDadosMarkup() {
    try {
      // let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CAD_MARKUP", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, null);
      let response = await requisicao('GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={ 
        "tabela":"CAD_MARKUP", "camposSelect":["CAD_MARKUP.CODIGO", "CAD_MARKUP.DESCRICAO", "CAD_MARKUP.CODREP REPRESENTANTE", "REPRESEN.NOME NOME_REP", "CAD_MARKUP.CODCLI CLIENTE", "ENTIDADE.NOME NOME_CLI"],
        "leftjoin": [
          {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = CAD_MARKUP.CODCLI"}, 
          {"tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = CAD_MARKUP.CODREP"},
          {"tabela": "PRECO_PARAM", "condicao": "PRECO_PARAM.MARKUP = CAD_MARKUP.CODIGO AND PRECO_PARAM.EMP_ID = CAD_MARKUP.EMP_ID"}
          ], 
        "where": ["1=1", "(PRECO_PARAM.CODIGO = PRECO_PARAM.MARKUP) OR (PRECO_PARAM.MARKUP IS NULL) AND CAD_MARKUP.EMP_ID=${getCookie('emp_id')}"]}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      const arrDados = jsonStr.RESULT[0];
      return arrDados;

    } catch (error) {
      console.error(error);
    }
  }

  async function buscaMarkup() {
    let dataSet = await retornaDadosMarkup();
    $('#tabelaMarkup').DataTable().rows().remove().draw(false);
    for (let i = 0; i < dataSet.length; i++) {
      const markup = dataSet[i];
      $('#tabelaMarkup').DataTable().row.add([markup.CODIGO, markup.DESCRICAO]).draw(false);
    }
  }

  $('.collapse').on('shown.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })

    .on('hidden.bs.collapse', function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  function botaoSelecionarGrid(sel, row) {
    if (sel == 'S') {
      return '<div class="icheck-primary">' +
        `<input type="checkbox" class="form-check-input campoSelUF" id="check_col_${row}"} checked>` +
        `<label for="check_col_${row}"  class="form-check-label"></label>` +
        '</div>';
    } else {
      return '<div class="icheck-primary">' +
        `<input type="checkbox" class="form-check-input campoSelUF" id="check_col_${row}">` +
        `<label for="check_col_${row}" class="form-check-label"></label>` +
        '</div>';
    }
  };

  //Tributacao
  $('#btnAlterarTrib').on('click', async function () {
    if ($('#tabelaTributacao').DataTable().rows().data().length == 0) {
      throw msgAlerta('Nenhum registro para alterar, verifique!')
    }
    $('.controlaEdicaoTrib').attr('disabled', false);
    $('.controlaEdicaoTrib').attr('readonly', false);
    $('#btnExcluirTrib').addClass('d-none');
    $('#btnIncluirTrib').addClass('d-none');
    $('#btnAlterarTrib').addClass('d-none');
    $('#btnGravarTrib').removeClass('d-none');
    $('#btnCancelarTrib').removeClass('d-none');
  });

  $('#btnIncluirTrib').on('click', async function () {
    $('.controlaEdicaoTrib').attr('disabled', false);
    $('.controlaEdicaoTrib').attr('readonly', false);
    $('#btnExcluirTrib').addClass('d-none');
    $('#btnIncluirTrib').addClass('d-none');
    $('#btnAlterarTrib').addClass('d-none');
    $('#btnGravarTrib').removeClass('d-none');
    $('#btnCancelarTrib').removeClass('d-none');
    await limpaCamposIndice();
  });

  $('#btnCancelarTrib').on('click', function () {
    $('.controlaEdicaoTrib').attr('disabled', true);
    $('.controlaEdicaoTrib').attr('readonly', true);
    $('#btnExcluirTrib').removeClass('d-none');
    $('#btnIncluirTrib').removeClass('d-none');
    $('#btnAlterarTrib').removeClass('d-none');
    $('#btnGravarTrib').addClass('d-none');
    $('#btnCancelarTrib').addClass('d-none');
    $("#tabelaIndice tr:eq(1)").trigger("click");
  });

  async function buscaTributacao() {
    try {
      $.LoadingOverlay("show");
      let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_PRAZO", "camposSelect":["DOLAR", "FIXO", "INDICE", "EURO", "ID_PRECO"], "where": ["1=1"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#tabelaTributacao').DataTable({
        filter: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },

        "autoWidth": true,
        "data": jsonStr.RESULT[0],
        "columns": [{
          "data": "DOLAR"
        },
        {
          "data": "FIXO"
        },
        {
          "data": "INDICE"
        },
        {
          "data": "EURO"
        },
        {
          "data": "ID_PRECO"
        }]
      });

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaTributacao').on('click', 'tr', async function () {
    try {
      const data = $('#tabelaTributacao').DataTable().row($(this)).data();

      let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_PRAZO", "camposSelect":["COFINS", "ICMS", "IPI", "PIS"], "where": ["1=1", "ID_PRECO='${data.ID_PRECO}'"]}`, null);

      if (!response) {
        return
      }
      let jsonStr = await response.json();

      if (jsonStr.RESULT[0][0].COFINS == 'S') {
        $('#cbCOFINS').prop('checked', true);
      } else {
        $('#cbCOFINS').prop('checked', false);
      }

      if (jsonStr.RESULT[0][0].ICMS == 'S') {
        $('#cbICMS').prop('checked', true);
      } else {
        $('#cbICMS').prop('checked', false);
      }

      if (jsonStr.RESULT[0][0].IPI == 'S') {
        $('#cbIPI').prop('checked', true);
      } else {
        $('#cbIPI').prop('checked', false);
      }

      if (jsonStr.RESULT[0][0].PIS == 'S') {
        $('#cbPIS').prop('checked', true);
      } else {
        $('#cbPIS').prop('checked', false);
      }

      $('#txtDolar').val(data.DOLAR);
      $('#txtEuro').val(data.EURO);
      $('#txtIndiceTrib').val(data.INDICE);
      $('#txtFixo').val(data.FIXO);
      $('#txtId').val(data.ID_PRECO);

    } catch (err) {
      console.log(err);
    }
  });

  $('#btnGravarTrib').on('click', async function () {
    $.LoadingOverlay('show')
    let id = $('#txtId').val() != '' ? $('#txtId').val() : await RetornaProximo('PRECO_PRAZO', 'PRECO_PRAZO', 'ID_PRECO', 3)
    try {
      let tributacao = {
        DOLAR: $('#txtDolar').val(),
        INDICE: $('#txtIndiceTrib').val(),
        EURO: $('#txtEuro').val(),
        FIXO: $('#txtFixo').val(),
        COFINS: $('#cbCOFINS').is(':checked') ? 'S' : 'N',
        ICMS: $('#cbICMS').is(':checked') ? 'S' : 'N',
        IPI: $('#cbIPI').is(':checked') ? 'S' : 'N',
        PIS: $('#cbPIS').is(':checked') ? 'S' : 'N',
        ID_PRECO: id,
      };

      let response = await await requisicao('POST', '/Sisplan/markup/V1/tributacao?', `JSON=${JSON.stringify(tributacao)}`, 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      limpaCamposTributacao();
      await buscaTributacao();
      $('#btnCancelarTrib').trigger('click');

    } catch (err) {
      console.log(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#tabelaTributacao tbody").on("click", "tr", function () {
    $("#tabelaTributacao").dataTable().$("tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  $('#btnExcluirTrib').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      let data = {};
      let tr = $('#tabelaTributacao tr.selected')[0];
      data.ID_PRECO = $('#tabelaTributacao').DataTable().row($(tr)).data().ID_PRECO;

      let response = await requisicao('DELETE', '/Sisplan/markup/V1/tributacao?', `JSON=${JSON.stringify(data)}`, 15000);

      if (!response) {
        return;
      }

      if (response.status == 200) {
        let tr = $('#tabelaTributacao tr.selected')[0];
        const data = $("#tabelaTributacao").DataTable().row($(tr));
        data.remove().draw(false);
      }
    } catch (err) {
      console.log(err);
    } finally {
      $.LoadingOverlay('hide');
      limpaCamposTributacao();
    }
  });

  function limpaCamposTributacao() {
    $('#txtDolar').val('');
    $('#txtEuro').val('');
    $('#txtIndiceTrib').val('');
    $('#txtFixo').val('');
    $('#cbCOFINS').prop('checked', false);
    $('#cbICMS').prop('checked', false);
    $('#cbIPI').prop('checked', false);
    $('#cbPIS').prop('checked', false);
  }

  $('#btnIncluirTrib').on('click', async function () {
    $("#tabelaTributacao").dataTable().$("tr.selected").removeClass("selected");
    limpaCamposTributacao();
    $('#txtDolar').focus();
  });

  $("#tabelaMarkup tr:eq(1)").trigger("click");
  // $("#tabelaTributacao tr:eq(1)").trigger("click");
  bloqueiaCampos(true);
});