$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtNumero',
      popover: {
        title: 'Código da Aplicação PCP',
        description: 'Esse campo é o número identificador da Aplicação PCP, se for cadastrada uma nova Aplicação, esse campo é preenchido automaticamente ao gravar a Aplicação.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome, ele serve para descrever a Aplicação do PCP cadastrado ou uma nova Aplicação.',
        position: 'top'
      }
    },
    {
      element: '#txtTipo',
      popover: {
        title: 'Campo tipo Aplicação',
        description: 'Neste campo, você pode consultar e selecionar um tipo de aplicação para atrelar na Aplicação PCP.',
        position: 'top'
      }
    },
    {
      element: '#txtGrupo',
      popover: {
        title: 'Campo Grupo',
        description: 'Neste campo, podemos descrever de qual grupo será a Aplicação PCP.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a Aplicação PCP.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#txtTipo').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnTipo').pesquisa('#txtTipo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_APL", "camposSelect":["CODIGO", "DESCRICAO", "ATIVO", "ESTOQUE"]}`, 'Consulta Aplicação', 'APLICACAO_PCP');
  $('#btnLimpaTipo').on('click', function () {
    $('#txtTipo').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let codigoAplicacao = parametros[parametros.length - 1];

  if (codigoAplicacao != "" && codigoAplicacao != "create") {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"PCPAPL", "camposSelect":["PCPAPL.CODIGO", "PCPAPL.DESCRICAO",
                                                     "PCPAPL.TIPO", "PCPAPL.TIPOAPL", "PCPAPL.ATIVO", "PCPAPL.CALCULO",
                                                     "PCPAPL.CARACT_UNICA", "PCPAPL.CONS_TECIDO", "TIPO_APL.DESCRICAO DESC_TIPOAPL"],
          "leftjoin": [{"tabela": "TIPO_APL", "condicao": "TIPO_APL.CODIGO = PCPAPL.TIPOAPL"}],
            "where": ["PCPAPL.CODIGO = '${codigoAplicacao}'"]}`,
          null
        );

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }

        $("#txtNumero").val(jsonStr.RESULT[0][0].CODIGO);
        insereValor("#txtTipo", jsonStr.RESULT[0][0].TIPOAPL, jsonStr.RESULT[0][0].DESC_TIPOAPL);
        $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
        $('#txtGrupo').val(jsonStr.RESULT[0][0].TIPO);
        if (jsonStr.RESULT[0][0].ATIVO == "S") {
          $('#cbAtivo').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].CALCULO == "S") {
          $('#cbCalcConsumo').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].CARACT_UNICA == "S") {
          $('#cbCarctUnica').prop('checked', true);
        }
        if (jsonStr.RESULT[0][0].CONS_TECIDO == "S") {
          $('#cbConsTecido').prop('checked', true);
        }
      } catch (error) {
        console.error(error);
        msgAlerta(`Não foi possível buscar os dados:`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  if(codigoAplicacao == "create"){
    $('#cbAtivo').prop('checked', true);
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/aplicacao_pcp`;
  })

  async function gravaStatus() {
    $.LoadingOverlay('show')
    try {
      if ($('#txtDescricao').val() == '') {
        msgAlerta('Preencha o campo Descrição');
        return;
      }

      let status = {}

      if ($('#cbAtivo').is(':checked')) {
        status.ATIVO = 'S'
      };
      status.CODIGO = $('#txtNumero').val() == '' ? await RetornaProximo("CODIGO", "PCPAPL", "CODIGO", 4) : $('#txtNumero').val();
      status.DESCRICAO = $('#txtDescricao').val().toUpperCase();
      status.TIPOAPL = pegaChave('#txtTipo');
      status.TIPO = $("#txtGrupo").val().toUpperCase();
      if ($('#cbCalcConsumo').is(':checked')) {
        status.CALCULO = 'S'
      };
      if ($('#cbCarctUnica').is(':checked')) {
        status.CARACT_UNICA = 'S'
      };
      if ($('#cbConsTecido').is(':checked')) {
        status.CONS_TECIDO = 'S'
      };

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/cadaplicacaopcp?`, `EMP_ID=${getCookie('emp_id')}&JSON=${JSON.stringify(status)}`, 15000);
      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Cadastro efetuado com sucesso!
         Aplicação do PCP: ${status.CODIGO}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/aplicacao_pcp`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnGravar').on('click', async function () {
    await gravaStatus()
  })
});
