$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovoTemplate',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma nova Aplicação do PCP.',
          position: 'right'
        }
      },
      {
        element: '#tabelaAplicacaoPCP',
        popover: {
          title: 'Tabela Aplicação do PCP',
          description: 'Aqui estão os dados das Aplicações do PCP cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
//Grid Acesso//,
$(document).ready(async function () {

  $('#txtConsultaAplicacao').autocompleta(1, `JSON={ "tabela":"PCPAPL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#txtConsultaTipo').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  $('#btn-ConsultaAplicacao').pesquisa('#txtConsultaAplicacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PCPAPL", "camposSelect":["CODIGO", "DESCRICAO", "TIPOAPL", "TIPO"]}`, 'Consulta Aplicação', 'APLICACAO_PCP');
  $('#btn-ConsultaTipo').pesquisa('#txtConsultaTipo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_APL", "camposSelect":["CODIGO", "DESCRICAO", "ATIVO"]}`, 'Consulta Tipo', 'APLICACAO_PCP');

  $('#btnLimparFiltros').on('click', function () {
    $('#txtConsultaTipo, #txtConsultaAplicacao').val('');
  });

  $('#btn-limpa-ConsultaAplicacao').on('click', function () {
    $('#txtConsultaAplicacao').val('');
  });

  $('#btn-limpa-ConsultaTipo').on('click', function () {
    $('#txtConsultaTipo').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    let colunas = [];
    let dataSetCols = [];
    $.LoadingOverlay("show");
    let sWhere = '';

    try {
      if ($.fn.DataTable.isDataTable('#tabelaAplicacaoPCP')) {
        $("#tabelaAplicacaoPCP").DataTable().destroy();
        $("#tabelaAplicacaoPCP").empty();
      }

      sWhere += $("#txtConsultaTipo").val() != '' ? `AND PCPAPL.TIPOAPL='${pegaChave("#txtConsultaTipo")}'` : '';
      sWhere += $("#txtConsultaAplicacao").val() != '' ? `AND PCPAPL.CODIGO='${pegaChave("#txtConsultaAplicacao")}'` : '';
      let ajaxData = {};

      if ($("#txtConsultaAplicacao").val() == '') {
        camposSelect = `["PCPAPL.CODIGO", "PCPAPL.DESCRICAO", "PCPAPL.TIPO", "PCPAPL.TIPOAPL"]`;
        colunas = ["CODIGO", "DESCRICAO", "TIPOAPL", "DESC_TIPOAPL"];

        ajaxData = {
          "EMPRESA": getCookie('empresa'),
          "JSON": `{ "tabela":"PCPAPL", "camposSelect":["PCPAPL.CODIGO", "PCPAPL.DESCRICAO",
                                                        "PCPAPL.TIPOAPL", "TIPO_APL.DESCRICAO DESC_TIPOAPL"],
          "leftjoin": [{"tabela": "TIPO_APL", "condicao": "TIPO_APL.CODIGO = PCPAPL.TIPOAPL"}],
           "where": ["1=1 ${sWhere}"]
          }`
        };
      } else {
        camposSelect = `["PCPAPL.CODIGO", "PCPAPL.DESCRICAO", "PCPAPL.TIPO", "PCPAPL.TIPOAPL"]`;
        colunas = ["CODIGO", "DESCRICAO", "TIPOAPL", "DESC_TIPOAPL"];

        ajaxData = {
          "EMPRESA": getCookie('empresa'),
          "JSON": `{ "tabela":"PCPAPL", "camposSelect":["PCPAPL.CODIGO", "PCPAPL.DESCRICAO",
                                                        "PCPAPL.TIPOAPL", "TIPO_APL.DESCRICAO DESC_TIPOAPL"],
          "leftjoin": [{"tabela": "TIPO_APL", "condicao": "TIPO_APL.CODIGO = PCPAPL.TIPOAPL"}],
           "where": ["1=1 ${sWhere}"]
          }`
        };
      };

      for (let i = 0; i < colunas.length; i++) {
        dataSetCols.push({
          'title': colunas[i],
          'data': i
        });
      }

      $('#tabelaAplicacaoPCP').DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: true,
        order: false,
        autoWidth: true,
        destroy: true,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: {
            'Authorization': BASIC_AUTH
          },
          data: ajaxData,
        },
        "language": {
          "sEmptyTable": "Nenhuma consulta realizada",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhuma consulta realizada",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"

          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          },
        },
        columns: dataSetCols,
        columnDefs: [{
          targets: [0],
          render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados dos itens.');
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  });

  $('#btnConsultar').trigger('click');

  function retornaBotaoOpcoes(data) {
    let retorno = ''
    retorno = '<div style="text-align:start;"> ' +
      '    <button id="editaOpcoes" class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" > ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#tabelaAplicacaoPCP').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAplicacaoPCP').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('APLICACAO_PCP', data[0]);
      if (registroLiberado) {
        window.location.href = `aplicacao_pcp/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaAplicacaoPCP').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const data = $('#tabelaAplicacaoPCP').DataTable().row($(this).parents('tr')).data();
      msgAlerta(`Você realmente deseja excluir o registro ${data[0]}?`, async () => {
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(CODIGO) {
    try {
      $.LoadingOverlay("show");
      try {

        let response = await requisicao('DELETE', '/Sisplan/cadastros/V1/cadaplicacaopcp?', `CODIGO=${encodeURIComponent(CODIGO[0])}`, null)
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/aplicacao_pcp`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function permissaoAcessos(tela) {
    try {
      $.LoadingOverlay("show");

      let object = new Object();
      object.resultado = true;
      object.mensagem = "";

      if (getCookie("cod_usuario") == "0000") {
        object.ALTERA = "S";
        object.CONSULTA = 'S';
        object.EXCLUI = 'S';
        object.INCLUI = 'S';
        return object;
      }

      try {
        const codusuario = getCookie("cod_usuario");
        const response = await requisicao(
          "GET",
          `/Sisplan/AcessoMenu/v1/Acesso?`,
          `codusuario=${codusuario}&tela=${tela}`,
          null,
          60000
        );

        if (!response) {
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        let valida = await response.json();
        if (response.status != 200) {
          console.error(valida.RESULT[0].mensagem);
          msgErro("Erro ao buscar permissões da tela.");
          return;
        }

        if (valida.length <= 0) {
          object.ALTERA = "N";
          object.CONSULTA = 'N';
          object.EXCLUI = 'N';
          object.INCLUI = 'N';
          return object;
        }

        return valida[0];
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar permissões da tela.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  const permissaoUsuarioLogado = await permissaoAcessos("APLICACAO_PCP");

  $('#tabelaAplicacaoPCP').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaAplicacaoPCP').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('APLICACAO_PCP', data[0]);
      if (registroLiberado) {
        window.location.href = `aplicacao_pcp/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});
