$('#tutorial').on('click', function () {
	$(document).ready(async function () {
		const driver = new Driver({
			doneBtnText: 'Sair',
			closeBtnText: 'Fechar',
			nextBtnText: 'Próximo',
			prevBtnText: 'Anterior',
			allowClose: false
		});

		driver.defineSteps([{
			element: '#divFiltros',
			popover: {
				title: 'Filtros',
				description: 'Aqui estão os campos disponíveis de filtro, botão de consultar e imprimir os dados.',
				position: 'botton'
			}
		},
		{
			element: '#divTabela',
			popover: {
				title: 'Consignados/vendas',
				description: 'Aqui você seleciona os consignados/vendas que deseja conferir/devolver.',
				position: 'top'
			}
		},
		{
			element: '#btnDevolver',
			popover: {
				title: 'Devolver Parcial',
				description: 'Faça a devolução por esse botão quando o cliente quiser devolver itens porém sem dar por finalizado o(s) consignado(s), dessa forma será criado apenas uma venda de devolução com os itens devolvidos, podendo finalizar o(s) consignado(s) posteriormente através do botão Conferir.',
				position: 'top'
			}
		},
		{
			element: '#btnConferir',
			popover: {
				title: 'Conferir/Finalizar',
				description: 'Utilize esse botão quando quiser finalizar o(s) consignado(s), tendo a opção de devolver itens que o cliente não ficou e gerar uma nova venda com apenas os itens que o cliente ficou.',
				position: 'top'
			}
		}, {
			element: '#divTotais',
			popover: {
				title: 'Totalizadores',
				description: 'Aqui você pode acompanhar os totalizadores conforme os dados consultados em tela',
				position: 'top'
			}
		}
		]);

		driver.start();

		const activeElement = driver.getHighlightedElement();
	});
});

$(document).ready(async function () {

	const permissaoUsuarioLogado = await permissaoAcessos("AGRUPAMENTO_VENDA");
	await setarDataAtual('dtInicio');
	await setarDataAtual('dtFim');
	const parametrosVenda = await BuscaParametrosVenda();
	const utilizaBarraLog = parametrosVenda[46] != '0';
	const integracaoEPC = parametrosVenda[60];
	let listaBarrasBipadas = [];
	let listaBarrasNaoBipadas = [];
	let listaBarrasBipadasEPC = [];
	let listaBarrasForamBipadasEPC = [];

	let quantidadeCasasDecimaisParametro = await CopiaParametro('SISTEMA', 1);
	let quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;

	let response = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"PERMISSOES_TELA","camposSelect":["PERMISSAO"], "where": ["USUARIO = '${getCookie("cod_usuario")}' AND EMP_ID = ${getCookie("emp_id")} AND TELA = 'AGRUPAMENTO_VENDA' AND ACAO = 'CHECK_CONFERENCIA_CONSIGNADO'"]}`, null);

	if (!response || response.status != 200) {
		return;
	}

	let jsonStr = await response.json();

	let podeAlterarCheck;
	if (jsonStr.RESULT[0].length > 0) {
		podeAlterarCheck = jsonStr.RESULT[0][0].PERMISSAO == "S";
	} else {
		podeAlterarCheck = false;
	}

	criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px', undefined, undefined, [], [], [], [], {}, 2, '', '', false, [], [6, 7, 8]);
	function retornaPrimeiroDia() {
		const agora = new Date();
		const primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
		return primeiroDia;
	}

	if ((integracaoEPC != '0') && (integracaoEPC != '3')) {
		$('.divRFID').removeClass("d-none");
	} else if (integracaoEPC == '3') {
		$('#btnRFID').removeClass("d-none");
	}

	$('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
	$('#btnCliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["ativo = 'S'"]}`, 'Pesquisa Cliente');
	// $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
	// $('#btnCliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Cliente');
	$('#btnACliente').on('click', function () { $('#txtCliente').val(''); });

	// $('#txtCaixa').listaFiltros();
	$('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
	$('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
	$('#btnLimpaCaixa').on('click', function () { $('#txtCaixa').val(''); });
	$('#txtTipoVendaFiltro').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
	$('#btnPesquisaTipoVenda').pesquisa('#txtTipoVendaFiltro', 'ID', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa Tipo Venda', 'VENDA_TIPO');
	$('#btnLimpaTipoVenda').on('click', function () {
		$('#txtTipoVendaFiltro').val('');
	});

	$('#txtCliente').focus();

	async function buscarDados(sCodcli, sDtIni, sDtFim, sCaixa, stipoVenda) {
		$.LoadingOverlay("show");
		try {
			const pesquisaParam = {
				tabela: 'VENDA',
				camposSelect: ['VENDA.CODVEN', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR',
					`VENDA.VALOR - (SELECT COALESCE(SUM(VALOR*QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N' )  VALOR_RESTANTE`,
					'SUM(ITVENDA.QUANTIDADE) QUANTIDADE',
					`(SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N') QTDE_DEV`,
					`SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N') QUANT_RESTANTE`,
					'VENDA.TIPO_VENDA', 'VENDA_TIPO.DESCRICAO DESC_TIPO_VENDA', 'VENDA_TIPO.CONSIGNADO'
				],
				leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' },
				{ tabela: 'ITVENDA', condicao: 'ITVENDA.CODVEN = VENDA.CODVEN AND ITVENDA.EMP_ID = VENDA.EMP_ID' },
				{ tabela: 'VENDA_TIPO', condicao: 'VENDA.TIPO_VENDA = VENDA_TIPO.ID' }
				],
				where: [`VENDA.CODCLI = '${sCodcli}' AND VENDA.DATA >= '${sDtIni}' AND VENDA.DATA <= '${sDtFim}' AND VENDA.NRCAIXA = '${sCaixa}' AND VENDA.FECHADA = 0 AND VENDA.CANCELADA = 0 AND VENDA.DEVOLUCAO=0 AND VENDA.EMP_ID= ${getCookie('emp_id')} AND VENDA_TIPO.ESTOQUE = 'S'`],
				groupBy: ['VENDA.CODVEN', 'VENDA.EMP_ID', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR', 'VENDA.TIPO_VENDA', 'VENDA_TIPO.DESCRICAO', 'VENDA_TIPO.CONSIGNADO']
			};

			if (stipoVenda != '') {
				pesquisaParam.where.push(`VENDA.TIPO_VENDA = ${stipoVenda}`);
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			const totalDevolvido = jsonStr.reduce((total, vendas) => { return total += vendas.QTDE_DEV }, 0);
			$('#txtTotalDevolucao').val(totalDevolvido);
			return jsonStr;
		} finally {
			$.LoadingOverlay("hide");
		}
	};

	$('#check_todos').on('change', function () {
		$('.campoSel').prop('checked', $('#check_todos').prop('checked'));
		if ($('#check_todos').prop('checked')) {
			$('.campoSel').addClass('selecionado');
		} else {
			$('.campoSel').removeClass('selecionado');
		}
		atualizaTotaisSelecionados();
	});

	$("#btnConsultar").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#btnConsultar").trigger("click");
		}
	});

	$('#btnConsultar').on('click', async function () {
		if ($.fn.DataTable.isDataTable('#tabelaVendas')) {
			$('#tabelaVendas').DataTable().destroy();
			$('#tabelaVendas').empty();
		}

		const codcli = pegaChave('#txtCliente');
		const dtIni = $('#dtInicio').val();
		const dtFim = $('#dtFim').val();
		// const nrCaixa = await formataListas($('#listaCaixa').val());
		const nrCaixa = pegaChave('#txtCaixa');
		const tipoVenda = pegaChave('#txtTipoVendaFiltro');

		if ([codcli, dtIni, dtFim, nrCaixa].includes('')) {
			msgAlerta('Necessário preencher todos os dados.');
			return;
		}

		const dados = await buscarDados(codcli, dtIni, dtFim, nrCaixa, tipoVenda);

		if (dados.length == 0) {
			msgAlerta('Nenhuma venda encontrada, favor verificar.');
			return;
		}

		let dataSetCols = [];

		let keys = Object.keys(dados[0]);
		dataSetCols.push({
			'title': 'SEL',
			'data': 'SEL',
			'width': '15px'
		});

		dataSetCols[0].render = function (data, type, row, meta) {
			return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
		}

		for (var k in keys) {
			dataSetCols.push({
				'data': keys[k]
			});
		}
		criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px', dados, dataSetCols, [11], [], [], [4, 5], {}, 2, '', '', false, [], [6, 7, 8]);

		$('.campoSel').on('change', function () {
			if (this.checked) {
				$(this).addClass('selecionado');
			} else {
				$(this).removeClass('selecionado');
			}
			$('#check_todos').prop('checked', $('.campoSel').length == $('.selecionado').length);
			atualizaTotaisSelecionados();
		});
	});

	function atualizaTotaisSelecionados() {
		let quantidade = 0;
		let valor = 0;
		let quantidadeRestante = 0;
		let valorRestante = 0;
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				quantidade += $('#tabelaVendas').DataTable().row(i).data().QUANTIDADE;
				valor += $('#tabelaVendas').DataTable().row(i).data().VALOR;
				quantidadeRestante += $('#tabelaVendas').DataTable().row(i).data().QUANT_RESTANTE;
				valorRestante += $('#tabelaVendas').DataTable().row(i).data().VALOR_RESTANTE;
			}
		}
		$('#txtTotalQuantSelec').val(quantidade);
		$('#txtTotalValorSelec').val(TruncaDecimaisNova(2, valor));
		$('#txtTotalQuantRestante').val(quantidadeRestante);
		$('#txtTotalValorRestante').val(TruncaDecimaisNova(2, valorRestante));
	}

	async function retornaFiltros() {
		try {
			const cliente = pegaChave('#txtCliente');
			const dataIni = $('#dtInicio').val();
			const dataFim = $('#dtFim').val();
			const tipoVenda = pegaChave('#txtTipoVendaFiltro');
			// const nrCaixa = await formataListas($('#listaCaixa').val())
			const nrCaixa = pegaChave('#txtCaixa');

			const retorno =
				`CLIENTE=${cliente}` +
				`&DATAINI=${dataIni}` +
				`&CAIXA=${nrCaixa}` +
				`&EMP_ID=${getCookie('emp_id')}` +
				`&DATAFIM=${dataFim}` +
				`&TIPO_VENDA=${tipoVenda}`;
			return retorno;
		} catch (error) {
			console.error(error);
		}
	}

	$('#btnLojaPrincipal').on('click', function () {
		window.location.href = `${BASE_URI}/loja`;
	});

	retornaHintRelatorio('btnImprimir', 'AgrupamentoConsig')
	$('#btnImprimir').on('click', async function () {
		await imprimirAgrupamento();
	});

	async function imprimirAgrupamento() {
		try {
			$.LoadingOverlay('show');
			try {
				if ($('#txtCliente').val() == '') {
					msgAlerta('Necessário preencher os dados');
					return;
				}
				let url = `/sisplan/impressao/v1/agrupamentoconsig?`;
				const dados = await retornaFiltros();
				const bImprimeAutomatico = await verificaImprimirAutomatico('AgrupamentoConsig');
				let arquivo = await GeraRelatorio(`${url}${dados}`, 'GET', 1000000, false, 'AgrupamentoConsig');
				if (arquivo != undefined) {
					if (!bImprimeAutomatico) {
						window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
					}
					await limparRelatorios();
				}

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	$('#btnConferir').on('click', async function () {
		if (permissaoUsuarioLogado.INCLUI == 'S') {
			const arrVendas = [];
			for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
				if ($('#check_col_' + i + '_row_0').prop('checked')) {
					arrVendas.push({
						CODIGO: $('#tabelaVendas').DataTable().row(i).data().CODVEN,
						TIPO_VENDA: $('#tabelaVendas').DataTable().row(i).data().TIPO_VENDA,
					});
				}
			}

			if (arrVendas.length == 0) {
				msgAlerta('Nenhuma venda selecionada, favor verificar.');
				return;
			}

			const tiposDiferentes = arrVendas.filter((venda) => venda.TIPO_VENDA !== arrVendas[0].TIPO_VENDA).length > 0;
			if (tiposDiferentes) {
				msgAlerta('Os tipos de venda devem ser iguais');
				return;
			}

			const ListaNumeroVendas = arrVendas.map((venda) => venda.CODIGO);

			if (arrVendas[0].TIPO_VENDA == 1) {
				await preencheConferenciaVenda(ListaNumeroVendas);
			} else {
				await preencheConferenciaConsignado(ListaNumeroVendas);
				$('#txtTotalConferido').val(0);
				$('#txtValorTotalConferido').val(0);
			}
		} else {
			msgAlertaSemConfirmacao("Sem permissão para incluir!");
		}
	});

	$('#btnDevolver').on('click', async function () {
		let bConsignado = false;
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				if (($('#tabelaVendas').DataTable().row(i).data().DESC_TIPO_VENDA == 'CONSIGNADO') || ($('#tabelaVendas').DataTable().row(i).data().CONSIGNADO == 'S')) {
					bConsignado = true;
					break;
				}
			}
		}

		if (!bConsignado) {
			msgAlerta('Não é possível devolver Vendas por aqui, apenas consignados.');
			return;
		}

		if ((!bConsignado) || (parametrosVenda[73] == 0) || (parametrosVenda[73] == undefined)) {
			await abreTelaDevolucao();
			$('#txtTotalDevolvido').val(0);
			$('#txtValorTotalDevolvido').val(0);
		} else if (parametrosVenda[73] == 1) {
			senhaSupervisor('Para devolução de consignado, ', async () => {
				await abreTelaDevolucao();
				$('#txtTotalDevolvido').val(0);
				$('#txtValorTotalDevolvido').val(0);
			})
		} else if (parametrosVenda[73] == 2) {
			msgAlerta('Não é possível fazer devolução de consignados!');
		}
	});

	async function barraJaEstaBipada(sBarra) {
		try {
			if (listaBarrasBipadas.find(item => item.barra === sBarra)) {
				msgErro(`Barra ${sBarra} já lida, verifique.`);
				return true;
			}
			return false;
		} catch (error) {
			console.error('barra_log', error);
			msgErro('Erro ao processar barra log.');
			return false;
		}
	}

	async function retornaBarraLogLida(sBarra) {
		try {
			const url = `/sisplan/barralog/v1/validarbarra?`;
			const params = `barra=${encodeURIComponent(sBarra)}`;
			const response = await requisicao('GET', url, params, 15000);

			if (!response) {
				return;
			}

			jsonStr = await response.json();
			if (response.status != 200) {
				return jsonStr.mensagem;
			}

			return jsonStr.mensagem;
		} catch (error) {
			console.error(error);
		}
	}

	async function adicionaBarraBipada(objItem) {
		try {
			const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
			if (['barra_log'].includes(retornoBarraLog)) {
				listaBarrasBipadas.push(objItem);
				listaBarrasNaoBipadas = listaBarrasNaoBipadas.filter(barra => objItem.barra != barra.barra);
			}
		} catch (error) {
			console.error(error);
		}
	}

	// executa após definicao das rotinas
	if (localStorage.getItem('@venda.cliente')) {
		const dadosCli = localStorage.getItem('@venda.cliente');
		const nomeCli = localStorage.getItem('@venda.cliente_nome');
		const dadosCaixa = localStorage.getItem('@venda.caixa');
		insereValor('#txtCliente', dadosCli, nomeCli);
		insereValor('#txtCaixa', dadosCaixa);
		const primeiroDia = retornaPrimeiroDia();
		const dia01 = primeiroDia;
		const dia01ISO = dia01.toISOString();
		const dia01String = dia01ISO.substr(0, 10);
		$('#dtInicio').val(dia01String);
		$('#dtFim').val('2500-12-31');
		localStorage.removeItem("@venda.cliente");
		localStorage.removeItem("@venda.caixa");
		localStorage.removeItem("@venda.cliente_nome");
		$('#btnConsultar').trigger('click');
	}

	async function abreTelaDevolucao() {
		$.LoadingOverlay("show");
		try {
			const arrVendas = [];
			for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
				if ($('#check_col_' + i + '_row_0').prop('checked')) {
					arrVendas.push($('#tabelaVendas').DataTable().row(i).data().CODVEN);
				}
			}

			if (arrVendas.length == 0) {
				msgAlerta('Nenhuma venda selecionada, favor verificar.');
				return;
			}

			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODVEN VENDA', 'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', `SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					`0 QTDE_DEV`, `0 QTD_DEV`, 'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ VALOR',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.CODVEN', 'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN',
					'ITVENDA.PRECO_LIQ', 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				]
			}

			let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			if (jsonStr && jsonStr.length > 0) {
				$('#txtVendasDev').val(arrVendas.toString().replaceAll(',', ', '));

				let dataSetCols = [];
				const keys = Object.keys(jsonStr[0]);
				for (var k in keys) {
					if (keys[k].toUpperCase() == 'DESCRICAO') {
						dataSetCols.push({
							'title': keys[k],
							'data': keys[k],
							'width': '100px'
						});
					} else {
						dataSetCols.push({
							'title': keys[k],
							'data': keys[k]
						});
					}
				};
				let i = 0;
				jsonStr.forEach(dado => {
					dado.QTD_DEV = `<input type="text" class="input-default focus form-control qtdeDev" id="qtdeDev_${i}" value="0">`;
					i++;
				});

				criaDataTablePadrao('#tabelaDevolucao', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [6, 8, 9, 10, 11, 12, 13, 14, 17, 18], [], [], [], {}, 2, '', '', false, [], [5]);
				await carregaBarrasLog();

				i = 0;
				jsonStr.forEach(dado => {
					if (dado.TIPO == 'M') {
						$(`#qtdeDev_${i}`).maskMoney({
							decimal: ".",
							thousands: "",
							precision: quantidadeCasasDecimaisCampo,
						});
					} else {
						$(`#qtdeDev_${i}`).maskMoney({
							decimal: ".",
							thousands: "",
							precision: 0,
						});
					}
					i++;
				});

				adicionaFocusout('.qtdeDev');
			}

			$('#modalDevolucao').modal('show');
			$("#tabelaDevolucao").DataTable().columns.adjust().draw(false);

			const somAtivo = localStorage.getItem('@consignado.somAtivo') ?? 'false';
			if (somAtivo == 'true') {
				$($('#somInativoDev')[0]).trigger('click');
				$($('#somInativoBarra')[0]).trigger('click');
			} else {
				$($('#somAtivoDev')[0]).trigger('click');
				$($('#somAtivoBarra')[0]).trigger('click');
			}

		} finally {
			$.LoadingOverlay("hide");
			$('#txtBarra').focus();
		}
	};

	function adicionaFocusout(input) {
		let itens = $(input);
		for (let index = 0; index < itens.length; index++) {
			const element = itens[index];
			$(`#${element.id}`).on('focusout', async function () {
				await confereBarraDevDig(this);
			});
		}
	}

	async function preencheConferenciaConsignado(arrVendas) {
		$.LoadingOverlay("show");
		try {
			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', `SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN AND ITVENDADEV.EMP_ID = ${getCookie('emp_id')} ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					`0 QTDE_CONF`, 'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ VALOR',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN',
					'ITVENDA.PRECO_LIQ', 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', 'ITVENDA.CODVEN'
				]
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

			$('#txtVendas').val(arrVendas.toString().replaceAll(',', ', '));

			let dataSetCols = [];
			const keys = Object.keys(jsonStr[0]);
			for (var k in keys) {
				if (keys[k].toUpperCase() == 'DESCRICAO') {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k],
						'width': '100px'
					});
				} else {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k]
					});
				}
			};

			criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [7, 8, 9, 10, 11, 12, 15, 16], [], [], [], {}, 2, '', '', false, [], []);
			await carregaBarrasLog();

			$('#modalConferencia').modal('show');
			$("#tabelaItens").DataTable().columns.adjust().draw(false);

			const somAtivoBarra = localStorage.getItem('@consignado.somAtivo') ?? 'false';
			if (somAtivoBarra == 'true') {
				$($('#somInativoBarra')[0]).trigger('click');
				$($('#somInativoDev')[0]).trigger('click');
			} else {
				$($('#somAtivoBarra')[0]).trigger('click');
				$($('#somAtivoDev')[0]).trigger('click');
			}

			if (!podeAlterarCheck) {
				$("#checkConsig").prop("disabled", true);
			}

		} finally {
			$.LoadingOverlay("hide");
			$('#txtBarra').focus();
		}
	};

	async function preencheConferenciaVenda(arrVendas) {
		$.LoadingOverlay("show");
		try {

			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', //`ITVENDA.QUANTIDADE QTDE`,
					`SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN AND ITVENDADEV.EMP_ID = ${getCookie('emp_id')} ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE', 'ITVENDA.VALOR', 'SUM(ITVENDA.DESC_ITEM) DESC_ITEM', 'ITVENDA.PERC_DESC', 'VENDA.CODREP', 'ITVENDA.CODVEN',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ', 'SUM(ITVENDA.TOTAL) TOTAL', 'SUM(ITVENDA.TOTAL_LIQ) TOTAL_LIQ',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', 'ITVENDA.PEDIDO', 'ITVENDA.ORDEM_PED'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' },
					{ tabela: 'VENDA', condicao: 'VENDA.CODVEN = ITVENDA.CODVEN AND VENDA.EMP_ID = ITVENDA.EMP_ID' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'ITVENDA.VALOR'
					, 'ITVENDA.PERC_DESC', 'VENDA.CODREP', 'ITVENDA.CODVEN', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN', 'ITVENDA.CODVEN', 'ITVENDA.PRECO_LIQ'
					, 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', 'VENDA.CODREP', 'ITVENDA.PEDIDO', 'ITVENDA.ORDEM_PED'
				]
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

			$('#txtAgrupaVendas').val(arrVendas.toString().replaceAll(',', ', '));

			let dataSetCols = [];
			const keys = Object.keys(jsonStr[0]);
			for (var k in keys) {
				if (keys[k].toUpperCase() == 'DESCRICAO') {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k],
						'width': '100px'
					});
				} else {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k]
					});
				}
			};

			criaDataTablePadrao('#tabelaItensAgrupaVendas', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 21, 22, 23, 24], [], [], [], {}, 2, '', '', false, [], [4]);

			$('#modalAgrupaVendas').modal('show');
			$("#tabelaItensAgrupaVendas").DataTable().columns.adjust().draw(false);

			const somAtivoBarra = localStorage.getItem('@consignado.somAtivo') ?? 'false';
			if (somAtivoBarra == 'true') {
				$($('#somInativoBarra')[0]).trigger('click');
				$($('#somInativoDev')[0]).trigger('click');
			} else {
				$($('#somAtivoBarra')[0]).trigger('click');
				$($('#somAtivoDev')[0]).trigger('click');
			}

		} finally {
			$.LoadingOverlay("hide");
		}
	};

	$('#modalConferencia').on('hidden.bs.modal', function (_) {
		listaBarrasBipadas = [];
		listaBarrasNaoBipadas = [];
	});

	$('#txtBarra').on('blur', async function () {
		await confereBarra();
	});

	$('#txtBarraDev').on('blur', async function () {
		await confereBarraDev();
	});

	$('#txtBarra').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			$('#txtBarra').trigger('blur');
			$('#txtBarra').focus();
		}
	});

	$('#txtBarraDev').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			event.preventDefault();
			$('#txtBarraDev').trigger('blur');
			$('#txtBarraDev').focus();
		}
	});

	$('#tabelaItens tbody').on('click', 'tr', async function () {
		$("#tabelaItens tbody tr td")[0].click();
		$('#tabelaItens tbody tr.selected').removeClass('selected');
		$(this).addClass('selected');
	});

	$('#tabelaDevolucao tbody').on('click', 'tr', async function () {
		$("#tabelaDevolucao tbody tr td")[0].click();
		$('#tabelaDevolucao tbody tr.selected').removeClass('selected');
		$(this).addClass('selected');
	});

	$('#txtTotalDevolvido').val(0);
	$('#txtValorTotalDevolvido').val(0);

	async function atualizaTotalDevolvido() {
		const quantidadeDevolvida = $('#tabelaDevolucao').DataTable().column(6, {}).data().sum();
		$('#txtTotalDevolvido').val(+quantidadeDevolvida);
	}

	async function atualizaValorTotalDevolvido(valor) {
		$('#txtValorTotalDevolvido').val(TruncaDecimaisNova(2, +$('#txtValorTotalDevolvido').val() + valor));
	}

	async function confereBarraDev() {
		let barra = $('#txtBarraDev').val();
		let bEstorno = false;

		let quantidade = 1;
		if (barra.indexOf("*") > 0) {
			quantidade = +barra.substring(0, barra.indexOf("*"));
			barra = barra.substring(barra.indexOf("*") + 1, barra.length);
		}

		if (barra.substring(0, 1) == '-') {
			barra = barra.substring(barra.indexOf("-") + 1, barra.length);
			bEstorno = true;
		}

		const ebarralog = await retornaBarraLogLida(barra) == "barra_log";

		if (ebarralog) {
			barra = await extraiBarra28(barra, 'N');
		}

		if (barra == '') {
			return;
		}

		const dados = $('#tabelaDevolucao').DataTable().rows().data().toArray();
		const indiceQtde = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE > item.QTDE_DEV)
		);

		const indiceEstorno = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE_DEV > 0)
		);
		const indice = indiceQtde != -1 && !bEstorno ? indiceQtde : indiceEstorno;

		if (indice != -1) {
			const dadosItem = $('#tabelaDevolucao').DataTable().row(indice).data();
			// validacao barra_log
			if (utilizaBarraLog) {
				const item = {
					codigo: dadosItem.CODIGO,
					cor: dadosItem.COR,
					tam: dadosItem.TAM,
					barra: $('#txtBarraDev').val()
				}
				if (await barraJaEstaBipada($('#txtBarraDev').val())) {
					$('#txtBarraDev').val('');
					return;
				} else {
					await adicionaBarraBipada(item);
				}
			}
			if (!bEstorno) {
				if (dadosItem.QTDE_DEV < dadosItem.QTDE) {
					if (quantidade > 1 && quantidade + dadosItem.QTDE_DEV <= dadosItem.QTDE) {
						dadosItem.QTDE_DEV += quantidade;
					} else if (quantidade == 1) {
						dadosItem.QTDE_DEV += quantidade;
					} else {
						msgAlerta('Quantidade informada inválida ou maior que o saldo para devolução, verifique');
						$('#txtBarraDev').val('');
						$('#txtBarraDev').focus();
						return;
					}
					atualizaTotalDevolvido();
					atualizaValorTotalDevolvido(dadosItem.VALOR * quantidade);
					SomAlerta()
				} else {
					msgAlerta(`Quantidade total do item: ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} já conferida`, null, null, () => { $('#txtBarraDev').focus(); });
					SomAlerta(BASE_URI, true);
					$('#txtBarraDev').val('');
				}
			} else {
				if (dadosItem.QTDE_DEV > 0) {
					dadosItem.QTDE_DEV -= 1;
					atualizaTotalDevolvido();
					atualizaValorTotalDevolvido(-dadosItem.VALOR);
					if (ebarralog) {
						estornaBarraBipada($('#txtBarraDev').val());
					}
					SomAlerta()
				} else {
					msgAlerta(`Item ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} sem quantidades para estornar!`, null, null, () => { $('#txtBarraDev').focus(); });
					SomAlerta(BASE_URI, true);
					$('#txtBarraDev').val('');
				}
			}


			$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
			$(`#qtdeDev_${indice}`).val(dadosItem.QTDE_DEV);
			adicionaFocusout(`#qtdeDev_${indice}`);
			$($('#tabelaDevolucao tbody tr')[indice]).click();

			$('#tabelaDevolucao').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));

			$('#txtBarraDev').val('');
			$('#txtBarraDev').focus();
		} else {
			msgAlerta('Nenhuma barra com saldo disponível localizada', null, null, () => { $('#txtBarraDev').focus(); });
			SomAlerta(BASE_URI, true);
			$('#txtBarraDev').val('');
		}

	}

	async function confereBarraDevDig(input) {
		const id = input.id.substring(input.id.indexOf('_') + 1);
		const quantidade = parseFloat(input.value);
		const indice = id;

		if (indice != -1) {
			const dadosItem = $('#tabelaDevolucao').DataTable().row(indice).data();

			if (quantidade <= dadosItem.QTDE) {
				dadosItem.QTDE_DEV = quantidade;
				atualizaTotalDevolvido();
				$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
				atualizaValorTotalDevolvidoManual();
				$(`#${input.id}`).val(quantidade);
			} else {
				msgAlerta(`Quantidade maior que o campo QTDE, impossível continuar!`);
				dadosItem.QTDE_DEV = 0;
				$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
				atualizaValorTotalDevolvidoManual();
				$(`#${input.id}`).val('0');
			}
			adicionaFocusout(`#${input.id}`);
		}
	}

	function atualizaValorTotalDevolvidoManual() {
		const dados = $('#tabelaDevolucao').DataTable().rows().data().toArray();
		let valor = 0;
		dados.forEach(item => {
			valor += TruncaDecimaisNova(2, item.QTDE_DEV * item.VALOR);
		});
		$('#txtValorTotalDevolvido').val(valor);
	}

	$('#txtTotalConferido').val(0);
	$('#txtValorTotalConferido').val(0);

	async function atualizaTotalConferido() {
		const quantidadeConferida = $('#tabelaItens').DataTable().column(5, {}).data().sum();
		$('#txtTotalConferido').val(+quantidadeConferida);
	}

	async function atualizaValorTotalConferido(valor) {
		$('#txtValorTotalConferido').val(TruncaDecimaisNova(2, +$('#txtValorTotalConferido').val() + valor));
	}


	async function confereBarra() {
		let barra = $('#txtBarra').val();
		let bEstorno = false;

		let quantidade = 1;
		if (barra.indexOf("*") > 0) {
			quantidade = +barra.substring(0, barra.indexOf("*"));
			barra = barra.substring(barra.indexOf("*") + 1, barra.length);
		}

		if (barra.substring(0, 1) == '-') {
			barra = barra.substring(barra.indexOf("-") + 1, barra.length);
			bEstorno = true;
		}

		const ebarralog = await retornaBarraLogLida(barra) == "barra_log";

		if (ebarralog) {
			barra = await extraiBarra28(barra, 'N');
		}

		if (barra == '') {
			return;
		}

		const dados = $('#tabelaItens').DataTable().rows().data().toArray();
		const indiceQtde = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE > item.QTDE_CONF));

		const indiceEstorno = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE_CONF > 0));

		const indice = indiceQtde != -1 && !bEstorno ? indiceQtde : indiceEstorno;

		if (indice != -1) {
			const dadosItem = $('#tabelaItens').DataTable().row(indice).data();
			// validacao barra_log
			if (utilizaBarraLog) {
				const item = {
					codigo: dadosItem.CODIGO,
					cor: dadosItem.COR,
					tam: dadosItem.TAM,
					barra: barra
				}
				if (await barraJaEstaBipada(barra)) {
					$('#txtBarra').val('');
					return;
				} else {
					await adicionaBarraBipada(item);
				}
			}
			if (!bEstorno) {
				if (dadosItem.QTDE_CONF < dadosItem.QTDE) {
					if (quantidade > 1 && quantidade + dadosItem.QTDE_CONF <= dadosItem.QTDE) {
						dadosItem.QTDE_CONF += quantidade;
						SomAlerta()
					} else if (quantidade == 1) {
						dadosItem.QTDE_CONF += quantidade;
						SomAlerta()
					} else {
						msgAlerta('Quantidade informada inválida ou maior que o saldo para devolução, verifique');
						SomAlerta(BASE_URI, true);
						$('#txtBarra').val('');
						$('#txtBarra').focus();
						return;
					}
					atualizaTotalConferido();
					atualizaValorTotalConferido(dadosItem.VALOR * quantidade);
				} else {
					msgAlerta(`Quantidade total do item: ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} já conferida`, null, null, () => { $('#txtBarra').focus(); });
					SomAlerta(BASE_URI, true);
					$('#txtBarra').val('');
				}
			} else {
				if (dadosItem.QTDE_CONF > 0) {
					dadosItem.QTDE_CONF -= 1;
					atualizaTotalConferido();
					atualizaValorTotalConferido(-dadosItem.VALOR);
					if (ebarralog) {
						estornaBarraBipada($('#txtBarraDev').val());
					}
					SomAlerta()
				} else {
					msgAlerta(`Item ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} sem quantidades para estornar!`, null, null, () => { $('#txtBarra').focus(); });
					SomAlerta(BASE_URI, true);
					$('#txtBarra').val('');
				}
			}

			$('#tabelaItens').DataTable().row(indice).data(dadosItem).draw(false);
			$($('#tabelaItens tbody tr')[indice]).click();

			$('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));

			$('#txtBarra').val('');
			$('#txtBarra').focus();
		} else {
			msgAlerta('Nenhuma barra com saldo disponível localizada', null, null, () => { $('#txtBarra').focus(); });
			$('#txtBarra').val('');
		}
	}


	$('#txtTipoVendaFiltro').on('blur', function () {
		$('#btnConsultar').focus();
	});

	$('#btnConfirmarConf').on('click', async function () {
		$('#btnConfirmarConf').prop('disabled', true);
		try {
			await confirmaConferencia();
		} finally {
			$('#btnConfirmarConf').prop('disabled', false);
		}

	});

	$('#btnConfirmarDev').on('click', async function () {
		$("#btnConfirmarDev").prop("disabled", true);
		try {
			await confirmaDevolucao();
		} finally {
			$("#btnConfirmarDev").prop("disabled", false);
		}

	});

	$('#btnConfirmarAgrupaVendas').on('click', async function () {
		$('#btnConfirmarAgrupaVendas').prop('disabled', true);
		try {
			await confirmaAgrupaVendas();
		} finally {
			$('#btnConfirmarAgrupaVendas').prop('disabled', false);
		}

	});

	function retornaJsonAgrupamentoVendas(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '1',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: false,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: infosVenda.STATUS,
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaItensAgrupaVendas').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: item.CODREP,
				CODVENDEV: item.CODVEN,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESC_ITEM: item.DESC_ITEM,
				DESCONTO: item.DESC_ITEM,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: item.ORDEM_PED,
				PEDIDO: item.PEDIDO,
				PERC_DESC: item.PERC_DESC,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.PRECO_LIQ,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * item.QTDE),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * item.QTDE),
				VALOR: item.VALOR,
				VALOR_DESC: item.VALOR_DESC
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL - itemVenda.DESC_ITEM;
				venda.VALOR_BRUTO += itemVenda.VALOR * itemVenda.QUANTIDADE;
				venda.ITENS.push(itemVenda);
			}
		});

		return venda;
	}

	function retornaJsonDevolucao(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '2',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: true,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: '',
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaDevolucao').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: infosVenda.CODREP,
				CODVENDEV: item.VENDA,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE_DEV,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * (item.QTDE_DEV)),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * (item.QTDE_DEV)),
				VALOR: item.VALOR,
				VALOR_DESC: 0,
				BARRAS_LOG: retornaBarraLog(item.CODIGO, item.COR, item.TAM, utilizaBarraLog)
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL;
				venda.VALOR_BRUTO += itemVenda.TOTAL;
				venda.ITENS.push(itemVenda);
			}
		});
		return venda;
	}

	function retornaJsonVenda(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '1',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: false,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: infosVenda.STATUS,
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaItens').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: infosVenda.CODREP,
				CODVENDEV: 0,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE - item.QTDE_CONF,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * (item.QTDE - item.QTDE_CONF)),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * (item.QTDE - item.QTDE_CONF)),
				VALOR: item.VALOR,
				VALOR_DESC: 0,
				BARRAS_LOG: retornaBarraLog(item.CODIGO, item.COR, item.TAM, utilizaBarraLog)
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL;
				venda.VALOR_BRUTO += itemVenda.TOTAL;
				venda.ITENS.push(itemVenda);
			}
		});

		return venda;
	}

	function retornaBarraLog(sCodigo, sCor, sTam, utilizaBarraLog) {
		const barras = utilizaBarraLog
			? listaBarrasBipadas
				.filter((item) => item.codigo == sCodigo && item.cor == sCor && item.tam == sTam)
				.map((item) => item.barra)
			: [];
		return barras;
	}

	function retornaJsonConsignado(sVenda) {
		sVenda.VENDA_TIPO = '2';
		sVenda.ITENS = [];
		sVenda.BASE_DESC = 0;
		sVenda.VALOR = 0;
		sVenda.VALOR_BRUTO = 0;
		$('#tabelaItens').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA,
				CAIXA: '',
				CODREP: sVenda.CODREP,
				CODVENDEV: 0,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: sVenda.DATA,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE_CONF,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * item.QTDE_CONF),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * item.QTDE_CONF),
				VALOR: item.VALOR,
				VALOR_DESC: 0
			};
			if (itemVenda.QUANTIDADE > 0) {
				sVenda.BASE_DESC += itemVenda.TOTAL;
				sVenda.VALOR += itemVenda.TOTAL;
				sVenda.VALOR_BRUTO += itemVenda.TOTAL;
				sVenda.ITENS.push(itemVenda);
			}
		});
		return sVenda;
	}

	async function gravaConsignado(consignado) {
		try {
			const responseConsig = await requisicao('POST', '/sisplan/vendas/v1/venda?', `FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}`, `JSON=${encodeURIComponent(JSON.stringify(consignado))}`, 180000);

			if (!responseConsig) {
				return false;
			}

			const jsonStrConsig = await responseConsig.json();

			if (responseConsig.status != 200) {
				msgErro(jsonStrConsig.mensagem);
				return;
			}
		} catch (error) {
			console.error(error);
		}
	}

	async function gravaVenda(venda, bDevolucao = false) {
		const response = await requisicao('POST', '/sisplan/vendas/v1/venda?', `SEMANTECIPACAO=${bDevolucao ? 'S' : 'N'}&FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}&VERIFICA_CAIXA=${false}`, `JSON=${encodeURIComponent(JSON.stringify(venda))}`, 180000);

		if (!response) {
			return false;
		}

		const jsonStr = await response.json();

		if (response.status != 200) {
			msgErro(jsonStr.mensagem);
			return;
		}
	}

	async function cancelaVendasConferidas(sVendas) {
		for (let i = 0; i < sVendas.length; i++) {
			const paramConsigFinalizado = '&CONSIG_FINALIZADO=S';
			const response = await requisicao('POST', '/Sisplan/Vendas/V1/Cancelar?', `OBS=${'CANCELAMENTO EFETUADO PELA TELA AGRUPAMENTO DE VENDA'}&MOV_ESTOQUE=N&CODVEN=${sVendas[i]}${paramConsigFinalizado}`, '', 150000);
			const jsonStr = response.text();
			if (response.status != 200) {
				msgErro(jsonStr.mensagem);
				return;
			}

		}
	}

	async function carregaBarrasLog() {
		const arrVendas = [];
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				arrVendas.push($('#tabelaVendas').DataTable().row(i).data().CODVEN);
			}
		}

		if (arrVendas.length > 0) {
			const pesquisaParam = {
				tabela: 'ITVENDA_BARRA',
				camposSelect: ['CODIGO', 'COR', 'TAMANHO', 'BARRA_LOG'],
				where: [`CODVEN IN (${arrVendas.toString()}) AND EMP_ID = ${getCookie('emp_id')}`],
			}
			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			if (jsonStr && jsonStr.length > 0) {
				for (let i = 0; i < jsonStr.length; i++) {
					const item = {
						codigo: jsonStr[i].CODIGO,
						cor: jsonStr[i].COR,
						tam: jsonStr[i].TAMANHO,
						barra: jsonStr[i].BARRA_LOG
					}
					listaBarrasNaoBipadas.push(item);
				}
			}
		}
	}

	async function confirmaConferencia() {

		if (await verificaCaixa()) {
			return;
		}

		const infosVenda = [];
		const vendedorPadraoVenda = parametrosVenda[59];
		const mantemTipoConsignado = parametrosVenda[80] == "1";

		try {
			for (let i = 0; i < $('#txtVendas').val().split(', ').length; i++) {
				infosVenda[i] = await retornaInfosVenda($('#txtVendas').val().split(', ')[i]);
			}
			const mantemStatus = infosVenda.filter(info => info.STATUS !== '');
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const possuiStatusDiferente = infosVenda.filter(info => info.STATUS === infosVenda[0].STATUS && info.STATUS !== '').length > 0;
			const possuiStatusVazio = infosVenda.filter(info => info.STATUS === '').length > 0;
			const bGuiasIguais = infosVenda.map(info => info.CODREP2).every(guia => guia === infosVenda[0].CODREP2);
			if ((possuiStatusDiferente) && (!possuiStatusVazio)) {
				for (let i = 0; i < infosVenda.length; i++) {
					infosVenda[i].STATUS = '';
				}
			} else {
				if (!possuiStatusVazio) {
					for (let i = 0; i < infosVenda.length; i++) {
						infosVenda[i].STATUS = mantemStatus[0].STATUS;
					}
				}
			}

			const venda = retornaJsonVenda(infosVenda[0], dtAtual);

			if (bGuiasIguais) {
				venda.CODREP2 = infosVenda[0].CODREP2;
			}

			let gerouConsignado = false;
			$.LoadingOverlay('show');
			try {

				// cancela vendas selecionadas para conferência
				await cancelaVendasConferidas($('#txtVendas').val().split(', '));

				// grava venda com itens não conferidos
				if (venda.ITENS.length > 0) {
					const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
					venda.CODVEN = sCodven;
					if (vendedorPadraoVenda != '') {
						venda.CODREP = pegaChave(vendedorPadraoVenda);
					}
					if (mantemTipoConsignado) {
						venda.VENDA_TIPO = "2";
					}
					await gravaVenda(venda, false);
					await salvaAgrupado($('#txtVendas').val().split(', '), sCodven, true);
				}

				// se check estiver marcado grava itens conferidos como consignado
				if ($('#checkConsig').is(':checked')) {
					if (validaConsignado()) {
						gerouConsignado = true;
						const sCodvenConsig = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
						venda.CODVEN = sCodvenConsig;
						const consignado = retornaJsonConsignado(venda);
						await gravaConsignado(consignado);
					} else {
						msgAlerta('Consignado não gerado pois não havia nenhum item bipado.');
					}
				}


				await criaMensagemSucesso(($('#checkConsig').is(':checked') && gerouConsignado) ? `Venda pendente:${venda.CODVEN} e consignado criados com sucesso` : venda.CODVEN != '' ? `Venda pendente: ${venda.CODVEN} criada com sucesso!` : '', () => {
					setCookie('vai_para_aba_itens', 'true');
					if (venda.CODVEN != '') {
						window.location.href = `${BASE_URI}/venda/${venda.CODVEN}`;
					} else {
						window.location.href = `${BASE_URI}/agrupamento_venda`
					}
				});

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	async function cancelaVendasSemSaldo(listaVendas) {
		const dados = $('#tabelaDevolucao').DataTable().data().toArray();
		const dadosComSaldo = dados.filter(item => item.QTDE > item.QTDE_DEV);
		const vendasComSaldo = [...new Set(dadosComSaldo)].map(item => String(item.VENDA));

		const vendasFinalizadas = listaVendas.filter(venda => {
			if (!vendasComSaldo.includes(venda)) {
				return venda;
			}
		});
		if (vendasFinalizadas.length > 0) {
			await cancelaVendasConferidas(vendasFinalizadas);
		}
	}

	async function confirmaDevolucao() {
		try {

			if (await verificaCaixa()) {
				return;
			}

			// await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
			const infosVenda = await retornaInfosVenda($('#txtVendasDev').val().split(', ')[0]);
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const venda = retornaJsonDevolucao(infosVenda, dtAtual);

			$.LoadingOverlay('show');
			try {
				if (venda.ITENS.length > 0) {
					msgAlerta('Deseja imprimir a venda?', async () => {
						try {
							$.LoadingOverlay('show');
							const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
							venda.CODVEN = sCodven;
							await gravaVenda(venda, true);
							await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
							await imprimirAgrupamento();
							await criaMensagemSucesso('Devolução criada com sucesso', () => {
								$('#modalDevolucao').modal('hide');
								$('#btnConsultar').trigger('click');
							});
						} finally {
							$.LoadingOverlay('hide');
						}
					},
						async () => {
							try {
								$.LoadingOverlay('show');
								const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
								venda.CODVEN = sCodven;
								await gravaVenda(venda, true);
								await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
								await criaMensagemSucesso('Devolução criada com sucesso', () => {
									$('#modalDevolucao').modal('hide');
									$('#btnConsultar').trigger('click');
								});
							} finally {
								$.LoadingOverlay('hide');
							}
						}
					);
				} else {
					await criaMensagemErro('Nenhum item devolvido, impossível continuar.', () => { });
				}
			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	async function confirmaAgrupaVendas() {

		if (await verificaCaixa()) {
			return;
		}

		const infosVenda = [];
		const vendedorPadraoVenda = parametrosVenda[59];

		try {
			for (let i = 0; i < $('#txtAgrupaVendas').val().split(', ').length; i++) {
				infosVenda[i] = await retornaInfosVenda($('#txtAgrupaVendas').val().split(', ')[i]);
			}
			const mantemStatus = infosVenda.filter(info => info.STATUS !== '');
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const possuiStatusDiferente = infosVenda.filter(info => info.STATUS === infosVenda[0].STATUS && info.STATUS !== '').length > 0;
			const possuiStatusVazio = infosVenda.filter(info => info.STATUS === '').length > 0;
			const bGuiasIguais = infosVenda.map(info => info.CODREP2).every(guia => guia === infosVenda[0].CODREP2);
			if ((possuiStatusDiferente) && (!possuiStatusVazio)) {
				for (let i = 0; i < infosVenda.length; i++) {
					infosVenda[i].STATUS = '';
				}
			} else {
				if (!possuiStatusVazio) {
					for (let i = 0; i < infosVenda.length; i++) {
						infosVenda[i].STATUS = mantemStatus[0].STATUS;
					}
				}
			}

			const venda = retornaJsonAgrupamentoVendas(infosVenda[0], dtAtual);

			if (bGuiasIguais) {
				venda.CODREP2 = infosVenda[0].CODREP2;
			}

			$.LoadingOverlay('show');
			try {

				// cancela vendas selecionadas para conferência
				await cancelaVendasConferidas($('#txtAgrupaVendas').val().split(', '));

				// grava venda com itens não conferidos
				if (venda.ITENS.length > 0) {
					const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
					venda.CODVEN = sCodven;
					if (vendedorPadraoVenda != '') {
						venda.CODREP = pegaChave(vendedorPadraoVenda);
					}
					await gravaVenda(venda, false);
					await salvaAgrupado($('#txtAgrupaVendas').val().split(', '), sCodven, false);
				}

				await criaMensagemSucesso(`Venda pendente: ${venda.CODVEN} criada com sucesso!`, () => { window.location.href = `${BASE_URI}/loja` });

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	function validaConsignado() {
		return $("#tabelaItens").DataTable().column(5, {}).data().sum() > 0;
	}

	async function retornaInfosVenda(sCodVen) {
		const pesquisaParam = {
			tabela: 'VENDA',
			camposSelect: ['ENTIDADE.NOME', 'VENDA.CODCLI', 'VENDA.TABELA', 'ENTIDADE.CNPJ', 'VENDA.CODREP', 'VENDA.NRCAIXA', 'VENDA.STATUS', 'VENDA.CODREP2'],
			leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' }],
			where: [`VENDA.CODVEN = ${sCodVen} AND VENDA.EMP_ID= ${getCookie('emp_id')}`]
		}
		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
		return jsonStr[0];
	}

	async function salvaAgrupado(sVendas, sCodven, consignado) {
		const response = await requisicao('POST', '/sisplan/vendas/v1/salvaagrupado?', `&VENDAS=${sVendas}&CDAGRUPADA=${sCodven}&CONSIGNADO=${consignado}`);
		const jsonStr = await response.text();
		if (response.status != 200) {
			msgErro(jsonStr.mensagem);
			return;
		}
	}

	async function verificaCaixa() {
		const caixa = pegaChave("#txtCaixa");
		const data = new Date();
		try {
			const response = await requisicao('GET', '/sisplan/vendas/v1/verificastatuscaixa?', `CAIXA=${caixa}&DATA=${data.toISOString().slice(0, 10)}`, '', 30000);

			if (!response) {
				msgAlerta("Não foi possível verificar o caixa, tente novamente.");
				return true;
			}

			const jsonStr = await response.json();
			if (response.status != 200) {
				msgAlerta("Não foi possível verificar o caixa, tente novamente.");
				return true;
			}

			if (jsonStr == "true") {
				msgAlerta("Não foi possível fechar a venda. \r\nMotivo: Caixa do dia " + data.toLocaleDateString() + " já fechado!");
				return true;
			} else {
				return false;
			}

		} catch (error) {
			console.error(error);
			return true;
		}
	}

	$('#btn-iniciar-epc').on('click', async function () {
		try {
			$('#btn-iniciar-epc').prop('disabled', true);
			$('#btn-parar-epc').prop('disabled', false);
			$('#btnIniciarEPCConferencia').prop('disabled', true);
			$('#btnPararEPCConferencia').prop('disabled', true);
			epcVenda = true;
			await iniciarEPC();
		} catch (error) {
			console.error(error)
		}
	})

	$('#btn-parar-epc').on('click', async function () {
		try {
			$('#btn-iniciar-epc').prop('disabled', false);
			$('#btn-parar-epc').prop('disabled', true);
			$('#btnIniciarEPCConferencia').prop('disabled', false);
			$('#btnPararEPCConferencia').prop('disabled', false);
			await pararEPC();
		} catch (error) {
			console.error(error)
		}
	})

	async function iniciarEPC() {
		$.LoadingOverlay("show");
		try {
			const url = '/epc/inicia?';
			const response = await requisicao_ecf('POST', url, `INTEGRACAO=${integracaoEPC}`);

			if ((!response) || (response.status != 200)) {
				msgAlerta('Erro ao iniciar a leitura RFID!');
			}

		} catch (error) {
			console.error('Erro ao iniciar a leitura RFID', error);
		} finally {
			$.LoadingOverlay("hide");
		}
	}

	async function pararEPC() {
		$.LoadingOverlay("show");
		try {
			const url = '/epc/para?';
			const response = await requisicao_ecf('PUT', url, `INTEGRACAO=${integracaoEPC}`);

			if ((!response) || (response.status != 200)) {
				msgAlerta('Erro ao parar a leitura RFID!');
			}

			await retornaCodigosEPC();

		} catch (error) {
			console.error('Erro ao parar a leitura RFID', error);
		} finally {
			$.LoadingOverlay("hide");
		}
	}

	async function retornaCodigosEPC(estorno = false, listaEPC) {
		$.LoadingOverlay("show");
		try {
			const url = '/epc/retorna?';
			const response = await requisicao_ecf('GET', url, `INTEGRACAO=${integracaoEPC}`);

			if ((!response) || (response.status != 200)) {
				msgAlerta('Erro ao retornar codigos da leitura RFID!')
			}
			listaBarrasForamBipadasEPC = JSON.parse(await response.text());

			if (integracaoEPC == '2') {
				listaBarrasForamBipadasEPC = listaBarrasForamBipadasEPC.data.epcs;
			}

			if (listaBarrasForamBipadasEPC.length == 0) {
				msgAlerta('Nenhum código bipado!');
				return;
			}

			if (!estorno) {
				if (await barraJaEstaBipadaEPC()) {
					return;
				}
			}

			if (listaBarrasForamBipadasEPC.length > 0) {
				await retornaProdutosEPC(estorno ? listaEPC : listaBarrasForamBipadasEPC, estorno);
			}

		} catch (error) {
			console.error('Erro ao retornar codigos da leitura RFID', error);
		} finally {
			$.LoadingOverlay("hide");
		}
	}

	async function barraJaEstaBipadaEPC(sCodigoEPC) {
		try {
			// aqui ele pega os que foram bipados e compara com os que estão na tabela itens para nao bipar 2x
			const barrasLidas = listaBarrasForamBipadasEPC.filter((barrasBipadas) => listaBarrasBipadasEPC.includes(barrasBipadas));

			if (barrasLidas.length > 0) {
				// aqui ele pega só os que foram bipados e joga pra variavel global
				listaBarrasForamBipadasEPC = listaBarrasForamBipadasEPC.filter((barrasBipadas) => !listaBarrasBipadasEPC.includes(barrasBipadas));
				msgAlerta(`RFID ${barrasLidas.join(', ')} já lido nesta expedição, o mesmo será estornado.`);
				await limpaEPCSBipados(barrasLidas)
				return true;
			}

			return false;

		} catch (error) {
			console.error('barra_EPC', error);
			msgErro('Erro ao processar barra EPC.');
		}
	}

	async function retornaProdutosEPC(codigos, estorno = false) {

		async function retornaIdEPC(codigos) {
			const codigosWhere = codigos.map((codigo) => "'" + codigo + "'");
			const pesquisaIdEPC = {
				tabela: "EPC",
				camposSelect: [
					"EPC",
					"ID",
					"PERMITE_MOVIMENTACAO",
				],
				where: [`EPC IN (${codigosWhere.toString()})`],
			};

			const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaIdEPC));


			await verificaSeTodosEPCsExistem(codigos, json);

			return json;
		}

		async function verificaSeTodosEPCsExistem(codigos, retornos) {
			try {
				const codigosRetornados = retornos.map((codigo) => codigo.EPC);
				const codigoNaoExiste = codigos.filter((codigo, i) => !codigosRetornados.includes(codigo));

				if (codigoNaoExiste.length > 0) {
					msgAlerta(`Codigos: ${JSON.stringify(codigoNaoExiste)} não existem ou estão desativado na base de dados, faça a bipagem manual`)
				}

			} catch (error) {
				console.error('Erro verificar codigos RFID', error);
			}
		}

		async function retornaDadosProdutoEPC(dadosEPC) {
			const ids = dadosEPC.map((dado) => "'" + dado.ID + "'");

			const pesquisaDadosProdutosEPC = {
				tabela: "EPC_PRODUTO",
				camposSelect: [
					"EPC_PRODUTO.CODIGO",
					"EPC_PRODUTO.COR",
					"EPC_PRODUTO.TAMANHO",
					"EPC.EPC",
				],
				leftjoin: [{
					tabela: "EPC",
					condicao: "EPC_PRODUTO.ID_EPC = EPC.ID"
				}],
				where: [`EPC_PRODUTO.ID_EPC IN (${ids.toString()})`],
			};

			const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDadosProdutosEPC));

			return json;
		}

		try {
			const dadosEPC = await retornaIdEPC(codigos);
			const naoPermiteMovimentacao = dadosEPC.filter((dadoEPC) => dadoEPC.PERMITE_MOVIMENTACAO != 'S');
			const permiteMovimentacao = dadosEPC.filter((dadoEPC) => dadoEPC.PERMITE_MOVIMENTACAO == 'S');
			if (permiteMovimentacao.length > 0) {
				const produtos = await retornaDadosProdutoEPC(permiteMovimentacao);
				await bipaEPC(produtos, estorno);
			}
			naoPermiteMovimentacao.length > 0 && msgAlerta(`Codigos: ${naoPermiteMovimentacao.map((dado) => `${dado.EPC},`)} não existem ou estão desativados na base de dados, faça a bipagem manual!`);

		} catch (error) {
			console.error(error)
		}
	}

	async function limpaEPCSBipados(barras) {
		try {
			await retornaCodigosEPC(true, barras);
			listaBarrasBipadasEPC = listaBarrasBipadasEPC.filter((barrasBipadas) => !barras.includes(barrasBipadas));
			listaBarrasForamBipadasEPC = [];
		} catch (error) {
			console.error('Erro ao limpar a leitura RFID', error);
		}
	}

	async function bipaEPC(itensEPC, estorno) {

		async function retornaBarrasEPC(itens) {
			const arrayBarras = [];
			await Promise.all(itens.map(async (item) => {

				const dadosBarraEPC = {
					tabela: "PA_ITEN",
					camposSelect: [
						"BARRA",
						"BARRACLI",
						"BARRA28",
						"ID_PA_ITEN",
						`'${item.EPC}' EPC`
					],
					where: [`CODIGO = '${item.CODIGO}' AND COR = '${item.COR}' AND TAM = '${item.TAMANHO}' AND DEPOSITO = '${$('#tabelaDevolucao').DataTable().row(0).data().DEPOSITO}' `],
				};

				const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosBarraEPC));
				if ((json) && (json.length > 0)) {
					if (json[0].BARRA != '') {
						arrayBarras.push({
							BARRA: json[0].BARRA,
							IDITEM: json[0].ID_PA_ITEN,
							EPC: json[0].EPC
						});
					} else if (json[0].BARRACLI != '') {
						arrayBarras.push({
							BARRA: json[0].BARRACLI,
							IDITEM: json[0].ID_PA_ITEN,
							EPC: json[0].EPC
						});
					} else if (json[0].BARRA28 != '') {
						arrayBarras.push({
							BARRA: json[0].BARRA28,
							IDITEM: json[0].ID_PA_ITEN,
							EPC: json[0].EPC
						});
					} else {
						arrayBarras.push({
							BARRA: '',
							IDITEM: json[0].ID_PA_ITEN,
							EPC: json[0].EPC
						});
					}
				} else {
					msgAlerta(`Não existe barra para esse RFID: ${item.EPC}`);
				}
			}));

			return arrayBarras
		}

		try {
			const barrasEPC = await retornaBarrasEPC(itensEPC);

			async function processarBarras() {
				for (const barra of barrasEPC) {
					$('#txtBarraDev').val(barra.BARRA);
					// $('#txtCodigoEPC').val(barra.EPC);
					await confereBarraDev();
					await sleep(150);
				}
			}

			await processarBarras();
		} catch (error) {
			console.error(error);
		}
	}

	async function adicionaBarraBipadaEPC() {
		if (integracaoEPC != '0') {
			const codigoEPC = $('#txtCodigoEPC').val();
			try {
				if (codigoEPC != '') {
					listaBarrasBipadasEPC.push(codigoEPC);
					return true;
				}
				$('#txtCodigoEPC').val('');
			} catch (error) {
				console.error(error);
			}
		}
	}

	function retornaCodigosGravacaoEPC(numeroPedido, bUsaIntegraçãoITAG) {
		if (bUsaIntegraçãoITAG) {
			const objeto = {
				Numero: numeroPedido,
				Id: '',
				CodigosEPC:
					listaBarrasBipadasEPC.map((lista) => {
						const objeto = {
							EPC: lista
						}
						return objeto
					}),
			}
			return objeto;
		} else {
			const objeto = {
				Numero: numeroPedido,
				Id: '',
				CodigosEPC: []
			}
			return objeto
		}
	}

	$('#somAtivoDev').on('click', function () {
		$(this).addClass('d-none');
		localStorage.setItem("@consignado.somAtivo", false);
		$('#somInativoDev').removeClass('d-none');
	});

	$('#somInativoDev').on('click', function () {
		$(this).addClass('d-none');
		localStorage.setItem("@consignado.somAtivo", true);
		$('#somAtivoDev').removeClass('d-none');
	});

	const somAtivo = localStorage.getItem('@consignado.somAtivo') ?? 'false';
	if (somAtivo == 'true') {
		$($('#somInativoDev')[0]).trigger('click');
	}

	$('#somAtivoBarra').on('click', function () {
		$(this).addClass('d-none');
		localStorage.setItem("@consignado.somAtivo", false);
		$('#somInativoBarra').removeClass('d-none');
	});

	$('#somInativoBarra').on('click', function () {
		$(this).addClass('d-none');
		localStorage.setItem("@consignado.somAtivo", true);
		$('#somAtivoBarra').removeClass('d-none');
	});

	const somAtivoBarra = localStorage.getItem('@consignado.somAtivo') ?? 'false';
	if (somAtivoBarra == 'true') {
		$($('#somInativoBarra')[0]).trigger('click');
	}

	async function estornaBarraBipada(sBarra) {
		try {
			sBarra = sBarra.substring(sBarra.indexOf("-") + 1, sBarra.length);
			listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
		} catch (error) {
			console.error(error);
		}
	}

});