$(document).ready(async function () {

  const colunasItens = [
    { title: 'Lote', data: 'LOTE' },
    { title: 'Tipo', data: 'TIPO' },
    { title: 'Acabamento', data: 'ACABAMENTO' },
    { title: 'Pedi Fluxo', data: 'PEDIFLUXO' },
    { title: 'Tecido', data: 'TECIDO' },
    { title: 'Cor', data: 'COR' },
    { title: 'Variante', data: 'VARIANTE' },
    { title: 'Estampa', data: 'ESTAMPA' },
    { title: 'Pedido Tinto', data: 'PEDIDOTINTO' },
    { title: 'Item Pedido Tinto', data: 'ITPEDIDOTINTO' },
    { title: 'Pedido Compra', data: 'PEDIDOCOMPRA' },
    { title: 'Item Pedido Compra', data: 'ITPEDIDOCOMPRA' },
    { title: 'Largura', data: 'LARGURA' },
    { title: 'Gramatura', data: 'GRAMATURA' },
    { title: 'Título do fio', data: 'TITULOFIO' },
    { title: 'Nota fiscal', data: 'NOTA' },
    { title: 'Quantidade', data: 'QTDE' },
    { title: 'Peças', data: 'PECAS' },
    { title: 'Unidade', data: 'UNIDADE' },
    { title: 'Ourelas', data: 'OURELAS' },
    { title: 'Engomar', data: 'ENGOMAR' },
    { title: 'Agulha', data: 'AGULHA' },
    { title: 'Observações', data: 'OBSERVACAO' },
    { title: 'Excluir', data: 'EXCLUIR' },
  ];

  const urlFal = $(window.location.href.split('/')).get(-1);

  addBotoesAvancarVoltar();
  addPesquisaAutocompleta();
  insereValor('#txtCliente', getCookie('g_nome_empresa_logada'));
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '500px', undefined, colunasItens);

  await setarDataAtual('dtEmissao');
  await validaEdicao();

  $('#btnConfirmarItem').on('click', function () {
    try {
      const item = {
        LOTE: pegaValor('#txtLote'),
        TIPO: pegaValor('#rgTipo'),
        ACABAMENTO: pegaValor('#rgAcabamento'),
        PEDIFLUXO: pegaValor('#rgPediFluxo'),
        TECIDO: pegaChave('#txtTecido'),
        COR: pegaChave('#txtCor'),
        VARIANTE: pegaChave('#txtVariante'),
        ESTAMPA: pegaValor('#txtEstampa'),
        PEDIDOTINTO: pegaValor('#txtPedidoTinto'),
        ITPEDIDOTINTO: pegaValor('#txtItPedTinto'),
        PEDIDOCOMPRA: pegaValor('#txtPedidoCompra'),
        ITPEDIDOCOMPRA: pegaValor('#txtItPedCompra'),
        LARGURA: pegaValor('#txtLargura'),
        GRAMATURA: pegaValor('#txtGramatura'),
        TITULOFIO: pegaValor('#txtTitFioFab'),
        NOTA: pegaValor('#txtNf'),
        QTDE: pegaValor('#txtQuantidade'),
        PECAS: pegaValor('#txtPecas'),
        UNIDADE: pegaValor('#rgUnidade'),
        OURELAS: pegaValor('#rgOurelas'),
        ENGOMAR: pegaValor('#rgEngomar'),
        AGULHA: pegaValor('#rgAgulha'),
        OBSERVACAO: pegaValor('#txtObsItem'),
        EXCLUIR: retornaBotaoExcluir(),
      };

      $('#tabelaItens').DataTable().row.add(item).draw(false);
    } finally {
      $('#modalAddItem').modal('hide');
    }
  });

  $('#btnAddItem').on('click', function () {
    window.event.preventDefault();
    $('#modalAddItem').modal('show');
  });

  $('#tabelaItens').on('click', '#btn-excluir', async function () {
    $("#tabelaItens").DataTable().row($(this).parents("tr")).remove().draw(false);
  });

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/servtingimento`;
  });

  $('#btnGravar').on('click', async function () {
    if ($('#tabelaItens').DataTable().rows().length == 0) {
      msgAlerta('Necessário adicionar pelo menos um item a FAL.')
      return;
    }

    await gravaDados();
  });

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      const fal = {
        NUMERO: pegaValor('#txtNumero'),
        EMP_ID: getCookie('emp_id'),
        DATA_INI: pegaValor('#dtEmissao'),
        OBS: pegaValor('#txtObservacoes'),
        STATUS: pegaValor('#txtStatus'),
        FAT_PED_COMPLETO: isChecked('#cbFatPedidoCompleto') ? 'S' : 'N',
        ITENS: retornaItensFal()
      }

      const response = await requisicao('POST', '/sisplan/fal/v1/fal?', '', JSON.stringify(fal));

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      const jsonStr = await response.json();

      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }

      criaMensagemSucesso('FAL cadastrada com sucesso!', () => { window.location.href = `${BASE_URI}/servtingimento` });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function retornaItensFal() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map(item => {
      arrItens.push(item);
    });
    return arrItens;
  }

  async function validaEdicao() {
    if (urlFal == 'create') {
      insereValor('#txtNumero', await RetornaProximo("FAL", "FAL", "NUMERO", 5));
      $('#txtNumero').prop('disabled', true);
      return;
    }

    $.LoadingOverlay('show');
    try {
      $('#txtNumero').prop('disabled', true);
      $('#dtEmissao').prop('disabled', true);
      insereValor('#txtNumero', urlFal);
      // edita FAL
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function addPesquisaAutocompleta() {
    $('#txtTecido').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnTecido").pesquisa_serverside(["#txtTecido"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Material");
    $('#btnATecido').on('click', function () { $('#txtTecido').val('') });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
    $('#btnACor').on('click', function () { $('#txtCor').val(''); });

    $('#txtVariante').autocompleta(1, `JSON={ "tabela":"VARIANTE", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $("#btnVariante").pesquisa_serverside(["#txtVariante"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"VARIANTE", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Variante");
    $('#btnAVariante').on('click', function () { $('#txtVariante').val('') });
  };

  function retornaBotaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  }

  function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaDuplicatas").DataTable().columns.adjust().draw(false);
      // $("#tabelaItens").DataTable().columns.adjust().draw(false);
    });
  };
});