$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relPosCtasPag == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosCtasPag: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosCtasPag: novasColunas }))

      $('#tabelaPosicaoCtasPag').DataTable().columns().visible(true);
      $('#tabelaPosicaoCtasPag').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })
  
  componenteFiltro("situacao", true);
  componenteFiltro("banco", true);
  componenteFiltro("fornecedor", true);
  componenteFiltro("classe", true);
  componenteFiltro("historico", true);
  componenteFiltro("ramoAtividade", true);
  componenteFiltro("grupoCli", true);
  componenteFiltro("centroCusto", true);

  await preencheOrdenacaoTela("RelPosCtasPag");

  $("#btnFiltrosRel").on("click", function () {
    $("#modal-filtros").modal("show");
    let dataAtual = new Date().toISOString().split('T')[0];
    $("#txtData").val(dataAtual);
  });

  $("#btnLimpaFiltros").on("click", function () {
    limpaFiltros();
  });

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $("#btnConsultar").on("click", async function () {
    await fazConsulta();
    if ($("#txtOrdem option").toArray().lenght > 0){
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => {return [map.selected, $(map).attr('nome_prt')]}).filter(filter => filter[0] == true)[0][1])
    }
    $('#modal-filtros').modal('hide');
  });

  retornaHintRelatorio('btnImprimir','RelPosCtasPag')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show'); 
      try {
        const url = `/sisplan/impressao/v1/imprimirrelposctaspag?`;
        const ordem = `&TELA_ORDENACAO=RelPosCtasPag&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('relposctaspag');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'relposctaspag');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaPosicaoCtasPag')) {
      $("#tabelaPosicaoCtasPag").DataTable().destroy();
      $("#tabelaPosicaoCtasPag").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');

      const url = "/sisplan/impressao/v1/consultarelposctaspag?";
      const filtros = await retornaFiltros();
      const response = await requisicao("GET", url, `${filtros}&COD_USUARIO=${getCookie("cod_usuario")}`, "", 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtMeta").val();
        if ($.fn.DataTable.isDataTable('#tabelaPosicaoCtasPag')) {
          $('#tabelaPosicaoCtasPag').DataTable().destroy();
          $('#tabelaPosicaoCtasPag').empty();
        }
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      let indiceValor;

      for (let i = 0; i < keys.length; i++) {
        if (keys[i] == 'VALOR') {
          indiceValor = i;
        }
      }

      $('#tabelaPosicaoCtasPag').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
        columnDefs: [
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });

            },
            "targets": [4],
            "className": 'pr-4 text-right'
          },
          {
            "type": 'date-br',
            "targets": [10, 11, 12],
            "render": function (data) {
              if (data != undefined && data != '') {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          },
        ],
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaPosicaoCtasPag_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPosicaoCtasPag_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelposctaspag?';
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Posição de Constas a Pagar', '#tabelaPosicaoCtasPag');
      })


      $('#tabelaPosicaoCtasPag').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relPosEstoque).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    $('#tabelaPosicaoCtasPag').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });
    adicionaColunas(cols, colunasInvisiveis.relPosCtasPag ?? [])
  });


  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const situacoesFiltradas = await formataListas($("#txtSituacao").val().toString());
    const bancosFiltrados = await formataListas($("#txtBanco").val().toString());
    const fornecedorFitlrados = await formataListas($("#txtFornecedor").val().toString());
    const classesFiltradas = await formataListas($("#txtClasse").val().toString());
    const historicosFiltrados = await formataListas($("#txtHistorico").val().toString());
    const ramoAtividadeFiltrados = await formataListas($("#txtRamoAtividade").val().toString());
    const gruposCliFiltrados = await formataListas($("#txtGrupoCli").val().toString());
    const centroCustoFiltrados = await formataListas($("#txtCentroCusto").val().toString());

    const data = $("#txtData").val();
    const filtro = $('input[name="rdfiltro"]:checked').val();

    const tipoAP = $("#cbAP").is(":checked") ? 1 : 0;
    const tipoAntecipacao = $("#cbAntecipacao").is(":checked") ? 1 : 0;
    const tipoOrcamento = $("#cbOrcamento").is(":checked") ? 1 : 0;
    const tipoCheque = $("#cbCheque").is(":checked") ? 1 : 0;

    const consideraSituacao = $("#cbConsideraSituacao").is(":checked") ? 1 : 0;
    const consideraFornecedor = $("#cbConsideraFornecedor").is(":checked") ? 1 : 0;
    const consideraHistorico = $("#cbConsideraHistorico").is(":checked") ? 1 : 0;
    const consideraGrupoCli = $("#cbConsideraGrupoCli").is(":checked") ? 1 : 0;

    const filtros =
      `DATA=${data}` +
      `&FILTRO=${filtro}` +
      `&TIPOAP=${tipoAP}` +
      `&TIPOANTECIPACAO=${tipoAntecipacao}` +
      `&TIPOORCAMENTO=${tipoOrcamento}` +
      `&TIPOCHEQUE=${tipoCheque}` +
      `&EMPRESASFILTRADAS=${empresasFiltradas}` +
      `&SITUACAO=${situacoesFiltradas}` +
      `&CONSIDERASITUACAO=${consideraSituacao}` +
      `&BANCO=${bancosFiltrados}` +
      `&FORNECEDOR=${fornecedorFitlrados}` +
      `&CONSIDERAFORNECEDOR=${consideraFornecedor}` +
      `&CLASSES=${classesFiltradas}` +
      `&HISTORICO=${historicosFiltrados}` +
      `&CONSIDERAHISTORICO=${consideraHistorico}` +
      `&RAMOATIVIDADE=${ramoAtividadeFiltrados}` +
      `&GRUPOCLIENTE=${gruposCliFiltrados}` +
      `&CONSIDERAGRUPOCLIENTE=${consideraGrupoCli}` +
      `&CENTROCUSTO=${centroCustoFiltrados}`;

    return filtros;
  }

  function limpaFiltros() {
    $("#txtData").val("1200-01-01");
    $("#cbConsideraSituacao").prop('checked', true);
    $("#cbConsideraFornecedor").prop('checked', true);
    $("#cbConsideraHistorico").prop('checked', true);
    $("#cbConsideraGrupoCli").prop('checked', true);

    $("#txtSituacao").empty().trigger("change");
    $("#txtBanco").empty().trigger("change");
    $("#txtFornecedor").empty().trigger("change");
    $("#txtClasse").empty().trigger("change");
    $("#txtSituacao").empty().trigger("change");
    $("#txtRamoAtividade").empty().trigger("change");
    $("#txtGrupoCli").empty().trigger("change");
    $("#txtCentroCusto").empty().trigger("change");
  }

  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
      });
      driver.defineSteps([
        {
          element: "#btnFiltrosRel",
          popover: {
            title: "Botão Filtros",
            description:
              "Clique aqui para abrir os filtros e realizar alguma consulta.",
            position: "right",
          },
        },
        {
          element: "#btnImprimir",
          popover: {
            title: "Botão Imprimir",
            description: "Clique aqui para imprimir um relatório.",
            position: "right",
          },
        },
      ]);
      driver.start();
    });
  });
});
