$(document).ready(async function () {
  // autocompleta
  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
  $('#txtConta').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

  // pesquisa
  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
  $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
  $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
  $('#btn-Conta').pesquisa('#txtConta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta', 'cadconta');

  // limpa campos
  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btn-limpa-Fornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });
  $('#btn-limpa-Situacao').on('click', function () {
    $('#txtSituacao').val('');
  });
  $('#btn-limpa-Banco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });

  // modais
  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/pagar?`;
        const classeGer = pegaChave('#txtClasse');
        const numAp = $('#txtNumAp').val();
        const banco = pegaChave('#txtBanco');
        const situacao = pegaChave('#txtSituacao');
        const fornecedor = pegaChave('#txtFornecedor');
        const conta = pegaChave('#txtConta');

        const params = `CLASSE_GER=${classeGer}&NUM_AP=${numAp}&FORNECEDOR=${fornecedor}&BANCO=${banco}&SITUACAO=${situacao}&CONTA=${conta}`;
        let arquivo = await GeraRelatorio(`${url + params}&`, 'GET', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/consultarelpagar?';

        const classeGer = pegaChave('#txtClasse');
        const numAp = $('#txtNumAp').val();
        const banco = pegaChave('#txtBanco');
        const situacao = pegaChave('#txtSituacao');
        const fornecedor = pegaChave('#txtFornecedor');
        const conta = pegaChave('#txtConta');

        const params = `CLASSE_GER=${classeGer}&NUM_AP=${numAp}&FORNECEDOR=${fornecedor}&BANCO=${banco}&SITUACAO=${situacao}&CONTA=${conta}`;

        const response = await requisicao('GET', url, params, 30000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          $('#txtClasse').val('');
          $('#txtNumAp').val('');
          $('#txtBanco').val('');
          $('#txtSituacao').val('');
          $('#txtFornecedor').val('');
          $('#txtConta').val('');
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelPagar').DataTable({
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "data": jsonStr,
          "columns": dataSetCols
        });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelPagar',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});