$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.RelMinuta == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, RelMinuta: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, RelMinuta: novasColunas }))

      $('#tabelaRelMinuta').DataTable().columns().visible(true);
      $('#tabelaRelMinuta').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  addTutorial();
  await preencheOrdenacaoTela('RelMinuta');
  addPesquisaAutocompleta();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    limpaFiltros();
  });

  retornaHintRelatorio('btnImprimir', 'RelMinuta')
  retornaHintRelatorio('btnImprimirEtiqueta', 'RelMinutaEtiqueta')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelminuta?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelMinuta&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMinuta');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelMinuta');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImprimirEtiqueta').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelminuta?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelMinutaEtiqueta&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMinutaEtiqueta');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelMinutaEtiqueta');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#rdEtiqueta').on('change', async function (){
    if ($('#rdEtiqueta').is(':checked')){
      $('#txtOrdem').empty()
      await preencheOrdenacaoTela('RelMinutaEtiqueta');
    }
  }) 

  $('#rdMinuta').on('change', async function (){
    if ($('#rdMinuta').is(':checked')){
      $('#txtOrdem').empty()
      await preencheOrdenacaoTela('RelMinuta');
    }
  }) 

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().lenght > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1], true)
    }
    if ($.fn.DataTable.isDataTable('#tabelaRelMinuta')) {
      $('#tabelaRelMinuta').DataTable().destroy();
      $('#tabelaRelMinuta').empty();
    }
    try {
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/relminuta?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!')
        return;
      }

      if ($('#rdEtiqueta').is(':checked')){
        $('#btnImprimir').addClass('d-none')
        $('#btnImprimirEtiqueta').removeClass('d-none')
      } else {
        $('#btnImprimir').removeClass('d-none')
        $('#btnImprimirEtiqueta').addClass('d-none')
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaRelMinuta', true, true, true, true, true, true, true, jsonStr, dataSetCols, [], [10,11], [], [5, 6, 7], '', 2, 'buttonColVis', 'buttonExcel', true, [], [12]);


      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/relminuta?';
        const filtros = await retornaFiltros();

        await exportaCSV(url, filtros, false, null, 'Relatório de Minuta', '#tabelaRelMinuta');
      });


      $('#tabelaRelMinuta').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relMinuta).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelMinuta').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relMinuta ?? [])
  })

  function limpaFiltros() {
    $('#dtEmissaoDe').val('');
    $('#dtEmissaoAte').val('');
    $('#dtSaidaDe').val('');
    $('#dtSaidaAte').val('');
    $('#dtEmbarqueDe').val('');
    $('#dtEmbarqueAte').val('');
    $('#txtNotaDe').val('');
    $('#txtNotaAte').val('');
    $('#txtObs').val('');
    $('#txtChave').val('');
    $('#selectNotas').val('');
    $('#txtCliente').empty().trigger('change');
    $('#txtRepresentante').empty().trigger('change')
    $('#txtTransportadora').empty().trigger('change')
    $('#txtTipoCliente').empty().trigger('change')
    $('#txtUf').empty().trigger('change')
    $('#txtOperacaoFiscal').empty().trigger('change')
    $('#txtPlaca').empty().trigger('change')
    $('#txtTipoVenda').empty().trigger('change')
    $('#txtNota').empty().trigger('change')
    $('#cbNotasDenegadas').prop('checked', false)
    $('#cbExpedicao').prop('checked', false)
    $('#cbSemDtEmbarque').prop('checked', false)
    $('#cbTipoNatVenda').prop('checked', false)
    $('#rdMinuta').prop('checked', true)
  }

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;

    const retorno =
      `EMISSAODE=${$('#dtEmissaoDe').val()}` +
      `&EMISSAOATE=${$('#dtEmissaoAte').val()}` +
      `&SAIDADE=${$('#dtSaidaDe').val()}` +
      `&SAIDAATE=${$('#dtSaidaAte').val()}` +
      `&EMBARQUEDE=${$('#dtEmbarqueDe').val()}` +
      `&EMBARQUEATE=${$('#dtEmbarqueAte').val()}` +
      `&NOTADE=${$('#txtNotaDe').val()}` +
      `&NOTAATE=${$('#txtNotaAte').val()}` +
      `&OBS=${$('#txtObs').val()}` +
      `&CHAVE=${$('#txtChave').val()}` +
      `&TIPONOTA=${$('#selectNotas').val()}` +
      `&TRANSPORTADORA=${await formataListas($('#txtTransportadora').val().toString())}` +
      `&TIPOCLIENTE=${await formataListas($('#txtTipoCliente').val().toString())}` +
      `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&UF=${await formataListas($('#txtUf').val().toString())}` +
      `&OPERACAOFISCAL=${await formataListas($('#txtOperacaoFiscal').val().toString())}` +
      `&PLACA=${await formataListas($('#txtPlaca').val().toString())}` +
      `&TIPOVENDA=${await formataListas($('#txtTipoVenda').val().toString())}` +
      `&NOTAS=${await formataListas($('#txtNota').val().toString())}` +
      `&NOTADENEGADA=${$('#cbNotasDenegadas').is(':checked') ? true : false}` +
      `&EXPEDICAO=${$('#cbExpedicao').is(':checked') ? true : false}` +
      `&SEMDTEMBARQUE=${$('#cbSemDtEmbarque').is(':checked') ? true : false}` +
      `&TIPONATVENDA=${$('#cbTipoNatVenda').is(':checked') ? true : false}` +
      `&TIPO=${$('#rdMinuta').is(':checked') ? 'M' : 'E'}` +
      `&TODASEMPRESAS=${todasEmpresas}` +
      `&EMPRESAS=${empresasFiltradasFormatada}`
    return retorno;
  }

  function addTutorial() {
    $('#tutorial').on('click', function () {
      $(document).ready(async function () {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
          element: '#btnFiltros',
          popover: {
            title: 'Botão Filtros',
            description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
            position: 'right'
          }
        },
        {
          element: '#btnImprimir',
          popover: {
            title: 'Botão Imprimir',
            description: 'Clique aqui para imprimir um relatório.',
            position: 'right'
          }
        },
        {
          element: '#tabelaRelMinuta',
          popover: {
            title: 'Tabela Notas',
            description: 'Aqui, após clicar em consultar ficam os dados das notas filtradas.',
            position: 'bottom'
          }
        }
        ]);
        driver.start();
      });
    });
  }

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $('#txtChave').on('blur', async function () {
    if ($('#txtChave').val() != '') {
      let chave = $('#txtChave').val()
      $.LoadingOverlay('show')
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"NOTA", 
              "camposSelect":["FATURA", "CHAVE_NFE"], 
              "where": ["CHAVE_NFE = '${chave}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        await insereValorPesquisaVarios('txtNota', 'FATURA', 'CHAVE_NFE', jsonStr.RESULT[0]);
        $('#txtChave').val('')
      } finally {
        $.LoadingOverlay('hide')
      }
    }
  })

  function addPesquisaAutocompleta() {
    $('#txtCliente').pesquisa_variosServerside(3, `{ "tabela":"entidade", "camposSelect":[ "codcli", "nome"], "where": null}`, 'CODCLI', 'NOME');
    $('#txtRepresentante').pesquisa_variosServerside(1, `{ "tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": null}`, 'CODREP', 'NOME');
    $('#txtTransportadora').pesquisa_variosServerside(1, `{ "tabela":"TABTRAN", "camposSelect":["CODIGO", "NOME"], "where": null}`, 'CODIGO', 'NOME');
    $('#txtTipoCliente').pesquisa_variosServerside(1, `{ "tabela":"SITCLI", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
    $('#txtUf').pesquisa_variosServerside(1, `{ "tabela":"TABUF", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
    $('#txtOperacaoFiscal').pesquisa_variosServerside(1, `{ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
    $('#txtPlaca').pesquisa_variosServerside(1, `{ "tabela":"VEICULO", "camposSelect":["PLACA", "MODELO"], "where": null}`, 'PLACA', 'MODELO');
    $('#txtTipoVenda').pesquisa_variosServerside(1, `{ "tabela":"TIPO", "camposSelect":["ID_TIPO", "DESCRICAO"], "where": null}`, 'ID_TIPO', 'DESCRICAO');
    $('#txtNota').pesquisa_variosServerside(3, `{ "tabela":"NOTA", "camposSelect":["FATURA", "CHAVE_NFE"], "where": null}`, 'FATURA', 'CHAVE_NFE');

    $('#btn-Cliente').pesquisa_serversideSel('#txtCliente', '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
    $('#btn-Representante').pesquisa_serversideSel('#txtRepresentante', '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'Pesquisa Representante');
    $('#btn-Transportadora').pesquisa_serversideSel('#txtTransportadora', '{"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora');
    $('#btn-TipoCliente').pesquisa_serversideSel('#txtTipoCliente', '{"tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Cliente');
    $('#btn-Uf').pesquisa_serversideSel('#txtUf', '{"tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa UF');
    $('#btn-OperacaoFiscal').pesquisa_serversideSel('#txtOperacaoFiscal', '{"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Operação Fiscal');
    $('#btn-Placa').pesquisa_serversideSel('#txtPlaca', '{"tabela":"VEICULO", "camposSelect":[ "PLACA", "MODELO" ], "where": null}', 'Pesquisa Placa');
    $('#btn-TipoVenda').pesquisa_serversideSel('#txtTipoVenda', '{"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda');
    $('#btn-Nota').pesquisa_serversideSel('#txtNota', '{ "tabela":"NOTA", "camposSelect":["FATURA", "CHAVE_NFE"], "where": null}', 'Pesquisa Nota');

    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').empty().trigger('change'); });
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').empty().trigger('change') });
    $('#btn-limpa-Transportadora').on('click', function () { $('#txtTransportadora').empty().trigger('change') });
    $('#btn-limpa-TipoCliente').on('click', function () { $('#txtTipoCliente').empty().trigger('change') });
    $('#btn-limpa-Uf').on('click', function () { $('#txtUf').empty().trigger('change') });
    $('#btn-limpa-OperacaoFiscal').on('click', function () { $('#txtOperacaoFiscal').empty().trigger('change') });
    $('#btn-limpa-Placa').on('click', function () { $('#txtPlaca').empty().trigger('change') });
    $('#btn-limpa-TipoVenda').on('click', function () { $('#txtTipoVenda').empty().trigger('change') });
    $('#btn-limpa-Nota').on('click', function () { $('#txtNota').empty().trigger('change') });
  }
});