$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'formcard1') {
                    $('.driver-close-btn').on('click', location.reload());
                };
            }
        });

        driver.defineSteps([{
            element: '#divCashback',
            popover: {
                title: 'Lista de Cashback',
                description: 'Aqui estão os registros de cashback gerados/utilizados pelos clientes.',
                position: 'top'
            }
        },
        {
            element: '#btnFiltros',
            popover: {
                title: 'Filtros',
                description: 'Aqui, você tem a opção de filtrar as informações que deseja analisar.',
                position: 'bottom'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Imprimir',
                description: 'Imprime os dados filtrados.',
                position: 'bottom'
            }
        },
        {
            element: '#boxDashboard',
            popover: {
                title: 'Totalizadores',
                description: 'Aqui você tem um total resumido dos dados apresentados abaixo',
                position: 'top'
            }
        },
        {
            element: '#txtQuantidade',
            popover: {
                title: 'Quantidade',
                description: 'Adicionamos neste campo a quantidade da unidade.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a Unidade.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

function anosEntre(inicio, fim) {
    const anos = [];
    for (let i = inicio; i <= fim; i++) {
        anos.push(String(i));
    }
    // eslint-disable-next-line prefer-template
    return anos.map(ano => ano).toString();
}

function retornaEmpresas() {
    const listaEmpresas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray() : [];
    const listaEmpPaths = listaEmpresas.map(input => {
        const labelText = $(`label[for="${input.id}"]`).text();
        const empresa = `_${labelText.substring(0, labelText.indexOf('-') - 1)}`;
        return empresa;
    });
    return listaEmpPaths.map(emp => `${emp}`).toString();
}

async function retornaFiltros() {
    const anoInicial = $('#txtDataDe').val();
    const anoFinal = $('#txtDataAte').val();
    const anos = anosEntre(anoInicial, anoFinal);
    const empresas = retornaEmpresas();
    const produto = await formataListas($('#txtProduto').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const analisePor = $('input[name="analisePor"]:checked').val();
    const modelo = await formataListas($('#txtModelo').val().toString());
    const emitido = $('#cbEmitido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const agrupado = $('#cbAgrupado').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const cancelado = $('#cbCancelado').prop('checked');
    const material = await formataListas($('#txtMaterial').val().toString());
    const tipo = isChecked('#radioProduto') ? 'P' : 'M';
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());

    let filtros = `ANOS=${anos}`;
    filtros += `&EMPRESAS=${empresas}`;
    filtros += `&ANALISE_POR=${analisePor}`;

    if (produto && produto != '') {
        filtros += `&PRODUTO=${produto}`;
    }
    if (material && material != '') {
        filtros += `&MATERIAL=${material}`;
    }
    if (grupo && grupo != '') {
        filtros += `&GRUPO=${grupo}`;
    }
    if (marca && marca != '') {
        filtros += `&MARCA=${marca}`;
    }
    if (linha && linha != '') {
        filtros += `&LINHA=${linha}`;
    }
    if (etiqueta && etiqueta != '') {
        filtros += `&ETIQUETA=${etiqueta}`;
    }
    if (colecao && colecao != '') {
        filtros += `&COLECAO=${colecao}`;
    }
    if (modelo && modelo != '') {
        filtros += `&MODELO=${modelo}`;
    }
    if (tipovenda && tipovenda != '') {
        filtros += `&TIPO_VENDA=${tipovenda}`;
    }
    filtros += `&EMITIDO=${emitido}`;
    filtros += `&PENDENTE=${pendente}`;
    filtros += `&AGRUPADO=${agrupado}`;
    filtros += `&DEVOLVIDO=${devolvido}`;
    filtros += `&CANCELADO=${cancelado}`;
    filtros += `&TIPO=${tipo}`;
    return filtros;
}

$(document).ready(async function () {
    componenteFiltro('colecao', true);
    componenteFiltro('produto', true);
    componenteFiltro('marca', true);
    componenteFiltro('grupo', true);
    componenteFiltro('linha', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('modelo', true);
    componenteFiltro('material', true);
    componenteFiltro('tipoVenda', true);
    limparFiltros();

    let grafico;

    let utilizaMaterial = (await CopiaParametro("VENDA", 17)) == 1;

    // $("#btnFiltros").on("click", function () {
    //     $("#modal-filtros").modal("show");
    // });

    validaUtilizaMaterial();

    $("#radioProduto, #radioMaterial").on("change", async function () {
        const tipoConsulta = $("#radioMaterial").is(":checked") ? "M" : "P";
        if (tipoConsulta == "M") {
            utilizaMaterial = 1;
        } else {
            utilizaMaterial = 0;
        }
        validaUtilizaMaterial();
    });

    function validaUtilizaMaterial() {
        if (utilizaMaterial == 1) {
            $("#radioMaterial").prop("checked", true);
            $('.filtroProduto').addClass('d-none');
            $('.filtroMaterial').removeClass('d-none');
        } else {
            $("#radioProduto").prop("checked", true);
            $('.filtroMaterial').addClass('d-none');
            $('.filtroProduto').removeClass('d-none');
        }
    };

    let modalAberto = false;
    $('#btnFiltros').on('click', async function () {    // Da um click em cada select ao abrir o modal, 
        if (!modalAberto) {                            // e adiciona o z-index correto.
            $('[role="combobox"]').trigger('click');
            modalAberto = true;
        }

        setTimeout(function () {
            $('.modal-body').trigger('click');
            $('#modal-filtros').modal('show');
        }, 100);
    });

    $('#btnLimparFiltros').on('click', function () {
        limpaFiltros();
    });

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    function aplicaEstiloTabela() {
        const tabela = document.getElementById("tabelaDados");
        const linhas = tabela.getElementsByTagName("tr");

        for (let i = 0; i < linhas.length; i++) {
            const celulas = linhas[i].getElementsByTagName("td");
            const header = linhas[i].getElementsByTagName('th');
            const borda = '3px solid #C0C0C0';
            for (let j = 0; j < header.length; j++) {
                if (j % 2 !== 0) {
                    header[j].style.borderLeft = borda;
                    header[j].style.borderRight = borda;

                    if (i === 0) {
                        // header[j].style.borderTop = borda;
                    } else if (i === linhas.length - 1) {
                        header[j].style.borderBottom = borda;
                        header[j].style.borderRadius = '0 0 10px 10px';
                    }
                }
            }
            for (let j = 0; j < celulas.length; j++) {
                if (j % 2 !== 0) {
                    celulas[j].style.borderLeft = borda;
                    celulas[j].style.borderRight = borda;

                    if (i === 0) {
                        // celulas[j].style.borderTop = borda;
                    } else if (i === linhas.length - 1) {
                        celulas[j].style.borderBottom = borda;
                        celulas[j].style.borderRadius = '0 0 10px 10px';
                    }
                }
            }
        }


    }

    function formataColuna(coluna) {
        const partes = coluna.split('_'); // divide a string em um array, utilizando o separador "_"
        if (partes.length > 3) {
            const colunaFormatada = `${partes[2]}_${partes[3]} - ${partes[1]}`; // reorganiza as partes conforme desejado
            return colunaFormatada;
        } else if (partes.length > 2) {
            const colunaFormatada = `${partes[0]}/${partes[1]}/${partes[2]}`;;
            return colunaFormatada;
        } else if (partes.length > 1) {
            const colunaFormatada = `${partes[0].replace('MARCO', 'MARÇO')}/${partes[1].replace('MARCO', 'MARÇO')}`
            return colunaFormatada;
        }
        return coluna;
    }


    function atualizarTotais() {
        const total = $(`#tabelaDados thead tr th`).toArray().map((col, idx) => ({
            valor: idx * 0,
            qtde: 0,
        }));
        const analisePor = $('input[name="analisePor"]:checked').val();

        $('#tabelaDados tbody tr').each(function () {
            const linha = $(this);
            const colunas = linha.find('td');
            for (let i = 1; i < colunas.length; i++) {
                const coluna = $(colunas[i]).text();
                if (analisePor == 0) {
                    total[i].valor += parseFloat(coluna);
                } else if (analisePor == 1) {
                    total[i].valor += parseFloat(coluna.replaceAll('R$', '').replaceAll('.', '').replaceAll(',', '.'));
                } else {
                    if (i % 2 == 0) {
                        total[i].valor += parseFloat(coluna.replaceAll('R$', '').replaceAll('.', '').replaceAll(',', '.'));
                    } else {
                        total[i].valor += parseFloat(coluna);
                    }
                }
                //     const ehTotalQtde = (($(colunas[0]).text().indexOf('_QTDE') > -1) && (analisePor == 2));
                //     if (ehTotalQtde) {
                //         total[i].qtde += parseFloat(coluna);
                //     } else if (analisePor == 0) {
                //         total[i].valor += parseFloat(coluna);
                //     }
                //     else {
                //         const valorFormatado = parseFloat(coluna.replaceAll('R$', '').replaceAll(',', '.'));
                //         const valorFormatado = parseFloat(coluna.replaceAll('R$', '').replaceAll('.', '').replaceAll(',', '.'));
                //         total[i].valor += valorFormatado;
                //     }
            }
        });
        $(`#tabelaDados tfoot tr th`).each((i, foot) => {
            $(foot).addClass('text-right');
            if (i != 0) {
                if (analisePor == 0) {
                    $(foot).text(total[i].valor);
                } else if (analisePor == 1) {
                    $(foot).text(parseFloat(total[i].valor).toLocaleString());
                } else {
                    let html = '';
                    if (i % 2 == 1) {
                        html = `<div style="display: flex; flex-direction: column;">
                                    <span style="white-space: nowrap;">Qtde: ${total[i].valor}</span></div>`;
                    } else {
                        html = `<div style="display: flex; flex-direction: column;">
                                    <span style="white-space: nowrap;">Valor: ${parseFloat(total[i].valor).toLocaleString()}</span></div>`;
                    }
                    $(foot).html(html);
                }
            } else {
                $(foot).text('Totais por mês');
            }
        });
    }

    function imprimirTabela() {
        // Obter a tabela e seu conteúdo HTML
        const tabela = document.querySelector("#tabelaDados");

        if ($("#tabelaDados tbody td").length <= 0) {
            msgAlerta('Necessário consultar os dados antes de imprimir');
            return;
        }
        const conteudo = tabela.outerHTML;
        const titulo = $('#tituloTabela').html();

        // Criar uma nova janela de impressão
        const janelaImpressao = window.open('', '', 'height=500,width=500');

        // Adicionar o conteúdo HTML da tabela à nova janela de impressão
        janelaImpressao.document.write('<html><head><title>Relatório de Comparativo Anual</title>');
        janelaImpressao.document.write('</head><body>');
        janelaImpressao.document.write(titulo);
        janelaImpressao.document.write(conteudo);
        janelaImpressao.document.write('</body></html>');

        // Fechar a janela de impressão quando a impressão for concluída
        janelaImpressao.document.close();
        janelaImpressao.focus();
        janelaImpressao.print();
        janelaImpressao.close();
    }

    $('#btnImprimir').on('click', async function () {
        // imprimirTabela();

        try {
            $.LoadingOverlay('show');
            try {
                const url = '/sisplan/impressao/v1/imprimircomparativoanual?';
                const filtros = await retornaFiltros();
                // const analisePor = $('input[name="analisePor"]:checked').val();
                // const dataSetCols = [];

                if (($('#txtDataDe').val() == '') || ($('#txtDataAte').val() == '')) {
                    msgAlerta('Necessário informar os Anos para análise.');
                    return;
                }

                if ($('#txtDataDe').val() > $('#txtDataAte').val()) {
                    msgAlerta('Ano inicial não pode ser maior que ano final');
                    return;
                }

                let arquivo = await GeraRelatorio(`${url + filtros}&`, 'POST', 100000, false);
                if (arquivo != undefined) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnConsultar').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultacomparativoanual?';
        const filtros = await retornaFiltros();
        const analisePor = $('input[name="analisePor"]:checked').val();
        const dataSetCols = [];

        if (($('#txtDataDe').val() == '') || ($('#txtDataAte').val() == '')) {
            msgAlerta('Necessário informar os Anos para análise.');
            return;
        }

        if ($('#txtDataDe').val() > $('#txtDataAte').val()) {
            msgAlerta('Ano inicial não pode ser maior que ano final');
            return;
        }
        $.LoadingOverlay('show');
        try {
            try {
                const response = await requisicao('GET', url, filtros, '', 600000);
                if (!response) {
                    return;
                }
                const jsonStr = await response.json();
                if (jsonStr.length == 0) {
                    msgAlerta('Nenhum registro encontrado!');
                    return;
                }
                if (response.status != 200) {
                    console.error(jsonStr.mensagem);
                }
                const dataSet = jsonStr;
                const keys = Object.keys(dataSet[0]);
                // eslint-disable-next-line no-restricted-syntax, guard-for-in
                for (let k in keys) {
                    if (keys.hasOwnProperty(k)) {
                        dataSetCols.push({
                            'title': formataColuna(keys[k]),
                            'data': keys[k]
                        });
                    }
                }

                $('#excel').empty();
                $('#excel').html('<h4 id="tituloTabela"></h4>');

                const tituloTabela = {
                    0: 'Análise por quantidade',
                    1: 'Análise por valor',
                    2: 'Análise por quantidade e valor'
                };

                $('#tituloTabela').html(tituloTabela[analisePor]);

                if ($.fn.DataTable.isDataTable('#tabelaDados')) {
                    $('#tabelaDados').DataTable().destroy();
                    $('#tabelaDados').empty();
                };

                // const columnDefs = [
                //     {
                //         "render": function (data, type, row) {
                //             const condicoesParaValorReal = ((analisePor == 1 && typeof data == 'number')
                //                 || (analisePor == 2 && typeof data == 'number' && row.MES.indexOf('_VALOR') > -1));
                //             if (condicoesParaValorReal) {
                //                 return parseFloat(data).toLocaleString();
                //             }
                //             return data;
                //         },
                //         "targets": '_all',
                //         "type": 'currency',
                //         // "sortType": 'currency'
                //     }
                // ];

                $.fn.dataTable.ext.type.order['currency-pre'] = function (data) {
                    mesNumerico = {
                        'JANEIRO': 1,
                        'FEVEREIRO': 2,
                        'MARÇO': 3,
                        'ABRIL': 4,
                        'MAIO': 5,
                        'JUNHO': 6,
                        'JULHO': 7,
                        'AGOSTO': 8,
                        'SETEMBRO': 9,
                        'OUTUBRO': 10,
                        'NOVEMBRO': 11,
                        'DEZEMBRO': 12
                    };

                    const meses = Object.keys(mesNumerico);
                    if (meses.includes(String(data).split('_')[0])) { // pega primeira parte
                        return mesNumerico[String(data).split('_')[0]];
                    }
                    const condicaoOrdenacaoValor = ((typeof data != 'number') && (data.indexOf('R$') > -1));
                    const unformatted = condicaoOrdenacaoValor ? data.replace(/[^\d]/g, '') : data;
                    return condicaoOrdenacaoValor ? parseFloat(unformatted) : unformatted;
                };

                const columnDefs = retornaColunasFormatadas(analisePor, dataSetCols.length - 1);

                $('#tabelaDados').DataTable({
                    paging: false,
                    filter: false,
                    sort: true,
                    info: true,
                    destroy: true,
                    "language": {
                        "sEmptyTable": "Nenhum registro encontrado",
                        "sInfo": "_TOTAL_ registros",
                        "sInfoEmpty": " 0 registros",
                        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                        "sInfoPostFix": "",
                        "sInfoThousands": ".",
                        "sLengthMenu": "_MENU_ resultados",
                        "sLoadingRecords": "Carregando...",
                        "sProcessing": "Processando...",
                        "sZeroRecords": "Nenhum registro encontrado",
                        "sSearch": "Pesquisar",
                        "oPaginate": {
                            "sNext": "Próximo",
                            "sPrevious": "Anterior",
                            "sFirst": "Primeiro",
                            "sLast": "Último"
                        },
                        "oAria": {
                            "sSortAscending": ": Ordenar colunas de forma ascendente",
                            "sSortDescending": ": Ordenar colunas de forma descendente"
                        }
                    },
                    colReorder: true,
                    columns: dataSetCols,
                    data: dataSet,
                    columnDefs: columnDefs,
                    order: ['0', 'asc'],
                });
                $("#tabelaDados ").append(
                    $('<tfoot/>').append($("#tabelaDados thead tr").clone())
                );
                $('#excel').append('<button class="buttonExcel ml-2" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonExcel').prop('title', 'Exportar CSV')

                $('#buttonExcel').on('click', async function () {
                    const analisePor = $('input[name="analisePor"]:checked').val();
                    const url = '/sisplan/impressao/v1/consultacomparativoanual?';
                    const filtros = await retornaFiltros();
                    if (filtros.venda_de == '') {
                        msgAlerta('Data não informada ou inválida');
                        return;
                    }
                    await exportaCSV(url, filtros, false, null, 'Relatório Comparativo Anual', '#tabelaDados', montaComandosCampos(analisePor));
                })

                $('#modal-filtros').modal('hide');
                $('#tabelaDados thead th').each(function () {
                    const valor = $(this).text().trim();
                    if ((valor.indexOf('_') > -1) && (valor.indexOf('-') > -1)) {
                        $(this).addClass('text-center');
                    }
                });
                $('#tabelaDados tbody td').each(function () {
                    const valor = $(this).text().trim();
                    if ((valor.indexOf('R$') > -1) || (!isNaN(valor))) {
                        $(this).addClass('text-right');
                    }
                });
                $('#tabelaDados').on('draw.dt', function () {
                    atualizarTotais();
                });
                atualizarTotais();
                aplicaEstiloTabela();
                apresentaGrafico(dataSet, $('input[name="analisePor"]:checked').val());

            } catch (error) {
                console.error(error);
                msgAlerta('Erro ao buscar os dados para análise, tente novamente.');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    function montaComandosCampos(f) {
        let retorno = `let result = {};

                       dados.forEach(obj => {
                           for (const key in obj) {
                               result[key] = (result[key] || 0) + obj[key];
                           }
                       });`


        if (f == '1') {
            retorno += `for (key in result) {
                            if (key != 'EMPRESA_ANO') {
                                result[key] = parseFloat(result[key]).toFixed(2);
                            }
                        }`;
        } else if (f == '2') {
            retorno += `for (key in result) {
                            if (key != 'EMPRESA_ANO') {
                                if ((key.toUpperCase()).includes('VALOR')) {
                                    result[key] = parseFloat(result[key]).toFixed(2);
                                }
                            }
                        }`;
        }

        retorno += `result['EMPRESA_ANO'] = 'Totais por mês';
                    dados.push(result);`

        return retorno;
    };

    function formataValoresGraficos() {
        $(".apexcharts-yaxis-label").each(function () {
            let titleElement = $(this).find("tspan");

            if (titleElement.length > 0) {
                const titleContent = titleElement.text();
                titleElement.text(parseFloat(titleContent).toLocaleString());
            }
        });
    }

    function apresentaGrafico(data, tipoGrafico) {
        const listaCores = ["#F3B415", "#F27036", "#663F59", "#6A6E94", "#4E88B4", "#00A7C6", "#18D8D8", "#A9D794", "#46AF78", "#A93F55", "#8C5E58", "#2176FF", "#33A1FD", "#7A918D", "#BAFF29", "#F3B415", "#F27036", "#663F59", "#6A6E94", "#4E88B4", "#00A7C6", "#18D8D8", "#A9D794", "#46AF78", "#A93F55", "#8C5E58", "#2176FF", "#33A1FD", "#7A918D", "#BAFF29", "#F3B415", "#F27036", "#663F59", "#6A6E94", "#4E88B4", "#00A7C6", "#18D8D8", "#A9D794", "#46AF78", "#A93F55", "#8C5E58", "#2176FF", "#33A1FD", "#7A918D", "#BAFF29", "#F3B415", "#F27036", "#663F59", "#6A6E94", "#4E88B4", "#00A7C6", "#18D8D8", "#A9D794", "#46AF78", "#A93F55", "#8C5E58", "#2176FF", "#33A1FD", "#7A918D", "#BAFF29"]
        try {
            if (tipoGrafico == '0') {
                $('#chart0').removeClass('d-none');
                $('#chart1').addClass('d-none');
                $('#chart2').addClass('d-none');
                let options = {
                    series: [],
                    chart: {
                        type: 'bar',
                        height: 350,
                        zoom: {
                            enabled: true,
                            type: 'x',
                            autoScaleYaxis: false,
                            zoomedArea: {
                                fill: {
                                    color: '#90CAF9',
                                    opacity: 0.4
                                },
                                stroke: {
                                    color: '#0D47A1',
                                    opacity: 0.4,
                                    width: 1
                                }
                            }
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    colors: listaCores,
                    xaxis: {
                        categories: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                        tickPlacement: 'on',
                    },
                    yaxis: {
                        title: {
                            text: 'Quantidades por empresa/ano'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return val
                            }
                        }
                    }
                };

                data.map(item => {
                    options.series.push({
                        name: item.EMPRESA_ANO,
                        data: [item.JANEIRO, item.FEVEREIRO, item.MARCO, item.ABRIL, item.MAIO, item.JUNHO, item.JULHO, item.AGOSTO, item.SETEMBRO, item.OUTUBRO, item.NOVEMBRO, item.DEZEMBRO]
                    });
                });

                options.series.map(item => {
                    $.each(item.data, function (index, value) {
                        if (value === 0) {
                            item.data[index] = null;
                        }
                    });
                });

                var chart = new ApexCharts(document.querySelector("#chart0"), options);
                chart.render();
            } else if (tipoGrafico == '1') {
                $('#chart1').removeClass('d-none');
                $('#chart0').addClass('d-none');
                $('#chart2').addClass('d-none');
                let options = {
                    series: [],
                    chart: {
                        type: 'bar',
                        height: 350,
                        zoom: {
                            enabled: true,
                            type: 'x',
                            autoScaleYaxis: false,
                            zoomedArea: {
                                fill: {
                                    color: '#90CAF9',
                                    opacity: 0.4
                                },
                                stroke: {
                                    color: '#0D47A1',
                                    opacity: 0.4,
                                    width: 1
                                }
                            }
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    colors: listaCores,
                    xaxis: {
                        categories: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                        tickPlacement: 'on',
                    },
                    yaxis: {
                        title: {
                            text: 'Valor por empresa/ano'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return val
                            }
                        }
                    }
                };

                data.map(item => {
                    options.series.push({
                        name: item.EMPRESA_ANO,
                        data: [item.JANEIRO, item.FEVEREIRO, item.MARCO, item.ABRIL, item.MAIO, item.JUNHO, item.JULHO, item.AGOSTO, item.SETEMBRO, item.OUTUBRO, item.NOVEMBRO, item.DEZEMBRO]
                    });
                });

                options.series.map(item => {
                    $.each(item.data, function (index, value) {
                        if (value === 0) {
                            item.data[index] = null;
                        }
                    });
                });

                var chart = new ApexCharts(document.querySelector("#chart1"), options);
                chart.render().then(() => {
                    setTimeout(() => {
                        formataValoresGraficos();
                    }, 1500)
                })
            } else if (tipoGrafico == '2') {
                $('#chart2').removeClass('d-none');
                $('#chart0').addClass('d-none');
                $('#chart1').addClass('d-none');
                let options = {
                    series: [],
                    chart: {
                        type: 'bar',
                        height: 350,
                        zoom: {
                            enabled: true,
                            type: 'x',
                            autoScaleYaxis: false,
                            zoomedArea: {
                                fill: {
                                    color: '#90CAF9',
                                    opacity: 0.4
                                },
                                stroke: {
                                    color: '#0D47A1',
                                    opacity: 0.4,
                                    width: 1
                                }
                            }
                        }
                    },
                    plotOptions: {
                        bar: {
                            horizontal: false,
                            columnWidth: '55%',
                            endingShape: 'rounded'
                        },
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        show: true,
                        width: 2,
                        colors: ['transparent']
                    },
                    colors: listaCores,
                    xaxis: {
                        categories: ['Jan Qtde', 'Jan Val', 'Fev Qtde', 'Fev Val', 'Mar Qtde', 'Mar Val', 'Abr Qtde', 'Abr Val', 'Mai Qtde', 'Mai Val', 'Jun Qtde', 'Jun Val',
                            'Jul Qtde', 'Jul Val', 'Ago Qtde', 'Ago Val', 'Set Qtde', 'Set Val', 'Out Qtde', 'Out Val', 'Nov Qtde', 'Nov Val', 'Dez Qtde', 'Dez Val'],
                        tickPlacement: 'on',
                    },
                    yaxis: {
                        title: {
                            text: 'Valor/qtde por empresa/ano'
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    tooltip: {
                        y: {
                            formatter: function (val) {
                                return val
                            }
                        }
                    }
                };

                data.map(item => {
                    options.series.push({
                        name: item.EMPRESA_ANO,
                        data: [
                            item.JANEIRO_QTDE, item.JANEIRO_VALOR, item.FEVEREIRO_QTDE, item.FEVEREIRO_VALOR, item.MARCO_QTDE, item.MARCO_VALOR, item.ABRIL_QTDE,
                            item.ABRIL_VALOR, item.MAIO_QTDE, item.MAIO_VALOR, item.JUNHO_QTDE, item.JUNHO_VALOR, item.JULHO_QTDE, item.JULHO_VALOR,
                            item.AGOSTO_QTDE, item.AGOSTO_VALOR, item.SETEMBRO_QTDE, item.SETEMBRO_VALOR, item.OUTUBRO_QTDE, item.OUTUBRO_VALOR,
                            item.NOVEMBRO_QTDE, item.NOVEMBRO_VALOR, item.DEZEMBRO_QTDE, item.DEZEMBRO_VALOR
                        ]
                    });
                });

                options.series.map(item => {
                    $.each(item.data, function (index, value) {
                        if (value === 0) {
                            item.data[index] = null;
                        }
                    });
                });

                var chart = new ApexCharts(document.querySelector("#chart2"), options);
                chart.render().then(() => {
                    setTimeout(() => {
                        formataValoresGraficos();
                    }, 1500)
                })
            }

            $('#tabelaDados').DataTable().rows().data().map((itemTab, index) => {
                const primeiroTd = $($('#tabelaDados').find('tr td:first-child')[index]);
                data.map((item, idxData) => {
                    if (itemTab.EMPRESA_ANO == item.EMPRESA_ANO) {
                        primeiroTd.css('background-color', listaCores[idxData]);
                        primeiroTd.css('color', 'white');
                        primeiroTd.addClass('hoverFirstTd');
                    }
                });
            });
        } finally {
            chart.appendSeries({});
        }
    }

    function retornaColunasFormatadas(analisePor, alvo) {
        const retorno = [];

        if (analisePor == 0) {
            retorno.push(
                {
                    targets: [alvo],
                    render: function (data, type, row) {
                        return `<b>${data}</b>`;
                    }
                },
                {
                    className: "alinharDireita",
                    "targets": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
                }
            )
        } else if (analisePor == 1) {
            retorno.push(
                {
                    targets: [alvo],
                    render: function (data, type, row) {
                        return `<b>${parseFloat(data).toLocaleString()}</b>`;
                    }
                },
                {
                    targets: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
                    render: function (data, type, row) {
                        return parseFloat(data).toLocaleString();
                    }
                },
                {
                    className: "alinharDireita",
                    "targets": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
                }
            )
        } else {
            retorno.push(
                {
                    targets: [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24],
                    render: function (data, type, row) {
                        return parseFloat(data).toLocaleString();
                    }
                },
                {
                    targets: [alvo - 1],
                    render: function (data, type, row) {
                        return `<b>${data}</b>`;
                    }
                },
                {
                    targets: [alvo],
                    render: function (data, type, row) {
                        return `<b>${parseFloat(data).toLocaleString()}</b>`;
                    }
                },
                {
                    className: "alinharDireita",
                    "targets": [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26]
                }
            )
        }

        return retorno;
    }

    function limpaFiltros() {
        $('#txtProduto').empty().trigger('change');
        $('#txtGrupo').empty().trigger('change');
        $('#txtColecao').empty().trigger('change');
        $('#txtEtiqueta').empty().trigger('change');
        $('#txtLinha').empty().trigger('change');
        $('#txtMarca').empty().trigger('change');
        $('#txtDataDe').val();
        $('#txtDataAte').val();
        $('#txtTipoVenda').empty().trigger('change');
    }

    adicionarConteudoModal(
        'Comparativo Anual de Vendas', [
        {
            tipo: 'paragrafo',
            valor: 'Analisar o comparativo anual de vendas é essencial para tomada de decisões. ' +
                'Este relatório possibilita obter resultados riquíssimos para entendimento dos potenciais e defasagens de cada unidade, em uma visão ampla anual. ' +
                'Trata-se do total de vendas por valor e/ou quantidade com possibilidade de aplicar filtros para um resumir ainda mais a visão. ' +
                'Tem como objetivo, fornecer informações para tomadas de decisões, como por exemplo, questionar equipes, criar planos de ação ou até mesmo capacitação para nivelar desempenhos. '
        },
        {
            tipo: 'paragrafo',
            valor: 'Compare sempre! Se uma unidade consegue atingir objetivos, a outra também deve conseguir!',
        },
        {
            tipo: 'paragrafo',
            valor:
                'Atenção/Ação para quem está caindo! Manter o foco de quem está subindo!'

        }
    ]
    );

});