$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#filtros',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar os dados.',
          position: 'bottom'
        }
      },
      {
        element: '#txtNumero',
        popover: {
          title: 'Campo Número - (F8)',
          description: 'Campo para filtrar o número do receber ou AP. Contém a opção com o F8 com o foco no campo, onde irá abrir um modal com vários filtros podendo selecionar vários registros.',
          position: 'bottom'
        }
      },
      {
        element: '#tabelaItens_wrapper',
        popover: {
          title: 'Tabela',
          description: 'Tabela com os dados consultados.',
          position: 'bottom'
        }
      },
      {
        element: '#btnAdicionar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta.',
          position: 'left'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir os dados que estão no grid.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let sTipo = '';

  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', null, null, [], [], [], [1,2]);
  criaDataTablePadrao('#tabelaItensConsulta', false, false, false, false, true, true, '250px', null, null, [], [], [], [2,3]);
  $("#tabelaItens").DataTable().columns.adjust().draw(false);

  $("#txtPagoPara").autocompleta(3, 'JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}');
  $("#btnPagoPara").pesquisa_serverside(["#txtPagoPara"], ["CODCLI", "CNPJ"], ["NOME", "CNPJ"], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', "Pesquisa Cliente");
  $('#btnLimpaPagoPara').on('click', function () { $('#txtPagoPara').val('') });
  $('#btnLimpaLancamento').on('click', function () { $('#txtLancamento').val('') });
  $('#btnLimpaNumero').on('click', function () { $('#txtNumero').val('') });

  $('#txtFornecedor').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": null}`);
  $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'Pesquisa Entidade', 'ENTIDADE');
  $('#btn-limpa-Fornecedor').on('click', function () { $('#txtFornecedor').val('') });

  $('#txtClasseGer').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
  $('#btn-ClasseGer').pesquisa('#txtClasseGer', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Classe Gerencial', 'CLASSE_GER');
  $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').val('') });

  async function pesquisaRadioReceber() {
    $('#btnNumero').off()
    $('#btnLancamento').off()
    $('#btnNumero').pesquisa_serverside(['#txtNumero'], ['NUMERO'], ['CODCLI'], `{"tabela":"RECEBER", "camposSelect":[ "NUMERO", "CODCLI" ],"where": ["RECEBER.EMP_ID=${getCookie('emp_id')}"]}`, "Pesquisa Receber");
    $('#txtNumero').autocompleta(3, `JSON={ "tabela":"RECEBER", "camposSelect":["NUMERO CHAVE, CODCLI DESCRICAO"], "where": ["RECEBER.EMP_ID=${getCookie('emp_id')}"]}`);
    $('#txtLancamento').autocompleta(3, `JSON={ "tabela":"RECEBERB", "camposSelect":["NUMERO CHAVE", "LANCAMENTO DESCRICAO"], "where": [] }`, [], [], []);

    $('#btnLancamento').pesquisa_serverside(['#txtLancamento'], ['LANCAMENTO'], ['NUMERO'], `{
      "tabela":"RECEBERB",
      "camposSelect":["LANCAMENTO", "NUMERO"], 
      "where": null}`,
      'Pesquisa ReceberB');

    $('#txtNumero').on('blur', function () {
      if ($('#txtNumero').val() != '') {
        $('#btnLancamento').off()
        $('#btnLancamento').pesquisa_array(['#txtLancamento'], ['LANCAMENTO'], ['NUMERO'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"RECEBERB", 
        "camposSelect":["RECEBERB.NUMERO", "RECEBERB.LANCAMENTO"],
        "leftJoin": [{"tabela": "RECEBER", "condicao": "RECEBER.NUMERO = RECEBERB.NUMERO"}],
        "groupBy": ["RECEBERB.NUMERO", "RECEBERB.LANCAMENTO"],
        "where": ["1=1 AND RECEBERB.NUMERO = '${pegaChave('#txtNumero')}' AND RECEBER.EMP_ID = '${getCookie('emp_id')}'"]}`, 'Pesquisa ReceberB', 'RECEBERB');
      }
    })
  }

  async function pesquisaRadioPagar() {
    $('#btnLancamento').off()
    $('#btnNumero').off()
    $('#txtNumero').autocompleta(3, `JSON={ "tabela":"PAGTO", "camposSelect":["NUM_AP CHAVE, CODCRE DESCRICAO"], "where": ["PAGTO.EMP_ID=${getCookie('emp_id')}"]}`);
    $('#btnNumero').pesquisa_serverside(['#txtNumero'], ['NUM_AP'], ['CODCRE'], `{"tabela":"PAGTO", "camposSelect":[ "NUM_AP", "CODCRE" ],  "where": ["PAGTO.EMP_ID=${getCookie('emp_id')}"]}`, "Pesquisa Pagar");
    $('#txtLancamento').autocompleta(1, `JSON={ "tabela":"PAGTO1", "camposSelect":["LANCAMENTO CHAVE, NUM_AP DESCRICAO"], "where": [] }`, [], [], []);

    $('#btnLancamento').pesquisa_serverside(['#txtLancamento'], ['LANCAMENTO'], ['NUM_AP'], `{
      "tabela":"PAGTO1",
      "camposSelect":["LANCAMENTO", "NUM_AP"], 
      "where": null,
      "groupBy": ["LANCAMENTO", "NUM_AP"]}`,
      'Pesquisa Pagto1');

    $('#txtNumero').on('blur', function () {
      if ($('#txtNumero').val() != '') {
        $('#btnLancamento').off();
        $('#btnLancamento').pesquisa_array(['#txtLancamento'], ['LANCAMENTO'], ['NUM_AP'],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PAGTO1", 
        "camposSelect":[ "NUM_AP", "LANCAMENTO" ],
        "groupBy": ["LANCAMENTO", "NUM_AP"], 
        "where": ["1=1 AND NUM_AP = '${pegaChave('#txtNumero')}'"]}`, 'Pesquisa Pagto1', 'PAGTO1');
      }
    })
  }

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show')
    $("#tabelaItensConsulta").DataTable().columns.adjust().draw(false);
  })

  $('#btnEmissao').on('click', async function () {
    $("#modal-emissao").modal('show');
  });

  $('#btnLimpar').on('click', function () {
    limpar();
  });

  $('#check_todos').on('click', async function () {
    $('.checkVarios').prop('checked', $('#check_todos').prop('checked'));
    addSelected($('#check_todos').prop('checked'));
  });

  $("#tabelaItensConsulta").on("click", "td", function () {
    selecionarLinhaTabela("#tabelaItensConsulta", "checkVarios", this);
  });

  $('#btnConfirmar').on('click', async function () {
    importaDados();
    $('#modal-filtros').modal('hide');
  });

  $('#tabelaEmissao').on('click', '#btn-excluir', async function () {
    msgAlerta('Você realmente deseja excluir esse registro?', async () => {
      const data = $("#tabelaEmissao").DataTable().row($(this).parents("tr"));
      data.remove().draw(false);
    });
  });

  $('#modal-emissao').on('show.bs.modal', function () {
    $('#radioPagar').trigger('click')
    $('#radioReceber').trigger('click')
    $("#tabelaEmissao").DataTable().columns.adjust().draw(false);
  });

  $('#radioReceber, #radioPagar').on('change', async function () {
    await limpaCampos()
    sTipo = ($('#radioReceber').is(':checked') ? 'R' : 'P');
    if (sTipo == 'R') {
      await pesquisaRadioReceber();
    } else {
      await pesquisaRadioPagar();
    }
  });

  retornaHintRelatorio('btnImprimir','RelRecibo')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relrecibo?`;
        const listaNumeros = retornaListaNumeros();
        const filtros = retornaFiltros('impressao') + listaNumeros;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelRecibo');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelRecibo');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', function () {
    limpar();
    consultar();
    $('#modal-filtros').modal('hide')
  });

  async function consultar() {
    $.LoadingOverlay('show')
    const dados = await RetornaDadosConsulta();
    try {
      dados.map(item => {
        $('#tabelaItens').DataTable().row.add(
          [
            item.NUM_AP,
            item.VALOR,
            item.VALOR_PAGO,
            item.NOME,
            item.OBS,
            item.DOCTO,
            item.CNPJ,
            item.DT_VEN,
            item.TIPO
          ]).draw(false);
      });
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
    $("#tabelaItensConsulta").DataTable().columns.adjust().draw(false);
  };

  function limpar() {
    if ($('#tabelaItens').DataTable().rows().count() > 0) {
      $('#tabelaItens').empty();
      criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', null, null, [], [], [], [1,2]);
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    };
  };

  function limparConsulta() {
    if ($('#tabelaItensConsulta').DataTable().rows().count() > 0) {
      $('#tabelaItensConsulta').empty();
      criaDataTablePadrao('#tabelaItensConsulta', false, false, false, false, true, true, '250px', null, null, [], [], [], [2,3]);
      $("#tabelaItensConsulta").DataTable().columns.adjust().draw(false);
    };
  };

  $('#btnConsultarVarios').on('click', async function () {
    await consultarVarios();
  });

  async function consultarVarios() {
    $.LoadingOverlay("show");
    try {
      limparConsulta();
      const dados = await RetornaDadosConsulta();

      dados.map(item => {
        $('#tabelaItensConsulta').DataTable().row.add(
          [
            botaoSelecionarGrid(),
            item.NUM_AP,
            item.VALOR,
            item.VALOR_PAGO,
            item.NOME,
            item.OBS,
            item.DOCTO,
            item.CNPJ,
            item.DT_VEN,
            item.TIPO
          ]).draw(false);
      });

    } finally {
      $.LoadingOverlay('hide');
      $("#tabelaItensConsulta").DataTable().columns.adjust().draw(false);
    }
  };

  async function RetornaDadosConsulta() {
    const filtro = retornaFiltros();
    const url = '/sisplan/impressao/v1/consultarecibo?';

    const response = await requisicao('GET', url, filtro, 30000);

    if (!response) {
      return;
    };

    const jsonStr = await response.json();

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum registro encontrado!');
      return;
    };

    if (response.status != 200) {
      console.error(jsonStr.mensagem);
      return;
    };
    return jsonStr;
  };


  function retornaListaNumeros() {
    const dadosDataTable = $('#tabelaItens').DataTable().data().toArray();
    const iQtdeRegistros = dadosDataTable.length;
    const iNumeros = [];
    if (iQtdeRegistros > 0) {
      for (i = 0; i < iQtdeRegistros; i++) {
        iNumeros.push(dadosDataTable[i][0]);
      };
    }
    return iNumeros.length > 0 ? '&LISTANUMEROS=' + iNumeros
      : '&LISTANUMEROS=';
  }

  function retornaFiltros() {
    const iTipo = $('#txtBuscar').val();
    const iEmissaoDe = ($("#txtDataEmiDe").val() != "1200-01-01") ? $("#txtDataEmiDe").val() : '';
    const iEmissaoAte = ($("#txtDataEmiAte").val() != "2500-12-01") ? $("#txtDataEmiAte").val() : '';
    const iVencimentoDe = ($("#txtDataVencimentoDe").val() != "1200-01-01") ? $("#txtDataVencimentoDe").val() : '';
    const iVencimentoAte = ($("#txtDataVencimentoAte").val() != "2500-12-01") ? $("#txtDataVencimentoAte").val() : '';
    const iPagamentoDe = ($("#txtDataPagamentoDe").val() != "1200-01-01") ? $("#txtDataPagamentoDe").val() : '';
    const iPagamentoAte = ($("#txtDataPagamentoAte").val() != "2500-12-01") ? $("#txtDataPagamentoAte").val() : '';
    const iNumeroDe = $("#txtNumeroDe").val();
    const iNumeroAte = $("#txtNumeroAte").val();
    const iFornecedor = pegaChave('#txtFornecedor');
    const iClasseGer = pegaChave('#txtClasseGer');
    const iNota = $("#txtNotaFiscal").val();
    const iSituacao = pegaValor('#txtSituacao');
    const iNumero = $('#txtNumero').val() != '' ? `'${pegaChave('#txtNumero')}'` : '';
    const iLancamento = pegaChave('#txtLancamento');

    const retorno =
      `TIPO=${iTipo}` +
      `&EMISSAODE=${iEmissaoDe}` +
      `&EMISSAOATE=${iEmissaoAte}` +
      `&VENCIMENTODE=${iVencimentoDe}` +
      `&VENCIMENTOATE=${iVencimentoAte}` +
      `&PAGAMENTODE=${iPagamentoDe}` +
      `&PAGAMENTOATE=${iPagamentoAte}` +
      `&NUMERODE=${iNumeroDe}` +
      `&NUMEROATE=${iNumeroAte}` +
      `&FORNECEDOR=${iFornecedor}` +
      `&CLASSEGER=${iClasseGer}` +
      `&NOTA=${iNota}` +
      `&SITUACAO=${iSituacao}` +
      `&NUMERO=${iNumero}` +
      `&LANCAMENTO=${iLancamento}` +
      `&EMP_ID=${getCookie('emp_id')}`
    return retorno;
  };

  function botaoSelecionarGrid() {
    return (
      '<div class="form-check">' +
      '<input type="checkbox" class="align-self-center checkVarios" value"">' +
      '</div>'
    );
  };

  function addSelected(add = true) {
    for (let i = 0; i < $('#tabelaItensConsulta').DataTable().rows().data().length; i++) {
      if (add) {
        $($("table#tabelaItensConsulta tr")[i + 1]).addClass("selected");
      } else {
        $($("table#tabelaItensConsulta tr")[i + 1]).removeClass("selected");
      }
    }
  };

  function importaDados() {
    $.LoadingOverlay("show");
    try {
      limpar();
      let tabela = $("#tabelaItensConsulta").DataTable().rows(".selected").data();

      for (let i = 0; i < tabela.length; i++) {
        $('#tabelaItens').DataTable().row.add([
          tabela[i][1],
          tabela[i][2],
          tabela[i][3],
          tabela[i][4],
          tabela[i][5],
          tabela[i][6],
          tabela[i][7],
          tabela[i][8],
          tabela[i][9],
        ]).draw(false);
      };
      $("#tabelaItensConsulta").DataTable().columns.adjust().draw(false);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaValor(tabela, campoSelect, campoCondicao, valorCondicao) {
    const pesquisaParam = { tabela: `${tabela}`, camposSelect: [`${campoSelect}`], where: [`${campoCondicao} = '${valorCondicao}'`] };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (jsonStr[0] != undefined) {
      return jsonStr[0][campoSelect]
    } else {
      return ''
    }
  }

  async function validaSeoNumeroJaExiste(iNumero) {
    let controle = 1;
    const tabela = $('#tabelaEmissao').DataTable().rows().data().toArray();
    for (let i = 0; i < tabela.length; i++) {
      let = fieldNumero = $('#txtNumAp_' + controle).val()
      if (fieldNumero != '' && iNumero != '') {
        if (fieldNumero == iNumero) {
          msgAlerta('Número da AP já existe na emissão do recibo')
          return false
        }
      }
      controle++
    }
  }

  $('#btnAdicionar').on('click', async function () {
    if ($('#tabelaEmissao').DataTable().rows().data().length > 0) {
      let validaNumero = await validaSeoNumeroJaExiste(pegaChave('#txtNumero'))
      if (validaNumero != undefined) return
    }
    if ($("#txtLancamento").val() != '') {
      sLancamento = await carregaLancamento();
    } else if ($('#txtNumero').val() != '') {
      if ($('#txtValor').val() == '' || $('#txtValor').val() == 0) {
        msgAlerta('Informe o valor!');
        $('#txtValor').focus();
        return
      }

      const sDadosNumero = await buscaPeloNumero();
      const sBaixas = await buscaBaixas();
      if (!sBaixas) {
        msgAlerta('Título não possui baixa, impossível adicionar.');
        return;
      }
      const sDadosCliente = $('#radioReceber').is(':checked')
        ? await buscaDadosCliente(sDadosNumero[0].CODCLI)
        : await buscaDadosCliente(sDadosNumero[0].CODCRE)
      const sDuplicata = await buscaDuplicata(pegaChave('#txtNumero'));


      await insereDadosTabela(sBaixas, sDadosCliente, sDuplicata);
    } else {
      await insereDadosSemNumeroELanc()
    }
  });

  async function insereDadosSemNumeroELanc() {
    let dtContrato = $('#dtContrato').val() != '' ? $('#dtContrato').val() : '1899-12-31';
    const totalRegistros = $('#tabelaEmissao').DataTable().data().toArray().length + 1;
    $('#tabelaEmissao').DataTable().row.add([
      retornaBotaoOpcoes(),
      `<input style="width: 7em;" id="txtNumAp_${totalRegistros}" type="text" class="inputNumAp inputTable focus input-default form-control" value="${''}">`, //Num_Ap
      `<input style="width: 7em;" id="txtValor_${totalRegistros}" type="number" class="inputValor inputTable focus input-default form-control" value="${''}">`, //Valor
      `<input style="width: 7em;" id="txtValPagto_${totalRegistros}" type="number" class="inputTable focus input-default form-control" value="${''}">`, //VAL_PAGTO
      `<input style="width: 7em;" id="txtValAberto_${totalRegistros}" type="number" class="inputTable focus input-default form-control" value="${''}">`, //VAL_ABERTO
      `<input style="width: 25em;" id="txtNome_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtPagoPara').val().indexOf("[") != -1 ? pegaDescricao("#txtPagoPara") : $("#txtPagoPara").val()}">`, //Nome
      `<input style="width: 25em;" id="txtObs_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtReferencia').val()}">`, //Obs
      `<input style="width: 7em;" id="txtDocumento_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtDocumento').val()}">`, //Docto
      `<input style="width: 10em;" id="txtCnpj_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //CNPJ
      `<input style="width: 25em;" id="txtEmpresa_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtPagoPor').val()}">`, //Empresa
      `<input style="width: 8.2em;" id="dtVen_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${$('#dtData').val()}">`, //Dt_Ven
      `<input style="width: 7em;" id="txtDupli_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //Dupli
      `<input style="width: 8.2em;" id="dtPagto_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${$('#dtData').val()}">`, //Data_Pagto
      `<input style="width: 13em;" id="txtObsBaixa_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //OBS_BAIXA
      `<input style="width: 7em;" id="txtNrCarteira_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //NR_CARTEIRA
      `<input style="width: 7em;" id="txtSerie_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //SERIE
      `<input style="width: 8.2em;" id="dtContrato_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${dtContrato}">`, //Dt_Contr
      `<input style="width: 7em;" id="txtTipo_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${''}">`, //sTipo
    ]).draw(false)
    await limpaCampos();
  }

  async function insereDadosTabela(sBaixas, sDadosCliente, sDuplicata) {
    let dtContrato = $('#dtContrato').val() != '' ? $('#dtContrato').val() : '1899-12-31';
    let duplicata = sDuplicata[0] != undefined ? sDuplicata[0].DUPLI : '';
    const clientePagoPara = $("#txtPagoPara").val();
    let cnpj = "";
    if (clientePagoPara.indexOf("[") != -1) {
      cnpj = await buscaValor("ENTIDADE", "CNPJ", "CODCLI", pegaChave(clientePagoPara));
    }
    const totalRegistros = $('#tabelaEmissao').DataTable().data().toArray().length + 1;
    $('#tabelaEmissao').DataTable().row.add([
      retornaBotaoOpcoes(),
      `<input style="width: 7em;" id="txtNumAp_${totalRegistros}" type="text" class="inputNumAp inputTable focus input-default form-control" value="${pegaChave('#txtNumero')}">`, //Num_Ap
      `<input style="width: 7em;" id="txtValor_${totalRegistros}" type="number" class="inputValor inputTable focus input-default form-control" value="${$('#txtValor').val()}">`, //Valor
      `<input style="width: 7em;" id="txtValPagto_${totalRegistros}" type="number" class="inputTable focus input-default form-control" value="${''}">`, //VAL_PAGTO
      `<input style="width: 7em;" id="txtValAberto_${totalRegistros}" type="number" class="inputTable focus input-default form-control" value="${''}">`, //VAL_ABERTO
      `<input style="width: 25em;" id="txtNome_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtPagoPara').val().indexOf("[") != -1 ? pegaDescricao("#txtPagoPara") : $("#txtPagoPara").val()}">`, //Nome
      `<input style="width: 25em;" id="txtObs_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtReferencia').val()}">`, //Obs
      `<input style="width: 7em;" id="txtDocumento_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtDocumento').val()}">`, //Docto
      `<input style="width: 10em;" id="txtCnpj_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${cnpj != "" ? cnpj : sDadosCliente[0].CNPJ}">`, //CNPJ
      `<input style="width: 25em;" id="txtEmpresa_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${$('#txtPagoPor').val()}">`, //Empresa
      `<input style="width: 8.2em;" id="dtVen_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${$('#dtData').val()}">`, //Dt_Ven
      `<input style="width: 7em;" id="txtDupli_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${duplicata}">`, //Dupli
      `<input style="width: 8.2em;" id="dtPagto_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${sBaixas[0].DT_PAGTO}">`, //Data_Pagto
      `<input style="width: 13em;" id="txtObsBaixa_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${sBaixas[0].OBS_BAIXA}">`, //OBS_BAIXA
      `<input style="width: 7em;" id="txtNrCarteira_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${sDadosCliente[0].NR_CARTEIRA}">`, //NR_CARTEIRA
      `<input style="width: 7em;" id="txtSerie_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${sDadosCliente[0].SERIE}">`, //SERIE
      `<input style="width: 8.2em;" id="dtContrato_${totalRegistros}" type="date" max="2500-12-31" class="inputTable focus input-default form-control" value="${dtContrato}">`, //Dt_Contr
      `<input style="width: 7em;" id="txtTipo_${totalRegistros}" type="text" class="inputTable focus input-default form-control" value="${sTipo}">`, //sTipo
    ]).draw(false)
    await limpaCampos();
  }

  async function carregaLancamento() {
    let dtContrato = $('#dtContrato').val() != '' ? $('#dtContrato').val() : '1899-12-31';
    let sLancamento = await buscaLancamento(pegaChave('#txtNumero'), pegaChave('#txtLancamento'));
    let sDocto = $('#radioPagar').is(':checked') ? sLancamento.DUPLI : sLancamento.DOCTO;
    const totalRegistros = $('#tabelaEmissao').DataTable().data().toArray().length + 1;
    $('#tabelaEmissao').DataTable().row.add([
      retornaBotaoOpcoes(),
      `<input style="width: 7em;" type="text" id="txtNumAp_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.NUM_AP}">`, //Num_Ap
      `<input style="width: 7em;" type="number" id="txtValor_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.VALOR}">`, //Valor
      `<input style="width: 7em;" type="number" id="txtValPagto_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.VAL_PAG}">`, //VAL_PAGTO
      `<input style="width: 7em;" type="number" id="txtValAberto_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.SALDO}">`, //VAL_ABERTO
      `<input style="width: 25em;" type="text" id="txtNome_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.NOME}">`, //Nome
      `<input style="width: 20em;" type="text" id="txtObs_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.OBS}">`, //Obs
      `<input style="width: 7em;" type="text" id="txtDocumento_${totalRegistros}" class="inputTable focus input-default form-control" value="${sDocto}">`, //Docto
      `<input style="width: 10em;" type="text" id="txtCnpj_${totalRegistros}" class="inputTable focus input-default form-control" value="${await buscaValor('ENTIDADE', 'CNPJ', 'CODCLI', sLancamento.CODCRE)}">`, //CNPJ
      `<input style="width: 25em;" type="text" id="txtEmpresa_${totalRegistros}" class="inputTable focus input-default form-control" value="${getCookie('g_nome_empresa_logada')}">`, //Empresa
      `<input style="width: 8.2em;" type="date" max="2500-12-31" id="dtVen_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.DT_VEN}">`, //Dt_Ven
      `<input style="width: 7em;" type="text" id="txtDupli_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.DUPLI}">`, //Dupli
      `<input style="width: 8.2em;" type="date" max="2500-12-31" id="dtPagto_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.DT_PAGTO}">`, //Data_Pagto
      `<input style="width: 13em;" type="text" id="txtObsBaixa_${totalRegistros}" class="inputTable focus input-default form-control" value="${sLancamento.OBS_BAIXA}">`, //OBS_BAIXA
      `<input style="width: 7em;" type="text" id="txtNrCarteira_${totalRegistros}" class="inputTable focus input-default form-control" value="${await buscaValor('PESSOAL', 'NR_CARTEIRA', 'CODIGO', sLancamento.CODCRE)}">`, //NR_CARTEIRA
      `<input style="width: 7em;" type="text" id="txtSerie_${totalRegistros}" class="inputTable focus input-default form-control" value="${await buscaValor('PESSOAL', 'SERIE', 'CODIGO', sLancamento.CODCRE)}">`, //SERIE
      `<input style="width: 8.2em;" type="date" max="2500-12-31" id="dtContrato_${totalRegistros}" class="inputTable focus input-default form-control" value="${dtContrato}">`, //Dt_Contr
      `<input style="width: 7em;" type="text" id="txtTipo_${totalRegistros}" class="inputTable focus input-default form-control" value="${sTipo}">`, //sTipo
    ]).draw(false);
    await limpaCampos();
  };

  // async function formataCnpj(numLinha) {

  //   let options = {
  //     onKeyPress(cpf, ev, el, op) {
  //       let masks = ["000.000.000-000", "00.000.000/0000-00"];
  //       $(`#txtCnpj_${numLinha}`).mask(cpf.length > 14 ? masks[1] : masks[0], op);
  //     },
  //   };

  //   if ($(`#txtCnpj_${numLinha}`).length > 11) {
  //     $(`#txtCnpj_${numLinha}`).mask("00.000.000/0000-00", options);
  //   } else {
  //     $(`#txtCnpj_${numLinha}`).mask("000.000.000-00#", options);
  //   }
  // }

  $('#btnImprimirEmissao').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let Grid = await buscaDadosTabela();
        const url = `/sisplan/impressao/v1/impressaodinamica?`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEmissaoRecibo');
        const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'RelEmissaoRecibo', `JSON=${JSON.stringify(Grid)}`);

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function buscaDadosTabela() {
    let Grid = [];
    let controle = 1;
    const tabelaEmissao = $('#tabelaEmissao').DataTable().rows().data().toArray();
    for (let i = 0; i < tabelaEmissao.length; i++) {
      const retorno = {
        NUMEROAP: '',
        VALOR_PAGO: '',
        VALOR_ABERTO: '',
        PAGO_PARA: $('#txtNome_' + controle).val(),
        OBS: $('#txtObs_' + controle).val(),
        DOCUMENTO: $('#txtDocumento_' + controle).val(),
        CNPJ: $('#txtCnpj_' + controle).val(),
        PAGO_POR: $('#txtEmpresa_' + controle).val(),
        DTVEN: $('#dtVen_' + controle).val(),
        DUPLI: $('#txtDupli_' + controle).val(),
        DT_PAGTO: $('#dtPagto_' + controle).val(),
        OBSBAIXA: $('#txtObsBaixa_' + controle).val(),
        NR_CARTEIRA: $('#txtNrCarteira_' + controle).val(),
        SERIE: $('#txtSerie_' + controle).val(),
        DTCONTRATO: $('#dtContrato_' + controle).val(),
        TIPO: $('#txtTipo_' + controle).val(),
      };

      if (!retorno.NUMEROAP) {
        retorno.NUMEROAP = $('#txtNumAp_' + controle).val() == '' ? $('#ftxtDocumento_' + controle).val() : $('#txtNumAp_' + controle).val();
      }

      retorno.VALOR_PAGO = $('#txtValPagto_' + controle).val() != '' ? parseFloat($('#txtValPagto_' + controle).val()) : 0;
      retorno.VALOR_ABERTO = $('#txtValAberto_' + controle).val() != '' ? parseFloat($('#txtValAberto_' + controle).val()) : 0;
      Grid.push(retorno);

      controle++;
    };
    return Grid;
  }

  async function buscaLancamento(sNumero, sLancamento) {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/recibo/v1/carregalancamento?';
        const response = await requisicao('GET', url, `NUMERO=${sNumero}&LANCAMENTO=${sLancamento}&TIPO=${sTipo}`, 30000);

        if (!response) return

        const jsonStr = await response.json();
        return jsonStr[0]

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaDadosCliente(sCodCli) {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/recibo/v1/buscadadoscliente?';
        const response = await requisicao('GET', url, `CODCLI=${sCodCli}&TIPO=${sTipo}`, 30000);

        if (!response) return

        const jsonStr = await response.json();
        return jsonStr

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaPeloNumero() {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/recibo/v1/buscapelonumero?';
        const response = await requisicao('GET', url, `NUMERO=${pegaChave('#txtNumero')}&TIPO=${sTipo}`, 30000);

        if (!response) return

        const jsonStr = await response.json();
        return jsonStr;

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function buscaBaixas() {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/recibo/v1/buscabaixas?';
        const response = await requisicao('GET', url, `NUMERO=${pegaChave('#txtNumero')}&TIPO=${sTipo}`, 30000);

        if (!response) return

        const jsonStr = await response.json();
        return jsonStr

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#txtNumero').on('focusout', async function () {
    if ($('#txtNumero').val() != '') {
      if ($('#radioReceber').is(':checked')) {
        const dados = await buscaPeloNumero(pegaChave('#txtNumero'));
        await carregaInputsReceber(dados);
      } else {
        const dados = await buscaPeloNumero(pegaChave('#txtNumero'));
        await carregaInputsPagar(dados)
      }
    }
  });

  async function carregaInputsPagar(dados) {
    let sValor = dados[0].VAL_PAG;
    // let sInput = dados[0].VALOR;
    // $('#txtValor').val($('#txtValor').val() - sValor);
    if ($('#txtValor').val() == 0 && sValor > 0) {
      $('#txtValor').val(sValor);
    }
    $('#txtReferencia').val(dados[0].OBS);
    $('#txtPagoPor').val(getCookie('g_nome_empresa_logada').substring(6));
    $('#txtPagoPara').val(await buscaValor('ENTIDADE', 'NOME', 'CODCLI', dados[0].CODCRE));
    $('#txtDocumento').val(dados[0].DOCTO);
    buscaDataAtual();
  }

  async function carregaInputsReceber(dados) {
    let sValor = dados[0].VALOR_PAGO + dados[0].DESCONTO;
    let sInput = dados[0].VALOR2;
    $('#txtValor').val(sInput - sValor);
    $('#txtReferencia').val(dados[0].OBS);
    $('#txtPagoPor').val(await buscaValor('ENTIDADE', 'NOME', 'CODCLI', dados[0].CODCLI));
    $('#txtPagoPara').val(getCookie('g_nome_empresa_logada').substring(6));
    $('#txtDocumento').val(dados[0].FATURA);
    buscaDataAtual();
  }

  async function buscaDuplicata(sNumero) {
    const pesquisaParam = {
      tabela: "PAGTO",
      camposSelect: [
        "DUPLI"
      ],
      where: [`NUM_AP = '${sNumero}'`]
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    return jsonStr;
  }

  $('#btnLimpaCampos').on('click', async function () {
    await limpaCampos();
  })

  async function limpaCampos() {
    $('#txtNumero').val('');
    $('#txtLancamento').val('');
    $('#txtPagoPor').val('');
    $('#txtDocumento').val('');
    $('#txtPagoPara').val('');
    $('#txtValor').val('');
    $('#txtReferencia').val('');
    $('#dtContrato').val('');
    buscaDataAtual();
  }

  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" id="btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '   </div>';
  }

  $("#txtValor").inputmask("numeric", {
    min: 0,
    positionCaretOnClick: "select",
    digits: 2
  }).on("focus", function () {
    var that = $(this);
    setTimeout(function () {
      that.select();
    }, 1)
  });

  async function buscaDataAtual() {
    Date.prototype.toDateInputValue = (function () {
      var local = new Date(this);
      local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
      return local.toJSON().slice(0, 10);
    });

    $(document).ready(function () {
      $('#dtData').val(new Date().toDateInputValue());
    });
  }

});