$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnNovaProspeccao',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma prospecção.',
          position: 'right'
        }
      },
      {
        element: '#tabelaProspeccao',
        popover: {
          title: 'Tabela Prospecção',
          description: 'Aqui estão os dados das prospecções cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("PROSPECCAO");
  const permissaoUsuarioLogadoEntidade = await permissaoAcessos("ENTIDADE");

  $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"CAD_PROSP", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'CODIGO', 'NOME');
  $('#txtCliente').pesquisa_variosServerside(1, '{ "tabela":"CAD_PROSP", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
  $('#txtCidade').pesquisa_variosServerside(1, '{ "tabela":"CIDADE", "camposSelect":[ "NOME", "COD_UF" ], "where": null}', 'NOME', 'COD_UF');
  $('#txtRamoAtividade').pesquisa_variosServerside(1, '{ "tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtUsuario').autocompleta(1, 'JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO" ], "where": null}');
  $('#txtRepresentante').autocompleta(1, 'JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO" ], "where": null}');


  $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"CAD_PROSP", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, 'Pesquisa de Código');
  $('#btnCliente').pesquisa_serversideSel('#txtCliente', `{ "tabela":"CAD_PROSP", "camposSelect":[ "CODCLI", "NOME" ], "where": null}`, 'Pesquisa de Cliente');
  $('#btnCidade').pesquisa_serversideSel('#txtCidade', `{ "tabela":"CIDADE", "camposSelect":[ "NOME", "COD_UF" ], "where": null}`, 'Pesquisa de Cidade');
  $('#btnRamoAtividade').pesquisa_serversideSel('#txtRamoAtividade', `{ "tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}`, 'Pesquisa de Ramo de Atividade');
  $('#btnUsuario').pesquisa_serverside(['#txtUsuario'], ['CODIGO'], ['NOME'], `{ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, 'Pesquisa de Usuário');
  $('#btnRepresentante').pesquisa_serverside(['#txtRepresentante'], ['CODREP'], ['NOME'], `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}`, 'Pesquisa de Representante');


  $('#btnACodigo').on('click', function () { $('#txtCodigo').empty().trigger('change') })
  $('#btnACliente').on('click', function () { $('#txtCliente').empty().trigger('change') })
  $('#btnACidade').on('click', function () { $('#txtCidade').empty().trigger('change') })
  $('#btnARamoAtividade').on('click', function () { $('#txtRamoAtividade').empty().trigger('change') })
  $('#btnAUsuario').on('click', function () { $('#txtUsuario').val('') })
  $('#btnARepresentante').on('click', function () { $('#txtRepresentante').val('') })

  $('#btnARazaoSocial').on('click', function () { $('#txtRazaoSocial').val('') })
  $('#btnAFantasia').on('click', function () { $('#txtFantasia').val('') })
  $('#btnACNPJ').on('click', function () { $('#txtCNPJ').val('') })
  $('#btnAInscricao').on('click', function () { $('#txtInscricao').val('') })
  $('#btnABairro').on('click', function () { $('#txtBairro').val('') })
  $('#btnAEmail').on('click', function () { $('#txtEmail').val('') })

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
    let options = {
      onKeyPress(cpf, ev, el, op) {
        let masks = ["000.000.000-000", "00.000.000/0000-00"];
        $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
      },
    };

    if ($("#txtCNPJ").length > 11) {
      $("#txtCNPJ").mask("00.000.000/0000-00", options);
    } else {
      $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $("#txtCNPJ").on('change', function () {
      let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
      if (validaCNPJ != false) {
        $("#txtCNPJ").val(validaCNPJ);
      }
    });
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCodigo').empty().trigger('change');
    $('#txtCliente').empty().trigger('change');
    $('#txtRamoAtividade').empty().trigger('change');
    $('#txtCidade').empty().trigger('change');

    $('#txtUsuario').val('');
    $('#txtRepresentante').val('');
    $('#txtRazaoSocial').val('');
    $('#txtFantasia').val('');
    $('#txtCNPJ').val('');
    $('#txtInscricao').val('');
    $('#txtBairro').val('');
    $('#txtEmail').val('');
    $('#txtObs').val('');

    $('#txtCadastroDe').val('1200-01-01');
    $('#txtCadastroAte').val('2500-12-31');
    $('#txtRetornoDe').val('1200-01-01');
    $('#txtRetornoAte').val('2500-12-31');
    $('#txtEstado').val('');
    $('#txtOrigem').val('0');

    $('#rdStatusTodos').prop('checked', true);
    $('#rdEntTodos').prop('checked', true);
    $('#rdPessoaTodos').prop('checked', true);
    $('#rdTipoTodos').prop('checked', true);

    $('#cbTodos').prop('checked', false);
    $('#cbLigacao').prop('checked', false);
    $('#cbEmail').prop('checked', false);
    $('#cbVisita').prop('checked', false);
    $('#cbWhatsapp').prop('checked', false);
    $('#cbOutros').prop('checked', false);
  });

  $('#btnNovaProspeccao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "prospeccao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Criar Entidade" id="btn-criarEntidade">Criar Entidade</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await fazConsulta();
  });

  async function retornaFiltros() {
    const dtCadastroDe = $('#txtCadastroDe').val();
    const dtCadastroAte = $('#txtCadastroAte').val();
    const dtRetornoDe = $('#txtRetornoDe').val();
    const dtRetornoAte = $('#txtRetornoAte').val();

    const estado = $('#txtEstado').val();
    const origem = $('#txtOrigem').val();

    const fantasia = $('#txtFantasia').val();
    const razao = $('#txtRazaoSocial').val()
    const cnpj = $('#txtCNPJ').val();
    const inscricao = $('#txtInscricao').val();
    const bairro = $('#txtBairro').val();
    const email = $('#txtEmail').val();
    const usuario = $('#txtUsuario').val();
    const representante = $('#txtRepresentante').val();
    const obs = $('#txtObs').val();

    const codigo = await formataListas($('#txtCodigo').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const cidade = await formataListas($('#txtCidade').val().toString());
    const ramoAtividade = await formataListas($('#txtRamoAtividade').val().toString());

    let formaTodos = $('#cbTodos').is(':checked') ? true : false
    let formaLigacao = $('#cbLigacao').is(':checked') ? true : false
    let formaEmail = $('#cbEmail').is(':checked') ? true : false
    let formaVisita = $('#cbVisita').is(':checked') ? true : false
    let formaWhatsapp = $('#cbWhatsapp').is(':checked') ? true : false
    let formaOutros = $('#cbOutros').is(':checked') ? true : false

    let filtroStatus;
    if ($('#rdStatusTodos').is(':checked')) {
      filtroStatus = 0
    } else if ($('#rdStatusProsp').is(':checked')) {
      filtroStatus = 1
    } else if ($('#rdStatusSemCont').is(':checked')) {
      filtroStatus = 2
    } else if ($('#rdStatusSemInt').is(':checked')) {
      filtroStatus = 3
    } else if ($('#rdStatusSemOrc').is(':checked')) {
      filtroStatus = 4
    } else {
      filtroStatus = 5
    }

    let filtroEntidade;
    if ($('#rdEntTodos').is(':checked')) {
      filtroEntidade = 0
    } else if ($('#rdEntCad').is(':checked')) {
      filtroEntidade = 1
    } else[
      filtroEntidade = 2
    ]

    let filtroTipoPessoa;
    if ($('#rdPessoaTodos').is(':checked')) {
      filtroTipoPessoa = 0
    } else if ($('#rdPessoaFisica').is(':checked')) {
      filtroTipoPessoa = 1
    } else {
      filtroTipoPessoa = 2
    }

    let filtroTipo;
    if ($('#rdTipoTodos').is(':checked')) {
      filtroTipo = 0
    } else if ($('#rdTipoAtivo').is(':checked')) {
      filtroTipo = 1
    } else {
      filtroTipo = 2
    }

    let filtros = `DTCADASTRODE=${dtCadastroDe}&` +
      `DTCADASTROATE=${dtCadastroAte}&` +
      `DTRETORNODE=${dtRetornoDe}&` +
      `DTRETORNOATE=${dtRetornoAte}&` +
      `ORIGEM=${origem}&` +
      `ESTADO=${estado}&` +
      `RAZAO=${razao}&` +
      `RAMO=${ramoAtividade}&` +
      `FANTASIA=${fantasia}&` +
      `CNPJ=${cnpj}&` +
      `INSCRICAO=${inscricao}&` +
      `BAIRRO=${bairro}&` +
      `EMAIL=${email}&` +
      `REPRESENTANTE=${representante}&` +
      `OBS=${obs}&` +
      `USR=${usuario}&` +
      `CODIGO=${codigo}&` +
      `CLIENTE=${cliente}&` +
      `CIDADE=${cidade}&` +
      `FILTROSTATUS=${filtroStatus}&` +
      `FILTROENTIDADE=${filtroEntidade}&` +
      `FILTROTIPOPESSOA=${filtroTipoPessoa}&` +
      `FILTROTIPO=${filtroTipo}&` +
      `FORMATODOS=${formaTodos}&` +
      `FORMALIGACAO=${formaLigacao}&` +
      `FORMAEMAIL=${formaEmail}&` +
      `FORMAVISITA=${formaVisita}&` +
      `FORMAWHATSAPP=${formaWhatsapp}&` +
      `FORMAOUTROS=${formaOutros}`

    return filtros
  }

  async function fazConsulta() {
    $.LoadingOverlay("show");
    try {
      try {
        dataSetCols = [];
        const url = "/sisplan/cadastros/v1/prospeccao?";
        const filtros = await retornaFiltros();
        const response = await requisicao("GET", url, `${filtros}&EMPRESA=${getCookie("empresa")}`, "", 360000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        };

        if (jsonStr.length == 0) {
          msgAlerta("Nenhum registro encontrado!");
          if ($.fn.DataTable.isDataTable('#tabelaProspeccao')) {
            $('#tabelaProspeccao').DataTable().destroy();
            $('#tabelaProspeccao').empty();
          }
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach((k) => {
          dataSetCols.push({
            title: k,
            data: k,
          });
        });

        $('#tabelaProspeccao').DataTable({
          bPaginate: true,
          destroy: true,
          colReorder: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último",
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente",
            },
          },
          "autoWidth": true,
          "columns": dataSetCols,
          "data": jsonStr,
          "columnDefs": [{
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          }]
        });


      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#cbTodos').on('change', async function () {
    if ($('#cbTodos').is(':checked')) {
      $('#cbLigacao').prop('checked', false)
      $('#cbLigacao').prop('disabled', true)
      $('#cbLigacao').prop('readonly', true)
      $('#cbEmail').prop('checked', false)
      $('#cbEmail').prop('disabled', true)
      $('#cbEmail').prop('readonly', true)
      $('#cbVisita').prop('checked', false)
      $('#cbVisita').prop('disabled', true)
      $('#cbVisita').prop('readonly', true)
      $('#cbWhatsapp').prop('checked', false)
      $('#cbWhatsapp').prop('disabled', true)
      $('#cbWhatsapp').prop('readonly', true)
      $('#cbOutros').prop('checked', false)
      $('#cbOutros').prop('disabled', true)
      $('#cbOutros').prop('readonly', true)
    } else {
      $('#cbLigacao').prop('checked', false)
      $('#cbLigacao').prop('disabled', false)
      $('#cbLigacao').prop('readonly', false)
      $('#cbEmail').prop('checked', false)
      $('#cbEmail').prop('disabled', false)
      $('#cbEmail').prop('readonly', false)
      $('#cbVisita').prop('checked', false)
      $('#cbVisita').prop('disabled', false)
      $('#cbVisita').prop('readonly', false)
      $('#cbWhatsapp').prop('checked', false)
      $('#cbWhatsapp').prop('disabled', false)
      $('#cbWhatsapp').prop('readonly', false)
      $('#cbOutros').prop('checked', false)
      $('#cbOutros').prop('disabled', false)
      $('#cbOutros').prop('readonly', false)
    }
  })

  $('#tabelaProspeccao').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaProspeccao').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('PROSPECCAO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `prospeccao/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaProspeccao').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaProspeccao').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('PROSPECCAO', data.CODIGO);
      if (registroLiberado) {
        window.location.href = `prospeccao/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaProspeccao').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaProspeccao").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#tabelaProspeccao').on('click', '#btn-criarEntidade', async function () {
    $.LoadingOverlay('show')
    try {
      if (permissaoUsuarioLogadoEntidade.INCLUI == 'S') {
        const data = $("#tabelaProspeccao").DataTable().row($(this).parents("tr")).data();
        if (data.CODCLI != '') {
          msgAlerta(`Entidade já cadastrada número: ${data.CODCLI}`)
          return;
        }
        await ciraEntidade(data.CODIGO);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para Incluir!");
      }

    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function ciraEntidade(codigo) {
    try {
      let novoCodCli = await RetornaProximo("CODCLI", "ENTIDADE", "CODCLI", 5)
      let response = await requisicao("POST", "/Sisplan/Cadastros/v1/clienteprospeccao?", `CODIGO=${encodeURIComponent(codigo)}&NOVOCODCLI=${novoCodCli}`, null);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(`Entidade Criada Com Sucesso! Numero : ${novoCodCli}`, "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          data.remove().draw(false);
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

      await fazConsulta();
    } catch (error) {
      console.error(error)
    }
  }

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/prospeccao?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
