<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Produto</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.243.11.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.243.11.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.243.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.243.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.243.11.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.243.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.243.11.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.243.11.1">
  <style>
    #tabelaCadProduto td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaCadProduto td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .btnBarra {
      color: black;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 5px 10px 5px;
      float: right;
    }

    #tabelaCadProduto_info {
      position: absolute;
      z-index: -1 !important;
    }

    .dropProduto::-webkit-scrollbar {
      width: 12px;
    }

    .dropProduto::-webkit-scrollbar-track {
      background: var(--btn-hover);
    }

    .dropProduto::-webkit-scrollbar-thumb {
      background: var(--color-secondary);
      border-radius: 20px;
      border: 3px solid var(--font-card-color);
    }

    .dropProduto {
      height: 180px;
      overflow-x: auto;
      min-width: 12rem !important;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      border-radius: 3px !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Produto</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card" id="tabelaCadProdutoForne">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span>
                Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnNovoProduto"><span class="fas fa-plus"></span> Incluir</button>
              <button id="btnImprimirAcessoProd" class="btn-sisp btn btn-secondary"><i class="fas fa-print"></i> Imprimir</button>
            </div>

            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Produtos</h5>
              <table id="tabelaCadProduto" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Código Produto
                    </th>
                    <th class="th-sm">Código2
                    </th>
                    <th class="th-sm">Foto
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Preço
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
              <div class="modal-content" id="modalBody">
                <div class="modal-header">
                  <h4 class="modal-title">Filtros</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="row justify-content-sm-start justify-content-center mb-3">
                    <div class="col-auto">
                      <fieldset class="form border-Field mb-0 pb-0 d-sm-flex d-block">
                        <legend class="textoBorda mb-0 pb-0">Opções</legend>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbTodos" name="cbStatusProd" checked>
                          <label for="cbTodos">Todos</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbAtivo" name="cbStatusProd" value="S">
                          <label for="cbAtivo">Ativo</label>
                        </div>
                        <div class="m-1 icheck-primary">
                          <input type="radio" id="cbInativo" name="cbStatusProd" value="N">
                          <label for="cbInativo">Inativo</label>
                        </div>
                      </fieldset>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaProduto">Produto: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaProduto" name="txtConsultaProduto" class="form-control" placeholder="Produto">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaProduto" name="btn-ConsultaProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaColecao">Coleção: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaColecao" name="txtConsultaColecao" class="form-control" placeholder="Colecao">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaColecao" name="btn-ConsultaColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaMarca">Marca: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaMarca" name="txtConsultaMarca" class="form-control" placeholder="Marca">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaMarca" name="btn-ConsultaMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaGrupo">Grupo: </label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaGrupo" name="txtConsultaGrupo" class="form-control" placeholder="Grupo">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaGrupo" name="btn-ConsultaGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <div class="row">
                    <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
                      Filtros</button>     
                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span>
                      Consultar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalBarra" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Barra - Cadastro de Itens de Estoque</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="row">
            <div class="col-xl-4">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtCodigoProduto">Codigo Produto</label>
                <div class="relative">
                  <input type="text" placeholder="Codigo Produto" class="input-default focus form-control validate" id="txtCodigoProduto" name="txtCodigoProduto" disabled>
                </div>
              </div>
            </div>
            <div class="col-xl-8">
              <div class="group-default form-group">
                <label data-error="wrong" data-success="right" for="txtDescricaoProduto">Descrição</label>
                <div class="relative">
                  <input type="text" placeholder="Descricao Produto" class="input-default focus form-control validate" id="txtDescricaoProduto" name="txtDescricaoProduto" disabled>
                </div>
              </div>
            </div>
          </div>
          <div>
            <div class="card">
              <div class="card-body px-0 pb-0" style="min-height: 100px;">
                <div class="col-sm-12 table-responsive card-body px-0 pb-0">
                  <table id="tabelaBarra" style="width: 100%;" class="table table-sm table-select table-hover">
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-warning btnBarra btn-sisp" id="btnConfirmarBarra"> Confirmar</button>
            <button class="btn btn-primary btnBarra btn-sisp" id="btnGeraEan13"> Gera EAN13</button>
            <button class="btn btn-primary btnBarra btn-sisp" id="btnGeraBarra128"> Gera Barra 128</button>
            <button class="btn btn-primary btnBarra btn-sisp d-none" id="btnGeraDun14Barra"> Gera Dun14</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalPartes" tabindex="-1" role="dialog" aria-labelledby="modalPartes" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Parte</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body pb-0">
          <div class="form-row">
            <div class="col-lg-12 col-12 pb-3">
              <label data-error="wrong" data-success="right" for="txtParte">Parte:</label>
              <div class="input-group">
                <input class="d-none" type="text" id="txtTabPadrao">
                <input class="d-none" type="text" id="txtCodigoFaccao">
                <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtParte" style="border-color: #a9a9a9">
                  <option class="drilldown-item" value=""></option>
                </select>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btnBarra btn-sisp" id="btnConfirmarPartes"> Confirmar</button>
            <button class="btn bg-gradient-danger btnBarra btn-sisp" id="btnFecharPartes"> Fechar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="imagemodal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">
          <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
          <img src="" class="imagepreview" style="width: 100%;">
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  include_once('../../../modals/modal_medidas.html');
  include_once('../../../modals/modal_combinacao.html');
  include_once('../../../modals/modal_histprod.html');
  include_once('../../../modals/modal_fluxo_produto.html');
  include_once('../../../modals/modal_proditensest.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.243.11.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.243.11.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.243.11.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.243.11.1"></script>
  <script src="dist/js/sisplan.js?versao=3.243.11.1"></script>
  <script src="utils/funcoes.js?versao=3.243.11.1"></script>
  <script src="utils/cookies.js?versao=3.243.11.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.243.11.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.243.11.1"></script>
  <script src="dist/js/driver.min.js?versao=3.243.11.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="config.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_medidas.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_combinacao.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_histprod.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_fluxo_produto.js?versao=3.243.11.1"></script>
  <script type="text/javascript" src="modals/modal_proditensest.js?versao=3.243.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PRODUTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/produto/acesso_produto/acesso_produto.js?versao=3.243.11.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>