function validarCaracteres(value) {
  const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
  return result?.length ?? 0;
}

$(document).ready(async function () {

  let validaConfirmar = false;
  let contaFs = 1;

  $(".next").click(function () {
    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    }
  });

  $(".previous").click(function () {
    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($(".abas").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  if (getCookie("usuario") == "") {
    window.location.href = `${BASE_URI}/login`;
    return;
  }

  $('#account').on('click', function () {
    if (contaFs == 2) {
      $('#voltar2').trigger('click');
    }
  });

  $('#confirm').on('click', function () {
    if (contaFs == 1) {
      $('#verBaixas').trigger('click');
    }
  });

  componenteFiltro('cliente', true);
  componenteFiltro('moeda', true);
  componenteFiltro('banco', false, false);
  componenteFiltro('classeBaixa', false, false);
  componenteFiltro('classeJuros', false, false);
  componenteFiltro('classeDesconto', false, false);
  componenteFiltro('historico', false, false);
  componenteFiltro('conta', false, false);
  componenteFiltro('integracao', false, false);


  function criaTabelaRetorno() {

    function retornaBotaoSel(meta, data) {
      let marcado = '';
      if (data == 'S') {
        marcado = 'checked';
      }

      return `<div class="icheck-primary">
                <input type="checkbox" ${marcado} id="check_col_${meta.col}_row_${meta.row}" class="campoSel">
                <label for="check_col_${meta.col}_row_${meta.row}"></label>
              </div>`;
    };

    const cols = [
      {
        title: `<div class="form-group icheck-primary col-1 m-0 p-0" id="containerSelTodos">
                        <input type="checkbox" class="input-default focus form-control validate" id="cbSelecionarTodos" name="cbSelecionarTodos">
                        <label for="cbSelecionarTodos">Sel</label>
                    </div>`,
        data: `SEL`
      },
      {
        title: 'Número',
        data: 'NUMERO'
      },
      {
        title: 'Emp_id',
        data: 'EMP_ID'
      },
      {
        title: 'Codcli',
        data: 'CODCLI'
      },
      {
        title: 'Número',
        data: 'NOSSO_NUMERO'
      },
      {
        title: 'Nome',
        data: 'NOME'
      },
      {
        title: 'Fatura',
        data: 'FATURA'
      },
      {
        title: 'Data Emissão',
        data: 'DT_EMISSAO'
      },
      {
        title: 'Data Vencimento',
        data: 'DT_VENCIMENTO'
      },
      {
        title: 'Data Pagamento',
        data: 'DT_PAGAMENTO'
      },
      {
        title: 'NSU',
        data: 'NSU'
      },
      {
        title: 'Número Terminal',
        data: 'NUM_TERMINAL'
      },
      {
        title: 'Valor',
        data: 'VALOR'
      },
      {
        title: 'Valor Pago',
        data: 'VALOR_PAGO'
      },
      {
        title: 'Valor Tarifa',
        data: 'VALOR_TARIFA'
      },
      {
        title: 'Valor Líquido',
        data: 'VALOR_LIQUIDO'
      },
      {
        title: 'Cartão',
        data: 'CARTAO'
      },
      {
        title: 'Saldo',
        data: 'SALDO'
      },
      {
        title: 'Banco',
        data: 'BANCO'
      },
      {
        title: 'Taxa Antec.',
        data: 'TAXAANTEC'
      },
      {
        title: 'Agência',
        data: 'AGENCIA'
      },
      {
        title: 'Conta',
        data: 'CONTA'
      },
      {
        title: 'Bandeira',
        data: 'BANDEIRA'
      },
      {
        title: 'Modalidade',
        data: 'MODALIDADE'
      },
      {
        title: 'Tipo Recto',
        data: 'TIPO_RECTO'
      },
      {
        title: 'Dif. Menor',
        data: 'DIF_MENOR'
      },
      {
        title: 'Dif. Maior',
        data: 'DIF_MAIOR'
      },
      {
        title: 'Parcela',
        data: 'PARCELA'
      },
      {
        title: 'Tipo Lancamento',
        data: 'TIPOLANCTO'
      },
      {
        title: 'Taxa',
        data: 'TAXA'
      },
      {
        title: 'Taxa Rec.',
        data: 'TAXAREC'
      },
      {
        title: 'Conciliado',
        data: 'CONCILIADO'
      },
      {
        title: 'Autorização',
        data: 'AUTORIZACAO'
      },
      {
        title: 'Data Emissão Arq.',
        data: 'DT_EMISSAO_ARQ'
      },
      {
        title: 'Data Vencimento Arq.',
        data: 'DT_VENCIMENTO_ARQ'
      },
      {
        title: 'Lançamento',
        data: 'LANCAMENTO'
      },
      {
        title: 'Valor Duplicata',
        data: 'VALOR_DUPLICATA'
      },
      {
        title: 'Não Seleciona',
        data: 'NAOSELECIONA'
      },
      {
        title: 'Agência Original',
        data: 'AGENCIA_ORIG'
      },
      {
        title: 'Conta Original',
        data: 'CONTA_ORIG'
      },
      {
        title: 'Id Api',
        data: 'ID_API'
      },
      {
        title: 'Id Receber',
        data: 'ID_RECEBER'
      },
      {
        title: 'Desc. Integração',
        data: 'DESC_INTEGRACAO'
      },
      {
        title: 'Tipo Erro',
        data: 'TIPOERRO'
      },
      {
        title: 'Valor Tarifa Conf',
        data: 'VALOR_TARIFA_CONF'
      },
      {
        title: 'Valor Antec. Conf',
        data: 'VALOR_ANTEC_CONF'
      },
      {
        title: 'Taxa Band. Dupl.',
        data: 'TAXA_BAND_DUPL'
      },
      {
        title: 'Taxa Moeda Dupl.',
        data: 'TAXA_MOEDA_DUPL'
      },
      {
        title: 'Tipo Pagamento',
        data: 'TIPO_PAGAMENTO'
      }
    ];

    try {
      $('#tabelaRetorno').DataTable({
        paging: false,
        lengthChange: false,
        info: false,
        order: [[1, 'desc']],
        destroy: true,
        autowidth: true,
        columnDefs: [
          {
            targets: [0],
            render: function (data, type, row, meta) {
              return retornaBotaoSel(meta, data);
            }
          },
          {
            type: 'date-br',
            targets: [7, 8, 9],
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              } else {
                return '';
              }

            },
          },
          {
            targets: [12, 13, 14, 15, 17, 19, 25, 26, 29, 37, 38, 39, 40],
            render: function (data) {
              let valor = parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });

              if (isNaN(parseFloat(valor))) {
                valor = '0';
              }

              return valor;
            },
          }
        ],
        rowCallback: async function (row, data) {
          $(row).css('color', 'white');
          if (data.TIPOERRO == 1) { // vermelho
            $(row).css('background-color', '#F46262');
            $(row).css('color', 'white');
          }
          if (data.TIPOERRO == 2) { // azul
            $(row).css('background-color', '#3C67B0');
            $(row).css('color', 'white');
          }
          if (data.TIPOERRO == 3) { // verde
            $(row).css('background-color', '#90ee90');
            $(row).css('color', 'black');
          }
          if (data.TIPOERRO == 4) { // roxo
            $(row).css('background-color', '#c673fe');
            $(row).css('color', 'black');
          }

          if (localStorage.getItem('theme') == 'theme-dark') {
            $(row.cells[0]).css('background-color', '#1d2729');
          } else {
            $(row.cells[0]).css('background-color', '#ffffff');
          }
          $(`#check_col_0_row_${row._DT_RowIndex}`).off('change');

          $(`#check_col_0_row_${row._DT_RowIndex}`).on('change', function () {
            let indice = (this.id).split('_')[4];
            let d = $('#tabelaRetorno').DataTable().row(indice).data();

            if ($(this).prop('checked')) {
              d.SEL = 'S';
            } else {
              d.SEL = 'N';
            }

            $('#tabelaRetorno').DataTable().row(indice).data(d).draw(false);
          })
        },
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        columns: cols
      });

      $('#tabelaRetorno_filter').addClass('d-none');

      $('#cbSelecionarTodos').on('change', function () {
        $.LoadingOverlay('show');
        if (localStorage.getItem('theme') == 'theme-dark') {
          $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#1d2729');
          $('#tabelaRetorno tbody tr').each(function () {
            if (($(this)[0].style.backgroundColor == 'rgb(0, 0, 0)') || ($(this)[0].style.backgroundColor == '')) {
              $(this)[0].style.color = 'rgb(255, 255, 255)';
            }
          })
        } else {
          $('#tabelaRetorno tr td:nth-child(1)').css('background-color', '#ffffff');
          $('#tabelaRetorno tbody tr').each(function () {
            if (($(this)[0].style.backgroundColor == 'rgb(255, 255, 255)') || ($(this)[0].style.backgroundColor == '')) {
              $(this)[0].style.color = 'rgb(0, 0, 0)';
            }
          })
        }

        if ($('#cbSelecionarTodos').prop('checked')) {
          $('.campoSel').prop('checked', true);
        } else {
          $('.campoSel').prop('checked', false);
        }

        $('.campoSel').trigger('change');
        $.LoadingOverlay('hide');
      })

      $('#tabelaRetorno thead th').each(function () {
        $(this)[0].style.verticalAlign = 'middle';
      })
    } catch (e) {
      console.log(e);
    }
  }

  async function carregaDadosApi() {
    try {

      let obj = await retornaObjInfo();

      let response = await requisicao("GET", `/Sisplan/escretorno/V1/carregadadosapi?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}&JSON=${encodeURIComponent(JSON.stringify(obj))}`);

      if (response.status != 200) {
        return;
      }

      let dadosRetorno = await response.json();
      if (response.status != 200) {
        msgErro(dadosRetorno.mensagem);
        return;
      }

      dadosRetorno.map((e) => {
        $('#tabelaRetorno').DataTable().row.add(e);
      })

      // tem que fazer duas vezes mesmo
      $('#tabelaRetorno').DataTable().draw(false);
      $('#tabelaRetorno').DataTable().draw(false);

    } catch (e) {
      console.log(e);
    }
  }

  async function retornaObjInfo() {
    let obj = {
      CLIENTE: await formataListas($('#txtCliente').val().toString()),
      MOEDA: await formataListas($('#txtMoeda').val().toString()),
      PAGTOINI: $('#txtPagamentoIni').val() != '' ? $('#txtPagamentoIni').val() : '1200-01-01',
      PAGTOFIM: $('#txtPagamentoFim').val() != '' ? $('#txtPagamentoFim').val() : '2500-12-31',
      EMIINI: $('#txtEmissaoIni').val() != '' ? $('#txtEmissaoIni').val() : '1200-01-01',
      EMIFIM: $('#txtEmissaoFim').val() != '' ? $('#txtEmissaoFim').val() : '2500-12-31',
      MOSTRARREGPROC: $('#cbMostrar').prop('checked'),
      TIPOINCONSISTENCIA: $('input[name="radioIncon"]:checked').val(),
      TIPOINFO: $('#txtInstrucao').val(),
      INTEGRACAO: pegaChave('#txtIntegracao'),
      BANCO: pegaChave('#txtBanco'),
      CONTA: pegaChave('#txtConta'),
      CLASSEBAIXA: pegaChave('#txtClasseBaixa'),
      CLASSETARIFA: pegaChave('#txtClasseJuros'),
      CLASSEANTEC: pegaChave('#txtClasseDesconto'),
      HISTORICO: pegaChave('#txtHistorico'),
      DATAPAGAMENTO: $('#txtPagamento').val() != '' ? $('#txtPagamento').val() : '1200-01-01',
      NAOGERARCC: $('#cbGerarCC').prop('checked')
    }

    return obj;
  }

  function calculaTotais() {
    try {
      let totEnc = 0;
      let totNaoEnc = 0;
      let totGeral = 0;
      let totSel = 0;
      let totBruto = 0;
      let totDesc = 0;
      let totLiq = 0;

      let data = $('#tabelaRetorno').DataTable().data().toArray();

      data.map((e) => {
        if (e.NUMERO != '') {
          totEnc += 1;
        }
        if (e.SEL == 'S') {
          totBruto += e.VALOR;
          totDesc += (e.VALOR_TARIFA + e.TAXAANTEC);
          totSel += 1;
        }
      })

      totNaoEnc = data.length - totEnc;
      totGeral = totNaoEnc // + edtTotEncJuno.Value;
      totLiq = totBruto - totDesc;

      $('#txtRegEnc').val(totEnc);
      $('#txtRegNao').val(totNaoEnc);
      $('#txtRegTot').val(totGeral);
      $('#txtRegSel').val(totSel);
      $('#txtRegBru').val(parseFloat(totBruto).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
      $('#txtRegDes').val(parseFloat(totDesc).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));
      $('#txtRegLiq').val(parseFloat(totLiq).toLocaleString("pt-br", {
        maximumFractionDigits: 2,
        minimumFractionDigits: 2,
      }));

    } catch (e) {
      console.log(e);
    }
  }

  $('#btnConfirmar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let dadosTabela = $('#tabelaRetorno').DataTable().data().toArray();

        if (dadosTabela.length == 0) {
          msgErro('Não existem dados a serem gravados!');
          return;
        }

        if ($('#txtBanco').val() == '') {
          msgErro('Banco não informado, impossível continuar.');
          $('#txtBanco').focus();
          return;
        }

        if ($('#txtConta').val() == '') {
          msgErro('Conta não informada, impossível continuar.');
          $('#txtConta').focus();
          return;
        }

        if ($('#txtClasseBaixa').val() == '') {
          msgErro('Classe de baixa não informada, impossível continuar.');
          $('#txtClasseBaixa').focus();
          return;
        }

        if ($('#txtClasseJuros').val() == '') {
          msgErro('Classe de despesa não informada, impossível continuar.');
          $('#txtClasseJuros').focus();
          return;
        }

        if ($('#txtHistorico').val() == '') {
          msgErro('Histórico não informado, impossível continuar.');
          $('#txtHistorico').focus();
          return;
        }

        const data = dadosTabela.filter((e) => {
          return e.SEL == 'S';
        });

        if (data.length == 0) {
          msgErro('Necessário selecionar algum registro para gravar.')
          return;
        }

        if ($('#txtPagamento').val() != '') {
          msgAlerta('Uma data de pagamento foi informada, todos os lançamentos serão feitos nesta data. Continuar mesmo assim?', () => { }, () => { $('#txtPagamento').focus(); return; }, async () => { $.LoadingOverlay('show'); await gravaPagamentos(); bAtualiza = true; }, () => { $('#txtPagamento').focus(); return; });
        } else {
          await gravaPagamentos();
        }

      } catch (e) {
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  // $('#voltar1').on('click', function () {
  //   msgAlerta('Tem certeza que deseja cancelar o procedimento?', () => {
  //     window.location.href = `${BASE_URI}/index.php`
  //   })
  // })

  async function gravaPagamentos() {
    try {

      if ($('#cbGerarCC').prop('checked')) {
        await abreModalConfirmacao('Está marcado para NÃO gerar contábil e conta corrente dos títulos. Deseja continuar mesmo assim?');
        if (validaConfirmar) {
          rotinaGeraLog('INTEGRACAO_CARTAO', '', 'Marcou flag para não gerar contábil e conta corrente na baixa do arquivo. Tela - Integração Cartão', 'Movimentação')
        } else {
          return;
        }
      }

      let data = $('#tabelaRetorno').DataTable().data().toArray();

      let obj = {
        LISTAREG: data
      }

      let info = await retornaObjInfo();

      let response = await requisicao("POST", `/Sisplan/escretorno/V1/gravadadosintegracaocartao?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `&JSONINFO=${encodeURIComponent(JSON.stringify(info))}&JSONDADOS=${encodeURIComponent(JSON.stringify(obj))}`);

      if (!response) {
        msgErro('Não foi possível gravar os dados.');
        return;
      }

      let retorno = await response.json();
      if (response.status != 200) {
        msgErro('Não foi possível gravar os dados.');
        return;
      }

      if (retorno == -1) {
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#limparDados').trigger('click');
            $('#verBaixas').trigger('click');
          }
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
      } else {
        $('#limparDados').trigger('click');
        $('#verBaixas').trigger('click');
      }

    } catch (e) {
      console.log(e);
      msgErro('Não foi possível gravar os dados.');
    }
  }

  $('#limparDados').on('click', function () {
    $.LoadingOverlay('show');
    if ($.fn.DataTable.isDataTable('#tabelaRetorno')) {
      $('#tabelaRetorno').DataTable().destroy();
      $('#tabelaRetorno').empty();
    }
    $('#txtRegEnc').val('');
    $('#txtRegNao').val('');
    $('#txtRegTot').val('');
    $('#txtRegSel').val('');
    $('#txtRegBru').val('');
    $('#txtRegDes').val('');
    $('#txtRegLiq').val('');
    $.LoadingOverlay('hide');
  })

  $('#verBaixas').on('click', async function () {
    if (($('#txtPagamentoIni').val() == '1200-01-01') && ($('#txtPagamentoFim').val() == '2500-12-01') && ($('#txtEmissaoIni').val() == '1200-01-01') && ($('#txtEmissaoFim').val() == '2500-12-01')) {
      await abreModalConfirmacao('O período informado é muito grande. Tem certeza que deseja continuar?');
      if (!validaConfirmar) {
        $('#voltar2').trigger('click');
        return;
      }
    }

    if (!$.fn.DataTable.isDataTable('#tabelaRetorno')) {
      criaTabelaRetorno();
    }
    if ($('#tabelaRetorno').DataTable().data().length == 0) {
      $('#cbGerarCC').prop('checked', false);
      $.LoadingOverlay('show');
      try {
        await carregaDadosApi();
        calculaTotais();

      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });

  criaTabelaRetorno();

  async function abreModalConfirmacao(msg) {
    return await new Promise(async (resolve) => {

      setTimeout(async () => {
        $.LoadingOverlay('hide');

        $('#modal-warning .modal-header').css('-webkit-justify-content', 'left')

        await msgAlerta(msg,
          async () => { },
          async () => {
            validaConfirmar = false;
            resolve();
          },
          async () => {
            $.LoadingOverlay('show');
            validaConfirmar = true;
            resolve();
          })
      }, 500);

    })
  }

  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
        animate: true,
        onNext: (Element) => {
          if ((Element.node.id == 'verBaixas')) {
            $('#verBaixas').trigger('click');
          };
        },
        onPrevious: (Element) => {
          if (Element.node.id == 'fieldset2') {
            $('#voltar2').trigger('click');
          }
        }
      });

      driver.defineSteps([
        {
          element: "#fieldset1",
          popover: {
            title: "Dados",
            description:
              "Aqui você informa os dados da ocorrência.",
            position: "right",
          },
        },
        {
          element: "#voltar1",
          popover: {
            title: "Botão Voltar",
            description:
              "Clique neste botão para voltar para a tela de acesso.",
            position: "right",
          },
        },
        {
          element: "#verBaixas",
          popover: {
            title: "Botão Gravar",
            description: "Clique neste botão para avançar para a aba Configuração.",
            position: "top",
          },
        },
        {
          element: "#fieldset2",
          popover: {
            title: "Configuração",
            description: "Aqui você realiza a configuração da ocorrência.",
            position: "top",
          },
        },
        {
          element: "#voltar2",
          popover: {
            title: "Configuração",
            description: "Clique neste botão para voltar para a aba Geral.",
            position: "top",
          },
        },
        {
          element: "#btnConfirmar",
          popover: {
            title: "Configuração",
            description: "Clique neste botão para gravar os dados.",
            position: "top",
          },
        },
      ]);
      driver.start();
    });
  });

});