async function avancarPag() {
    currentFs = $(this).parent();
    nextFs = $(this).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate({
        opacity: 0
    }, {
        step(now) {
            opacity = 1 - now;

            currentFs.css({
                'display': 'none',
                'position': 'relative'
            });
            nextFs.css({
                'opacity': opacity
            });
        },
        duration: 600
    });
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'formacard') {
                    $('#btnVoltar').trigger('click');
                };
                if (Element.node.id == 'configuracao') {
                    $('#voltar2').trigger('click');
                }
            }
        })

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtEstrutura',
            popover: {
                title: 'Estrutura',
                description: 'Neste campo adicionamos a estrutura do Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#rgTipo',
            popover: {
                title: 'Tipo',
                description: 'Neste campo selecionamos o tipo do Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#tpCusto',
            popover: {
                title: 'Tipo de Custo',
                description: 'Neste campo selecionamos o tipo de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtGrupoCC',
            popover: {
                title: 'Grupo',
                description: 'Neste campo adicionamos o grupo para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtResponsavel',
            popover: {
                title: 'Responsavel',
                description: 'Neste campo adicionamos o responsavel para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtResponsavel2',
            popover: {
                title: 'Responsavel Auxiliar',
                description: 'Neste campo adicionamos o responsavel auxiliar para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtNegocio',
            popover: {
                title: 'Negócio',
                description: 'Neste campo adicionamos o negócio para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: '#txtObs',
            popover: {
                title: 'Observação',
                description: 'Neste campo adicionamos a observação para o Centro de Custo.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description: "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Ao clicar nesse botão você irá para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#configuracao',
            popover: {
                title: 'Selecionar Empresas',
                description: 'Nesta tabela você seleciona as empresas do Centro de Custo.',
                position: 'left'
            }
        },
        {
            element: "#voltar2",
            popover: {
                title: "Botão Voltar",
                description: "Ao clicar nesse botão você retorna para a aba anterior.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o Centro de Custo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    await preencheEmpresas();

    async function criaPesquisas() {
        $('#txtGrupoCC').autocompleta(1, `JSON={ "tabela":"GRUPO_CCUSTO", "camposSelect":[ "CODIGO chave", "DESCRICAO descricao"], "where": null}`);
        $('#btnGrupoCC').pesquisa_serverside(['#txtGrupoCC'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_CCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Grupo de Centro de Custo');
        $('#btnAGrupoCC').on('click', function () {
            $('#txtGrupoCC').val('');
        });

        $('#txtNegocio').autocompleta(1, `JSON={ "tabela":"NEGOCIOCUSTO", "camposSelect":[ "ID chave", "DESCRICAO descricao"], "where": null}`);
        $('#btnNegocio').pesquisa_serverside(['#txtNegocio'], ['ID'], ['DESCRICAO'], '{"tabela":"NEGOCIOCUSTO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa Negócio de Centro de Custo');
        $('#btnANegocio').on('click', function () {
            $('#txtNegocio').val('');
        });

        $('#txtResponsavel2').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": ["ATIVO = 'S'"]}`);
        $('#btnResponsavel2').pesquisa_serverside(['#txtResponsavel2'], ['CODIGO'], ['NOME'], `{"tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Usuário');
        $('#btnAResponsavel2').on('click', function () {
            $('#txtResponsavel2').val('');
        });

        $('#txtResponsavel').autocompleta(1, `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO chave", "NOME descricao"], "where": ["ATIVO = 'S'"]}`);
        $('#btnResponsavel').pesquisa_serverside(['#txtResponsavel'], ['CODIGO'], ['NOME'], `{"tabela":"ACESSO_USUARIOS", "camposSelect":[ "CODIGO", "NOME"], "where": ["ATIVO = 'S'"]}`, 'Pesquisa de Usuário');
        $('#btnAResponsavel').on('click', function () {
            $('#txtResponsavel').val('');
        });

        $('#tabelaEmpresa').on('click', 'td', function () {
            selecionarLinhaTabela('#tabelaEmpresa', 'checkEmpresa', this);
        });
    };

    $('#tabelaEmpresa').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollX: false,
        scrollY: '200px',
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });


    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CENTROCUSTO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/centrocusto`;
    });

    $(document).ready(function () {
        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
                rgTipo: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let centroCusto = parametros[parametros.length - 1];

    let contaFs = 1;

    $(".previous").click(function () {

        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li").eq($("#msform > fieldset").index(currentFs)).removeClass("active");
        previousFs.show();
        currentFs.animate({
            opacity: 0
        }, {
            step(now) {
                opacity = 1 - now;
                currentFs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previousFs.css({
                    'opacity': opacity
                });
            },
            duration: 600
        });
    });

    $(".next").click(function () {

        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($("#msform > fieldset").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    nextFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
            $("#tabelaEmpresa").DataTable().columns.adjust().draw(false);
        }
    });

    $('#account').on('click', function () {
        if (centroCusto != 'create') {
            if (contaFs == 2) {
                $('#voltar2').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (centroCusto != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
        }
    });

    $('#avancar1').on('click', function () {
        if ($('#rgTipo').val() == null) {
            $('#voltar2').trigger('click')
            msgAlerta('Tipo não informado!')
        }
    })

    async function buscaDados(codigo) {
        $.LoadingOverlay("show");
        try {
            let centroCusto = ''
            centroCusto += codigo != '' ? ` AND CODIGO = '${codigo}'` : ''

            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"CENTROCUSTO", 
                "camposSelect":["CODIGO", "DESCRICAO", "ESTRUTURA", "GRUPO", "RESPONSAVEL", "RESPONSAVEL_AUX", "ID_NEGOCIO", "OBS", "TP_CUSTO", "TIPO", "ATIVO", "PRODUTIVO"], 
                "where": ["1=1 ${centroCusto}"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                return jsonStr.RESULT[0][0];

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados do Centro de Custo: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    function preencheCampos(centroCusto) {
        $('#txtCodigo').val(centroCusto.CODIGO);
        $('#txtEstrutura').val(centroCusto.ESTRUTURA);
        $('#rgTipo').val(centroCusto.TIPO)
        $('#txtDescricao').val(centroCusto.DESCRICAO);
        $('#txtObs').val(centroCusto.OBS);

        insereValor('#txtGrupoCC', centroCusto.GRUPO, { tabela: 'GRUPO_CCUSTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: centroCusto.GRUPO });
        insereValor('#txtResponsavel', centroCusto.RESPONSAVEL, { tabela: 'ACESSO_USUARIOS', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: centroCusto.RESPONSAVEL });
        insereValor('#txtResponsavel2', centroCusto.RESPONSAVEL_AUX, { tabela: 'ACESSO_USUARIOS', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: centroCusto.RESPONSAVEL_AUX });
        centroCusto.ID_NEGOCIO == null ? '' : insereValor('#txtNegocio', centroCusto.ID_NEGOCIO, { tabela: 'NEGOCIOCUSTO', campoBusca: 'DESCRICAO', campoWhere: 'ID', valorWhere: centroCusto.ID_NEGOCIO });


        $('#cbCustoFixo').prop('checked', centroCusto.TP_CUSTO == 'F')
        $('#cbCustoVariavel').prop('checked', centroCusto.TP_CUSTO == 'V')

        $('#cbAtivo').prop('checked', centroCusto.ATIVO == 'S')
        $('#cbProdutivo').prop('checked', centroCusto.PRODUTIVO == 'S')
    }

    if (centroCusto != '' && centroCusto != 'create') {
        $('#txtCodigo').attr('disabled', true);
        if (await liberarRegistro('CENTROCUSTO', centroCusto) == false) {
            window.location.href = '../centrocusto';
        } else {
            let dados = await buscaDados(centroCusto)
            preencheCampos(dados)

            const dadosEmpresa = await buscaEmpresas(centroCusto);

            if (dadosEmpresa != '') {
                for (let i = 0; i < dadosEmpresa.length; i++) {
                    for (let x = 0; x < $('#tabelaEmpresa').DataTable().rows().data().length; x++) {
                        let dados = $('#tabelaEmpresa').DataTable().rows().data()[x];
                        let empresa = dados[1].split(' - ')[0];
                        if (empresa == dadosEmpresa[i].EMP_ID) {
                            $($('.checkEmpresa')[x]).prop('checked', true);
                            $($("table#tabelaEmpresa tr")[x + 1]).addClass("selected");
                        }
                    }
                }
            }
        }
    } else {
        $("#cbAtivo").prop("checked", true);
        $('#txtCodigo').val(await RetornaProximo('centrocusto', 'CENTROCUSTO', 'CODIGO', 0));
    }

    $("#gravar").click(async function () {

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();



        if (erros == 0) {
            try {
                $.LoadingOverlay("show");

                centroCusto = {};

                centroCusto.CODIGO = $('#txtCodigo').val();
                centroCusto.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                centroCusto.ESTRUTURA = $('#txtEstrutura').val().toUpperCase();
                centroCusto.TIPO = $('#rgTipo').val().toUpperCase();
                centroCusto.GRUPO = pegaChave('#txtGrupoCC')
                centroCusto.RESPONSAVEL = pegaChave('#txtResponsavel')
                centroCusto.RESPONSAVELAUX = pegaChave('#txtResponsavel2')
                centroCusto.IDNEGOCIO = pegaChave('#txtNegocio')
                centroCusto.OBS = $('#txtObs').val().toUpperCase();
                centroCusto.TPCUSTO = $('#cbCustoFixo').prop('checked') ? 'F' : 'V';
                centroCusto.ATIVO = $('#cbAtivo').prop('checked') ? 'S' : 'N';
                centroCusto.PRODUTIVO = $('#cbProdutivo').prop('checked') ? 'S' : 'N';

                let arrayEmpresas = [];
                for (let i = 0; i < $('#tabelaEmpresa').DataTable().rows('.selected').data().length; i++) {
                    let empresa = {};
                    let dados = $('#tabelaEmpresa').DataTable().rows('.selected').data()[i];
                    empresa.EMP_ID = dados[1].split(' - ')[0];
                    arrayEmpresas.push(empresa);
                }

                centroCusto.EMPRESAS = arrayEmpresas

                if (arrayEmpresas.length <= 0) {
                    msgAlerta('Nenhuma empresa selecionada!')
                    $.LoadingOverlay('hide')
                    return
                }

                let response = await requisicao('POST', '/Sisplan/Cadastros/v1/centrocusto?', `JSON=${encodeURIComponent(JSON.stringify(centroCusto))}`, null);

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                };

                let jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    `Cadastro efetuado com sucesso!
                         Centro de Custo: ${centroCusto.CODIGO}`,
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/centrocusto`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados do centro de custo: ${error}`);
            }
        }
    });

    async function preencheEmpresas() {
        const dataSet = await RetornaEmpresas();
        for (let i = 0; i < dataSet.length; i++) {
            const empresa = dataSet[i];
            $('#tabelaEmpresa').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_ID} - ${empresa.EMP_NOME}`]).draw(false);
        }
    };

    function botaoSelecionarGrid() {
        return '<div class="form-check icheck-primary">' +
            '<input type="checkbox" class="align-self-center checkEmpresa" value""><label></label>' +
            '</div>';
    };

    async function RetornaEmpresas() {
        const _url = `/sisplan/funcoes/v1/pesquisa?`;
        const _params = `JSON={"tabela":"empresa", "camposSelect":[ "emp_id", "emp_nome"], "where": null}`;

        try {
            const response = await requisicao('GET', _url, _params, null);

            if (!response) {
                return '';
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            return jsonStr.RESULT[0];

        } catch (error) {
            console.error(error);
        }
    };

    async function buscaEmpresas(codigo) {
        try {
            const url = '/Sisplan/Funcoes/v1/pesquisa?';
            const response = await requisicao('GET', url, `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID"], "where": ["TABELA = 'CENTROCUSTO' AND VALOR = '${codigo}'"]}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }
            if (jsonStr.RESULT[0].length > 0) {
                return jsonStr.RESULT[0];
            }
            return '';


        } catch (error) {
            console.error(error);
            msgErro('Erro ao buscar dados da empresa do usuário');
        }
    }

    await criaPesquisas()
});