$(document).ready(async function () {
    let bInclusao = false;
    let bAlteracao = false;
    let bModificacao = false;
    let bAlteracaoOrdem = false;
    let bDuplicar = false;

    $("#modal-fluxoProduto").modal({
        backdrop: "static",
        keyboard: true,
        show: false,
    });

    $('#txtParteFluxo').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtSimbologia').autocompleta(1, `JSON={ "tabela":"ETIQUETA", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#txtFluxo').autocompleta(1, `JSON={ "tabela":"ROTEIRO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtComposicao').autocompleta(1, `JSON={ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtTpProd').autocompleta(1, `JSON={ "tabela":"CAD_TIPO_PROD", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtCodigoImportarFluxoProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);


    $('#btnParte').pesquisa('#txtParteFluxo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "TIPO_APL","camposSelect": ["TIPO_APL.CODIGO", "TIPO_APL.DESCRICAO"]}`, 'Pesquisa Parte', 'TIPO_APL');
    $('#btnSimbologia').pesquisa('#txtSimbologia', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "ETIQUETA","camposSelect": ["ETIQUETA.CODIGO", "ETIQUETA.NOME"]}`, 'Pesquisa Simbologia', 'ETIQUETA');
    $('#btnFluxo').pesquisa('#txtFluxo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "ROTEIRO","camposSelect": ["ROTEIRO.CODIGO", "ROTEIRO.DESCRICAO"]}`, 'Pesquisa Fluxo', 'ROTEIRO');
    $('#btnComposicao').pesquisa('#txtComposicao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOMPOSI","camposSelect": ["CADCOMPOSI.CODIGO", "CADCOMPOSI.DESCRICAO"]}`, 'Pesquisa Composição', 'CADCOMPOSI');
    $('#btnTpProd').pesquisa('#txtTpProd', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CAD_TIPO_PROD","camposSelect": ["CAD_TIPO_PROD.CODIGO", "CAD_TIPO_PROD.DESCRICAO"]}`, 'Pesquisa Tp. Prod.', 'CAD_TIPO_PROD');
    $('#btnCodigoImportarFluxoProduto').pesquisa_serverside(['#txtCodigoImportarFluxoProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');


    $('#btnLimpaParte').on('click', function () {
        $('#txtParteFluxo').val('');
    })

    $('#btnLimpaSimbologia').on('click', function () {
        $('#txtSimbologia').val('');
    })

    $('#btnLimpaFluxo').on('click', function () {
        $('#txtFluxo').val('');
    })

    $('#btnLimpaComposicao').on('click', function () {
        $('#txtComposicao').val('');
    })

    $('#btnLimpaTpProd').on('click', function () {
        $('#txtTpProd').val('');
    })

    $("#btnLimpaCodigoImportarFluxoProduto").on("click", function () {
        $("#txtCodigoImportarFluxoProduto").val("");
    })

    $("#modal-fluxoProduto").on('show.bs.modal', async function () {
        limpaCamposFluxo();
        limpaDataTable("tabelaFluxo");
        limpaDataTable("tabelaSetoresFluxo");
        resetaVariaveisControle();
        await carregaFluxo();
    });


    $("#modal-fluxoProduto").on('shown.bs.modal', async function () {
        if ($.fn.DataTable.isDataTable('#tabelaFluxo')) {
            $("#tabelaFluxo").DataTable().columns.adjust().draw(false);
        }
        
        if ($.fn.DataTable.isDataTable('#tabelaSetoresFluxo')) {
            $("#tabelaSetoresFluxo").DataTable().columns.adjust().draw(false);
        }
    })


    $('#btnIncluirFluxo').on('click', async function () {
        bInclusao = true;
        ajustaBotoesGridFluxo(false);
        desmarcaSelected();
        limpaCamposFluxo();
        limpaDataTable('tabelaSetoresFluxo');
    })

    $('#btnAlterarFluxo').on('click', function () {
        
        if (!$.fn.DataTable.isDataTable('#tabelaFluxo')) {
            throw msgAlerta("Nenhum registro selecionado para alterar, verifique!");
        }

        const registroSelecionado = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
        if (registroSelecionado.length == 0) {
            msgAlerta('Nenhum registro selecionado para alterar, verifique!');
            return;
        }
        bAlteracao = true;
        ajustaBotoesGridFluxo(registroSelecionado[0].CODIGO != '');
    })

    $('#btnConfirmarFluxo').on('click', async function () {
        if (bAlteracaoOrdem) {
            throw msgAlerta("Necessário sair do modo de alteração de ordem para confirmar a operação.");
        }

        await adicionarFluxo();
    })

    $('#btnCancelarFluxo').on('click', function () {

        if (bAlteracaoOrdem) {
            throw msgAlerta("Necessário sair do modo de alteração de ordem para confirmar a operação.");
        }

        bInclusao = false;
        bAlteracao = false;
        bDuplicar = false;
        ajustaBotoesGridFluxo(false);
        desmarcaSelected();
        limpaCamposFluxo();
        limpaDataTable('tabelaSetoresFluxo');
    })

    $('#btnExcluirFluxo').on('click', async function () {
        $.LoadingOverlay("show");
        try {
            const registroSelecionado = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
            if (registroSelecionado.length == 0) {
                msgAlerta('Nenhum registro selecionado para excluir, verifique!');
                return;
            }
            if (registroSelecionado[0].CODIGO != '') {
                await excluirFluxo();
            } else {
                $("#tabelaFluxo").DataTable().rows(".selected").remove().draw(false);
                limpaDataTable('tabelaSetoresFluxo');
                limpaCamposFluxo();
            }
        } finally {
            $.LoadingOverlay("hide");
        }

    })

    $("#btnGravarFluxo").on("click", async function () {
        $.LoadingOverlay("show");
        $("#btnGravarFluxo").prop("disabled", true);
        try {
            if (validaIndice()) {
                await gravarFluxo();
            } else {
                msgAlerta("A soma dos indices deve ser igual a 1");
            }
        } finally {
            $.LoadingOverlay("hide");
            $("#btnGravarFluxo").prop("disabled", false);
        }
    })

    $("#btnRecalcularIndiceFluxo").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            recalculaIndice();
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnFecharFluxo").on("click", function () {
        if ((bInclusao) || (bAlteracao) || (bDuplicar)) {
           throw msgAlerta("Necessário sair do modo de inclusão/alteração para fechar a tela.");
        }

        if (bModificacao) {
            msgAlerta("Existem alterações que ainda não foram salvas, deseja mesmo fechar a tela? Qualquer alteração não salva será perdida.",
                () => { $("#modal-fluxoProduto").modal("hide"); });
        } else {
            $("#modal-fluxoProduto").modal("hide");
        }

    })

    $('#checkSelecionarTodos').on('change', function () {
        $('.campoSel').prop('checked', $('#checkSelecionarTodos').prop('checked'));
    });

    $('#checkSelecionarTodosAlterarSetores').on('change', function () {
        $('input[class=campoSelAlterarSetores]:checked').trigger('click');
        if ($("#checkSelecionarTodosAlterarSetores").prop("checked")) {
            $(".campoSelAlterarSetores").trigger("click");
        }
    });

    $('#checkSelecionarTodosImportarFluxoProduto').on('change', function () {
        $('.campoSelFluxoImportarFluxo').prop('checked', $('#checkSelecionarTodosImportarFluxoProduto').prop('checked'));
    });

    $("#btnIncluirSetor").on("click", async function () {
        await montaModalAlterarSetores();
        $("#checkSelecionarTodosAlterarSetores").prop("checked", false);
        $("#modalAlterarSetores").modal("show");
    })

    $("#modalAlterarSetores").on("shown.bs.modal", function () {
        if ($.fn.DataTable.isDataTable('#tabelaAlterarSetores')) {
            $("#tabelaAlterarSetores").DataTable().columns.adjust().draw(false);
        }
    })

    $("#btnExcluirSetor").on("click", async function () {

        const setoresSelecionados = $('#tabelaSetoresFluxo').DataTable().rows($($('input[class=campoSel]:checked').closest('tr'))).data().toArray().map(dados => "'" + dados.SETOR + "'").toString();

        if (setoresSelecionados.length == 0) {
            throw msgAlerta("Nenhum setor selecionado para excluir.");
        }

        msgAlerta("Deseja mesmo excluir os setores selecionados?", async () => { await excluirSetor(setoresSelecionados); })

    })

    $("#btnConfirmarAlterarSetores").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            if (await gravaSetores()) {
                $("#modalAlterarSetores").modal("hide");
                bModificacao = true;
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnAlterarOrdemSetor").on("click", function () {
        bAlteracaoOrdem = true;
        ajustaBotoesAlterarOrdem();
    })

    $("#btnConfirmaAlterarOrdem").on("click", function () {
        const tabelaFluxo = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
        const objetoSetoresFluxo = $("#tabelaSetoresFluxo").DataTable().data().toArray().map(function (objeto) { delete objeto.SEL; return objeto; });
        tabelaFluxo[0].SETORES_FLUXO = objetoSetoresFluxo;
        $("input[class=campoSel]:checked").prop("checked", false);
        bAlteracaoOrdem = false;
        ajustaBotoesAlterarOrdem();
    })

    $("#btnCancelaAlterarOrdem").on("click", async function () {
        const tabelaFluxo = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
        await montaTabelaSetoresFluxo(tabelaFluxo[0].SETORES_FLUXO);
        bAlteracaoOrdem = false;
        ajustaBotoesAlterarOrdem();
    })

    $("#btnSobeAlterarOrdem").on("click", function () {
        if ($("input[class=campoSel]:checked").length == 0) {
            throw msgAlerta("Nenhum setor selecionado para alterar a ordem! Verifique.");
        }

        if ($("input[class=campoSel]:checked").length != 1) {
            throw msgAlerta("Para alterar a ordem, somente um setor pode estar selecionado! Verifique.");
        }
        
        const registroAlterarOrdem = $("#tabelaSetoresFluxo").DataTable().rows($($("input[class=campoSel]:checked").closest("tr"))).data().toArray()[0];

        if (registroAlterarOrdem.ORDEM == 1) {
            throw msgAlerta("O setor ja esta na primeira posição!");
        }

        const indexRegistroAcima = $("#tabelaSetoresFluxo").DataTable().data().toArray().findIndex(function (obj) { return obj.ORDEM === registroAlterarOrdem.ORDEM - 1; });
        const registroAcima = $("#tabelaSetoresFluxo").DataTable().row(indexRegistroAcima).data();

        $("#tabelaSetoresFluxo").DataTable().row(indexRegistroAcima).data(registroAlterarOrdem).draw(false);
        $("#tabelaSetoresFluxo").DataTable().row(registroAlterarOrdem.ORDEM - 1).data(registroAcima).draw(false);
        $($(".campoSel")[indexRegistroAcima]).prop("checked", true);
        ajustaOrdemSetoresFluxo();

    })

    $("#btnDesceAlterarOrdem").on("click", function () {
        if ($("input[class=campoSel]:checked").length == 0) {
            throw msgAlerta("Nenhum setor selecionado para alterar a ordem! Verifique.");
        }

        if ($("input[class=campoSel]:checked").length != 1) {
            throw msgAlerta("Para alterar a ordem, somente um setor pode estar selecionado! Verifique.");
        }

        const ultimaOrdem = $("#tabelaSetoresFluxo").DataTable().rows().count();
        const registroAlterarOrdem = $("#tabelaSetoresFluxo").DataTable().rows($($("input[class=campoSel]:checked").closest("tr"))).data().toArray()[0];

        if (registroAlterarOrdem.ORDEM == ultimaOrdem) {
            throw msgAlerta("O setor ja esta na última posição!");
        }

        const indexRegistroAbaixo = $("#tabelaSetoresFluxo").DataTable().data().toArray().findIndex(function (obj) { return obj.ORDEM === registroAlterarOrdem.ORDEM + 1 });
        const registroAbaixo = $("#tabelaSetoresFluxo").DataTable().row(indexRegistroAbaixo).data();

        $("#tabelaSetoresFluxo").DataTable().row(indexRegistroAbaixo).data(registroAlterarOrdem).draw(false);
        $("#tabelaSetoresFluxo").DataTable().row(registroAlterarOrdem.ORDEM - 1).data(registroAbaixo).draw(false);
        $($(".campoSel")[indexRegistroAbaixo]).prop("checked", true);
        ajustaOrdemSetoresFluxo();

    })

    $("#btnImprimirFluxo").on("click", async function () {
        // try {
        //     $.LoadingOverlay('show');
        //     try {
        //       let url = `/sisplan/impressao/v1/relembarque?`;
      
        //       const filtros = await retornaFiltros();
        //       const bImprimeAutomatico = await verificaImprimirAutomatico('RelEmbarque');
        //       let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 1000000, false, 'RelEmbarque');
        //       if (arquivo != undefined) {
        //         if (!bImprimeAutomatico) {
        //           window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        //         }
        //         await limparRelatorios();
        //       }
      
        //     } catch (error) {
        //       console.error(error);
        //     }
        //   } finally {
        //     $.LoadingOverlay('hide');
        //   }
    })

    $("#btnDuplicarFluxo").on("click", function () {
        const registroSelecionado = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
        if (registroSelecionado.length == 0) {
            msgAlerta('Nenhum registro selecionado para duplicar, verifique!');
            return;
        }
        bDuplicar = true;
        ajustaBotoesGridFluxo(false);
    })

    $("#btnImportarFluxo").on("click", function () {
        $("#modalImportarFluxoProduto").modal("show");
    })

    $("#btnConsultarImportarFluxoProduto").on("click", async function () {
        $.LoadingOverlay("show");
        try {

            const codigoProduto = pegaChave("#txtCodigoImportarFluxoProduto");

            if (codigoProduto == "") {
                throw msgAlerta("Não foi possível realizar a consulta, código do produto não informado. Informe um código para prosseguir.")
            }

            await carregaImportarFluxoProduto(codigoProduto);

            if ($.fn.DataTable.isDataTable('#tabelaFluxoImportarFluxoProduto')) {
                if ($('#tabelaFluxoImportarFluxoProduto').DataTable().data().toArray().length > 0) {
                    $($('#tabelaFluxoImportarFluxoProduto tbody tr')[0]).trigger('click');
                }
            }

        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnConfirmarImportarSetores").on("click", function () {
        $.LoadingOverlay("show");
        $("#btnConfirmarImportarSetores").prop("disabled", true);
        try {
            importarFluxo();
        } finally {
            $.LoadingOverlay("hide");
            $("#btnConfirmarImportarSetores").prop("disabled", false);
        }
    })

    $("#modalImportarFluxoProduto").on("hide.bs.modal", function () {
        $("#txtCodigoImportarFluxoProduto").val("");
        $("#checkSelecionarTodosImportarFluxoProduto").prop("checked", false);
        limpaDataTable("tabelaFluxoImportarFluxoProduto"); 
        limpaDataTable("tabelaSetoresImportarFluxoProduto"); 
    })


    async function carregaFluxo() {
        $.LoadingOverlay("show");
        try {
            const codigoProduto = $('#modal-fluxoProduto').prop('codigoProduto');

            const response = await requisicao('GET', '/sisplan/fluxo/v1/consultafluxo?', `CODIGO=${codigoProduto}`, '', 30000);

            if (!response) {
                msgAlerta(`Não foi possível carregar o fluxo do produto ${$('#txtTituloFluxo').html()}`);
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(`Não foi possível carregar o fluxo do produto ${$('#txtTituloFluxo').html()}`)
                return;
            }

            if (jsonStr.length == 0) {
                return;
            }

            const dataSetCols = [];
            const keys = Object.keys(jsonStr[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            };

            for (let i = 0; i < jsonStr.length; i++) {
                jsonStr[i].SETORES_FLUXO = await consultaSetoresFluxo('CONSULTA', jsonStr[i].CODIGO, jsonStr[i].PARTE);
            }

            criaDataTablePadrao('#tabelaFluxo', false, false, false, false, true, true, false, jsonStr, dataSetCols, [15, 16]);
            $("#tabelaFluxo").DataTable().order([0, 'asc']).draw(false);

            $('#tabelaFluxo tbody').unbind('click');
            eventoClickTabelaFluxo();

            if ($('#tabelaFluxo').DataTable().data().toArray().length > 0) {
                $($('#tabelaFluxo tbody tr')[0]).trigger('click');
            }


        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function montaTabelaSetoresFluxo(setoresFluxo) {
        let objSetoresFluxo;

        if (typeof(setoresFluxo) == "string") {
            objSetoresFluxo = JSON.parse(setoresFluxo);
        } else if (typeof(setoresFluxo) == "object") {
            objSetoresFluxo = setoresFluxo;
        }       

        if ($.fn.DataTable.isDataTable('#tabelaSetoresFluxo')) {
            if ($("#tabelaSetoresFluxo").DataTable().data().length != 0) {
                limpaDataTable("tabelaSetoresFluxo");
                $('#tabelaSetoresFluxo').DataTable().destroy();
                $('#tabelaSetoresFluxo').empty();
            }
        };

        if (objSetoresFluxo.length == 0) {
            return;
        }

        const dataSetCols = [];
        dataSetCols.push({
            'title': 'SEL',
            'data': 'SEL'
        });

        const keys = Object.keys(objSetoresFluxo[0]);
        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        };

        objSetoresFluxo.forEach((item, i) => {
            item.SEL = `<div class="icheck-primary d-inline">
                <input type="checkbox" id="check${i}" class="campoSel">
                <label for="check${i}"></label>
                </div>`;
            // item.OBSERVACAO = ``;
            // item.QTDE = ``;
            // item.DIAS = ``;
        });

        criaDataTablePadrao('#tabelaSetoresFluxo', false, false, false, false, true, true, false, objSetoresFluxo, dataSetCols, []);

    }

    function ajustaBotoesGridFluxo(bAlterarSetores) {
        $('#txtSimbologia').prop('disabled', !$('#txtSimbologia').prop('disabled'));
        $('#btnSimbologia').prop('disabled', !$('#btnSimbologia').prop('disabled'));
        $('#btnLimpaSimbologia').prop('disabled', !$('#btnLimpaSimbologia').prop('disabled'));
        $('#txtParteFluxo').prop('disabled',  !$('#txtParteFluxo').prop('disabled'));
        $('#txtComposicao').prop('disabled', !$('#txtComposicao').prop('disabled'));
        $('#btnComposicao').prop('disabled', !$('#btnComposicao').prop('disabled'));
        $('#btnLimpaComposicao').prop('disabled', !$('#btnLimpaComposicao').prop('disabled'));
        $('#txtTpProd').prop('disabled', !$('#txtTpProd').prop('disabled'));
        $('#btnTpProd').prop('disabled', !$('#btnTpProd').prop('disabled'));
        $('#btnLimpaTpProd').prop('disabled', !$('#btnLimpaTpProd').prop('disabled'));
        $('#txtObservacao').prop('disabled', !$('#txtObservacao').prop('disabled'));
        $('#txtIndice').prop('disabled', !$('#txtIndice').prop('disabled'));
        $('#txtOrdemFluxo').prop('disabled', !$('#txtOrdemFluxo').prop('disabled'));
        $('#txtMultiplo').prop('disabled', !$('#txtMultiplo').prop('disabled'));
        $('#btnGravarFluxo').prop('disabled', !$('#btnGravarFluxo').prop('disabled'));
        $('#btnImprimirFluxo').prop('disabled', !$('#btnImprimirFluxo').prop('disabled'));
        $('#btnDuplicarFluxo').prop('disabled', !$('#btnDuplicarFluxo').prop('disabled'));
        $('#btnImportarFluxo').prop('disabled', !$('#btnImportarFluxo').prop('disabled'));
        // $('#btnFotoFluxo').prop('disabled', !$('#btnFotoFluxo').prop('disabled'));

        if (bInclusao) {
            $('#txtParteFluxo').prop('disabled', false);
            $('#btnParte').prop('disabled', false);
            $('#btnLimpaParte').prop('disabled', false);
            $('#txtFluxo').prop('disabled', false);
            $('#btnFluxo').prop('disabled', false);
            $('#btnLimpaFluxo').prop('disabled', false);
        } else if (bDuplicar) {
            $('#txtParteFluxo').prop('disabled', false);
            $('#btnParte').prop('disabled', false);
            $('#btnLimpaParte').prop('disabled', false);
            $('#txtFluxo').prop('disabled', true);
            $('#btnFluxo').prop('disabled', true);
            $('#btnLimpaFluxo').prop('disabled', true);
        } else {
            $('#txtParteFluxo').prop('disabled', true);
            $('#btnParte').prop('disabled', true);
            $('#btnLimpaParte').prop('disabled', true);
            $('#txtFluxo').prop('disabled', true);
            $('#btnFluxo').prop('disabled', true);
            $('#btnLimpaFluxo').prop('disabled', true);
        }

        if (bAlterarSetores) {
            $('#btnIncluirSetor').prop('disabled', false);
            $('#btnAlterarOrdemSetor').prop('disabled', false);
            $('#btnExcluirSetor').prop('disabled', false);
        } else {
            $('#btnIncluirSetor').prop('disabled', true);
            $('#btnAlterarOrdemSetor').prop('disabled', true);
            $('#btnExcluirSetor').prop('disabled', true);
        }

        if ($('#btnIncluirFluxo').hasClass('d-none')) {
            $('#btnIncluirFluxo').removeClass('d-none');
            $('#btnAlterarFluxo').removeClass('d-none');
            $('#btnRecalcularIndiceFluxo').removeClass('d-none');
            $('#btnExcluirFluxo').removeClass('d-none');
            $('#btnConfirmarFluxo').addClass('d-none');
            $('#btnCancelarFluxo').addClass('d-none');
        } else {
            $('#btnIncluirFluxo').addClass('d-none');
            $('#btnAlterarFluxo').addClass('d-none');
            $('#btnRecalcularIndiceFluxo').addClass('d-none');
            $('#btnExcluirFluxo').addClass('d-none');
            $('#btnConfirmarFluxo').removeClass('d-none');
            $('#btnCancelarFluxo').removeClass('d-none');
        }
    }

    async function consultaSetoresFluxo(operacao, codigoProduto = '', parte = '', fluxo = '') {
        try {
            let params = `OPERACAO=${operacao}` +
                `&CODIGO=${codigoProduto}` +
                `&PARTE=${parte}`;

            if (operacao == 'INCLUSAO') {
                params += `&FLUXO=${fluxo}`;
            } 

            const response = await requisicao('GET', '/sisplan/fluxo/v1/consultasetoresfluxo?', params, '', 30000);

            if (!response) {
                msgAlerta(`Não foi possível carregar os setores do fluxo ${$('#txtTituloFluxo').html()}`);
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(`Não foi possível carregar os setores do fluxo ${$('#txtTituloFluxo').html()}`)
                return;
            }

            return JSON.stringify(jsonStr);


        } catch (error) {
            console.error(error);
        }
    }

    function desmarcaSelected() {
        const rows = $($('#tabelaFluxo').children()[1]).children();

        for (let i = 0; i < rows.length; i++) {
            if ($($($('#tabelaFluxo').children()[1]).children()[i]).hasClass('selected')) {
                $($($('#tabelaFluxo').children()[1]).children()[i]).removeClass('selected');
                break;
            }
        }
    }

    function limpaCamposFluxo() {
        $('#txtParteFluxo').val('');
        $('#txtSimbologia').val('');
        $('#txtFluxo').val('');
        $('#txtComposicao').val('');
        $('#txtTpProd').val('');
        $("#txtObservacao").val("")
        $('#txtIndice').val('');
        $('#txtOrdemFluxo').val('');
        $('#txtMultiplo').val('');
    }

    function limpaDataTable(tabela) {
        if ($.fn.DataTable.isDataTable(`#${tabela}`)) {
            $(`#${tabela}`).DataTable().clear().draw(false);
        }
    }

    async function adicionarFluxo() {
        const codigoProduto = $('#modal-fluxoProduto').prop('codigoProduto');
        const parteFluxo = $('#txtParteFluxo').val();
        const simbologiaFluxo = $('#txtSimbologia').val();
        const fluxo = $('#txtFluxo').val();
        const composicaoFluxo = $('#txtComposicao').val();
        const tpProdFluxo = $('#txtTpProd').val();
        const observacao = $("#txtObservacao").val();
        const indiceFluxo = $('#txtIndice').val();
        const ordemFluxo = parseInt($('#txtOrdemFluxo').val());
        const multiploFluxo = $('#txtMultiplo').val();
        

        if (parteFluxo == '') {
            throw msgAlerta('Parte não informada, verifique!');
        }

        if (fluxo == '') {
            throw msgAlerta('Fluxo não informado, verifique!');
        }

        if (ordemFluxo < 0) {
            throw msgAlerta('Ordem não pode ser menor que zero, verifique!');
        }

        if (ordemFluxo == '') {
            throw msgAlerta('Ordem não informada, verifique!');
        }

        if (indiceFluxo == '') {
            throw msgAlerta('Indice não informado, verifique!');
        }

        if (validaParteCadastrada(pegaChave(parteFluxo))) {
            throw msgAlerta('Parte já cadastrada nesse produto, verifique!');
        }

        async function callBack() {

            if (bAlteracao) {

            const linhaAlteracao = parseInt($("#tabelaFluxo").DataTable().rows(".selected").toArray().toString());

            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 0).data(ordemFluxo);
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 1).data(pegaChave(parteFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 2).data(pegaDescricao(parteFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 3).data(pegaChave(fluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 4).data(pegaDescricao(fluxo));
            // $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 5).data() NÃO SEI O Q PASSAR
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 6).data(indiceFluxo);
            // $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 7).data('N'); NÃO ALTERA
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 8).data(multiploFluxo);
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 9).data(observacao);
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 10).data(pegaChave(tpProdFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 11).data(pegaDescricao(tpProdFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 12).data(pegaChave(composicaoFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 13).data(pegaDescricao(composicaoFluxo));
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 14).data(pegaChave(simbologiaFluxo));
            // $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 15).data(/* CODIGO DO PRODUTO */);
            const objetoSetoresFluxo = $("#tabelaSetoresFluxo").DataTable().data().toArray().map(function (objeto) { delete objeto.SEL; return objeto; });
            $("#tabelaFluxo").DataTable().cell(linhaAlteracao, 16).data(JSON.stringify(objetoSetoresFluxo));

            $("#tabelaFluxo").DataTable().order([0, 'asc']).draw(false);

            bAlteracao = false;
            bModificacao = true;
            ajustaBotoesGridFluxo(false);

            } else if (bDuplicar) {
                const registroSelecionado = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray()[0];
                const setores = JSON.parse(registroSelecionado.SETORES_FLUXO);

                setores.forEach(setor => {
                    setor.PARTE = pegaChave(parteFluxo);
                })

                const objetoFluxo = {
                    ORDEM: ordemFluxo,
                    PARTE: pegaChave(parteFluxo),
                    DESCRICAO: pegaDescricao(parteFluxo),
                    FLUXO: pegaChave(fluxo),
                    DESC_FLUXO: pegaDescricao(fluxo),
                    DESC_PARTE: '',
                    IND_INV: indiceFluxo,
                    ESTOQUE: 'N',
                    MULTIPLO: multiploFluxo,
                    OBS: observacao,
                    TP_PROD: pegaChave(tpProdFluxo),
                    DESC_TP_PROD: pegaDescricao(tpProdFluxo),
                    COMPOSICAO: pegaChave(composicaoFluxo),
                    DESC_COMP: pegaDescricao(composicaoFluxo),
                    SIMBOLOGIA: pegaChave(simbologiaFluxo),
                    CODIGO: '',
                    SETORES_FLUXO: JSON.stringify(setores)
                }
    
                $('#tabelaFluxo').DataTable().row.add(objetoFluxo).draw(false);
                $("#tabelaFluxo").DataTable().order([0, 'asc']).draw(false);
    
                bDuplicar = false;
                bModificacao = true;
                ajustaBotoesGridFluxo(false);

            } else {
                const objetoFluxo = {
                    ORDEM: ordemFluxo,
                    PARTE: pegaChave(parteFluxo),
                    DESCRICAO: pegaDescricao(parteFluxo),
                    FLUXO: pegaChave(fluxo),
                    DESC_FLUXO: pegaDescricao(fluxo),
                    DESC_PARTE: '',
                    IND_INV: indiceFluxo,
                    ESTOQUE: 'N',
                    MULTIPLO: multiploFluxo,
                    OBS: observacao,
                    TP_PROD: pegaChave(tpProdFluxo),
                    DESC_TP_PROD: pegaDescricao(tpProdFluxo),
                    COMPOSICAO: pegaChave(composicaoFluxo),
                    DESC_COMP: pegaDescricao(composicaoFluxo),
                    SIMBOLOGIA: pegaChave(simbologiaFluxo),
                    CODIGO: '',
                    SETORES_FLUXO: await consultaSetoresFluxo('INCLUSAO', codigoProduto, pegaChave(parteFluxo), pegaChave(fluxo))
                }

                if (!$.fn.DataTable.isDataTable('#tabelaFluxo')) {
                    const dataSetCols = [];
                    const keys = Object.keys(objetoFluxo);
                    for (var k in keys) {
                        dataSetCols.push({
                            'title': keys[k],
                            'data': keys[k]
                        });
                    };

                    criaDataTablePadrao('#tabelaFluxo', false, false, false, false, true, true, false, '', dataSetCols, [15, 16]);

                    $('#tabelaFluxo tbody').unbind('click');
                    eventoClickTabelaFluxo();

                }

                $('#tabelaFluxo').DataTable().row.add(objetoFluxo).draw(false);
                $("#tabelaFluxo").DataTable().order([0, 'asc']).draw(false);

                bInclusao = false;
                bModificacao = true;
                ajustaBotoesGridFluxo(false);

            }

        }

        if (validaOrdemCadastrada(ordemFluxo)) {
            msgAlerta('Ordem já cadastrada nesse produto, deseja substituir a ordem já cadastrada? A ordem substituida será reposicionada para a ultima posição.',
                async () => {
                    reposicionaOrdem(ordemFluxo);
                    await callBack();
                });

        } else {
            await callBack();
        }
    }

    function validaParteCadastrada(parte) {
        try {
            if (!$.fn.DataTable.isDataTable('#tabelaFluxo')) {
                return false;
            }

            let data = [];
            if (bAlteracao) {
                const selected = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
                const dados = $("#tabelaFluxo").DataTable().data().toArray();

                for (let i = 0; i < dados.length; i++) {
                    if (dados[i] != selected[0]) {
                        data.push(dados[i]);
                    }
                }
            } else {
                data = $('#tabelaFluxo').DataTable().data().toArray();
            }

            if (data.filter(dados => dados.PARTE == parte).length > 0) {
                return true;
            }


        } catch (error) {
            console.error(error);
        }
    }

    function validaOrdemCadastrada(ordem) {
        try {
            if (!$.fn.DataTable.isDataTable('#tabelaFluxo')) {
                return false;
            }

            let data = [];
            if (bAlteracao) {
                const selected = $("#tabelaFluxo").DataTable().rows(".selected").data().toArray();
                const dados = $("#tabelaFluxo").DataTable().data().toArray();

                for (let i = 0; i < dados.length; i++) {
                    if (dados[i] != selected[0]) {
                        data.push(dados[i]);
                    }
                }
            } else {
                data = $('#tabelaFluxo').DataTable().data().toArray();
            }

            if (data.filter(dados => dados.ORDEM == ordem).length > 0) {
                return true;
            }


        } catch (error) {
            console.error(error);
        }
    }

    async function excluirFluxo() {
        try {
            const codigoProduto = $('#modal-fluxoProduto').prop('codigoProduto');
            const parteFluxo = pegaChave('#txtParteFluxo');
            const fluxo = pegaChave('#txtFluxo');
            const bExisteFaccao = await verificaExisteFaccao(codigoProduto, parteFluxo, fluxo);
            const bExistePrecoFaccao = await verificaExistePrecoFaccao(codigoProduto, parteFluxo);

            if (bExisteFaccao) {
                await msgAlerta('Código está sendo utilizado na Facção. Deseja Excluir?', async () => {
                    await senhaSupervisor('Deletar Fluxo',
                        async () => {
                            if (bExistePrecoFaccao) {
                                msgAlerta("Existem Preços de Facção cadastrados para este Produto e Parte, se continuar com a operação os preços serão excluídos. Deseja continuar?", async () => {
                                    await callBackPrecoFaccao();
                                    await rotinaGeraLog('FLUXO_PRODUTO', codigoProduto, 'Exclusão do Fluxo do Produto: ' + codigoProduto + ' Parte: ' + parteFluxo, 'Exclusão');
                                    $("#tabelaFluxo").DataTable().rows(".selected").remove().draw(false);
                                    limpaDataTable('tabelaSetoresFluxo');
                                    limpaCamposFluxo();
                                    bModificacao = true;
                                });
                            } else {
                                await rotinaGeraLog('FLUXO_PRODUTO', codigoProduto, 'Exclusão do Fluxo do Produto: ' + codigoProduto + ' Parte: ' + parteFluxo, 'Exclusão');
                                $("#tabelaFluxo").DataTable().rows(".selected").remove().draw(false);
                                limpaDataTable('tabelaSetoresFluxo');
                                limpaCamposFluxo();
                                bModificacao = true;
                            }

                        });
                });
            } else {
                await msgAlerta('Deseja eliminar este Registro?', async () => {
                    if (bExistePrecoFaccao) {
                        msgAlerta("Existem Preços de Facção cadastrados para este Produto e Parte, se continuar com a operação os preços serão excluídos. Deseja continuar?", async () => {
                            await callBackPrecoFaccao();
                            await rotinaGeraLog('FLUXO_PRODUTO', codigoProduto, 'Exclusão do Fluxo do Produto: ' + codigoProduto + ' Parte: ' + parteFluxo, 'Exclusão');

                            if ($("#tabelaFluxo").DataTable().rows().count() == 1) {
                                await deletaProFluxo(codigoProduto);
                            }

                            $("#tabelaFluxo").DataTable().rows(".selected").remove().draw(false);
                            limpaDataTable('tabelaSetoresFluxo');
                            limpaCamposFluxo();
                            bModificacao = true;

                        });
                    } else {
                        await rotinaGeraLog('FLUXO_PRODUTO', codigoProduto, 'Exclusão do Fluxo do Produto: ' + codigoProduto + ' Parte: ' + parteFluxo, 'Exclusão');

                        if ($("#tabelaFluxo").DataTable().rows().count() == 1) {
                            await deletaProFluxo(codigoProduto);
                        }

                        $("#tabelaFluxo").DataTable().rows(".selected").remove().draw(false);
                        limpaDataTable('tabelaSetoresFluxo');
                        limpaCamposFluxo();
                        bModificacao = true;

                    }
                });
            }

            async function callBackPrecoFaccao() {
                try {
                    const response = await requisicao('DELETE', '/sisplan/fluxo/v1/excluifluxo?', `CODIGO=${codigoProduto}&PARTE=${parteFluxo}`, '', 30000);

                    if (!response) {
                        // msgAlerta(`Não foi possível excluir o setor.`);
                        // return;
                    }

                    if (response.status != 200) {
                        // msgAlerta(`Não foi possível excluir o setor.`)
                        // return;
                    }

                    if (response.status == 200) {
                        await rotinaGeraLog('FLUXO_PRODUTO', codigoProduto, 'Exclusão do Preço de Facção do Produto: ' + codigoProduto + 'e Parte: ' + parteFluxo, 'Exclusão');
                    }
                } catch (error) {
                    console.error(error);
                }

            }

        } catch (error) {
            console.error(error);
        }
    }

    async function deletaProFluxo(codigoProduto) {
        try {
            const response = await requisicao('DELETE', '/sisplan/fluxo/v1/deletaprofluxo?', `CODIGO=${codigoProduto}`, '', 30000);

            if (!response) {
                msgAlerta("Não foi possível excluir o setor.");
                return;
            }

            if (response.status != 200) {
                msgAlerta("Não foi possível excluir o setor.");
                return;
            }

        } catch (error) {
            console.error(error);
        }
    }

    async function verificaExisteFaccao(codigoProduto, parteFluxo, fluxo) {
        try {
            const responseExisteFaccao = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"FACCAO",
                "camposSelect":["CODIGO"], 
                "where": ["CODIGO = '${codigoProduto}'", "FLUXO = '${fluxo}'", "PARTE = ${parteFluxo}"]}`, null);

            if (!responseExisteFaccao) {
                return false;
            }

            if (responseExisteFaccao.status != 200) {
                return false;
            }

            const jsonExisteFaccao = await responseExisteFaccao.json();

            if (jsonExisteFaccao.RESULT.length > 0) {
                return true;
            }

            return false;

        } catch (error) {
            console.error(error);
            return false;
        }
    }

    async function verificaExistePrecoFaccao(codigoProduto, parteFluxo) {
        try {
            const responseExistePrecoFaccao = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"TABELA",
                "camposSelect":["CODIGO"], 
                "where": ["CODIGO = '${codigoProduto}'", "PARTE = ${parteFluxo}"]}`, null);

            if (!responseExistePrecoFaccao) {
                return false;
            }

            if (responseExistePrecoFaccao.status != 200) {
                return false;
            }

            const jsonExistePrecoFaccao = await responseExistePrecoFaccao.json();

            if (jsonExistePrecoFaccao.RESULT.length > 0) {
                return true;
            }

            return false;

        } catch (error) {
            console.error(error);
            return false;
        }
    }

    async function gravarFluxo() {
        try {
            const codigoProduto = $('#modal-fluxoProduto').prop('codigoProduto');
            const objeto = {
                LISTAFLUXOS: await retornaFluxos()
            }
            const response = await requisicao("POST", "/sisplan/fluxo/v1/gravafluxo?", "", `LISTAFLUXOS=${JSON.stringify(objeto)}&CODIGO=${codigoProduto}`, 180000);

            if (!response) {
                msgAlerta("Não foi possível gravar os fluxos, tente novamente.");
                return;
            }

            if (response.status != 200) {
                msgAlerta("Não foi possível gravar os fluxos, tente novamente.");
                return;
            }

            await criaMensagemSucesso("Fluxos gravados com sucesso!",
                () => { bModificacao = false; $("#modal-fluxoProduto").modal("hide"); });

        } catch (error) {
            console.error(error);
        }
    }

    async function retornaFluxos() {
        const dados = $("#tabelaFluxo").DataTable().data().toArray();
        const listaFluxos = [];

        dados.forEach(fluxo => {
            const obj = {
                ORDEM: fluxo.ORDEM,
                PARTE: fluxo.PARTE,
                DESCRICAO: fluxo.DESCRICAO,
                FLUXO: fluxo.FLUXO,
                DESC_FLUXO: fluxo.DESC_FLUXO,
                DESC_PARTE: fluxo.DESC_PARTE,
                IND_INV: fluxo.IND_INV,
                MOV_ESTOQUE: fluxo.ESTOQUE,
                MULTIPLO: fluxo.MULTIPLO,
                OBSERVACAO: fluxo.OBS,
                TP_PROD: fluxo.TP_PROD,
                COMPOSICAO: fluxo.COMPOSICAO,
                DESC_COMPOSICAO: fluxo.DESC_COMP,
                SIMBOLOGIA: fluxo.SIMBOLOGIA,
                SETORES_FLUXO: JSON.parse(fluxo.SETORES_FLUXO)
            }
            listaFluxos.push(obj);
        });

        return listaFluxos;
    }

    function validaIndice() {
        return $("#tabelaFluxo").DataTable().column(6).data().sum() === 1;
    }

    function recalculaIndice() {
        const linhas = $("#tabelaFluxo").DataTable().rows().count();
        const indiceRecalculado = parseFloat((1 / linhas).toFixed(2));
        const ajusteValorArredondado = parseFloat((indiceRecalculado + parseFloat((1 - (indiceRecalculado * linhas)).toFixed(2))).toFixed(2));

        for (let i = 0; i < linhas; i++) {
            $("#tabelaFluxo").DataTable().cell(i, 6).data(indiceRecalculado);

            if (i == linhas - 1) {
                $("#tabelaFluxo").DataTable().cell(i, 6).data(ajusteValorArredondado);
            }
        }

    }

    function reposicionaOrdem(ordem) {
        const index = $("#tabelaFluxo").DataTable().data().toArray().findIndex(function (obj) { return obj.ORDEM === ordem; });
        const ultimaOrdem = Math.max.apply(null, $("#tabelaFluxo").DataTable().column(0).data().toArray());
        $("#tabelaFluxo").DataTable().cell(index, 0).data(ultimaOrdem + 1);
    }

    async function montaModalAlterarSetores() {
        $.LoadingOverlay("show");
        try {
            const codigoProduto = $('#modal-fluxoProduto').prop('codigoProduto');
            const descricaoProduto = $('#modal-fluxoProduto').prop('descricaoProduto');
            $("#txtCodigoAlterarSetores").val(`[${codigoProduto}] - ${descricaoProduto}`);
            $("#txtParteAlterarSetores").val($("#txtParteFluxo").val());
            $("#txtFluxoAlteraSetores").val($("#txtFluxo").val());

            await buscaSetoresAlterarSetores(codigoProduto, pegaChave("#txtParteFluxo"), pegaChave("#txtFluxo"));

        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function buscaSetoresAlterarSetores(codigo, parte, fluxo) {

        if ($.fn.DataTable.isDataTable('#tabelaAlterarSetores')) {
            $('#tabelaAlterarSetores').DataTable().destroy();
            $('#tabelaAlterarSetores').empty();
        };

        const ativo = "S"; // PEGAR A PARTIR DOS RADIOS

        const params = `CODIGO=${codigo}` +
            `&PARTE=${parte}` +
            `&FLUXO=${fluxo}` +
            `&ATIVO=${ativo}`;
        try {
            const response = await requisicao('GET', '/sisplan/fluxo/v1/consultaAlterarSetores?', params, '', 30000);

            if (!response) {
                msgAlerta("Não foi possível buscar os setores. Feche a tela e tente novamente.");
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta("Não foi possível buscar os setores. Feche a tela e tente novamente.");
                return;
            }

            if (jsonStr.length == 0) {
                return;
            }

            const dataSetCols = [];
            dataSetCols.push({
                'title': 'SEL',
                'data': 'SEL'
            });

            const keys = Object.keys(jsonStr[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            };

            jsonStr.forEach((item, i) => {
                item.SEL = `<div class="icheck-primary d-inline">
                <input type="checkbox" id="checkAlterarSetores${i}" class="campoSelAlterarSetores">
                <label for="checkAlterarSetores${i}"></label>
                </div>`
            });

            criaDataTablePadrao('#tabelaAlterarSetores', false, false, false, false, true, true, false, jsonStr, dataSetCols, [3, 4, 5]);

            verificaAlterarSetoresSelecionados();

        } catch (error) {
            console.error(error);
        }

    }

    function verificaAlterarSetoresSelecionados() {
        const dados = $("#tabelaAlterarSetores").DataTable().data().toArray();
        limpaDataTable("tabelaConfirmaAlterarSetores");

        dados.forEach((dado, i) => {
            if (dado.EXISTE_SETOR == "S") {
                $(`#checkAlterarSetores${i}`).prop("checked", true);
                adicionaTabelaConfirmaAlterarSetores(dado.CODIGO, dado.DESCRICAO, dado.ORDEM);
            }
        })
    }

    function adicionaTabelaConfirmaAlterarSetores(codigo, descricao, pOrdem = "") {
        const ordem = pOrdem != "" ? pOrdem : $("#tabelaConfirmaAlterarSetores").DataTable().rows().count() + 1;
        const row = [ordem, codigo, descricao];
        $("#tabelaConfirmaAlterarSetores").DataTable().row.add(row).draw(false);

        $(".campoSelAlterarSetores").unbind("click");
        $(".campoSelAlterarSetores").on("click", function () {
            const row = $("#tabelaAlterarSetores").DataTable().row($(this.closest('tr'))).data();
            if ($(this).prop("checked")) {
                adicionaTabelaConfirmaAlterarSetores(row.CODIGO, row.DESCRICAO);
            } else {
                removeTabelaConfirmaAlterarSetores(row.CODIGO);
            }

        })

    }

    function removeTabelaConfirmaAlterarSetores(codigo) {
        const index = $("#tabelaConfirmaAlterarSetores").DataTable().data().toArray().map(dados => dados[1]).findIndex(function (codigos) { return codigos === codigo });
        $("#tabelaConfirmaAlterarSetores").DataTable().row(index).remove().draw(false);
        ajustaOrdemConfirmaAlterarSetores();
    }

    function ajustaOrdemFluxo() {
        const rowsCount = $("#tabelaFluxo").DataTable().rows().count();

        for (let i = 0; i < rowsCount; i++) {
            $("#tabelaFluxo").DataTable().cell(i, 0).data(i + 1);
        }
    }

    function ajustaOrdemSetoresFluxo() {
        const rowsCount = $("#tabelaSetoresFluxo").DataTable().rows().count();

        for (let i = 0; i < rowsCount; i++) {
            $("#tabelaSetoresFluxo").DataTable().cell(i, 1).data(i + 1);
        }
    }

    function ajustaOrdemConfirmaAlterarSetores() {
        const rowsCount = $("#tabelaConfirmaAlterarSetores").DataTable().rows().count();

        for (let i = 0; i < rowsCount; i++) {
            $("#tabelaConfirmaAlterarSetores").DataTable().cell(i, 0).data(i + 1);
        }
    }

    async function excluirSetor(setores) {
        try {
            const codigoProduto = $('#modal-fluxoProduto').prop("codigoProduto");
            const parte = pegaChave("#txtParteFluxo");
            const bExistePrecoFaccaoSetor = await verificaExistePrecoFaccaoSetor(codigoProduto, parte, setores);

            if (!bExistePrecoFaccaoSetor) {
                $("#tabelaSetoresFluxo").DataTable().rows($($("input[class=campoSel]:checked").closest("tr"))).remove().draw(false);
                await rotinaGeraLog("PRODUTO", codigoProduto, "EXCLUSÃO DOS SETORES: " + setores.replaceAll("'", "") + " NO FLUXO DA PARTE: " + parte + " DO PRODUTO: " + codigoProduto, "Exclusão");
                ajustaOrdemSetoresFluxo();
                const objetoSetoresFluxo = $("#tabelaSetoresFluxo").DataTable().data().toArray().map(function (objeto) { delete objeto.SEL; return objeto; });
                $("#tabelaFluxo").DataTable().rows(".selected").data().toArray()[0].SETORES_FLUXO = JSON.stringify(objetoSetoresFluxo);
                bModificacao = true;
            }

        } catch (error) {
            console.error(error);
        }

    }

    async function gravaSetores() {
        const tabelaConfirmaAlterarSetores = $("#tabelaConfirmaAlterarSetores").DataTable().data().toArray();
        const parte = pegaChave("#txtParteAlterarSetores");
        const listaSetores = [];

        tabelaConfirmaAlterarSetores.forEach(dado => {
            const setor = {
                ORDEM: dado[0],
                SETOR: dado[1],
                DESCRICAO: dado[2],
                PARTE: parte,
                OBSERVACAO: "",
                QTDE: 0,
                DIAS: 0,
                TERCEIRO: "",
                NOME_TERCEIRO: ""
            }
            listaSetores.push(setor);
        });

        const objeto = {
            PARTE: parte,
            FLUXO: pegaChave("#txtFluxoAlteraSetores"),
            SETORES_FLUXO: listaSetores
        }

        try {

            const response = await requisicao("PUT", "/sisplan/fluxo/v1/gravasetores?", "", `FLUXO=${JSON.stringify(objeto)}&CODIGO=${pegaChave("#txtCodigoAlterarSetores")}`, 180000);

            if (!response) {
                msgAlerta("Não foi possível gravar os setores.");
                return false;
            }

            if (response.status != 200) {
                msgAlerta("Não foi possível gravar os setores.");
                return false;
            }

            $("#tabelaFluxo").DataTable().rows(".selected").data().toArray()[0].SETORES_FLUXO = JSON.stringify(listaSetores);
            await montaTabelaSetoresFluxo(JSON.stringify(listaSetores));
            return true;

        } catch (error) {
            console.error(error);
        }

    }

    async function verificaExistePrecoFaccaoSetor(codigoProduto, parte, setores) {
        try {
            const responseExistePrecoFaccaoSetor = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"TABELA",
                "camposSelect":["SUM(PRECO) PRECO, SETOR"], 
                "where": ["CODIGO = '${codigoProduto}'", "PARTE = ${parte}", "SETOR IN (${setores})", "PRECO != 0"], "groupby": ["SETOR"]}`, null);

            if (!responseExistePrecoFaccaoSetor) {
                throw msgAlerta("Não foi possível excluir o setor!");
            }

            if (responseExistePrecoFaccaoSetor.status != 200) {
                throw msgAlerta("Não foi possível excluir o setor!");
            }

            const jsonExistePrecoFaccaoSetor = await responseExistePrecoFaccaoSetor.json();

            if (jsonExistePrecoFaccaoSetor.RESULT[0].length > 0) {
                const setoresPrecoFaccao = jsonExistePrecoFaccaoSetor.RESULT[0].map(dados => ' ' + dados.SETOR).toString();
                msgAlerta("Existe preço de facção para os setores:" + setoresPrecoFaccao);
                return true;
            }

            return false;

        } catch (error) {
            console.error(error);
        }
    }

    function ajustaBotoesAlterarOrdem() {
        if ($("#divBotoesSetorPadrao").hasClass("d-none")) {
            $("#divBotoesSetorPadrao").removeClass("d-none");
            $("#divBotoesSetorOrdem").addClass("d-none");
        } else {
            $("#divBotoesSetorPadrao").addClass("d-none");
            $("#divBotoesSetorOrdem").removeClass("d-none");
        }
    }

    async function carregaImportarFluxoProduto(codigoProduto) {
        $.LoadingOverlay("show");
        try {

            const response = await requisicao('GET', '/sisplan/fluxo/v1/consultafluxo?', `CODIGO=${codigoProduto}`, '', 30000);

            if (!response) {
                msgAlerta(`Não foi possível carregar o fluxo do produto ${codigoProduto}`);
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(`Não foi possível carregar o fluxo do produto ${codigoProduto}`)
                return;
            }

            if (jsonStr.length == 0) {
                limpaDataTable("tabelaFluxoImportarFluxoProduto"); 
                limpaDataTable("tabelaSetoresImportarFluxoProduto"); 
                throw msgAlerta("Nenhum registro encontrado.");
            }

            if ($.fn.DataTable.isDataTable('#tabelaFluxoImportarFluxoProduto')) {
                limpaDataTable("tabelaFluxoImportarFluxoProduto");
                $('#tabelaFluxoImportarFluxoProduto').DataTable().destroy();
                $('#tabelaFluxoImportarFluxoProduto').empty();
            };

            const dataSetCols = [];
            dataSetCols.push({
            'title': 'SEL',
            'data': 'SEL'
            });

            const keys = Object.keys(jsonStr[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            };

            jsonStr.forEach((item, i) => {
            item.SEL = `<div class="icheck-primary d-inline">
                <input type="checkbox" id="checkFluxoImportarFluxo${i}" class="campoSelFluxoImportarFluxo">
                <label for="checkFluxoImportarFluxo${i}"></label>
                </div>`
            });


            for (let i = 0; i < jsonStr.length; i++) {
                jsonStr[i].SETORES_FLUXO = await consultaSetoresFluxo('CONSULTA', jsonStr[i].CODIGO, jsonStr[i].PARTE);
            }

            criaDataTablePadrao('#tabelaFluxoImportarFluxoProduto', false, false, false, false, true, true, false, jsonStr, dataSetCols, [16, 17]);
            $("#tabelaFluxoImportarFluxoProduto").DataTable().order([0, 'asc']).draw(false);

            $('#tabelaFluxoImportarFluxoProduto tbody').unbind('click');
            $('#tabelaFluxoImportarFluxoProduto tbody').on('click', 'tr', async function () {
                if (!bAlteracao && !bInclusao && !bDuplicar) {
                    if ($(this).hasClass('selected')) {
                        $(this).removeClass('selected');
                        limpaCamposFluxo();
                        limpaDataTable("tabelaSetoresImportarFluxoProduto");
                    } else {
                        $('#tabelaFluxoImportarFluxoProduto').DataTable().$('tr.selected').removeClass('selected');
                        $(this).addClass('selected');
                        if ($('#tabelaFluxoImportarFluxoProduto').DataTable().rows().count() == 0) {
                            limpaCamposFluxo();
                            limpaDataTable("tabelaSetoresImportarFluxoProduto");
                        } else {
                            const data = $('#tabelaFluxoImportarFluxoProduto').DataTable().row($(this)).data();
                            await montaTabelaSetoresImportarFluxo(data.SETORES_FLUXO);

                        }
                    }
                }
            });


        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function montaTabelaSetoresImportarFluxo(setoresFluxo) {
        let objSetoresFluxo;

        if (typeof(setoresFluxo) == "string") {
            objSetoresFluxo = JSON.parse(setoresFluxo);
        } else if (typeof(setoresFluxo) == "object") {
            objSetoresFluxo = setoresFluxo;
        }       

        if ($.fn.DataTable.isDataTable('#tabelaSetoresImportarFluxoProduto')) {
            limpaDataTable("tabelaSetoresImportarFluxoProduto");
            $('#tabelaSetoresImportarFluxoProduto').DataTable().destroy();
            $('#tabelaSetoresImportarFluxoProduto').empty();
        };

        if (objSetoresFluxo.length == 0) {
            return;
        }

        const dataSetCols = [];

        const keys = Object.keys(objSetoresFluxo[0]);
        for (var k in keys) {
            dataSetCols.push({
                'title': keys[k],
                'data': keys[k]
            });
        };

        criaDataTablePadrao('#tabelaSetoresImportarFluxoProduto', false, false, false, false, true, true, false, objSetoresFluxo, dataSetCols, []);

    }

    function importarFluxo() {
        const registrosSelecionados = $('#tabelaFluxoImportarFluxoProduto').DataTable().rows($($('input[class=campoSelFluxoImportarFluxo]:checked').closest('tr'))).data().toArray().map(function (objeto) { delete objeto.SEL; return objeto; });

        if (registrosSelecionados.length <= 0) {
            throw msgAlerta("Nenhum registro selecionado para importar, para realizar a importação é necessário selecionar algum registro.");
        }

        registrosSelecionados.forEach(registro => {
            if (validaParteCadastrada(registro.PARTE)) {
                throw msgAlerta(`Parte ${registro.PARTE} já cadastrada, não é possível importar essa parte.`);
            }
        });

        if (!$.fn.DataTable.isDataTable('#tabelaFluxo')) {
            const dataSetCols = [];
            const keys = Object.keys(registrosSelecionados[0]);
            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            };

            criaDataTablePadrao('#tabelaFluxo', false, false, false, false, true, true, false, '', dataSetCols, [15, 16]);

            $('#tabelaFluxo tbody').unbind('click');
            eventoClickTabelaFluxo();

        }

        registrosSelecionados.forEach(registro => {
            registro.CODIGO = "";
            $('#tabelaFluxo').DataTable().row.add(registro).draw(false);
        });
        ajustaOrdemFluxo();
        $("#tabelaFluxo").DataTable().order([0, 'asc']).draw(false);
        $("#modalImportarFluxoProduto").modal("hide");
        bModificacao = true;

    }

    function resetaVariaveisControle() {
        bInclusao = false;
        bAlteracao = false;
        bModificacao = false;
        bAlteracaoOrdem = false;
        bDuplicar = false;
    }

    function eventoClickTabelaFluxo() {
        $('#tabelaFluxo tbody').on('click', 'tr', async function () {
            if (!bAlteracao && !bInclusao && !bDuplicar) {
                if ($(this).hasClass('selected')) {
                    $(this).removeClass('selected');
                    limpaCamposFluxo();
                    limpaDataTable("tabelaSetoresFluxo");
                } else {
                    $('#tabelaFluxo').DataTable().$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                    if ($('#tabelaFluxo').DataTable().rows().count() == 0) {
                        limpaCamposFluxo();
                        limpaDataTable("tabelaSetoresFluxo");
                    } else {
                        const data = $('#tabelaFluxo').DataTable().row($(this)).data();
                        data.PARTE != '' ? $('#txtParteFluxo').val(`[${data.PARTE}] - ${data.DESCRICAO}`) : $("#txtParteFluxo").val("");
                        data.SIMBOLOGIA != "" ? insereValor("#txtSimbologia", data.SIMBOLOGIA, { tabela: 'ETIQUETA', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: data.SIMBOLOGIA }) : $('#txtSimbologia').val("");
                        data.FLUXO != '' ? $('#txtFluxo').val(`[${data.FLUXO}] - ${data.DESC_FLUXO}`) : $("#txtFluxo").val("");
                        data.COMPOSICAO != '' ? $('#txtComposicao').val(`[${data.COMPOSICAO}] - ${data.DESC_COMP}`) : $("#txtComposicao").val("");
                        data.TP_PROD != '' ? $('#txtTpProd').val(`[${data.TP_PROD}] - ${data.DESC_TP_PROD}`) : $("#txtTpProd").val("");
                        $("#txtObservacao").val(data.OBS);
                        $('#txtIndice').val(data.IND_INV);
                        $('#txtOrdemFluxo').val(data.ORDEM);
                        $('#txtMultiplo').val(data.MULTIPLO);

                        await montaTabelaSetoresFluxo(data.SETORES_FLUXO);

                    }
                }
            }
        });
    }

});