$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: '.infFiltros',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o estoque.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta do estoque.',
          position: 'left'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para zerar o estoque dos itens selecionados.',
          position: 'left'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  adicionarPesquisaAutocompleta()

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.zeraEstoqueMaterial == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, zeraEstoqueMaterial: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      const novasColunas = retornaNovasColunasInvisiveis()
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, zeraEstoqueMaterial: novasColunas }))
      $('#tabelaItens').DataTable().columns().visible(true)
      $('#tabelaItens').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false)
          }
        })
    } finally {
      $.LoadingOverlay('hide')
      $('#modal-ColunasVisiveis').modal('hide')
    }
  })

  $('#btnConsultar').on('click', function () {
    carregarDados()
    $('#btnGravar').prop('disabled', false)
  })

  function carregarDados() {
    $.LoadingOverlay('show')
    buscarDados()
      .then(({ itens, quantidadeTotal }) => {
        criarTabelaItens(itens ?? [])
        $('#txtQuantidade').val(
          parseFloat(quantidadeTotal ?? 0).toLocaleString("pt-br", {
            maximumFractionDigits: 6,
            minimumFractionDigits: 6,
          })
        )
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao buscar os dados.')
      }).finally(() => $.LoadingOverlay('hide'))
  }

  async function buscarDados() {
    const filtros = await retornarFiltros()
    const response = await requisicao("POST", '/sisplan/zeraestoquematerial/v1/buscardados?', '', JSON.stringify(filtros), 3600000)

    const data = await response.json()

    if (data) {
      const { resultado, mensagem } = data
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      if (resultado) {
        return resultado
      }
    }

    return []
  }

  function criarTabelaItens(data) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    const columns = [
      {
        data: 'sel',
        title: 'Sel',
        render: function (value, _1, _2, { row }) {
          return `<div class="icheck-primary" style="max-width: 20px">
            <input type="checkbox" ${!!value && 'checked'} id="cbSel_${row}" class="cbSel">
            <label for="cbSel_${row}"></label>
          </div>`
        }
      },
      {
        data: 'idMatIten',
        title: 'Id',
      },
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
      {
        data: 'cor',
        title: 'Cor',
      },
      {
        data: 'descricaoCor',
        title: 'Descrição Cor',
      },
      {
        data: 'deposito',
        title: 'Depósito',
      },
      {
        data: 'descricaoDeposito',
        title: 'Descrição Depósito',
      },
      {
        data: 'lote',
        title: 'Lote',
      },
      {
        data: 'local',
        title: 'Local',
      },
      {
        data: 'qualidade',
        title: 'Qualidade',
      },
      {
        data: 'quantidade',
        title: 'Quantidade',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 6,
              minimumFractionDigits: 6,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 6,
            minimumFractionDigits: 6,
          })
        },
        className: 'text-right',
      },
      {
        data: 'quantidadeReservada',
        title: 'Quantidade Reservada',
      },
      {
        data: 'grupo',
        title: 'Grupo',
      },
      {
        data: 'subgrupo',
        title: 'Subgrupo',
      },
      {
        data: 'precoMedio',
        title: 'Preço Médio',
        render: function (data) {
          if (!data) {
            return parseFloat(0).toLocaleString("pt-br", {
              maximumFractionDigits: 8,
              minimumFractionDigits: 8,
            })
          }
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 8,
            minimumFractionDigits: 8,
          })
        },
        className: 'text-right',
      },
      {
        data: 'dataValidade',
        title: 'Validade',
        render: function (data) {
          if (data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split("T")[0]} 23:59:59`)
            )
          }
        },
      },
      {
        data: 'dataFabricacao',
        title: 'Fabricação',
        render: function (data) {
          if (data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split("T")[0]} 23:59:59`)
            )
          }
        },
      },
    ]

    $('#tabelaItens').DataTable({
      bPaginate: true,
      destroy: true,
      colReorder: true,
      scrollX: true,
      autoWidth: true,
      columns,
      data,
    })
    adicionarEventoCheckboxDatatable()
    $('#cbSelAll').prop('checked', true).trigger('change')
    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaItens_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>')
    $('#tabelaItens_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>')

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show')
      $('#modal-ColunasVisiveis').modal('show')
      $.LoadingOverlay('hide')
    })

    $('#buttonExcel').on('click', async function () {
      const url = `/sisplan/zeraestoquematerial/v1/buscardados?`
      const filtros = await retornarFiltros()
      const dados = $('#tabelaItens')
                      .DataTable()
                      .data()
                      .toArray()
                      .map((item) => (
                        {
                          ...item,
                          dataFabricacao: item?.dataFabricacao?.substring(0, 10) ?? '',
                          dataValidade: item?.dataValidade?.substring(0, 10) ?? '',
                        }
                      ))
      $.LoadingOverlay('show')
      exportaCSV(url, filtros, false, null, 'Zera Estoque Material', '#tabelaItens', '', 999, false, false, dados)
        .finally(() => $.LoadingOverlay('hide'))
    })

    $('#tabelaItens').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.zeraEstoqueMaterial).indexOf(this.dataSrc()) != -1) {
          this.visible(false)
        }
      }
    )
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = []
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    $('#tabelaItens').DataTable().columns().every(function () {
      if ($(this.header()).text() !== 'Sel') {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      }
    })

    adicionaColunas(cols, colunasInvisiveis.zeraEstoqueMaterial ?? [])
  })

  function adicionarEventoCheckboxDatatable() {
    $('#tabelaItens tbody').on('change', '.cbSel', function () {
      const row = $(this).closest('tr')
      const isChecked = $(this).prop('checked')
      row.toggleClass('selected', isChecked)
    })

    $('#cbSelAll').off('change')
    $('#cbSelAll').on('change', function () {
      const isChecked = this.checked
      const table = $('#tabelaItens').DataTable()
      table.rows().every(function () {
        const row = $(this.node())
        row.toggleClass('selected', isChecked)
        const checkbox = row.find('.cbSel')
        checkbox.prop('checked', isChecked)
      })
    })
  }

  $('#btnGravar').on('click', function () {
    msgAlerta(
      'Deseja gravar os dados?',
      () => { },
      () => { },
      () => {
        const dadosGravar = retornarDadosGravar()
        const { itens } = dadosGravar

        if (itens.find((item) => item.quantidadeReservada > 0)) {
          msgErro(
            'Existem itens com reserva, estes não serão alterados.',
            () => {
              const novosItens = dadosGravar?.itens?.filter((item) => item.quantidadeReservada === 0) ?? []
              const novosDados = { ...dadosGravar, itens: novosItens }
              if (validarDadosGravar(novosDados)) zerarEstoque(novosDados)
            }
          )
          return
        }

        if (validarDadosGravar(dadosGravar)) zerarEstoque(dadosGravar)
      }
    )
  })

  function retornarDadosGravar() {
    const itens = $('#tabelaItens').DataTable().rows('.selected').data().toArray()
    const tipoBaixa = pegaChave('#txtTipoMov')

    return {
      itens,
      tipoBaixa,
    }
  }

  function validarDadosGravar({ itens, tipoBaixa }) {
    if (!tipoBaixa) {
      msgErro('Tipo de baixa não informado, impossível continuar.',)
      return false
    }

    if (!itens || itens.length === 0) {
      msgErro('Nenhum item sem quantidade reservada selecionado, impossível continuar.')
      return false
    }

    return true
  }

  function zerarEstoque(dados) {
    $.LoadingOverlay('show')
    gravar(dados)
      .then(() => {
        $('#btnConsultar').trigger('click')
        $('#cbSelAll').prop('checked', false)
        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      })
      .catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao gravar os dados.')
      })
      .finally(() => $.LoadingOverlay('hide'))
  }

  async function gravar(dados) {
    const response = await requisicao("POST", '/sisplan/zeraestoquematerial/v1/gravar?', '', JSON.stringify(dados), 3600000)

    const data = await response.json()

    if (data) {
      const { resultado, mensagem } = data
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      if (resultado) {
        return resultado
      }
    }

    return []
  }

  async function retornarFiltros() {
    const depositos = await formataListas($('#txtDeposito').val().toString())
    const qualidades = await formataListas($('#txtQualidade').val().toString())
    const materiais = await formataListas($('#txtMaterial').val().toString())
    const colecoes = await formataListas($('#txtColecao').val().toString())
    const linhas = await formataListas($('#txtLinha').val().toString())
    const cores = await formataListas($('#txtCor').val().toString())
    const lote = $('#txtLote').val()
    const grupos = await formataListas($('#txtGrupo').val().toString())
    const subgrupos = await formataListas($('#txtSubgrupo').val().toString())
    const estoqueNegativo = $('#cbEstoqueNegativo').prop('checked')

    return {
      depositos,
      qualidades,
      materiais,
      colecoes,
      linhas,
      cores,
      lote,
      grupos,
      subgrupos,
      estoqueNegativo,
    }
  }

  function adicionarPesquisaAutocompleta() {
    componenteFiltro('depositoUsuario', true, true, 'Deposito')
    componenteFiltro('qualidade', true)
    componenteFiltro('material', true)
    componenteFiltro('colecao', true)
    componenteFiltro('linha', true)
    componenteFiltro('cor', true)
    componenteFiltro('grupoMA', true, true, 'Grupo')
    componenteFiltro('subGrupo', true, true, 'Subgrupo')
    componenteFiltro('tipoMov', false, false)
  }
})