$(document).ready(async function () {

  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };

  preCorTam = await CopiaParametro('VENDA', 5);
  const utilizaMaterial = (await CopiaParametro("VENDA", 17)) == 1;

  if (preCorTam == '1') {
    $('#divPrazo').addClass('d-none');
  }

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relVendaXCusto == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVendaXCusto: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVendaXCusto: novasColunas }))

      $('#tabelaVendaXCusto').DataTable().columns().visible(true);

      // $('#tabelaVendaXCusto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaVendaXCusto').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltrosRel',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  let modalAberto = false;

  $('#btnFiltrosRel').on('click', async function () {
    if (!modalAberto) {
      $('[role="combobox"]').trigger('click');
      modalAberto = true;
    }

    setTimeout(function () {
      $('.modal-body').trigger('click');
      $('#modal-filtros').modal('show');
    }, 100);
  });

  $('#btnConsultar').on('click', async function () {
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $('#txtOrdem option').toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    if ($.fn.DataTable.isDataTable('#tabelaVendaXCusto')) {
      $("#tabelaVendaXCusto").DataTable().destroy();
      $("#tabelaVendaXCusto").empty();
    }
    await buscaDados();
    $('#modal-filtros').modal('hide');
  });

  // async function adicionaOrdem() {
  //   const dadosSelect = {
  //     tabela: `${"ORDEM_TELA"}`,
  //     camposSelect: [`${"NOME_ORD_TELA"}`, `${"NOME_PRT"}`],
  //     where: [`${"NOME_TELA"} = 'RelVendaxCusto'`],
  //   };

  //   const retornoSelect = await retornaJsonPesquisaPadrao(
  //     JSON.stringify(dadosSelect)
  //   );
  //   if (!retornoSelect) {
  //     return;
  //   }

  //   let index = 0;
  //   retornoSelect.forEach(function (item) {
  //     $("#txtOrdem").append(
  //       `<option value= ${index} nome_prt = ${item.NOME_PRT}>${item.NOME_ORD_TELA}</option>`
  //     );
  //     index++;
  //   });
  // };

  // await adicionaOrdem();
  preencheOrdenacaoTela('RelVendaxCusto');

  function escondeCamposProduto() {
    $('#divProduto').addClass('d-none');
    $('#divMaterial').removeClass('d-none');
    $('#divModelo').addClass('d-none');
    $('#divGrupoPA').addClass('d-none');
    $('#divGrupoMA').removeClass('d-none');
    $('#divSubGrupo').removeClass('d-none');
    $('#divEtiqueta').addClass('d-none');
    $('#divLinha').addClass('d-none');
    $('#divMatLinha').removeClass('d-none');
    $('#divMarca').addClass('d-none');
    $('#divColecao').addClass('d-none');
    criaPesquisa();
  }

  function mostraCamposProduto() {
    $('#divProduto').removeClass('d-none');
    $('#divMaterial').addClass('d-none');
    $('#divModelo').removeClass('d-none');
    $('#divGrupoPA').removeClass('d-none');
    $('#divGrupoMA').addClass('d-none');
    $('#divSubGrupo').addClass('d-none');
    $('#divEtiqueta').removeClass('d-none');
    $('#divLinha').removeClass('d-none');
    $('#divMatLinha').addClass('d-none');
    $('#divMarca').removeClass('d-none');
    $('#divColecao').removeClass('d-none');
    criaPesquisa();
  }

  async function criaPesquisa() {
    componenteFiltro('venda', true);
    componenteFiltro('cliente', true);
    componenteFiltro('tabPreco', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('produto', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('marca', true);
    componenteFiltro('linha', true);
    componenteFiltro('colecao', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('modelo', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('matLinha', true);
    componenteFiltro('material', true);
    componenteFiltro('subGrupo', true);
    componenteFiltro('tipoVenda', true);
  }

  $('#btnLimpaFiltros').on('click', async function () {
    limpaFiltros();
  });

  $('#radioProduto').on('change', function () {
    limpaFiltros(true);
    mostraCamposProduto();
  });

  $('#radioMaterial').on('change', function () {
    limparFiltros(true);
    escondeCamposProduto();
  });

  if (utilizaMaterial) {
    $('#radioMaterial').prop('checked', true);
    limparFiltros(true);
    escondeCamposProduto();
  } else {
    $('#radioProduto').prop('checked', true);
    limparFiltros(true);
    mostraCamposProduto();
  }

  function limpaFiltros(changeIten = false) {
    $('#rdTodas').prop('checked', true);

    $('#txtDataDe').val('1200-01-01');
    $('#txtDataAte').val('2500-12-31');

    $('#txtVenda').empty().trigger('change');
    $('#txtCliente').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#selectPrazo').val('00');
    $('#txtVendedor').empty().trigger('change');
    $('#txtProduto').empty().trigger('change');
    $('#txtGrupoPA').empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtEtiqueta').empty().trigger('change');
    $('#txtSubGrupo').empty().trigger('change');
    $('#txtMatLinha').empty().trigger('change');
    $('#txtGrupoMA').empty().trigger('change');
    $('#txtMaterial').empty().trigger('change');
    $('#txtTipoVenda').empty().trigger('change');

    if (!changeIten) {
      if (utilizaMaterial) {
        $('#radioMaterial').prop('checked', true);
      } else {
        $('#radioProduto').prop('checked', true);
      }
    }
  }

  retornaHintRelatorio('btnImprimir', 'RelVendaxCustoPadrao')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const filtros = await retornaFiltros();
        let url = `/sisplan/impressao/v1/relvendaxcusto?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
        const ordem = `&TELA_ORDENACAO=RelVendaXCusto&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelVendaXCusto');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, "GET", 100000, false, 'relvendaxcusto');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function buscaDados(colunaOrdenacao = '') {

    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    const sTipo = $($("[name='tipo']").toArray().filter(radio => radio.checked == true)).parent().text().substring(2);
    const where = await montaWherePesquisa(sTipo);
    const leftJoin = await montaLeftJoinPesquisa();
    const campos = await montaCamposSelect();

    let dataSetCols = [];

    const orderBy = colunaOrdenacao == '' ? '1' : colunaOrdenacao;
    try {
      try {
        $.LoadingOverlay("show");

        for (let i = 0; i < campos.colunas.length; i++) {
          dataSetCols.push({
            'title': campos.colunas[i],
            'data': campos.colunas[i]
          });
        }

        const pesquisa = {
          tabela: 'VENDA',
          camposSelect: campos.camposSelect,
          leftJoin: leftJoin,
          where: [`1=1 ${where}`],
          orderby: [orderBy]
        }

        if ($.fn.DataTable.isDataTable('#tabelaVendaXCusto')) {
          $('#tabelaVendaXCusto').DataTable().destroy();
          $('#tabelaVendaXCusto').empty();
        };

        $('#tabelaVendaXCusto').DataTable({
          paging: true,
          lengthChange: true,
          filter: false,
          info: true,
          order: false,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          colReorder: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            dataSrc: '',
            type: "POST",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: {
              EMPRESA: getCookie('empresa'),
              JSON: JSON.stringify(pesquisa),
            },
            dataSrc: function (data) {
              const cols = campos.colunas;
              const array = data.data;
              return array.map(row => {
                return row.reduce((obj, value, index) => {
                  obj[cols[index]] = value;
                  return obj;
                }, {});
              });
            }
          },
          columns: dataSetCols,
          columnDefs: [
            {
              render: function (data) {
                if (data == '') {
                  data = '0';
                }
                return parseFloat(data).toLocaleString("pt-br", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2,
                });
              },
              targets: utilizaMaterial ? [12, 13, 14, 15, 16, 29] : [12, 13, 14, 15, 16, 31, 32, 33],
              "className": 'pr-4 text-right'
            },
            {
              render: function (data) {
                if (data == '') {
                  data = '0';
                }
                return data.toLocaleString("pt-br", {
                  maximumFractionDigits: 4,
                  minimumFractionDigits: 4,
                });
              },
              targets: utilizaMaterial ? [26] : [29],
              "className": 'pr-4 text-right'
            },
            {
              targets: [11],
              "className": 'pr-4 text-right'
            },
            {
              targets: [dataSetCols.length - 1],
              visible: false,
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaVendaXCusto_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaVendaXCusto_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/Sisplan/Funcoes/v1/pesquisa?';
          const where = await montaWherePesquisa(sTipo);
          const leftJoin = await montaLeftJoinPesquisa();
          const campos = await montaCamposSelect();
          const pesquisa = {
            tabela: 'VENDA',
            camposSelect: campos.camposSelect,
            leftJoin: leftJoin,
            where: [`1=1 ${where}`],
            orderby: [orderBy]
          }
          await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`, true, null, 'Relatório de Venda X Custo', '#tabelaVendaXCusto');
        })


        $('#tabelaVendaXCusto').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relVendaXCusto).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })


        $('#tabelaVendaXCusto th').unbind('click');
        $('#tabelaVendaXCusto th').on('click', async function () {
          const nomeColuna = $(this).html();
          const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
          const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
          await buscaDados(nomeColuna + ' ' + ordenacao);
        });
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }

  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaVendaXCusto').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relVendaXCusto ?? [])
  })

  $('#btnCarregaEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {
    const emp = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const dataDe = $('#txtDataDe').val().replace();
    const dataAte = $('#txtDataAte').val().replace();
    const venda = await formataListas($('#txtVenda').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    let tabela = await formataListas($('#txtTabPreco').val().toString());
    // if (tabela == '') {
    //   tabela = `''`;
    // }
    const selPrazos = $('#selectPrazo').val();
    const vendedor = await formataListas($('#txtVendedor').val().toString());
    const produto = await formataListas($('#txtProduto').val().toString());
    const grupoProduto = await formataListas($('#txtGrupoPA').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const grupoMaterial = await formataListas($('#txtGrupoMA').val().toString());
    const subGrupoMaterial = await formataListas($('#txtSubGrupo').val().toString());
    const linhaMat = await formataListas($('#txtMatLinha').val().toString());
    const material = await formataListas($('#txtMaterial').val().toString());
    const tipoProd = $('#radioProduto').is(':checked') ? 'P' : 'M';
    const emitido = $('#cbEmitido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const agrupado = $('#cbAgrupado').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const cancelado = $('#cbCancelado').prop('checked');
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());

    const params =
      `EMPRESASFILTRADAS=${emp}&` +
      `DATADE=${dataDe}&` +
      `DATAATE=${dataAte}&` +
      `VENDA=${venda}&` +
      `CLIENTE=${cliente}&` +
      `TABELA=${tabela}&` +
      `SELECTPRAZO=${selPrazos}&` +
      `VENDEDOR=${vendedor}&` +
      `PRODUTO=${produto}&` +
      `GRUPOPRODUTO=${grupoProduto}&` +
      `MARCA=${marca}&` +
      `LINHA=${linha}&` +
      `COLECAO=${colecao}&` +
      `ETIQUETA=${etiqueta}&` +
      `MODELO=${modelo}&` +
      `USAPRECOCORTAM=${preCorTam == '1' ? 'S' : 'N'}&` +
      `EMITIDO=${emitido}&` +
      `PENDENTE=${pendente}&` +
      `AGRUPADO=${agrupado}&` +
      `DEVOLVIDO=${devolvido}&` +
      `CANCELADO=${cancelado}&` +
      `GRUPOMATERIAL=${grupoMaterial}&` +
      `SUBGRUPOMATERIAL=${subGrupoMaterial}&` +
      `LINHAMATERIAL=${linhaMat}&` +
      `MATERIAL=${material}&` +
      `TIPOPRODUTO=${tipoProd}&` +
      `TIPO_VENDA=${tipovenda}`;
    return params;
  }

  async function montaWherePesquisa() {
    const dataDe = $('#txtDataDe').val().replace();
    const dataAte = $('#txtDataAte').val().replace();
    const venda = await formataListas($('#txtVenda').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const vendedor = await formataListas($('#txtVendedor').val().toString());
    const produto = await formataListas($('#txtProduto').val().toString());
    const grupoProduto = await formataListas($('#txtGrupoPA').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const tabela = await formataListas($('#txtTabPreco').val().toString());
    const grupoMaterial = await formataListas($('#txtGrupoMA').val().toString());
    const subGrupoMaterial = await formataListas($('#txtSubGrupo').val().toString());
    const linhaMat = await formataListas($('#txtMatLinha').val().toString());
    const material = await formataListas($('#txtMaterial').val().toString());
    const tipoProd = $('#radioProduto').is(':checked') ? 'P' : 'M';
    const emitido = $('#cbEmitido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const agrupado = $('#cbAgrupado').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const cancelado = $('#cbCancelado').prop('checked');
    const emp = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());

    let where = '';
    let sFiltro = 'AND (';

    if (emp != '') {
      where += ` AND VENDA.EMP_ID IN (${emp})`;
    }

    if (tipoProd == 'M') {
      where += $('#txtDataDe').val() != '' ? ` AND (VENDA.DATA >= '${dataDe}')` : '';
      where += $('#txtDataAte').val() != '' ? ` AND (VENDA.DATA <= '${dataAte}')` : '';
      where += $('#txtVenda').val() != '' ? ` AND VENDA.CODVEN IN (${venda})` : '';
      where += $('#txtCliente').val() != '' ? ` AND VENDA.CODCLI IN (${cliente})` : '';
      where += $('#txtVendedor').val() != '' ? ` AND VENDA.CODREP IN (${vendedor})` : '';
      where += $('#txtTabPreco').val() != '' ? ` AND VENDA.TABELA IN (${tabela})` : '';
      where += $('#txtMaterial').val() != '' ? ` AND MATERIAL.CODIGO IN (${material})` : '';
      where += $('#txtGrupoMA').val() != '' ? ` AND MATERIAL.GRUPO IN (${grupoMaterial})` : '';
      where += $('#txtSubGrupo').val() != '' ? ` AND MATERIAL.SUBGRUPO IN (${subGrupoMaterial})` : '';
      where += $('#txtMatLinha').val() != '' ? ` AND MATERIAL.LINHA IN (${linhaMat})` : '';
      where += $('#txtTipoVenda').val() != '' ? ` AND VENDA.TIPO_VENDA IN (${tipovenda})` : '';
      where += ` AND ITVENDA.TIPO = 'M'`;
    } else {
      where += $('#txtDataDe').val() != '' ? ` AND (VENDA.DATA >= '${dataDe}')` : '';
      where += $('#txtDataAte').val() != '' ? ` AND (VENDA.DATA <= '${dataAte}')` : '';
      where += $('#txtVenda').val() != '' ? ` AND VENDA.CODVEN IN (${venda})` : '';
      where += $('#txtProduto').val() != '' ? ` AND PRODUTO.CODIGO IN (${produto})` : '';
      where += $('#txtCliente').val() != '' ? ` AND VENDA.CODCLI IN (${cliente})` : '';
      where += $('#txtVendedor').val() != '' ? ` AND VENDA.CODREP IN (${vendedor})` : '';
      where += $('#txtGrupoPA').val() != '' ? ` AND PRODUTO.GRUPO IN (${grupoProduto})` : '';
      where += $('#txtMarca').val() != '' ? ` AND PRODUTO.MARCA IN (${marca})` : '';
      where += $('#txtEtiqueta').val() != '' ? ` AND PRODUTO.ETIQUETA IN (${etiqueta})` : '';
      where += $('#txtLinha').val() != '' ? ` AND PRODUTO.LINHA IN (${linha})` : '';
      where += $('#txtColecao').val() != '' ? ` AND PRODUTO.COLECAO IN (${colecao})` : '';
      where += $('#txtModelo').val() != '' ? ` AND PRODUTO.MODELO IN (${modelo})` : '';
      where += $('#txtTabPreco').val() != '' ? ` AND VENDA.TABELA IN (${tabela})` : '';
      where += $('#txtTipoVenda').val() != '' ? ` AND VENDA.TIPO_VENDA IN (${tipovenda})` : '';
      where += ` AND ITVENDA.TIPO = 'P'`;
    }

    if (emitido) {
      if (agrupado) {
        sFiltro += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1))`;
      } else {
        sFiltro += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) = 0))`;
      }
    }

    if (devolvido) {
      if (sFiltro != 'AND (') {
        sFiltro += ' OR ';
      }

      sFiltro += '(VENDA.CANCELADA = 0 ' +
        'AND VENDA.FECHADA = 0 ' +
        'AND (((VENDA.TROCA = 1) ' +
        'OR (VENDA.DEVOLUCAO = 1)) ' +
        'AND VENDA.ORCAMENTO = 0))';
    }

    if (pendente) {
      if (sFiltro != 'AND (') {
        sFiltro += ' OR ';
      }

      sFiltro += '(VENDA.CANCELADA = 0 ' +
        'AND VENDA.FECHADA = 0 ' +
        'AND VENDA.TROCA = 0 ' +
        'AND VENDA.DEVOLUCAO = 0 ' +
        'AND VENDA.ORCAMENTO = 0)';
    }

    if (cancelado) {
      if (sFiltro != 'AND (') {
        sFiltro += ' OR ';
      }

      sFiltro += '((VENDA.CANCELADA = 1) ' +
        "AND (VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S') " +
        'OR (((VENDA.CANCELADA = 1) ' +
        "AND (VENDA.CONSIG_FINALIZADO = 'S') " +
        'AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)))';
    }

    if (agrupado) {
      if (sFiltro != 'AND (') {
        sFiltro += ' OR ';
      }

      if (!cancelado) {
        sFiltro += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0 AND ((SELECT CANCELADA FROM [VENDA] WHERE CODVEN = VENDA.CDAGRUPADA) = 0))`
      } else {
        sFiltro += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)`;
      }
    }

    sFiltro += ')';

    const todos = (emitido && devolvido && cancelado && pendente && agrupado) || (!emitido && !devolvido && !cancelado && !pendente && !agrupado);

    if (!todos && !agrupado) {
      sFiltro += ` AND ((VENDA.AGRUPADA IS NULL OR VENDA.AGRUPADA = '' OR VENDA.AGRUPADA = 'N') OR (VENDA.TIPO_VENDA = 2))`;
    }

    if (sFiltro != 'AND ()') {
      where += sFiltro;
    }

    return where;
  }

  async function montaLeftJoinPesquisa() {

    const tabela = ($('#txtTabPreco').val().toString() !== '') ? await formataListas($('#txtTabPreco').val().toString()) : `''`;

    let ligacaoPreco;
    let campoConsulta;

    if (preCorTam == '1') {
      ligacaoPreco = {
        "tabela": "PRECO_COR_TAM",
        "alias": "PRECO_COR_TAM",
        "condicao": `ITVENDA.CODIGO = PRECO_COR_TAM.CODIGO AND ITVENDA.COR = PRECO_COR_TAM.COR AND ITVENDA.TAM = PRECO_COR_TAM.TAM AND PRECO_COR_TAM.REGIAO = VENDA.TABELA`
      }
    } else {
      ligacaoPreco = {
        "tabela": "TABPRECO",
        "alias": "PRECO",
        "condicao": `ITVENDA.CODIGO = PRECO.CODIGO AND PRECO.REGIAO = VENDA.TABELA`
      }
    }

    let ligacaoGrupo;
    let ligacaoColecao;
    let ligacaoLinha;
    let ligacaoMatPreco;

    if (utilizaMaterial) {
      ligacaoGrupo = { "tabela": "GRUPO_MA", "condicao": "MATERIAL.GRUPO = GRUPO_MA.CODIGO" };
      ligacaoLinha = { "tabela": "MAT_LINHA", "condicao": "MATERIAL.LINHA = MAT_LINHA.CODIGO" };
      ligacaoColecao = { "tabela": "COLECAO", "condicao": "COLECAO.CODIGO = MATERIAL.COLECAO" };
      ligacaoMatPreco = { "tabela": "MAT_PRECO", "condicao": "MAT_PRECO.CODIGO = MATERIAL.CODIGO" };
    } else {
      ligacaoGrupo = { "tabela": "GRUPO_PA", "alias": "GRUPO", "condicao": "GRUPO.CODIGO  = PRODUTO.GRUPO" };
      ligacaoColecao = { "tabela": "COLECAO", "condicao": "COLECAO.CODIGO = PRODUTO.COLECAO" };
      ligacaoLinha = { "tabela": "TABLIN", "alias": "LINHA", "condicao": "LINHA.CODIGO   = PRODUTO.LINHA" };
    }

    const ligacao = [{ "tabela": "REPRESEN", "condicao": "VENDA.CODREP = REPRESEN.CODREP" },
    { "tabela": "ITVENDA", "condicao": "VENDA.CODVEN = ITVENDA.CODVEN AND VENDA.EMP_ID = ITVENDA.EMP_ID" },
      ligacaoPreco,
    { "tabela": "ENTIDADE", "alias": "CLIENTE", "condicao": "VENDA.CODCLI   = CLIENTE.CODCLI" },
    { "tabela": "CADCOR", "alias": "COR", "condicao": "COR.COR = ITVENDA.COR" },
    { "tabela": "PRODUTO", "condicao": "ITVENDA.CODIGO = PRODUTO.CODIGO" },
    { "tabela": "MATERIAL", "condicao": "ITVENDA.CODIGO = MATERIAL.CODIGO" },
    { "tabela": "ETQ_PROD", "alias": "ETIQUETA", "condicao": "ETIQUETA.CODIGO= PRODUTO.ETIQUETA" },
    { "tabela": "MARCA", "condicao": "MARCA.CODIGO = PRODUTO.MARCA" },
    { "tabela": "SUBGRUPO_MA", "condicao": "MATERIAL.SUB_GRUPO = SUBGRUPO_MA.CODIGO" }]

    if (utilizaMaterial) {
      ligacao.push(ligacaoGrupo);
      ligacao.push(ligacaoLinha);
      ligacao.push(ligacaoColecao);
      ligacao.push(ligacaoMatPreco);
    } else {
      ligacao.push(ligacaoGrupo);
      ligacao.push(ligacaoColecao);
      ligacao.push(ligacaoLinha);
    };

    return ligacao;
  }

  async function montaCamposSelect() {

    const selPrazos = $('#selectPrazo').val();

    let campoConsulta;
    let tabela;

    if (preCorTam == '1') {
      campoConsulta = 'PRECO_COR_TAM.PRECO';
      tabela = 'PRECO_COR_TAM';
    } else {
      campoConsulta = `PRECO.PRECO_${selPrazos}`;
      tabela = 'PRECO';
    }

    let camposSelect;
    let colunas;

    if (utilizaMaterial) {
      camposSelect = ["VENDA.CODVEN", "VENDA.CODCLI", "CLIENTE.NOME", "VENDA.DATA DATA_VENDA",
        "VENDA.CODREP", "REPRESEN.NOME AS VENDEDOR", "ITVENDA.CODIGO", "MATERIAL.DESCRICAO DESC_MATERIAL",
        "ITVENDA.COR", "COR.DESCRICAO", "ITVENDA.TAM", "ITVENDA.QUANTIDADE", "ITVENDA.VALOR PRECO_VENDA", "ITVENDA.VALOR_DESC", "ITVENDA.TOTAL_LIQ", "VENDA.VALOR TOTAL",
        "MATERIAL.GRUPO", "GRUPO_MA.DESCRICAO DESC_GRUPO", "MATERIAL.SUB_GRUPO", "SUBGRUPO_MA.DESCRICAO DESC_SUB_GRUPO", "MATERIAL.LINHA", "MAT_LINHA.LINHA DESC_LINHA", "MATERIAL.COLECAO", "COLECAO.DESCRICAO DESC_COLECAO", "ITVENDA.TROCA",
        "ITVENDA.CANCELADO", `${await retornarSqlCampoCusto()} CUSTO`, `${tabela}.REGIAO`, `${campoConsulta} PRECO`, `(ITVENDA.QUANTIDADE * ${campoConsulta}) VALOR`, "CLIENTE.FANTASIA", "VENDA.HR_VENDA"];

      colunas = ["CODVEN", "CODCLI", "NOME", "DATA_VENDA", "CODREP", "VENDEDOR", "CODIGO", "DESC_MATERIAL", "COR", "DESCRICAO", "TAM", "QUANTIDADE", "PRECO_VENDA", "VALOR_DESC", "TOTAL_LIQ", "TOTAL", "GRUPO", "DESC_GRUPO", "SUB_GRUPO", "DESC_SUB_GRUPO", "LINHA", "DESC_LINHA", "COLECAO", "DESC_COLECAO", "TROCA", "CANCELADO", "CUSTO", "TABELA", "PRECO", "VALOR", "FANTASIA", "HR_VENDA"];
    } else {
      camposSelect = ["VENDA.CODVEN", "VENDA.CODCLI", "CLIENTE.NOME", "VENDA.DATA DATA_VENDA", "VENDA.CODREP", "REPRESEN.NOME AS VENDEDOR", "ITVENDA.CODIGO",
        "(CASE WHEN PRODUTO.DESCRICAO IS NULL THEN MATERIAL.DESCRICAO ELSE PRODUTO.DESCRICAO END) DESC_PROD", "ITVENDA.COR", "COR.DESCRICAO", "ITVENDA.TAM", "ITVENDA.QUANTIDADE", "ITVENDA.VALOR PRECO_VENDA", "ITVENDA.VALOR_DESC",
        "ITVENDA.TOTAL_LIQ", "(CASE WHEN PRODUTO.CUSTO IS NULL THEN 0 ELSE PRODUTO.CUSTO END) CUSTO_PROD", "VENDA.VALOR TOTAL", "(CASE WHEN PRODUTO.GRUPO IS NULL THEN MATERIAL.GRUPO ELSE PRODUTO.GRUPO END) GRUPO",
        "GRUPO.DESCRICAO DESC_GRUPO", "(CASE WHEN PRODUTO.MARCA IS NULL THEN '' ELSE PRODUTO.MARCA END) MARCA", "MARCA.DESCRICAO DESC_MARCA", "PRODUTO.ETIQUETA", "ETIQUETA.DESCRICAO DESC_ETIQUETA", "PRODUTO.LINHA", "LINHA.DESCRICAO DESC_LINHA",
        "PRODUTO.COLECAO", "COLECAO.DESCRICAO DESC_COLECAO", "ITVENDA.TROCA", "ITVENDA.CANCELADO", `(CASE WHEN PRODUTO.PRECO_COM IS NULL THEN ${await retornarSqlCampoCusto()} ELSE PRODUTO.PRECO_COM END) CUSTO`, `${tabela}.REGIAO`, `${campoConsulta} PRECO`,
        `(ITVENDA.QUANTIDADE * ${campoConsulta}) VALOR`, "VENDA.VALOR TOTAL", "CLIENTE.FANTASIA", "VENDA.HR_VENDA"];

      colunas = ["CODVEN", "CODCLI", "NOME", "DATA_VENDA", "CODREP", "VENDEDOR", "CODIGO", "DESC_PROD", "COR", "DESCRICAO", "TAM", "QUANTIDADE", "PRECO_VENDA", "VALOR_DESC", "TOTAL_LIQ", "CUSTO_PROD", "TOTAL", "GRUPO", "DESC_GRUPO", "MARCA",
        "DESC_MARCA", "ETIQUETA", "DESC_ETIQUETA", "LINHA", "DESC_LINHA", "COLECAO", "DESC_COLECAO", "TROCA", "CANCELADO", "CUSTO", "TABELA", "PRECO", "VALOR", "TOTAL", "FANTASIA", "HR_VENDA"];
    }



    return objeto = {
      camposSelect: camposSelect,
      colunas: colunas
    };
  }

  const retornarSqlCampoCusto = async () => {
    const tipoBanco = await retornaDatabase()
    switch (tipoBanco) {
      case 'FIREBIRD':
        return '(SELECT' +
          ' FIRST 1 MAT_MOV.PRECO' +
          ' FROM' +
          ' [MAT_MOV] MAT_MOV' +
          ' WHERE' +
          ' MAT_MOV.HR_MOVTO IS NOT NULL' +
          ' AND MAT_MOV.HR_MOVTO < VENDA.HR_VENDA' +
          ' AND MAT_MOV.CODIGO = ITVENDA.CODIGO' +
          ' AND MAT_MOV.COR = ITVENDA.COR' +
          ' AND MAT_MOV.DEPOSITO = ITVENDA.DEPOSITO' +
          ' AND MAT_MOV.LOTE = ITVENDA.LOTE' +
          ' AND MAT_MOV.QUALIDADE = ITVENDA.QUALIDADE' +
          ' ORDER BY' +
          ' MAT_MOV.HR_MOVTO DESC)'
      case 'SQLSERVER':
        return '(SELECT' +
          ' TOP 1 MAT_MOV.PRECO' +
          ' FROM' +
          ' [MAT_MOV] MAT_MOV' +
          ' WHERE' +
          ' MAT_MOV.HR_MOVTO IS NOT NULL' +
          ' AND MAT_MOV.HR_MOVTO < VENDA.HR_VENDA' +
          ' AND MAT_MOV.CODIGO = ITVENDA.CODIGO' +
          ' AND MAT_MOV.COR = ITVENDA.COR' +
          ' AND MAT_MOV.DEPOSITO = ITVENDA.DEPOSITO' +
          ' AND MAT_MOV.LOTE = ITVENDA.LOTE' +
          ' AND MAT_MOV.QUALIDADE = ITVENDA.QUALIDADE' +
          ' ORDER BY' +
          ' MAT_MOV.HR_MOVTO DESC)'
      case 'ORACLE':
        return '(SELECT' +
          ' MAT_MOV.PRECO' +
          ' FROM' +
          ' [MAT_MOV] MAT_MOV' +
          ' WHERE' +
          ' MAT_MOV.HR_MOVTO IS NOT NULL' +
          ' AND MAT_MOV.HR_MOVTO < VENDA.HR_VENDA' +
          ' AND MAT_MOV.CODIGO = ITVENDA.CODIGO' +
          ' AND MAT_MOV.COR = ITVENDA.COR' +
          ' AND MAT_MOV.DEPOSITO = ITVENDA.DEPOSITO' +
          ' AND MAT_MOV.LOTE = ITVENDA.LOTE' +
          ' AND MAT_MOV.QUALIDADE = ITVENDA.QUALIDADE' +
          ' ORDER BY' +
          ' MAT_MOV.HR_MOVTO DESC FETCH FIRST 1 ROWS ONLY)'
      case 'POSTGRES':
        return '(SELECT' +
          ' MAT_MOV.PRECO' +
          ' FROM' +
          ' [MAT_MOV] MAT_MOV' +
          ' WHERE' +
          ' MAT_MOV.HR_MOVTO IS NOT NULL' +
          ' AND MAT_MOV.HR_MOVTO < VENDA.HR_VENDA' +
          ' AND MAT_MOV.CODIGO = ITVENDA.CODIGO' +
          ' AND MAT_MOV.COR = ITVENDA.COR' +
          ' AND MAT_MOV.DEPOSITO = ITVENDA.DEPOSITO' +
          ' AND MAT_MOV.LOTE = ITVENDA.LOTE' +
          ' AND MAT_MOV.QUALIDADE = ITVENDA.QUALIDADE' +
          ' ORDER BY' +
          ' MAT_MOV.HR_MOVTO DESC LIMIT 1)'
      default:
        return 'MATERIAL.PRE_COMPRA'
    }
  }

  adicionarConteudoModal(
    'Markup de Vendas', [
    {
      tipo: 'paragrafo',
      valor: 'Analisar o Markup de Vendas é essencial para tomada de decisões. ' +
        'Em uma visão comparativa, este relatório tem como objetivo apresentar o markup determinado no ato de entrada no estoque do produto, contra o markup realizado. '
    },
    {
      tipo: 'paragrafo',
      valor: 'Em resumo, se o produto foi vendido com desconto (por regra promocional, por desconto em tabela de preço, por desconto manual ou por outra forma de aplicar desconto) ' +
        'o markup realizado se torna diferente do markup estabelecido inicialmente para o produto.',
    },
    {
      tipo: 'paragrafo',
      valor:
        'Objetivamente, saber o markup realizado (não o idealizado) é fundamental para a gestão.'

    },
    {
      tipo: 'paragrafo',
      valor:
        'Entende-se que, se um markup realizado é menor do que o estabelecido, não se obteve lucro na venda.'

    },
    {
      tipo: 'paragrafo',
      valor:
        'O que não é medido, não é gerenciado!'

    }
  ]
  );
});












































