$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Vendas',
          description: 'Aqui, após clicar em consultar ficam os dados das vendas filtradas.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  const utilizaStatus = await CopiaParametro('VENDA', 37) == 1;
  if (utilizaStatus) {
    $('#statusContainer').removeClass('d-none')
  } else {
    $('#statusContainer').addClass('d-none')
  }
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relVenda == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVenda: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVenda: novasColunas }))

      $('#tabelaRelVenda').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelVenda').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  let utilizaMaterial = await CopiaParametro('VENDA', 17) == 1;

  if (utilizaMaterial == 1) {
    $('#radioMaterial').prop('checked', true);
    adicionaPesquiaPadraoMaterial();
  } else {
    adicionaPesquiaPadraoProduto();
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  const empId = getCookie('emp_id');
  preencheOrdenacaoTela('RelVenda');
  const apenasVendasDoRepresentanteLogado = await apenasClientesVinculadosAoRepresentante();

  function adicionaPesquiaPadraoProduto() {
    $("#lblProduto").text("Produto:");
    $('#txtMaterial').attr('id', 'txtProduto');
    $('#btnMaterial').attr('id', 'btnProduto');
    $('#btnLimpaMaterial').attr('id', 'btnLimpaProduto')
    $('#txtGrupoMA').attr('id', 'txtGrupoPA');
    $('#btnGrupoMA').attr('id', 'btnGrupoPA');
    $('#btnLimpaGrupoMA').attr('id', 'btnLimpaGrupoPA');

    $('#divEtiqueta').removeClass('d-none');
    $('#divMarca').removeClass('d-none');
    $('#divModelo').removeClass('d-none');
    $('#divTamanho').removeClass('d-none');
    $('#divCategoria').removeClass('d-none');
    $('#divTipoProduto').removeClass('d-none');
    $('#divLote').addClass('d-none');

    componenteFiltro('transportadora', true);
    componenteFiltro('venda', true);
    componenteFiltro('moeda', true, false);
    componenteFiltro('tipoVenda', true);
    componenteFiltro('cliente', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('usuario', true);
    componenteFiltro('produto', true);
    componenteFiltro('cor', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('linha', true);
    componenteFiltro('marca', true);
    componenteFiltro('modelo', true);
    componenteFiltro('tabPreco', true);
    componenteFiltro('regEstado', true);
    componenteFiltro('guia', true);
    componenteFiltro('pedido', true);
    componenteFiltro('tipoPessoa', true);
    componenteFiltro('tamanho', true)
    componenteFiltro('auxiliar', true)
    componenteFiltro('tipoProduto', true)
    componenteFiltro('caixa', true)
    componenteFiltro('funcionario', true)
    componenteFiltro('qualidade', true)
    componenteFiltro('status', true, true, 'Status', [`TIPO = 'VEN'`])
  }

  function adicionaPesquiaPadraoMaterial() {
    $("#lblProduto").text("Material:");
    $('#txtProduto').attr('id', 'txtMaterial');
    $('#btnProduto').attr('id', 'btnMaterial');
    $('#btnLimpaProduto').attr('id', 'btnLimpaMaterial')
    $('#txtGrupoPA').attr('id', 'txtGrupoMA');
    $('#btnGrupoPA').attr('id', 'btnGrupoMA');
    $('#btnLimpaGrupoPA').attr('id', 'btnLimpaGrupoMA');

    $('#divEtiqueta').addClass('d-none');
    $('#divMarca').addClass('d-none');
    $('#divModelo').addClass('d-none');
    $('#divTamanho').addClass('d-none');
    $('#divCategoria').addClass('d-none');
    $('#divTipoProduto').addClass('d-none');

    $('#divLote').removeClass('d-none');

    componenteFiltro('transportadora', true);
    componenteFiltro('venda', true);
    componenteFiltro('moeda', true, false);
    componenteFiltro('tipoVenda', true);
    componenteFiltro('cliente', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('usuario', true);
    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('linha', true);
    componenteFiltro('tabPreco', true);
    componenteFiltro('regEstado', true);
    componenteFiltro('guia', true);
    componenteFiltro('pedido', true);
    componenteFiltro('tipoPessoa', true);
    componenteFiltro('caixa', true);
    componenteFiltro('funcionario', true);
    componenteFiltro('qualidade', true);
    componenteFiltro('status', true, true, 'Status', [`TIPO = 'VEN'`])

    $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO"], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO"]}`, 'LOTE', 'CODIGO');
    $('#btnLote').pesquisa_serversideSel('#txtLote', `{ "tabela":"MAT_ITEN", "camposSelect":[ "LOTE", "CODIGO", "COR" ], "where": ["LOTE <> '' OR LOTE IS NOT NULL"], "groupBy": ["LOTE", "CODIGO", "COR"]}`, 'Pesquisa de Lote');

    $('#txtLote').addClass('camposFiltros');
    $('#btnLimpaLote').on('click', function () {
      $('#txtLote').empty().trigger('change')
      $('#txtLote').val('');
      $('#txtLote').attr('data-chave', '');
      $('#txtLote').attr('data-desc', '');
    });

  }

  $('#btnFiltros').on('click', async function () {
    $('#cbEmitido').prop('checked', JSON.parse(getCookie('emitidoRelVenda') == '' ? true : getCookie('emitidoRelVenda')));
    $('#cbDevolvido').prop('checked', JSON.parse(getCookie('devolvidoRelVenda') == '' ? true : getCookie('devolvidoRelVenda')));
    $('#cbPendente').prop('checked', JSON.parse(getCookie('pendenteRelVenda') == '' ? true : getCookie('pendenteRelVenda')));
    $('#cbCancelada').prop('checked', JSON.parse(getCookie('canceladaRelVenda') == '' ? true : getCookie('canceladaRelVenda')));
    $('#cbAgrupada').prop('checked', JSON.parse(getCookie('agrupadaRelVenda') == '' ? true : getCookie('agrupadaRelVenda')));
    if (await carregaValoresPadroes()) {
      const usuario = getCookie('cod_usuario');
      const nomeUsuario = getCookie('usuario');
      insereValor($('#txtUsuario'), usuario, nomeUsuario);
    };

    if (apenasVendasDoRepresentanteLogado) {
      await bloqueiaFiltroEPreencheValorRepresentante('#txtVendedor', '#btnVendedor', '#btnLimpaVendedor');
    };

    $('#modal-filtros').modal('show');
  });
  $('#btnLimparFiltros').on('click', async function () {
    $('#dtEmissaoDe').val('');
    $('#dtEmissaoAte').val('');
    $('#txtVenda').empty().trigger('change');
    $('#txtPedido').empty().trigger('change');
    $('#txtMoeda').empty().trigger('change');
    $('#txtTipoVenda').empty().trigger('change');
    $('#txtCliente').empty().trigger('change');
    $('#txtVendedor').empty().trigger('change');
    $('#txtUsuario').empty().trigger('change');
    $('#txtProduto').empty().trigger('change');
    $('#txtMaterial').empty().trigger('change');
    $('#txtCor').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtGrupoPA').empty().trigger('change');
    $('#txtGrupoMA').empty().trigger('change');
    $("#txtEtiqueta").empty().trigger('change');
    $("#txtLinha").empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtModelo').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#txtRegEstado').empty().trigger('change');
    $('#txtGuia').empty().trigger('change');
    $('#txtTamanho').empty().trigger('change');
    $('#txtCategoria').empty().trigger('change');
    $('#txtTipoProduto').empty().trigger('change');
    $('#txtLote').empty().trigger('change');
    $('#txtFuncionario').empty().trigger('change');
    $('#txtQualidade').empty().trigger('change');
    $('#txtStatus').empty().trigger('change');
    $('#rg_status').val(0);
  });

  $('#radioProduto, #radioMaterial').on('change', async function () {

    if ($('#radioMaterial').is(':checked')) {
      adicionaPesquiaPadraoMaterial();
    } else {
      adicionaPesquiaPadraoProduto();
    }
  });

  async function retornaFiltros() {

    let codigo;
    let grp;

    if ($('#radioMaterial').is(':checked')) {
      codigo = '#txtMaterial';
      grp = '#txtGrupoMA';
    } else {
      codigo = '#txtProduto';
      grp = '#txtGrupoPA';
    }

    const emissaoDe = $('#dtEmissaoDe').val();
    const emissaoAte = $('#dtEmissaoAte').val();
    const venda = await formataListas($('#txtVenda').val().toString());
    const moeda = await formataListas($('#txtMoeda').val().toString());
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const vendedor = await formataListas($('#txtVendedor').val().toString());
    const transportadora = await formataListas($('#txtTransportadora').val().toString());
    const usuario = await validaFiltroUsuario(
      await formataListas($("#txtUsuario").val().toString())
    );
    const produto = await formataListas($(codigo).val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const grupo = await formataListas($(grp).val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const tabela = await formataListas($('#txtTabPreco').val().toString());
    const guia = await formataListas($('#txtGuia').val().toString());
    const pedido = await formataListas($('#txtPedido').val().toString());
    const emitido = $('#cbEmitido').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const cancelada = $('#cbCancelada').prop('checked');
    const agrupada = $('#cbAgrupada').prop('checked');
    const agrupaItens = $('#cbAgrupaItens').prop('checked');
    const tipoItem = $('#radioProduto').prop('checked') ? 'P' : 'M';
    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const regiao = await formataListas($('#txtRegEstado').val().toString());
    const tipoPessoa = await formataListas($('#txtTipoPessoa').val().toString());
    const tamanho = await formataListas($('#txtTamanho').val().toString());
    const categoria = await formataListas($('#txtAuxiliar').val().toString());
    const tipoProduto = await formataListas($('#txtTipoProduto').val().toString());
    const ordenacao = await buscaValor('ORDEM_TELA', 'TIPO_ORDENACAO, NOME_ORD_SIST', 'ORDEM', `${$('#txtOrdem').val()}' AND NOME_TELA = 'RelVenda`);
    const caixa = await formataListas($('#txtCaixa').val().toString());
    const lote = await formataListas($('#txtLote').val().toString());
    const funcionario = await formataListas($('#txtFuncionario').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const status = await formataListas($('#txtStatus').val().toString());

    const retorno =
      `EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&VENDEDOR=${vendedor}` +
      `&TRANSPORTADORA=${transportadora}` +
      `&CLIENTE=${cliente}` +
      `&VENDA=${venda}` +
      `&MOEDA=${moeda}` +
      `&TABELA=${tabela}` +
      `&PRODUTO=${produto}` +
      `&MARCA=${marca}` +
      `&TIPOVENDA=${tipovenda}` +
      `&EMITIDO=${emitido}` +
      `&DEVOLVIDO=${devolvido}` +
      `&PENDENTE=${pendente}` +
      `&CANCELADA=${cancelada}` +
      `&AGRUPADA=${agrupada}` +
      `&AGRUPAITENS=${agrupaItens}` +
      `&GRUPO=${grupo}` +
      `&TIPO_ITEM=${tipoItem}` +
      `&USR_CAIXA=${usuario}` +
      `&EMP_IDS=${listaEmpIds}` +
      `&TIPO_ITEM=${tipoItem}` +
      `&ETIQUETA=${etiqueta}` +
      `&COR=${cor}` +
      `&COLECAO=${colecao}` +
      `&LINHA=${linha}` +
      `&MODELO=${modelo}` +
      `&REGIAO=${regiao}` +
      `&PEDIDO=${pedido}` +
      `&GUIA=${guia}` +
      `&TIPO_PESSOA=${tipoPessoa}` +
      `&TAMANHO=${tamanho}` +
      `&CATEGORIA=${categoria}` +
      `&TIPOPRODUTO=${tipoProduto}` +
      `&CAIXA=${caixa}` +
      `&LOTE=${lote}` +
      `&FUNCIONARIO=${funcionario}` +
      `&QUALIDADE=${qualidade}` +
      `&STATUS=${status}` +
      `&ORDENACAO=${ordenacao.NOME_ORD_SIST}` + `${ordenacao.TIPO_ORDENACAO == 'DESC' ? ':D' : ':A'}` +
      `&TELA_ORDENACAO=RelVenda`;

    return retorno;
  }

  retornaHintRelatorio('btnImprimir', 'RelVenda')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relvenda?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelVenda&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelVenda');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, 'POST', 550000, false, 'RelVenda', filtros);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
    try {
      setCookie('emitidoRelVenda', $('#cbEmitido').prop('checked'));
      setCookie('devolvidoRelVenda', $('#cbDevolvido').prop('checked'));
      setCookie('pendenteRelVenda', $('#cbPendente').prop('checked'));
      setCookie('canceladaRelVenda', $('#cbCancelada').prop('checked'));
      setCookie('agrupadaRelVenda', $('#cbAgrupada').prop('checked'));
      Graficos.limpaGrafico(['graficoRelVenda', 'graficoRelVenda1']);
      try {
        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/consultarelvenda?';
        const filtros = await retornaFiltros();

        const response = await requisicao('POST', url, '', filtros, 350000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          if ($.fn.DataTable.isDataTable("#tabelaRelVenda")) {
            $("#tabelaRelVenda").DataTable().destroy();
            $("#tabelaRelVenda").empty();
          }
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        const colunasValor = [7, 8, 14, 20, 21, 23, 24];
        dataSetCols.forEach((item, index) => {
          if (['CUSTO_PROD'].includes(item.data)) {
            colunasValor.push(index);
          }
        });

        $('#tabelaRelVenda').DataTable({
          destroy: true,
          colReorder: true,
          paging: true,
          sort: false,
          sorting: false,
          order: false,
          autoWidth: true,
          data: jsonStr,
          columns: dataSetCols,
          columnDefs: [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString('pt-BR', {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });

              },
              "targets": colunasValor,
              "className": 'pr-4 text-right'
            },
            {
              "targets": [18, 19],
              "className": 'pr-4 text-right'
            },
            {
              "type": 'date-br',
              "targets": [22, 33, 34],
              "render": function (data) {
                if (data != undefined && data != '') {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return ''
                }
              }
            }
          ],
        });

        // if ($.fn.DataTable.isDataTable('#tabelaRelVenda')) {
        //   $("#tabelaRelVenda").DataTable().columns.adjust().draw(false);
        // };

        $('#tabelaRelVenda_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelVenda_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelvenda?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Venda', '#tabelaRelVenda', '', 999, true);
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelVenda').DataTable().columns(colunas.relVenda ?? []).visible(false);
        $('#tabelaRelVenda').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relVenda).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        const dados = $('#tabelaRelVenda').DataTable().data().toArray().map((item) => {
          if (item.DEVOLUCAO === 1) {
            return { ...item, TOTAL_LIQ: -Math.abs(item.TOTAL_LIQ) };
          } else {
            return item;
          }
        });

        Graficos.criarGrafico({
          container: 'graficoRelVenda',
          tipo: 'column',
          dados: dados,
          nomeSerie: 'Valor',
          colunasAgrupamento: ['CODIGO'],
          colunasValor: ['TOTAL_LIQ'],
          title: 'Valor por código do item'
        });

        Graficos.criarGrafico({
          container: 'graficoRelVenda1',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Valor',
          colunasAgrupamento: ['DESC_COLECAO'],
          colunasValor: ['TOTAL_LIQ'],
          title: 'Valor por coleção'
        });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelVenda').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relVenda ?? [])
  });

  $('#btn-confirmar-empresas').on('click', async function () {
    const EmpresasIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : ['']
    $('#txtVendedor').unbind('autocompleta');
    $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "distinct codrep chave", "nome descricao"], "where": null}`, undefined, '', '', undefined, undefined, '', EmpresasIds);
    $('#btn-Vendedor').off();
    $('#btn-Vendedor').unbind('pesquisa');
    $('#btn-Vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "distinct codrep", "nome"]}`, 'Pesquisa Vendedor', 'represen', '', undefined, '', EmpresasIds);
  });

  async function carregaValoresPadroes() {
    const pesquisa = await buscaValoresPadroes('LOJA')
    const jsonStr = pesquisa.filter((item) => item.CAMPO == 'RETORNA_USUARIO')

    const retornaUsuarioLogado = jsonStr.length <= 0 ? false : jsonStr[0].VALOR == 'S' ? true : false;

    return retornaUsuarioLogado;
  };

});