$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'DadosGerais') {
          if (!$('#CollapseDados').hasClass('show')) {
            $('#DadosGerais').collapse('show');
          }
        }
        if (Element.node.id == 'observacao') {
          if (!$('#CollapseDados').hasClass('show')) {
            $('#observacao').collapse('show');
          }
        }
      }
    });
    driver.defineSteps([
      {
        element: '#DadosGerais',
        popover: {
          title: 'Informar dados gerais',
          description: 'Aqui estão os campos disponíveis para o cadastro.',
          position: 'top'
        }
      },
      {
        element: '#NotaFiscalInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'bottom'
        }
      },
      {
        element: '#FornecedorInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#ValorInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtClasse',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#BancoInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtConta',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtSituacao',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#observacao',
        popover: {
          title: 'Aba de Observação',
          description: 'Aqui é informado a observação da Conta a Pagar.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  // autocompleta

  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": ["ATIVO = 'S'", "TP_CONTA <> 'T'"]}`);
  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
  $('#txtConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtHistorico').autocompleta(1, `JSON={ "tabela": "HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": ["ATIVO = 'S'"] }`);

  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"], "where": ["ATIVO = 'S'", "TP_CONTA <> 'T'"], "orderby":["codigo"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ", "FANTASIA"]}`, 'Pesquisa Fornecedor', 'ENTIDADE');
  $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
  $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
  $('#btn-Conta').pesquisa('#txtConta', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, 'Pesquisa Conta', 'CADCONTA');
  $("#btnHistorico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": ["ATIVO = 'S'"], "orderby":["HISTORICO"] }`, "Pesquisa Histórico", "HISTCP");

  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btn-limpa-Fornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });
  $('#btn-limpa-Situacao').on('click', function () {
    $('#txtSituacao').val('');
  });
  $('#btn-limpa-Banco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });
  $('#btnLimpaHistorico').on('click', function () {
    $('#txtHistorico').val('');
  });

  componenteFiltro('ocorrencia', false, false);

  await buscaEmpresasPagar();

  async function buscaEmpresasPagar() {
    try {

      const retornoSelect = await buscaEmpresas();

      if (retornoSelect && retornoSelect.length > 0) {
        retornoSelect.map(e => {
          let vSelect = e.EMP_ID == getCookie('emp_id') ? ' selected' : '';
          $('#txtEmpresa').append(`<option class="drilldown-item" value="${e.EMP_ID}"${vSelect}>${e.EMPRESA} - ${e.EMP_NOME}</option>`)
        })
      } else {
        throw '';
      }
    } catch (e) {
      $('#txtEmpresa').prop('disabled', true);
    }
  }

  let queryString = window.location.href;
  let achaPagar = queryString.indexOf('pagar/') + 6; // + 6 porque é a soma do "pagar/""
  let pagar = queryString.substr(achaPagar, queryString.length);
  let emp_id_ap = getCookie('emp_id');

  $('#txtNotaFiscal').on('blur', async function () {
    if ($(this).val() == '') {
      $(this).val(await RetornaProximo('PAGTO', 'PAGTO', 'DOCTO', 6));
    }
  });

  $('#txtConta').on('blur', async function () {
    const conta = pegaChave(this)
    if (conta != '') {
      const response = await buscaValor('CADCONTA', 'BANCO', 'CONTA', conta)
      if (response && response !== '' && response.BANCO !== '') {
        insereValor('#txtBanco', response.BANCO, { tabela: 'CADBAN', campoBusca: 'NOME_BANCO', campoWhere: 'BANCO', valorWhere: response.BANCO })
      }
    }
  })

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('PAGAR', getCookie('usuario'), pagar);
    window.location.href = `${BASE_URI}/pagar`;
  });

  if (pagar != 'create') {
    pagar = atob(pagar);
    $('#txtEmpresa').prop('disabled', true);
    emp_id_dupli = (await buscaValor('PAGTO', 'EMP_ID', 'NUM_AP', pagar)).EMP_ID
    $('#txtEmpresa').val(emp_id_dupli);
  } else {
    const paramsReceber = await BuscaParametrosReceber();

    if (paramsReceber[10].VALOR != '1') {
      $('#txtEmpresa').prop('disabled', true);
    } else {
      $('#txtEmpresa').prop('disabled', false);
    }
  }

  $('#txtFornecedor').on('blur', async function () {
    if ($(this).val() != '') {
      let sCodCli = pegaChave('#txtFornecedor');
      await verificaCliente(sCodCli);
    }
  });

  $('#btnGerarBoleto').on('click', function () {
    $('#modalGerarBoleto').modal('show');
  });

  $('#btnConfirmarBoleto').on('click', function () {
    const barra = geraBarraBoleto();
    if (barra) {
      $('#txtBarraBoleto').val(barra);
    }
    $('#modalGerarBoleto').modal('hide');
  })

  $('#modalGerarBoleto').on('hide.bs.modal', function () {
    $('#txtLinhaDigitavel').val('');
  })

  function geraBarraBoleto() {
    try {
      let linha = $('#txtLinhaDigitavel').val().replaceAll('/', '').replaceAll('.', '').replaceAll('-', '').replaceAll(' ', '');
      let barra = '';
      if (pagar != 'create') {
        if ((linha != '') && (linha.length != 48)) {
          if (pegaChave('#txtBanco') == '341') {
            barra = linha;
          } else {
            barra = linha.substr(0, 3);
            barra += linha.substr(3, 1);
            barra += linha.substr(32, 1);
            barra += linha.substr(33, 4);
            barra += linha.substr(37, 10);
            barra += linha.substr(4, 5);
            barra += linha.substr(10, 10);
            barra += linha.substr(21, 10);
          }
        }
      } else {
        if ((linha != '') && (linha.length != 48)) {
          barra = linha.substr(0, 3);
          barra += linha.substr(3, 1);
          barra += linha.substr(32, 1);
          barra += linha.substr(33, 4);
          barra += linha.substr(37, 10);
          barra += linha.substr(4, 5);
          barra += linha.substr(10, 10);
          barra += linha.substr(21, 10);
        } else {
          if (linha.length == 48) {
            barra = linha;
          }
        }
      }

      return barra;
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível gerar a barra: ${e}`);
    }
  }

  async function verificaCliente(codcli) {
    if (codcli == '') {
      return;
    }
    try {
      let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`, null);

      if (!response) {
        return;
      }

      let jsonEntidade = await response.json();
      if (response.status != 200) {
        msgErro(jsonEntidade.RESULT[0].mensagem);
        return;
      }
      if (jsonEntidade.RESULT[0][0].BLOQUEIO == 'S') {
        msgAlerta('Fornecedor bloqueado, impossível continuar.');
        $('#txtFornecedor').val('');
      } else if (jsonEntidade.RESULT[0][0].ATIVO == 'N') {
        msgAlerta('Fornecedor inativo, impossível continuar.');
        $('#txtFornecedor').val('');
      }
    } catch (error) {
      console.error(error);
    }
  };

  function retornaListaPagar() {
    let arrayPagar = [];
    const fornecedor = pegaChave('#txtFornecedor');

    $('#tabelaParcelas').DataTable().rows().data().map(item => {
      let dtVencimento = item.VENCIMENTO.split('/');
      dtVencimento = dtVencimento[2] + '-' + dtVencimento[1] + '-' + dtVencimento[0];
      let dtEmissao = item.EMISSAO.split('/');
      dtEmissao = dtEmissao[2] + '-' + dtEmissao[1] + '-' + dtEmissao[0];
      let dtEntrada = item.ENTRADA.split('/');
      dtEntrada = dtEntrada[2] + '-' + dtEntrada[1] + '-' + dtEntrada[0];
      arrayPagar.push({
        DOCTO: $('#txtNotaFiscal').val(),
        DUPLI: item.DUPLICATANUMERO,
        LANCAMENTO: $('#txtLancamento').val(),
        VALOR: parseFloat(item.VALOR),
        VALOR_ORIG: parseFloat(item.VALOR),
        DT_VEN: `${dtVencimento}T00:00:00Z`,
        DATA_ORIG: `${dtVencimento}T00:00:00Z`,
        DT_EMI: `${dtEmissao}T00:00:00Z`,
        DT_ATUAL: `${dtEntrada}T00:00:00Z`,
        STATUS: $('#txtStatus').val(),
        OBS: item.OBSERVACAO,
        EMP_ID: $('#txtEmpresa').val(),
        CODCRE: fornecedor,
        SITUACAO: item.SITUACAO,
        NUM_OS: item.CLASSE,
        BANCO: item.BANCO,
        CONTA: item.CONTA,
        BARRA: $('#txtBarraBoleto').val(),
        OCORRENCIA: pegaChave('#txtOcorrencia'),
        TIPO_DOCTO: $('#txtTipoDocumento').val(),
        BANCO_FAV: $('#txtBancoFavor').val(),
        CONTA_FAV: $('#txtContaFavor').val(),
        AGENCIA_FAV: $('#txtAgenciaFavor').val(),
        DIG_CONTA_FAV: $('#txtDigitoContaFavor').val(),
        DIG_AGENCIA_FAV: $('#txtDigitoAgenciaFavor').val(),
        TELA: "PAGAR",
        HISTORICO: item.HISTORICO
      });
    });

    return { ListaPagar: arrayPagar };
  }

  $('#btnGerarAp').on('click', async function () {
    await geraParcelas();
  })


  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtMoeda: {
        required: true,
      },
      txtBanco: {
        required: true,
      },
      txtConta: {
        required: true,
      },
      txtSituacao: {
        required: true,
      },
      txtValor: {
        required: true,
      },
      txtFornecedor: {
        required: true,
      },
      txtNotaFiscal: {
        required: true,
      },
      txtDTemissao: {
        max: "2500-12-31",
        required: true
      },
      txtDTvencimento: {
        max: "2500-12-31",
      }
    },
    messages: {
      txtMoeda: {
        required: "Informe uma Moeda."
      },
      txtBanco: {
        required: "Informe um Banco válido."
      },
      txtConta: {
        required: "Informe uma Conta."
      },
      txtValor: {
        required: "Informe o Valor do Pagamento."
      },
      txtSituacao: {
        required: "Informe alguma Situação."
      },
      txtFornecedor: {
        required: "Informe um Fornecedor."
      },
      txtNotaFiscal: {
        required: "Informe uma Nota Fiscal."
      },
      txtDTemissao: {
        max: "Data Inválida",
        required: "Informe a Data de Emissão."
      },
      txtDTvencimento: {
        max: "Data Inválida"
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    },
    async submitHandler(form, event) {
      try {
        event.preventDefault();
        $.LoadingOverlay("show");
        try {
          const valorTotal = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
          if (valorTotal <= 0) {
            msgAlerta('Valor não pode ser 0!');
            return;
          }

          // if (!$('.divParcela').hasClass('d-none')) {
          //   await geraParcelas();
          // }

          if (!$('.divParcela').hasClass('d-none')) {
            const dados = $("#tabelaParcelas").DataTable().data().toArray();
            let parcelaZerada = false;
            let somaParcelas = 0;
            let semDataVenc = false;
            let dataVencInvalida = false;
            let dataEmissao = new Date();
            if ($("#txtDTemissao").val() !== '') {
              const dta = $("#txtDTemissao").val().split("-");
              dataEmissao = new Date(dta[0], dta[1] - 1, dta[2], 23, 59, 59);
            }
            for (let i = 0; i < dados.length; i++) {
              const valor = parseFloat(dados[i].VALOR);
              somaParcelas = somaParcelas + valor;
              if (valor == 0) {
                parcelaZerada = true;
              }

              if (dados[i].VENCIMENTO === '') {
                semDataVenc = true;
              }

              if (dados[i].VENCIMENTO !== '') {
                const dta = dados[i].VENCIMENTO.split('/');
                const dtVenc = new Date(dta[2], dta[1] - 1, dta[0], 23, 59, 59);
                if (dtVenc < dataEmissao) {
                  dataVencInvalida = true;
                }
              }
            }

            if (parcelaZerada) {
              msgAlerta('Parcelas não podem ter valor 0, verifique!');
              return;
            }

            if (valorTotal != parseFloat(somaParcelas.toFixed(2))) {
              msgAlerta('Soma do valor das parcelas não confere com o valor total, verifique!');
              return;
            }

            if (semDataVenc) {
              msgAlerta('Parcelas precisam ter data de vencimento, verifique!');
              return;
            }

            if (dataVencInvalida) {
              msgAlerta('Não é possível gravar parcelas com vencimento menor do que a data de emissão, verifique!');
              return;
            }

            const objeto = retornaListaPagar();

            let response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/pagarvarios?', '', `JSON=${encodeURIComponent(JSON.stringify(objeto))}`, 50000);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status == 502) {
              await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
            } else if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
              'Cadastro efetuado com sucesso!',
              'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/pagar`;
              }
            }
            ).css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px"
            });
          } else {
            const classe = pegaChave('#txtClasse');
            const situacao = pegaChave('#txtSituacao');
            const fornecedor = pegaChave('#txtFornecedor');
            const banco = pegaChave('#txtBanco');
            const conta = pegaChave('#txtConta');
            const historico = pegaChave("#txtHistorico");

            const PagarC = {};

            PagarC.NUM_AP = $('#txtNum_ap').val();
            PagarC.DOCTO = $('#txtNotaFiscal').val();
            PagarC.DUPLI = $('#txtDupli').val();
            PagarC.LANCAMENTO = $('#txtLancamento').val();
            PagarC.VALOR = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
            PagarC.VAL_PAG = parseFloat($('#txtValorPago').val().replace('.', '').replace(',', '.'));
            PagarC.VALOR_ORIG = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
            PagarC.DT_VEN = `${$('#txtDTvencimento').val()}T00:00:00Z`;
            PagarC.DATA_ORIG = `${$('#txtDTvencimento').val()}T00:00:00Z`;
            PagarC.DT_EMI = `${$('#txtDTemissao').val()}T00:00:00Z`;
            PagarC.STATUS = $('#txtStatus').val();
            PagarC.OBS = $('#txtObs').val();
            PagarC.EMP_ID = $('#txtEmpresa').val();
            PagarC.CODCRE = fornecedor;
            PagarC.SITUACAO = situacao;
            PagarC.NUM_OS = classe;
            PagarC.BANCO = banco;
            PagarC.CONTA = conta;
            PagarC.HISTORICO = historico;
            PagarC.BARRA = $('#txtBarraBoleto').val();
            PagarC.OCORRENCIA = pegaChave('#txtOcorrencia');
            PagarC.TIPO_DOCTO = $('#txtTipoDocumento').val();
            PagarC.BANCO_FAV = $('#txtBancoFavor').val();
            PagarC.CONTA_FAV = $('#txtContaFavor').val();
            PagarC.AGENCIA_FAV = $('#txtAgenciaFavor').val();
            PagarC.DIG_CONTA_FAV = $('#txtDigitoContaFavor').val();
            PagarC.DIG_AGENCIA_FAV = $('#txtDigitoAgenciaFavor').val();
            PagarC.QTDEPARCELAS = $('#txtParcela').val();

            const response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/Pagar?', '', `JSON=${encodeURIComponent(JSON.stringify(PagarC))}`);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();

            if (response.status == 502) {
              await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
            } else if (response.status != 200) {
              msgErro(jsonStr.RESULT[0].mensagem);
              return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
              'Cadastro efetuado com sucesso!',
              'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                deletaRegistro('PAGAR', getCookie('usuario'), PagarC.NUM_AP);
                window.location.href = `${BASE_URI}/pagar`;
              }
            }
            ).css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px"
            });
          }
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível gravar os dados do Pagamento: ');
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });
  if (pagar != '' && pagar != 'create') {

    ajustarLayoutEdicao();

    if (await liberarRegistro('PAGAR', pagar) == false) {
      window.location.href = '../pagar';
    } else {
      try {
        let response = '';
        let jsonStr = [];
        let fornecedor = '';
        let classe = '';
        let situacao = '';
        let banco = '';
        let conta = '';
        let historico = '';

        $.LoadingOverlay("show");
        response = await requisicao('GET', '/Sisplan/pagar/V1/Pagar?', `num_ap=${pagar}&EMP_ID=${emp_id_dupli}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.length <= 0) {
          window.location.href = '../pagar';
        }

        let pagarJson = jsonStr;

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.CODCRE", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            fornecedor = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          fornecedor = `[${jsonStr.RESULT[0][0].CODCRE}] - ${jsonStr.RESULT[0][0].NOME}`;
        } catch (error) {
          console.error(error);
          fornecedor = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CLASSE_GER.CODIGO", "CLASSE_GER.DESCRICAO"], "leftJoin": [{"tabela": "CLASSE_GER", "condicao": "PAGTO.NUM_OS = CLASSE_GER.CODIGO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            classe = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          classe = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          classe = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["TABSIT.CODIGO", "TABSIT.DESCRICAO"], "leftJoin": [{"tabela": "TABSIT", "condicao": "PAGTO.SITUACAO = TABSIT.CODIGO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);

          if (!response) {
            situacao = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          situacao = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          situacao = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CADBAN.BANCO", "CADBAN.NOME_BANCO"], "leftJoin": [{"tabela": "CADBAN", "condicao": "PAGTO.BANCO = CADBAN.BANCO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            banco = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          banco = `[${jsonStr.RESULT[0][0].BANCO}] - ${jsonStr.RESULT[0][0].NOME_BANCO}`;
        } catch (error) {
          console.error(error);
          banco = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CADCONTA.CONTA", "CADCONTA.DESCRICAO"], "leftJoin": [{"tabela": "CADCONTA", "condicao": "PAGTO.CONTA = CADCONTA.CONTA"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            conta = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          conta = `[${jsonStr.RESULT[0][0].CONTA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          conta = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["HISTCP.HISTORICO", "HISTCP.DESCRICAO"], "leftJoin": [{"tabela": "HISTCP", "condicao": "PAGTO.HISTORICO = HISTCP.HISTORICO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            historico = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          historico = `[${jsonStr.RESULT[0][0].HISTORICO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          historico = '';
        }

        // desabilita os campos q nao podem ser editados
        if (pagarJson[0].VALOR === pagarJson[0].VAL_PAG) {
          $('#btn-Fornecedor').attr('disabled', 'disabled');
          $('#btn-limpa-Fornecedor').attr('disabled', 'disabled');
          $('#txtFornecedor').attr('disabled', 'disabled');
          $('#txtValor').attr('disabled', 'disabled');
          $('#txtNotaFiscal').attr('disabled', 'disabled');
          $('#txtSituacao').attr('disabled', 'disabled');
          $('#txtBanco').attr('disabled', 'disabled');
          $('#txtDTvencimento').attr('disabled', 'disabled');
          $('#txtDTemissao').attr('disabled', 'disabled');
          $('#txtDTentrada').attr('disabled', 'disabled');
          $('#txtConta').attr('disabled', 'disabled');
        }

        $('#txtNum_ap').val(pagarJson[0].NUM_AP);
        $('#txtLancamento').val(pagarJson[0].LANCAMENTO);
        $('#txtNotaFiscal').val(pagarJson[0].DOCTO);
        $('#txtDupli').val(pagarJson[0].DUPLI);
        $('#txtValor').val(pagarJson[0].VALOR.toLocaleString('pt-BR', { maximumFractionDigits: 2, minimumFractionDigits: 2 }));
        $('#txtValorPago').val(pagarJson[0].VAL_PAG.toLocaleString('pt-BR', { maximumFractionDigits: 2, minimumFractionDigits: 2 }));
        $('#txtDTvencimento').val(pagarJson[0].DT_VEN);
        $('#txtDTvencimentoBase').val(pagarJson[0].DT_VEN);
        $('#txtDTemissao').val(pagarJson[0].DT_EMI);
        $('#txtDTentrada').val(pagarJson[0].DT_ATUAL);
        $('#txtObs').val(pagarJson[0].OBS);
        $('#txtStatus').val(pagarJson[0].STATUS);
        $('#txtEmpId').val(pagarJson[0].EMP_ID);
        $('#txtFornecedor').val(fornecedor);
        $('#txtSituacao').val(situacao);
        $('#txtClasse').val(classe);
        $('#txtBanco').val(banco);
        $('#txtConta').val(conta);
        $('#txtHistorico').val(historico);
        $('#txtBancoFavor').val(pagarJson[0].BANCO_FAV);
        $('#txtContaFavor').val(pagarJson[0].CONTA_FAV);
        $('#txtAgenciaFavor').val(pagarJson[0].AGENCIA_FAV);
        $('#txtDigitoContaFavor').val(pagarJson[0].DIG_CONTA_FAV);
        $('#txtDigitoAgenciaFavor').val(pagarJson[0].DIG_AGENCIA_FAV);
        $('#txtTipoDocumento').val(pagarJson[0].TIPO_DOCTO);
        $('#txtBarraBoleto').val(pagarJson[0].BARRA);
        insereValor('#txtOcorrencia', pagarJson[0].OCORRENCIA, { tabela: 'OCORRENCIA', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: pagarJson[0].OCORRENCIA });
        const parcela = pagarJson[0].DUPLI.split('-');
        if ((parcela) && (parcela[1] != '')) {
          $('#labelParcela').removeClass('d-none');
          let label = $("#labelParcela label");
          const qtdeParcela = await buscaQtdeParcela(pagarJson[0].DOCTO, getCookie('emp_id'));
          let sParcela = parcela[1];
          if (!sParcela) {
            sParcela = 1;
          }
          label.text(`Parcela ${sParcela} de ${qtdeParcela}`);
        }
        $.LoadingOverlay("hide");
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro('Não foi possível buscar os dados do pagar: ');
      }
    }
  } else {
    $('#txtDTemissao').val(new Date().toISOString().slice(0, 10));
    $('#txtDTvencimento').val(new Date().toISOString().slice(0, 10));
    $('#txtDTvencimentoBase').val(new Date().toISOString().slice(0, 10));
    $('#txtDTentrada').val(new Date().toISOString().slice(0, 10));
    $('#txtEmpId').val(getCookie('emp_id'));
    $('.divParcela').removeClass('d-none');
  }

  $('#txtDTentrada').on('blur', function () {
    let dtEmissao = $('#txtDTemissao').val()
    if ($(this).val() < dtEmissao) {
      $('#txtDTentrada').val(new Date().toISOString().slice(0, 10));
      throw msgAlerta('A data de entrada não pode ser menor que a data de emissão, verifique!')
    }
  })

  $(function () {
    $('#txtValor, #txtValorParcela').maskMoney({
      decimal: ',',
      thousands: '.',
      precision: 2,
      allowZero: true,
      defaultZero: true,
      min: 0,
      max: 99
    });

    $('#txtIntervaloDias, #txtParcela').on('input', function (event) {
      $(this).val($(this).val().replace(/[^0-9.]/g, ''));
    });

    $('#txtIntervaloDias').on('blur', function () {
      atualizaDataVencimento($(this).val())
    })
  });

  $('#btnBuscarEntidade').on('click', async function (e) {
    e.preventDefault();
    $.LoadingOverlay('show');
    try {
      const codcli = pegaChave('#txtFornecedor');

      const dados = await buscaValor('ENTIDADE', 'CONTA, BANCO, AGENCIA', 'CODCLI', codcli);
      if (dados != undefined) {
        $('#txtBancoFavor').val(dados.BANCO);
        $('#txtContaFavor').val(dados.CONTA.split('-')[0] ?? '');
        $('#txtDigitoContaFavor').val(dados.CONTA.split('-')[1] ?? '');
        $('#txtAgenciaFavor').val(dados.AGENCIA.split('-')[0] ?? '');
        $('#txtDigitoAgenciaFavor').val(dados.AGENCIA.split('-')[1] ?? '');
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#txtParcela').on('blur', function () {
    if ((parseFloat($('#txtValor').val()) > 0) && (parseFloat($(this).val()) > 0)) {
      const valor = (parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')) / parseFloat($(this).val())).toFixed(2);
      $('#txtValorParcela').val(valor.replace('.', ','));
    }
  });

  $('#txtValorParcela').on('blur', function () {
    if ((parseFloat($('#txtValor').val()) > 0) && (parseFloat($(this).val()) > 0)) {
      const qtdeParcela = (parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')) / parseFloat($(this).val().replace('.', '').replace(',', '.'))).toFixed(0);
      $('#txtParcela').val(qtdeParcela);
    }
  });

  async function buscaQtdeParcela(docto, emp_id) {
    try {
      response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"PAGTO", "camposSelect":["COUNT(*) QTDE"], "where": ["PAGTO.DOCTO = '${docto}'", "PAGTO.EMP_ID = ${emp_id}"]}`,
        null
      );
      if (!response) {
        return 1;
      }
      jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0][0].QTDE;
    } catch (error) {
      console.error(error);
    }
  }

  function ultimoDiaDoMes(data, ultimoDia) {
    let dataRetorno = new Date(data.getFullYear(), data.getMonth(), 0);
    if (dataRetorno.getDate() > ultimoDia) {
      dataRetorno.setDate(ultimoDia);
    }
    return dataRetorno;
  }

  function formatarDataStr(dataStr) {
    const partes = dataStr.split('/');
    return `${partes[2]}-${partes[1]}-${partes[0]}`;
  }

  function calcularParcelas(indiceLinhaAlterada) {
    const tabela = $("#tabelaParcelas").DataTable();
    const dadosTabela = tabela.data().toArray();
    if (indiceLinhaAlterada < (dadosTabela.length - 1)) {
      const parcelas = parseInt($('#txtParcela').val()) > 0 ? parseInt($('#txtParcela').val()) : 1;
      const valorTotal = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
      let somaParcelas = 0;
      for (let i = 0; i <= indiceLinhaAlterada; i++) {
        somaParcelas += parseFloat(parseFloat(dadosTabela[i].VALOR).toFixed(2));
      }

      const diferença = parseFloat((valorTotal - somaParcelas).toFixed(2));
      let valorParcRestantes = 0;
      let valorUltimaParcela = 0;
      if (diferença > 0) {
        const parcelasRestantes = parcelas - (indiceLinhaAlterada + 1);
        if (parcelasRestantes % 2 == 0) {
          valorParcRestantes = Math.floor((diferença / parcelasRestantes) * 100) / 100;
        } else {
          valorParcRestantes = parseFloat((diferença / parcelasRestantes).toFixed(2));
        }

        valorUltimaParcela = valorParcRestantes;
        const somaTotal = parseFloat((somaParcelas + parseFloat((valorParcRestantes * parcelasRestantes).toFixed(2))).toFixed(2));
        const difUltimaParcela = parseFloat((valorTotal - somaTotal).toFixed(2));
        if (difUltimaParcela != 0) {
          valorUltimaParcela = parseFloat((valorParcRestantes + difUltimaParcela).toFixed(2));
        }
      }

      for (let i = (indiceLinhaAlterada + 1); i < dadosTabela.length; i++) {
        if (i == (dadosTabela.length - 1)) {
          tabela.rows().data()[i].VALOR = valorUltimaParcela.toFixed(2);
          $(`#txtValParc_${i}`).val(parseFloat(valorUltimaParcela).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        } else {
          tabela.rows().data()[i].VALOR = valorParcRestantes.toFixed(2);
          $(`#txtValParc_${i}`).val(parseFloat(valorParcRestantes).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
        }
      }
    }
  }

  async function geraParcelas() {
    $.LoadingOverlay("show");
    try {
      $('#txtParcela').trigger('blur');
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        const colunas = [
          { title: 'Duplicata/Número', data: 'DUPLICATANUMERO' },
          { title: 'Valor', data: 'VALOR' },
          { title: 'Vencimento', data: 'VENCIMENTO' },
          { title: 'Emissão', data: 'EMISSAO' },
          { title: 'Entrada', data: 'ENTRADA' },
          { title: 'Classe', data: 'CLASSE' },
          { title: 'Desc. Classe', data: 'DESC_CLASSE' },
          { title: 'Banco', data: 'BANCO' },
          { title: 'Desc. Banco', data: 'DESC_BANCO' },
          { title: 'Conta', data: 'CONTA' },
          { title: 'Desc. Conta', data: 'DESC_CONTA' },
          { title: 'Situação', data: 'SITUACAO' },
          { title: 'Desc. Situação', data: 'DESC_SITUACAO' },
          { title: 'Histórico', data: 'HISTORICO' },
          { title: 'Desc. Histórico', data: 'DESC_HISTORICO' },
          { title: 'Observação', data: 'OBSERVACAO' }
        ];

        $("#tabelaParcelas").DataTable({
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          scrollX: true,
          scrollY: '400px',
          data: null,
          columns: colunas,
          rowCallback: async function (row, data) {
            let colValor = $(`td:eq(1)`, row);
            colValor.empty().append(
              $('<input>', {
                type: 'text',
                id: `txtValParc_${row._DT_RowIndex}`,
                class: 'input-default focus form-control text-right input-valor-parcelas',
                value: parseFloat(data.VALOR).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }),
                blur: function () {
                  if ($(this).val() === '') {
                    $(this).val(0);
                  }
                  if (parseFloat(this) !== 0) {
                    data.VALOR = parseFloat($(this).val().replace('.', '').replace(',', '.')).toFixed(2);
                  }
                  calcularParcelas(row._DT_RowIndex);
                },
                focus: function () {
                  if ($(this).val() == '0') {
                    $(this).val('');
                  }
                }
              })
            );

            let colVenc = $(`td:eq(2)`, row);
            colVenc.empty().append(
              $('<input>', {
                type: 'date',
                id: `txtVencimento_${row._DT_RowIndex}`,
                class: 'input-default focus form-control input-vencimento-parcelas',
                value: formatarDataStr(data.VENCIMENTO),
                blur: function () {
                  if ($(this).val() !== '') {
                    const dta = $(this).val().split("-");
                    data.VENCIMENTO = `${dta[2]}/${dta[1]}/${dta[0]}`;
                  } else {
                    data.VENCIMENTO = '';
                  }
                }
              })
            );
          }
        });

        if ($.fn.dataTable.isDataTable('#tabelaParcelas')) {
          let tabelaParcelas = $('#tabelaParcelas').DataTable();
          tabelaParcelas.clear().draw();
        }

        const parcelas = parseInt($('#txtParcela').val()) > 0 ? parseInt($('#txtParcela').val()) : 1;
        const valorTotal = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
        let valorParcela = (valorTotal / parcelas).toFixed(2);
        const dtVencto = pegaValor('#txtDTvencimento').split('-');
        const vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
        const primeiroVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
        let dtVencimento;
        let novoVenctoTabela = new Date();
        let dtEmissao;
        let novaEmissaoTabela = new Date();
        const intervalo = pegaValor('#txtIntervaloDias') == '' ? 0 : pegaValor('#txtIntervaloDias');
        const valorDiferenca = (valorTotal - (valorParcela * parcelas)).toFixed(2);
        const intervaloEmissao = (await carregaValoresPadroesLista('PAGTO')).INTERVALO_DIAS_EMISS

        const dtEmi = $('#txtDTemissao').val().split('-')
        const emi = new Date(dtEmi[0], dtEmi[1] - 1, dtEmi[2], 23, 59, 59);

        for (let i = 0; i < parcelas; i++) {
          if (((i + 1) == parcelas) && (valorDiferenca != 0)) {
            valorParcela = (parseFloat(valorParcela) + parseFloat(valorDiferenca)).toFixed(2);
          }

          if (i == 0) {
            dtVencimento = vencto;
            novoVenctoTabela = dtVencimento;
            dtEmissao = emi
            novaEmissaoTabela = dtEmissao
          } else {
            if ($('#cbVenctoMesmoDia').prop('checked')) {
              dtVencimento = novoVenctoTabela;
              dtVencimento.setMonth(dtVencimento.getMonth() + 1);
              if (primeiroVencto.getDate() != dtVencimento.getDate()) {
                dtVencimento = ultimoDiaDoMes(dtVencimento, primeiroVencto.getDate());
              }
              novaEmissaoTabela.setDate(novaEmissaoTabela.getDate() + parseInt(intervaloEmissao));
              dtEmissao = novaEmissaoTabela;
            } else {
              novoVenctoTabela.setDate(novoVenctoTabela.getDate() + parseInt(intervalo));
              dtVencimento = novoVenctoTabela;
              novaEmissaoTabela.setDate(novaEmissaoTabela.getDate() + parseInt(intervaloEmissao));
              dtEmissao = novaEmissaoTabela;
            }
          }

          dtVencimento = formataData(dtVencimento);
          dtEmissao = formataData(dtEmissao);
          dtVencimento = formataDataBonita(dtVencimento);
          dtEmissao = formataDataBonita(dtEmissao);

          if (!intervaloEmissao) {
            dtEmissao = formataDataBonita($('#txtDTemissao').val())
          }
          const concatDupli = ((i + 1) >= 10) ? '-' : '-0';
          const objeto = {
            DUPLICATANUMERO: $('#txtNotaFiscal').val() + concatDupli + (i + 1),
            VALOR: valorParcela,
            VENCIMENTO: dtVencimento,
            EMISSAO: dtEmissao,
            ENTRADA: retornaDataEntrada(dtVencimento),
            CLASSE: pegaChave('#txtClasse'),
            DESC_CLASSE: pegaDescricao('#txtClasse'),
            BANCO: pegaChave('#txtBanco'),
            DESC_BANCO: pegaDescricao('#txtBanco'),
            CONTA: pegaChave('#txtConta'),
            DESC_CONTA: pegaDescricao('#txtConta'),
            SITUACAO: pegaChave('#txtSituacao'),
            DESC_SITUACAO: pegaDescricao('#txtSituacao'),
            HISTORICO: pegaChave('#txtHistorico'),
            DESC_HISTORICO: pegaDescricao('#txtHistorico'),
            OBSERVACAO: $('#txtObs').val(),
          }

          $('#tabelaParcelas').DataTable().row.add(objeto).draw(false);

          setTimeout(() => {
            $(`#txtValParc_${i}`).maskMoney({
              decimal: ',',
              thousands: '.',
              precision: 2,
              allowZero: true,
              defaultZero: true,
              min: 0
            });
          }, 50);
        }
      }
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('.collapse').on('shown.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })
    .on('hidden.bs.collapse', function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });

  function retornaDataEntrada(dtVencimento) {
    let dtEntrada;
    if ($('#cbDataEntradaIgualVencto').is(':checked')) {
      dtEntrada = tratarData(dtVencimento)
    } else {
      dtEntrada = formataDataBonita($('#txtDTentrada').val());
    }
    return dtEntrada
  }

  $('#cbDataEntradaIgualVencto').on('change', function () {
    if ($(this).is(':checked')) {
      $('.divDtEntrada').addClass('d-none')
      $('#NotaFiscalInfoTour').removeClass('col-xl-1')
      $('#FornecedorInfoTour').removeClass('col-xl-5')
      $('#NotaFiscalInfoTour').addClass('col-xl-2')
      $('#FornecedorInfoTour').addClass('col-xl-6')
      $('#txtDTentrada').val(new Date().toISOString().slice(0, 10));
    } else {
      $('.divDtEntrada').removeClass('d-none')
      $('#NotaFiscalInfoTour').removeClass('col-xl-2')
      $('#FornecedorInfoTour').removeClass('col-xl-6')
      $('#NotaFiscalInfoTour').addClass('col-xl-1')
      $('#FornecedorInfoTour').addClass('col-xl-5')
      $('#txtDTentrada').val(new Date().toISOString().slice(0, 10));
    }
  })

  function tratarData(dataVencimento) {
    const data = dataVencimento.split('/')
    let mes = data[1]
    let ano = data[2]
    let novaData = '01/' + mes + '/' + ano;
    return novaData;
  }

  function atualizaDataVencimento(intervaloDias) {
    intervaloDias = !intervaloDias ? 0 : intervaloDias
    let novaData = new Date($('#txtDTvencimentoBase').val().replace(/-/g, '/'))
    novaData.setDate(novaData.getDate() + parseInt(intervaloDias))
    $('#txtDTvencimento').val(formataDataComTraco(novaData.toLocaleDateString('pt-BR')))
  }

  function ajustarLayoutEdicao() {
    $('.divParcela').addClass('d-none');
    $('#DupliInfoTour').removeClass('d-none');
    $('#FornecedorInfoTour').removeClass('col-xl-5');
    $('#FornecedorInfoTour').addClass('col-xl-4');
    $('.divBarraBoleto').removeClass('col-xl-4');
    $('.divEmpresa').removeClass('col-xl-3');
    $('#divBarraBoleto').addClass('col-xl-6');
    $('.divEmpresa').addClass('col-xl-6');
  }

});
